const { PrismaClient } = require('@prisma/client');
const { compare } = require('bcrypt');

const prisma = new PrismaClient();

async function testAuth() {
  try {
    const email = 'superadmin@healthguardian.com';
    console.log('Looking up user:', email);
    
    const user = await prisma.user.findUnique({
      where: { email },
      include: { hospital: true },
    });
    
    console.log('User found:', user ? 'Yes' : 'No');
    
    if (user) {
      console.log('Username:', user.username);
      console.log('Role:', user.role);
      console.log('Password (hashed):', user.password);
      
      // Test password
      const validPassword = await compare('admin123', user.password);
      console.log('Password valid:', validPassword);
      
      if (validPassword) {
        console.log('Authentication would succeed!');
      } else {
        console.log('Password invalid');
      }
    } else {
      console.log('User not found');
    }
  } catch (error) {
    console.error('Error:', error);
  } finally {
    await prisma.$disconnect();
  }
}

testAuth(); 