const { compare } = require('bcrypt');
const { PrismaClient } = require('@prisma/client');

// Set database connection parameters
const DB_URL = 'mysql://root:@localhost:3306/health_audit';
process.env.DATABASE_URL = DB_URL;

const prisma = new PrismaClient();

// Simulate the NextAuth authorize function
async function testAuthorize(credentials) {
  console.log(`Testing authorize with credentials: ${credentials.email}`);

  if (!credentials?.email || !credentials?.password) {
    console.log('Missing credentials');
    return null;
  }

  try {
    const user = await prisma.user.findUnique({
      where: {
        email: credentials.email,
      },
      include: {
        hospital: true,
      },
    });

    console.log("User found:", user ? "Yes" : "No");

    if (!user) {
      return null;
    }

    const isPasswordValid = await compare(credentials.password, user.password);
    console.log("Password valid:", isPasswordValid);

    if (!isPasswordValid) {
      return null;
    }

    const authUser = {
      id: String(user.id),
      email: user.email,
      name: user.username,
      role: user.role,
      hospitalId: user.hospital_id ? String(user.hospital_id) : null,
      hospitalName: user.hospital?.name,
    };

    console.log("Authentication successful for user:", authUser.email);
    return authUser;
  } catch (error) {
    console.error("Auth error:", error);
    return null;
  }
}

async function main() {
  try {
    console.log('Testing NextAuth login process...');

    const testCredentials = [
      {
        email: 'superadmin@healthguardian.com',
        password: 'admin123'
      },
      {
        email: 'hospital@healthguardian.com',
        password: 'hospital123'
      },
      {
        email: 'superadmin@healthguardian.com',
        password: 'wrongpassword'
      },
      {
        email: 'nonexistent@example.com',
        password: 'password123'
      }
    ];

    for (const cred of testCredentials) {
      console.log('\n---------------------------------------');
      console.log(`Testing login for: ${cred.email}`);
      console.log('---------------------------------------');
      
      const result = await testAuthorize(cred);
      
      if (result) {
        console.log('✅ Login successful!');
        console.log('User details:');
        console.log(JSON.stringify(result, null, 2));
      } else {
        console.log('❌ Login failed!');
      }
    }

  } catch (error) {
    console.error('Error during test:', error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 