// Script to print out environment variables
console.log('Environment variables:');
console.log('NODE_ENV:', process.env.NODE_ENV);
console.log('DATABASE_URL:', process.env.DATABASE_URL || 'Not set');
console.log('NEXTAUTH_URL:', process.env.NEXTAUTH_URL || 'Not set');
console.log('NEXTAUTH_SECRET:', process.env.NEXTAUTH_SECRET ? '[Set]' : 'Not set');

// Check if .env or .env.local files exist
const fs = require('fs');
const path = require('path');

const rootDir = path.resolve(__dirname, '..');
console.log('\nChecking for env files in:', rootDir);

const envFiles = ['.env', '.env.local', '.env.development', '.env.production'];
envFiles.forEach(file => {
  const filePath = path.join(rootDir, file);
  if (fs.existsSync(filePath)) {
    console.log(`${file}: EXISTS`);
    // Print first line to verify it's a valid file (without exposing secrets)
    const content = fs.readFileSync(filePath, 'utf8');
    const firstLine = content.split('\n')[0].trim();
    console.log(`  First line: ${firstLine.substring(0, 30)}${firstLine.length > 30 ? '...' : ''}`);
  } else {
    console.log(`${file}: NOT FOUND`);
  }
}); 