const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

async function testDepartments() {
  try {
    console.log('Testing Departments API...\n');
    
    // Test 1: Count existing departments
    const count = await prisma.department.count();
    console.log(`Found ${count} departments in the database`);
    
    // Test 2: List all departments
    const departments = await prisma.department.findMany({
      orderBy: { name: 'asc' }
    });
    
    console.log('\nExisting departments:');
    departments.forEach(dept => {
      console.log(`- ${dept.name} (ID: ${dept.id}, Hospital: ${dept.hospital_id})`);
    });
    
    // Test 3: Create a test department
    console.log('\nCreating test department...');
    const testDept = await prisma.department.create({
      data: {
        name: 'Test Department ' + Date.now(),
        description: 'Test department created by script',
        hospital_id: 1 // Using hospital ID 1 for testing
      }
    });
    console.log('Created:', testDept);
    
    // Test 4: Update the test department
    console.log('\nUpdating test department...');
    const updated = await prisma.department.update({
      where: { id: testDept.id },
      data: { description: 'Updated description' }
    });
    console.log('Updated:', updated);
    
    // Test 5: Delete the test department
    console.log('\nDeleting test department...');
    await prisma.department.delete({
      where: { id: testDept.id }
    });
    console.log('Deleted successfully');
    
    console.log('\n✅ All tests passed!');
  } catch (error) {
    console.error('❌ Test failed:', error.message);
  } finally {
    await prisma.$disconnect();
  }
}

testDepartments(); 