const { PrismaClient } = require('@prisma/client');
const { compare } = require('bcrypt');

// Set database connection parameters
const DB_URL = 'mysql://root:@localhost:3306/health_audit';
process.env.DATABASE_URL = DB_URL;

const prisma = new PrismaClient();

async function main() {
  try {
    console.log('Testing database connection and authentication...');
    console.log(`Using DATABASE_URL: ${process.env.DATABASE_URL}`);
    
    // Test superadmin
    const superadmin = await prisma.user.findUnique({
      where: { email: 'superadmin@healthguardian.com' },
      include: { hospital: true },
    });

    console.log('\n=== Super Admin ===');
    if (superadmin) {
      console.log('Super admin user found:');
      console.log(`- ID: ${superadmin.id}`);
      console.log(`- Username: ${superadmin.username}`);
      console.log(`- Email: ${superadmin.email}`);
      console.log(`- Role: ${superadmin.role}`);
      console.log(`- Hospital ID: ${superadmin.hospital_id || 'None'}`);

      // Test password
      const superadminPassword = 'admin123';
      const superadminPasswordMatch = await compare(superadminPassword, superadmin.password);
      console.log(`- Password 'admin123' valid: ${superadminPasswordMatch ? 'Yes ✅' : 'No ❌'}`);
    } else {
      console.log('Super admin user not found! ❌');
    }

    // Test hospital user
    const hospitalUser = await prisma.user.findUnique({
      where: { email: 'hospital@healthguardian.com' },
      include: { hospital: true },
    });

    console.log('\n=== Hospital User ===');
    if (hospitalUser) {
      console.log('Hospital user found:');
      console.log(`- ID: ${hospitalUser.id}`);
      console.log(`- Username: ${hospitalUser.username}`);
      console.log(`- Email: ${hospitalUser.email}`);
      console.log(`- Role: ${hospitalUser.role}`);
      console.log(`- Hospital ID: ${hospitalUser.hospital_id || 'None'}`);
      
      if (hospitalUser.hospital) {
        console.log(`- Hospital Name: ${hospitalUser.hospital.name}`);
      } else {
        console.log('- Hospital: Not associated with any hospital ❌');
      }

      // Test password
      const hospitalPassword = 'hospital123';
      const hospitalPasswordMatch = await compare(hospitalPassword, hospitalUser.password);
      console.log(`- Password 'hospital123' valid: ${hospitalPasswordMatch ? 'Yes ✅' : 'No ❌'}`);
    } else {
      console.log('Hospital user not found! ❌');
    }

    // List all users for debugging
    console.log('\n=== All Users ===');
    const allUsers = await prisma.user.findMany({
      select: {
        id: true,
        username: true,
        email: true,
        role: true,
        hospital_id: true
      }
    });
    
    console.log(`Found ${allUsers.length} users in the database:`);
    allUsers.forEach(user => {
      console.log(`- ${user.username} (${user.email}): role=${user.role}, hospital_id=${user.hospital_id || 'None'}`);
    });

    // List all hospitals
    console.log('\n=== All Hospitals ===');
    const allHospitals = await prisma.hospital.findMany();
    
    console.log(`Found ${allHospitals.length} hospitals in the database:`);
    allHospitals.forEach(hospital => {
      console.log(`- ${hospital.name} (ID: ${hospital.id}): ${hospital.location}`);
    });

  } catch (error) {
    console.error('Error testing authentication:', error);
  } finally {
    await prisma.$disconnect();
  }
}

main(); 