const { spawn } = require('child_process');
const path = require('path');
const fs = require('fs');

// Create a temporary .env file with the connection string
const createEnvFile = () => {
  const envPath = path.join(__dirname, '..', '.env.debug');
  const envContent = `
DATABASE_URL="mysql://root:@localhost:3306/health_audit"
NEXTAUTH_SECRET="debug-secret-key-for-testing"
NEXTAUTH_URL="http://localhost:3000"
  `.trim();
  
  fs.writeFileSync(envPath, envContent);
  console.log(`Created temporary .env file at ${envPath}`);
  return envPath;
};

// Run the debug script with the environment variables
const runDebugScript = (envPath) => {
  console.log('Running debug script with environment variables...');
  
  const env = { ...process.env };
  const envContent = fs.readFileSync(envPath, 'utf-8');
  
  // Parse the .env file
  envContent.split('\n').forEach(line => {
    const match = line.match(/^([^=]+)=(.*)$/);
    if (match) {
      const key = match[1].trim();
      // Remove quotes if present
      let value = match[2].trim();
      if (value.startsWith('"') && value.endsWith('"')) {
        value = value.slice(1, -1);
      }
      env[key] = value;
    }
  });
  
  // Run the debug script with the environment variables
  const debugScript = path.join(__dirname, 'debug-login.js');
  
  console.log(`Running: node ${debugScript}`);
  console.log('With environment:');
  console.log(`DATABASE_URL: ${env.DATABASE_URL}`);
  
  const child = spawn('node', [debugScript], { 
    env,
    stdio: 'inherit'
  });
  
  child.on('close', (code) => {
    console.log(`Debug script exited with code ${code}`);
    
    // Clean up
    try {
      fs.unlinkSync(envPath);
      console.log(`Removed temporary .env file`);
    } catch (err) {
      console.error(`Failed to remove temporary .env file: ${err.message}`);
    }
  });
};

// Main function
const main = () => {
  try {
    const envPath = createEnvFile();
    runDebugScript(envPath);
  } catch (error) {
    console.error('Error running debug script:', error);
  }
};

main(); 