const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

async function checkHospitals() {
  try {
    console.log('--- Current Hospitals in Database ---');
    
    const hospitals = await prisma.hospital.findMany({
      include: {
        users: {
          select: {
            id: true,
            username: true,
            email: true,
            role: true
          }
        }
      },
      orderBy: {
        id: 'asc'
      }
    });
    
    if (hospitals.length === 0) {
      console.log('No hospitals found in database.');
    } else {
      hospitals.forEach(hospital => {
        console.log(`\nHospital ID ${hospital.id}: ${hospital.name}`);
        console.log(`  Location: ${hospital.location}`);
        console.log(`  Created: ${hospital.created_at}`);
        console.log(`  Users (${hospital.users.length}):`);
        
        if (hospital.users.length === 0) {
          console.log('    - No users associated');
        } else {
          hospital.users.forEach(user => {
            console.log(`    - ${user.email} (${user.username}) - Role: ${user.role}`);
          });
        }
      });
    }
    
  } catch (error) {
    console.error('Error checking hospitals:', error);
  } finally {
    await prisma.$disconnect();
  }
}

checkHospitals(); 