const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

async function addStaffCompliance() {
  try {
    // Get all hospitals
    const hospitals = await prisma.hospital.findMany();
    
    if (hospitals.length === 0) {
      console.log('No hospitals found. Please run the seed script first.');
      return;
    }

    // Sample staff compliance data
    const staffComplianceData = [
      { department: 'Nursing', staff_count: 45, compliance_rate: 88 },
      { department: 'Emergency', staff_count: 32, compliance_rate: 92 },
      { department: 'Surgery', staff_count: 28, compliance_rate: 85 },
      { department: 'Radiology', staff_count: 15, compliance_rate: 95 },
      { department: 'Laboratory', staff_count: 20, compliance_rate: 90 }
    ];

    // Add staff compliance data for each hospital
    for (const hospital of hospitals) {
      console.log(`Adding staff compliance data for ${hospital.name}...`);
      
      for (const data of staffComplianceData) {
        await prisma.staffCompliance.create({
          data: {
            hospital_id: hospital.id,
            department: data.department,
            staff_count: data.staff_count,
            compliance_rate: data.compliance_rate,
            notes: `Sample compliance data for ${data.department} department`
          }
        });
      }
    }

    console.log('Staff compliance data added successfully!');
  } catch (error) {
    console.error('Error adding staff compliance data:', error);
  } finally {
    await prisma.$disconnect();
  }
}

addStaffCompliance(); 