import prisma from '../lib/prisma';

async function seedPolicyData() {
  console.log('🌱 Seeding policy statuses...');
  
  // Seed Policy Statuses
  const policyStatuses = [
    { value: "Active", label: "Active", description: "Policy is currently active and in effect" },
    { value: "Review Due", label: "Review Due", description: "Policy requires review and potential updates" },
    { value: "Update Required", label: "Update Required", description: "Policy needs to be updated before it can be active" },
    { value: "Inactive", label: "Inactive", description: "Policy is no longer in effect" }
  ];

  for (const status of policyStatuses) {
    await prisma.policyStatus.upsert({
      where: { value: status.value },
      update: {},
      create: status,
    });
  }

  console.log('✅ Policy statuses seeded successfully');

  console.log('🌱 Seeding policy categories...');
  
  // Seed Policy Categories
  const policyCategories = [
    { value: "Data Privacy Policies", label: "Data Privacy Policies", description: "Policies related to data protection and privacy" },
    { value: "Quality Management Policies", label: "Quality Management Policies", description: "Policies for maintaining quality standards" },
    { value: "Facility Safety Policies", label: "Facility Safety Policies", description: "Policies ensuring facility safety and security" },
    { value: "HR Policies", label: "HR Policies", description: "Human resources and personnel policies" },
    { value: "Information Security Policies", label: "Information Security Policies", description: "Policies for protecting information systems and data" }
  ];

  for (const category of policyCategories) {
    await prisma.policyCategory.upsert({
      where: { value: category.value },
      update: {},
      create: category,
    });
  }

  console.log('✅ Policy categories seeded successfully');

  console.log('🌱 Seeding report types...');
  
  // Seed Report Types
  const reportTypes = [
    { value: "compliance_summary", label: "Compliance Summary", description: "Summary of overall compliance status" },
    { value: "training_status", label: "Training Status", description: "Status of staff training and certifications" },
    { value: "audit_findings", label: "Audit Findings", description: "Results and findings from audits" },
    { value: "risk_assessment", label: "Risk Assessment", description: "Analysis of potential risks and mitigation strategies" }
  ];

  for (const reportType of reportTypes) {
    await prisma.reportType.upsert({
      where: { value: reportType.value },
      update: {},
      create: reportType,
    });
  }

  console.log('✅ Report types seeded successfully');
}

export default seedPolicyData;

// Allow running this script directly
if (require.main === module) {
  seedPolicyData()
    .catch((e) => {
      console.error('❌ Error seeding policy data:', e);
      process.exit(1);
    })
    .finally(async () => {
      await prisma.$disconnect();
    });
} 