-- AlterTable
ALTER TABLE `standard_compliance` MODIFY `required_threshold` DOUBLE NOT NULL DEFAULT 90;

-- CreateTable
CREATE TABLE `staff_compliance` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `department` VARCHAR(100) NOT NULL,
    `staff_count` INTEGER NOT NULL,
    `compliance_rate` DOUBLE NOT NULL,
    `notes` TEXT NULL,
    `hospital_id` INTEGER NOT NULL,
    `created_at` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updated_at` DATETIME(3) NOT NULL,

    INDEX `staff_compliance_hospital_id_fkey`(`hospital_id`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `staff_compliance` ADD CONSTRAINT `staff_compliance_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;
