/*
  Warnings:

  - You are about to drop the `AuditSchedule` table. If the table is not empty, all the data it contains will be lost.
  - You are about to drop the `RegulatoryDeadline` table. If the table is not empty, all the data it contains will be lost.
  - You are about to drop the `ResourceAllocation` table. If the table is not empty, all the data it contains will be lost.
  - You are about to drop the `TrainingEvent` table. If the table is not empty, all the data it contains will be lost.

*/
-- DropTable
DROP TABLE `AuditSchedule`;

-- DropTable
DROP TABLE `RegulatoryDeadline`;

-- DropTable
DROP TABLE `ResourceAllocation`;

-- DropTable
DROP TABLE `TrainingEvent`;

-- CreateTable
CREATE TABLE `audit_schedules` (
    `id` VARCHAR(191) NOT NULL,
    `title` VARCHAR(200) NOT NULL,
    `date` DATETIME(3) NOT NULL,
    `department` VARCHAR(100) NOT NULL,
    `auditor` VARCHAR(100) NOT NULL,
    `status` VARCHAR(50) NOT NULL,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    INDEX `audit_schedules_hospital_id_fkey`(`hospital_id`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `training_events` (
    `id` VARCHAR(191) NOT NULL,
    `title` VARCHAR(200) NOT NULL,
    `date` DATETIME(3) NOT NULL,
    `instructor` VARCHAR(100) NOT NULL,
    `location` VARCHAR(100) NOT NULL,
    `department` VARCHAR(100) NOT NULL,
    `duration` VARCHAR(50) NOT NULL,
    `capacity` INTEGER NOT NULL,
    `enrolled` INTEGER NOT NULL,
    `required` BOOLEAN NOT NULL DEFAULT false,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    INDEX `training_events_hospital_id_fkey`(`hospital_id`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `regulatory_deadlines` (
    `id` VARCHAR(191) NOT NULL,
    `title` VARCHAR(200) NOT NULL,
    `dueDate` DATETIME(3) NOT NULL,
    `authority` VARCHAR(100) NOT NULL,
    `criticalLevel` VARCHAR(20) NOT NULL,
    `status` VARCHAR(50) NOT NULL,
    `assignedTo` VARCHAR(100) NOT NULL,
    `description` TEXT NOT NULL,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    INDEX `regulatory_deadlines_hospital_id_fkey`(`hospital_id`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `resource_allocations` (
    `id` VARCHAR(191) NOT NULL,
    `resourceName` VARCHAR(100) NOT NULL,
    `role` VARCHAR(100) NOT NULL,
    `allocatedTo` VARCHAR(200) NOT NULL,
    `startDate` DATETIME(3) NOT NULL,
    `endDate` DATETIME(3) NOT NULL,
    `utilizationPercentage` INTEGER NOT NULL,
    `department` VARCHAR(100) NOT NULL,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    INDEX `resource_allocations_hospital_id_fkey`(`hospital_id`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `audit_schedules` ADD CONSTRAINT `audit_schedules_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `training_events` ADD CONSTRAINT `training_events_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `regulatory_deadlines` ADD CONSTRAINT `regulatory_deadlines_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `resource_allocations` ADD CONSTRAINT `resource_allocations_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;
