-- CreateTable
CREATE TABLE `regulatory_standards` (
    `id` VARCHAR(191) NOT NULL,
    `name` VARCHAR(100) NOT NULL,
    `category` VARCHAR(100) NOT NULL,
    `relevance` VARCHAR(50) NOT NULL,
    `lastUpdated` DATETIME(3) NOT NULL,
    `description` TEXT NULL,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- CreateTable
CREATE TABLE `regulatory_news` (
    `id` VARCHAR(191) NOT NULL,
    `title` VARCHAR(255) NOT NULL,
    `source` VARCHAR(100) NOT NULL,
    `date` DATETIME(3) NOT NULL,
    `category` VARCHAR(100) NOT NULL,
    `content` TEXT NULL,
    `url` VARCHAR(255) NULL,
    `isNew` BOOLEAN NOT NULL DEFAULT true,
    `hospital_id` INTEGER NULL,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `regulatory_standards` ADD CONSTRAINT `regulatory_standards_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `regulatory_news` ADD CONSTRAINT `regulatory_news_hospital_id_fkey` FOREIGN KEY (`hospital_id`) REFERENCES `hospitals`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;
