import { PrismaClient } from '@prisma/client';
import { hash } from 'bcryptjs';

const prisma = new PrismaClient();

async function createSuperAdmin() {
  try {
    const email = 'superadmin@healthguardian.com';
    const password = 'admin123';
    
    // Check if user already exists
    const existingUser = await prisma.user.findUnique({
      where: { email },
    });
    
    if (existingUser) {
      console.log(`User with email ${email} already exists`);
      return;
    }
    
    // Hash the password
    const hashedPassword = await hash(password, 10);
    
    // Create the super admin user
    const superAdmin = await prisma.user.create({
      data: {
        username: 'superadmin',
        password: hashedPassword,
        email: email,
        role: 'super_admin',
      },
    });
    
    console.log(`Created super_admin user: ${superAdmin.email}`);
  } catch (error) {
    console.error('Error creating super admin:', error);
  } finally {
    await prisma.$disconnect();
  }
}

createSuperAdmin(); 