
/**
 * Client
**/

import * as runtime from '@prisma/client/runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model Hospital
 * 
 */
export type Hospital = $Result.DefaultSelection<Prisma.$HospitalPayload>
/**
 * Model Account
 * 
 */
export type Account = $Result.DefaultSelection<Prisma.$AccountPayload>
/**
 * Model Session
 * 
 */
export type Session = $Result.DefaultSelection<Prisma.$SessionPayload>
/**
 * Model VerificationToken
 * 
 */
export type VerificationToken = $Result.DefaultSelection<Prisma.$VerificationTokenPayload>
/**
 * Model ComplianceData
 * 
 */
export type ComplianceData = $Result.DefaultSelection<Prisma.$ComplianceDataPayload>
/**
 * Model StandardCompliance
 * 
 */
export type StandardCompliance = $Result.DefaultSelection<Prisma.$StandardCompliancePayload>
/**
 * Model ComplianceReport
 * 
 */
export type ComplianceReport = $Result.DefaultSelection<Prisma.$ComplianceReportPayload>
/**
 * Model CompliancePolicy
 * 
 */
export type CompliancePolicy = $Result.DefaultSelection<Prisma.$CompliancePolicyPayload>
/**
 * Model AuditFinding
 * 
 */
export type AuditFinding = $Result.DefaultSelection<Prisma.$AuditFindingPayload>
/**
 * Model AuditSchedule
 * 
 */
export type AuditSchedule = $Result.DefaultSelection<Prisma.$AuditSchedulePayload>
/**
 * Model TrainingEvent
 * 
 */
export type TrainingEvent = $Result.DefaultSelection<Prisma.$TrainingEventPayload>
/**
 * Model RegulatoryDeadline
 * 
 */
export type RegulatoryDeadline = $Result.DefaultSelection<Prisma.$RegulatoryDeadlinePayload>
/**
 * Model ResourceAllocation
 * 
 */
export type ResourceAllocation = $Result.DefaultSelection<Prisma.$ResourceAllocationPayload>
/**
 * Model DocumentCategory
 * 
 */
export type DocumentCategory = $Result.DefaultSelection<Prisma.$DocumentCategoryPayload>
/**
 * Model Document
 * 
 */
export type Document = $Result.DefaultSelection<Prisma.$DocumentPayload>
/**
 * Model RegulatoryStandard
 * 
 */
export type RegulatoryStandard = $Result.DefaultSelection<Prisma.$RegulatoryStandardPayload>
/**
 * Model RegulatoryNews
 * 
 */
export type RegulatoryNews = $Result.DefaultSelection<Prisma.$RegulatoryNewsPayload>
/**
 * Model StaffCompliance
 * 
 */
export type StaffCompliance = $Result.DefaultSelection<Prisma.$StaffCompliancePayload>
/**
 * Model Department
 * 
 */
export type Department = $Result.DefaultSelection<Prisma.$DepartmentPayload>
/**
 * Model PolicyStatus
 * 
 */
export type PolicyStatus = $Result.DefaultSelection<Prisma.$PolicyStatusPayload>
/**
 * Model PolicyCategory
 * 
 */
export type PolicyCategory = $Result.DefaultSelection<Prisma.$PolicyCategoryPayload>
/**
 * Model ReportType
 * 
 */
export type ReportType = $Result.DefaultSelection<Prisma.$ReportTypePayload>
/**
 * Model FindingSeverity
 * 
 */
export type FindingSeverity = $Result.DefaultSelection<Prisma.$FindingSeverityPayload>
/**
 * Model FindingStatus
 * 
 */
export type FindingStatus = $Result.DefaultSelection<Prisma.$FindingStatusPayload>
/**
 * Model DocumentStatus
 * 
 */
export type DocumentStatus = $Result.DefaultSelection<Prisma.$DocumentStatusPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const Role: {
  hospital: 'hospital',
  super_admin: 'super_admin'
};

export type Role = (typeof Role)[keyof typeof Role]


export const Severity: {
  critical: 'critical',
  high: 'high',
  medium: 'medium',
  low: 'low'
};

export type Severity = (typeof Severity)[keyof typeof Severity]


export const Status: {
  open: 'open',
  in_progress: 'in_progress',
  resolved: 'resolved'
};

export type Status = (typeof Status)[keyof typeof Status]

}

export type Role = $Enums.Role

export const Role: typeof $Enums.Role

export type Severity = $Enums.Severity

export const Severity: typeof $Enums.Severity

export type Status = $Enums.Status

export const Status: typeof $Enums.Status

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): PrismaClient;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb<ClientOptions>, ExtArgs, $Utils.Call<Prisma.TypeMapCb<ClientOptions>, {
    extArgs: ExtArgs
  }>>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.hospital`: Exposes CRUD operations for the **Hospital** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Hospitals
    * const hospitals = await prisma.hospital.findMany()
    * ```
    */
  get hospital(): Prisma.HospitalDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.account`: Exposes CRUD operations for the **Account** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Accounts
    * const accounts = await prisma.account.findMany()
    * ```
    */
  get account(): Prisma.AccountDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.session`: Exposes CRUD operations for the **Session** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Sessions
    * const sessions = await prisma.session.findMany()
    * ```
    */
  get session(): Prisma.SessionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.verificationToken`: Exposes CRUD operations for the **VerificationToken** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more VerificationTokens
    * const verificationTokens = await prisma.verificationToken.findMany()
    * ```
    */
  get verificationToken(): Prisma.VerificationTokenDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.complianceData`: Exposes CRUD operations for the **ComplianceData** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ComplianceData
    * const complianceData = await prisma.complianceData.findMany()
    * ```
    */
  get complianceData(): Prisma.ComplianceDataDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.standardCompliance`: Exposes CRUD operations for the **StandardCompliance** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more StandardCompliances
    * const standardCompliances = await prisma.standardCompliance.findMany()
    * ```
    */
  get standardCompliance(): Prisma.StandardComplianceDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.complianceReport`: Exposes CRUD operations for the **ComplianceReport** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ComplianceReports
    * const complianceReports = await prisma.complianceReport.findMany()
    * ```
    */
  get complianceReport(): Prisma.ComplianceReportDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.compliancePolicy`: Exposes CRUD operations for the **CompliancePolicy** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CompliancePolicies
    * const compliancePolicies = await prisma.compliancePolicy.findMany()
    * ```
    */
  get compliancePolicy(): Prisma.CompliancePolicyDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.auditFinding`: Exposes CRUD operations for the **AuditFinding** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AuditFindings
    * const auditFindings = await prisma.auditFinding.findMany()
    * ```
    */
  get auditFinding(): Prisma.AuditFindingDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.auditSchedule`: Exposes CRUD operations for the **AuditSchedule** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AuditSchedules
    * const auditSchedules = await prisma.auditSchedule.findMany()
    * ```
    */
  get auditSchedule(): Prisma.AuditScheduleDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.trainingEvent`: Exposes CRUD operations for the **TrainingEvent** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more TrainingEvents
    * const trainingEvents = await prisma.trainingEvent.findMany()
    * ```
    */
  get trainingEvent(): Prisma.TrainingEventDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.regulatoryDeadline`: Exposes CRUD operations for the **RegulatoryDeadline** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RegulatoryDeadlines
    * const regulatoryDeadlines = await prisma.regulatoryDeadline.findMany()
    * ```
    */
  get regulatoryDeadline(): Prisma.RegulatoryDeadlineDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.resourceAllocation`: Exposes CRUD operations for the **ResourceAllocation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ResourceAllocations
    * const resourceAllocations = await prisma.resourceAllocation.findMany()
    * ```
    */
  get resourceAllocation(): Prisma.ResourceAllocationDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.documentCategory`: Exposes CRUD operations for the **DocumentCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more DocumentCategories
    * const documentCategories = await prisma.documentCategory.findMany()
    * ```
    */
  get documentCategory(): Prisma.DocumentCategoryDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.document`: Exposes CRUD operations for the **Document** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Documents
    * const documents = await prisma.document.findMany()
    * ```
    */
  get document(): Prisma.DocumentDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.regulatoryStandard`: Exposes CRUD operations for the **RegulatoryStandard** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RegulatoryStandards
    * const regulatoryStandards = await prisma.regulatoryStandard.findMany()
    * ```
    */
  get regulatoryStandard(): Prisma.RegulatoryStandardDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.regulatoryNews`: Exposes CRUD operations for the **RegulatoryNews** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RegulatoryNews
    * const regulatoryNews = await prisma.regulatoryNews.findMany()
    * ```
    */
  get regulatoryNews(): Prisma.RegulatoryNewsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.staffCompliance`: Exposes CRUD operations for the **StaffCompliance** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more StaffCompliances
    * const staffCompliances = await prisma.staffCompliance.findMany()
    * ```
    */
  get staffCompliance(): Prisma.StaffComplianceDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.department`: Exposes CRUD operations for the **Department** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Departments
    * const departments = await prisma.department.findMany()
    * ```
    */
  get department(): Prisma.DepartmentDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.policyStatus`: Exposes CRUD operations for the **PolicyStatus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more PolicyStatuses
    * const policyStatuses = await prisma.policyStatus.findMany()
    * ```
    */
  get policyStatus(): Prisma.PolicyStatusDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.policyCategory`: Exposes CRUD operations for the **PolicyCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more PolicyCategories
    * const policyCategories = await prisma.policyCategory.findMany()
    * ```
    */
  get policyCategory(): Prisma.PolicyCategoryDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.reportType`: Exposes CRUD operations for the **ReportType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ReportTypes
    * const reportTypes = await prisma.reportType.findMany()
    * ```
    */
  get reportType(): Prisma.ReportTypeDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.findingSeverity`: Exposes CRUD operations for the **FindingSeverity** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FindingSeverities
    * const findingSeverities = await prisma.findingSeverity.findMany()
    * ```
    */
  get findingSeverity(): Prisma.FindingSeverityDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.findingStatus`: Exposes CRUD operations for the **FindingStatus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FindingStatuses
    * const findingStatuses = await prisma.findingStatus.findMany()
    * ```
    */
  get findingStatus(): Prisma.FindingStatusDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.documentStatus`: Exposes CRUD operations for the **DocumentStatus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more DocumentStatuses
    * const documentStatuses = await prisma.documentStatus.findMany()
    * ```
    */
  get documentStatus(): Prisma.DocumentStatusDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.8.2
   * Query Engine version: 2060c79ba17c6bb9f5823312b6f6b7f4a845738e
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? P : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    Hospital: 'Hospital',
    Account: 'Account',
    Session: 'Session',
    VerificationToken: 'VerificationToken',
    ComplianceData: 'ComplianceData',
    StandardCompliance: 'StandardCompliance',
    ComplianceReport: 'ComplianceReport',
    CompliancePolicy: 'CompliancePolicy',
    AuditFinding: 'AuditFinding',
    AuditSchedule: 'AuditSchedule',
    TrainingEvent: 'TrainingEvent',
    RegulatoryDeadline: 'RegulatoryDeadline',
    ResourceAllocation: 'ResourceAllocation',
    DocumentCategory: 'DocumentCategory',
    Document: 'Document',
    RegulatoryStandard: 'RegulatoryStandard',
    RegulatoryNews: 'RegulatoryNews',
    StaffCompliance: 'StaffCompliance',
    Department: 'Department',
    PolicyStatus: 'PolicyStatus',
    PolicyCategory: 'PolicyCategory',
    ReportType: 'ReportType',
    FindingSeverity: 'FindingSeverity',
    FindingStatus: 'FindingStatus',
    DocumentStatus: 'DocumentStatus'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb<ClientOptions = {}> extends $Utils.Fn<{extArgs: $Extensions.InternalArgs }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], ClientOptions extends { omit: infer OmitOptions } ? OmitOptions : {}>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> = {
    globalOmitOptions: {
      omit: GlobalOmitOptions
    }
    meta: {
      modelProps: "user" | "hospital" | "account" | "session" | "verificationToken" | "complianceData" | "standardCompliance" | "complianceReport" | "compliancePolicy" | "auditFinding" | "auditSchedule" | "trainingEvent" | "regulatoryDeadline" | "resourceAllocation" | "documentCategory" | "document" | "regulatoryStandard" | "regulatoryNews" | "staffCompliance" | "department" | "policyStatus" | "policyCategory" | "reportType" | "findingSeverity" | "findingStatus" | "documentStatus"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      Hospital: {
        payload: Prisma.$HospitalPayload<ExtArgs>
        fields: Prisma.HospitalFieldRefs
        operations: {
          findUnique: {
            args: Prisma.HospitalFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.HospitalFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          findFirst: {
            args: Prisma.HospitalFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.HospitalFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          findMany: {
            args: Prisma.HospitalFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>[]
          }
          create: {
            args: Prisma.HospitalCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          createMany: {
            args: Prisma.HospitalCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.HospitalDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          update: {
            args: Prisma.HospitalUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          deleteMany: {
            args: Prisma.HospitalDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.HospitalUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.HospitalUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$HospitalPayload>
          }
          aggregate: {
            args: Prisma.HospitalAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateHospital>
          }
          groupBy: {
            args: Prisma.HospitalGroupByArgs<ExtArgs>
            result: $Utils.Optional<HospitalGroupByOutputType>[]
          }
          count: {
            args: Prisma.HospitalCountArgs<ExtArgs>
            result: $Utils.Optional<HospitalCountAggregateOutputType> | number
          }
        }
      }
      Account: {
        payload: Prisma.$AccountPayload<ExtArgs>
        fields: Prisma.AccountFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AccountFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AccountFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          findFirst: {
            args: Prisma.AccountFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AccountFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          findMany: {
            args: Prisma.AccountFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>[]
          }
          create: {
            args: Prisma.AccountCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          createMany: {
            args: Prisma.AccountCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.AccountDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          update: {
            args: Prisma.AccountUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          deleteMany: {
            args: Prisma.AccountDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AccountUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.AccountUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AccountPayload>
          }
          aggregate: {
            args: Prisma.AccountAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAccount>
          }
          groupBy: {
            args: Prisma.AccountGroupByArgs<ExtArgs>
            result: $Utils.Optional<AccountGroupByOutputType>[]
          }
          count: {
            args: Prisma.AccountCountArgs<ExtArgs>
            result: $Utils.Optional<AccountCountAggregateOutputType> | number
          }
        }
      }
      Session: {
        payload: Prisma.$SessionPayload<ExtArgs>
        fields: Prisma.SessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.SessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.SessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findFirst: {
            args: Prisma.SessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.SessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          findMany: {
            args: Prisma.SessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>[]
          }
          create: {
            args: Prisma.SessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          createMany: {
            args: Prisma.SessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.SessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          update: {
            args: Prisma.SessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          deleteMany: {
            args: Prisma.SessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.SessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.SessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$SessionPayload>
          }
          aggregate: {
            args: Prisma.SessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSession>
          }
          groupBy: {
            args: Prisma.SessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<SessionGroupByOutputType>[]
          }
          count: {
            args: Prisma.SessionCountArgs<ExtArgs>
            result: $Utils.Optional<SessionCountAggregateOutputType> | number
          }
        }
      }
      VerificationToken: {
        payload: Prisma.$VerificationTokenPayload<ExtArgs>
        fields: Prisma.VerificationTokenFieldRefs
        operations: {
          findUnique: {
            args: Prisma.VerificationTokenFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.VerificationTokenFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          findFirst: {
            args: Prisma.VerificationTokenFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.VerificationTokenFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          findMany: {
            args: Prisma.VerificationTokenFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>[]
          }
          create: {
            args: Prisma.VerificationTokenCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          createMany: {
            args: Prisma.VerificationTokenCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.VerificationTokenDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          update: {
            args: Prisma.VerificationTokenUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          deleteMany: {
            args: Prisma.VerificationTokenDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.VerificationTokenUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.VerificationTokenUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$VerificationTokenPayload>
          }
          aggregate: {
            args: Prisma.VerificationTokenAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateVerificationToken>
          }
          groupBy: {
            args: Prisma.VerificationTokenGroupByArgs<ExtArgs>
            result: $Utils.Optional<VerificationTokenGroupByOutputType>[]
          }
          count: {
            args: Prisma.VerificationTokenCountArgs<ExtArgs>
            result: $Utils.Optional<VerificationTokenCountAggregateOutputType> | number
          }
        }
      }
      ComplianceData: {
        payload: Prisma.$ComplianceDataPayload<ExtArgs>
        fields: Prisma.ComplianceDataFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ComplianceDataFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ComplianceDataFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          findFirst: {
            args: Prisma.ComplianceDataFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ComplianceDataFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          findMany: {
            args: Prisma.ComplianceDataFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>[]
          }
          create: {
            args: Prisma.ComplianceDataCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          createMany: {
            args: Prisma.ComplianceDataCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ComplianceDataDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          update: {
            args: Prisma.ComplianceDataUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          deleteMany: {
            args: Prisma.ComplianceDataDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ComplianceDataUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ComplianceDataUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceDataPayload>
          }
          aggregate: {
            args: Prisma.ComplianceDataAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateComplianceData>
          }
          groupBy: {
            args: Prisma.ComplianceDataGroupByArgs<ExtArgs>
            result: $Utils.Optional<ComplianceDataGroupByOutputType>[]
          }
          count: {
            args: Prisma.ComplianceDataCountArgs<ExtArgs>
            result: $Utils.Optional<ComplianceDataCountAggregateOutputType> | number
          }
        }
      }
      StandardCompliance: {
        payload: Prisma.$StandardCompliancePayload<ExtArgs>
        fields: Prisma.StandardComplianceFieldRefs
        operations: {
          findUnique: {
            args: Prisma.StandardComplianceFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.StandardComplianceFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          findFirst: {
            args: Prisma.StandardComplianceFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.StandardComplianceFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          findMany: {
            args: Prisma.StandardComplianceFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>[]
          }
          create: {
            args: Prisma.StandardComplianceCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          createMany: {
            args: Prisma.StandardComplianceCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.StandardComplianceDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          update: {
            args: Prisma.StandardComplianceUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          deleteMany: {
            args: Prisma.StandardComplianceDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.StandardComplianceUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.StandardComplianceUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StandardCompliancePayload>
          }
          aggregate: {
            args: Prisma.StandardComplianceAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateStandardCompliance>
          }
          groupBy: {
            args: Prisma.StandardComplianceGroupByArgs<ExtArgs>
            result: $Utils.Optional<StandardComplianceGroupByOutputType>[]
          }
          count: {
            args: Prisma.StandardComplianceCountArgs<ExtArgs>
            result: $Utils.Optional<StandardComplianceCountAggregateOutputType> | number
          }
        }
      }
      ComplianceReport: {
        payload: Prisma.$ComplianceReportPayload<ExtArgs>
        fields: Prisma.ComplianceReportFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ComplianceReportFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ComplianceReportFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          findFirst: {
            args: Prisma.ComplianceReportFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ComplianceReportFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          findMany: {
            args: Prisma.ComplianceReportFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>[]
          }
          create: {
            args: Prisma.ComplianceReportCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          createMany: {
            args: Prisma.ComplianceReportCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ComplianceReportDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          update: {
            args: Prisma.ComplianceReportUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          deleteMany: {
            args: Prisma.ComplianceReportDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ComplianceReportUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ComplianceReportUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ComplianceReportPayload>
          }
          aggregate: {
            args: Prisma.ComplianceReportAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateComplianceReport>
          }
          groupBy: {
            args: Prisma.ComplianceReportGroupByArgs<ExtArgs>
            result: $Utils.Optional<ComplianceReportGroupByOutputType>[]
          }
          count: {
            args: Prisma.ComplianceReportCountArgs<ExtArgs>
            result: $Utils.Optional<ComplianceReportCountAggregateOutputType> | number
          }
        }
      }
      CompliancePolicy: {
        payload: Prisma.$CompliancePolicyPayload<ExtArgs>
        fields: Prisma.CompliancePolicyFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CompliancePolicyFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CompliancePolicyFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          findFirst: {
            args: Prisma.CompliancePolicyFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CompliancePolicyFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          findMany: {
            args: Prisma.CompliancePolicyFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>[]
          }
          create: {
            args: Prisma.CompliancePolicyCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          createMany: {
            args: Prisma.CompliancePolicyCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.CompliancePolicyDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          update: {
            args: Prisma.CompliancePolicyUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          deleteMany: {
            args: Prisma.CompliancePolicyDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CompliancePolicyUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.CompliancePolicyUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CompliancePolicyPayload>
          }
          aggregate: {
            args: Prisma.CompliancePolicyAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCompliancePolicy>
          }
          groupBy: {
            args: Prisma.CompliancePolicyGroupByArgs<ExtArgs>
            result: $Utils.Optional<CompliancePolicyGroupByOutputType>[]
          }
          count: {
            args: Prisma.CompliancePolicyCountArgs<ExtArgs>
            result: $Utils.Optional<CompliancePolicyCountAggregateOutputType> | number
          }
        }
      }
      AuditFinding: {
        payload: Prisma.$AuditFindingPayload<ExtArgs>
        fields: Prisma.AuditFindingFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AuditFindingFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AuditFindingFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          findFirst: {
            args: Prisma.AuditFindingFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AuditFindingFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          findMany: {
            args: Prisma.AuditFindingFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>[]
          }
          create: {
            args: Prisma.AuditFindingCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          createMany: {
            args: Prisma.AuditFindingCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.AuditFindingDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          update: {
            args: Prisma.AuditFindingUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          deleteMany: {
            args: Prisma.AuditFindingDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AuditFindingUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.AuditFindingUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditFindingPayload>
          }
          aggregate: {
            args: Prisma.AuditFindingAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuditFinding>
          }
          groupBy: {
            args: Prisma.AuditFindingGroupByArgs<ExtArgs>
            result: $Utils.Optional<AuditFindingGroupByOutputType>[]
          }
          count: {
            args: Prisma.AuditFindingCountArgs<ExtArgs>
            result: $Utils.Optional<AuditFindingCountAggregateOutputType> | number
          }
        }
      }
      AuditSchedule: {
        payload: Prisma.$AuditSchedulePayload<ExtArgs>
        fields: Prisma.AuditScheduleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AuditScheduleFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AuditScheduleFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          findFirst: {
            args: Prisma.AuditScheduleFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AuditScheduleFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          findMany: {
            args: Prisma.AuditScheduleFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>[]
          }
          create: {
            args: Prisma.AuditScheduleCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          createMany: {
            args: Prisma.AuditScheduleCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.AuditScheduleDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          update: {
            args: Prisma.AuditScheduleUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          deleteMany: {
            args: Prisma.AuditScheduleDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AuditScheduleUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.AuditScheduleUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AuditSchedulePayload>
          }
          aggregate: {
            args: Prisma.AuditScheduleAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuditSchedule>
          }
          groupBy: {
            args: Prisma.AuditScheduleGroupByArgs<ExtArgs>
            result: $Utils.Optional<AuditScheduleGroupByOutputType>[]
          }
          count: {
            args: Prisma.AuditScheduleCountArgs<ExtArgs>
            result: $Utils.Optional<AuditScheduleCountAggregateOutputType> | number
          }
        }
      }
      TrainingEvent: {
        payload: Prisma.$TrainingEventPayload<ExtArgs>
        fields: Prisma.TrainingEventFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TrainingEventFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TrainingEventFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          findFirst: {
            args: Prisma.TrainingEventFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TrainingEventFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          findMany: {
            args: Prisma.TrainingEventFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>[]
          }
          create: {
            args: Prisma.TrainingEventCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          createMany: {
            args: Prisma.TrainingEventCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.TrainingEventDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          update: {
            args: Prisma.TrainingEventUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          deleteMany: {
            args: Prisma.TrainingEventDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TrainingEventUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.TrainingEventUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TrainingEventPayload>
          }
          aggregate: {
            args: Prisma.TrainingEventAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTrainingEvent>
          }
          groupBy: {
            args: Prisma.TrainingEventGroupByArgs<ExtArgs>
            result: $Utils.Optional<TrainingEventGroupByOutputType>[]
          }
          count: {
            args: Prisma.TrainingEventCountArgs<ExtArgs>
            result: $Utils.Optional<TrainingEventCountAggregateOutputType> | number
          }
        }
      }
      RegulatoryDeadline: {
        payload: Prisma.$RegulatoryDeadlinePayload<ExtArgs>
        fields: Prisma.RegulatoryDeadlineFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RegulatoryDeadlineFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RegulatoryDeadlineFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          findFirst: {
            args: Prisma.RegulatoryDeadlineFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RegulatoryDeadlineFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          findMany: {
            args: Prisma.RegulatoryDeadlineFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>[]
          }
          create: {
            args: Prisma.RegulatoryDeadlineCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          createMany: {
            args: Prisma.RegulatoryDeadlineCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.RegulatoryDeadlineDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          update: {
            args: Prisma.RegulatoryDeadlineUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          deleteMany: {
            args: Prisma.RegulatoryDeadlineDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RegulatoryDeadlineUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.RegulatoryDeadlineUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryDeadlinePayload>
          }
          aggregate: {
            args: Prisma.RegulatoryDeadlineAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRegulatoryDeadline>
          }
          groupBy: {
            args: Prisma.RegulatoryDeadlineGroupByArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryDeadlineGroupByOutputType>[]
          }
          count: {
            args: Prisma.RegulatoryDeadlineCountArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryDeadlineCountAggregateOutputType> | number
          }
        }
      }
      ResourceAllocation: {
        payload: Prisma.$ResourceAllocationPayload<ExtArgs>
        fields: Prisma.ResourceAllocationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ResourceAllocationFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ResourceAllocationFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          findFirst: {
            args: Prisma.ResourceAllocationFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ResourceAllocationFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          findMany: {
            args: Prisma.ResourceAllocationFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>[]
          }
          create: {
            args: Prisma.ResourceAllocationCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          createMany: {
            args: Prisma.ResourceAllocationCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ResourceAllocationDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          update: {
            args: Prisma.ResourceAllocationUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          deleteMany: {
            args: Prisma.ResourceAllocationDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ResourceAllocationUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ResourceAllocationUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ResourceAllocationPayload>
          }
          aggregate: {
            args: Prisma.ResourceAllocationAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateResourceAllocation>
          }
          groupBy: {
            args: Prisma.ResourceAllocationGroupByArgs<ExtArgs>
            result: $Utils.Optional<ResourceAllocationGroupByOutputType>[]
          }
          count: {
            args: Prisma.ResourceAllocationCountArgs<ExtArgs>
            result: $Utils.Optional<ResourceAllocationCountAggregateOutputType> | number
          }
        }
      }
      DocumentCategory: {
        payload: Prisma.$DocumentCategoryPayload<ExtArgs>
        fields: Prisma.DocumentCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DocumentCategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DocumentCategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          findFirst: {
            args: Prisma.DocumentCategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DocumentCategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          findMany: {
            args: Prisma.DocumentCategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>[]
          }
          create: {
            args: Prisma.DocumentCategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          createMany: {
            args: Prisma.DocumentCategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.DocumentCategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          update: {
            args: Prisma.DocumentCategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          deleteMany: {
            args: Prisma.DocumentCategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.DocumentCategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.DocumentCategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentCategoryPayload>
          }
          aggregate: {
            args: Prisma.DocumentCategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDocumentCategory>
          }
          groupBy: {
            args: Prisma.DocumentCategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<DocumentCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.DocumentCategoryCountArgs<ExtArgs>
            result: $Utils.Optional<DocumentCategoryCountAggregateOutputType> | number
          }
        }
      }
      Document: {
        payload: Prisma.$DocumentPayload<ExtArgs>
        fields: Prisma.DocumentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DocumentFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DocumentFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          findFirst: {
            args: Prisma.DocumentFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DocumentFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          findMany: {
            args: Prisma.DocumentFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>[]
          }
          create: {
            args: Prisma.DocumentCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          createMany: {
            args: Prisma.DocumentCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.DocumentDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          update: {
            args: Prisma.DocumentUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          deleteMany: {
            args: Prisma.DocumentDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.DocumentUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.DocumentUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentPayload>
          }
          aggregate: {
            args: Prisma.DocumentAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDocument>
          }
          groupBy: {
            args: Prisma.DocumentGroupByArgs<ExtArgs>
            result: $Utils.Optional<DocumentGroupByOutputType>[]
          }
          count: {
            args: Prisma.DocumentCountArgs<ExtArgs>
            result: $Utils.Optional<DocumentCountAggregateOutputType> | number
          }
        }
      }
      RegulatoryStandard: {
        payload: Prisma.$RegulatoryStandardPayload<ExtArgs>
        fields: Prisma.RegulatoryStandardFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RegulatoryStandardFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RegulatoryStandardFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          findFirst: {
            args: Prisma.RegulatoryStandardFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RegulatoryStandardFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          findMany: {
            args: Prisma.RegulatoryStandardFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>[]
          }
          create: {
            args: Prisma.RegulatoryStandardCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          createMany: {
            args: Prisma.RegulatoryStandardCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.RegulatoryStandardDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          update: {
            args: Prisma.RegulatoryStandardUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          deleteMany: {
            args: Prisma.RegulatoryStandardDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RegulatoryStandardUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.RegulatoryStandardUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryStandardPayload>
          }
          aggregate: {
            args: Prisma.RegulatoryStandardAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRegulatoryStandard>
          }
          groupBy: {
            args: Prisma.RegulatoryStandardGroupByArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryStandardGroupByOutputType>[]
          }
          count: {
            args: Prisma.RegulatoryStandardCountArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryStandardCountAggregateOutputType> | number
          }
        }
      }
      RegulatoryNews: {
        payload: Prisma.$RegulatoryNewsPayload<ExtArgs>
        fields: Prisma.RegulatoryNewsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RegulatoryNewsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RegulatoryNewsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          findFirst: {
            args: Prisma.RegulatoryNewsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RegulatoryNewsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          findMany: {
            args: Prisma.RegulatoryNewsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>[]
          }
          create: {
            args: Prisma.RegulatoryNewsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          createMany: {
            args: Prisma.RegulatoryNewsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.RegulatoryNewsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          update: {
            args: Prisma.RegulatoryNewsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          deleteMany: {
            args: Prisma.RegulatoryNewsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.RegulatoryNewsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.RegulatoryNewsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$RegulatoryNewsPayload>
          }
          aggregate: {
            args: Prisma.RegulatoryNewsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRegulatoryNews>
          }
          groupBy: {
            args: Prisma.RegulatoryNewsGroupByArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryNewsGroupByOutputType>[]
          }
          count: {
            args: Prisma.RegulatoryNewsCountArgs<ExtArgs>
            result: $Utils.Optional<RegulatoryNewsCountAggregateOutputType> | number
          }
        }
      }
      StaffCompliance: {
        payload: Prisma.$StaffCompliancePayload<ExtArgs>
        fields: Prisma.StaffComplianceFieldRefs
        operations: {
          findUnique: {
            args: Prisma.StaffComplianceFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.StaffComplianceFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          findFirst: {
            args: Prisma.StaffComplianceFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.StaffComplianceFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          findMany: {
            args: Prisma.StaffComplianceFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>[]
          }
          create: {
            args: Prisma.StaffComplianceCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          createMany: {
            args: Prisma.StaffComplianceCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.StaffComplianceDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          update: {
            args: Prisma.StaffComplianceUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          deleteMany: {
            args: Prisma.StaffComplianceDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.StaffComplianceUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.StaffComplianceUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$StaffCompliancePayload>
          }
          aggregate: {
            args: Prisma.StaffComplianceAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateStaffCompliance>
          }
          groupBy: {
            args: Prisma.StaffComplianceGroupByArgs<ExtArgs>
            result: $Utils.Optional<StaffComplianceGroupByOutputType>[]
          }
          count: {
            args: Prisma.StaffComplianceCountArgs<ExtArgs>
            result: $Utils.Optional<StaffComplianceCountAggregateOutputType> | number
          }
        }
      }
      Department: {
        payload: Prisma.$DepartmentPayload<ExtArgs>
        fields: Prisma.DepartmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DepartmentFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DepartmentFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findFirst: {
            args: Prisma.DepartmentFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DepartmentFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findMany: {
            args: Prisma.DepartmentFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>[]
          }
          create: {
            args: Prisma.DepartmentCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          createMany: {
            args: Prisma.DepartmentCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.DepartmentDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          update: {
            args: Prisma.DepartmentUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          deleteMany: {
            args: Prisma.DepartmentDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.DepartmentUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.DepartmentUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          aggregate: {
            args: Prisma.DepartmentAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDepartment>
          }
          groupBy: {
            args: Prisma.DepartmentGroupByArgs<ExtArgs>
            result: $Utils.Optional<DepartmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.DepartmentCountArgs<ExtArgs>
            result: $Utils.Optional<DepartmentCountAggregateOutputType> | number
          }
        }
      }
      PolicyStatus: {
        payload: Prisma.$PolicyStatusPayload<ExtArgs>
        fields: Prisma.PolicyStatusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PolicyStatusFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PolicyStatusFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          findFirst: {
            args: Prisma.PolicyStatusFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PolicyStatusFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          findMany: {
            args: Prisma.PolicyStatusFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>[]
          }
          create: {
            args: Prisma.PolicyStatusCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          createMany: {
            args: Prisma.PolicyStatusCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.PolicyStatusDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          update: {
            args: Prisma.PolicyStatusUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          deleteMany: {
            args: Prisma.PolicyStatusDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.PolicyStatusUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.PolicyStatusUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyStatusPayload>
          }
          aggregate: {
            args: Prisma.PolicyStatusAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePolicyStatus>
          }
          groupBy: {
            args: Prisma.PolicyStatusGroupByArgs<ExtArgs>
            result: $Utils.Optional<PolicyStatusGroupByOutputType>[]
          }
          count: {
            args: Prisma.PolicyStatusCountArgs<ExtArgs>
            result: $Utils.Optional<PolicyStatusCountAggregateOutputType> | number
          }
        }
      }
      PolicyCategory: {
        payload: Prisma.$PolicyCategoryPayload<ExtArgs>
        fields: Prisma.PolicyCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PolicyCategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PolicyCategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          findFirst: {
            args: Prisma.PolicyCategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PolicyCategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          findMany: {
            args: Prisma.PolicyCategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>[]
          }
          create: {
            args: Prisma.PolicyCategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          createMany: {
            args: Prisma.PolicyCategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.PolicyCategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          update: {
            args: Prisma.PolicyCategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          deleteMany: {
            args: Prisma.PolicyCategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.PolicyCategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.PolicyCategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$PolicyCategoryPayload>
          }
          aggregate: {
            args: Prisma.PolicyCategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePolicyCategory>
          }
          groupBy: {
            args: Prisma.PolicyCategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<PolicyCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.PolicyCategoryCountArgs<ExtArgs>
            result: $Utils.Optional<PolicyCategoryCountAggregateOutputType> | number
          }
        }
      }
      ReportType: {
        payload: Prisma.$ReportTypePayload<ExtArgs>
        fields: Prisma.ReportTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ReportTypeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ReportTypeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          findFirst: {
            args: Prisma.ReportTypeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ReportTypeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          findMany: {
            args: Prisma.ReportTypeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>[]
          }
          create: {
            args: Prisma.ReportTypeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          createMany: {
            args: Prisma.ReportTypeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.ReportTypeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          update: {
            args: Prisma.ReportTypeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          deleteMany: {
            args: Prisma.ReportTypeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ReportTypeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.ReportTypeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReportTypePayload>
          }
          aggregate: {
            args: Prisma.ReportTypeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateReportType>
          }
          groupBy: {
            args: Prisma.ReportTypeGroupByArgs<ExtArgs>
            result: $Utils.Optional<ReportTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.ReportTypeCountArgs<ExtArgs>
            result: $Utils.Optional<ReportTypeCountAggregateOutputType> | number
          }
        }
      }
      FindingSeverity: {
        payload: Prisma.$FindingSeverityPayload<ExtArgs>
        fields: Prisma.FindingSeverityFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FindingSeverityFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FindingSeverityFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          findFirst: {
            args: Prisma.FindingSeverityFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FindingSeverityFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          findMany: {
            args: Prisma.FindingSeverityFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>[]
          }
          create: {
            args: Prisma.FindingSeverityCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          createMany: {
            args: Prisma.FindingSeverityCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.FindingSeverityDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          update: {
            args: Prisma.FindingSeverityUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          deleteMany: {
            args: Prisma.FindingSeverityDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.FindingSeverityUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.FindingSeverityUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingSeverityPayload>
          }
          aggregate: {
            args: Prisma.FindingSeverityAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFindingSeverity>
          }
          groupBy: {
            args: Prisma.FindingSeverityGroupByArgs<ExtArgs>
            result: $Utils.Optional<FindingSeverityGroupByOutputType>[]
          }
          count: {
            args: Prisma.FindingSeverityCountArgs<ExtArgs>
            result: $Utils.Optional<FindingSeverityCountAggregateOutputType> | number
          }
        }
      }
      FindingStatus: {
        payload: Prisma.$FindingStatusPayload<ExtArgs>
        fields: Prisma.FindingStatusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FindingStatusFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FindingStatusFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          findFirst: {
            args: Prisma.FindingStatusFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FindingStatusFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          findMany: {
            args: Prisma.FindingStatusFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>[]
          }
          create: {
            args: Prisma.FindingStatusCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          createMany: {
            args: Prisma.FindingStatusCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.FindingStatusDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          update: {
            args: Prisma.FindingStatusUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          deleteMany: {
            args: Prisma.FindingStatusDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.FindingStatusUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.FindingStatusUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$FindingStatusPayload>
          }
          aggregate: {
            args: Prisma.FindingStatusAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateFindingStatus>
          }
          groupBy: {
            args: Prisma.FindingStatusGroupByArgs<ExtArgs>
            result: $Utils.Optional<FindingStatusGroupByOutputType>[]
          }
          count: {
            args: Prisma.FindingStatusCountArgs<ExtArgs>
            result: $Utils.Optional<FindingStatusCountAggregateOutputType> | number
          }
        }
      }
      DocumentStatus: {
        payload: Prisma.$DocumentStatusPayload<ExtArgs>
        fields: Prisma.DocumentStatusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DocumentStatusFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DocumentStatusFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          findFirst: {
            args: Prisma.DocumentStatusFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DocumentStatusFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          findMany: {
            args: Prisma.DocumentStatusFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>[]
          }
          create: {
            args: Prisma.DocumentStatusCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          createMany: {
            args: Prisma.DocumentStatusCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.DocumentStatusDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          update: {
            args: Prisma.DocumentStatusUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          deleteMany: {
            args: Prisma.DocumentStatusDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.DocumentStatusUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.DocumentStatusUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$DocumentStatusPayload>
          }
          aggregate: {
            args: Prisma.DocumentStatusAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDocumentStatus>
          }
          groupBy: {
            args: Prisma.DocumentStatusGroupByArgs<ExtArgs>
            result: $Utils.Optional<DocumentStatusGroupByOutputType>[]
          }
          count: {
            args: Prisma.DocumentStatusCountArgs<ExtArgs>
            result: $Utils.Optional<DocumentStatusCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    user?: UserOmit
    hospital?: HospitalOmit
    account?: AccountOmit
    session?: SessionOmit
    verificationToken?: VerificationTokenOmit
    complianceData?: ComplianceDataOmit
    standardCompliance?: StandardComplianceOmit
    complianceReport?: ComplianceReportOmit
    compliancePolicy?: CompliancePolicyOmit
    auditFinding?: AuditFindingOmit
    auditSchedule?: AuditScheduleOmit
    trainingEvent?: TrainingEventOmit
    regulatoryDeadline?: RegulatoryDeadlineOmit
    resourceAllocation?: ResourceAllocationOmit
    documentCategory?: DocumentCategoryOmit
    document?: DocumentOmit
    regulatoryStandard?: RegulatoryStandardOmit
    regulatoryNews?: RegulatoryNewsOmit
    staffCompliance?: StaffComplianceOmit
    department?: DepartmentOmit
    policyStatus?: PolicyStatusOmit
    policyCategory?: PolicyCategoryOmit
    reportType?: ReportTypeOmit
    findingSeverity?: FindingSeverityOmit
    findingStatus?: FindingStatusOmit
    documentStatus?: DocumentStatusOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    accounts: number
    sessions: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    accounts?: boolean | UserCountOutputTypeCountAccountsArgs
    sessions?: boolean | UserCountOutputTypeCountSessionsArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAccountsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AccountWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountSessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SessionWhereInput
  }


  /**
   * Count Type HospitalCountOutputType
   */

  export type HospitalCountOutputType = {
    findings: number
    audit_schedules: number
    compliance: number
    policies: number
    reports: number
    departments: number
    document_categories: number
    documents: number
    regulatory_deadlines: number
    regulatory_news: number
    regulatory_standards: number
    resource_allocations: number
    staff_compliance: number
    standards: number
    training_events: number
    users: number
  }

  export type HospitalCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    findings?: boolean | HospitalCountOutputTypeCountFindingsArgs
    audit_schedules?: boolean | HospitalCountOutputTypeCountAudit_schedulesArgs
    compliance?: boolean | HospitalCountOutputTypeCountComplianceArgs
    policies?: boolean | HospitalCountOutputTypeCountPoliciesArgs
    reports?: boolean | HospitalCountOutputTypeCountReportsArgs
    departments?: boolean | HospitalCountOutputTypeCountDepartmentsArgs
    document_categories?: boolean | HospitalCountOutputTypeCountDocument_categoriesArgs
    documents?: boolean | HospitalCountOutputTypeCountDocumentsArgs
    regulatory_deadlines?: boolean | HospitalCountOutputTypeCountRegulatory_deadlinesArgs
    regulatory_news?: boolean | HospitalCountOutputTypeCountRegulatory_newsArgs
    regulatory_standards?: boolean | HospitalCountOutputTypeCountRegulatory_standardsArgs
    resource_allocations?: boolean | HospitalCountOutputTypeCountResource_allocationsArgs
    staff_compliance?: boolean | HospitalCountOutputTypeCountStaff_complianceArgs
    standards?: boolean | HospitalCountOutputTypeCountStandardsArgs
    training_events?: boolean | HospitalCountOutputTypeCountTraining_eventsArgs
    users?: boolean | HospitalCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the HospitalCountOutputType
     */
    select?: HospitalCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountFindingsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditFindingWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountAudit_schedulesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditScheduleWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountComplianceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ComplianceDataWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountPoliciesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CompliancePolicyWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountReportsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ComplianceReportWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountDepartmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountDocument_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentCategoryWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountDocumentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountRegulatory_deadlinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryDeadlineWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountRegulatory_newsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryNewsWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountRegulatory_standardsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryStandardWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountResource_allocationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ResourceAllocationWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountStaff_complianceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StaffComplianceWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountStandardsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StandardComplianceWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountTraining_eventsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TrainingEventWhereInput
  }

  /**
   * HospitalCountOutputType without action
   */
  export type HospitalCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }


  /**
   * Count Type DocumentCategoryCountOutputType
   */

  export type DocumentCategoryCountOutputType = {
    documents: number
  }

  export type DocumentCategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    documents?: boolean | DocumentCategoryCountOutputTypeCountDocumentsArgs
  }

  // Custom InputTypes
  /**
   * DocumentCategoryCountOutputType without action
   */
  export type DocumentCategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategoryCountOutputType
     */
    select?: DocumentCategoryCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * DocumentCategoryCountOutputType without action
   */
  export type DocumentCategoryCountOutputTypeCountDocumentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentWhereInput
  }


  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type UserSumAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type UserMinAggregateOutputType = {
    id: number | null
    auth0_id: string | null
    username: string | null
    password: string | null
    email: string | null
    role: $Enums.Role | null
    created_at: Date | null
    hospital_id: number | null
  }

  export type UserMaxAggregateOutputType = {
    id: number | null
    auth0_id: string | null
    username: string | null
    password: string | null
    email: string | null
    role: $Enums.Role | null
    created_at: Date | null
    hospital_id: number | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    auth0_id: number
    username: number
    password: number
    email: number
    role: number
    created_at: number
    hospital_id: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type UserSumAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    auth0_id?: true
    username?: true
    password?: true
    email?: true
    role?: true
    created_at?: true
    hospital_id?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    auth0_id?: true
    username?: true
    password?: true
    email?: true
    role?: true
    created_at?: true
    hospital_id?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    auth0_id?: true
    username?: true
    password?: true
    email?: true
    role?: true
    created_at?: true
    hospital_id?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: number
    auth0_id: string | null
    username: string
    password: string
    email: string
    role: $Enums.Role
    created_at: Date
    hospital_id: number | null
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    auth0_id?: boolean
    username?: boolean
    password?: boolean
    email?: boolean
    role?: boolean
    created_at?: boolean
    hospital_id?: boolean
    accounts?: boolean | User$accountsArgs<ExtArgs>
    sessions?: boolean | User$sessionsArgs<ExtArgs>
    hospital?: boolean | User$hospitalArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>



  export type UserSelectScalar = {
    id?: boolean
    auth0_id?: boolean
    username?: boolean
    password?: boolean
    email?: boolean
    role?: boolean
    created_at?: boolean
    hospital_id?: boolean
  }

  export type UserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "auth0_id" | "username" | "password" | "email" | "role" | "created_at" | "hospital_id", ExtArgs["result"]["user"]>
  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    accounts?: boolean | User$accountsArgs<ExtArgs>
    sessions?: boolean | User$sessionsArgs<ExtArgs>
    hospital?: boolean | User$hospitalArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      accounts: Prisma.$AccountPayload<ExtArgs>[]
      sessions: Prisma.$SessionPayload<ExtArgs>[]
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      auth0_id: string | null
      username: string
      password: string
      email: string
      role: $Enums.Role
      created_at: Date
      hospital_id: number | null
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserFindUniqueArgs>(args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(args: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserFindFirstArgs>(args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserFindManyArgs>(args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends UserCreateArgs>(args: SelectSubset<T, UserCreateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserCreateManyArgs>(args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends UserDeleteArgs>(args: SelectSubset<T, UserDeleteArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserUpdateArgs>(args: SelectSubset<T, UserUpdateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDeleteManyArgs>(args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserUpdateManyArgs>(args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends UserUpsertArgs>(args: SelectSubset<T, UserUpsertArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    accounts<T extends User$accountsArgs<ExtArgs> = {}>(args?: Subset<T, User$accountsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    sessions<T extends User$sessionsArgs<ExtArgs> = {}>(args?: Subset<T, User$sessionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    hospital<T extends User$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, User$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the User model
   */
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'Int'>
    readonly auth0_id: FieldRef<"User", 'String'>
    readonly username: FieldRef<"User", 'String'>
    readonly password: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly role: FieldRef<"User", 'Role'>
    readonly created_at: FieldRef<"User", 'DateTime'>
    readonly hospital_id: FieldRef<"User", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to delete.
     */
    limit?: number
  }

  /**
   * User.accounts
   */
  export type User$accountsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    where?: AccountWhereInput
    orderBy?: AccountOrderByWithRelationInput | AccountOrderByWithRelationInput[]
    cursor?: AccountWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * User.sessions
   */
  export type User$sessionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    where?: SessionWhereInput
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    cursor?: SessionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * User.hospital
   */
  export type User$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model Hospital
   */

  export type AggregateHospital = {
    _count: HospitalCountAggregateOutputType | null
    _avg: HospitalAvgAggregateOutputType | null
    _sum: HospitalSumAggregateOutputType | null
    _min: HospitalMinAggregateOutputType | null
    _max: HospitalMaxAggregateOutputType | null
  }

  export type HospitalAvgAggregateOutputType = {
    id: number | null
  }

  export type HospitalSumAggregateOutputType = {
    id: number | null
  }

  export type HospitalMinAggregateOutputType = {
    id: number | null
    name: string | null
    location: string | null
    logo_url: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HospitalMaxAggregateOutputType = {
    id: number | null
    name: string | null
    location: string | null
    logo_url: string | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type HospitalCountAggregateOutputType = {
    id: number
    name: number
    location: number
    logo_url: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type HospitalAvgAggregateInputType = {
    id?: true
  }

  export type HospitalSumAggregateInputType = {
    id?: true
  }

  export type HospitalMinAggregateInputType = {
    id?: true
    name?: true
    location?: true
    logo_url?: true
    created_at?: true
    updated_at?: true
  }

  export type HospitalMaxAggregateInputType = {
    id?: true
    name?: true
    location?: true
    logo_url?: true
    created_at?: true
    updated_at?: true
  }

  export type HospitalCountAggregateInputType = {
    id?: true
    name?: true
    location?: true
    logo_url?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type HospitalAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Hospital to aggregate.
     */
    where?: HospitalWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hospitals to fetch.
     */
    orderBy?: HospitalOrderByWithRelationInput | HospitalOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: HospitalWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hospitals from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hospitals.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Hospitals
    **/
    _count?: true | HospitalCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: HospitalAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: HospitalSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: HospitalMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: HospitalMaxAggregateInputType
  }

  export type GetHospitalAggregateType<T extends HospitalAggregateArgs> = {
        [P in keyof T & keyof AggregateHospital]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateHospital[P]>
      : GetScalarType<T[P], AggregateHospital[P]>
  }




  export type HospitalGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: HospitalWhereInput
    orderBy?: HospitalOrderByWithAggregationInput | HospitalOrderByWithAggregationInput[]
    by: HospitalScalarFieldEnum[] | HospitalScalarFieldEnum
    having?: HospitalScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: HospitalCountAggregateInputType | true
    _avg?: HospitalAvgAggregateInputType
    _sum?: HospitalSumAggregateInputType
    _min?: HospitalMinAggregateInputType
    _max?: HospitalMaxAggregateInputType
  }

  export type HospitalGroupByOutputType = {
    id: number
    name: string
    location: string
    logo_url: string | null
    created_at: Date
    updated_at: Date
    _count: HospitalCountAggregateOutputType | null
    _avg: HospitalAvgAggregateOutputType | null
    _sum: HospitalSumAggregateOutputType | null
    _min: HospitalMinAggregateOutputType | null
    _max: HospitalMaxAggregateOutputType | null
  }

  type GetHospitalGroupByPayload<T extends HospitalGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<HospitalGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof HospitalGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], HospitalGroupByOutputType[P]>
            : GetScalarType<T[P], HospitalGroupByOutputType[P]>
        }
      >
    >


  export type HospitalSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    location?: boolean
    logo_url?: boolean
    created_at?: boolean
    updated_at?: boolean
    findings?: boolean | Hospital$findingsArgs<ExtArgs>
    audit_schedules?: boolean | Hospital$audit_schedulesArgs<ExtArgs>
    compliance?: boolean | Hospital$complianceArgs<ExtArgs>
    policies?: boolean | Hospital$policiesArgs<ExtArgs>
    reports?: boolean | Hospital$reportsArgs<ExtArgs>
    departments?: boolean | Hospital$departmentsArgs<ExtArgs>
    document_categories?: boolean | Hospital$document_categoriesArgs<ExtArgs>
    documents?: boolean | Hospital$documentsArgs<ExtArgs>
    regulatory_deadlines?: boolean | Hospital$regulatory_deadlinesArgs<ExtArgs>
    regulatory_news?: boolean | Hospital$regulatory_newsArgs<ExtArgs>
    regulatory_standards?: boolean | Hospital$regulatory_standardsArgs<ExtArgs>
    resource_allocations?: boolean | Hospital$resource_allocationsArgs<ExtArgs>
    staff_compliance?: boolean | Hospital$staff_complianceArgs<ExtArgs>
    standards?: boolean | Hospital$standardsArgs<ExtArgs>
    training_events?: boolean | Hospital$training_eventsArgs<ExtArgs>
    users?: boolean | Hospital$usersArgs<ExtArgs>
    _count?: boolean | HospitalCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["hospital"]>



  export type HospitalSelectScalar = {
    id?: boolean
    name?: boolean
    location?: boolean
    logo_url?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type HospitalOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "location" | "logo_url" | "created_at" | "updated_at", ExtArgs["result"]["hospital"]>
  export type HospitalInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    findings?: boolean | Hospital$findingsArgs<ExtArgs>
    audit_schedules?: boolean | Hospital$audit_schedulesArgs<ExtArgs>
    compliance?: boolean | Hospital$complianceArgs<ExtArgs>
    policies?: boolean | Hospital$policiesArgs<ExtArgs>
    reports?: boolean | Hospital$reportsArgs<ExtArgs>
    departments?: boolean | Hospital$departmentsArgs<ExtArgs>
    document_categories?: boolean | Hospital$document_categoriesArgs<ExtArgs>
    documents?: boolean | Hospital$documentsArgs<ExtArgs>
    regulatory_deadlines?: boolean | Hospital$regulatory_deadlinesArgs<ExtArgs>
    regulatory_news?: boolean | Hospital$regulatory_newsArgs<ExtArgs>
    regulatory_standards?: boolean | Hospital$regulatory_standardsArgs<ExtArgs>
    resource_allocations?: boolean | Hospital$resource_allocationsArgs<ExtArgs>
    staff_compliance?: boolean | Hospital$staff_complianceArgs<ExtArgs>
    standards?: boolean | Hospital$standardsArgs<ExtArgs>
    training_events?: boolean | Hospital$training_eventsArgs<ExtArgs>
    users?: boolean | Hospital$usersArgs<ExtArgs>
    _count?: boolean | HospitalCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $HospitalPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Hospital"
    objects: {
      findings: Prisma.$AuditFindingPayload<ExtArgs>[]
      audit_schedules: Prisma.$AuditSchedulePayload<ExtArgs>[]
      compliance: Prisma.$ComplianceDataPayload<ExtArgs>[]
      policies: Prisma.$CompliancePolicyPayload<ExtArgs>[]
      reports: Prisma.$ComplianceReportPayload<ExtArgs>[]
      departments: Prisma.$DepartmentPayload<ExtArgs>[]
      document_categories: Prisma.$DocumentCategoryPayload<ExtArgs>[]
      documents: Prisma.$DocumentPayload<ExtArgs>[]
      regulatory_deadlines: Prisma.$RegulatoryDeadlinePayload<ExtArgs>[]
      regulatory_news: Prisma.$RegulatoryNewsPayload<ExtArgs>[]
      regulatory_standards: Prisma.$RegulatoryStandardPayload<ExtArgs>[]
      resource_allocations: Prisma.$ResourceAllocationPayload<ExtArgs>[]
      staff_compliance: Prisma.$StaffCompliancePayload<ExtArgs>[]
      standards: Prisma.$StandardCompliancePayload<ExtArgs>[]
      training_events: Prisma.$TrainingEventPayload<ExtArgs>[]
      users: Prisma.$UserPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      location: string
      logo_url: string | null
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["hospital"]>
    composites: {}
  }

  type HospitalGetPayload<S extends boolean | null | undefined | HospitalDefaultArgs> = $Result.GetResult<Prisma.$HospitalPayload, S>

  type HospitalCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<HospitalFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: HospitalCountAggregateInputType | true
    }

  export interface HospitalDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Hospital'], meta: { name: 'Hospital' } }
    /**
     * Find zero or one Hospital that matches the filter.
     * @param {HospitalFindUniqueArgs} args - Arguments to find a Hospital
     * @example
     * // Get one Hospital
     * const hospital = await prisma.hospital.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends HospitalFindUniqueArgs>(args: SelectSubset<T, HospitalFindUniqueArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Hospital that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {HospitalFindUniqueOrThrowArgs} args - Arguments to find a Hospital
     * @example
     * // Get one Hospital
     * const hospital = await prisma.hospital.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends HospitalFindUniqueOrThrowArgs>(args: SelectSubset<T, HospitalFindUniqueOrThrowArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Hospital that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalFindFirstArgs} args - Arguments to find a Hospital
     * @example
     * // Get one Hospital
     * const hospital = await prisma.hospital.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends HospitalFindFirstArgs>(args?: SelectSubset<T, HospitalFindFirstArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Hospital that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalFindFirstOrThrowArgs} args - Arguments to find a Hospital
     * @example
     * // Get one Hospital
     * const hospital = await prisma.hospital.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends HospitalFindFirstOrThrowArgs>(args?: SelectSubset<T, HospitalFindFirstOrThrowArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Hospitals that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Hospitals
     * const hospitals = await prisma.hospital.findMany()
     * 
     * // Get first 10 Hospitals
     * const hospitals = await prisma.hospital.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const hospitalWithIdOnly = await prisma.hospital.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends HospitalFindManyArgs>(args?: SelectSubset<T, HospitalFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Hospital.
     * @param {HospitalCreateArgs} args - Arguments to create a Hospital.
     * @example
     * // Create one Hospital
     * const Hospital = await prisma.hospital.create({
     *   data: {
     *     // ... data to create a Hospital
     *   }
     * })
     * 
     */
    create<T extends HospitalCreateArgs>(args: SelectSubset<T, HospitalCreateArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Hospitals.
     * @param {HospitalCreateManyArgs} args - Arguments to create many Hospitals.
     * @example
     * // Create many Hospitals
     * const hospital = await prisma.hospital.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends HospitalCreateManyArgs>(args?: SelectSubset<T, HospitalCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Hospital.
     * @param {HospitalDeleteArgs} args - Arguments to delete one Hospital.
     * @example
     * // Delete one Hospital
     * const Hospital = await prisma.hospital.delete({
     *   where: {
     *     // ... filter to delete one Hospital
     *   }
     * })
     * 
     */
    delete<T extends HospitalDeleteArgs>(args: SelectSubset<T, HospitalDeleteArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Hospital.
     * @param {HospitalUpdateArgs} args - Arguments to update one Hospital.
     * @example
     * // Update one Hospital
     * const hospital = await prisma.hospital.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends HospitalUpdateArgs>(args: SelectSubset<T, HospitalUpdateArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Hospitals.
     * @param {HospitalDeleteManyArgs} args - Arguments to filter Hospitals to delete.
     * @example
     * // Delete a few Hospitals
     * const { count } = await prisma.hospital.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends HospitalDeleteManyArgs>(args?: SelectSubset<T, HospitalDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Hospitals.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Hospitals
     * const hospital = await prisma.hospital.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends HospitalUpdateManyArgs>(args: SelectSubset<T, HospitalUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Hospital.
     * @param {HospitalUpsertArgs} args - Arguments to update or create a Hospital.
     * @example
     * // Update or create a Hospital
     * const hospital = await prisma.hospital.upsert({
     *   create: {
     *     // ... data to create a Hospital
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Hospital we want to update
     *   }
     * })
     */
    upsert<T extends HospitalUpsertArgs>(args: SelectSubset<T, HospitalUpsertArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Hospitals.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalCountArgs} args - Arguments to filter Hospitals to count.
     * @example
     * // Count the number of Hospitals
     * const count = await prisma.hospital.count({
     *   where: {
     *     // ... the filter for the Hospitals we want to count
     *   }
     * })
    **/
    count<T extends HospitalCountArgs>(
      args?: Subset<T, HospitalCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], HospitalCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Hospital.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends HospitalAggregateArgs>(args: Subset<T, HospitalAggregateArgs>): Prisma.PrismaPromise<GetHospitalAggregateType<T>>

    /**
     * Group by Hospital.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {HospitalGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends HospitalGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: HospitalGroupByArgs['orderBy'] }
        : { orderBy?: HospitalGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, HospitalGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetHospitalGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Hospital model
   */
  readonly fields: HospitalFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Hospital.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__HospitalClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    findings<T extends Hospital$findingsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$findingsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    audit_schedules<T extends Hospital$audit_schedulesArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$audit_schedulesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    compliance<T extends Hospital$complianceArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$complianceArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    policies<T extends Hospital$policiesArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$policiesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    reports<T extends Hospital$reportsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$reportsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    departments<T extends Hospital$departmentsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$departmentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    document_categories<T extends Hospital$document_categoriesArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$document_categoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    documents<T extends Hospital$documentsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$documentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    regulatory_deadlines<T extends Hospital$regulatory_deadlinesArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$regulatory_deadlinesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    regulatory_news<T extends Hospital$regulatory_newsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$regulatory_newsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    regulatory_standards<T extends Hospital$regulatory_standardsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$regulatory_standardsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    resource_allocations<T extends Hospital$resource_allocationsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$resource_allocationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    staff_compliance<T extends Hospital$staff_complianceArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$staff_complianceArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    standards<T extends Hospital$standardsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$standardsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    training_events<T extends Hospital$training_eventsArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$training_eventsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    users<T extends Hospital$usersArgs<ExtArgs> = {}>(args?: Subset<T, Hospital$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Hospital model
   */
  interface HospitalFieldRefs {
    readonly id: FieldRef<"Hospital", 'Int'>
    readonly name: FieldRef<"Hospital", 'String'>
    readonly location: FieldRef<"Hospital", 'String'>
    readonly logo_url: FieldRef<"Hospital", 'String'>
    readonly created_at: FieldRef<"Hospital", 'DateTime'>
    readonly updated_at: FieldRef<"Hospital", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Hospital findUnique
   */
  export type HospitalFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter, which Hospital to fetch.
     */
    where: HospitalWhereUniqueInput
  }

  /**
   * Hospital findUniqueOrThrow
   */
  export type HospitalFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter, which Hospital to fetch.
     */
    where: HospitalWhereUniqueInput
  }

  /**
   * Hospital findFirst
   */
  export type HospitalFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter, which Hospital to fetch.
     */
    where?: HospitalWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hospitals to fetch.
     */
    orderBy?: HospitalOrderByWithRelationInput | HospitalOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Hospitals.
     */
    cursor?: HospitalWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hospitals from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hospitals.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Hospitals.
     */
    distinct?: HospitalScalarFieldEnum | HospitalScalarFieldEnum[]
  }

  /**
   * Hospital findFirstOrThrow
   */
  export type HospitalFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter, which Hospital to fetch.
     */
    where?: HospitalWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hospitals to fetch.
     */
    orderBy?: HospitalOrderByWithRelationInput | HospitalOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Hospitals.
     */
    cursor?: HospitalWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hospitals from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hospitals.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Hospitals.
     */
    distinct?: HospitalScalarFieldEnum | HospitalScalarFieldEnum[]
  }

  /**
   * Hospital findMany
   */
  export type HospitalFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter, which Hospitals to fetch.
     */
    where?: HospitalWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Hospitals to fetch.
     */
    orderBy?: HospitalOrderByWithRelationInput | HospitalOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Hospitals.
     */
    cursor?: HospitalWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Hospitals from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Hospitals.
     */
    skip?: number
    distinct?: HospitalScalarFieldEnum | HospitalScalarFieldEnum[]
  }

  /**
   * Hospital create
   */
  export type HospitalCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * The data needed to create a Hospital.
     */
    data: XOR<HospitalCreateInput, HospitalUncheckedCreateInput>
  }

  /**
   * Hospital createMany
   */
  export type HospitalCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Hospitals.
     */
    data: HospitalCreateManyInput | HospitalCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Hospital update
   */
  export type HospitalUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * The data needed to update a Hospital.
     */
    data: XOR<HospitalUpdateInput, HospitalUncheckedUpdateInput>
    /**
     * Choose, which Hospital to update.
     */
    where: HospitalWhereUniqueInput
  }

  /**
   * Hospital updateMany
   */
  export type HospitalUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Hospitals.
     */
    data: XOR<HospitalUpdateManyMutationInput, HospitalUncheckedUpdateManyInput>
    /**
     * Filter which Hospitals to update
     */
    where?: HospitalWhereInput
    /**
     * Limit how many Hospitals to update.
     */
    limit?: number
  }

  /**
   * Hospital upsert
   */
  export type HospitalUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * The filter to search for the Hospital to update in case it exists.
     */
    where: HospitalWhereUniqueInput
    /**
     * In case the Hospital found by the `where` argument doesn't exist, create a new Hospital with this data.
     */
    create: XOR<HospitalCreateInput, HospitalUncheckedCreateInput>
    /**
     * In case the Hospital was found with the provided `where` argument, update it with this data.
     */
    update: XOR<HospitalUpdateInput, HospitalUncheckedUpdateInput>
  }

  /**
   * Hospital delete
   */
  export type HospitalDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    /**
     * Filter which Hospital to delete.
     */
    where: HospitalWhereUniqueInput
  }

  /**
   * Hospital deleteMany
   */
  export type HospitalDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Hospitals to delete
     */
    where?: HospitalWhereInput
    /**
     * Limit how many Hospitals to delete.
     */
    limit?: number
  }

  /**
   * Hospital.findings
   */
  export type Hospital$findingsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    where?: AuditFindingWhereInput
    orderBy?: AuditFindingOrderByWithRelationInput | AuditFindingOrderByWithRelationInput[]
    cursor?: AuditFindingWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AuditFindingScalarFieldEnum | AuditFindingScalarFieldEnum[]
  }

  /**
   * Hospital.audit_schedules
   */
  export type Hospital$audit_schedulesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    where?: AuditScheduleWhereInput
    orderBy?: AuditScheduleOrderByWithRelationInput | AuditScheduleOrderByWithRelationInput[]
    cursor?: AuditScheduleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AuditScheduleScalarFieldEnum | AuditScheduleScalarFieldEnum[]
  }

  /**
   * Hospital.compliance
   */
  export type Hospital$complianceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    where?: ComplianceDataWhereInput
    orderBy?: ComplianceDataOrderByWithRelationInput | ComplianceDataOrderByWithRelationInput[]
    cursor?: ComplianceDataWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ComplianceDataScalarFieldEnum | ComplianceDataScalarFieldEnum[]
  }

  /**
   * Hospital.policies
   */
  export type Hospital$policiesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    where?: CompliancePolicyWhereInput
    orderBy?: CompliancePolicyOrderByWithRelationInput | CompliancePolicyOrderByWithRelationInput[]
    cursor?: CompliancePolicyWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CompliancePolicyScalarFieldEnum | CompliancePolicyScalarFieldEnum[]
  }

  /**
   * Hospital.reports
   */
  export type Hospital$reportsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    where?: ComplianceReportWhereInput
    orderBy?: ComplianceReportOrderByWithRelationInput | ComplianceReportOrderByWithRelationInput[]
    cursor?: ComplianceReportWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ComplianceReportScalarFieldEnum | ComplianceReportScalarFieldEnum[]
  }

  /**
   * Hospital.departments
   */
  export type Hospital$departmentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Hospital.document_categories
   */
  export type Hospital$document_categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    where?: DocumentCategoryWhereInput
    orderBy?: DocumentCategoryOrderByWithRelationInput | DocumentCategoryOrderByWithRelationInput[]
    cursor?: DocumentCategoryWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentCategoryScalarFieldEnum | DocumentCategoryScalarFieldEnum[]
  }

  /**
   * Hospital.documents
   */
  export type Hospital$documentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    where?: DocumentWhereInput
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    cursor?: DocumentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentScalarFieldEnum | DocumentScalarFieldEnum[]
  }

  /**
   * Hospital.regulatory_deadlines
   */
  export type Hospital$regulatory_deadlinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    where?: RegulatoryDeadlineWhereInput
    orderBy?: RegulatoryDeadlineOrderByWithRelationInput | RegulatoryDeadlineOrderByWithRelationInput[]
    cursor?: RegulatoryDeadlineWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RegulatoryDeadlineScalarFieldEnum | RegulatoryDeadlineScalarFieldEnum[]
  }

  /**
   * Hospital.regulatory_news
   */
  export type Hospital$regulatory_newsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    where?: RegulatoryNewsWhereInput
    orderBy?: RegulatoryNewsOrderByWithRelationInput | RegulatoryNewsOrderByWithRelationInput[]
    cursor?: RegulatoryNewsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RegulatoryNewsScalarFieldEnum | RegulatoryNewsScalarFieldEnum[]
  }

  /**
   * Hospital.regulatory_standards
   */
  export type Hospital$regulatory_standardsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    where?: RegulatoryStandardWhereInput
    orderBy?: RegulatoryStandardOrderByWithRelationInput | RegulatoryStandardOrderByWithRelationInput[]
    cursor?: RegulatoryStandardWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RegulatoryStandardScalarFieldEnum | RegulatoryStandardScalarFieldEnum[]
  }

  /**
   * Hospital.resource_allocations
   */
  export type Hospital$resource_allocationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    where?: ResourceAllocationWhereInput
    orderBy?: ResourceAllocationOrderByWithRelationInput | ResourceAllocationOrderByWithRelationInput[]
    cursor?: ResourceAllocationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ResourceAllocationScalarFieldEnum | ResourceAllocationScalarFieldEnum[]
  }

  /**
   * Hospital.staff_compliance
   */
  export type Hospital$staff_complianceArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    where?: StaffComplianceWhereInput
    orderBy?: StaffComplianceOrderByWithRelationInput | StaffComplianceOrderByWithRelationInput[]
    cursor?: StaffComplianceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: StaffComplianceScalarFieldEnum | StaffComplianceScalarFieldEnum[]
  }

  /**
   * Hospital.standards
   */
  export type Hospital$standardsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    where?: StandardComplianceWhereInput
    orderBy?: StandardComplianceOrderByWithRelationInput | StandardComplianceOrderByWithRelationInput[]
    cursor?: StandardComplianceWhereUniqueInput
    take?: number
    skip?: number
    distinct?: StandardComplianceScalarFieldEnum | StandardComplianceScalarFieldEnum[]
  }

  /**
   * Hospital.training_events
   */
  export type Hospital$training_eventsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    where?: TrainingEventWhereInput
    orderBy?: TrainingEventOrderByWithRelationInput | TrainingEventOrderByWithRelationInput[]
    cursor?: TrainingEventWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TrainingEventScalarFieldEnum | TrainingEventScalarFieldEnum[]
  }

  /**
   * Hospital.users
   */
  export type Hospital$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * Hospital without action
   */
  export type HospitalDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
  }


  /**
   * Model Account
   */

  export type AggregateAccount = {
    _count: AccountCountAggregateOutputType | null
    _avg: AccountAvgAggregateOutputType | null
    _sum: AccountSumAggregateOutputType | null
    _min: AccountMinAggregateOutputType | null
    _max: AccountMaxAggregateOutputType | null
  }

  export type AccountAvgAggregateOutputType = {
    userId: number | null
    expires_at: number | null
  }

  export type AccountSumAggregateOutputType = {
    userId: number | null
    expires_at: number | null
  }

  export type AccountMinAggregateOutputType = {
    id: string | null
    userId: number | null
    type: string | null
    provider: string | null
    providerAccountId: string | null
    refresh_token: string | null
    access_token: string | null
    expires_at: number | null
    token_type: string | null
    scope: string | null
    id_token: string | null
    session_state: string | null
  }

  export type AccountMaxAggregateOutputType = {
    id: string | null
    userId: number | null
    type: string | null
    provider: string | null
    providerAccountId: string | null
    refresh_token: string | null
    access_token: string | null
    expires_at: number | null
    token_type: string | null
    scope: string | null
    id_token: string | null
    session_state: string | null
  }

  export type AccountCountAggregateOutputType = {
    id: number
    userId: number
    type: number
    provider: number
    providerAccountId: number
    refresh_token: number
    access_token: number
    expires_at: number
    token_type: number
    scope: number
    id_token: number
    session_state: number
    _all: number
  }


  export type AccountAvgAggregateInputType = {
    userId?: true
    expires_at?: true
  }

  export type AccountSumAggregateInputType = {
    userId?: true
    expires_at?: true
  }

  export type AccountMinAggregateInputType = {
    id?: true
    userId?: true
    type?: true
    provider?: true
    providerAccountId?: true
    refresh_token?: true
    access_token?: true
    expires_at?: true
    token_type?: true
    scope?: true
    id_token?: true
    session_state?: true
  }

  export type AccountMaxAggregateInputType = {
    id?: true
    userId?: true
    type?: true
    provider?: true
    providerAccountId?: true
    refresh_token?: true
    access_token?: true
    expires_at?: true
    token_type?: true
    scope?: true
    id_token?: true
    session_state?: true
  }

  export type AccountCountAggregateInputType = {
    id?: true
    userId?: true
    type?: true
    provider?: true
    providerAccountId?: true
    refresh_token?: true
    access_token?: true
    expires_at?: true
    token_type?: true
    scope?: true
    id_token?: true
    session_state?: true
    _all?: true
  }

  export type AccountAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Account to aggregate.
     */
    where?: AccountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Accounts to fetch.
     */
    orderBy?: AccountOrderByWithRelationInput | AccountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AccountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Accounts
    **/
    _count?: true | AccountCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AccountAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AccountSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AccountMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AccountMaxAggregateInputType
  }

  export type GetAccountAggregateType<T extends AccountAggregateArgs> = {
        [P in keyof T & keyof AggregateAccount]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAccount[P]>
      : GetScalarType<T[P], AggregateAccount[P]>
  }




  export type AccountGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AccountWhereInput
    orderBy?: AccountOrderByWithAggregationInput | AccountOrderByWithAggregationInput[]
    by: AccountScalarFieldEnum[] | AccountScalarFieldEnum
    having?: AccountScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AccountCountAggregateInputType | true
    _avg?: AccountAvgAggregateInputType
    _sum?: AccountSumAggregateInputType
    _min?: AccountMinAggregateInputType
    _max?: AccountMaxAggregateInputType
  }

  export type AccountGroupByOutputType = {
    id: string
    userId: number
    type: string
    provider: string
    providerAccountId: string
    refresh_token: string | null
    access_token: string | null
    expires_at: number | null
    token_type: string | null
    scope: string | null
    id_token: string | null
    session_state: string | null
    _count: AccountCountAggregateOutputType | null
    _avg: AccountAvgAggregateOutputType | null
    _sum: AccountSumAggregateOutputType | null
    _min: AccountMinAggregateOutputType | null
    _max: AccountMaxAggregateOutputType | null
  }

  type GetAccountGroupByPayload<T extends AccountGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AccountGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AccountGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AccountGroupByOutputType[P]>
            : GetScalarType<T[P], AccountGroupByOutputType[P]>
        }
      >
    >


  export type AccountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    userId?: boolean
    type?: boolean
    provider?: boolean
    providerAccountId?: boolean
    refresh_token?: boolean
    access_token?: boolean
    expires_at?: boolean
    token_type?: boolean
    scope?: boolean
    id_token?: boolean
    session_state?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["account"]>



  export type AccountSelectScalar = {
    id?: boolean
    userId?: boolean
    type?: boolean
    provider?: boolean
    providerAccountId?: boolean
    refresh_token?: boolean
    access_token?: boolean
    expires_at?: boolean
    token_type?: boolean
    scope?: boolean
    id_token?: boolean
    session_state?: boolean
  }

  export type AccountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "userId" | "type" | "provider" | "providerAccountId" | "refresh_token" | "access_token" | "expires_at" | "token_type" | "scope" | "id_token" | "session_state", ExtArgs["result"]["account"]>
  export type AccountInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $AccountPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Account"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      userId: number
      type: string
      provider: string
      providerAccountId: string
      refresh_token: string | null
      access_token: string | null
      expires_at: number | null
      token_type: string | null
      scope: string | null
      id_token: string | null
      session_state: string | null
    }, ExtArgs["result"]["account"]>
    composites: {}
  }

  type AccountGetPayload<S extends boolean | null | undefined | AccountDefaultArgs> = $Result.GetResult<Prisma.$AccountPayload, S>

  type AccountCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<AccountFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AccountCountAggregateInputType | true
    }

  export interface AccountDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Account'], meta: { name: 'Account' } }
    /**
     * Find zero or one Account that matches the filter.
     * @param {AccountFindUniqueArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AccountFindUniqueArgs>(args: SelectSubset<T, AccountFindUniqueArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Account that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {AccountFindUniqueOrThrowArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AccountFindUniqueOrThrowArgs>(args: SelectSubset<T, AccountFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Account that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountFindFirstArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AccountFindFirstArgs>(args?: SelectSubset<T, AccountFindFirstArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Account that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountFindFirstOrThrowArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AccountFindFirstOrThrowArgs>(args?: SelectSubset<T, AccountFindFirstOrThrowArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Accounts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Accounts
     * const accounts = await prisma.account.findMany()
     * 
     * // Get first 10 Accounts
     * const accounts = await prisma.account.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const accountWithIdOnly = await prisma.account.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends AccountFindManyArgs>(args?: SelectSubset<T, AccountFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Account.
     * @param {AccountCreateArgs} args - Arguments to create a Account.
     * @example
     * // Create one Account
     * const Account = await prisma.account.create({
     *   data: {
     *     // ... data to create a Account
     *   }
     * })
     * 
     */
    create<T extends AccountCreateArgs>(args: SelectSubset<T, AccountCreateArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Accounts.
     * @param {AccountCreateManyArgs} args - Arguments to create many Accounts.
     * @example
     * // Create many Accounts
     * const account = await prisma.account.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AccountCreateManyArgs>(args?: SelectSubset<T, AccountCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Account.
     * @param {AccountDeleteArgs} args - Arguments to delete one Account.
     * @example
     * // Delete one Account
     * const Account = await prisma.account.delete({
     *   where: {
     *     // ... filter to delete one Account
     *   }
     * })
     * 
     */
    delete<T extends AccountDeleteArgs>(args: SelectSubset<T, AccountDeleteArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Account.
     * @param {AccountUpdateArgs} args - Arguments to update one Account.
     * @example
     * // Update one Account
     * const account = await prisma.account.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AccountUpdateArgs>(args: SelectSubset<T, AccountUpdateArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Accounts.
     * @param {AccountDeleteManyArgs} args - Arguments to filter Accounts to delete.
     * @example
     * // Delete a few Accounts
     * const { count } = await prisma.account.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AccountDeleteManyArgs>(args?: SelectSubset<T, AccountDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Accounts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Accounts
     * const account = await prisma.account.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AccountUpdateManyArgs>(args: SelectSubset<T, AccountUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Account.
     * @param {AccountUpsertArgs} args - Arguments to update or create a Account.
     * @example
     * // Update or create a Account
     * const account = await prisma.account.upsert({
     *   create: {
     *     // ... data to create a Account
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Account we want to update
     *   }
     * })
     */
    upsert<T extends AccountUpsertArgs>(args: SelectSubset<T, AccountUpsertArgs<ExtArgs>>): Prisma__AccountClient<$Result.GetResult<Prisma.$AccountPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Accounts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountCountArgs} args - Arguments to filter Accounts to count.
     * @example
     * // Count the number of Accounts
     * const count = await prisma.account.count({
     *   where: {
     *     // ... the filter for the Accounts we want to count
     *   }
     * })
    **/
    count<T extends AccountCountArgs>(
      args?: Subset<T, AccountCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AccountCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Account.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AccountAggregateArgs>(args: Subset<T, AccountAggregateArgs>): Prisma.PrismaPromise<GetAccountAggregateType<T>>

    /**
     * Group by Account.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AccountGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AccountGroupByArgs['orderBy'] }
        : { orderBy?: AccountGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AccountGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAccountGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Account model
   */
  readonly fields: AccountFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Account.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AccountClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Account model
   */
  interface AccountFieldRefs {
    readonly id: FieldRef<"Account", 'String'>
    readonly userId: FieldRef<"Account", 'Int'>
    readonly type: FieldRef<"Account", 'String'>
    readonly provider: FieldRef<"Account", 'String'>
    readonly providerAccountId: FieldRef<"Account", 'String'>
    readonly refresh_token: FieldRef<"Account", 'String'>
    readonly access_token: FieldRef<"Account", 'String'>
    readonly expires_at: FieldRef<"Account", 'Int'>
    readonly token_type: FieldRef<"Account", 'String'>
    readonly scope: FieldRef<"Account", 'String'>
    readonly id_token: FieldRef<"Account", 'String'>
    readonly session_state: FieldRef<"Account", 'String'>
  }
    

  // Custom InputTypes
  /**
   * Account findUnique
   */
  export type AccountFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter, which Account to fetch.
     */
    where: AccountWhereUniqueInput
  }

  /**
   * Account findUniqueOrThrow
   */
  export type AccountFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter, which Account to fetch.
     */
    where: AccountWhereUniqueInput
  }

  /**
   * Account findFirst
   */
  export type AccountFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter, which Account to fetch.
     */
    where?: AccountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Accounts to fetch.
     */
    orderBy?: AccountOrderByWithRelationInput | AccountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Accounts.
     */
    cursor?: AccountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Accounts.
     */
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * Account findFirstOrThrow
   */
  export type AccountFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter, which Account to fetch.
     */
    where?: AccountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Accounts to fetch.
     */
    orderBy?: AccountOrderByWithRelationInput | AccountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Accounts.
     */
    cursor?: AccountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Accounts.
     */
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * Account findMany
   */
  export type AccountFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter, which Accounts to fetch.
     */
    where?: AccountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Accounts to fetch.
     */
    orderBy?: AccountOrderByWithRelationInput | AccountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Accounts.
     */
    cursor?: AccountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Accounts.
     */
    skip?: number
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * Account create
   */
  export type AccountCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * The data needed to create a Account.
     */
    data: XOR<AccountCreateInput, AccountUncheckedCreateInput>
  }

  /**
   * Account createMany
   */
  export type AccountCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Accounts.
     */
    data: AccountCreateManyInput | AccountCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Account update
   */
  export type AccountUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * The data needed to update a Account.
     */
    data: XOR<AccountUpdateInput, AccountUncheckedUpdateInput>
    /**
     * Choose, which Account to update.
     */
    where: AccountWhereUniqueInput
  }

  /**
   * Account updateMany
   */
  export type AccountUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Accounts.
     */
    data: XOR<AccountUpdateManyMutationInput, AccountUncheckedUpdateManyInput>
    /**
     * Filter which Accounts to update
     */
    where?: AccountWhereInput
    /**
     * Limit how many Accounts to update.
     */
    limit?: number
  }

  /**
   * Account upsert
   */
  export type AccountUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * The filter to search for the Account to update in case it exists.
     */
    where: AccountWhereUniqueInput
    /**
     * In case the Account found by the `where` argument doesn't exist, create a new Account with this data.
     */
    create: XOR<AccountCreateInput, AccountUncheckedCreateInput>
    /**
     * In case the Account was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AccountUpdateInput, AccountUncheckedUpdateInput>
  }

  /**
   * Account delete
   */
  export type AccountDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
    /**
     * Filter which Account to delete.
     */
    where: AccountWhereUniqueInput
  }

  /**
   * Account deleteMany
   */
  export type AccountDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Accounts to delete
     */
    where?: AccountWhereInput
    /**
     * Limit how many Accounts to delete.
     */
    limit?: number
  }

  /**
   * Account without action
   */
  export type AccountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Account
     */
    select?: AccountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Account
     */
    omit?: AccountOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AccountInclude<ExtArgs> | null
  }


  /**
   * Model Session
   */

  export type AggregateSession = {
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  export type SessionAvgAggregateOutputType = {
    userId: number | null
  }

  export type SessionSumAggregateOutputType = {
    userId: number | null
  }

  export type SessionMinAggregateOutputType = {
    id: string | null
    sessionToken: string | null
    userId: number | null
    expires: Date | null
  }

  export type SessionMaxAggregateOutputType = {
    id: string | null
    sessionToken: string | null
    userId: number | null
    expires: Date | null
  }

  export type SessionCountAggregateOutputType = {
    id: number
    sessionToken: number
    userId: number
    expires: number
    _all: number
  }


  export type SessionAvgAggregateInputType = {
    userId?: true
  }

  export type SessionSumAggregateInputType = {
    userId?: true
  }

  export type SessionMinAggregateInputType = {
    id?: true
    sessionToken?: true
    userId?: true
    expires?: true
  }

  export type SessionMaxAggregateInputType = {
    id?: true
    sessionToken?: true
    userId?: true
    expires?: true
  }

  export type SessionCountAggregateInputType = {
    id?: true
    sessionToken?: true
    userId?: true
    expires?: true
    _all?: true
  }

  export type SessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Session to aggregate.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Sessions
    **/
    _count?: true | SessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SessionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SessionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SessionMaxAggregateInputType
  }

  export type GetSessionAggregateType<T extends SessionAggregateArgs> = {
        [P in keyof T & keyof AggregateSession]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSession[P]>
      : GetScalarType<T[P], AggregateSession[P]>
  }




  export type SessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: SessionWhereInput
    orderBy?: SessionOrderByWithAggregationInput | SessionOrderByWithAggregationInput[]
    by: SessionScalarFieldEnum[] | SessionScalarFieldEnum
    having?: SessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SessionCountAggregateInputType | true
    _avg?: SessionAvgAggregateInputType
    _sum?: SessionSumAggregateInputType
    _min?: SessionMinAggregateInputType
    _max?: SessionMaxAggregateInputType
  }

  export type SessionGroupByOutputType = {
    id: string
    sessionToken: string
    userId: number
    expires: Date
    _count: SessionCountAggregateOutputType | null
    _avg: SessionAvgAggregateOutputType | null
    _sum: SessionSumAggregateOutputType | null
    _min: SessionMinAggregateOutputType | null
    _max: SessionMaxAggregateOutputType | null
  }

  type GetSessionGroupByPayload<T extends SessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SessionGroupByOutputType[P]>
            : GetScalarType<T[P], SessionGroupByOutputType[P]>
        }
      >
    >


  export type SessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    sessionToken?: boolean
    userId?: boolean
    expires?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["session"]>



  export type SessionSelectScalar = {
    id?: boolean
    sessionToken?: boolean
    userId?: boolean
    expires?: boolean
  }

  export type SessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "sessionToken" | "userId" | "expires", ExtArgs["result"]["session"]>
  export type SessionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $SessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Session"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      sessionToken: string
      userId: number
      expires: Date
    }, ExtArgs["result"]["session"]>
    composites: {}
  }

  type SessionGetPayload<S extends boolean | null | undefined | SessionDefaultArgs> = $Result.GetResult<Prisma.$SessionPayload, S>

  type SessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<SessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: SessionCountAggregateInputType | true
    }

  export interface SessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Session'], meta: { name: 'Session' } }
    /**
     * Find zero or one Session that matches the filter.
     * @param {SessionFindUniqueArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends SessionFindUniqueArgs>(args: SelectSubset<T, SessionFindUniqueArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Session that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {SessionFindUniqueOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends SessionFindUniqueOrThrowArgs>(args: SelectSubset<T, SessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends SessionFindFirstArgs>(args?: SelectSubset<T, SessionFindFirstArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Session that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindFirstOrThrowArgs} args - Arguments to find a Session
     * @example
     * // Get one Session
     * const session = await prisma.session.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends SessionFindFirstOrThrowArgs>(args?: SelectSubset<T, SessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Sessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Sessions
     * const sessions = await prisma.session.findMany()
     * 
     * // Get first 10 Sessions
     * const sessions = await prisma.session.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const sessionWithIdOnly = await prisma.session.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends SessionFindManyArgs>(args?: SelectSubset<T, SessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Session.
     * @param {SessionCreateArgs} args - Arguments to create a Session.
     * @example
     * // Create one Session
     * const Session = await prisma.session.create({
     *   data: {
     *     // ... data to create a Session
     *   }
     * })
     * 
     */
    create<T extends SessionCreateArgs>(args: SelectSubset<T, SessionCreateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Sessions.
     * @param {SessionCreateManyArgs} args - Arguments to create many Sessions.
     * @example
     * // Create many Sessions
     * const session = await prisma.session.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends SessionCreateManyArgs>(args?: SelectSubset<T, SessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Session.
     * @param {SessionDeleteArgs} args - Arguments to delete one Session.
     * @example
     * // Delete one Session
     * const Session = await prisma.session.delete({
     *   where: {
     *     // ... filter to delete one Session
     *   }
     * })
     * 
     */
    delete<T extends SessionDeleteArgs>(args: SelectSubset<T, SessionDeleteArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Session.
     * @param {SessionUpdateArgs} args - Arguments to update one Session.
     * @example
     * // Update one Session
     * const session = await prisma.session.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends SessionUpdateArgs>(args: SelectSubset<T, SessionUpdateArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Sessions.
     * @param {SessionDeleteManyArgs} args - Arguments to filter Sessions to delete.
     * @example
     * // Delete a few Sessions
     * const { count } = await prisma.session.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends SessionDeleteManyArgs>(args?: SelectSubset<T, SessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Sessions
     * const session = await prisma.session.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends SessionUpdateManyArgs>(args: SelectSubset<T, SessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Session.
     * @param {SessionUpsertArgs} args - Arguments to update or create a Session.
     * @example
     * // Update or create a Session
     * const session = await prisma.session.upsert({
     *   create: {
     *     // ... data to create a Session
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Session we want to update
     *   }
     * })
     */
    upsert<T extends SessionUpsertArgs>(args: SelectSubset<T, SessionUpsertArgs<ExtArgs>>): Prisma__SessionClient<$Result.GetResult<Prisma.$SessionPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionCountArgs} args - Arguments to filter Sessions to count.
     * @example
     * // Count the number of Sessions
     * const count = await prisma.session.count({
     *   where: {
     *     // ... the filter for the Sessions we want to count
     *   }
     * })
    **/
    count<T extends SessionCountArgs>(
      args?: Subset<T, SessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SessionAggregateArgs>(args: Subset<T, SessionAggregateArgs>): Prisma.PrismaPromise<GetSessionAggregateType<T>>

    /**
     * Group by Session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends SessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: SessionGroupByArgs['orderBy'] }
        : { orderBy?: SessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, SessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Session model
   */
  readonly fields: SessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Session.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__SessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Session model
   */
  interface SessionFieldRefs {
    readonly id: FieldRef<"Session", 'String'>
    readonly sessionToken: FieldRef<"Session", 'String'>
    readonly userId: FieldRef<"Session", 'Int'>
    readonly expires: FieldRef<"Session", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Session findUnique
   */
  export type SessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findUniqueOrThrow
   */
  export type SessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session findFirst
   */
  export type SessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findFirstOrThrow
   */
  export type SessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter, which Session to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Sessions.
     */
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session findMany
   */
  export type SessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter, which Sessions to fetch.
     */
    where?: SessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Sessions to fetch.
     */
    orderBy?: SessionOrderByWithRelationInput | SessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Sessions.
     */
    cursor?: SessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Sessions.
     */
    skip?: number
    distinct?: SessionScalarFieldEnum | SessionScalarFieldEnum[]
  }

  /**
   * Session create
   */
  export type SessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * The data needed to create a Session.
     */
    data: XOR<SessionCreateInput, SessionUncheckedCreateInput>
  }

  /**
   * Session createMany
   */
  export type SessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Sessions.
     */
    data: SessionCreateManyInput | SessionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Session update
   */
  export type SessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * The data needed to update a Session.
     */
    data: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
    /**
     * Choose, which Session to update.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session updateMany
   */
  export type SessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Sessions.
     */
    data: XOR<SessionUpdateManyMutationInput, SessionUncheckedUpdateManyInput>
    /**
     * Filter which Sessions to update
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to update.
     */
    limit?: number
  }

  /**
   * Session upsert
   */
  export type SessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * The filter to search for the Session to update in case it exists.
     */
    where: SessionWhereUniqueInput
    /**
     * In case the Session found by the `where` argument doesn't exist, create a new Session with this data.
     */
    create: XOR<SessionCreateInput, SessionUncheckedCreateInput>
    /**
     * In case the Session was found with the provided `where` argument, update it with this data.
     */
    update: XOR<SessionUpdateInput, SessionUncheckedUpdateInput>
  }

  /**
   * Session delete
   */
  export type SessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
    /**
     * Filter which Session to delete.
     */
    where: SessionWhereUniqueInput
  }

  /**
   * Session deleteMany
   */
  export type SessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Sessions to delete
     */
    where?: SessionWhereInput
    /**
     * Limit how many Sessions to delete.
     */
    limit?: number
  }

  /**
   * Session without action
   */
  export type SessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Session
     */
    select?: SessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Session
     */
    omit?: SessionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SessionInclude<ExtArgs> | null
  }


  /**
   * Model VerificationToken
   */

  export type AggregateVerificationToken = {
    _count: VerificationTokenCountAggregateOutputType | null
    _min: VerificationTokenMinAggregateOutputType | null
    _max: VerificationTokenMaxAggregateOutputType | null
  }

  export type VerificationTokenMinAggregateOutputType = {
    identifier: string | null
    token: string | null
    expires: Date | null
  }

  export type VerificationTokenMaxAggregateOutputType = {
    identifier: string | null
    token: string | null
    expires: Date | null
  }

  export type VerificationTokenCountAggregateOutputType = {
    identifier: number
    token: number
    expires: number
    _all: number
  }


  export type VerificationTokenMinAggregateInputType = {
    identifier?: true
    token?: true
    expires?: true
  }

  export type VerificationTokenMaxAggregateInputType = {
    identifier?: true
    token?: true
    expires?: true
  }

  export type VerificationTokenCountAggregateInputType = {
    identifier?: true
    token?: true
    expires?: true
    _all?: true
  }

  export type VerificationTokenAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which VerificationToken to aggregate.
     */
    where?: VerificationTokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of VerificationTokens to fetch.
     */
    orderBy?: VerificationTokenOrderByWithRelationInput | VerificationTokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: VerificationTokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` VerificationTokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` VerificationTokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned VerificationTokens
    **/
    _count?: true | VerificationTokenCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: VerificationTokenMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: VerificationTokenMaxAggregateInputType
  }

  export type GetVerificationTokenAggregateType<T extends VerificationTokenAggregateArgs> = {
        [P in keyof T & keyof AggregateVerificationToken]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateVerificationToken[P]>
      : GetScalarType<T[P], AggregateVerificationToken[P]>
  }




  export type VerificationTokenGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: VerificationTokenWhereInput
    orderBy?: VerificationTokenOrderByWithAggregationInput | VerificationTokenOrderByWithAggregationInput[]
    by: VerificationTokenScalarFieldEnum[] | VerificationTokenScalarFieldEnum
    having?: VerificationTokenScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: VerificationTokenCountAggregateInputType | true
    _min?: VerificationTokenMinAggregateInputType
    _max?: VerificationTokenMaxAggregateInputType
  }

  export type VerificationTokenGroupByOutputType = {
    identifier: string
    token: string
    expires: Date
    _count: VerificationTokenCountAggregateOutputType | null
    _min: VerificationTokenMinAggregateOutputType | null
    _max: VerificationTokenMaxAggregateOutputType | null
  }

  type GetVerificationTokenGroupByPayload<T extends VerificationTokenGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<VerificationTokenGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof VerificationTokenGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], VerificationTokenGroupByOutputType[P]>
            : GetScalarType<T[P], VerificationTokenGroupByOutputType[P]>
        }
      >
    >


  export type VerificationTokenSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    identifier?: boolean
    token?: boolean
    expires?: boolean
  }, ExtArgs["result"]["verificationToken"]>



  export type VerificationTokenSelectScalar = {
    identifier?: boolean
    token?: boolean
    expires?: boolean
  }

  export type VerificationTokenOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"identifier" | "token" | "expires", ExtArgs["result"]["verificationToken"]>

  export type $VerificationTokenPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "VerificationToken"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      identifier: string
      token: string
      expires: Date
    }, ExtArgs["result"]["verificationToken"]>
    composites: {}
  }

  type VerificationTokenGetPayload<S extends boolean | null | undefined | VerificationTokenDefaultArgs> = $Result.GetResult<Prisma.$VerificationTokenPayload, S>

  type VerificationTokenCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<VerificationTokenFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: VerificationTokenCountAggregateInputType | true
    }

  export interface VerificationTokenDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['VerificationToken'], meta: { name: 'VerificationToken' } }
    /**
     * Find zero or one VerificationToken that matches the filter.
     * @param {VerificationTokenFindUniqueArgs} args - Arguments to find a VerificationToken
     * @example
     * // Get one VerificationToken
     * const verificationToken = await prisma.verificationToken.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends VerificationTokenFindUniqueArgs>(args: SelectSubset<T, VerificationTokenFindUniqueArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one VerificationToken that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {VerificationTokenFindUniqueOrThrowArgs} args - Arguments to find a VerificationToken
     * @example
     * // Get one VerificationToken
     * const verificationToken = await prisma.verificationToken.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends VerificationTokenFindUniqueOrThrowArgs>(args: SelectSubset<T, VerificationTokenFindUniqueOrThrowArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first VerificationToken that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenFindFirstArgs} args - Arguments to find a VerificationToken
     * @example
     * // Get one VerificationToken
     * const verificationToken = await prisma.verificationToken.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends VerificationTokenFindFirstArgs>(args?: SelectSubset<T, VerificationTokenFindFirstArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first VerificationToken that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenFindFirstOrThrowArgs} args - Arguments to find a VerificationToken
     * @example
     * // Get one VerificationToken
     * const verificationToken = await prisma.verificationToken.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends VerificationTokenFindFirstOrThrowArgs>(args?: SelectSubset<T, VerificationTokenFindFirstOrThrowArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more VerificationTokens that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all VerificationTokens
     * const verificationTokens = await prisma.verificationToken.findMany()
     * 
     * // Get first 10 VerificationTokens
     * const verificationTokens = await prisma.verificationToken.findMany({ take: 10 })
     * 
     * // Only select the `identifier`
     * const verificationTokenWithIdentifierOnly = await prisma.verificationToken.findMany({ select: { identifier: true } })
     * 
     */
    findMany<T extends VerificationTokenFindManyArgs>(args?: SelectSubset<T, VerificationTokenFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a VerificationToken.
     * @param {VerificationTokenCreateArgs} args - Arguments to create a VerificationToken.
     * @example
     * // Create one VerificationToken
     * const VerificationToken = await prisma.verificationToken.create({
     *   data: {
     *     // ... data to create a VerificationToken
     *   }
     * })
     * 
     */
    create<T extends VerificationTokenCreateArgs>(args: SelectSubset<T, VerificationTokenCreateArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many VerificationTokens.
     * @param {VerificationTokenCreateManyArgs} args - Arguments to create many VerificationTokens.
     * @example
     * // Create many VerificationTokens
     * const verificationToken = await prisma.verificationToken.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends VerificationTokenCreateManyArgs>(args?: SelectSubset<T, VerificationTokenCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a VerificationToken.
     * @param {VerificationTokenDeleteArgs} args - Arguments to delete one VerificationToken.
     * @example
     * // Delete one VerificationToken
     * const VerificationToken = await prisma.verificationToken.delete({
     *   where: {
     *     // ... filter to delete one VerificationToken
     *   }
     * })
     * 
     */
    delete<T extends VerificationTokenDeleteArgs>(args: SelectSubset<T, VerificationTokenDeleteArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one VerificationToken.
     * @param {VerificationTokenUpdateArgs} args - Arguments to update one VerificationToken.
     * @example
     * // Update one VerificationToken
     * const verificationToken = await prisma.verificationToken.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends VerificationTokenUpdateArgs>(args: SelectSubset<T, VerificationTokenUpdateArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more VerificationTokens.
     * @param {VerificationTokenDeleteManyArgs} args - Arguments to filter VerificationTokens to delete.
     * @example
     * // Delete a few VerificationTokens
     * const { count } = await prisma.verificationToken.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends VerificationTokenDeleteManyArgs>(args?: SelectSubset<T, VerificationTokenDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more VerificationTokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many VerificationTokens
     * const verificationToken = await prisma.verificationToken.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends VerificationTokenUpdateManyArgs>(args: SelectSubset<T, VerificationTokenUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one VerificationToken.
     * @param {VerificationTokenUpsertArgs} args - Arguments to update or create a VerificationToken.
     * @example
     * // Update or create a VerificationToken
     * const verificationToken = await prisma.verificationToken.upsert({
     *   create: {
     *     // ... data to create a VerificationToken
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the VerificationToken we want to update
     *   }
     * })
     */
    upsert<T extends VerificationTokenUpsertArgs>(args: SelectSubset<T, VerificationTokenUpsertArgs<ExtArgs>>): Prisma__VerificationTokenClient<$Result.GetResult<Prisma.$VerificationTokenPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of VerificationTokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenCountArgs} args - Arguments to filter VerificationTokens to count.
     * @example
     * // Count the number of VerificationTokens
     * const count = await prisma.verificationToken.count({
     *   where: {
     *     // ... the filter for the VerificationTokens we want to count
     *   }
     * })
    **/
    count<T extends VerificationTokenCountArgs>(
      args?: Subset<T, VerificationTokenCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], VerificationTokenCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a VerificationToken.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends VerificationTokenAggregateArgs>(args: Subset<T, VerificationTokenAggregateArgs>): Prisma.PrismaPromise<GetVerificationTokenAggregateType<T>>

    /**
     * Group by VerificationToken.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {VerificationTokenGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends VerificationTokenGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: VerificationTokenGroupByArgs['orderBy'] }
        : { orderBy?: VerificationTokenGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, VerificationTokenGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetVerificationTokenGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the VerificationToken model
   */
  readonly fields: VerificationTokenFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for VerificationToken.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__VerificationTokenClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the VerificationToken model
   */
  interface VerificationTokenFieldRefs {
    readonly identifier: FieldRef<"VerificationToken", 'String'>
    readonly token: FieldRef<"VerificationToken", 'String'>
    readonly expires: FieldRef<"VerificationToken", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * VerificationToken findUnique
   */
  export type VerificationTokenFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter, which VerificationToken to fetch.
     */
    where: VerificationTokenWhereUniqueInput
  }

  /**
   * VerificationToken findUniqueOrThrow
   */
  export type VerificationTokenFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter, which VerificationToken to fetch.
     */
    where: VerificationTokenWhereUniqueInput
  }

  /**
   * VerificationToken findFirst
   */
  export type VerificationTokenFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter, which VerificationToken to fetch.
     */
    where?: VerificationTokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of VerificationTokens to fetch.
     */
    orderBy?: VerificationTokenOrderByWithRelationInput | VerificationTokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for VerificationTokens.
     */
    cursor?: VerificationTokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` VerificationTokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` VerificationTokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of VerificationTokens.
     */
    distinct?: VerificationTokenScalarFieldEnum | VerificationTokenScalarFieldEnum[]
  }

  /**
   * VerificationToken findFirstOrThrow
   */
  export type VerificationTokenFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter, which VerificationToken to fetch.
     */
    where?: VerificationTokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of VerificationTokens to fetch.
     */
    orderBy?: VerificationTokenOrderByWithRelationInput | VerificationTokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for VerificationTokens.
     */
    cursor?: VerificationTokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` VerificationTokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` VerificationTokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of VerificationTokens.
     */
    distinct?: VerificationTokenScalarFieldEnum | VerificationTokenScalarFieldEnum[]
  }

  /**
   * VerificationToken findMany
   */
  export type VerificationTokenFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter, which VerificationTokens to fetch.
     */
    where?: VerificationTokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of VerificationTokens to fetch.
     */
    orderBy?: VerificationTokenOrderByWithRelationInput | VerificationTokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing VerificationTokens.
     */
    cursor?: VerificationTokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` VerificationTokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` VerificationTokens.
     */
    skip?: number
    distinct?: VerificationTokenScalarFieldEnum | VerificationTokenScalarFieldEnum[]
  }

  /**
   * VerificationToken create
   */
  export type VerificationTokenCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * The data needed to create a VerificationToken.
     */
    data: XOR<VerificationTokenCreateInput, VerificationTokenUncheckedCreateInput>
  }

  /**
   * VerificationToken createMany
   */
  export type VerificationTokenCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many VerificationTokens.
     */
    data: VerificationTokenCreateManyInput | VerificationTokenCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * VerificationToken update
   */
  export type VerificationTokenUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * The data needed to update a VerificationToken.
     */
    data: XOR<VerificationTokenUpdateInput, VerificationTokenUncheckedUpdateInput>
    /**
     * Choose, which VerificationToken to update.
     */
    where: VerificationTokenWhereUniqueInput
  }

  /**
   * VerificationToken updateMany
   */
  export type VerificationTokenUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update VerificationTokens.
     */
    data: XOR<VerificationTokenUpdateManyMutationInput, VerificationTokenUncheckedUpdateManyInput>
    /**
     * Filter which VerificationTokens to update
     */
    where?: VerificationTokenWhereInput
    /**
     * Limit how many VerificationTokens to update.
     */
    limit?: number
  }

  /**
   * VerificationToken upsert
   */
  export type VerificationTokenUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * The filter to search for the VerificationToken to update in case it exists.
     */
    where: VerificationTokenWhereUniqueInput
    /**
     * In case the VerificationToken found by the `where` argument doesn't exist, create a new VerificationToken with this data.
     */
    create: XOR<VerificationTokenCreateInput, VerificationTokenUncheckedCreateInput>
    /**
     * In case the VerificationToken was found with the provided `where` argument, update it with this data.
     */
    update: XOR<VerificationTokenUpdateInput, VerificationTokenUncheckedUpdateInput>
  }

  /**
   * VerificationToken delete
   */
  export type VerificationTokenDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
    /**
     * Filter which VerificationToken to delete.
     */
    where: VerificationTokenWhereUniqueInput
  }

  /**
   * VerificationToken deleteMany
   */
  export type VerificationTokenDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which VerificationTokens to delete
     */
    where?: VerificationTokenWhereInput
    /**
     * Limit how many VerificationTokens to delete.
     */
    limit?: number
  }

  /**
   * VerificationToken without action
   */
  export type VerificationTokenDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the VerificationToken
     */
    select?: VerificationTokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the VerificationToken
     */
    omit?: VerificationTokenOmit<ExtArgs> | null
  }


  /**
   * Model ComplianceData
   */

  export type AggregateComplianceData = {
    _count: ComplianceDataCountAggregateOutputType | null
    _avg: ComplianceDataAvgAggregateOutputType | null
    _sum: ComplianceDataSumAggregateOutputType | null
    _min: ComplianceDataMinAggregateOutputType | null
    _max: ComplianceDataMaxAggregateOutputType | null
  }

  export type ComplianceDataAvgAggregateOutputType = {
    id: number | null
    compliance: number | null
    required: number | null
    hospital_id: number | null
  }

  export type ComplianceDataSumAggregateOutputType = {
    id: number | null
    compliance: number | null
    required: number | null
    hospital_id: number | null
  }

  export type ComplianceDataMinAggregateOutputType = {
    id: number | null
    name: string | null
    compliance: number | null
    required: number | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ComplianceDataMaxAggregateOutputType = {
    id: number | null
    name: string | null
    compliance: number | null
    required: number | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ComplianceDataCountAggregateOutputType = {
    id: number
    name: number
    compliance: number
    required: number
    hospital_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ComplianceDataAvgAggregateInputType = {
    id?: true
    compliance?: true
    required?: true
    hospital_id?: true
  }

  export type ComplianceDataSumAggregateInputType = {
    id?: true
    compliance?: true
    required?: true
    hospital_id?: true
  }

  export type ComplianceDataMinAggregateInputType = {
    id?: true
    name?: true
    compliance?: true
    required?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type ComplianceDataMaxAggregateInputType = {
    id?: true
    name?: true
    compliance?: true
    required?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type ComplianceDataCountAggregateInputType = {
    id?: true
    name?: true
    compliance?: true
    required?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ComplianceDataAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ComplianceData to aggregate.
     */
    where?: ComplianceDataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceData to fetch.
     */
    orderBy?: ComplianceDataOrderByWithRelationInput | ComplianceDataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ComplianceDataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceData from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceData.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ComplianceData
    **/
    _count?: true | ComplianceDataCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ComplianceDataAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ComplianceDataSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ComplianceDataMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ComplianceDataMaxAggregateInputType
  }

  export type GetComplianceDataAggregateType<T extends ComplianceDataAggregateArgs> = {
        [P in keyof T & keyof AggregateComplianceData]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateComplianceData[P]>
      : GetScalarType<T[P], AggregateComplianceData[P]>
  }




  export type ComplianceDataGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ComplianceDataWhereInput
    orderBy?: ComplianceDataOrderByWithAggregationInput | ComplianceDataOrderByWithAggregationInput[]
    by: ComplianceDataScalarFieldEnum[] | ComplianceDataScalarFieldEnum
    having?: ComplianceDataScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ComplianceDataCountAggregateInputType | true
    _avg?: ComplianceDataAvgAggregateInputType
    _sum?: ComplianceDataSumAggregateInputType
    _min?: ComplianceDataMinAggregateInputType
    _max?: ComplianceDataMaxAggregateInputType
  }

  export type ComplianceDataGroupByOutputType = {
    id: number
    name: string
    compliance: number
    required: number
    hospital_id: number
    created_at: Date
    updated_at: Date
    _count: ComplianceDataCountAggregateOutputType | null
    _avg: ComplianceDataAvgAggregateOutputType | null
    _sum: ComplianceDataSumAggregateOutputType | null
    _min: ComplianceDataMinAggregateOutputType | null
    _max: ComplianceDataMaxAggregateOutputType | null
  }

  type GetComplianceDataGroupByPayload<T extends ComplianceDataGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ComplianceDataGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ComplianceDataGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ComplianceDataGroupByOutputType[P]>
            : GetScalarType<T[P], ComplianceDataGroupByOutputType[P]>
        }
      >
    >


  export type ComplianceDataSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    compliance?: boolean
    required?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["complianceData"]>



  export type ComplianceDataSelectScalar = {
    id?: boolean
    name?: boolean
    compliance?: boolean
    required?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ComplianceDataOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "compliance" | "required" | "hospital_id" | "created_at" | "updated_at", ExtArgs["result"]["complianceData"]>
  export type ComplianceDataInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $ComplianceDataPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ComplianceData"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      compliance: number
      required: number
      hospital_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["complianceData"]>
    composites: {}
  }

  type ComplianceDataGetPayload<S extends boolean | null | undefined | ComplianceDataDefaultArgs> = $Result.GetResult<Prisma.$ComplianceDataPayload, S>

  type ComplianceDataCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ComplianceDataFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ComplianceDataCountAggregateInputType | true
    }

  export interface ComplianceDataDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ComplianceData'], meta: { name: 'ComplianceData' } }
    /**
     * Find zero or one ComplianceData that matches the filter.
     * @param {ComplianceDataFindUniqueArgs} args - Arguments to find a ComplianceData
     * @example
     * // Get one ComplianceData
     * const complianceData = await prisma.complianceData.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ComplianceDataFindUniqueArgs>(args: SelectSubset<T, ComplianceDataFindUniqueArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one ComplianceData that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ComplianceDataFindUniqueOrThrowArgs} args - Arguments to find a ComplianceData
     * @example
     * // Get one ComplianceData
     * const complianceData = await prisma.complianceData.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ComplianceDataFindUniqueOrThrowArgs>(args: SelectSubset<T, ComplianceDataFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ComplianceData that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataFindFirstArgs} args - Arguments to find a ComplianceData
     * @example
     * // Get one ComplianceData
     * const complianceData = await prisma.complianceData.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ComplianceDataFindFirstArgs>(args?: SelectSubset<T, ComplianceDataFindFirstArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ComplianceData that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataFindFirstOrThrowArgs} args - Arguments to find a ComplianceData
     * @example
     * // Get one ComplianceData
     * const complianceData = await prisma.complianceData.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ComplianceDataFindFirstOrThrowArgs>(args?: SelectSubset<T, ComplianceDataFindFirstOrThrowArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more ComplianceData that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ComplianceData
     * const complianceData = await prisma.complianceData.findMany()
     * 
     * // Get first 10 ComplianceData
     * const complianceData = await prisma.complianceData.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const complianceDataWithIdOnly = await prisma.complianceData.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ComplianceDataFindManyArgs>(args?: SelectSubset<T, ComplianceDataFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a ComplianceData.
     * @param {ComplianceDataCreateArgs} args - Arguments to create a ComplianceData.
     * @example
     * // Create one ComplianceData
     * const ComplianceData = await prisma.complianceData.create({
     *   data: {
     *     // ... data to create a ComplianceData
     *   }
     * })
     * 
     */
    create<T extends ComplianceDataCreateArgs>(args: SelectSubset<T, ComplianceDataCreateArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many ComplianceData.
     * @param {ComplianceDataCreateManyArgs} args - Arguments to create many ComplianceData.
     * @example
     * // Create many ComplianceData
     * const complianceData = await prisma.complianceData.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ComplianceDataCreateManyArgs>(args?: SelectSubset<T, ComplianceDataCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ComplianceData.
     * @param {ComplianceDataDeleteArgs} args - Arguments to delete one ComplianceData.
     * @example
     * // Delete one ComplianceData
     * const ComplianceData = await prisma.complianceData.delete({
     *   where: {
     *     // ... filter to delete one ComplianceData
     *   }
     * })
     * 
     */
    delete<T extends ComplianceDataDeleteArgs>(args: SelectSubset<T, ComplianceDataDeleteArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one ComplianceData.
     * @param {ComplianceDataUpdateArgs} args - Arguments to update one ComplianceData.
     * @example
     * // Update one ComplianceData
     * const complianceData = await prisma.complianceData.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ComplianceDataUpdateArgs>(args: SelectSubset<T, ComplianceDataUpdateArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more ComplianceData.
     * @param {ComplianceDataDeleteManyArgs} args - Arguments to filter ComplianceData to delete.
     * @example
     * // Delete a few ComplianceData
     * const { count } = await prisma.complianceData.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ComplianceDataDeleteManyArgs>(args?: SelectSubset<T, ComplianceDataDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ComplianceData.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ComplianceData
     * const complianceData = await prisma.complianceData.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ComplianceDataUpdateManyArgs>(args: SelectSubset<T, ComplianceDataUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ComplianceData.
     * @param {ComplianceDataUpsertArgs} args - Arguments to update or create a ComplianceData.
     * @example
     * // Update or create a ComplianceData
     * const complianceData = await prisma.complianceData.upsert({
     *   create: {
     *     // ... data to create a ComplianceData
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ComplianceData we want to update
     *   }
     * })
     */
    upsert<T extends ComplianceDataUpsertArgs>(args: SelectSubset<T, ComplianceDataUpsertArgs<ExtArgs>>): Prisma__ComplianceDataClient<$Result.GetResult<Prisma.$ComplianceDataPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of ComplianceData.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataCountArgs} args - Arguments to filter ComplianceData to count.
     * @example
     * // Count the number of ComplianceData
     * const count = await prisma.complianceData.count({
     *   where: {
     *     // ... the filter for the ComplianceData we want to count
     *   }
     * })
    **/
    count<T extends ComplianceDataCountArgs>(
      args?: Subset<T, ComplianceDataCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ComplianceDataCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ComplianceData.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ComplianceDataAggregateArgs>(args: Subset<T, ComplianceDataAggregateArgs>): Prisma.PrismaPromise<GetComplianceDataAggregateType<T>>

    /**
     * Group by ComplianceData.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceDataGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ComplianceDataGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ComplianceDataGroupByArgs['orderBy'] }
        : { orderBy?: ComplianceDataGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ComplianceDataGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetComplianceDataGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ComplianceData model
   */
  readonly fields: ComplianceDataFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ComplianceData.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ComplianceDataClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ComplianceData model
   */
  interface ComplianceDataFieldRefs {
    readonly id: FieldRef<"ComplianceData", 'Int'>
    readonly name: FieldRef<"ComplianceData", 'String'>
    readonly compliance: FieldRef<"ComplianceData", 'Float'>
    readonly required: FieldRef<"ComplianceData", 'Float'>
    readonly hospital_id: FieldRef<"ComplianceData", 'Int'>
    readonly created_at: FieldRef<"ComplianceData", 'DateTime'>
    readonly updated_at: FieldRef<"ComplianceData", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ComplianceData findUnique
   */
  export type ComplianceDataFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceData to fetch.
     */
    where: ComplianceDataWhereUniqueInput
  }

  /**
   * ComplianceData findUniqueOrThrow
   */
  export type ComplianceDataFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceData to fetch.
     */
    where: ComplianceDataWhereUniqueInput
  }

  /**
   * ComplianceData findFirst
   */
  export type ComplianceDataFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceData to fetch.
     */
    where?: ComplianceDataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceData to fetch.
     */
    orderBy?: ComplianceDataOrderByWithRelationInput | ComplianceDataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ComplianceData.
     */
    cursor?: ComplianceDataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceData from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceData.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ComplianceData.
     */
    distinct?: ComplianceDataScalarFieldEnum | ComplianceDataScalarFieldEnum[]
  }

  /**
   * ComplianceData findFirstOrThrow
   */
  export type ComplianceDataFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceData to fetch.
     */
    where?: ComplianceDataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceData to fetch.
     */
    orderBy?: ComplianceDataOrderByWithRelationInput | ComplianceDataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ComplianceData.
     */
    cursor?: ComplianceDataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceData from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceData.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ComplianceData.
     */
    distinct?: ComplianceDataScalarFieldEnum | ComplianceDataScalarFieldEnum[]
  }

  /**
   * ComplianceData findMany
   */
  export type ComplianceDataFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceData to fetch.
     */
    where?: ComplianceDataWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceData to fetch.
     */
    orderBy?: ComplianceDataOrderByWithRelationInput | ComplianceDataOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ComplianceData.
     */
    cursor?: ComplianceDataWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceData from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceData.
     */
    skip?: number
    distinct?: ComplianceDataScalarFieldEnum | ComplianceDataScalarFieldEnum[]
  }

  /**
   * ComplianceData create
   */
  export type ComplianceDataCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * The data needed to create a ComplianceData.
     */
    data: XOR<ComplianceDataCreateInput, ComplianceDataUncheckedCreateInput>
  }

  /**
   * ComplianceData createMany
   */
  export type ComplianceDataCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ComplianceData.
     */
    data: ComplianceDataCreateManyInput | ComplianceDataCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ComplianceData update
   */
  export type ComplianceDataUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * The data needed to update a ComplianceData.
     */
    data: XOR<ComplianceDataUpdateInput, ComplianceDataUncheckedUpdateInput>
    /**
     * Choose, which ComplianceData to update.
     */
    where: ComplianceDataWhereUniqueInput
  }

  /**
   * ComplianceData updateMany
   */
  export type ComplianceDataUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ComplianceData.
     */
    data: XOR<ComplianceDataUpdateManyMutationInput, ComplianceDataUncheckedUpdateManyInput>
    /**
     * Filter which ComplianceData to update
     */
    where?: ComplianceDataWhereInput
    /**
     * Limit how many ComplianceData to update.
     */
    limit?: number
  }

  /**
   * ComplianceData upsert
   */
  export type ComplianceDataUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * The filter to search for the ComplianceData to update in case it exists.
     */
    where: ComplianceDataWhereUniqueInput
    /**
     * In case the ComplianceData found by the `where` argument doesn't exist, create a new ComplianceData with this data.
     */
    create: XOR<ComplianceDataCreateInput, ComplianceDataUncheckedCreateInput>
    /**
     * In case the ComplianceData was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ComplianceDataUpdateInput, ComplianceDataUncheckedUpdateInput>
  }

  /**
   * ComplianceData delete
   */
  export type ComplianceDataDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
    /**
     * Filter which ComplianceData to delete.
     */
    where: ComplianceDataWhereUniqueInput
  }

  /**
   * ComplianceData deleteMany
   */
  export type ComplianceDataDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ComplianceData to delete
     */
    where?: ComplianceDataWhereInput
    /**
     * Limit how many ComplianceData to delete.
     */
    limit?: number
  }

  /**
   * ComplianceData without action
   */
  export type ComplianceDataDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceData
     */
    select?: ComplianceDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceData
     */
    omit?: ComplianceDataOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceDataInclude<ExtArgs> | null
  }


  /**
   * Model StandardCompliance
   */

  export type AggregateStandardCompliance = {
    _count: StandardComplianceCountAggregateOutputType | null
    _avg: StandardComplianceAvgAggregateOutputType | null
    _sum: StandardComplianceSumAggregateOutputType | null
    _min: StandardComplianceMinAggregateOutputType | null
    _max: StandardComplianceMaxAggregateOutputType | null
  }

  export type StandardComplianceAvgAggregateOutputType = {
    id: number | null
    compliance: number | null
    hospital_id: number | null
    required_threshold: number | null
  }

  export type StandardComplianceSumAggregateOutputType = {
    id: number | null
    compliance: number | null
    hospital_id: number | null
    required_threshold: number | null
  }

  export type StandardComplianceMinAggregateOutputType = {
    id: number | null
    standard: string | null
    category: string | null
    compliance: number | null
    last_assessed: Date | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
    required_threshold: number | null
  }

  export type StandardComplianceMaxAggregateOutputType = {
    id: number | null
    standard: string | null
    category: string | null
    compliance: number | null
    last_assessed: Date | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
    required_threshold: number | null
  }

  export type StandardComplianceCountAggregateOutputType = {
    id: number
    standard: number
    category: number
    compliance: number
    last_assessed: number
    hospital_id: number
    created_at: number
    updated_at: number
    required_threshold: number
    _all: number
  }


  export type StandardComplianceAvgAggregateInputType = {
    id?: true
    compliance?: true
    hospital_id?: true
    required_threshold?: true
  }

  export type StandardComplianceSumAggregateInputType = {
    id?: true
    compliance?: true
    hospital_id?: true
    required_threshold?: true
  }

  export type StandardComplianceMinAggregateInputType = {
    id?: true
    standard?: true
    category?: true
    compliance?: true
    last_assessed?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    required_threshold?: true
  }

  export type StandardComplianceMaxAggregateInputType = {
    id?: true
    standard?: true
    category?: true
    compliance?: true
    last_assessed?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    required_threshold?: true
  }

  export type StandardComplianceCountAggregateInputType = {
    id?: true
    standard?: true
    category?: true
    compliance?: true
    last_assessed?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    required_threshold?: true
    _all?: true
  }

  export type StandardComplianceAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which StandardCompliance to aggregate.
     */
    where?: StandardComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StandardCompliances to fetch.
     */
    orderBy?: StandardComplianceOrderByWithRelationInput | StandardComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: StandardComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StandardCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StandardCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned StandardCompliances
    **/
    _count?: true | StandardComplianceCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: StandardComplianceAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: StandardComplianceSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: StandardComplianceMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: StandardComplianceMaxAggregateInputType
  }

  export type GetStandardComplianceAggregateType<T extends StandardComplianceAggregateArgs> = {
        [P in keyof T & keyof AggregateStandardCompliance]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateStandardCompliance[P]>
      : GetScalarType<T[P], AggregateStandardCompliance[P]>
  }




  export type StandardComplianceGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StandardComplianceWhereInput
    orderBy?: StandardComplianceOrderByWithAggregationInput | StandardComplianceOrderByWithAggregationInput[]
    by: StandardComplianceScalarFieldEnum[] | StandardComplianceScalarFieldEnum
    having?: StandardComplianceScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: StandardComplianceCountAggregateInputType | true
    _avg?: StandardComplianceAvgAggregateInputType
    _sum?: StandardComplianceSumAggregateInputType
    _min?: StandardComplianceMinAggregateInputType
    _max?: StandardComplianceMaxAggregateInputType
  }

  export type StandardComplianceGroupByOutputType = {
    id: number
    standard: string
    category: string
    compliance: number
    last_assessed: Date
    hospital_id: number
    created_at: Date
    updated_at: Date
    required_threshold: number
    _count: StandardComplianceCountAggregateOutputType | null
    _avg: StandardComplianceAvgAggregateOutputType | null
    _sum: StandardComplianceSumAggregateOutputType | null
    _min: StandardComplianceMinAggregateOutputType | null
    _max: StandardComplianceMaxAggregateOutputType | null
  }

  type GetStandardComplianceGroupByPayload<T extends StandardComplianceGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<StandardComplianceGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof StandardComplianceGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], StandardComplianceGroupByOutputType[P]>
            : GetScalarType<T[P], StandardComplianceGroupByOutputType[P]>
        }
      >
    >


  export type StandardComplianceSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    standard?: boolean
    category?: boolean
    compliance?: boolean
    last_assessed?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    required_threshold?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["standardCompliance"]>



  export type StandardComplianceSelectScalar = {
    id?: boolean
    standard?: boolean
    category?: boolean
    compliance?: boolean
    last_assessed?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    required_threshold?: boolean
  }

  export type StandardComplianceOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "standard" | "category" | "compliance" | "last_assessed" | "hospital_id" | "created_at" | "updated_at" | "required_threshold", ExtArgs["result"]["standardCompliance"]>
  export type StandardComplianceInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $StandardCompliancePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "StandardCompliance"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      standard: string
      category: string
      compliance: number
      last_assessed: Date
      hospital_id: number
      created_at: Date
      updated_at: Date
      required_threshold: number
    }, ExtArgs["result"]["standardCompliance"]>
    composites: {}
  }

  type StandardComplianceGetPayload<S extends boolean | null | undefined | StandardComplianceDefaultArgs> = $Result.GetResult<Prisma.$StandardCompliancePayload, S>

  type StandardComplianceCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<StandardComplianceFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: StandardComplianceCountAggregateInputType | true
    }

  export interface StandardComplianceDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['StandardCompliance'], meta: { name: 'StandardCompliance' } }
    /**
     * Find zero or one StandardCompliance that matches the filter.
     * @param {StandardComplianceFindUniqueArgs} args - Arguments to find a StandardCompliance
     * @example
     * // Get one StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends StandardComplianceFindUniqueArgs>(args: SelectSubset<T, StandardComplianceFindUniqueArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one StandardCompliance that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {StandardComplianceFindUniqueOrThrowArgs} args - Arguments to find a StandardCompliance
     * @example
     * // Get one StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends StandardComplianceFindUniqueOrThrowArgs>(args: SelectSubset<T, StandardComplianceFindUniqueOrThrowArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first StandardCompliance that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceFindFirstArgs} args - Arguments to find a StandardCompliance
     * @example
     * // Get one StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends StandardComplianceFindFirstArgs>(args?: SelectSubset<T, StandardComplianceFindFirstArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first StandardCompliance that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceFindFirstOrThrowArgs} args - Arguments to find a StandardCompliance
     * @example
     * // Get one StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends StandardComplianceFindFirstOrThrowArgs>(args?: SelectSubset<T, StandardComplianceFindFirstOrThrowArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more StandardCompliances that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all StandardCompliances
     * const standardCompliances = await prisma.standardCompliance.findMany()
     * 
     * // Get first 10 StandardCompliances
     * const standardCompliances = await prisma.standardCompliance.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const standardComplianceWithIdOnly = await prisma.standardCompliance.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends StandardComplianceFindManyArgs>(args?: SelectSubset<T, StandardComplianceFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a StandardCompliance.
     * @param {StandardComplianceCreateArgs} args - Arguments to create a StandardCompliance.
     * @example
     * // Create one StandardCompliance
     * const StandardCompliance = await prisma.standardCompliance.create({
     *   data: {
     *     // ... data to create a StandardCompliance
     *   }
     * })
     * 
     */
    create<T extends StandardComplianceCreateArgs>(args: SelectSubset<T, StandardComplianceCreateArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many StandardCompliances.
     * @param {StandardComplianceCreateManyArgs} args - Arguments to create many StandardCompliances.
     * @example
     * // Create many StandardCompliances
     * const standardCompliance = await prisma.standardCompliance.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends StandardComplianceCreateManyArgs>(args?: SelectSubset<T, StandardComplianceCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a StandardCompliance.
     * @param {StandardComplianceDeleteArgs} args - Arguments to delete one StandardCompliance.
     * @example
     * // Delete one StandardCompliance
     * const StandardCompliance = await prisma.standardCompliance.delete({
     *   where: {
     *     // ... filter to delete one StandardCompliance
     *   }
     * })
     * 
     */
    delete<T extends StandardComplianceDeleteArgs>(args: SelectSubset<T, StandardComplianceDeleteArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one StandardCompliance.
     * @param {StandardComplianceUpdateArgs} args - Arguments to update one StandardCompliance.
     * @example
     * // Update one StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends StandardComplianceUpdateArgs>(args: SelectSubset<T, StandardComplianceUpdateArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more StandardCompliances.
     * @param {StandardComplianceDeleteManyArgs} args - Arguments to filter StandardCompliances to delete.
     * @example
     * // Delete a few StandardCompliances
     * const { count } = await prisma.standardCompliance.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends StandardComplianceDeleteManyArgs>(args?: SelectSubset<T, StandardComplianceDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more StandardCompliances.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many StandardCompliances
     * const standardCompliance = await prisma.standardCompliance.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends StandardComplianceUpdateManyArgs>(args: SelectSubset<T, StandardComplianceUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one StandardCompliance.
     * @param {StandardComplianceUpsertArgs} args - Arguments to update or create a StandardCompliance.
     * @example
     * // Update or create a StandardCompliance
     * const standardCompliance = await prisma.standardCompliance.upsert({
     *   create: {
     *     // ... data to create a StandardCompliance
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the StandardCompliance we want to update
     *   }
     * })
     */
    upsert<T extends StandardComplianceUpsertArgs>(args: SelectSubset<T, StandardComplianceUpsertArgs<ExtArgs>>): Prisma__StandardComplianceClient<$Result.GetResult<Prisma.$StandardCompliancePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of StandardCompliances.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceCountArgs} args - Arguments to filter StandardCompliances to count.
     * @example
     * // Count the number of StandardCompliances
     * const count = await prisma.standardCompliance.count({
     *   where: {
     *     // ... the filter for the StandardCompliances we want to count
     *   }
     * })
    **/
    count<T extends StandardComplianceCountArgs>(
      args?: Subset<T, StandardComplianceCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], StandardComplianceCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a StandardCompliance.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends StandardComplianceAggregateArgs>(args: Subset<T, StandardComplianceAggregateArgs>): Prisma.PrismaPromise<GetStandardComplianceAggregateType<T>>

    /**
     * Group by StandardCompliance.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StandardComplianceGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends StandardComplianceGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: StandardComplianceGroupByArgs['orderBy'] }
        : { orderBy?: StandardComplianceGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, StandardComplianceGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetStandardComplianceGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the StandardCompliance model
   */
  readonly fields: StandardComplianceFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for StandardCompliance.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__StandardComplianceClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the StandardCompliance model
   */
  interface StandardComplianceFieldRefs {
    readonly id: FieldRef<"StandardCompliance", 'Int'>
    readonly standard: FieldRef<"StandardCompliance", 'String'>
    readonly category: FieldRef<"StandardCompliance", 'String'>
    readonly compliance: FieldRef<"StandardCompliance", 'Float'>
    readonly last_assessed: FieldRef<"StandardCompliance", 'DateTime'>
    readonly hospital_id: FieldRef<"StandardCompliance", 'Int'>
    readonly created_at: FieldRef<"StandardCompliance", 'DateTime'>
    readonly updated_at: FieldRef<"StandardCompliance", 'DateTime'>
    readonly required_threshold: FieldRef<"StandardCompliance", 'Float'>
  }
    

  // Custom InputTypes
  /**
   * StandardCompliance findUnique
   */
  export type StandardComplianceFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StandardCompliance to fetch.
     */
    where: StandardComplianceWhereUniqueInput
  }

  /**
   * StandardCompliance findUniqueOrThrow
   */
  export type StandardComplianceFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StandardCompliance to fetch.
     */
    where: StandardComplianceWhereUniqueInput
  }

  /**
   * StandardCompliance findFirst
   */
  export type StandardComplianceFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StandardCompliance to fetch.
     */
    where?: StandardComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StandardCompliances to fetch.
     */
    orderBy?: StandardComplianceOrderByWithRelationInput | StandardComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for StandardCompliances.
     */
    cursor?: StandardComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StandardCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StandardCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of StandardCompliances.
     */
    distinct?: StandardComplianceScalarFieldEnum | StandardComplianceScalarFieldEnum[]
  }

  /**
   * StandardCompliance findFirstOrThrow
   */
  export type StandardComplianceFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StandardCompliance to fetch.
     */
    where?: StandardComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StandardCompliances to fetch.
     */
    orderBy?: StandardComplianceOrderByWithRelationInput | StandardComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for StandardCompliances.
     */
    cursor?: StandardComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StandardCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StandardCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of StandardCompliances.
     */
    distinct?: StandardComplianceScalarFieldEnum | StandardComplianceScalarFieldEnum[]
  }

  /**
   * StandardCompliance findMany
   */
  export type StandardComplianceFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StandardCompliances to fetch.
     */
    where?: StandardComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StandardCompliances to fetch.
     */
    orderBy?: StandardComplianceOrderByWithRelationInput | StandardComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing StandardCompliances.
     */
    cursor?: StandardComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StandardCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StandardCompliances.
     */
    skip?: number
    distinct?: StandardComplianceScalarFieldEnum | StandardComplianceScalarFieldEnum[]
  }

  /**
   * StandardCompliance create
   */
  export type StandardComplianceCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * The data needed to create a StandardCompliance.
     */
    data: XOR<StandardComplianceCreateInput, StandardComplianceUncheckedCreateInput>
  }

  /**
   * StandardCompliance createMany
   */
  export type StandardComplianceCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many StandardCompliances.
     */
    data: StandardComplianceCreateManyInput | StandardComplianceCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * StandardCompliance update
   */
  export type StandardComplianceUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * The data needed to update a StandardCompliance.
     */
    data: XOR<StandardComplianceUpdateInput, StandardComplianceUncheckedUpdateInput>
    /**
     * Choose, which StandardCompliance to update.
     */
    where: StandardComplianceWhereUniqueInput
  }

  /**
   * StandardCompliance updateMany
   */
  export type StandardComplianceUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update StandardCompliances.
     */
    data: XOR<StandardComplianceUpdateManyMutationInput, StandardComplianceUncheckedUpdateManyInput>
    /**
     * Filter which StandardCompliances to update
     */
    where?: StandardComplianceWhereInput
    /**
     * Limit how many StandardCompliances to update.
     */
    limit?: number
  }

  /**
   * StandardCompliance upsert
   */
  export type StandardComplianceUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * The filter to search for the StandardCompliance to update in case it exists.
     */
    where: StandardComplianceWhereUniqueInput
    /**
     * In case the StandardCompliance found by the `where` argument doesn't exist, create a new StandardCompliance with this data.
     */
    create: XOR<StandardComplianceCreateInput, StandardComplianceUncheckedCreateInput>
    /**
     * In case the StandardCompliance was found with the provided `where` argument, update it with this data.
     */
    update: XOR<StandardComplianceUpdateInput, StandardComplianceUncheckedUpdateInput>
  }

  /**
   * StandardCompliance delete
   */
  export type StandardComplianceDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
    /**
     * Filter which StandardCompliance to delete.
     */
    where: StandardComplianceWhereUniqueInput
  }

  /**
   * StandardCompliance deleteMany
   */
  export type StandardComplianceDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which StandardCompliances to delete
     */
    where?: StandardComplianceWhereInput
    /**
     * Limit how many StandardCompliances to delete.
     */
    limit?: number
  }

  /**
   * StandardCompliance without action
   */
  export type StandardComplianceDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StandardCompliance
     */
    select?: StandardComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StandardCompliance
     */
    omit?: StandardComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StandardComplianceInclude<ExtArgs> | null
  }


  /**
   * Model ComplianceReport
   */

  export type AggregateComplianceReport = {
    _count: ComplianceReportCountAggregateOutputType | null
    _avg: ComplianceReportAvgAggregateOutputType | null
    _sum: ComplianceReportSumAggregateOutputType | null
    _min: ComplianceReportMinAggregateOutputType | null
    _max: ComplianceReportMaxAggregateOutputType | null
  }

  export type ComplianceReportAvgAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type ComplianceReportSumAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type ComplianceReportMinAggregateOutputType = {
    id: number | null
    title: string | null
    type: string | null
    file_url: string | null
    hospital_id: number | null
    created_at: Date | null
  }

  export type ComplianceReportMaxAggregateOutputType = {
    id: number | null
    title: string | null
    type: string | null
    file_url: string | null
    hospital_id: number | null
    created_at: Date | null
  }

  export type ComplianceReportCountAggregateOutputType = {
    id: number
    title: number
    type: number
    file_url: number
    hospital_id: number
    created_at: number
    _all: number
  }


  export type ComplianceReportAvgAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type ComplianceReportSumAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type ComplianceReportMinAggregateInputType = {
    id?: true
    title?: true
    type?: true
    file_url?: true
    hospital_id?: true
    created_at?: true
  }

  export type ComplianceReportMaxAggregateInputType = {
    id?: true
    title?: true
    type?: true
    file_url?: true
    hospital_id?: true
    created_at?: true
  }

  export type ComplianceReportCountAggregateInputType = {
    id?: true
    title?: true
    type?: true
    file_url?: true
    hospital_id?: true
    created_at?: true
    _all?: true
  }

  export type ComplianceReportAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ComplianceReport to aggregate.
     */
    where?: ComplianceReportWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceReports to fetch.
     */
    orderBy?: ComplianceReportOrderByWithRelationInput | ComplianceReportOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ComplianceReportWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceReports from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceReports.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ComplianceReports
    **/
    _count?: true | ComplianceReportCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ComplianceReportAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ComplianceReportSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ComplianceReportMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ComplianceReportMaxAggregateInputType
  }

  export type GetComplianceReportAggregateType<T extends ComplianceReportAggregateArgs> = {
        [P in keyof T & keyof AggregateComplianceReport]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateComplianceReport[P]>
      : GetScalarType<T[P], AggregateComplianceReport[P]>
  }




  export type ComplianceReportGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ComplianceReportWhereInput
    orderBy?: ComplianceReportOrderByWithAggregationInput | ComplianceReportOrderByWithAggregationInput[]
    by: ComplianceReportScalarFieldEnum[] | ComplianceReportScalarFieldEnum
    having?: ComplianceReportScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ComplianceReportCountAggregateInputType | true
    _avg?: ComplianceReportAvgAggregateInputType
    _sum?: ComplianceReportSumAggregateInputType
    _min?: ComplianceReportMinAggregateInputType
    _max?: ComplianceReportMaxAggregateInputType
  }

  export type ComplianceReportGroupByOutputType = {
    id: number
    title: string
    type: string
    file_url: string | null
    hospital_id: number
    created_at: Date
    _count: ComplianceReportCountAggregateOutputType | null
    _avg: ComplianceReportAvgAggregateOutputType | null
    _sum: ComplianceReportSumAggregateOutputType | null
    _min: ComplianceReportMinAggregateOutputType | null
    _max: ComplianceReportMaxAggregateOutputType | null
  }

  type GetComplianceReportGroupByPayload<T extends ComplianceReportGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ComplianceReportGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ComplianceReportGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ComplianceReportGroupByOutputType[P]>
            : GetScalarType<T[P], ComplianceReportGroupByOutputType[P]>
        }
      >
    >


  export type ComplianceReportSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    type?: boolean
    file_url?: boolean
    hospital_id?: boolean
    created_at?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["complianceReport"]>



  export type ComplianceReportSelectScalar = {
    id?: boolean
    title?: boolean
    type?: boolean
    file_url?: boolean
    hospital_id?: boolean
    created_at?: boolean
  }

  export type ComplianceReportOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "type" | "file_url" | "hospital_id" | "created_at", ExtArgs["result"]["complianceReport"]>
  export type ComplianceReportInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $ComplianceReportPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ComplianceReport"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      title: string
      type: string
      file_url: string | null
      hospital_id: number
      created_at: Date
    }, ExtArgs["result"]["complianceReport"]>
    composites: {}
  }

  type ComplianceReportGetPayload<S extends boolean | null | undefined | ComplianceReportDefaultArgs> = $Result.GetResult<Prisma.$ComplianceReportPayload, S>

  type ComplianceReportCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ComplianceReportFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ComplianceReportCountAggregateInputType | true
    }

  export interface ComplianceReportDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ComplianceReport'], meta: { name: 'ComplianceReport' } }
    /**
     * Find zero or one ComplianceReport that matches the filter.
     * @param {ComplianceReportFindUniqueArgs} args - Arguments to find a ComplianceReport
     * @example
     * // Get one ComplianceReport
     * const complianceReport = await prisma.complianceReport.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ComplianceReportFindUniqueArgs>(args: SelectSubset<T, ComplianceReportFindUniqueArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one ComplianceReport that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ComplianceReportFindUniqueOrThrowArgs} args - Arguments to find a ComplianceReport
     * @example
     * // Get one ComplianceReport
     * const complianceReport = await prisma.complianceReport.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ComplianceReportFindUniqueOrThrowArgs>(args: SelectSubset<T, ComplianceReportFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ComplianceReport that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportFindFirstArgs} args - Arguments to find a ComplianceReport
     * @example
     * // Get one ComplianceReport
     * const complianceReport = await prisma.complianceReport.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ComplianceReportFindFirstArgs>(args?: SelectSubset<T, ComplianceReportFindFirstArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ComplianceReport that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportFindFirstOrThrowArgs} args - Arguments to find a ComplianceReport
     * @example
     * // Get one ComplianceReport
     * const complianceReport = await prisma.complianceReport.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ComplianceReportFindFirstOrThrowArgs>(args?: SelectSubset<T, ComplianceReportFindFirstOrThrowArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more ComplianceReports that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ComplianceReports
     * const complianceReports = await prisma.complianceReport.findMany()
     * 
     * // Get first 10 ComplianceReports
     * const complianceReports = await prisma.complianceReport.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const complianceReportWithIdOnly = await prisma.complianceReport.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ComplianceReportFindManyArgs>(args?: SelectSubset<T, ComplianceReportFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a ComplianceReport.
     * @param {ComplianceReportCreateArgs} args - Arguments to create a ComplianceReport.
     * @example
     * // Create one ComplianceReport
     * const ComplianceReport = await prisma.complianceReport.create({
     *   data: {
     *     // ... data to create a ComplianceReport
     *   }
     * })
     * 
     */
    create<T extends ComplianceReportCreateArgs>(args: SelectSubset<T, ComplianceReportCreateArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many ComplianceReports.
     * @param {ComplianceReportCreateManyArgs} args - Arguments to create many ComplianceReports.
     * @example
     * // Create many ComplianceReports
     * const complianceReport = await prisma.complianceReport.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ComplianceReportCreateManyArgs>(args?: SelectSubset<T, ComplianceReportCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ComplianceReport.
     * @param {ComplianceReportDeleteArgs} args - Arguments to delete one ComplianceReport.
     * @example
     * // Delete one ComplianceReport
     * const ComplianceReport = await prisma.complianceReport.delete({
     *   where: {
     *     // ... filter to delete one ComplianceReport
     *   }
     * })
     * 
     */
    delete<T extends ComplianceReportDeleteArgs>(args: SelectSubset<T, ComplianceReportDeleteArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one ComplianceReport.
     * @param {ComplianceReportUpdateArgs} args - Arguments to update one ComplianceReport.
     * @example
     * // Update one ComplianceReport
     * const complianceReport = await prisma.complianceReport.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ComplianceReportUpdateArgs>(args: SelectSubset<T, ComplianceReportUpdateArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more ComplianceReports.
     * @param {ComplianceReportDeleteManyArgs} args - Arguments to filter ComplianceReports to delete.
     * @example
     * // Delete a few ComplianceReports
     * const { count } = await prisma.complianceReport.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ComplianceReportDeleteManyArgs>(args?: SelectSubset<T, ComplianceReportDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ComplianceReports.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ComplianceReports
     * const complianceReport = await prisma.complianceReport.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ComplianceReportUpdateManyArgs>(args: SelectSubset<T, ComplianceReportUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ComplianceReport.
     * @param {ComplianceReportUpsertArgs} args - Arguments to update or create a ComplianceReport.
     * @example
     * // Update or create a ComplianceReport
     * const complianceReport = await prisma.complianceReport.upsert({
     *   create: {
     *     // ... data to create a ComplianceReport
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ComplianceReport we want to update
     *   }
     * })
     */
    upsert<T extends ComplianceReportUpsertArgs>(args: SelectSubset<T, ComplianceReportUpsertArgs<ExtArgs>>): Prisma__ComplianceReportClient<$Result.GetResult<Prisma.$ComplianceReportPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of ComplianceReports.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportCountArgs} args - Arguments to filter ComplianceReports to count.
     * @example
     * // Count the number of ComplianceReports
     * const count = await prisma.complianceReport.count({
     *   where: {
     *     // ... the filter for the ComplianceReports we want to count
     *   }
     * })
    **/
    count<T extends ComplianceReportCountArgs>(
      args?: Subset<T, ComplianceReportCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ComplianceReportCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ComplianceReport.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ComplianceReportAggregateArgs>(args: Subset<T, ComplianceReportAggregateArgs>): Prisma.PrismaPromise<GetComplianceReportAggregateType<T>>

    /**
     * Group by ComplianceReport.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ComplianceReportGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ComplianceReportGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ComplianceReportGroupByArgs['orderBy'] }
        : { orderBy?: ComplianceReportGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ComplianceReportGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetComplianceReportGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ComplianceReport model
   */
  readonly fields: ComplianceReportFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ComplianceReport.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ComplianceReportClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ComplianceReport model
   */
  interface ComplianceReportFieldRefs {
    readonly id: FieldRef<"ComplianceReport", 'Int'>
    readonly title: FieldRef<"ComplianceReport", 'String'>
    readonly type: FieldRef<"ComplianceReport", 'String'>
    readonly file_url: FieldRef<"ComplianceReport", 'String'>
    readonly hospital_id: FieldRef<"ComplianceReport", 'Int'>
    readonly created_at: FieldRef<"ComplianceReport", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ComplianceReport findUnique
   */
  export type ComplianceReportFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceReport to fetch.
     */
    where: ComplianceReportWhereUniqueInput
  }

  /**
   * ComplianceReport findUniqueOrThrow
   */
  export type ComplianceReportFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceReport to fetch.
     */
    where: ComplianceReportWhereUniqueInput
  }

  /**
   * ComplianceReport findFirst
   */
  export type ComplianceReportFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceReport to fetch.
     */
    where?: ComplianceReportWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceReports to fetch.
     */
    orderBy?: ComplianceReportOrderByWithRelationInput | ComplianceReportOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ComplianceReports.
     */
    cursor?: ComplianceReportWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceReports from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceReports.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ComplianceReports.
     */
    distinct?: ComplianceReportScalarFieldEnum | ComplianceReportScalarFieldEnum[]
  }

  /**
   * ComplianceReport findFirstOrThrow
   */
  export type ComplianceReportFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceReport to fetch.
     */
    where?: ComplianceReportWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceReports to fetch.
     */
    orderBy?: ComplianceReportOrderByWithRelationInput | ComplianceReportOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ComplianceReports.
     */
    cursor?: ComplianceReportWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceReports from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceReports.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ComplianceReports.
     */
    distinct?: ComplianceReportScalarFieldEnum | ComplianceReportScalarFieldEnum[]
  }

  /**
   * ComplianceReport findMany
   */
  export type ComplianceReportFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter, which ComplianceReports to fetch.
     */
    where?: ComplianceReportWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ComplianceReports to fetch.
     */
    orderBy?: ComplianceReportOrderByWithRelationInput | ComplianceReportOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ComplianceReports.
     */
    cursor?: ComplianceReportWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ComplianceReports from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ComplianceReports.
     */
    skip?: number
    distinct?: ComplianceReportScalarFieldEnum | ComplianceReportScalarFieldEnum[]
  }

  /**
   * ComplianceReport create
   */
  export type ComplianceReportCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * The data needed to create a ComplianceReport.
     */
    data: XOR<ComplianceReportCreateInput, ComplianceReportUncheckedCreateInput>
  }

  /**
   * ComplianceReport createMany
   */
  export type ComplianceReportCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ComplianceReports.
     */
    data: ComplianceReportCreateManyInput | ComplianceReportCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ComplianceReport update
   */
  export type ComplianceReportUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * The data needed to update a ComplianceReport.
     */
    data: XOR<ComplianceReportUpdateInput, ComplianceReportUncheckedUpdateInput>
    /**
     * Choose, which ComplianceReport to update.
     */
    where: ComplianceReportWhereUniqueInput
  }

  /**
   * ComplianceReport updateMany
   */
  export type ComplianceReportUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ComplianceReports.
     */
    data: XOR<ComplianceReportUpdateManyMutationInput, ComplianceReportUncheckedUpdateManyInput>
    /**
     * Filter which ComplianceReports to update
     */
    where?: ComplianceReportWhereInput
    /**
     * Limit how many ComplianceReports to update.
     */
    limit?: number
  }

  /**
   * ComplianceReport upsert
   */
  export type ComplianceReportUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * The filter to search for the ComplianceReport to update in case it exists.
     */
    where: ComplianceReportWhereUniqueInput
    /**
     * In case the ComplianceReport found by the `where` argument doesn't exist, create a new ComplianceReport with this data.
     */
    create: XOR<ComplianceReportCreateInput, ComplianceReportUncheckedCreateInput>
    /**
     * In case the ComplianceReport was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ComplianceReportUpdateInput, ComplianceReportUncheckedUpdateInput>
  }

  /**
   * ComplianceReport delete
   */
  export type ComplianceReportDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
    /**
     * Filter which ComplianceReport to delete.
     */
    where: ComplianceReportWhereUniqueInput
  }

  /**
   * ComplianceReport deleteMany
   */
  export type ComplianceReportDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ComplianceReports to delete
     */
    where?: ComplianceReportWhereInput
    /**
     * Limit how many ComplianceReports to delete.
     */
    limit?: number
  }

  /**
   * ComplianceReport without action
   */
  export type ComplianceReportDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ComplianceReport
     */
    select?: ComplianceReportSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ComplianceReport
     */
    omit?: ComplianceReportOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ComplianceReportInclude<ExtArgs> | null
  }


  /**
   * Model CompliancePolicy
   */

  export type AggregateCompliancePolicy = {
    _count: CompliancePolicyCountAggregateOutputType | null
    _avg: CompliancePolicyAvgAggregateOutputType | null
    _sum: CompliancePolicySumAggregateOutputType | null
    _min: CompliancePolicyMinAggregateOutputType | null
    _max: CompliancePolicyMaxAggregateOutputType | null
  }

  export type CompliancePolicyAvgAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type CompliancePolicySumAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type CompliancePolicyMinAggregateOutputType = {
    id: number | null
    name: string | null
    category: string | null
    status: string | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type CompliancePolicyMaxAggregateOutputType = {
    id: number | null
    name: string | null
    category: string | null
    status: string | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type CompliancePolicyCountAggregateOutputType = {
    id: number
    name: number
    category: number
    status: number
    hospital_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type CompliancePolicyAvgAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type CompliancePolicySumAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type CompliancePolicyMinAggregateInputType = {
    id?: true
    name?: true
    category?: true
    status?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type CompliancePolicyMaxAggregateInputType = {
    id?: true
    name?: true
    category?: true
    status?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type CompliancePolicyCountAggregateInputType = {
    id?: true
    name?: true
    category?: true
    status?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type CompliancePolicyAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CompliancePolicy to aggregate.
     */
    where?: CompliancePolicyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CompliancePolicies to fetch.
     */
    orderBy?: CompliancePolicyOrderByWithRelationInput | CompliancePolicyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CompliancePolicyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CompliancePolicies from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CompliancePolicies.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned CompliancePolicies
    **/
    _count?: true | CompliancePolicyCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CompliancePolicyAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CompliancePolicySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CompliancePolicyMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CompliancePolicyMaxAggregateInputType
  }

  export type GetCompliancePolicyAggregateType<T extends CompliancePolicyAggregateArgs> = {
        [P in keyof T & keyof AggregateCompliancePolicy]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCompliancePolicy[P]>
      : GetScalarType<T[P], AggregateCompliancePolicy[P]>
  }




  export type CompliancePolicyGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CompliancePolicyWhereInput
    orderBy?: CompliancePolicyOrderByWithAggregationInput | CompliancePolicyOrderByWithAggregationInput[]
    by: CompliancePolicyScalarFieldEnum[] | CompliancePolicyScalarFieldEnum
    having?: CompliancePolicyScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CompliancePolicyCountAggregateInputType | true
    _avg?: CompliancePolicyAvgAggregateInputType
    _sum?: CompliancePolicySumAggregateInputType
    _min?: CompliancePolicyMinAggregateInputType
    _max?: CompliancePolicyMaxAggregateInputType
  }

  export type CompliancePolicyGroupByOutputType = {
    id: number
    name: string
    category: string
    status: string
    hospital_id: number
    created_at: Date
    updated_at: Date
    _count: CompliancePolicyCountAggregateOutputType | null
    _avg: CompliancePolicyAvgAggregateOutputType | null
    _sum: CompliancePolicySumAggregateOutputType | null
    _min: CompliancePolicyMinAggregateOutputType | null
    _max: CompliancePolicyMaxAggregateOutputType | null
  }

  type GetCompliancePolicyGroupByPayload<T extends CompliancePolicyGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CompliancePolicyGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CompliancePolicyGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CompliancePolicyGroupByOutputType[P]>
            : GetScalarType<T[P], CompliancePolicyGroupByOutputType[P]>
        }
      >
    >


  export type CompliancePolicySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    category?: boolean
    status?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["compliancePolicy"]>



  export type CompliancePolicySelectScalar = {
    id?: boolean
    name?: boolean
    category?: boolean
    status?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type CompliancePolicyOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "category" | "status" | "hospital_id" | "created_at" | "updated_at", ExtArgs["result"]["compliancePolicy"]>
  export type CompliancePolicyInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $CompliancePolicyPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "CompliancePolicy"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      category: string
      status: string
      hospital_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["compliancePolicy"]>
    composites: {}
  }

  type CompliancePolicyGetPayload<S extends boolean | null | undefined | CompliancePolicyDefaultArgs> = $Result.GetResult<Prisma.$CompliancePolicyPayload, S>

  type CompliancePolicyCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<CompliancePolicyFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: CompliancePolicyCountAggregateInputType | true
    }

  export interface CompliancePolicyDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['CompliancePolicy'], meta: { name: 'CompliancePolicy' } }
    /**
     * Find zero or one CompliancePolicy that matches the filter.
     * @param {CompliancePolicyFindUniqueArgs} args - Arguments to find a CompliancePolicy
     * @example
     * // Get one CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CompliancePolicyFindUniqueArgs>(args: SelectSubset<T, CompliancePolicyFindUniqueArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one CompliancePolicy that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {CompliancePolicyFindUniqueOrThrowArgs} args - Arguments to find a CompliancePolicy
     * @example
     * // Get one CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CompliancePolicyFindUniqueOrThrowArgs>(args: SelectSubset<T, CompliancePolicyFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first CompliancePolicy that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyFindFirstArgs} args - Arguments to find a CompliancePolicy
     * @example
     * // Get one CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CompliancePolicyFindFirstArgs>(args?: SelectSubset<T, CompliancePolicyFindFirstArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first CompliancePolicy that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyFindFirstOrThrowArgs} args - Arguments to find a CompliancePolicy
     * @example
     * // Get one CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CompliancePolicyFindFirstOrThrowArgs>(args?: SelectSubset<T, CompliancePolicyFindFirstOrThrowArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more CompliancePolicies that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all CompliancePolicies
     * const compliancePolicies = await prisma.compliancePolicy.findMany()
     * 
     * // Get first 10 CompliancePolicies
     * const compliancePolicies = await prisma.compliancePolicy.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const compliancePolicyWithIdOnly = await prisma.compliancePolicy.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CompliancePolicyFindManyArgs>(args?: SelectSubset<T, CompliancePolicyFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a CompliancePolicy.
     * @param {CompliancePolicyCreateArgs} args - Arguments to create a CompliancePolicy.
     * @example
     * // Create one CompliancePolicy
     * const CompliancePolicy = await prisma.compliancePolicy.create({
     *   data: {
     *     // ... data to create a CompliancePolicy
     *   }
     * })
     * 
     */
    create<T extends CompliancePolicyCreateArgs>(args: SelectSubset<T, CompliancePolicyCreateArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many CompliancePolicies.
     * @param {CompliancePolicyCreateManyArgs} args - Arguments to create many CompliancePolicies.
     * @example
     * // Create many CompliancePolicies
     * const compliancePolicy = await prisma.compliancePolicy.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CompliancePolicyCreateManyArgs>(args?: SelectSubset<T, CompliancePolicyCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a CompliancePolicy.
     * @param {CompliancePolicyDeleteArgs} args - Arguments to delete one CompliancePolicy.
     * @example
     * // Delete one CompliancePolicy
     * const CompliancePolicy = await prisma.compliancePolicy.delete({
     *   where: {
     *     // ... filter to delete one CompliancePolicy
     *   }
     * })
     * 
     */
    delete<T extends CompliancePolicyDeleteArgs>(args: SelectSubset<T, CompliancePolicyDeleteArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one CompliancePolicy.
     * @param {CompliancePolicyUpdateArgs} args - Arguments to update one CompliancePolicy.
     * @example
     * // Update one CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CompliancePolicyUpdateArgs>(args: SelectSubset<T, CompliancePolicyUpdateArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more CompliancePolicies.
     * @param {CompliancePolicyDeleteManyArgs} args - Arguments to filter CompliancePolicies to delete.
     * @example
     * // Delete a few CompliancePolicies
     * const { count } = await prisma.compliancePolicy.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CompliancePolicyDeleteManyArgs>(args?: SelectSubset<T, CompliancePolicyDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more CompliancePolicies.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many CompliancePolicies
     * const compliancePolicy = await prisma.compliancePolicy.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CompliancePolicyUpdateManyArgs>(args: SelectSubset<T, CompliancePolicyUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one CompliancePolicy.
     * @param {CompliancePolicyUpsertArgs} args - Arguments to update or create a CompliancePolicy.
     * @example
     * // Update or create a CompliancePolicy
     * const compliancePolicy = await prisma.compliancePolicy.upsert({
     *   create: {
     *     // ... data to create a CompliancePolicy
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the CompliancePolicy we want to update
     *   }
     * })
     */
    upsert<T extends CompliancePolicyUpsertArgs>(args: SelectSubset<T, CompliancePolicyUpsertArgs<ExtArgs>>): Prisma__CompliancePolicyClient<$Result.GetResult<Prisma.$CompliancePolicyPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of CompliancePolicies.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyCountArgs} args - Arguments to filter CompliancePolicies to count.
     * @example
     * // Count the number of CompliancePolicies
     * const count = await prisma.compliancePolicy.count({
     *   where: {
     *     // ... the filter for the CompliancePolicies we want to count
     *   }
     * })
    **/
    count<T extends CompliancePolicyCountArgs>(
      args?: Subset<T, CompliancePolicyCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CompliancePolicyCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a CompliancePolicy.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CompliancePolicyAggregateArgs>(args: Subset<T, CompliancePolicyAggregateArgs>): Prisma.PrismaPromise<GetCompliancePolicyAggregateType<T>>

    /**
     * Group by CompliancePolicy.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompliancePolicyGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CompliancePolicyGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CompliancePolicyGroupByArgs['orderBy'] }
        : { orderBy?: CompliancePolicyGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CompliancePolicyGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCompliancePolicyGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the CompliancePolicy model
   */
  readonly fields: CompliancePolicyFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for CompliancePolicy.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CompliancePolicyClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the CompliancePolicy model
   */
  interface CompliancePolicyFieldRefs {
    readonly id: FieldRef<"CompliancePolicy", 'Int'>
    readonly name: FieldRef<"CompliancePolicy", 'String'>
    readonly category: FieldRef<"CompliancePolicy", 'String'>
    readonly status: FieldRef<"CompliancePolicy", 'String'>
    readonly hospital_id: FieldRef<"CompliancePolicy", 'Int'>
    readonly created_at: FieldRef<"CompliancePolicy", 'DateTime'>
    readonly updated_at: FieldRef<"CompliancePolicy", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * CompliancePolicy findUnique
   */
  export type CompliancePolicyFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter, which CompliancePolicy to fetch.
     */
    where: CompliancePolicyWhereUniqueInput
  }

  /**
   * CompliancePolicy findUniqueOrThrow
   */
  export type CompliancePolicyFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter, which CompliancePolicy to fetch.
     */
    where: CompliancePolicyWhereUniqueInput
  }

  /**
   * CompliancePolicy findFirst
   */
  export type CompliancePolicyFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter, which CompliancePolicy to fetch.
     */
    where?: CompliancePolicyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CompliancePolicies to fetch.
     */
    orderBy?: CompliancePolicyOrderByWithRelationInput | CompliancePolicyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CompliancePolicies.
     */
    cursor?: CompliancePolicyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CompliancePolicies from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CompliancePolicies.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CompliancePolicies.
     */
    distinct?: CompliancePolicyScalarFieldEnum | CompliancePolicyScalarFieldEnum[]
  }

  /**
   * CompliancePolicy findFirstOrThrow
   */
  export type CompliancePolicyFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter, which CompliancePolicy to fetch.
     */
    where?: CompliancePolicyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CompliancePolicies to fetch.
     */
    orderBy?: CompliancePolicyOrderByWithRelationInput | CompliancePolicyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CompliancePolicies.
     */
    cursor?: CompliancePolicyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CompliancePolicies from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CompliancePolicies.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CompliancePolicies.
     */
    distinct?: CompliancePolicyScalarFieldEnum | CompliancePolicyScalarFieldEnum[]
  }

  /**
   * CompliancePolicy findMany
   */
  export type CompliancePolicyFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter, which CompliancePolicies to fetch.
     */
    where?: CompliancePolicyWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CompliancePolicies to fetch.
     */
    orderBy?: CompliancePolicyOrderByWithRelationInput | CompliancePolicyOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing CompliancePolicies.
     */
    cursor?: CompliancePolicyWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CompliancePolicies from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CompliancePolicies.
     */
    skip?: number
    distinct?: CompliancePolicyScalarFieldEnum | CompliancePolicyScalarFieldEnum[]
  }

  /**
   * CompliancePolicy create
   */
  export type CompliancePolicyCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * The data needed to create a CompliancePolicy.
     */
    data: XOR<CompliancePolicyCreateInput, CompliancePolicyUncheckedCreateInput>
  }

  /**
   * CompliancePolicy createMany
   */
  export type CompliancePolicyCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many CompliancePolicies.
     */
    data: CompliancePolicyCreateManyInput | CompliancePolicyCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * CompliancePolicy update
   */
  export type CompliancePolicyUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * The data needed to update a CompliancePolicy.
     */
    data: XOR<CompliancePolicyUpdateInput, CompliancePolicyUncheckedUpdateInput>
    /**
     * Choose, which CompliancePolicy to update.
     */
    where: CompliancePolicyWhereUniqueInput
  }

  /**
   * CompliancePolicy updateMany
   */
  export type CompliancePolicyUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update CompliancePolicies.
     */
    data: XOR<CompliancePolicyUpdateManyMutationInput, CompliancePolicyUncheckedUpdateManyInput>
    /**
     * Filter which CompliancePolicies to update
     */
    where?: CompliancePolicyWhereInput
    /**
     * Limit how many CompliancePolicies to update.
     */
    limit?: number
  }

  /**
   * CompliancePolicy upsert
   */
  export type CompliancePolicyUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * The filter to search for the CompliancePolicy to update in case it exists.
     */
    where: CompliancePolicyWhereUniqueInput
    /**
     * In case the CompliancePolicy found by the `where` argument doesn't exist, create a new CompliancePolicy with this data.
     */
    create: XOR<CompliancePolicyCreateInput, CompliancePolicyUncheckedCreateInput>
    /**
     * In case the CompliancePolicy was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CompliancePolicyUpdateInput, CompliancePolicyUncheckedUpdateInput>
  }

  /**
   * CompliancePolicy delete
   */
  export type CompliancePolicyDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
    /**
     * Filter which CompliancePolicy to delete.
     */
    where: CompliancePolicyWhereUniqueInput
  }

  /**
   * CompliancePolicy deleteMany
   */
  export type CompliancePolicyDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CompliancePolicies to delete
     */
    where?: CompliancePolicyWhereInput
    /**
     * Limit how many CompliancePolicies to delete.
     */
    limit?: number
  }

  /**
   * CompliancePolicy without action
   */
  export type CompliancePolicyDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompliancePolicy
     */
    select?: CompliancePolicySelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompliancePolicy
     */
    omit?: CompliancePolicyOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CompliancePolicyInclude<ExtArgs> | null
  }


  /**
   * Model AuditFinding
   */

  export type AggregateAuditFinding = {
    _count: AuditFindingCountAggregateOutputType | null
    _avg: AuditFindingAvgAggregateOutputType | null
    _sum: AuditFindingSumAggregateOutputType | null
    _min: AuditFindingMinAggregateOutputType | null
    _max: AuditFindingMaxAggregateOutputType | null
  }

  export type AuditFindingAvgAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type AuditFindingSumAggregateOutputType = {
    id: number | null
    hospital_id: number | null
  }

  export type AuditFindingMinAggregateOutputType = {
    id: number | null
    title: string | null
    department: string | null
    severity: $Enums.Severity | null
    status: $Enums.Status | null
    description: string | null
    date_reported: Date | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
    resolution_date: Date | null
    timeline: Date | null
  }

  export type AuditFindingMaxAggregateOutputType = {
    id: number | null
    title: string | null
    department: string | null
    severity: $Enums.Severity | null
    status: $Enums.Status | null
    description: string | null
    date_reported: Date | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
    resolution_date: Date | null
    timeline: Date | null
  }

  export type AuditFindingCountAggregateOutputType = {
    id: number
    title: number
    department: number
    severity: number
    status: number
    description: number
    date_reported: number
    hospital_id: number
    created_at: number
    updated_at: number
    resolution_date: number
    timeline: number
    _all: number
  }


  export type AuditFindingAvgAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type AuditFindingSumAggregateInputType = {
    id?: true
    hospital_id?: true
  }

  export type AuditFindingMinAggregateInputType = {
    id?: true
    title?: true
    department?: true
    severity?: true
    status?: true
    description?: true
    date_reported?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    resolution_date?: true
    timeline?: true
  }

  export type AuditFindingMaxAggregateInputType = {
    id?: true
    title?: true
    department?: true
    severity?: true
    status?: true
    description?: true
    date_reported?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    resolution_date?: true
    timeline?: true
  }

  export type AuditFindingCountAggregateInputType = {
    id?: true
    title?: true
    department?: true
    severity?: true
    status?: true
    description?: true
    date_reported?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    resolution_date?: true
    timeline?: true
    _all?: true
  }

  export type AuditFindingAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditFinding to aggregate.
     */
    where?: AuditFindingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditFindings to fetch.
     */
    orderBy?: AuditFindingOrderByWithRelationInput | AuditFindingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AuditFindingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditFindings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditFindings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned AuditFindings
    **/
    _count?: true | AuditFindingCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AuditFindingAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AuditFindingSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AuditFindingMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AuditFindingMaxAggregateInputType
  }

  export type GetAuditFindingAggregateType<T extends AuditFindingAggregateArgs> = {
        [P in keyof T & keyof AggregateAuditFinding]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuditFinding[P]>
      : GetScalarType<T[P], AggregateAuditFinding[P]>
  }




  export type AuditFindingGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditFindingWhereInput
    orderBy?: AuditFindingOrderByWithAggregationInput | AuditFindingOrderByWithAggregationInput[]
    by: AuditFindingScalarFieldEnum[] | AuditFindingScalarFieldEnum
    having?: AuditFindingScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AuditFindingCountAggregateInputType | true
    _avg?: AuditFindingAvgAggregateInputType
    _sum?: AuditFindingSumAggregateInputType
    _min?: AuditFindingMinAggregateInputType
    _max?: AuditFindingMaxAggregateInputType
  }

  export type AuditFindingGroupByOutputType = {
    id: number
    title: string
    department: string
    severity: $Enums.Severity
    status: $Enums.Status
    description: string | null
    date_reported: Date
    hospital_id: number
    created_at: Date
    updated_at: Date
    resolution_date: Date | null
    timeline: Date | null
    _count: AuditFindingCountAggregateOutputType | null
    _avg: AuditFindingAvgAggregateOutputType | null
    _sum: AuditFindingSumAggregateOutputType | null
    _min: AuditFindingMinAggregateOutputType | null
    _max: AuditFindingMaxAggregateOutputType | null
  }

  type GetAuditFindingGroupByPayload<T extends AuditFindingGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AuditFindingGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AuditFindingGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AuditFindingGroupByOutputType[P]>
            : GetScalarType<T[P], AuditFindingGroupByOutputType[P]>
        }
      >
    >


  export type AuditFindingSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    department?: boolean
    severity?: boolean
    status?: boolean
    description?: boolean
    date_reported?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    resolution_date?: boolean
    timeline?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["auditFinding"]>



  export type AuditFindingSelectScalar = {
    id?: boolean
    title?: boolean
    department?: boolean
    severity?: boolean
    status?: boolean
    description?: boolean
    date_reported?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    resolution_date?: boolean
    timeline?: boolean
  }

  export type AuditFindingOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "department" | "severity" | "status" | "description" | "date_reported" | "hospital_id" | "created_at" | "updated_at" | "resolution_date" | "timeline", ExtArgs["result"]["auditFinding"]>
  export type AuditFindingInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $AuditFindingPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "AuditFinding"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      title: string
      department: string
      severity: $Enums.Severity
      status: $Enums.Status
      description: string | null
      date_reported: Date
      hospital_id: number
      created_at: Date
      updated_at: Date
      resolution_date: Date | null
      timeline: Date | null
    }, ExtArgs["result"]["auditFinding"]>
    composites: {}
  }

  type AuditFindingGetPayload<S extends boolean | null | undefined | AuditFindingDefaultArgs> = $Result.GetResult<Prisma.$AuditFindingPayload, S>

  type AuditFindingCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<AuditFindingFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AuditFindingCountAggregateInputType | true
    }

  export interface AuditFindingDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['AuditFinding'], meta: { name: 'AuditFinding' } }
    /**
     * Find zero or one AuditFinding that matches the filter.
     * @param {AuditFindingFindUniqueArgs} args - Arguments to find a AuditFinding
     * @example
     * // Get one AuditFinding
     * const auditFinding = await prisma.auditFinding.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AuditFindingFindUniqueArgs>(args: SelectSubset<T, AuditFindingFindUniqueArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one AuditFinding that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {AuditFindingFindUniqueOrThrowArgs} args - Arguments to find a AuditFinding
     * @example
     * // Get one AuditFinding
     * const auditFinding = await prisma.auditFinding.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AuditFindingFindUniqueOrThrowArgs>(args: SelectSubset<T, AuditFindingFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuditFinding that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingFindFirstArgs} args - Arguments to find a AuditFinding
     * @example
     * // Get one AuditFinding
     * const auditFinding = await prisma.auditFinding.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AuditFindingFindFirstArgs>(args?: SelectSubset<T, AuditFindingFindFirstArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuditFinding that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingFindFirstOrThrowArgs} args - Arguments to find a AuditFinding
     * @example
     * // Get one AuditFinding
     * const auditFinding = await prisma.auditFinding.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AuditFindingFindFirstOrThrowArgs>(args?: SelectSubset<T, AuditFindingFindFirstOrThrowArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more AuditFindings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all AuditFindings
     * const auditFindings = await prisma.auditFinding.findMany()
     * 
     * // Get first 10 AuditFindings
     * const auditFindings = await prisma.auditFinding.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const auditFindingWithIdOnly = await prisma.auditFinding.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends AuditFindingFindManyArgs>(args?: SelectSubset<T, AuditFindingFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a AuditFinding.
     * @param {AuditFindingCreateArgs} args - Arguments to create a AuditFinding.
     * @example
     * // Create one AuditFinding
     * const AuditFinding = await prisma.auditFinding.create({
     *   data: {
     *     // ... data to create a AuditFinding
     *   }
     * })
     * 
     */
    create<T extends AuditFindingCreateArgs>(args: SelectSubset<T, AuditFindingCreateArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many AuditFindings.
     * @param {AuditFindingCreateManyArgs} args - Arguments to create many AuditFindings.
     * @example
     * // Create many AuditFindings
     * const auditFinding = await prisma.auditFinding.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AuditFindingCreateManyArgs>(args?: SelectSubset<T, AuditFindingCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a AuditFinding.
     * @param {AuditFindingDeleteArgs} args - Arguments to delete one AuditFinding.
     * @example
     * // Delete one AuditFinding
     * const AuditFinding = await prisma.auditFinding.delete({
     *   where: {
     *     // ... filter to delete one AuditFinding
     *   }
     * })
     * 
     */
    delete<T extends AuditFindingDeleteArgs>(args: SelectSubset<T, AuditFindingDeleteArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one AuditFinding.
     * @param {AuditFindingUpdateArgs} args - Arguments to update one AuditFinding.
     * @example
     * // Update one AuditFinding
     * const auditFinding = await prisma.auditFinding.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AuditFindingUpdateArgs>(args: SelectSubset<T, AuditFindingUpdateArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more AuditFindings.
     * @param {AuditFindingDeleteManyArgs} args - Arguments to filter AuditFindings to delete.
     * @example
     * // Delete a few AuditFindings
     * const { count } = await prisma.auditFinding.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AuditFindingDeleteManyArgs>(args?: SelectSubset<T, AuditFindingDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AuditFindings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many AuditFindings
     * const auditFinding = await prisma.auditFinding.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AuditFindingUpdateManyArgs>(args: SelectSubset<T, AuditFindingUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one AuditFinding.
     * @param {AuditFindingUpsertArgs} args - Arguments to update or create a AuditFinding.
     * @example
     * // Update or create a AuditFinding
     * const auditFinding = await prisma.auditFinding.upsert({
     *   create: {
     *     // ... data to create a AuditFinding
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the AuditFinding we want to update
     *   }
     * })
     */
    upsert<T extends AuditFindingUpsertArgs>(args: SelectSubset<T, AuditFindingUpsertArgs<ExtArgs>>): Prisma__AuditFindingClient<$Result.GetResult<Prisma.$AuditFindingPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of AuditFindings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingCountArgs} args - Arguments to filter AuditFindings to count.
     * @example
     * // Count the number of AuditFindings
     * const count = await prisma.auditFinding.count({
     *   where: {
     *     // ... the filter for the AuditFindings we want to count
     *   }
     * })
    **/
    count<T extends AuditFindingCountArgs>(
      args?: Subset<T, AuditFindingCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AuditFindingCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a AuditFinding.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AuditFindingAggregateArgs>(args: Subset<T, AuditFindingAggregateArgs>): Prisma.PrismaPromise<GetAuditFindingAggregateType<T>>

    /**
     * Group by AuditFinding.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditFindingGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AuditFindingGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AuditFindingGroupByArgs['orderBy'] }
        : { orderBy?: AuditFindingGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AuditFindingGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuditFindingGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the AuditFinding model
   */
  readonly fields: AuditFindingFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for AuditFinding.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AuditFindingClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the AuditFinding model
   */
  interface AuditFindingFieldRefs {
    readonly id: FieldRef<"AuditFinding", 'Int'>
    readonly title: FieldRef<"AuditFinding", 'String'>
    readonly department: FieldRef<"AuditFinding", 'String'>
    readonly severity: FieldRef<"AuditFinding", 'Severity'>
    readonly status: FieldRef<"AuditFinding", 'Status'>
    readonly description: FieldRef<"AuditFinding", 'String'>
    readonly date_reported: FieldRef<"AuditFinding", 'DateTime'>
    readonly hospital_id: FieldRef<"AuditFinding", 'Int'>
    readonly created_at: FieldRef<"AuditFinding", 'DateTime'>
    readonly updated_at: FieldRef<"AuditFinding", 'DateTime'>
    readonly resolution_date: FieldRef<"AuditFinding", 'DateTime'>
    readonly timeline: FieldRef<"AuditFinding", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * AuditFinding findUnique
   */
  export type AuditFindingFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter, which AuditFinding to fetch.
     */
    where: AuditFindingWhereUniqueInput
  }

  /**
   * AuditFinding findUniqueOrThrow
   */
  export type AuditFindingFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter, which AuditFinding to fetch.
     */
    where: AuditFindingWhereUniqueInput
  }

  /**
   * AuditFinding findFirst
   */
  export type AuditFindingFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter, which AuditFinding to fetch.
     */
    where?: AuditFindingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditFindings to fetch.
     */
    orderBy?: AuditFindingOrderByWithRelationInput | AuditFindingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditFindings.
     */
    cursor?: AuditFindingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditFindings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditFindings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditFindings.
     */
    distinct?: AuditFindingScalarFieldEnum | AuditFindingScalarFieldEnum[]
  }

  /**
   * AuditFinding findFirstOrThrow
   */
  export type AuditFindingFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter, which AuditFinding to fetch.
     */
    where?: AuditFindingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditFindings to fetch.
     */
    orderBy?: AuditFindingOrderByWithRelationInput | AuditFindingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditFindings.
     */
    cursor?: AuditFindingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditFindings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditFindings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditFindings.
     */
    distinct?: AuditFindingScalarFieldEnum | AuditFindingScalarFieldEnum[]
  }

  /**
   * AuditFinding findMany
   */
  export type AuditFindingFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter, which AuditFindings to fetch.
     */
    where?: AuditFindingWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditFindings to fetch.
     */
    orderBy?: AuditFindingOrderByWithRelationInput | AuditFindingOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing AuditFindings.
     */
    cursor?: AuditFindingWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditFindings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditFindings.
     */
    skip?: number
    distinct?: AuditFindingScalarFieldEnum | AuditFindingScalarFieldEnum[]
  }

  /**
   * AuditFinding create
   */
  export type AuditFindingCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * The data needed to create a AuditFinding.
     */
    data: XOR<AuditFindingCreateInput, AuditFindingUncheckedCreateInput>
  }

  /**
   * AuditFinding createMany
   */
  export type AuditFindingCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many AuditFindings.
     */
    data: AuditFindingCreateManyInput | AuditFindingCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AuditFinding update
   */
  export type AuditFindingUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * The data needed to update a AuditFinding.
     */
    data: XOR<AuditFindingUpdateInput, AuditFindingUncheckedUpdateInput>
    /**
     * Choose, which AuditFinding to update.
     */
    where: AuditFindingWhereUniqueInput
  }

  /**
   * AuditFinding updateMany
   */
  export type AuditFindingUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update AuditFindings.
     */
    data: XOR<AuditFindingUpdateManyMutationInput, AuditFindingUncheckedUpdateManyInput>
    /**
     * Filter which AuditFindings to update
     */
    where?: AuditFindingWhereInput
    /**
     * Limit how many AuditFindings to update.
     */
    limit?: number
  }

  /**
   * AuditFinding upsert
   */
  export type AuditFindingUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * The filter to search for the AuditFinding to update in case it exists.
     */
    where: AuditFindingWhereUniqueInput
    /**
     * In case the AuditFinding found by the `where` argument doesn't exist, create a new AuditFinding with this data.
     */
    create: XOR<AuditFindingCreateInput, AuditFindingUncheckedCreateInput>
    /**
     * In case the AuditFinding was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AuditFindingUpdateInput, AuditFindingUncheckedUpdateInput>
  }

  /**
   * AuditFinding delete
   */
  export type AuditFindingDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
    /**
     * Filter which AuditFinding to delete.
     */
    where: AuditFindingWhereUniqueInput
  }

  /**
   * AuditFinding deleteMany
   */
  export type AuditFindingDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditFindings to delete
     */
    where?: AuditFindingWhereInput
    /**
     * Limit how many AuditFindings to delete.
     */
    limit?: number
  }

  /**
   * AuditFinding without action
   */
  export type AuditFindingDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditFinding
     */
    select?: AuditFindingSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditFinding
     */
    omit?: AuditFindingOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditFindingInclude<ExtArgs> | null
  }


  /**
   * Model AuditSchedule
   */

  export type AggregateAuditSchedule = {
    _count: AuditScheduleCountAggregateOutputType | null
    _avg: AuditScheduleAvgAggregateOutputType | null
    _sum: AuditScheduleSumAggregateOutputType | null
    _min: AuditScheduleMinAggregateOutputType | null
    _max: AuditScheduleMaxAggregateOutputType | null
  }

  export type AuditScheduleAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type AuditScheduleSumAggregateOutputType = {
    hospital_id: number | null
  }

  export type AuditScheduleMinAggregateOutputType = {
    id: string | null
    title: string | null
    date: Date | null
    department: string | null
    auditor: string | null
    status: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type AuditScheduleMaxAggregateOutputType = {
    id: string | null
    title: string | null
    date: Date | null
    department: string | null
    auditor: string | null
    status: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type AuditScheduleCountAggregateOutputType = {
    id: number
    title: number
    date: number
    department: number
    auditor: number
    status: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type AuditScheduleAvgAggregateInputType = {
    hospital_id?: true
  }

  export type AuditScheduleSumAggregateInputType = {
    hospital_id?: true
  }

  export type AuditScheduleMinAggregateInputType = {
    id?: true
    title?: true
    date?: true
    department?: true
    auditor?: true
    status?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type AuditScheduleMaxAggregateInputType = {
    id?: true
    title?: true
    date?: true
    department?: true
    auditor?: true
    status?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type AuditScheduleCountAggregateInputType = {
    id?: true
    title?: true
    date?: true
    department?: true
    auditor?: true
    status?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type AuditScheduleAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditSchedule to aggregate.
     */
    where?: AuditScheduleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditSchedules to fetch.
     */
    orderBy?: AuditScheduleOrderByWithRelationInput | AuditScheduleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AuditScheduleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditSchedules from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditSchedules.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned AuditSchedules
    **/
    _count?: true | AuditScheduleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AuditScheduleAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AuditScheduleSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AuditScheduleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AuditScheduleMaxAggregateInputType
  }

  export type GetAuditScheduleAggregateType<T extends AuditScheduleAggregateArgs> = {
        [P in keyof T & keyof AggregateAuditSchedule]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuditSchedule[P]>
      : GetScalarType<T[P], AggregateAuditSchedule[P]>
  }




  export type AuditScheduleGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AuditScheduleWhereInput
    orderBy?: AuditScheduleOrderByWithAggregationInput | AuditScheduleOrderByWithAggregationInput[]
    by: AuditScheduleScalarFieldEnum[] | AuditScheduleScalarFieldEnum
    having?: AuditScheduleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AuditScheduleCountAggregateInputType | true
    _avg?: AuditScheduleAvgAggregateInputType
    _sum?: AuditScheduleSumAggregateInputType
    _min?: AuditScheduleMinAggregateInputType
    _max?: AuditScheduleMaxAggregateInputType
  }

  export type AuditScheduleGroupByOutputType = {
    id: string
    title: string
    date: Date
    department: string
    auditor: string
    status: string
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: AuditScheduleCountAggregateOutputType | null
    _avg: AuditScheduleAvgAggregateOutputType | null
    _sum: AuditScheduleSumAggregateOutputType | null
    _min: AuditScheduleMinAggregateOutputType | null
    _max: AuditScheduleMaxAggregateOutputType | null
  }

  type GetAuditScheduleGroupByPayload<T extends AuditScheduleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AuditScheduleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AuditScheduleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AuditScheduleGroupByOutputType[P]>
            : GetScalarType<T[P], AuditScheduleGroupByOutputType[P]>
        }
      >
    >


  export type AuditScheduleSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    date?: boolean
    department?: boolean
    auditor?: boolean
    status?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | AuditSchedule$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["auditSchedule"]>



  export type AuditScheduleSelectScalar = {
    id?: boolean
    title?: boolean
    date?: boolean
    department?: boolean
    auditor?: boolean
    status?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type AuditScheduleOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "date" | "department" | "auditor" | "status" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["auditSchedule"]>
  export type AuditScheduleInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | AuditSchedule$hospitalArgs<ExtArgs>
  }

  export type $AuditSchedulePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "AuditSchedule"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      title: string
      date: Date
      department: string
      auditor: string
      status: string
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["auditSchedule"]>
    composites: {}
  }

  type AuditScheduleGetPayload<S extends boolean | null | undefined | AuditScheduleDefaultArgs> = $Result.GetResult<Prisma.$AuditSchedulePayload, S>

  type AuditScheduleCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<AuditScheduleFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AuditScheduleCountAggregateInputType | true
    }

  export interface AuditScheduleDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['AuditSchedule'], meta: { name: 'AuditSchedule' } }
    /**
     * Find zero or one AuditSchedule that matches the filter.
     * @param {AuditScheduleFindUniqueArgs} args - Arguments to find a AuditSchedule
     * @example
     * // Get one AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AuditScheduleFindUniqueArgs>(args: SelectSubset<T, AuditScheduleFindUniqueArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one AuditSchedule that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {AuditScheduleFindUniqueOrThrowArgs} args - Arguments to find a AuditSchedule
     * @example
     * // Get one AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AuditScheduleFindUniqueOrThrowArgs>(args: SelectSubset<T, AuditScheduleFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuditSchedule that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleFindFirstArgs} args - Arguments to find a AuditSchedule
     * @example
     * // Get one AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AuditScheduleFindFirstArgs>(args?: SelectSubset<T, AuditScheduleFindFirstArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first AuditSchedule that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleFindFirstOrThrowArgs} args - Arguments to find a AuditSchedule
     * @example
     * // Get one AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AuditScheduleFindFirstOrThrowArgs>(args?: SelectSubset<T, AuditScheduleFindFirstOrThrowArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more AuditSchedules that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all AuditSchedules
     * const auditSchedules = await prisma.auditSchedule.findMany()
     * 
     * // Get first 10 AuditSchedules
     * const auditSchedules = await prisma.auditSchedule.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const auditScheduleWithIdOnly = await prisma.auditSchedule.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends AuditScheduleFindManyArgs>(args?: SelectSubset<T, AuditScheduleFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a AuditSchedule.
     * @param {AuditScheduleCreateArgs} args - Arguments to create a AuditSchedule.
     * @example
     * // Create one AuditSchedule
     * const AuditSchedule = await prisma.auditSchedule.create({
     *   data: {
     *     // ... data to create a AuditSchedule
     *   }
     * })
     * 
     */
    create<T extends AuditScheduleCreateArgs>(args: SelectSubset<T, AuditScheduleCreateArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many AuditSchedules.
     * @param {AuditScheduleCreateManyArgs} args - Arguments to create many AuditSchedules.
     * @example
     * // Create many AuditSchedules
     * const auditSchedule = await prisma.auditSchedule.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AuditScheduleCreateManyArgs>(args?: SelectSubset<T, AuditScheduleCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a AuditSchedule.
     * @param {AuditScheduleDeleteArgs} args - Arguments to delete one AuditSchedule.
     * @example
     * // Delete one AuditSchedule
     * const AuditSchedule = await prisma.auditSchedule.delete({
     *   where: {
     *     // ... filter to delete one AuditSchedule
     *   }
     * })
     * 
     */
    delete<T extends AuditScheduleDeleteArgs>(args: SelectSubset<T, AuditScheduleDeleteArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one AuditSchedule.
     * @param {AuditScheduleUpdateArgs} args - Arguments to update one AuditSchedule.
     * @example
     * // Update one AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AuditScheduleUpdateArgs>(args: SelectSubset<T, AuditScheduleUpdateArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more AuditSchedules.
     * @param {AuditScheduleDeleteManyArgs} args - Arguments to filter AuditSchedules to delete.
     * @example
     * // Delete a few AuditSchedules
     * const { count } = await prisma.auditSchedule.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AuditScheduleDeleteManyArgs>(args?: SelectSubset<T, AuditScheduleDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AuditSchedules.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many AuditSchedules
     * const auditSchedule = await prisma.auditSchedule.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AuditScheduleUpdateManyArgs>(args: SelectSubset<T, AuditScheduleUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one AuditSchedule.
     * @param {AuditScheduleUpsertArgs} args - Arguments to update or create a AuditSchedule.
     * @example
     * // Update or create a AuditSchedule
     * const auditSchedule = await prisma.auditSchedule.upsert({
     *   create: {
     *     // ... data to create a AuditSchedule
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the AuditSchedule we want to update
     *   }
     * })
     */
    upsert<T extends AuditScheduleUpsertArgs>(args: SelectSubset<T, AuditScheduleUpsertArgs<ExtArgs>>): Prisma__AuditScheduleClient<$Result.GetResult<Prisma.$AuditSchedulePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of AuditSchedules.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleCountArgs} args - Arguments to filter AuditSchedules to count.
     * @example
     * // Count the number of AuditSchedules
     * const count = await prisma.auditSchedule.count({
     *   where: {
     *     // ... the filter for the AuditSchedules we want to count
     *   }
     * })
    **/
    count<T extends AuditScheduleCountArgs>(
      args?: Subset<T, AuditScheduleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AuditScheduleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a AuditSchedule.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AuditScheduleAggregateArgs>(args: Subset<T, AuditScheduleAggregateArgs>): Prisma.PrismaPromise<GetAuditScheduleAggregateType<T>>

    /**
     * Group by AuditSchedule.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AuditScheduleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AuditScheduleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AuditScheduleGroupByArgs['orderBy'] }
        : { orderBy?: AuditScheduleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AuditScheduleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuditScheduleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the AuditSchedule model
   */
  readonly fields: AuditScheduleFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for AuditSchedule.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AuditScheduleClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends AuditSchedule$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, AuditSchedule$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the AuditSchedule model
   */
  interface AuditScheduleFieldRefs {
    readonly id: FieldRef<"AuditSchedule", 'String'>
    readonly title: FieldRef<"AuditSchedule", 'String'>
    readonly date: FieldRef<"AuditSchedule", 'DateTime'>
    readonly department: FieldRef<"AuditSchedule", 'String'>
    readonly auditor: FieldRef<"AuditSchedule", 'String'>
    readonly status: FieldRef<"AuditSchedule", 'String'>
    readonly hospital_id: FieldRef<"AuditSchedule", 'Int'>
    readonly createdAt: FieldRef<"AuditSchedule", 'DateTime'>
    readonly updatedAt: FieldRef<"AuditSchedule", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * AuditSchedule findUnique
   */
  export type AuditScheduleFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter, which AuditSchedule to fetch.
     */
    where: AuditScheduleWhereUniqueInput
  }

  /**
   * AuditSchedule findUniqueOrThrow
   */
  export type AuditScheduleFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter, which AuditSchedule to fetch.
     */
    where: AuditScheduleWhereUniqueInput
  }

  /**
   * AuditSchedule findFirst
   */
  export type AuditScheduleFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter, which AuditSchedule to fetch.
     */
    where?: AuditScheduleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditSchedules to fetch.
     */
    orderBy?: AuditScheduleOrderByWithRelationInput | AuditScheduleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditSchedules.
     */
    cursor?: AuditScheduleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditSchedules from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditSchedules.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditSchedules.
     */
    distinct?: AuditScheduleScalarFieldEnum | AuditScheduleScalarFieldEnum[]
  }

  /**
   * AuditSchedule findFirstOrThrow
   */
  export type AuditScheduleFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter, which AuditSchedule to fetch.
     */
    where?: AuditScheduleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditSchedules to fetch.
     */
    orderBy?: AuditScheduleOrderByWithRelationInput | AuditScheduleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AuditSchedules.
     */
    cursor?: AuditScheduleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditSchedules from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditSchedules.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AuditSchedules.
     */
    distinct?: AuditScheduleScalarFieldEnum | AuditScheduleScalarFieldEnum[]
  }

  /**
   * AuditSchedule findMany
   */
  export type AuditScheduleFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter, which AuditSchedules to fetch.
     */
    where?: AuditScheduleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AuditSchedules to fetch.
     */
    orderBy?: AuditScheduleOrderByWithRelationInput | AuditScheduleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing AuditSchedules.
     */
    cursor?: AuditScheduleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AuditSchedules from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AuditSchedules.
     */
    skip?: number
    distinct?: AuditScheduleScalarFieldEnum | AuditScheduleScalarFieldEnum[]
  }

  /**
   * AuditSchedule create
   */
  export type AuditScheduleCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * The data needed to create a AuditSchedule.
     */
    data: XOR<AuditScheduleCreateInput, AuditScheduleUncheckedCreateInput>
  }

  /**
   * AuditSchedule createMany
   */
  export type AuditScheduleCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many AuditSchedules.
     */
    data: AuditScheduleCreateManyInput | AuditScheduleCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AuditSchedule update
   */
  export type AuditScheduleUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * The data needed to update a AuditSchedule.
     */
    data: XOR<AuditScheduleUpdateInput, AuditScheduleUncheckedUpdateInput>
    /**
     * Choose, which AuditSchedule to update.
     */
    where: AuditScheduleWhereUniqueInput
  }

  /**
   * AuditSchedule updateMany
   */
  export type AuditScheduleUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update AuditSchedules.
     */
    data: XOR<AuditScheduleUpdateManyMutationInput, AuditScheduleUncheckedUpdateManyInput>
    /**
     * Filter which AuditSchedules to update
     */
    where?: AuditScheduleWhereInput
    /**
     * Limit how many AuditSchedules to update.
     */
    limit?: number
  }

  /**
   * AuditSchedule upsert
   */
  export type AuditScheduleUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * The filter to search for the AuditSchedule to update in case it exists.
     */
    where: AuditScheduleWhereUniqueInput
    /**
     * In case the AuditSchedule found by the `where` argument doesn't exist, create a new AuditSchedule with this data.
     */
    create: XOR<AuditScheduleCreateInput, AuditScheduleUncheckedCreateInput>
    /**
     * In case the AuditSchedule was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AuditScheduleUpdateInput, AuditScheduleUncheckedUpdateInput>
  }

  /**
   * AuditSchedule delete
   */
  export type AuditScheduleDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
    /**
     * Filter which AuditSchedule to delete.
     */
    where: AuditScheduleWhereUniqueInput
  }

  /**
   * AuditSchedule deleteMany
   */
  export type AuditScheduleDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AuditSchedules to delete
     */
    where?: AuditScheduleWhereInput
    /**
     * Limit how many AuditSchedules to delete.
     */
    limit?: number
  }

  /**
   * AuditSchedule.hospital
   */
  export type AuditSchedule$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * AuditSchedule without action
   */
  export type AuditScheduleDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AuditSchedule
     */
    select?: AuditScheduleSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AuditSchedule
     */
    omit?: AuditScheduleOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AuditScheduleInclude<ExtArgs> | null
  }


  /**
   * Model TrainingEvent
   */

  export type AggregateTrainingEvent = {
    _count: TrainingEventCountAggregateOutputType | null
    _avg: TrainingEventAvgAggregateOutputType | null
    _sum: TrainingEventSumAggregateOutputType | null
    _min: TrainingEventMinAggregateOutputType | null
    _max: TrainingEventMaxAggregateOutputType | null
  }

  export type TrainingEventAvgAggregateOutputType = {
    capacity: number | null
    enrolled: number | null
    hospital_id: number | null
  }

  export type TrainingEventSumAggregateOutputType = {
    capacity: number | null
    enrolled: number | null
    hospital_id: number | null
  }

  export type TrainingEventMinAggregateOutputType = {
    id: string | null
    title: string | null
    date: Date | null
    instructor: string | null
    location: string | null
    department: string | null
    duration: string | null
    capacity: number | null
    enrolled: number | null
    required: boolean | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type TrainingEventMaxAggregateOutputType = {
    id: string | null
    title: string | null
    date: Date | null
    instructor: string | null
    location: string | null
    department: string | null
    duration: string | null
    capacity: number | null
    enrolled: number | null
    required: boolean | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type TrainingEventCountAggregateOutputType = {
    id: number
    title: number
    date: number
    instructor: number
    location: number
    department: number
    duration: number
    capacity: number
    enrolled: number
    required: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type TrainingEventAvgAggregateInputType = {
    capacity?: true
    enrolled?: true
    hospital_id?: true
  }

  export type TrainingEventSumAggregateInputType = {
    capacity?: true
    enrolled?: true
    hospital_id?: true
  }

  export type TrainingEventMinAggregateInputType = {
    id?: true
    title?: true
    date?: true
    instructor?: true
    location?: true
    department?: true
    duration?: true
    capacity?: true
    enrolled?: true
    required?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type TrainingEventMaxAggregateInputType = {
    id?: true
    title?: true
    date?: true
    instructor?: true
    location?: true
    department?: true
    duration?: true
    capacity?: true
    enrolled?: true
    required?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type TrainingEventCountAggregateInputType = {
    id?: true
    title?: true
    date?: true
    instructor?: true
    location?: true
    department?: true
    duration?: true
    capacity?: true
    enrolled?: true
    required?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type TrainingEventAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TrainingEvent to aggregate.
     */
    where?: TrainingEventWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TrainingEvents to fetch.
     */
    orderBy?: TrainingEventOrderByWithRelationInput | TrainingEventOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TrainingEventWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TrainingEvents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TrainingEvents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned TrainingEvents
    **/
    _count?: true | TrainingEventCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TrainingEventAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TrainingEventSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TrainingEventMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TrainingEventMaxAggregateInputType
  }

  export type GetTrainingEventAggregateType<T extends TrainingEventAggregateArgs> = {
        [P in keyof T & keyof AggregateTrainingEvent]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTrainingEvent[P]>
      : GetScalarType<T[P], AggregateTrainingEvent[P]>
  }




  export type TrainingEventGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TrainingEventWhereInput
    orderBy?: TrainingEventOrderByWithAggregationInput | TrainingEventOrderByWithAggregationInput[]
    by: TrainingEventScalarFieldEnum[] | TrainingEventScalarFieldEnum
    having?: TrainingEventScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TrainingEventCountAggregateInputType | true
    _avg?: TrainingEventAvgAggregateInputType
    _sum?: TrainingEventSumAggregateInputType
    _min?: TrainingEventMinAggregateInputType
    _max?: TrainingEventMaxAggregateInputType
  }

  export type TrainingEventGroupByOutputType = {
    id: string
    title: string
    date: Date
    instructor: string
    location: string
    department: string
    duration: string
    capacity: number
    enrolled: number
    required: boolean
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: TrainingEventCountAggregateOutputType | null
    _avg: TrainingEventAvgAggregateOutputType | null
    _sum: TrainingEventSumAggregateOutputType | null
    _min: TrainingEventMinAggregateOutputType | null
    _max: TrainingEventMaxAggregateOutputType | null
  }

  type GetTrainingEventGroupByPayload<T extends TrainingEventGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TrainingEventGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TrainingEventGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TrainingEventGroupByOutputType[P]>
            : GetScalarType<T[P], TrainingEventGroupByOutputType[P]>
        }
      >
    >


  export type TrainingEventSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    date?: boolean
    instructor?: boolean
    location?: boolean
    department?: boolean
    duration?: boolean
    capacity?: boolean
    enrolled?: boolean
    required?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | TrainingEvent$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["trainingEvent"]>



  export type TrainingEventSelectScalar = {
    id?: boolean
    title?: boolean
    date?: boolean
    instructor?: boolean
    location?: boolean
    department?: boolean
    duration?: boolean
    capacity?: boolean
    enrolled?: boolean
    required?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type TrainingEventOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "date" | "instructor" | "location" | "department" | "duration" | "capacity" | "enrolled" | "required" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["trainingEvent"]>
  export type TrainingEventInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | TrainingEvent$hospitalArgs<ExtArgs>
  }

  export type $TrainingEventPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "TrainingEvent"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      title: string
      date: Date
      instructor: string
      location: string
      department: string
      duration: string
      capacity: number
      enrolled: number
      required: boolean
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["trainingEvent"]>
    composites: {}
  }

  type TrainingEventGetPayload<S extends boolean | null | undefined | TrainingEventDefaultArgs> = $Result.GetResult<Prisma.$TrainingEventPayload, S>

  type TrainingEventCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<TrainingEventFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: TrainingEventCountAggregateInputType | true
    }

  export interface TrainingEventDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['TrainingEvent'], meta: { name: 'TrainingEvent' } }
    /**
     * Find zero or one TrainingEvent that matches the filter.
     * @param {TrainingEventFindUniqueArgs} args - Arguments to find a TrainingEvent
     * @example
     * // Get one TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TrainingEventFindUniqueArgs>(args: SelectSubset<T, TrainingEventFindUniqueArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one TrainingEvent that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {TrainingEventFindUniqueOrThrowArgs} args - Arguments to find a TrainingEvent
     * @example
     * // Get one TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TrainingEventFindUniqueOrThrowArgs>(args: SelectSubset<T, TrainingEventFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first TrainingEvent that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventFindFirstArgs} args - Arguments to find a TrainingEvent
     * @example
     * // Get one TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TrainingEventFindFirstArgs>(args?: SelectSubset<T, TrainingEventFindFirstArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first TrainingEvent that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventFindFirstOrThrowArgs} args - Arguments to find a TrainingEvent
     * @example
     * // Get one TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TrainingEventFindFirstOrThrowArgs>(args?: SelectSubset<T, TrainingEventFindFirstOrThrowArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more TrainingEvents that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all TrainingEvents
     * const trainingEvents = await prisma.trainingEvent.findMany()
     * 
     * // Get first 10 TrainingEvents
     * const trainingEvents = await prisma.trainingEvent.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const trainingEventWithIdOnly = await prisma.trainingEvent.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TrainingEventFindManyArgs>(args?: SelectSubset<T, TrainingEventFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a TrainingEvent.
     * @param {TrainingEventCreateArgs} args - Arguments to create a TrainingEvent.
     * @example
     * // Create one TrainingEvent
     * const TrainingEvent = await prisma.trainingEvent.create({
     *   data: {
     *     // ... data to create a TrainingEvent
     *   }
     * })
     * 
     */
    create<T extends TrainingEventCreateArgs>(args: SelectSubset<T, TrainingEventCreateArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many TrainingEvents.
     * @param {TrainingEventCreateManyArgs} args - Arguments to create many TrainingEvents.
     * @example
     * // Create many TrainingEvents
     * const trainingEvent = await prisma.trainingEvent.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TrainingEventCreateManyArgs>(args?: SelectSubset<T, TrainingEventCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a TrainingEvent.
     * @param {TrainingEventDeleteArgs} args - Arguments to delete one TrainingEvent.
     * @example
     * // Delete one TrainingEvent
     * const TrainingEvent = await prisma.trainingEvent.delete({
     *   where: {
     *     // ... filter to delete one TrainingEvent
     *   }
     * })
     * 
     */
    delete<T extends TrainingEventDeleteArgs>(args: SelectSubset<T, TrainingEventDeleteArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one TrainingEvent.
     * @param {TrainingEventUpdateArgs} args - Arguments to update one TrainingEvent.
     * @example
     * // Update one TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TrainingEventUpdateArgs>(args: SelectSubset<T, TrainingEventUpdateArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more TrainingEvents.
     * @param {TrainingEventDeleteManyArgs} args - Arguments to filter TrainingEvents to delete.
     * @example
     * // Delete a few TrainingEvents
     * const { count } = await prisma.trainingEvent.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TrainingEventDeleteManyArgs>(args?: SelectSubset<T, TrainingEventDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more TrainingEvents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many TrainingEvents
     * const trainingEvent = await prisma.trainingEvent.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TrainingEventUpdateManyArgs>(args: SelectSubset<T, TrainingEventUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one TrainingEvent.
     * @param {TrainingEventUpsertArgs} args - Arguments to update or create a TrainingEvent.
     * @example
     * // Update or create a TrainingEvent
     * const trainingEvent = await prisma.trainingEvent.upsert({
     *   create: {
     *     // ... data to create a TrainingEvent
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the TrainingEvent we want to update
     *   }
     * })
     */
    upsert<T extends TrainingEventUpsertArgs>(args: SelectSubset<T, TrainingEventUpsertArgs<ExtArgs>>): Prisma__TrainingEventClient<$Result.GetResult<Prisma.$TrainingEventPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of TrainingEvents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventCountArgs} args - Arguments to filter TrainingEvents to count.
     * @example
     * // Count the number of TrainingEvents
     * const count = await prisma.trainingEvent.count({
     *   where: {
     *     // ... the filter for the TrainingEvents we want to count
     *   }
     * })
    **/
    count<T extends TrainingEventCountArgs>(
      args?: Subset<T, TrainingEventCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TrainingEventCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a TrainingEvent.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TrainingEventAggregateArgs>(args: Subset<T, TrainingEventAggregateArgs>): Prisma.PrismaPromise<GetTrainingEventAggregateType<T>>

    /**
     * Group by TrainingEvent.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TrainingEventGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TrainingEventGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TrainingEventGroupByArgs['orderBy'] }
        : { orderBy?: TrainingEventGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TrainingEventGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTrainingEventGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the TrainingEvent model
   */
  readonly fields: TrainingEventFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for TrainingEvent.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TrainingEventClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends TrainingEvent$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, TrainingEvent$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the TrainingEvent model
   */
  interface TrainingEventFieldRefs {
    readonly id: FieldRef<"TrainingEvent", 'String'>
    readonly title: FieldRef<"TrainingEvent", 'String'>
    readonly date: FieldRef<"TrainingEvent", 'DateTime'>
    readonly instructor: FieldRef<"TrainingEvent", 'String'>
    readonly location: FieldRef<"TrainingEvent", 'String'>
    readonly department: FieldRef<"TrainingEvent", 'String'>
    readonly duration: FieldRef<"TrainingEvent", 'String'>
    readonly capacity: FieldRef<"TrainingEvent", 'Int'>
    readonly enrolled: FieldRef<"TrainingEvent", 'Int'>
    readonly required: FieldRef<"TrainingEvent", 'Boolean'>
    readonly hospital_id: FieldRef<"TrainingEvent", 'Int'>
    readonly createdAt: FieldRef<"TrainingEvent", 'DateTime'>
    readonly updatedAt: FieldRef<"TrainingEvent", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * TrainingEvent findUnique
   */
  export type TrainingEventFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter, which TrainingEvent to fetch.
     */
    where: TrainingEventWhereUniqueInput
  }

  /**
   * TrainingEvent findUniqueOrThrow
   */
  export type TrainingEventFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter, which TrainingEvent to fetch.
     */
    where: TrainingEventWhereUniqueInput
  }

  /**
   * TrainingEvent findFirst
   */
  export type TrainingEventFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter, which TrainingEvent to fetch.
     */
    where?: TrainingEventWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TrainingEvents to fetch.
     */
    orderBy?: TrainingEventOrderByWithRelationInput | TrainingEventOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TrainingEvents.
     */
    cursor?: TrainingEventWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TrainingEvents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TrainingEvents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TrainingEvents.
     */
    distinct?: TrainingEventScalarFieldEnum | TrainingEventScalarFieldEnum[]
  }

  /**
   * TrainingEvent findFirstOrThrow
   */
  export type TrainingEventFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter, which TrainingEvent to fetch.
     */
    where?: TrainingEventWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TrainingEvents to fetch.
     */
    orderBy?: TrainingEventOrderByWithRelationInput | TrainingEventOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TrainingEvents.
     */
    cursor?: TrainingEventWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TrainingEvents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TrainingEvents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TrainingEvents.
     */
    distinct?: TrainingEventScalarFieldEnum | TrainingEventScalarFieldEnum[]
  }

  /**
   * TrainingEvent findMany
   */
  export type TrainingEventFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter, which TrainingEvents to fetch.
     */
    where?: TrainingEventWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TrainingEvents to fetch.
     */
    orderBy?: TrainingEventOrderByWithRelationInput | TrainingEventOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing TrainingEvents.
     */
    cursor?: TrainingEventWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TrainingEvents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TrainingEvents.
     */
    skip?: number
    distinct?: TrainingEventScalarFieldEnum | TrainingEventScalarFieldEnum[]
  }

  /**
   * TrainingEvent create
   */
  export type TrainingEventCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * The data needed to create a TrainingEvent.
     */
    data: XOR<TrainingEventCreateInput, TrainingEventUncheckedCreateInput>
  }

  /**
   * TrainingEvent createMany
   */
  export type TrainingEventCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many TrainingEvents.
     */
    data: TrainingEventCreateManyInput | TrainingEventCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * TrainingEvent update
   */
  export type TrainingEventUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * The data needed to update a TrainingEvent.
     */
    data: XOR<TrainingEventUpdateInput, TrainingEventUncheckedUpdateInput>
    /**
     * Choose, which TrainingEvent to update.
     */
    where: TrainingEventWhereUniqueInput
  }

  /**
   * TrainingEvent updateMany
   */
  export type TrainingEventUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update TrainingEvents.
     */
    data: XOR<TrainingEventUpdateManyMutationInput, TrainingEventUncheckedUpdateManyInput>
    /**
     * Filter which TrainingEvents to update
     */
    where?: TrainingEventWhereInput
    /**
     * Limit how many TrainingEvents to update.
     */
    limit?: number
  }

  /**
   * TrainingEvent upsert
   */
  export type TrainingEventUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * The filter to search for the TrainingEvent to update in case it exists.
     */
    where: TrainingEventWhereUniqueInput
    /**
     * In case the TrainingEvent found by the `where` argument doesn't exist, create a new TrainingEvent with this data.
     */
    create: XOR<TrainingEventCreateInput, TrainingEventUncheckedCreateInput>
    /**
     * In case the TrainingEvent was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TrainingEventUpdateInput, TrainingEventUncheckedUpdateInput>
  }

  /**
   * TrainingEvent delete
   */
  export type TrainingEventDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
    /**
     * Filter which TrainingEvent to delete.
     */
    where: TrainingEventWhereUniqueInput
  }

  /**
   * TrainingEvent deleteMany
   */
  export type TrainingEventDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TrainingEvents to delete
     */
    where?: TrainingEventWhereInput
    /**
     * Limit how many TrainingEvents to delete.
     */
    limit?: number
  }

  /**
   * TrainingEvent.hospital
   */
  export type TrainingEvent$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * TrainingEvent without action
   */
  export type TrainingEventDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TrainingEvent
     */
    select?: TrainingEventSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TrainingEvent
     */
    omit?: TrainingEventOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TrainingEventInclude<ExtArgs> | null
  }


  /**
   * Model RegulatoryDeadline
   */

  export type AggregateRegulatoryDeadline = {
    _count: RegulatoryDeadlineCountAggregateOutputType | null
    _avg: RegulatoryDeadlineAvgAggregateOutputType | null
    _sum: RegulatoryDeadlineSumAggregateOutputType | null
    _min: RegulatoryDeadlineMinAggregateOutputType | null
    _max: RegulatoryDeadlineMaxAggregateOutputType | null
  }

  export type RegulatoryDeadlineAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryDeadlineSumAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryDeadlineMinAggregateOutputType = {
    id: string | null
    title: string | null
    dueDate: Date | null
    authority: string | null
    criticalLevel: string | null
    status: string | null
    assignedTo: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryDeadlineMaxAggregateOutputType = {
    id: string | null
    title: string | null
    dueDate: Date | null
    authority: string | null
    criticalLevel: string | null
    status: string | null
    assignedTo: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryDeadlineCountAggregateOutputType = {
    id: number
    title: number
    dueDate: number
    authority: number
    criticalLevel: number
    status: number
    assignedTo: number
    description: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type RegulatoryDeadlineAvgAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryDeadlineSumAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryDeadlineMinAggregateInputType = {
    id?: true
    title?: true
    dueDate?: true
    authority?: true
    criticalLevel?: true
    status?: true
    assignedTo?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryDeadlineMaxAggregateInputType = {
    id?: true
    title?: true
    dueDate?: true
    authority?: true
    criticalLevel?: true
    status?: true
    assignedTo?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryDeadlineCountAggregateInputType = {
    id?: true
    title?: true
    dueDate?: true
    authority?: true
    criticalLevel?: true
    status?: true
    assignedTo?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type RegulatoryDeadlineAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryDeadline to aggregate.
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryDeadlines to fetch.
     */
    orderBy?: RegulatoryDeadlineOrderByWithRelationInput | RegulatoryDeadlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RegulatoryDeadlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryDeadlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryDeadlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RegulatoryDeadlines
    **/
    _count?: true | RegulatoryDeadlineCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RegulatoryDeadlineAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RegulatoryDeadlineSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RegulatoryDeadlineMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RegulatoryDeadlineMaxAggregateInputType
  }

  export type GetRegulatoryDeadlineAggregateType<T extends RegulatoryDeadlineAggregateArgs> = {
        [P in keyof T & keyof AggregateRegulatoryDeadline]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRegulatoryDeadline[P]>
      : GetScalarType<T[P], AggregateRegulatoryDeadline[P]>
  }




  export type RegulatoryDeadlineGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryDeadlineWhereInput
    orderBy?: RegulatoryDeadlineOrderByWithAggregationInput | RegulatoryDeadlineOrderByWithAggregationInput[]
    by: RegulatoryDeadlineScalarFieldEnum[] | RegulatoryDeadlineScalarFieldEnum
    having?: RegulatoryDeadlineScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RegulatoryDeadlineCountAggregateInputType | true
    _avg?: RegulatoryDeadlineAvgAggregateInputType
    _sum?: RegulatoryDeadlineSumAggregateInputType
    _min?: RegulatoryDeadlineMinAggregateInputType
    _max?: RegulatoryDeadlineMaxAggregateInputType
  }

  export type RegulatoryDeadlineGroupByOutputType = {
    id: string
    title: string
    dueDate: Date
    authority: string
    criticalLevel: string
    status: string
    assignedTo: string
    description: string
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: RegulatoryDeadlineCountAggregateOutputType | null
    _avg: RegulatoryDeadlineAvgAggregateOutputType | null
    _sum: RegulatoryDeadlineSumAggregateOutputType | null
    _min: RegulatoryDeadlineMinAggregateOutputType | null
    _max: RegulatoryDeadlineMaxAggregateOutputType | null
  }

  type GetRegulatoryDeadlineGroupByPayload<T extends RegulatoryDeadlineGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RegulatoryDeadlineGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RegulatoryDeadlineGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RegulatoryDeadlineGroupByOutputType[P]>
            : GetScalarType<T[P], RegulatoryDeadlineGroupByOutputType[P]>
        }
      >
    >


  export type RegulatoryDeadlineSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    dueDate?: boolean
    authority?: boolean
    criticalLevel?: boolean
    status?: boolean
    assignedTo?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | RegulatoryDeadline$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["regulatoryDeadline"]>



  export type RegulatoryDeadlineSelectScalar = {
    id?: boolean
    title?: boolean
    dueDate?: boolean
    authority?: boolean
    criticalLevel?: boolean
    status?: boolean
    assignedTo?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type RegulatoryDeadlineOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "dueDate" | "authority" | "criticalLevel" | "status" | "assignedTo" | "description" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["regulatoryDeadline"]>
  export type RegulatoryDeadlineInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | RegulatoryDeadline$hospitalArgs<ExtArgs>
  }

  export type $RegulatoryDeadlinePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RegulatoryDeadline"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      title: string
      dueDate: Date
      authority: string
      criticalLevel: string
      status: string
      assignedTo: string
      description: string
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["regulatoryDeadline"]>
    composites: {}
  }

  type RegulatoryDeadlineGetPayload<S extends boolean | null | undefined | RegulatoryDeadlineDefaultArgs> = $Result.GetResult<Prisma.$RegulatoryDeadlinePayload, S>

  type RegulatoryDeadlineCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RegulatoryDeadlineFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RegulatoryDeadlineCountAggregateInputType | true
    }

  export interface RegulatoryDeadlineDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RegulatoryDeadline'], meta: { name: 'RegulatoryDeadline' } }
    /**
     * Find zero or one RegulatoryDeadline that matches the filter.
     * @param {RegulatoryDeadlineFindUniqueArgs} args - Arguments to find a RegulatoryDeadline
     * @example
     * // Get one RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RegulatoryDeadlineFindUniqueArgs>(args: SelectSubset<T, RegulatoryDeadlineFindUniqueArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one RegulatoryDeadline that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RegulatoryDeadlineFindUniqueOrThrowArgs} args - Arguments to find a RegulatoryDeadline
     * @example
     * // Get one RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RegulatoryDeadlineFindUniqueOrThrowArgs>(args: SelectSubset<T, RegulatoryDeadlineFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryDeadline that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineFindFirstArgs} args - Arguments to find a RegulatoryDeadline
     * @example
     * // Get one RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RegulatoryDeadlineFindFirstArgs>(args?: SelectSubset<T, RegulatoryDeadlineFindFirstArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryDeadline that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineFindFirstOrThrowArgs} args - Arguments to find a RegulatoryDeadline
     * @example
     * // Get one RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RegulatoryDeadlineFindFirstOrThrowArgs>(args?: SelectSubset<T, RegulatoryDeadlineFindFirstOrThrowArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more RegulatoryDeadlines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RegulatoryDeadlines
     * const regulatoryDeadlines = await prisma.regulatoryDeadline.findMany()
     * 
     * // Get first 10 RegulatoryDeadlines
     * const regulatoryDeadlines = await prisma.regulatoryDeadline.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const regulatoryDeadlineWithIdOnly = await prisma.regulatoryDeadline.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RegulatoryDeadlineFindManyArgs>(args?: SelectSubset<T, RegulatoryDeadlineFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a RegulatoryDeadline.
     * @param {RegulatoryDeadlineCreateArgs} args - Arguments to create a RegulatoryDeadline.
     * @example
     * // Create one RegulatoryDeadline
     * const RegulatoryDeadline = await prisma.regulatoryDeadline.create({
     *   data: {
     *     // ... data to create a RegulatoryDeadline
     *   }
     * })
     * 
     */
    create<T extends RegulatoryDeadlineCreateArgs>(args: SelectSubset<T, RegulatoryDeadlineCreateArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many RegulatoryDeadlines.
     * @param {RegulatoryDeadlineCreateManyArgs} args - Arguments to create many RegulatoryDeadlines.
     * @example
     * // Create many RegulatoryDeadlines
     * const regulatoryDeadline = await prisma.regulatoryDeadline.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RegulatoryDeadlineCreateManyArgs>(args?: SelectSubset<T, RegulatoryDeadlineCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a RegulatoryDeadline.
     * @param {RegulatoryDeadlineDeleteArgs} args - Arguments to delete one RegulatoryDeadline.
     * @example
     * // Delete one RegulatoryDeadline
     * const RegulatoryDeadline = await prisma.regulatoryDeadline.delete({
     *   where: {
     *     // ... filter to delete one RegulatoryDeadline
     *   }
     * })
     * 
     */
    delete<T extends RegulatoryDeadlineDeleteArgs>(args: SelectSubset<T, RegulatoryDeadlineDeleteArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one RegulatoryDeadline.
     * @param {RegulatoryDeadlineUpdateArgs} args - Arguments to update one RegulatoryDeadline.
     * @example
     * // Update one RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RegulatoryDeadlineUpdateArgs>(args: SelectSubset<T, RegulatoryDeadlineUpdateArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more RegulatoryDeadlines.
     * @param {RegulatoryDeadlineDeleteManyArgs} args - Arguments to filter RegulatoryDeadlines to delete.
     * @example
     * // Delete a few RegulatoryDeadlines
     * const { count } = await prisma.regulatoryDeadline.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RegulatoryDeadlineDeleteManyArgs>(args?: SelectSubset<T, RegulatoryDeadlineDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RegulatoryDeadlines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RegulatoryDeadlines
     * const regulatoryDeadline = await prisma.regulatoryDeadline.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RegulatoryDeadlineUpdateManyArgs>(args: SelectSubset<T, RegulatoryDeadlineUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RegulatoryDeadline.
     * @param {RegulatoryDeadlineUpsertArgs} args - Arguments to update or create a RegulatoryDeadline.
     * @example
     * // Update or create a RegulatoryDeadline
     * const regulatoryDeadline = await prisma.regulatoryDeadline.upsert({
     *   create: {
     *     // ... data to create a RegulatoryDeadline
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RegulatoryDeadline we want to update
     *   }
     * })
     */
    upsert<T extends RegulatoryDeadlineUpsertArgs>(args: SelectSubset<T, RegulatoryDeadlineUpsertArgs<ExtArgs>>): Prisma__RegulatoryDeadlineClient<$Result.GetResult<Prisma.$RegulatoryDeadlinePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of RegulatoryDeadlines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineCountArgs} args - Arguments to filter RegulatoryDeadlines to count.
     * @example
     * // Count the number of RegulatoryDeadlines
     * const count = await prisma.regulatoryDeadline.count({
     *   where: {
     *     // ... the filter for the RegulatoryDeadlines we want to count
     *   }
     * })
    **/
    count<T extends RegulatoryDeadlineCountArgs>(
      args?: Subset<T, RegulatoryDeadlineCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RegulatoryDeadlineCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RegulatoryDeadline.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RegulatoryDeadlineAggregateArgs>(args: Subset<T, RegulatoryDeadlineAggregateArgs>): Prisma.PrismaPromise<GetRegulatoryDeadlineAggregateType<T>>

    /**
     * Group by RegulatoryDeadline.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryDeadlineGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RegulatoryDeadlineGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RegulatoryDeadlineGroupByArgs['orderBy'] }
        : { orderBy?: RegulatoryDeadlineGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RegulatoryDeadlineGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRegulatoryDeadlineGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RegulatoryDeadline model
   */
  readonly fields: RegulatoryDeadlineFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RegulatoryDeadline.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RegulatoryDeadlineClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends RegulatoryDeadline$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, RegulatoryDeadline$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the RegulatoryDeadline model
   */
  interface RegulatoryDeadlineFieldRefs {
    readonly id: FieldRef<"RegulatoryDeadline", 'String'>
    readonly title: FieldRef<"RegulatoryDeadline", 'String'>
    readonly dueDate: FieldRef<"RegulatoryDeadline", 'DateTime'>
    readonly authority: FieldRef<"RegulatoryDeadline", 'String'>
    readonly criticalLevel: FieldRef<"RegulatoryDeadline", 'String'>
    readonly status: FieldRef<"RegulatoryDeadline", 'String'>
    readonly assignedTo: FieldRef<"RegulatoryDeadline", 'String'>
    readonly description: FieldRef<"RegulatoryDeadline", 'String'>
    readonly hospital_id: FieldRef<"RegulatoryDeadline", 'Int'>
    readonly createdAt: FieldRef<"RegulatoryDeadline", 'DateTime'>
    readonly updatedAt: FieldRef<"RegulatoryDeadline", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * RegulatoryDeadline findUnique
   */
  export type RegulatoryDeadlineFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryDeadline to fetch.
     */
    where: RegulatoryDeadlineWhereUniqueInput
  }

  /**
   * RegulatoryDeadline findUniqueOrThrow
   */
  export type RegulatoryDeadlineFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryDeadline to fetch.
     */
    where: RegulatoryDeadlineWhereUniqueInput
  }

  /**
   * RegulatoryDeadline findFirst
   */
  export type RegulatoryDeadlineFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryDeadline to fetch.
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryDeadlines to fetch.
     */
    orderBy?: RegulatoryDeadlineOrderByWithRelationInput | RegulatoryDeadlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryDeadlines.
     */
    cursor?: RegulatoryDeadlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryDeadlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryDeadlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryDeadlines.
     */
    distinct?: RegulatoryDeadlineScalarFieldEnum | RegulatoryDeadlineScalarFieldEnum[]
  }

  /**
   * RegulatoryDeadline findFirstOrThrow
   */
  export type RegulatoryDeadlineFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryDeadline to fetch.
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryDeadlines to fetch.
     */
    orderBy?: RegulatoryDeadlineOrderByWithRelationInput | RegulatoryDeadlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryDeadlines.
     */
    cursor?: RegulatoryDeadlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryDeadlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryDeadlines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryDeadlines.
     */
    distinct?: RegulatoryDeadlineScalarFieldEnum | RegulatoryDeadlineScalarFieldEnum[]
  }

  /**
   * RegulatoryDeadline findMany
   */
  export type RegulatoryDeadlineFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryDeadlines to fetch.
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryDeadlines to fetch.
     */
    orderBy?: RegulatoryDeadlineOrderByWithRelationInput | RegulatoryDeadlineOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RegulatoryDeadlines.
     */
    cursor?: RegulatoryDeadlineWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryDeadlines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryDeadlines.
     */
    skip?: number
    distinct?: RegulatoryDeadlineScalarFieldEnum | RegulatoryDeadlineScalarFieldEnum[]
  }

  /**
   * RegulatoryDeadline create
   */
  export type RegulatoryDeadlineCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * The data needed to create a RegulatoryDeadline.
     */
    data: XOR<RegulatoryDeadlineCreateInput, RegulatoryDeadlineUncheckedCreateInput>
  }

  /**
   * RegulatoryDeadline createMany
   */
  export type RegulatoryDeadlineCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RegulatoryDeadlines.
     */
    data: RegulatoryDeadlineCreateManyInput | RegulatoryDeadlineCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RegulatoryDeadline update
   */
  export type RegulatoryDeadlineUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * The data needed to update a RegulatoryDeadline.
     */
    data: XOR<RegulatoryDeadlineUpdateInput, RegulatoryDeadlineUncheckedUpdateInput>
    /**
     * Choose, which RegulatoryDeadline to update.
     */
    where: RegulatoryDeadlineWhereUniqueInput
  }

  /**
   * RegulatoryDeadline updateMany
   */
  export type RegulatoryDeadlineUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RegulatoryDeadlines.
     */
    data: XOR<RegulatoryDeadlineUpdateManyMutationInput, RegulatoryDeadlineUncheckedUpdateManyInput>
    /**
     * Filter which RegulatoryDeadlines to update
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * Limit how many RegulatoryDeadlines to update.
     */
    limit?: number
  }

  /**
   * RegulatoryDeadline upsert
   */
  export type RegulatoryDeadlineUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * The filter to search for the RegulatoryDeadline to update in case it exists.
     */
    where: RegulatoryDeadlineWhereUniqueInput
    /**
     * In case the RegulatoryDeadline found by the `where` argument doesn't exist, create a new RegulatoryDeadline with this data.
     */
    create: XOR<RegulatoryDeadlineCreateInput, RegulatoryDeadlineUncheckedCreateInput>
    /**
     * In case the RegulatoryDeadline was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RegulatoryDeadlineUpdateInput, RegulatoryDeadlineUncheckedUpdateInput>
  }

  /**
   * RegulatoryDeadline delete
   */
  export type RegulatoryDeadlineDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
    /**
     * Filter which RegulatoryDeadline to delete.
     */
    where: RegulatoryDeadlineWhereUniqueInput
  }

  /**
   * RegulatoryDeadline deleteMany
   */
  export type RegulatoryDeadlineDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryDeadlines to delete
     */
    where?: RegulatoryDeadlineWhereInput
    /**
     * Limit how many RegulatoryDeadlines to delete.
     */
    limit?: number
  }

  /**
   * RegulatoryDeadline.hospital
   */
  export type RegulatoryDeadline$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * RegulatoryDeadline without action
   */
  export type RegulatoryDeadlineDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryDeadline
     */
    select?: RegulatoryDeadlineSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryDeadline
     */
    omit?: RegulatoryDeadlineOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryDeadlineInclude<ExtArgs> | null
  }


  /**
   * Model ResourceAllocation
   */

  export type AggregateResourceAllocation = {
    _count: ResourceAllocationCountAggregateOutputType | null
    _avg: ResourceAllocationAvgAggregateOutputType | null
    _sum: ResourceAllocationSumAggregateOutputType | null
    _min: ResourceAllocationMinAggregateOutputType | null
    _max: ResourceAllocationMaxAggregateOutputType | null
  }

  export type ResourceAllocationAvgAggregateOutputType = {
    utilizationPercentage: number | null
    hospital_id: number | null
  }

  export type ResourceAllocationSumAggregateOutputType = {
    utilizationPercentage: number | null
    hospital_id: number | null
  }

  export type ResourceAllocationMinAggregateOutputType = {
    id: string | null
    resourceName: string | null
    role: string | null
    allocatedTo: string | null
    startDate: Date | null
    endDate: Date | null
    utilizationPercentage: number | null
    department: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type ResourceAllocationMaxAggregateOutputType = {
    id: string | null
    resourceName: string | null
    role: string | null
    allocatedTo: string | null
    startDate: Date | null
    endDate: Date | null
    utilizationPercentage: number | null
    department: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type ResourceAllocationCountAggregateOutputType = {
    id: number
    resourceName: number
    role: number
    allocatedTo: number
    startDate: number
    endDate: number
    utilizationPercentage: number
    department: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type ResourceAllocationAvgAggregateInputType = {
    utilizationPercentage?: true
    hospital_id?: true
  }

  export type ResourceAllocationSumAggregateInputType = {
    utilizationPercentage?: true
    hospital_id?: true
  }

  export type ResourceAllocationMinAggregateInputType = {
    id?: true
    resourceName?: true
    role?: true
    allocatedTo?: true
    startDate?: true
    endDate?: true
    utilizationPercentage?: true
    department?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type ResourceAllocationMaxAggregateInputType = {
    id?: true
    resourceName?: true
    role?: true
    allocatedTo?: true
    startDate?: true
    endDate?: true
    utilizationPercentage?: true
    department?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type ResourceAllocationCountAggregateInputType = {
    id?: true
    resourceName?: true
    role?: true
    allocatedTo?: true
    startDate?: true
    endDate?: true
    utilizationPercentage?: true
    department?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type ResourceAllocationAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ResourceAllocation to aggregate.
     */
    where?: ResourceAllocationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResourceAllocations to fetch.
     */
    orderBy?: ResourceAllocationOrderByWithRelationInput | ResourceAllocationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ResourceAllocationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResourceAllocations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResourceAllocations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ResourceAllocations
    **/
    _count?: true | ResourceAllocationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ResourceAllocationAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ResourceAllocationSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ResourceAllocationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ResourceAllocationMaxAggregateInputType
  }

  export type GetResourceAllocationAggregateType<T extends ResourceAllocationAggregateArgs> = {
        [P in keyof T & keyof AggregateResourceAllocation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateResourceAllocation[P]>
      : GetScalarType<T[P], AggregateResourceAllocation[P]>
  }




  export type ResourceAllocationGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ResourceAllocationWhereInput
    orderBy?: ResourceAllocationOrderByWithAggregationInput | ResourceAllocationOrderByWithAggregationInput[]
    by: ResourceAllocationScalarFieldEnum[] | ResourceAllocationScalarFieldEnum
    having?: ResourceAllocationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ResourceAllocationCountAggregateInputType | true
    _avg?: ResourceAllocationAvgAggregateInputType
    _sum?: ResourceAllocationSumAggregateInputType
    _min?: ResourceAllocationMinAggregateInputType
    _max?: ResourceAllocationMaxAggregateInputType
  }

  export type ResourceAllocationGroupByOutputType = {
    id: string
    resourceName: string
    role: string
    allocatedTo: string
    startDate: Date
    endDate: Date
    utilizationPercentage: number
    department: string
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: ResourceAllocationCountAggregateOutputType | null
    _avg: ResourceAllocationAvgAggregateOutputType | null
    _sum: ResourceAllocationSumAggregateOutputType | null
    _min: ResourceAllocationMinAggregateOutputType | null
    _max: ResourceAllocationMaxAggregateOutputType | null
  }

  type GetResourceAllocationGroupByPayload<T extends ResourceAllocationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ResourceAllocationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ResourceAllocationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ResourceAllocationGroupByOutputType[P]>
            : GetScalarType<T[P], ResourceAllocationGroupByOutputType[P]>
        }
      >
    >


  export type ResourceAllocationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    resourceName?: boolean
    role?: boolean
    allocatedTo?: boolean
    startDate?: boolean
    endDate?: boolean
    utilizationPercentage?: boolean
    department?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | ResourceAllocation$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["resourceAllocation"]>



  export type ResourceAllocationSelectScalar = {
    id?: boolean
    resourceName?: boolean
    role?: boolean
    allocatedTo?: boolean
    startDate?: boolean
    endDate?: boolean
    utilizationPercentage?: boolean
    department?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type ResourceAllocationOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "resourceName" | "role" | "allocatedTo" | "startDate" | "endDate" | "utilizationPercentage" | "department" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["resourceAllocation"]>
  export type ResourceAllocationInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | ResourceAllocation$hospitalArgs<ExtArgs>
  }

  export type $ResourceAllocationPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ResourceAllocation"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      resourceName: string
      role: string
      allocatedTo: string
      startDate: Date
      endDate: Date
      utilizationPercentage: number
      department: string
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["resourceAllocation"]>
    composites: {}
  }

  type ResourceAllocationGetPayload<S extends boolean | null | undefined | ResourceAllocationDefaultArgs> = $Result.GetResult<Prisma.$ResourceAllocationPayload, S>

  type ResourceAllocationCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ResourceAllocationFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ResourceAllocationCountAggregateInputType | true
    }

  export interface ResourceAllocationDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ResourceAllocation'], meta: { name: 'ResourceAllocation' } }
    /**
     * Find zero or one ResourceAllocation that matches the filter.
     * @param {ResourceAllocationFindUniqueArgs} args - Arguments to find a ResourceAllocation
     * @example
     * // Get one ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ResourceAllocationFindUniqueArgs>(args: SelectSubset<T, ResourceAllocationFindUniqueArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one ResourceAllocation that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ResourceAllocationFindUniqueOrThrowArgs} args - Arguments to find a ResourceAllocation
     * @example
     * // Get one ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ResourceAllocationFindUniqueOrThrowArgs>(args: SelectSubset<T, ResourceAllocationFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ResourceAllocation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationFindFirstArgs} args - Arguments to find a ResourceAllocation
     * @example
     * // Get one ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ResourceAllocationFindFirstArgs>(args?: SelectSubset<T, ResourceAllocationFindFirstArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ResourceAllocation that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationFindFirstOrThrowArgs} args - Arguments to find a ResourceAllocation
     * @example
     * // Get one ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ResourceAllocationFindFirstOrThrowArgs>(args?: SelectSubset<T, ResourceAllocationFindFirstOrThrowArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more ResourceAllocations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ResourceAllocations
     * const resourceAllocations = await prisma.resourceAllocation.findMany()
     * 
     * // Get first 10 ResourceAllocations
     * const resourceAllocations = await prisma.resourceAllocation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const resourceAllocationWithIdOnly = await prisma.resourceAllocation.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ResourceAllocationFindManyArgs>(args?: SelectSubset<T, ResourceAllocationFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a ResourceAllocation.
     * @param {ResourceAllocationCreateArgs} args - Arguments to create a ResourceAllocation.
     * @example
     * // Create one ResourceAllocation
     * const ResourceAllocation = await prisma.resourceAllocation.create({
     *   data: {
     *     // ... data to create a ResourceAllocation
     *   }
     * })
     * 
     */
    create<T extends ResourceAllocationCreateArgs>(args: SelectSubset<T, ResourceAllocationCreateArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many ResourceAllocations.
     * @param {ResourceAllocationCreateManyArgs} args - Arguments to create many ResourceAllocations.
     * @example
     * // Create many ResourceAllocations
     * const resourceAllocation = await prisma.resourceAllocation.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ResourceAllocationCreateManyArgs>(args?: SelectSubset<T, ResourceAllocationCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ResourceAllocation.
     * @param {ResourceAllocationDeleteArgs} args - Arguments to delete one ResourceAllocation.
     * @example
     * // Delete one ResourceAllocation
     * const ResourceAllocation = await prisma.resourceAllocation.delete({
     *   where: {
     *     // ... filter to delete one ResourceAllocation
     *   }
     * })
     * 
     */
    delete<T extends ResourceAllocationDeleteArgs>(args: SelectSubset<T, ResourceAllocationDeleteArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one ResourceAllocation.
     * @param {ResourceAllocationUpdateArgs} args - Arguments to update one ResourceAllocation.
     * @example
     * // Update one ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ResourceAllocationUpdateArgs>(args: SelectSubset<T, ResourceAllocationUpdateArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more ResourceAllocations.
     * @param {ResourceAllocationDeleteManyArgs} args - Arguments to filter ResourceAllocations to delete.
     * @example
     * // Delete a few ResourceAllocations
     * const { count } = await prisma.resourceAllocation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ResourceAllocationDeleteManyArgs>(args?: SelectSubset<T, ResourceAllocationDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ResourceAllocations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ResourceAllocations
     * const resourceAllocation = await prisma.resourceAllocation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ResourceAllocationUpdateManyArgs>(args: SelectSubset<T, ResourceAllocationUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ResourceAllocation.
     * @param {ResourceAllocationUpsertArgs} args - Arguments to update or create a ResourceAllocation.
     * @example
     * // Update or create a ResourceAllocation
     * const resourceAllocation = await prisma.resourceAllocation.upsert({
     *   create: {
     *     // ... data to create a ResourceAllocation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ResourceAllocation we want to update
     *   }
     * })
     */
    upsert<T extends ResourceAllocationUpsertArgs>(args: SelectSubset<T, ResourceAllocationUpsertArgs<ExtArgs>>): Prisma__ResourceAllocationClient<$Result.GetResult<Prisma.$ResourceAllocationPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of ResourceAllocations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationCountArgs} args - Arguments to filter ResourceAllocations to count.
     * @example
     * // Count the number of ResourceAllocations
     * const count = await prisma.resourceAllocation.count({
     *   where: {
     *     // ... the filter for the ResourceAllocations we want to count
     *   }
     * })
    **/
    count<T extends ResourceAllocationCountArgs>(
      args?: Subset<T, ResourceAllocationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ResourceAllocationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ResourceAllocation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ResourceAllocationAggregateArgs>(args: Subset<T, ResourceAllocationAggregateArgs>): Prisma.PrismaPromise<GetResourceAllocationAggregateType<T>>

    /**
     * Group by ResourceAllocation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ResourceAllocationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ResourceAllocationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ResourceAllocationGroupByArgs['orderBy'] }
        : { orderBy?: ResourceAllocationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ResourceAllocationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetResourceAllocationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ResourceAllocation model
   */
  readonly fields: ResourceAllocationFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ResourceAllocation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ResourceAllocationClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends ResourceAllocation$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, ResourceAllocation$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ResourceAllocation model
   */
  interface ResourceAllocationFieldRefs {
    readonly id: FieldRef<"ResourceAllocation", 'String'>
    readonly resourceName: FieldRef<"ResourceAllocation", 'String'>
    readonly role: FieldRef<"ResourceAllocation", 'String'>
    readonly allocatedTo: FieldRef<"ResourceAllocation", 'String'>
    readonly startDate: FieldRef<"ResourceAllocation", 'DateTime'>
    readonly endDate: FieldRef<"ResourceAllocation", 'DateTime'>
    readonly utilizationPercentage: FieldRef<"ResourceAllocation", 'Int'>
    readonly department: FieldRef<"ResourceAllocation", 'String'>
    readonly hospital_id: FieldRef<"ResourceAllocation", 'Int'>
    readonly createdAt: FieldRef<"ResourceAllocation", 'DateTime'>
    readonly updatedAt: FieldRef<"ResourceAllocation", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ResourceAllocation findUnique
   */
  export type ResourceAllocationFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter, which ResourceAllocation to fetch.
     */
    where: ResourceAllocationWhereUniqueInput
  }

  /**
   * ResourceAllocation findUniqueOrThrow
   */
  export type ResourceAllocationFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter, which ResourceAllocation to fetch.
     */
    where: ResourceAllocationWhereUniqueInput
  }

  /**
   * ResourceAllocation findFirst
   */
  export type ResourceAllocationFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter, which ResourceAllocation to fetch.
     */
    where?: ResourceAllocationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResourceAllocations to fetch.
     */
    orderBy?: ResourceAllocationOrderByWithRelationInput | ResourceAllocationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ResourceAllocations.
     */
    cursor?: ResourceAllocationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResourceAllocations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResourceAllocations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ResourceAllocations.
     */
    distinct?: ResourceAllocationScalarFieldEnum | ResourceAllocationScalarFieldEnum[]
  }

  /**
   * ResourceAllocation findFirstOrThrow
   */
  export type ResourceAllocationFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter, which ResourceAllocation to fetch.
     */
    where?: ResourceAllocationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResourceAllocations to fetch.
     */
    orderBy?: ResourceAllocationOrderByWithRelationInput | ResourceAllocationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ResourceAllocations.
     */
    cursor?: ResourceAllocationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResourceAllocations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResourceAllocations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ResourceAllocations.
     */
    distinct?: ResourceAllocationScalarFieldEnum | ResourceAllocationScalarFieldEnum[]
  }

  /**
   * ResourceAllocation findMany
   */
  export type ResourceAllocationFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter, which ResourceAllocations to fetch.
     */
    where?: ResourceAllocationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ResourceAllocations to fetch.
     */
    orderBy?: ResourceAllocationOrderByWithRelationInput | ResourceAllocationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ResourceAllocations.
     */
    cursor?: ResourceAllocationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ResourceAllocations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ResourceAllocations.
     */
    skip?: number
    distinct?: ResourceAllocationScalarFieldEnum | ResourceAllocationScalarFieldEnum[]
  }

  /**
   * ResourceAllocation create
   */
  export type ResourceAllocationCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * The data needed to create a ResourceAllocation.
     */
    data: XOR<ResourceAllocationCreateInput, ResourceAllocationUncheckedCreateInput>
  }

  /**
   * ResourceAllocation createMany
   */
  export type ResourceAllocationCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ResourceAllocations.
     */
    data: ResourceAllocationCreateManyInput | ResourceAllocationCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ResourceAllocation update
   */
  export type ResourceAllocationUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * The data needed to update a ResourceAllocation.
     */
    data: XOR<ResourceAllocationUpdateInput, ResourceAllocationUncheckedUpdateInput>
    /**
     * Choose, which ResourceAllocation to update.
     */
    where: ResourceAllocationWhereUniqueInput
  }

  /**
   * ResourceAllocation updateMany
   */
  export type ResourceAllocationUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ResourceAllocations.
     */
    data: XOR<ResourceAllocationUpdateManyMutationInput, ResourceAllocationUncheckedUpdateManyInput>
    /**
     * Filter which ResourceAllocations to update
     */
    where?: ResourceAllocationWhereInput
    /**
     * Limit how many ResourceAllocations to update.
     */
    limit?: number
  }

  /**
   * ResourceAllocation upsert
   */
  export type ResourceAllocationUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * The filter to search for the ResourceAllocation to update in case it exists.
     */
    where: ResourceAllocationWhereUniqueInput
    /**
     * In case the ResourceAllocation found by the `where` argument doesn't exist, create a new ResourceAllocation with this data.
     */
    create: XOR<ResourceAllocationCreateInput, ResourceAllocationUncheckedCreateInput>
    /**
     * In case the ResourceAllocation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ResourceAllocationUpdateInput, ResourceAllocationUncheckedUpdateInput>
  }

  /**
   * ResourceAllocation delete
   */
  export type ResourceAllocationDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
    /**
     * Filter which ResourceAllocation to delete.
     */
    where: ResourceAllocationWhereUniqueInput
  }

  /**
   * ResourceAllocation deleteMany
   */
  export type ResourceAllocationDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ResourceAllocations to delete
     */
    where?: ResourceAllocationWhereInput
    /**
     * Limit how many ResourceAllocations to delete.
     */
    limit?: number
  }

  /**
   * ResourceAllocation.hospital
   */
  export type ResourceAllocation$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * ResourceAllocation without action
   */
  export type ResourceAllocationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ResourceAllocation
     */
    select?: ResourceAllocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ResourceAllocation
     */
    omit?: ResourceAllocationOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ResourceAllocationInclude<ExtArgs> | null
  }


  /**
   * Model DocumentCategory
   */

  export type AggregateDocumentCategory = {
    _count: DocumentCategoryCountAggregateOutputType | null
    _avg: DocumentCategoryAvgAggregateOutputType | null
    _sum: DocumentCategorySumAggregateOutputType | null
    _min: DocumentCategoryMinAggregateOutputType | null
    _max: DocumentCategoryMaxAggregateOutputType | null
  }

  export type DocumentCategoryAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type DocumentCategorySumAggregateOutputType = {
    hospital_id: number | null
  }

  export type DocumentCategoryMinAggregateOutputType = {
    id: string | null
    name: string | null
    icon: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DocumentCategoryMaxAggregateOutputType = {
    id: string | null
    name: string | null
    icon: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DocumentCategoryCountAggregateOutputType = {
    id: number
    name: number
    icon: number
    description: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type DocumentCategoryAvgAggregateInputType = {
    hospital_id?: true
  }

  export type DocumentCategorySumAggregateInputType = {
    hospital_id?: true
  }

  export type DocumentCategoryMinAggregateInputType = {
    id?: true
    name?: true
    icon?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DocumentCategoryMaxAggregateInputType = {
    id?: true
    name?: true
    icon?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DocumentCategoryCountAggregateInputType = {
    id?: true
    name?: true
    icon?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type DocumentCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which DocumentCategory to aggregate.
     */
    where?: DocumentCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentCategories to fetch.
     */
    orderBy?: DocumentCategoryOrderByWithRelationInput | DocumentCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DocumentCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned DocumentCategories
    **/
    _count?: true | DocumentCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DocumentCategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DocumentCategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DocumentCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DocumentCategoryMaxAggregateInputType
  }

  export type GetDocumentCategoryAggregateType<T extends DocumentCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateDocumentCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDocumentCategory[P]>
      : GetScalarType<T[P], AggregateDocumentCategory[P]>
  }




  export type DocumentCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentCategoryWhereInput
    orderBy?: DocumentCategoryOrderByWithAggregationInput | DocumentCategoryOrderByWithAggregationInput[]
    by: DocumentCategoryScalarFieldEnum[] | DocumentCategoryScalarFieldEnum
    having?: DocumentCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DocumentCategoryCountAggregateInputType | true
    _avg?: DocumentCategoryAvgAggregateInputType
    _sum?: DocumentCategorySumAggregateInputType
    _min?: DocumentCategoryMinAggregateInputType
    _max?: DocumentCategoryMaxAggregateInputType
  }

  export type DocumentCategoryGroupByOutputType = {
    id: string
    name: string
    icon: string
    description: string
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: DocumentCategoryCountAggregateOutputType | null
    _avg: DocumentCategoryAvgAggregateOutputType | null
    _sum: DocumentCategorySumAggregateOutputType | null
    _min: DocumentCategoryMinAggregateOutputType | null
    _max: DocumentCategoryMaxAggregateOutputType | null
  }

  type GetDocumentCategoryGroupByPayload<T extends DocumentCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DocumentCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DocumentCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DocumentCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], DocumentCategoryGroupByOutputType[P]>
        }
      >
    >


  export type DocumentCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    icon?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | DocumentCategory$hospitalArgs<ExtArgs>
    documents?: boolean | DocumentCategory$documentsArgs<ExtArgs>
    _count?: boolean | DocumentCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["documentCategory"]>



  export type DocumentCategorySelectScalar = {
    id?: boolean
    name?: boolean
    icon?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type DocumentCategoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "icon" | "description" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["documentCategory"]>
  export type DocumentCategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | DocumentCategory$hospitalArgs<ExtArgs>
    documents?: boolean | DocumentCategory$documentsArgs<ExtArgs>
    _count?: boolean | DocumentCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }

  export type $DocumentCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "DocumentCategory"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
      documents: Prisma.$DocumentPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      icon: string
      description: string
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["documentCategory"]>
    composites: {}
  }

  type DocumentCategoryGetPayload<S extends boolean | null | undefined | DocumentCategoryDefaultArgs> = $Result.GetResult<Prisma.$DocumentCategoryPayload, S>

  type DocumentCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<DocumentCategoryFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: DocumentCategoryCountAggregateInputType | true
    }

  export interface DocumentCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['DocumentCategory'], meta: { name: 'DocumentCategory' } }
    /**
     * Find zero or one DocumentCategory that matches the filter.
     * @param {DocumentCategoryFindUniqueArgs} args - Arguments to find a DocumentCategory
     * @example
     * // Get one DocumentCategory
     * const documentCategory = await prisma.documentCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends DocumentCategoryFindUniqueArgs>(args: SelectSubset<T, DocumentCategoryFindUniqueArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one DocumentCategory that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {DocumentCategoryFindUniqueOrThrowArgs} args - Arguments to find a DocumentCategory
     * @example
     * // Get one DocumentCategory
     * const documentCategory = await prisma.documentCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends DocumentCategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, DocumentCategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first DocumentCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryFindFirstArgs} args - Arguments to find a DocumentCategory
     * @example
     * // Get one DocumentCategory
     * const documentCategory = await prisma.documentCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends DocumentCategoryFindFirstArgs>(args?: SelectSubset<T, DocumentCategoryFindFirstArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first DocumentCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryFindFirstOrThrowArgs} args - Arguments to find a DocumentCategory
     * @example
     * // Get one DocumentCategory
     * const documentCategory = await prisma.documentCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends DocumentCategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, DocumentCategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more DocumentCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all DocumentCategories
     * const documentCategories = await prisma.documentCategory.findMany()
     * 
     * // Get first 10 DocumentCategories
     * const documentCategories = await prisma.documentCategory.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const documentCategoryWithIdOnly = await prisma.documentCategory.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends DocumentCategoryFindManyArgs>(args?: SelectSubset<T, DocumentCategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a DocumentCategory.
     * @param {DocumentCategoryCreateArgs} args - Arguments to create a DocumentCategory.
     * @example
     * // Create one DocumentCategory
     * const DocumentCategory = await prisma.documentCategory.create({
     *   data: {
     *     // ... data to create a DocumentCategory
     *   }
     * })
     * 
     */
    create<T extends DocumentCategoryCreateArgs>(args: SelectSubset<T, DocumentCategoryCreateArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many DocumentCategories.
     * @param {DocumentCategoryCreateManyArgs} args - Arguments to create many DocumentCategories.
     * @example
     * // Create many DocumentCategories
     * const documentCategory = await prisma.documentCategory.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends DocumentCategoryCreateManyArgs>(args?: SelectSubset<T, DocumentCategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a DocumentCategory.
     * @param {DocumentCategoryDeleteArgs} args - Arguments to delete one DocumentCategory.
     * @example
     * // Delete one DocumentCategory
     * const DocumentCategory = await prisma.documentCategory.delete({
     *   where: {
     *     // ... filter to delete one DocumentCategory
     *   }
     * })
     * 
     */
    delete<T extends DocumentCategoryDeleteArgs>(args: SelectSubset<T, DocumentCategoryDeleteArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one DocumentCategory.
     * @param {DocumentCategoryUpdateArgs} args - Arguments to update one DocumentCategory.
     * @example
     * // Update one DocumentCategory
     * const documentCategory = await prisma.documentCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends DocumentCategoryUpdateArgs>(args: SelectSubset<T, DocumentCategoryUpdateArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more DocumentCategories.
     * @param {DocumentCategoryDeleteManyArgs} args - Arguments to filter DocumentCategories to delete.
     * @example
     * // Delete a few DocumentCategories
     * const { count } = await prisma.documentCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends DocumentCategoryDeleteManyArgs>(args?: SelectSubset<T, DocumentCategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more DocumentCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many DocumentCategories
     * const documentCategory = await prisma.documentCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends DocumentCategoryUpdateManyArgs>(args: SelectSubset<T, DocumentCategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one DocumentCategory.
     * @param {DocumentCategoryUpsertArgs} args - Arguments to update or create a DocumentCategory.
     * @example
     * // Update or create a DocumentCategory
     * const documentCategory = await prisma.documentCategory.upsert({
     *   create: {
     *     // ... data to create a DocumentCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the DocumentCategory we want to update
     *   }
     * })
     */
    upsert<T extends DocumentCategoryUpsertArgs>(args: SelectSubset<T, DocumentCategoryUpsertArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of DocumentCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryCountArgs} args - Arguments to filter DocumentCategories to count.
     * @example
     * // Count the number of DocumentCategories
     * const count = await prisma.documentCategory.count({
     *   where: {
     *     // ... the filter for the DocumentCategories we want to count
     *   }
     * })
    **/
    count<T extends DocumentCategoryCountArgs>(
      args?: Subset<T, DocumentCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DocumentCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a DocumentCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DocumentCategoryAggregateArgs>(args: Subset<T, DocumentCategoryAggregateArgs>): Prisma.PrismaPromise<GetDocumentCategoryAggregateType<T>>

    /**
     * Group by DocumentCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DocumentCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DocumentCategoryGroupByArgs['orderBy'] }
        : { orderBy?: DocumentCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DocumentCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDocumentCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the DocumentCategory model
   */
  readonly fields: DocumentCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for DocumentCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DocumentCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends DocumentCategory$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, DocumentCategory$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    documents<T extends DocumentCategory$documentsArgs<ExtArgs> = {}>(args?: Subset<T, DocumentCategory$documentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the DocumentCategory model
   */
  interface DocumentCategoryFieldRefs {
    readonly id: FieldRef<"DocumentCategory", 'String'>
    readonly name: FieldRef<"DocumentCategory", 'String'>
    readonly icon: FieldRef<"DocumentCategory", 'String'>
    readonly description: FieldRef<"DocumentCategory", 'String'>
    readonly hospital_id: FieldRef<"DocumentCategory", 'Int'>
    readonly createdAt: FieldRef<"DocumentCategory", 'DateTime'>
    readonly updatedAt: FieldRef<"DocumentCategory", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * DocumentCategory findUnique
   */
  export type DocumentCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter, which DocumentCategory to fetch.
     */
    where: DocumentCategoryWhereUniqueInput
  }

  /**
   * DocumentCategory findUniqueOrThrow
   */
  export type DocumentCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter, which DocumentCategory to fetch.
     */
    where: DocumentCategoryWhereUniqueInput
  }

  /**
   * DocumentCategory findFirst
   */
  export type DocumentCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter, which DocumentCategory to fetch.
     */
    where?: DocumentCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentCategories to fetch.
     */
    orderBy?: DocumentCategoryOrderByWithRelationInput | DocumentCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for DocumentCategories.
     */
    cursor?: DocumentCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of DocumentCategories.
     */
    distinct?: DocumentCategoryScalarFieldEnum | DocumentCategoryScalarFieldEnum[]
  }

  /**
   * DocumentCategory findFirstOrThrow
   */
  export type DocumentCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter, which DocumentCategory to fetch.
     */
    where?: DocumentCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentCategories to fetch.
     */
    orderBy?: DocumentCategoryOrderByWithRelationInput | DocumentCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for DocumentCategories.
     */
    cursor?: DocumentCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of DocumentCategories.
     */
    distinct?: DocumentCategoryScalarFieldEnum | DocumentCategoryScalarFieldEnum[]
  }

  /**
   * DocumentCategory findMany
   */
  export type DocumentCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter, which DocumentCategories to fetch.
     */
    where?: DocumentCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of DocumentCategories to fetch.
     */
    orderBy?: DocumentCategoryOrderByWithRelationInput | DocumentCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing DocumentCategories.
     */
    cursor?: DocumentCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` DocumentCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` DocumentCategories.
     */
    skip?: number
    distinct?: DocumentCategoryScalarFieldEnum | DocumentCategoryScalarFieldEnum[]
  }

  /**
   * DocumentCategory create
   */
  export type DocumentCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a DocumentCategory.
     */
    data: XOR<DocumentCategoryCreateInput, DocumentCategoryUncheckedCreateInput>
  }

  /**
   * DocumentCategory createMany
   */
  export type DocumentCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many DocumentCategories.
     */
    data: DocumentCategoryCreateManyInput | DocumentCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * DocumentCategory update
   */
  export type DocumentCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a DocumentCategory.
     */
    data: XOR<DocumentCategoryUpdateInput, DocumentCategoryUncheckedUpdateInput>
    /**
     * Choose, which DocumentCategory to update.
     */
    where: DocumentCategoryWhereUniqueInput
  }

  /**
   * DocumentCategory updateMany
   */
  export type DocumentCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update DocumentCategories.
     */
    data: XOR<DocumentCategoryUpdateManyMutationInput, DocumentCategoryUncheckedUpdateManyInput>
    /**
     * Filter which DocumentCategories to update
     */
    where?: DocumentCategoryWhereInput
    /**
     * Limit how many DocumentCategories to update.
     */
    limit?: number
  }

  /**
   * DocumentCategory upsert
   */
  export type DocumentCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the DocumentCategory to update in case it exists.
     */
    where: DocumentCategoryWhereUniqueInput
    /**
     * In case the DocumentCategory found by the `where` argument doesn't exist, create a new DocumentCategory with this data.
     */
    create: XOR<DocumentCategoryCreateInput, DocumentCategoryUncheckedCreateInput>
    /**
     * In case the DocumentCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DocumentCategoryUpdateInput, DocumentCategoryUncheckedUpdateInput>
  }

  /**
   * DocumentCategory delete
   */
  export type DocumentCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
    /**
     * Filter which DocumentCategory to delete.
     */
    where: DocumentCategoryWhereUniqueInput
  }

  /**
   * DocumentCategory deleteMany
   */
  export type DocumentCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which DocumentCategories to delete
     */
    where?: DocumentCategoryWhereInput
    /**
     * Limit how many DocumentCategories to delete.
     */
    limit?: number
  }

  /**
   * DocumentCategory.hospital
   */
  export type DocumentCategory$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * DocumentCategory.documents
   */
  export type DocumentCategory$documentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    where?: DocumentWhereInput
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    cursor?: DocumentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DocumentScalarFieldEnum | DocumentScalarFieldEnum[]
  }

  /**
   * DocumentCategory without action
   */
  export type DocumentCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DocumentCategory
     */
    select?: DocumentCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the DocumentCategory
     */
    omit?: DocumentCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentCategoryInclude<ExtArgs> | null
  }


  /**
   * Model Document
   */

  export type AggregateDocument = {
    _count: DocumentCountAggregateOutputType | null
    _avg: DocumentAvgAggregateOutputType | null
    _sum: DocumentSumAggregateOutputType | null
    _min: DocumentMinAggregateOutputType | null
    _max: DocumentMaxAggregateOutputType | null
  }

  export type DocumentAvgAggregateOutputType = {
    fileSize: number | null
    hospital_id: number | null
  }

  export type DocumentSumAggregateOutputType = {
    fileSize: number | null
    hospital_id: number | null
  }

  export type DocumentMinAggregateOutputType = {
    id: string | null
    title: string | null
    fileName: string | null
    fileUrl: string | null
    fileSize: number | null
    fileType: string | null
    status: string | null
    department: string | null
    updatedBy: string | null
    category_id: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DocumentMaxAggregateOutputType = {
    id: string | null
    title: string | null
    fileName: string | null
    fileUrl: string | null
    fileSize: number | null
    fileType: string | null
    status: string | null
    department: string | null
    updatedBy: string | null
    category_id: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DocumentCountAggregateOutputType = {
    id: number
    title: number
    fileName: number
    fileUrl: number
    fileSize: number
    fileType: number
    status: number
    department: number
    updatedBy: number
    category_id: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type DocumentAvgAggregateInputType = {
    fileSize?: true
    hospital_id?: true
  }

  export type DocumentSumAggregateInputType = {
    fileSize?: true
    hospital_id?: true
  }

  export type DocumentMinAggregateInputType = {
    id?: true
    title?: true
    fileName?: true
    fileUrl?: true
    fileSize?: true
    fileType?: true
    status?: true
    department?: true
    updatedBy?: true
    category_id?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DocumentMaxAggregateInputType = {
    id?: true
    title?: true
    fileName?: true
    fileUrl?: true
    fileSize?: true
    fileType?: true
    status?: true
    department?: true
    updatedBy?: true
    category_id?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DocumentCountAggregateInputType = {
    id?: true
    title?: true
    fileName?: true
    fileUrl?: true
    fileSize?: true
    fileType?: true
    status?: true
    department?: true
    updatedBy?: true
    category_id?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type DocumentAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Document to aggregate.
     */
    where?: DocumentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Documents to fetch.
     */
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DocumentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Documents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Documents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Documents
    **/
    _count?: true | DocumentCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DocumentAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DocumentSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DocumentMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DocumentMaxAggregateInputType
  }

  export type GetDocumentAggregateType<T extends DocumentAggregateArgs> = {
        [P in keyof T & keyof AggregateDocument]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDocument[P]>
      : GetScalarType<T[P], AggregateDocument[P]>
  }




  export type DocumentGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DocumentWhereInput
    orderBy?: DocumentOrderByWithAggregationInput | DocumentOrderByWithAggregationInput[]
    by: DocumentScalarFieldEnum[] | DocumentScalarFieldEnum
    having?: DocumentScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DocumentCountAggregateInputType | true
    _avg?: DocumentAvgAggregateInputType
    _sum?: DocumentSumAggregateInputType
    _min?: DocumentMinAggregateInputType
    _max?: DocumentMaxAggregateInputType
  }

  export type DocumentGroupByOutputType = {
    id: string
    title: string | null
    fileName: string | null
    fileUrl: string | null
    fileSize: number | null
    fileType: string | null
    status: string
    department: string | null
    updatedBy: string
    category_id: string
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: DocumentCountAggregateOutputType | null
    _avg: DocumentAvgAggregateOutputType | null
    _sum: DocumentSumAggregateOutputType | null
    _min: DocumentMinAggregateOutputType | null
    _max: DocumentMaxAggregateOutputType | null
  }

  type GetDocumentGroupByPayload<T extends DocumentGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DocumentGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DocumentGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DocumentGroupByOutputType[P]>
            : GetScalarType<T[P], DocumentGroupByOutputType[P]>
        }
      >
    >


  export type DocumentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    fileName?: boolean
    fileUrl?: boolean
    fileSize?: boolean
    fileType?: boolean
    status?: boolean
    department?: boolean
    updatedBy?: boolean
    category_id?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    category?: boolean | DocumentCategoryDefaultArgs<ExtArgs>
    hospital?: boolean | Document$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["document"]>



  export type DocumentSelectScalar = {
    id?: boolean
    title?: boolean
    fileName?: boolean
    fileUrl?: boolean
    fileSize?: boolean
    fileType?: boolean
    status?: boolean
    department?: boolean
    updatedBy?: boolean
    category_id?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type DocumentOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "fileName" | "fileUrl" | "fileSize" | "fileType" | "status" | "department" | "updatedBy" | "category_id" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["document"]>
  export type DocumentInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | DocumentCategoryDefaultArgs<ExtArgs>
    hospital?: boolean | Document$hospitalArgs<ExtArgs>
  }

  export type $DocumentPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Document"
    objects: {
      category: Prisma.$DocumentCategoryPayload<ExtArgs>
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      title: string | null
      fileName: string | null
      fileUrl: string | null
      fileSize: number | null
      fileType: string | null
      status: string
      department: string | null
      updatedBy: string
      category_id: string
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["document"]>
    composites: {}
  }

  type DocumentGetPayload<S extends boolean | null | undefined | DocumentDefaultArgs> = $Result.GetResult<Prisma.$DocumentPayload, S>

  type DocumentCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<DocumentFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: DocumentCountAggregateInputType | true
    }

  export interface DocumentDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Document'], meta: { name: 'Document' } }
    /**
     * Find zero or one Document that matches the filter.
     * @param {DocumentFindUniqueArgs} args - Arguments to find a Document
     * @example
     * // Get one Document
     * const document = await prisma.document.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends DocumentFindUniqueArgs>(args: SelectSubset<T, DocumentFindUniqueArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Document that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {DocumentFindUniqueOrThrowArgs} args - Arguments to find a Document
     * @example
     * // Get one Document
     * const document = await prisma.document.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends DocumentFindUniqueOrThrowArgs>(args: SelectSubset<T, DocumentFindUniqueOrThrowArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Document that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentFindFirstArgs} args - Arguments to find a Document
     * @example
     * // Get one Document
     * const document = await prisma.document.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends DocumentFindFirstArgs>(args?: SelectSubset<T, DocumentFindFirstArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Document that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentFindFirstOrThrowArgs} args - Arguments to find a Document
     * @example
     * // Get one Document
     * const document = await prisma.document.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends DocumentFindFirstOrThrowArgs>(args?: SelectSubset<T, DocumentFindFirstOrThrowArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Documents that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Documents
     * const documents = await prisma.document.findMany()
     * 
     * // Get first 10 Documents
     * const documents = await prisma.document.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const documentWithIdOnly = await prisma.document.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends DocumentFindManyArgs>(args?: SelectSubset<T, DocumentFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Document.
     * @param {DocumentCreateArgs} args - Arguments to create a Document.
     * @example
     * // Create one Document
     * const Document = await prisma.document.create({
     *   data: {
     *     // ... data to create a Document
     *   }
     * })
     * 
     */
    create<T extends DocumentCreateArgs>(args: SelectSubset<T, DocumentCreateArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Documents.
     * @param {DocumentCreateManyArgs} args - Arguments to create many Documents.
     * @example
     * // Create many Documents
     * const document = await prisma.document.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends DocumentCreateManyArgs>(args?: SelectSubset<T, DocumentCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Document.
     * @param {DocumentDeleteArgs} args - Arguments to delete one Document.
     * @example
     * // Delete one Document
     * const Document = await prisma.document.delete({
     *   where: {
     *     // ... filter to delete one Document
     *   }
     * })
     * 
     */
    delete<T extends DocumentDeleteArgs>(args: SelectSubset<T, DocumentDeleteArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Document.
     * @param {DocumentUpdateArgs} args - Arguments to update one Document.
     * @example
     * // Update one Document
     * const document = await prisma.document.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends DocumentUpdateArgs>(args: SelectSubset<T, DocumentUpdateArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Documents.
     * @param {DocumentDeleteManyArgs} args - Arguments to filter Documents to delete.
     * @example
     * // Delete a few Documents
     * const { count } = await prisma.document.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends DocumentDeleteManyArgs>(args?: SelectSubset<T, DocumentDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Documents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Documents
     * const document = await prisma.document.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends DocumentUpdateManyArgs>(args: SelectSubset<T, DocumentUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Document.
     * @param {DocumentUpsertArgs} args - Arguments to update or create a Document.
     * @example
     * // Update or create a Document
     * const document = await prisma.document.upsert({
     *   create: {
     *     // ... data to create a Document
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Document we want to update
     *   }
     * })
     */
    upsert<T extends DocumentUpsertArgs>(args: SelectSubset<T, DocumentUpsertArgs<ExtArgs>>): Prisma__DocumentClient<$Result.GetResult<Prisma.$DocumentPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Documents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentCountArgs} args - Arguments to filter Documents to count.
     * @example
     * // Count the number of Documents
     * const count = await prisma.document.count({
     *   where: {
     *     // ... the filter for the Documents we want to count
     *   }
     * })
    **/
    count<T extends DocumentCountArgs>(
      args?: Subset<T, DocumentCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DocumentCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Document.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DocumentAggregateArgs>(args: Subset<T, DocumentAggregateArgs>): Prisma.PrismaPromise<GetDocumentAggregateType<T>>

    /**
     * Group by Document.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DocumentGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DocumentGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DocumentGroupByArgs['orderBy'] }
        : { orderBy?: DocumentGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DocumentGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDocumentGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Document model
   */
  readonly fields: DocumentFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Document.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DocumentClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    category<T extends DocumentCategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, DocumentCategoryDefaultArgs<ExtArgs>>): Prisma__DocumentCategoryClient<$Result.GetResult<Prisma.$DocumentCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    hospital<T extends Document$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, Document$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Document model
   */
  interface DocumentFieldRefs {
    readonly id: FieldRef<"Document", 'String'>
    readonly title: FieldRef<"Document", 'String'>
    readonly fileName: FieldRef<"Document", 'String'>
    readonly fileUrl: FieldRef<"Document", 'String'>
    readonly fileSize: FieldRef<"Document", 'Int'>
    readonly fileType: FieldRef<"Document", 'String'>
    readonly status: FieldRef<"Document", 'String'>
    readonly department: FieldRef<"Document", 'String'>
    readonly updatedBy: FieldRef<"Document", 'String'>
    readonly category_id: FieldRef<"Document", 'String'>
    readonly hospital_id: FieldRef<"Document", 'Int'>
    readonly createdAt: FieldRef<"Document", 'DateTime'>
    readonly updatedAt: FieldRef<"Document", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Document findUnique
   */
  export type DocumentFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter, which Document to fetch.
     */
    where: DocumentWhereUniqueInput
  }

  /**
   * Document findUniqueOrThrow
   */
  export type DocumentFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter, which Document to fetch.
     */
    where: DocumentWhereUniqueInput
  }

  /**
   * Document findFirst
   */
  export type DocumentFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter, which Document to fetch.
     */
    where?: DocumentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Documents to fetch.
     */
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Documents.
     */
    cursor?: DocumentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Documents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Documents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Documents.
     */
    distinct?: DocumentScalarFieldEnum | DocumentScalarFieldEnum[]
  }

  /**
   * Document findFirstOrThrow
   */
  export type DocumentFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter, which Document to fetch.
     */
    where?: DocumentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Documents to fetch.
     */
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Documents.
     */
    cursor?: DocumentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Documents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Documents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Documents.
     */
    distinct?: DocumentScalarFieldEnum | DocumentScalarFieldEnum[]
  }

  /**
   * Document findMany
   */
  export type DocumentFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter, which Documents to fetch.
     */
    where?: DocumentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Documents to fetch.
     */
    orderBy?: DocumentOrderByWithRelationInput | DocumentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Documents.
     */
    cursor?: DocumentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Documents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Documents.
     */
    skip?: number
    distinct?: DocumentScalarFieldEnum | DocumentScalarFieldEnum[]
  }

  /**
   * Document create
   */
  export type DocumentCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * The data needed to create a Document.
     */
    data: XOR<DocumentCreateInput, DocumentUncheckedCreateInput>
  }

  /**
   * Document createMany
   */
  export type DocumentCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Documents.
     */
    data: DocumentCreateManyInput | DocumentCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Document update
   */
  export type DocumentUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * The data needed to update a Document.
     */
    data: XOR<DocumentUpdateInput, DocumentUncheckedUpdateInput>
    /**
     * Choose, which Document to update.
     */
    where: DocumentWhereUniqueInput
  }

  /**
   * Document updateMany
   */
  export type DocumentUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Documents.
     */
    data: XOR<DocumentUpdateManyMutationInput, DocumentUncheckedUpdateManyInput>
    /**
     * Filter which Documents to update
     */
    where?: DocumentWhereInput
    /**
     * Limit how many Documents to update.
     */
    limit?: number
  }

  /**
   * Document upsert
   */
  export type DocumentUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * The filter to search for the Document to update in case it exists.
     */
    where: DocumentWhereUniqueInput
    /**
     * In case the Document found by the `where` argument doesn't exist, create a new Document with this data.
     */
    create: XOR<DocumentCreateInput, DocumentUncheckedCreateInput>
    /**
     * In case the Document was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DocumentUpdateInput, DocumentUncheckedUpdateInput>
  }

  /**
   * Document delete
   */
  export type DocumentDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
    /**
     * Filter which Document to delete.
     */
    where: DocumentWhereUniqueInput
  }

  /**
   * Document deleteMany
   */
  export type DocumentDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Documents to delete
     */
    where?: DocumentWhereInput
    /**
     * Limit how many Documents to delete.
     */
    limit?: number
  }

  /**
   * Document.hospital
   */
  export type Document$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * Document without action
   */
  export type DocumentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Document
     */
    select?: DocumentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Document
     */
    omit?: DocumentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DocumentInclude<ExtArgs> | null
  }


  /**
   * Model RegulatoryStandard
   */

  export type AggregateRegulatoryStandard = {
    _count: RegulatoryStandardCountAggregateOutputType | null
    _avg: RegulatoryStandardAvgAggregateOutputType | null
    _sum: RegulatoryStandardSumAggregateOutputType | null
    _min: RegulatoryStandardMinAggregateOutputType | null
    _max: RegulatoryStandardMaxAggregateOutputType | null
  }

  export type RegulatoryStandardAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryStandardSumAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryStandardMinAggregateOutputType = {
    id: string | null
    name: string | null
    category: string | null
    relevance: string | null
    lastUpdated: Date | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryStandardMaxAggregateOutputType = {
    id: string | null
    name: string | null
    category: string | null
    relevance: string | null
    lastUpdated: Date | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryStandardCountAggregateOutputType = {
    id: number
    name: number
    category: number
    relevance: number
    lastUpdated: number
    description: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type RegulatoryStandardAvgAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryStandardSumAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryStandardMinAggregateInputType = {
    id?: true
    name?: true
    category?: true
    relevance?: true
    lastUpdated?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryStandardMaxAggregateInputType = {
    id?: true
    name?: true
    category?: true
    relevance?: true
    lastUpdated?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryStandardCountAggregateInputType = {
    id?: true
    name?: true
    category?: true
    relevance?: true
    lastUpdated?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type RegulatoryStandardAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryStandard to aggregate.
     */
    where?: RegulatoryStandardWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryStandards to fetch.
     */
    orderBy?: RegulatoryStandardOrderByWithRelationInput | RegulatoryStandardOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RegulatoryStandardWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryStandards from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryStandards.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RegulatoryStandards
    **/
    _count?: true | RegulatoryStandardCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RegulatoryStandardAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RegulatoryStandardSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RegulatoryStandardMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RegulatoryStandardMaxAggregateInputType
  }

  export type GetRegulatoryStandardAggregateType<T extends RegulatoryStandardAggregateArgs> = {
        [P in keyof T & keyof AggregateRegulatoryStandard]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRegulatoryStandard[P]>
      : GetScalarType<T[P], AggregateRegulatoryStandard[P]>
  }




  export type RegulatoryStandardGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryStandardWhereInput
    orderBy?: RegulatoryStandardOrderByWithAggregationInput | RegulatoryStandardOrderByWithAggregationInput[]
    by: RegulatoryStandardScalarFieldEnum[] | RegulatoryStandardScalarFieldEnum
    having?: RegulatoryStandardScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RegulatoryStandardCountAggregateInputType | true
    _avg?: RegulatoryStandardAvgAggregateInputType
    _sum?: RegulatoryStandardSumAggregateInputType
    _min?: RegulatoryStandardMinAggregateInputType
    _max?: RegulatoryStandardMaxAggregateInputType
  }

  export type RegulatoryStandardGroupByOutputType = {
    id: string
    name: string
    category: string
    relevance: string
    lastUpdated: Date
    description: string | null
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: RegulatoryStandardCountAggregateOutputType | null
    _avg: RegulatoryStandardAvgAggregateOutputType | null
    _sum: RegulatoryStandardSumAggregateOutputType | null
    _min: RegulatoryStandardMinAggregateOutputType | null
    _max: RegulatoryStandardMaxAggregateOutputType | null
  }

  type GetRegulatoryStandardGroupByPayload<T extends RegulatoryStandardGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RegulatoryStandardGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RegulatoryStandardGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RegulatoryStandardGroupByOutputType[P]>
            : GetScalarType<T[P], RegulatoryStandardGroupByOutputType[P]>
        }
      >
    >


  export type RegulatoryStandardSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    category?: boolean
    relevance?: boolean
    lastUpdated?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | RegulatoryStandard$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["regulatoryStandard"]>



  export type RegulatoryStandardSelectScalar = {
    id?: boolean
    name?: boolean
    category?: boolean
    relevance?: boolean
    lastUpdated?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type RegulatoryStandardOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "category" | "relevance" | "lastUpdated" | "description" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["regulatoryStandard"]>
  export type RegulatoryStandardInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | RegulatoryStandard$hospitalArgs<ExtArgs>
  }

  export type $RegulatoryStandardPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RegulatoryStandard"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      category: string
      relevance: string
      lastUpdated: Date
      description: string | null
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["regulatoryStandard"]>
    composites: {}
  }

  type RegulatoryStandardGetPayload<S extends boolean | null | undefined | RegulatoryStandardDefaultArgs> = $Result.GetResult<Prisma.$RegulatoryStandardPayload, S>

  type RegulatoryStandardCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RegulatoryStandardFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RegulatoryStandardCountAggregateInputType | true
    }

  export interface RegulatoryStandardDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RegulatoryStandard'], meta: { name: 'RegulatoryStandard' } }
    /**
     * Find zero or one RegulatoryStandard that matches the filter.
     * @param {RegulatoryStandardFindUniqueArgs} args - Arguments to find a RegulatoryStandard
     * @example
     * // Get one RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RegulatoryStandardFindUniqueArgs>(args: SelectSubset<T, RegulatoryStandardFindUniqueArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one RegulatoryStandard that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RegulatoryStandardFindUniqueOrThrowArgs} args - Arguments to find a RegulatoryStandard
     * @example
     * // Get one RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RegulatoryStandardFindUniqueOrThrowArgs>(args: SelectSubset<T, RegulatoryStandardFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryStandard that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardFindFirstArgs} args - Arguments to find a RegulatoryStandard
     * @example
     * // Get one RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RegulatoryStandardFindFirstArgs>(args?: SelectSubset<T, RegulatoryStandardFindFirstArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryStandard that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardFindFirstOrThrowArgs} args - Arguments to find a RegulatoryStandard
     * @example
     * // Get one RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RegulatoryStandardFindFirstOrThrowArgs>(args?: SelectSubset<T, RegulatoryStandardFindFirstOrThrowArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more RegulatoryStandards that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RegulatoryStandards
     * const regulatoryStandards = await prisma.regulatoryStandard.findMany()
     * 
     * // Get first 10 RegulatoryStandards
     * const regulatoryStandards = await prisma.regulatoryStandard.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const regulatoryStandardWithIdOnly = await prisma.regulatoryStandard.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RegulatoryStandardFindManyArgs>(args?: SelectSubset<T, RegulatoryStandardFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a RegulatoryStandard.
     * @param {RegulatoryStandardCreateArgs} args - Arguments to create a RegulatoryStandard.
     * @example
     * // Create one RegulatoryStandard
     * const RegulatoryStandard = await prisma.regulatoryStandard.create({
     *   data: {
     *     // ... data to create a RegulatoryStandard
     *   }
     * })
     * 
     */
    create<T extends RegulatoryStandardCreateArgs>(args: SelectSubset<T, RegulatoryStandardCreateArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many RegulatoryStandards.
     * @param {RegulatoryStandardCreateManyArgs} args - Arguments to create many RegulatoryStandards.
     * @example
     * // Create many RegulatoryStandards
     * const regulatoryStandard = await prisma.regulatoryStandard.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RegulatoryStandardCreateManyArgs>(args?: SelectSubset<T, RegulatoryStandardCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a RegulatoryStandard.
     * @param {RegulatoryStandardDeleteArgs} args - Arguments to delete one RegulatoryStandard.
     * @example
     * // Delete one RegulatoryStandard
     * const RegulatoryStandard = await prisma.regulatoryStandard.delete({
     *   where: {
     *     // ... filter to delete one RegulatoryStandard
     *   }
     * })
     * 
     */
    delete<T extends RegulatoryStandardDeleteArgs>(args: SelectSubset<T, RegulatoryStandardDeleteArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one RegulatoryStandard.
     * @param {RegulatoryStandardUpdateArgs} args - Arguments to update one RegulatoryStandard.
     * @example
     * // Update one RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RegulatoryStandardUpdateArgs>(args: SelectSubset<T, RegulatoryStandardUpdateArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more RegulatoryStandards.
     * @param {RegulatoryStandardDeleteManyArgs} args - Arguments to filter RegulatoryStandards to delete.
     * @example
     * // Delete a few RegulatoryStandards
     * const { count } = await prisma.regulatoryStandard.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RegulatoryStandardDeleteManyArgs>(args?: SelectSubset<T, RegulatoryStandardDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RegulatoryStandards.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RegulatoryStandards
     * const regulatoryStandard = await prisma.regulatoryStandard.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RegulatoryStandardUpdateManyArgs>(args: SelectSubset<T, RegulatoryStandardUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RegulatoryStandard.
     * @param {RegulatoryStandardUpsertArgs} args - Arguments to update or create a RegulatoryStandard.
     * @example
     * // Update or create a RegulatoryStandard
     * const regulatoryStandard = await prisma.regulatoryStandard.upsert({
     *   create: {
     *     // ... data to create a RegulatoryStandard
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RegulatoryStandard we want to update
     *   }
     * })
     */
    upsert<T extends RegulatoryStandardUpsertArgs>(args: SelectSubset<T, RegulatoryStandardUpsertArgs<ExtArgs>>): Prisma__RegulatoryStandardClient<$Result.GetResult<Prisma.$RegulatoryStandardPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of RegulatoryStandards.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardCountArgs} args - Arguments to filter RegulatoryStandards to count.
     * @example
     * // Count the number of RegulatoryStandards
     * const count = await prisma.regulatoryStandard.count({
     *   where: {
     *     // ... the filter for the RegulatoryStandards we want to count
     *   }
     * })
    **/
    count<T extends RegulatoryStandardCountArgs>(
      args?: Subset<T, RegulatoryStandardCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RegulatoryStandardCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RegulatoryStandard.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RegulatoryStandardAggregateArgs>(args: Subset<T, RegulatoryStandardAggregateArgs>): Prisma.PrismaPromise<GetRegulatoryStandardAggregateType<T>>

    /**
     * Group by RegulatoryStandard.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryStandardGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RegulatoryStandardGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RegulatoryStandardGroupByArgs['orderBy'] }
        : { orderBy?: RegulatoryStandardGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RegulatoryStandardGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRegulatoryStandardGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RegulatoryStandard model
   */
  readonly fields: RegulatoryStandardFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RegulatoryStandard.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RegulatoryStandardClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends RegulatoryStandard$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, RegulatoryStandard$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the RegulatoryStandard model
   */
  interface RegulatoryStandardFieldRefs {
    readonly id: FieldRef<"RegulatoryStandard", 'String'>
    readonly name: FieldRef<"RegulatoryStandard", 'String'>
    readonly category: FieldRef<"RegulatoryStandard", 'String'>
    readonly relevance: FieldRef<"RegulatoryStandard", 'String'>
    readonly lastUpdated: FieldRef<"RegulatoryStandard", 'DateTime'>
    readonly description: FieldRef<"RegulatoryStandard", 'String'>
    readonly hospital_id: FieldRef<"RegulatoryStandard", 'Int'>
    readonly createdAt: FieldRef<"RegulatoryStandard", 'DateTime'>
    readonly updatedAt: FieldRef<"RegulatoryStandard", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * RegulatoryStandard findUnique
   */
  export type RegulatoryStandardFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryStandard to fetch.
     */
    where: RegulatoryStandardWhereUniqueInput
  }

  /**
   * RegulatoryStandard findUniqueOrThrow
   */
  export type RegulatoryStandardFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryStandard to fetch.
     */
    where: RegulatoryStandardWhereUniqueInput
  }

  /**
   * RegulatoryStandard findFirst
   */
  export type RegulatoryStandardFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryStandard to fetch.
     */
    where?: RegulatoryStandardWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryStandards to fetch.
     */
    orderBy?: RegulatoryStandardOrderByWithRelationInput | RegulatoryStandardOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryStandards.
     */
    cursor?: RegulatoryStandardWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryStandards from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryStandards.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryStandards.
     */
    distinct?: RegulatoryStandardScalarFieldEnum | RegulatoryStandardScalarFieldEnum[]
  }

  /**
   * RegulatoryStandard findFirstOrThrow
   */
  export type RegulatoryStandardFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryStandard to fetch.
     */
    where?: RegulatoryStandardWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryStandards to fetch.
     */
    orderBy?: RegulatoryStandardOrderByWithRelationInput | RegulatoryStandardOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryStandards.
     */
    cursor?: RegulatoryStandardWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryStandards from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryStandards.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryStandards.
     */
    distinct?: RegulatoryStandardScalarFieldEnum | RegulatoryStandardScalarFieldEnum[]
  }

  /**
   * RegulatoryStandard findMany
   */
  export type RegulatoryStandardFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryStandards to fetch.
     */
    where?: RegulatoryStandardWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryStandards to fetch.
     */
    orderBy?: RegulatoryStandardOrderByWithRelationInput | RegulatoryStandardOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RegulatoryStandards.
     */
    cursor?: RegulatoryStandardWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryStandards from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryStandards.
     */
    skip?: number
    distinct?: RegulatoryStandardScalarFieldEnum | RegulatoryStandardScalarFieldEnum[]
  }

  /**
   * RegulatoryStandard create
   */
  export type RegulatoryStandardCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * The data needed to create a RegulatoryStandard.
     */
    data: XOR<RegulatoryStandardCreateInput, RegulatoryStandardUncheckedCreateInput>
  }

  /**
   * RegulatoryStandard createMany
   */
  export type RegulatoryStandardCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RegulatoryStandards.
     */
    data: RegulatoryStandardCreateManyInput | RegulatoryStandardCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RegulatoryStandard update
   */
  export type RegulatoryStandardUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * The data needed to update a RegulatoryStandard.
     */
    data: XOR<RegulatoryStandardUpdateInput, RegulatoryStandardUncheckedUpdateInput>
    /**
     * Choose, which RegulatoryStandard to update.
     */
    where: RegulatoryStandardWhereUniqueInput
  }

  /**
   * RegulatoryStandard updateMany
   */
  export type RegulatoryStandardUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RegulatoryStandards.
     */
    data: XOR<RegulatoryStandardUpdateManyMutationInput, RegulatoryStandardUncheckedUpdateManyInput>
    /**
     * Filter which RegulatoryStandards to update
     */
    where?: RegulatoryStandardWhereInput
    /**
     * Limit how many RegulatoryStandards to update.
     */
    limit?: number
  }

  /**
   * RegulatoryStandard upsert
   */
  export type RegulatoryStandardUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * The filter to search for the RegulatoryStandard to update in case it exists.
     */
    where: RegulatoryStandardWhereUniqueInput
    /**
     * In case the RegulatoryStandard found by the `where` argument doesn't exist, create a new RegulatoryStandard with this data.
     */
    create: XOR<RegulatoryStandardCreateInput, RegulatoryStandardUncheckedCreateInput>
    /**
     * In case the RegulatoryStandard was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RegulatoryStandardUpdateInput, RegulatoryStandardUncheckedUpdateInput>
  }

  /**
   * RegulatoryStandard delete
   */
  export type RegulatoryStandardDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
    /**
     * Filter which RegulatoryStandard to delete.
     */
    where: RegulatoryStandardWhereUniqueInput
  }

  /**
   * RegulatoryStandard deleteMany
   */
  export type RegulatoryStandardDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryStandards to delete
     */
    where?: RegulatoryStandardWhereInput
    /**
     * Limit how many RegulatoryStandards to delete.
     */
    limit?: number
  }

  /**
   * RegulatoryStandard.hospital
   */
  export type RegulatoryStandard$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * RegulatoryStandard without action
   */
  export type RegulatoryStandardDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryStandard
     */
    select?: RegulatoryStandardSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryStandard
     */
    omit?: RegulatoryStandardOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryStandardInclude<ExtArgs> | null
  }


  /**
   * Model RegulatoryNews
   */

  export type AggregateRegulatoryNews = {
    _count: RegulatoryNewsCountAggregateOutputType | null
    _avg: RegulatoryNewsAvgAggregateOutputType | null
    _sum: RegulatoryNewsSumAggregateOutputType | null
    _min: RegulatoryNewsMinAggregateOutputType | null
    _max: RegulatoryNewsMaxAggregateOutputType | null
  }

  export type RegulatoryNewsAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryNewsSumAggregateOutputType = {
    hospital_id: number | null
  }

  export type RegulatoryNewsMinAggregateOutputType = {
    id: string | null
    title: string | null
    source: string | null
    date: Date | null
    category: string | null
    content: string | null
    url: string | null
    isNew: boolean | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryNewsMaxAggregateOutputType = {
    id: string | null
    title: string | null
    source: string | null
    date: Date | null
    category: string | null
    content: string | null
    url: string | null
    isNew: boolean | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type RegulatoryNewsCountAggregateOutputType = {
    id: number
    title: number
    source: number
    date: number
    category: number
    content: number
    url: number
    isNew: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type RegulatoryNewsAvgAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryNewsSumAggregateInputType = {
    hospital_id?: true
  }

  export type RegulatoryNewsMinAggregateInputType = {
    id?: true
    title?: true
    source?: true
    date?: true
    category?: true
    content?: true
    url?: true
    isNew?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryNewsMaxAggregateInputType = {
    id?: true
    title?: true
    source?: true
    date?: true
    category?: true
    content?: true
    url?: true
    isNew?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type RegulatoryNewsCountAggregateInputType = {
    id?: true
    title?: true
    source?: true
    date?: true
    category?: true
    content?: true
    url?: true
    isNew?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type RegulatoryNewsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryNews to aggregate.
     */
    where?: RegulatoryNewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryNews to fetch.
     */
    orderBy?: RegulatoryNewsOrderByWithRelationInput | RegulatoryNewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RegulatoryNewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryNews from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryNews.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RegulatoryNews
    **/
    _count?: true | RegulatoryNewsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RegulatoryNewsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RegulatoryNewsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RegulatoryNewsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RegulatoryNewsMaxAggregateInputType
  }

  export type GetRegulatoryNewsAggregateType<T extends RegulatoryNewsAggregateArgs> = {
        [P in keyof T & keyof AggregateRegulatoryNews]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRegulatoryNews[P]>
      : GetScalarType<T[P], AggregateRegulatoryNews[P]>
  }




  export type RegulatoryNewsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RegulatoryNewsWhereInput
    orderBy?: RegulatoryNewsOrderByWithAggregationInput | RegulatoryNewsOrderByWithAggregationInput[]
    by: RegulatoryNewsScalarFieldEnum[] | RegulatoryNewsScalarFieldEnum
    having?: RegulatoryNewsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RegulatoryNewsCountAggregateInputType | true
    _avg?: RegulatoryNewsAvgAggregateInputType
    _sum?: RegulatoryNewsSumAggregateInputType
    _min?: RegulatoryNewsMinAggregateInputType
    _max?: RegulatoryNewsMaxAggregateInputType
  }

  export type RegulatoryNewsGroupByOutputType = {
    id: string
    title: string
    source: string
    date: Date
    category: string
    content: string | null
    url: string | null
    isNew: boolean
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: RegulatoryNewsCountAggregateOutputType | null
    _avg: RegulatoryNewsAvgAggregateOutputType | null
    _sum: RegulatoryNewsSumAggregateOutputType | null
    _min: RegulatoryNewsMinAggregateOutputType | null
    _max: RegulatoryNewsMaxAggregateOutputType | null
  }

  type GetRegulatoryNewsGroupByPayload<T extends RegulatoryNewsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RegulatoryNewsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RegulatoryNewsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RegulatoryNewsGroupByOutputType[P]>
            : GetScalarType<T[P], RegulatoryNewsGroupByOutputType[P]>
        }
      >
    >


  export type RegulatoryNewsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    source?: boolean
    date?: boolean
    category?: boolean
    content?: boolean
    url?: boolean
    isNew?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | RegulatoryNews$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["regulatoryNews"]>



  export type RegulatoryNewsSelectScalar = {
    id?: boolean
    title?: boolean
    source?: boolean
    date?: boolean
    category?: boolean
    content?: boolean
    url?: boolean
    isNew?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type RegulatoryNewsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "source" | "date" | "category" | "content" | "url" | "isNew" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["regulatoryNews"]>
  export type RegulatoryNewsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | RegulatoryNews$hospitalArgs<ExtArgs>
  }

  export type $RegulatoryNewsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RegulatoryNews"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      title: string
      source: string
      date: Date
      category: string
      content: string | null
      url: string | null
      isNew: boolean
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["regulatoryNews"]>
    composites: {}
  }

  type RegulatoryNewsGetPayload<S extends boolean | null | undefined | RegulatoryNewsDefaultArgs> = $Result.GetResult<Prisma.$RegulatoryNewsPayload, S>

  type RegulatoryNewsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<RegulatoryNewsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RegulatoryNewsCountAggregateInputType | true
    }

  export interface RegulatoryNewsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RegulatoryNews'], meta: { name: 'RegulatoryNews' } }
    /**
     * Find zero or one RegulatoryNews that matches the filter.
     * @param {RegulatoryNewsFindUniqueArgs} args - Arguments to find a RegulatoryNews
     * @example
     * // Get one RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends RegulatoryNewsFindUniqueArgs>(args: SelectSubset<T, RegulatoryNewsFindUniqueArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one RegulatoryNews that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {RegulatoryNewsFindUniqueOrThrowArgs} args - Arguments to find a RegulatoryNews
     * @example
     * // Get one RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends RegulatoryNewsFindUniqueOrThrowArgs>(args: SelectSubset<T, RegulatoryNewsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryNews that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsFindFirstArgs} args - Arguments to find a RegulatoryNews
     * @example
     * // Get one RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends RegulatoryNewsFindFirstArgs>(args?: SelectSubset<T, RegulatoryNewsFindFirstArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first RegulatoryNews that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsFindFirstOrThrowArgs} args - Arguments to find a RegulatoryNews
     * @example
     * // Get one RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends RegulatoryNewsFindFirstOrThrowArgs>(args?: SelectSubset<T, RegulatoryNewsFindFirstOrThrowArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more RegulatoryNews that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findMany()
     * 
     * // Get first 10 RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const regulatoryNewsWithIdOnly = await prisma.regulatoryNews.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends RegulatoryNewsFindManyArgs>(args?: SelectSubset<T, RegulatoryNewsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a RegulatoryNews.
     * @param {RegulatoryNewsCreateArgs} args - Arguments to create a RegulatoryNews.
     * @example
     * // Create one RegulatoryNews
     * const RegulatoryNews = await prisma.regulatoryNews.create({
     *   data: {
     *     // ... data to create a RegulatoryNews
     *   }
     * })
     * 
     */
    create<T extends RegulatoryNewsCreateArgs>(args: SelectSubset<T, RegulatoryNewsCreateArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many RegulatoryNews.
     * @param {RegulatoryNewsCreateManyArgs} args - Arguments to create many RegulatoryNews.
     * @example
     * // Create many RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends RegulatoryNewsCreateManyArgs>(args?: SelectSubset<T, RegulatoryNewsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a RegulatoryNews.
     * @param {RegulatoryNewsDeleteArgs} args - Arguments to delete one RegulatoryNews.
     * @example
     * // Delete one RegulatoryNews
     * const RegulatoryNews = await prisma.regulatoryNews.delete({
     *   where: {
     *     // ... filter to delete one RegulatoryNews
     *   }
     * })
     * 
     */
    delete<T extends RegulatoryNewsDeleteArgs>(args: SelectSubset<T, RegulatoryNewsDeleteArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one RegulatoryNews.
     * @param {RegulatoryNewsUpdateArgs} args - Arguments to update one RegulatoryNews.
     * @example
     * // Update one RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends RegulatoryNewsUpdateArgs>(args: SelectSubset<T, RegulatoryNewsUpdateArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more RegulatoryNews.
     * @param {RegulatoryNewsDeleteManyArgs} args - Arguments to filter RegulatoryNews to delete.
     * @example
     * // Delete a few RegulatoryNews
     * const { count } = await prisma.regulatoryNews.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends RegulatoryNewsDeleteManyArgs>(args?: SelectSubset<T, RegulatoryNewsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RegulatoryNews.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends RegulatoryNewsUpdateManyArgs>(args: SelectSubset<T, RegulatoryNewsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RegulatoryNews.
     * @param {RegulatoryNewsUpsertArgs} args - Arguments to update or create a RegulatoryNews.
     * @example
     * // Update or create a RegulatoryNews
     * const regulatoryNews = await prisma.regulatoryNews.upsert({
     *   create: {
     *     // ... data to create a RegulatoryNews
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RegulatoryNews we want to update
     *   }
     * })
     */
    upsert<T extends RegulatoryNewsUpsertArgs>(args: SelectSubset<T, RegulatoryNewsUpsertArgs<ExtArgs>>): Prisma__RegulatoryNewsClient<$Result.GetResult<Prisma.$RegulatoryNewsPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of RegulatoryNews.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsCountArgs} args - Arguments to filter RegulatoryNews to count.
     * @example
     * // Count the number of RegulatoryNews
     * const count = await prisma.regulatoryNews.count({
     *   where: {
     *     // ... the filter for the RegulatoryNews we want to count
     *   }
     * })
    **/
    count<T extends RegulatoryNewsCountArgs>(
      args?: Subset<T, RegulatoryNewsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RegulatoryNewsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RegulatoryNews.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RegulatoryNewsAggregateArgs>(args: Subset<T, RegulatoryNewsAggregateArgs>): Prisma.PrismaPromise<GetRegulatoryNewsAggregateType<T>>

    /**
     * Group by RegulatoryNews.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegulatoryNewsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RegulatoryNewsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RegulatoryNewsGroupByArgs['orderBy'] }
        : { orderBy?: RegulatoryNewsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RegulatoryNewsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRegulatoryNewsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RegulatoryNews model
   */
  readonly fields: RegulatoryNewsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RegulatoryNews.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RegulatoryNewsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends RegulatoryNews$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, RegulatoryNews$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the RegulatoryNews model
   */
  interface RegulatoryNewsFieldRefs {
    readonly id: FieldRef<"RegulatoryNews", 'String'>
    readonly title: FieldRef<"RegulatoryNews", 'String'>
    readonly source: FieldRef<"RegulatoryNews", 'String'>
    readonly date: FieldRef<"RegulatoryNews", 'DateTime'>
    readonly category: FieldRef<"RegulatoryNews", 'String'>
    readonly content: FieldRef<"RegulatoryNews", 'String'>
    readonly url: FieldRef<"RegulatoryNews", 'String'>
    readonly isNew: FieldRef<"RegulatoryNews", 'Boolean'>
    readonly hospital_id: FieldRef<"RegulatoryNews", 'Int'>
    readonly createdAt: FieldRef<"RegulatoryNews", 'DateTime'>
    readonly updatedAt: FieldRef<"RegulatoryNews", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * RegulatoryNews findUnique
   */
  export type RegulatoryNewsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryNews to fetch.
     */
    where: RegulatoryNewsWhereUniqueInput
  }

  /**
   * RegulatoryNews findUniqueOrThrow
   */
  export type RegulatoryNewsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryNews to fetch.
     */
    where: RegulatoryNewsWhereUniqueInput
  }

  /**
   * RegulatoryNews findFirst
   */
  export type RegulatoryNewsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryNews to fetch.
     */
    where?: RegulatoryNewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryNews to fetch.
     */
    orderBy?: RegulatoryNewsOrderByWithRelationInput | RegulatoryNewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryNews.
     */
    cursor?: RegulatoryNewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryNews from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryNews.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryNews.
     */
    distinct?: RegulatoryNewsScalarFieldEnum | RegulatoryNewsScalarFieldEnum[]
  }

  /**
   * RegulatoryNews findFirstOrThrow
   */
  export type RegulatoryNewsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryNews to fetch.
     */
    where?: RegulatoryNewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryNews to fetch.
     */
    orderBy?: RegulatoryNewsOrderByWithRelationInput | RegulatoryNewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RegulatoryNews.
     */
    cursor?: RegulatoryNewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryNews from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryNews.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RegulatoryNews.
     */
    distinct?: RegulatoryNewsScalarFieldEnum | RegulatoryNewsScalarFieldEnum[]
  }

  /**
   * RegulatoryNews findMany
   */
  export type RegulatoryNewsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter, which RegulatoryNews to fetch.
     */
    where?: RegulatoryNewsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RegulatoryNews to fetch.
     */
    orderBy?: RegulatoryNewsOrderByWithRelationInput | RegulatoryNewsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RegulatoryNews.
     */
    cursor?: RegulatoryNewsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RegulatoryNews from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RegulatoryNews.
     */
    skip?: number
    distinct?: RegulatoryNewsScalarFieldEnum | RegulatoryNewsScalarFieldEnum[]
  }

  /**
   * RegulatoryNews create
   */
  export type RegulatoryNewsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * The data needed to create a RegulatoryNews.
     */
    data: XOR<RegulatoryNewsCreateInput, RegulatoryNewsUncheckedCreateInput>
  }

  /**
   * RegulatoryNews createMany
   */
  export type RegulatoryNewsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RegulatoryNews.
     */
    data: RegulatoryNewsCreateManyInput | RegulatoryNewsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * RegulatoryNews update
   */
  export type RegulatoryNewsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * The data needed to update a RegulatoryNews.
     */
    data: XOR<RegulatoryNewsUpdateInput, RegulatoryNewsUncheckedUpdateInput>
    /**
     * Choose, which RegulatoryNews to update.
     */
    where: RegulatoryNewsWhereUniqueInput
  }

  /**
   * RegulatoryNews updateMany
   */
  export type RegulatoryNewsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RegulatoryNews.
     */
    data: XOR<RegulatoryNewsUpdateManyMutationInput, RegulatoryNewsUncheckedUpdateManyInput>
    /**
     * Filter which RegulatoryNews to update
     */
    where?: RegulatoryNewsWhereInput
    /**
     * Limit how many RegulatoryNews to update.
     */
    limit?: number
  }

  /**
   * RegulatoryNews upsert
   */
  export type RegulatoryNewsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * The filter to search for the RegulatoryNews to update in case it exists.
     */
    where: RegulatoryNewsWhereUniqueInput
    /**
     * In case the RegulatoryNews found by the `where` argument doesn't exist, create a new RegulatoryNews with this data.
     */
    create: XOR<RegulatoryNewsCreateInput, RegulatoryNewsUncheckedCreateInput>
    /**
     * In case the RegulatoryNews was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RegulatoryNewsUpdateInput, RegulatoryNewsUncheckedUpdateInput>
  }

  /**
   * RegulatoryNews delete
   */
  export type RegulatoryNewsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
    /**
     * Filter which RegulatoryNews to delete.
     */
    where: RegulatoryNewsWhereUniqueInput
  }

  /**
   * RegulatoryNews deleteMany
   */
  export type RegulatoryNewsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RegulatoryNews to delete
     */
    where?: RegulatoryNewsWhereInput
    /**
     * Limit how many RegulatoryNews to delete.
     */
    limit?: number
  }

  /**
   * RegulatoryNews.hospital
   */
  export type RegulatoryNews$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * RegulatoryNews without action
   */
  export type RegulatoryNewsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RegulatoryNews
     */
    select?: RegulatoryNewsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the RegulatoryNews
     */
    omit?: RegulatoryNewsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RegulatoryNewsInclude<ExtArgs> | null
  }


  /**
   * Model StaffCompliance
   */

  export type AggregateStaffCompliance = {
    _count: StaffComplianceCountAggregateOutputType | null
    _avg: StaffComplianceAvgAggregateOutputType | null
    _sum: StaffComplianceSumAggregateOutputType | null
    _min: StaffComplianceMinAggregateOutputType | null
    _max: StaffComplianceMaxAggregateOutputType | null
  }

  export type StaffComplianceAvgAggregateOutputType = {
    id: number | null
    staff_count: number | null
    compliance_rate: number | null
    hospital_id: number | null
  }

  export type StaffComplianceSumAggregateOutputType = {
    id: number | null
    staff_count: number | null
    compliance_rate: number | null
    hospital_id: number | null
  }

  export type StaffComplianceMinAggregateOutputType = {
    id: number | null
    department: string | null
    staff_count: number | null
    compliance_rate: number | null
    notes: string | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type StaffComplianceMaxAggregateOutputType = {
    id: number | null
    department: string | null
    staff_count: number | null
    compliance_rate: number | null
    notes: string | null
    hospital_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type StaffComplianceCountAggregateOutputType = {
    id: number
    department: number
    staff_count: number
    compliance_rate: number
    notes: number
    hospital_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type StaffComplianceAvgAggregateInputType = {
    id?: true
    staff_count?: true
    compliance_rate?: true
    hospital_id?: true
  }

  export type StaffComplianceSumAggregateInputType = {
    id?: true
    staff_count?: true
    compliance_rate?: true
    hospital_id?: true
  }

  export type StaffComplianceMinAggregateInputType = {
    id?: true
    department?: true
    staff_count?: true
    compliance_rate?: true
    notes?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type StaffComplianceMaxAggregateInputType = {
    id?: true
    department?: true
    staff_count?: true
    compliance_rate?: true
    notes?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
  }

  export type StaffComplianceCountAggregateInputType = {
    id?: true
    department?: true
    staff_count?: true
    compliance_rate?: true
    notes?: true
    hospital_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type StaffComplianceAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which StaffCompliance to aggregate.
     */
    where?: StaffComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StaffCompliances to fetch.
     */
    orderBy?: StaffComplianceOrderByWithRelationInput | StaffComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: StaffComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StaffCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StaffCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned StaffCompliances
    **/
    _count?: true | StaffComplianceCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: StaffComplianceAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: StaffComplianceSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: StaffComplianceMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: StaffComplianceMaxAggregateInputType
  }

  export type GetStaffComplianceAggregateType<T extends StaffComplianceAggregateArgs> = {
        [P in keyof T & keyof AggregateStaffCompliance]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateStaffCompliance[P]>
      : GetScalarType<T[P], AggregateStaffCompliance[P]>
  }




  export type StaffComplianceGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StaffComplianceWhereInput
    orderBy?: StaffComplianceOrderByWithAggregationInput | StaffComplianceOrderByWithAggregationInput[]
    by: StaffComplianceScalarFieldEnum[] | StaffComplianceScalarFieldEnum
    having?: StaffComplianceScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: StaffComplianceCountAggregateInputType | true
    _avg?: StaffComplianceAvgAggregateInputType
    _sum?: StaffComplianceSumAggregateInputType
    _min?: StaffComplianceMinAggregateInputType
    _max?: StaffComplianceMaxAggregateInputType
  }

  export type StaffComplianceGroupByOutputType = {
    id: number
    department: string
    staff_count: number
    compliance_rate: number
    notes: string | null
    hospital_id: number
    created_at: Date
    updated_at: Date
    _count: StaffComplianceCountAggregateOutputType | null
    _avg: StaffComplianceAvgAggregateOutputType | null
    _sum: StaffComplianceSumAggregateOutputType | null
    _min: StaffComplianceMinAggregateOutputType | null
    _max: StaffComplianceMaxAggregateOutputType | null
  }

  type GetStaffComplianceGroupByPayload<T extends StaffComplianceGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<StaffComplianceGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof StaffComplianceGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], StaffComplianceGroupByOutputType[P]>
            : GetScalarType<T[P], StaffComplianceGroupByOutputType[P]>
        }
      >
    >


  export type StaffComplianceSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    department?: boolean
    staff_count?: boolean
    compliance_rate?: boolean
    notes?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["staffCompliance"]>



  export type StaffComplianceSelectScalar = {
    id?: boolean
    department?: boolean
    staff_count?: boolean
    compliance_rate?: boolean
    notes?: boolean
    hospital_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type StaffComplianceOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "department" | "staff_count" | "compliance_rate" | "notes" | "hospital_id" | "created_at" | "updated_at", ExtArgs["result"]["staffCompliance"]>
  export type StaffComplianceInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | HospitalDefaultArgs<ExtArgs>
  }

  export type $StaffCompliancePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "StaffCompliance"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      department: string
      staff_count: number
      compliance_rate: number
      notes: string | null
      hospital_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["staffCompliance"]>
    composites: {}
  }

  type StaffComplianceGetPayload<S extends boolean | null | undefined | StaffComplianceDefaultArgs> = $Result.GetResult<Prisma.$StaffCompliancePayload, S>

  type StaffComplianceCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<StaffComplianceFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: StaffComplianceCountAggregateInputType | true
    }

  export interface StaffComplianceDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['StaffCompliance'], meta: { name: 'StaffCompliance' } }
    /**
     * Find zero or one StaffCompliance that matches the filter.
     * @param {StaffComplianceFindUniqueArgs} args - Arguments to find a StaffCompliance
     * @example
     * // Get one StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends StaffComplianceFindUniqueArgs>(args: SelectSubset<T, StaffComplianceFindUniqueArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one StaffCompliance that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {StaffComplianceFindUniqueOrThrowArgs} args - Arguments to find a StaffCompliance
     * @example
     * // Get one StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends StaffComplianceFindUniqueOrThrowArgs>(args: SelectSubset<T, StaffComplianceFindUniqueOrThrowArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first StaffCompliance that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceFindFirstArgs} args - Arguments to find a StaffCompliance
     * @example
     * // Get one StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends StaffComplianceFindFirstArgs>(args?: SelectSubset<T, StaffComplianceFindFirstArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first StaffCompliance that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceFindFirstOrThrowArgs} args - Arguments to find a StaffCompliance
     * @example
     * // Get one StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends StaffComplianceFindFirstOrThrowArgs>(args?: SelectSubset<T, StaffComplianceFindFirstOrThrowArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more StaffCompliances that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all StaffCompliances
     * const staffCompliances = await prisma.staffCompliance.findMany()
     * 
     * // Get first 10 StaffCompliances
     * const staffCompliances = await prisma.staffCompliance.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const staffComplianceWithIdOnly = await prisma.staffCompliance.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends StaffComplianceFindManyArgs>(args?: SelectSubset<T, StaffComplianceFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a StaffCompliance.
     * @param {StaffComplianceCreateArgs} args - Arguments to create a StaffCompliance.
     * @example
     * // Create one StaffCompliance
     * const StaffCompliance = await prisma.staffCompliance.create({
     *   data: {
     *     // ... data to create a StaffCompliance
     *   }
     * })
     * 
     */
    create<T extends StaffComplianceCreateArgs>(args: SelectSubset<T, StaffComplianceCreateArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many StaffCompliances.
     * @param {StaffComplianceCreateManyArgs} args - Arguments to create many StaffCompliances.
     * @example
     * // Create many StaffCompliances
     * const staffCompliance = await prisma.staffCompliance.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends StaffComplianceCreateManyArgs>(args?: SelectSubset<T, StaffComplianceCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a StaffCompliance.
     * @param {StaffComplianceDeleteArgs} args - Arguments to delete one StaffCompliance.
     * @example
     * // Delete one StaffCompliance
     * const StaffCompliance = await prisma.staffCompliance.delete({
     *   where: {
     *     // ... filter to delete one StaffCompliance
     *   }
     * })
     * 
     */
    delete<T extends StaffComplianceDeleteArgs>(args: SelectSubset<T, StaffComplianceDeleteArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one StaffCompliance.
     * @param {StaffComplianceUpdateArgs} args - Arguments to update one StaffCompliance.
     * @example
     * // Update one StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends StaffComplianceUpdateArgs>(args: SelectSubset<T, StaffComplianceUpdateArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more StaffCompliances.
     * @param {StaffComplianceDeleteManyArgs} args - Arguments to filter StaffCompliances to delete.
     * @example
     * // Delete a few StaffCompliances
     * const { count } = await prisma.staffCompliance.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends StaffComplianceDeleteManyArgs>(args?: SelectSubset<T, StaffComplianceDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more StaffCompliances.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many StaffCompliances
     * const staffCompliance = await prisma.staffCompliance.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends StaffComplianceUpdateManyArgs>(args: SelectSubset<T, StaffComplianceUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one StaffCompliance.
     * @param {StaffComplianceUpsertArgs} args - Arguments to update or create a StaffCompliance.
     * @example
     * // Update or create a StaffCompliance
     * const staffCompliance = await prisma.staffCompliance.upsert({
     *   create: {
     *     // ... data to create a StaffCompliance
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the StaffCompliance we want to update
     *   }
     * })
     */
    upsert<T extends StaffComplianceUpsertArgs>(args: SelectSubset<T, StaffComplianceUpsertArgs<ExtArgs>>): Prisma__StaffComplianceClient<$Result.GetResult<Prisma.$StaffCompliancePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of StaffCompliances.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceCountArgs} args - Arguments to filter StaffCompliances to count.
     * @example
     * // Count the number of StaffCompliances
     * const count = await prisma.staffCompliance.count({
     *   where: {
     *     // ... the filter for the StaffCompliances we want to count
     *   }
     * })
    **/
    count<T extends StaffComplianceCountArgs>(
      args?: Subset<T, StaffComplianceCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], StaffComplianceCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a StaffCompliance.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends StaffComplianceAggregateArgs>(args: Subset<T, StaffComplianceAggregateArgs>): Prisma.PrismaPromise<GetStaffComplianceAggregateType<T>>

    /**
     * Group by StaffCompliance.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StaffComplianceGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends StaffComplianceGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: StaffComplianceGroupByArgs['orderBy'] }
        : { orderBy?: StaffComplianceGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, StaffComplianceGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetStaffComplianceGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the StaffCompliance model
   */
  readonly fields: StaffComplianceFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for StaffCompliance.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__StaffComplianceClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends HospitalDefaultArgs<ExtArgs> = {}>(args?: Subset<T, HospitalDefaultArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the StaffCompliance model
   */
  interface StaffComplianceFieldRefs {
    readonly id: FieldRef<"StaffCompliance", 'Int'>
    readonly department: FieldRef<"StaffCompliance", 'String'>
    readonly staff_count: FieldRef<"StaffCompliance", 'Int'>
    readonly compliance_rate: FieldRef<"StaffCompliance", 'Float'>
    readonly notes: FieldRef<"StaffCompliance", 'String'>
    readonly hospital_id: FieldRef<"StaffCompliance", 'Int'>
    readonly created_at: FieldRef<"StaffCompliance", 'DateTime'>
    readonly updated_at: FieldRef<"StaffCompliance", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * StaffCompliance findUnique
   */
  export type StaffComplianceFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StaffCompliance to fetch.
     */
    where: StaffComplianceWhereUniqueInput
  }

  /**
   * StaffCompliance findUniqueOrThrow
   */
  export type StaffComplianceFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StaffCompliance to fetch.
     */
    where: StaffComplianceWhereUniqueInput
  }

  /**
   * StaffCompliance findFirst
   */
  export type StaffComplianceFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StaffCompliance to fetch.
     */
    where?: StaffComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StaffCompliances to fetch.
     */
    orderBy?: StaffComplianceOrderByWithRelationInput | StaffComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for StaffCompliances.
     */
    cursor?: StaffComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StaffCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StaffCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of StaffCompliances.
     */
    distinct?: StaffComplianceScalarFieldEnum | StaffComplianceScalarFieldEnum[]
  }

  /**
   * StaffCompliance findFirstOrThrow
   */
  export type StaffComplianceFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StaffCompliance to fetch.
     */
    where?: StaffComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StaffCompliances to fetch.
     */
    orderBy?: StaffComplianceOrderByWithRelationInput | StaffComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for StaffCompliances.
     */
    cursor?: StaffComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StaffCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StaffCompliances.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of StaffCompliances.
     */
    distinct?: StaffComplianceScalarFieldEnum | StaffComplianceScalarFieldEnum[]
  }

  /**
   * StaffCompliance findMany
   */
  export type StaffComplianceFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter, which StaffCompliances to fetch.
     */
    where?: StaffComplianceWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of StaffCompliances to fetch.
     */
    orderBy?: StaffComplianceOrderByWithRelationInput | StaffComplianceOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing StaffCompliances.
     */
    cursor?: StaffComplianceWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` StaffCompliances from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` StaffCompliances.
     */
    skip?: number
    distinct?: StaffComplianceScalarFieldEnum | StaffComplianceScalarFieldEnum[]
  }

  /**
   * StaffCompliance create
   */
  export type StaffComplianceCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * The data needed to create a StaffCompliance.
     */
    data: XOR<StaffComplianceCreateInput, StaffComplianceUncheckedCreateInput>
  }

  /**
   * StaffCompliance createMany
   */
  export type StaffComplianceCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many StaffCompliances.
     */
    data: StaffComplianceCreateManyInput | StaffComplianceCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * StaffCompliance update
   */
  export type StaffComplianceUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * The data needed to update a StaffCompliance.
     */
    data: XOR<StaffComplianceUpdateInput, StaffComplianceUncheckedUpdateInput>
    /**
     * Choose, which StaffCompliance to update.
     */
    where: StaffComplianceWhereUniqueInput
  }

  /**
   * StaffCompliance updateMany
   */
  export type StaffComplianceUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update StaffCompliances.
     */
    data: XOR<StaffComplianceUpdateManyMutationInput, StaffComplianceUncheckedUpdateManyInput>
    /**
     * Filter which StaffCompliances to update
     */
    where?: StaffComplianceWhereInput
    /**
     * Limit how many StaffCompliances to update.
     */
    limit?: number
  }

  /**
   * StaffCompliance upsert
   */
  export type StaffComplianceUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * The filter to search for the StaffCompliance to update in case it exists.
     */
    where: StaffComplianceWhereUniqueInput
    /**
     * In case the StaffCompliance found by the `where` argument doesn't exist, create a new StaffCompliance with this data.
     */
    create: XOR<StaffComplianceCreateInput, StaffComplianceUncheckedCreateInput>
    /**
     * In case the StaffCompliance was found with the provided `where` argument, update it with this data.
     */
    update: XOR<StaffComplianceUpdateInput, StaffComplianceUncheckedUpdateInput>
  }

  /**
   * StaffCompliance delete
   */
  export type StaffComplianceDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
    /**
     * Filter which StaffCompliance to delete.
     */
    where: StaffComplianceWhereUniqueInput
  }

  /**
   * StaffCompliance deleteMany
   */
  export type StaffComplianceDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which StaffCompliances to delete
     */
    where?: StaffComplianceWhereInput
    /**
     * Limit how many StaffCompliances to delete.
     */
    limit?: number
  }

  /**
   * StaffCompliance without action
   */
  export type StaffComplianceDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StaffCompliance
     */
    select?: StaffComplianceSelect<ExtArgs> | null
    /**
     * Omit specific fields from the StaffCompliance
     */
    omit?: StaffComplianceOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StaffComplianceInclude<ExtArgs> | null
  }


  /**
   * Model Department
   */

  export type AggregateDepartment = {
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  export type DepartmentAvgAggregateOutputType = {
    hospital_id: number | null
  }

  export type DepartmentSumAggregateOutputType = {
    hospital_id: number | null
  }

  export type DepartmentMinAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DepartmentMaxAggregateOutputType = {
    id: string | null
    name: string | null
    description: string | null
    hospital_id: number | null
    createdAt: Date | null
    updatedAt: Date | null
  }

  export type DepartmentCountAggregateOutputType = {
    id: number
    name: number
    description: number
    hospital_id: number
    createdAt: number
    updatedAt: number
    _all: number
  }


  export type DepartmentAvgAggregateInputType = {
    hospital_id?: true
  }

  export type DepartmentSumAggregateInputType = {
    hospital_id?: true
  }

  export type DepartmentMinAggregateInputType = {
    id?: true
    name?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DepartmentMaxAggregateInputType = {
    id?: true
    name?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
  }

  export type DepartmentCountAggregateInputType = {
    id?: true
    name?: true
    description?: true
    hospital_id?: true
    createdAt?: true
    updatedAt?: true
    _all?: true
  }

  export type DepartmentAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Department to aggregate.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Departments
    **/
    _count?: true | DepartmentCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DepartmentAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DepartmentSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DepartmentMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DepartmentMaxAggregateInputType
  }

  export type GetDepartmentAggregateType<T extends DepartmentAggregateArgs> = {
        [P in keyof T & keyof AggregateDepartment]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDepartment[P]>
      : GetScalarType<T[P], AggregateDepartment[P]>
  }




  export type DepartmentGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithAggregationInput | DepartmentOrderByWithAggregationInput[]
    by: DepartmentScalarFieldEnum[] | DepartmentScalarFieldEnum
    having?: DepartmentScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DepartmentCountAggregateInputType | true
    _avg?: DepartmentAvgAggregateInputType
    _sum?: DepartmentSumAggregateInputType
    _min?: DepartmentMinAggregateInputType
    _max?: DepartmentMaxAggregateInputType
  }

  export type DepartmentGroupByOutputType = {
    id: string
    name: string
    description: string | null
    hospital_id: number | null
    createdAt: Date
    updatedAt: Date
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  type GetDepartmentGroupByPayload<T extends DepartmentGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DepartmentGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DepartmentGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
            : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
        }
      >
    >


  export type DepartmentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
    hospital?: boolean | Department$hospitalArgs<ExtArgs>
  }, ExtArgs["result"]["department"]>



  export type DepartmentSelectScalar = {
    id?: boolean
    name?: boolean
    description?: boolean
    hospital_id?: boolean
    createdAt?: boolean
    updatedAt?: boolean
  }

  export type DepartmentOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "description" | "hospital_id" | "createdAt" | "updatedAt", ExtArgs["result"]["department"]>
  export type DepartmentInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    hospital?: boolean | Department$hospitalArgs<ExtArgs>
  }

  export type $DepartmentPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Department"
    objects: {
      hospital: Prisma.$HospitalPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
      description: string | null
      hospital_id: number | null
      createdAt: Date
      updatedAt: Date
    }, ExtArgs["result"]["department"]>
    composites: {}
  }

  type DepartmentGetPayload<S extends boolean | null | undefined | DepartmentDefaultArgs> = $Result.GetResult<Prisma.$DepartmentPayload, S>

  type DepartmentCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<DepartmentFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: DepartmentCountAggregateInputType | true
    }

  export interface DepartmentDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Department'], meta: { name: 'Department' } }
    /**
     * Find zero or one Department that matches the filter.
     * @param {DepartmentFindUniqueArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends DepartmentFindUniqueArgs>(args: SelectSubset<T, DepartmentFindUniqueArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Department that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {DepartmentFindUniqueOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends DepartmentFindUniqueOrThrowArgs>(args: SelectSubset<T, DepartmentFindUniqueOrThrowArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Department that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends DepartmentFindFirstArgs>(args?: SelectSubset<T, DepartmentFindFirstArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Department that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends DepartmentFindFirstOrThrowArgs>(args?: SelectSubset<T, DepartmentFindFirstOrThrowArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Departments that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Departments
     * const departments = await prisma.department.findMany()
     * 
     * // Get first 10 Departments
     * const departments = await prisma.department.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const departmentWithIdOnly = await prisma.department.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends DepartmentFindManyArgs>(args?: SelectSubset<T, DepartmentFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Department.
     * @param {DepartmentCreateArgs} args - Arguments to create a Department.
     * @example
     * // Create one Department
     * const Department = await prisma.department.create({
     *   data: {
     *     // ... data to create a Department
     *   }
     * })
     * 
     */
    create<T extends DepartmentCreateArgs>(args: SelectSubset<T, DepartmentCreateArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Departments.
     * @param {DepartmentCreateManyArgs} args - Arguments to create many Departments.
     * @example
     * // Create many Departments
     * const department = await prisma.department.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends DepartmentCreateManyArgs>(args?: SelectSubset<T, DepartmentCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Department.
     * @param {DepartmentDeleteArgs} args - Arguments to delete one Department.
     * @example
     * // Delete one Department
     * const Department = await prisma.department.delete({
     *   where: {
     *     // ... filter to delete one Department
     *   }
     * })
     * 
     */
    delete<T extends DepartmentDeleteArgs>(args: SelectSubset<T, DepartmentDeleteArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Department.
     * @param {DepartmentUpdateArgs} args - Arguments to update one Department.
     * @example
     * // Update one Department
     * const department = await prisma.department.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends DepartmentUpdateArgs>(args: SelectSubset<T, DepartmentUpdateArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Departments.
     * @param {DepartmentDeleteManyArgs} args - Arguments to filter Departments to delete.
     * @example
     * // Delete a few Departments
     * const { count } = await prisma.department.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends DepartmentDeleteManyArgs>(args?: SelectSubset<T, DepartmentDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Departments
     * const department = await prisma.department.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends DepartmentUpdateManyArgs>(args: SelectSubset<T, DepartmentUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Department.
     * @param {DepartmentUpsertArgs} args - Arguments to update or create a Department.
     * @example
     * // Update or create a Department
     * const department = await prisma.department.upsert({
     *   create: {
     *     // ... data to create a Department
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Department we want to update
     *   }
     * })
     */
    upsert<T extends DepartmentUpsertArgs>(args: SelectSubset<T, DepartmentUpsertArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentCountArgs} args - Arguments to filter Departments to count.
     * @example
     * // Count the number of Departments
     * const count = await prisma.department.count({
     *   where: {
     *     // ... the filter for the Departments we want to count
     *   }
     * })
    **/
    count<T extends DepartmentCountArgs>(
      args?: Subset<T, DepartmentCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DepartmentCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DepartmentAggregateArgs>(args: Subset<T, DepartmentAggregateArgs>): Prisma.PrismaPromise<GetDepartmentAggregateType<T>>

    /**
     * Group by Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DepartmentGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DepartmentGroupByArgs['orderBy'] }
        : { orderBy?: DepartmentGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DepartmentGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDepartmentGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Department model
   */
  readonly fields: DepartmentFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Department.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DepartmentClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    hospital<T extends Department$hospitalArgs<ExtArgs> = {}>(args?: Subset<T, Department$hospitalArgs<ExtArgs>>): Prisma__HospitalClient<$Result.GetResult<Prisma.$HospitalPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Department model
   */
  interface DepartmentFieldRefs {
    readonly id: FieldRef<"Department", 'String'>
    readonly name: FieldRef<"Department", 'String'>
    readonly description: FieldRef<"Department", 'String'>
    readonly hospital_id: FieldRef<"Department", 'Int'>
    readonly createdAt: FieldRef<"Department", 'DateTime'>
    readonly updatedAt: FieldRef<"Department", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Department findUnique
   */
  export type DepartmentFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findUniqueOrThrow
   */
  export type DepartmentFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findFirst
   */
  export type DepartmentFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findFirstOrThrow
   */
  export type DepartmentFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findMany
   */
  export type DepartmentFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Departments to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department create
   */
  export type DepartmentCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to create a Department.
     */
    data: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
  }

  /**
   * Department createMany
   */
  export type DepartmentCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Departments.
     */
    data: DepartmentCreateManyInput | DepartmentCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Department update
   */
  export type DepartmentUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to update a Department.
     */
    data: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
    /**
     * Choose, which Department to update.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department updateMany
   */
  export type DepartmentUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Departments.
     */
    data: XOR<DepartmentUpdateManyMutationInput, DepartmentUncheckedUpdateManyInput>
    /**
     * Filter which Departments to update
     */
    where?: DepartmentWhereInput
    /**
     * Limit how many Departments to update.
     */
    limit?: number
  }

  /**
   * Department upsert
   */
  export type DepartmentUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The filter to search for the Department to update in case it exists.
     */
    where: DepartmentWhereUniqueInput
    /**
     * In case the Department found by the `where` argument doesn't exist, create a new Department with this data.
     */
    create: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
    /**
     * In case the Department was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
  }

  /**
   * Department delete
   */
  export type DepartmentDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter which Department to delete.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department deleteMany
   */
  export type DepartmentDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Departments to delete
     */
    where?: DepartmentWhereInput
    /**
     * Limit how many Departments to delete.
     */
    limit?: number
  }

  /**
   * Department.hospital
   */
  export type Department$hospitalArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Hospital
     */
    select?: HospitalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Hospital
     */
    omit?: HospitalOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: HospitalInclude<ExtArgs> | null
    where?: HospitalWhereInput
  }

  /**
   * Department without action
   */
  export type DepartmentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Department
     */
    omit?: DepartmentOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
  }


  /**
   * Model PolicyStatus
   */

  export type AggregatePolicyStatus = {
    _count: PolicyStatusCountAggregateOutputType | null
    _avg: PolicyStatusAvgAggregateOutputType | null
    _sum: PolicyStatusSumAggregateOutputType | null
    _min: PolicyStatusMinAggregateOutputType | null
    _max: PolicyStatusMaxAggregateOutputType | null
  }

  export type PolicyStatusAvgAggregateOutputType = {
    id: number | null
  }

  export type PolicyStatusSumAggregateOutputType = {
    id: number | null
  }

  export type PolicyStatusMinAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PolicyStatusMaxAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PolicyStatusCountAggregateOutputType = {
    id: number
    value: number
    label: number
    description: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type PolicyStatusAvgAggregateInputType = {
    id?: true
  }

  export type PolicyStatusSumAggregateInputType = {
    id?: true
  }

  export type PolicyStatusMinAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type PolicyStatusMaxAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type PolicyStatusCountAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type PolicyStatusAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PolicyStatus to aggregate.
     */
    where?: PolicyStatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyStatuses to fetch.
     */
    orderBy?: PolicyStatusOrderByWithRelationInput | PolicyStatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PolicyStatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyStatuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyStatuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned PolicyStatuses
    **/
    _count?: true | PolicyStatusCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: PolicyStatusAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: PolicyStatusSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PolicyStatusMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PolicyStatusMaxAggregateInputType
  }

  export type GetPolicyStatusAggregateType<T extends PolicyStatusAggregateArgs> = {
        [P in keyof T & keyof AggregatePolicyStatus]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePolicyStatus[P]>
      : GetScalarType<T[P], AggregatePolicyStatus[P]>
  }




  export type PolicyStatusGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PolicyStatusWhereInput
    orderBy?: PolicyStatusOrderByWithAggregationInput | PolicyStatusOrderByWithAggregationInput[]
    by: PolicyStatusScalarFieldEnum[] | PolicyStatusScalarFieldEnum
    having?: PolicyStatusScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PolicyStatusCountAggregateInputType | true
    _avg?: PolicyStatusAvgAggregateInputType
    _sum?: PolicyStatusSumAggregateInputType
    _min?: PolicyStatusMinAggregateInputType
    _max?: PolicyStatusMaxAggregateInputType
  }

  export type PolicyStatusGroupByOutputType = {
    id: number
    value: string
    label: string
    description: string | null
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: PolicyStatusCountAggregateOutputType | null
    _avg: PolicyStatusAvgAggregateOutputType | null
    _sum: PolicyStatusSumAggregateOutputType | null
    _min: PolicyStatusMinAggregateOutputType | null
    _max: PolicyStatusMaxAggregateOutputType | null
  }

  type GetPolicyStatusGroupByPayload<T extends PolicyStatusGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PolicyStatusGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PolicyStatusGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PolicyStatusGroupByOutputType[P]>
            : GetScalarType<T[P], PolicyStatusGroupByOutputType[P]>
        }
      >
    >


  export type PolicyStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["policyStatus"]>



  export type PolicyStatusSelectScalar = {
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type PolicyStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "value" | "label" | "description" | "is_active" | "created_at" | "updated_at", ExtArgs["result"]["policyStatus"]>

  export type $PolicyStatusPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "PolicyStatus"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      value: string
      label: string
      description: string | null
      is_active: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["policyStatus"]>
    composites: {}
  }

  type PolicyStatusGetPayload<S extends boolean | null | undefined | PolicyStatusDefaultArgs> = $Result.GetResult<Prisma.$PolicyStatusPayload, S>

  type PolicyStatusCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<PolicyStatusFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: PolicyStatusCountAggregateInputType | true
    }

  export interface PolicyStatusDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['PolicyStatus'], meta: { name: 'PolicyStatus' } }
    /**
     * Find zero or one PolicyStatus that matches the filter.
     * @param {PolicyStatusFindUniqueArgs} args - Arguments to find a PolicyStatus
     * @example
     * // Get one PolicyStatus
     * const policyStatus = await prisma.policyStatus.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends PolicyStatusFindUniqueArgs>(args: SelectSubset<T, PolicyStatusFindUniqueArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one PolicyStatus that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {PolicyStatusFindUniqueOrThrowArgs} args - Arguments to find a PolicyStatus
     * @example
     * // Get one PolicyStatus
     * const policyStatus = await prisma.policyStatus.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends PolicyStatusFindUniqueOrThrowArgs>(args: SelectSubset<T, PolicyStatusFindUniqueOrThrowArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first PolicyStatus that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusFindFirstArgs} args - Arguments to find a PolicyStatus
     * @example
     * // Get one PolicyStatus
     * const policyStatus = await prisma.policyStatus.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends PolicyStatusFindFirstArgs>(args?: SelectSubset<T, PolicyStatusFindFirstArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first PolicyStatus that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusFindFirstOrThrowArgs} args - Arguments to find a PolicyStatus
     * @example
     * // Get one PolicyStatus
     * const policyStatus = await prisma.policyStatus.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends PolicyStatusFindFirstOrThrowArgs>(args?: SelectSubset<T, PolicyStatusFindFirstOrThrowArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more PolicyStatuses that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all PolicyStatuses
     * const policyStatuses = await prisma.policyStatus.findMany()
     * 
     * // Get first 10 PolicyStatuses
     * const policyStatuses = await prisma.policyStatus.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const policyStatusWithIdOnly = await prisma.policyStatus.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends PolicyStatusFindManyArgs>(args?: SelectSubset<T, PolicyStatusFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a PolicyStatus.
     * @param {PolicyStatusCreateArgs} args - Arguments to create a PolicyStatus.
     * @example
     * // Create one PolicyStatus
     * const PolicyStatus = await prisma.policyStatus.create({
     *   data: {
     *     // ... data to create a PolicyStatus
     *   }
     * })
     * 
     */
    create<T extends PolicyStatusCreateArgs>(args: SelectSubset<T, PolicyStatusCreateArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many PolicyStatuses.
     * @param {PolicyStatusCreateManyArgs} args - Arguments to create many PolicyStatuses.
     * @example
     * // Create many PolicyStatuses
     * const policyStatus = await prisma.policyStatus.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends PolicyStatusCreateManyArgs>(args?: SelectSubset<T, PolicyStatusCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a PolicyStatus.
     * @param {PolicyStatusDeleteArgs} args - Arguments to delete one PolicyStatus.
     * @example
     * // Delete one PolicyStatus
     * const PolicyStatus = await prisma.policyStatus.delete({
     *   where: {
     *     // ... filter to delete one PolicyStatus
     *   }
     * })
     * 
     */
    delete<T extends PolicyStatusDeleteArgs>(args: SelectSubset<T, PolicyStatusDeleteArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one PolicyStatus.
     * @param {PolicyStatusUpdateArgs} args - Arguments to update one PolicyStatus.
     * @example
     * // Update one PolicyStatus
     * const policyStatus = await prisma.policyStatus.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends PolicyStatusUpdateArgs>(args: SelectSubset<T, PolicyStatusUpdateArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more PolicyStatuses.
     * @param {PolicyStatusDeleteManyArgs} args - Arguments to filter PolicyStatuses to delete.
     * @example
     * // Delete a few PolicyStatuses
     * const { count } = await prisma.policyStatus.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends PolicyStatusDeleteManyArgs>(args?: SelectSubset<T, PolicyStatusDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more PolicyStatuses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many PolicyStatuses
     * const policyStatus = await prisma.policyStatus.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends PolicyStatusUpdateManyArgs>(args: SelectSubset<T, PolicyStatusUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one PolicyStatus.
     * @param {PolicyStatusUpsertArgs} args - Arguments to update or create a PolicyStatus.
     * @example
     * // Update or create a PolicyStatus
     * const policyStatus = await prisma.policyStatus.upsert({
     *   create: {
     *     // ... data to create a PolicyStatus
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the PolicyStatus we want to update
     *   }
     * })
     */
    upsert<T extends PolicyStatusUpsertArgs>(args: SelectSubset<T, PolicyStatusUpsertArgs<ExtArgs>>): Prisma__PolicyStatusClient<$Result.GetResult<Prisma.$PolicyStatusPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of PolicyStatuses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusCountArgs} args - Arguments to filter PolicyStatuses to count.
     * @example
     * // Count the number of PolicyStatuses
     * const count = await prisma.policyStatus.count({
     *   where: {
     *     // ... the filter for the PolicyStatuses we want to count
     *   }
     * })
    **/
    count<T extends PolicyStatusCountArgs>(
      args?: Subset<T, PolicyStatusCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PolicyStatusCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a PolicyStatus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PolicyStatusAggregateArgs>(args: Subset<T, PolicyStatusAggregateArgs>): Prisma.PrismaPromise<GetPolicyStatusAggregateType<T>>

    /**
     * Group by PolicyStatus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyStatusGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PolicyStatusGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PolicyStatusGroupByArgs['orderBy'] }
        : { orderBy?: PolicyStatusGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PolicyStatusGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPolicyStatusGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the PolicyStatus model
   */
  readonly fields: PolicyStatusFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for PolicyStatus.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PolicyStatusClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the PolicyStatus model
   */
  interface PolicyStatusFieldRefs {
    readonly id: FieldRef<"PolicyStatus", 'Int'>
    readonly value: FieldRef<"PolicyStatus", 'String'>
    readonly label: FieldRef<"PolicyStatus", 'String'>
    readonly description: FieldRef<"PolicyStatus", 'String'>
    readonly is_active: FieldRef<"PolicyStatus", 'Boolean'>
    readonly created_at: FieldRef<"PolicyStatus", 'DateTime'>
    readonly updated_at: FieldRef<"PolicyStatus", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * PolicyStatus findUnique
   */
  export type PolicyStatusFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter, which PolicyStatus to fetch.
     */
    where: PolicyStatusWhereUniqueInput
  }

  /**
   * PolicyStatus findUniqueOrThrow
   */
  export type PolicyStatusFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter, which PolicyStatus to fetch.
     */
    where: PolicyStatusWhereUniqueInput
  }

  /**
   * PolicyStatus findFirst
   */
  export type PolicyStatusFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter, which PolicyStatus to fetch.
     */
    where?: PolicyStatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyStatuses to fetch.
     */
    orderBy?: PolicyStatusOrderByWithRelationInput | PolicyStatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PolicyStatuses.
     */
    cursor?: PolicyStatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyStatuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyStatuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PolicyStatuses.
     */
    distinct?: PolicyStatusScalarFieldEnum | PolicyStatusScalarFieldEnum[]
  }

  /**
   * PolicyStatus findFirstOrThrow
   */
  export type PolicyStatusFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter, which PolicyStatus to fetch.
     */
    where?: PolicyStatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyStatuses to fetch.
     */
    orderBy?: PolicyStatusOrderByWithRelationInput | PolicyStatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PolicyStatuses.
     */
    cursor?: PolicyStatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyStatuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyStatuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PolicyStatuses.
     */
    distinct?: PolicyStatusScalarFieldEnum | PolicyStatusScalarFieldEnum[]
  }

  /**
   * PolicyStatus findMany
   */
  export type PolicyStatusFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter, which PolicyStatuses to fetch.
     */
    where?: PolicyStatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyStatuses to fetch.
     */
    orderBy?: PolicyStatusOrderByWithRelationInput | PolicyStatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing PolicyStatuses.
     */
    cursor?: PolicyStatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyStatuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyStatuses.
     */
    skip?: number
    distinct?: PolicyStatusScalarFieldEnum | PolicyStatusScalarFieldEnum[]
  }

  /**
   * PolicyStatus create
   */
  export type PolicyStatusCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * The data needed to create a PolicyStatus.
     */
    data: XOR<PolicyStatusCreateInput, PolicyStatusUncheckedCreateInput>
  }

  /**
   * PolicyStatus createMany
   */
  export type PolicyStatusCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many PolicyStatuses.
     */
    data: PolicyStatusCreateManyInput | PolicyStatusCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * PolicyStatus update
   */
  export type PolicyStatusUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * The data needed to update a PolicyStatus.
     */
    data: XOR<PolicyStatusUpdateInput, PolicyStatusUncheckedUpdateInput>
    /**
     * Choose, which PolicyStatus to update.
     */
    where: PolicyStatusWhereUniqueInput
  }

  /**
   * PolicyStatus updateMany
   */
  export type PolicyStatusUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update PolicyStatuses.
     */
    data: XOR<PolicyStatusUpdateManyMutationInput, PolicyStatusUncheckedUpdateManyInput>
    /**
     * Filter which PolicyStatuses to update
     */
    where?: PolicyStatusWhereInput
    /**
     * Limit how many PolicyStatuses to update.
     */
    limit?: number
  }

  /**
   * PolicyStatus upsert
   */
  export type PolicyStatusUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * The filter to search for the PolicyStatus to update in case it exists.
     */
    where: PolicyStatusWhereUniqueInput
    /**
     * In case the PolicyStatus found by the `where` argument doesn't exist, create a new PolicyStatus with this data.
     */
    create: XOR<PolicyStatusCreateInput, PolicyStatusUncheckedCreateInput>
    /**
     * In case the PolicyStatus was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PolicyStatusUpdateInput, PolicyStatusUncheckedUpdateInput>
  }

  /**
   * PolicyStatus delete
   */
  export type PolicyStatusDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
    /**
     * Filter which PolicyStatus to delete.
     */
    where: PolicyStatusWhereUniqueInput
  }

  /**
   * PolicyStatus deleteMany
   */
  export type PolicyStatusDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PolicyStatuses to delete
     */
    where?: PolicyStatusWhereInput
    /**
     * Limit how many PolicyStatuses to delete.
     */
    limit?: number
  }

  /**
   * PolicyStatus without action
   */
  export type PolicyStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyStatus
     */
    select?: PolicyStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyStatus
     */
    omit?: PolicyStatusOmit<ExtArgs> | null
  }


  /**
   * Model PolicyCategory
   */

  export type AggregatePolicyCategory = {
    _count: PolicyCategoryCountAggregateOutputType | null
    _avg: PolicyCategoryAvgAggregateOutputType | null
    _sum: PolicyCategorySumAggregateOutputType | null
    _min: PolicyCategoryMinAggregateOutputType | null
    _max: PolicyCategoryMaxAggregateOutputType | null
  }

  export type PolicyCategoryAvgAggregateOutputType = {
    id: number | null
  }

  export type PolicyCategorySumAggregateOutputType = {
    id: number | null
  }

  export type PolicyCategoryMinAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PolicyCategoryMaxAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type PolicyCategoryCountAggregateOutputType = {
    id: number
    value: number
    label: number
    description: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type PolicyCategoryAvgAggregateInputType = {
    id?: true
  }

  export type PolicyCategorySumAggregateInputType = {
    id?: true
  }

  export type PolicyCategoryMinAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type PolicyCategoryMaxAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type PolicyCategoryCountAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type PolicyCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PolicyCategory to aggregate.
     */
    where?: PolicyCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyCategories to fetch.
     */
    orderBy?: PolicyCategoryOrderByWithRelationInput | PolicyCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PolicyCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned PolicyCategories
    **/
    _count?: true | PolicyCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: PolicyCategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: PolicyCategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PolicyCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PolicyCategoryMaxAggregateInputType
  }

  export type GetPolicyCategoryAggregateType<T extends PolicyCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregatePolicyCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePolicyCategory[P]>
      : GetScalarType<T[P], AggregatePolicyCategory[P]>
  }




  export type PolicyCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PolicyCategoryWhereInput
    orderBy?: PolicyCategoryOrderByWithAggregationInput | PolicyCategoryOrderByWithAggregationInput[]
    by: PolicyCategoryScalarFieldEnum[] | PolicyCategoryScalarFieldEnum
    having?: PolicyCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PolicyCategoryCountAggregateInputType | true
    _avg?: PolicyCategoryAvgAggregateInputType
    _sum?: PolicyCategorySumAggregateInputType
    _min?: PolicyCategoryMinAggregateInputType
    _max?: PolicyCategoryMaxAggregateInputType
  }

  export type PolicyCategoryGroupByOutputType = {
    id: number
    value: string
    label: string
    description: string | null
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: PolicyCategoryCountAggregateOutputType | null
    _avg: PolicyCategoryAvgAggregateOutputType | null
    _sum: PolicyCategorySumAggregateOutputType | null
    _min: PolicyCategoryMinAggregateOutputType | null
    _max: PolicyCategoryMaxAggregateOutputType | null
  }

  type GetPolicyCategoryGroupByPayload<T extends PolicyCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PolicyCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PolicyCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PolicyCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], PolicyCategoryGroupByOutputType[P]>
        }
      >
    >


  export type PolicyCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["policyCategory"]>



  export type PolicyCategorySelectScalar = {
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type PolicyCategoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "value" | "label" | "description" | "is_active" | "created_at" | "updated_at", ExtArgs["result"]["policyCategory"]>

  export type $PolicyCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "PolicyCategory"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      value: string
      label: string
      description: string | null
      is_active: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["policyCategory"]>
    composites: {}
  }

  type PolicyCategoryGetPayload<S extends boolean | null | undefined | PolicyCategoryDefaultArgs> = $Result.GetResult<Prisma.$PolicyCategoryPayload, S>

  type PolicyCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<PolicyCategoryFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: PolicyCategoryCountAggregateInputType | true
    }

  export interface PolicyCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['PolicyCategory'], meta: { name: 'PolicyCategory' } }
    /**
     * Find zero or one PolicyCategory that matches the filter.
     * @param {PolicyCategoryFindUniqueArgs} args - Arguments to find a PolicyCategory
     * @example
     * // Get one PolicyCategory
     * const policyCategory = await prisma.policyCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends PolicyCategoryFindUniqueArgs>(args: SelectSubset<T, PolicyCategoryFindUniqueArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one PolicyCategory that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {PolicyCategoryFindUniqueOrThrowArgs} args - Arguments to find a PolicyCategory
     * @example
     * // Get one PolicyCategory
     * const policyCategory = await prisma.policyCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends PolicyCategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, PolicyCategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first PolicyCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryFindFirstArgs} args - Arguments to find a PolicyCategory
     * @example
     * // Get one PolicyCategory
     * const policyCategory = await prisma.policyCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends PolicyCategoryFindFirstArgs>(args?: SelectSubset<T, PolicyCategoryFindFirstArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first PolicyCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryFindFirstOrThrowArgs} args - Arguments to find a PolicyCategory
     * @example
     * // Get one PolicyCategory
     * const policyCategory = await prisma.policyCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends PolicyCategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, PolicyCategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more PolicyCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all PolicyCategories
     * const policyCategories = await prisma.policyCategory.findMany()
     * 
     * // Get first 10 PolicyCategories
     * const policyCategories = await prisma.policyCategory.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const policyCategoryWithIdOnly = await prisma.policyCategory.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends PolicyCategoryFindManyArgs>(args?: SelectSubset<T, PolicyCategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a PolicyCategory.
     * @param {PolicyCategoryCreateArgs} args - Arguments to create a PolicyCategory.
     * @example
     * // Create one PolicyCategory
     * const PolicyCategory = await prisma.policyCategory.create({
     *   data: {
     *     // ... data to create a PolicyCategory
     *   }
     * })
     * 
     */
    create<T extends PolicyCategoryCreateArgs>(args: SelectSubset<T, PolicyCategoryCreateArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many PolicyCategories.
     * @param {PolicyCategoryCreateManyArgs} args - Arguments to create many PolicyCategories.
     * @example
     * // Create many PolicyCategories
     * const policyCategory = await prisma.policyCategory.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends PolicyCategoryCreateManyArgs>(args?: SelectSubset<T, PolicyCategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a PolicyCategory.
     * @param {PolicyCategoryDeleteArgs} args - Arguments to delete one PolicyCategory.
     * @example
     * // Delete one PolicyCategory
     * const PolicyCategory = await prisma.policyCategory.delete({
     *   where: {
     *     // ... filter to delete one PolicyCategory
     *   }
     * })
     * 
     */
    delete<T extends PolicyCategoryDeleteArgs>(args: SelectSubset<T, PolicyCategoryDeleteArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one PolicyCategory.
     * @param {PolicyCategoryUpdateArgs} args - Arguments to update one PolicyCategory.
     * @example
     * // Update one PolicyCategory
     * const policyCategory = await prisma.policyCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends PolicyCategoryUpdateArgs>(args: SelectSubset<T, PolicyCategoryUpdateArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more PolicyCategories.
     * @param {PolicyCategoryDeleteManyArgs} args - Arguments to filter PolicyCategories to delete.
     * @example
     * // Delete a few PolicyCategories
     * const { count } = await prisma.policyCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends PolicyCategoryDeleteManyArgs>(args?: SelectSubset<T, PolicyCategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more PolicyCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many PolicyCategories
     * const policyCategory = await prisma.policyCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends PolicyCategoryUpdateManyArgs>(args: SelectSubset<T, PolicyCategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one PolicyCategory.
     * @param {PolicyCategoryUpsertArgs} args - Arguments to update or create a PolicyCategory.
     * @example
     * // Update or create a PolicyCategory
     * const policyCategory = await prisma.policyCategory.upsert({
     *   create: {
     *     // ... data to create a PolicyCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the PolicyCategory we want to update
     *   }
     * })
     */
    upsert<T extends PolicyCategoryUpsertArgs>(args: SelectSubset<T, PolicyCategoryUpsertArgs<ExtArgs>>): Prisma__PolicyCategoryClient<$Result.GetResult<Prisma.$PolicyCategoryPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of PolicyCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryCountArgs} args - Arguments to filter PolicyCategories to count.
     * @example
     * // Count the number of PolicyCategories
     * const count = await prisma.policyCategory.count({
     *   where: {
     *     // ... the filter for the PolicyCategories we want to count
     *   }
     * })
    **/
    count<T extends PolicyCategoryCountArgs>(
      args?: Subset<T, PolicyCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PolicyCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a PolicyCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PolicyCategoryAggregateArgs>(args: Subset<T, PolicyCategoryAggregateArgs>): Prisma.PrismaPromise<GetPolicyCategoryAggregateType<T>>

    /**
     * Group by PolicyCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PolicyCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PolicyCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PolicyCategoryGroupByArgs['orderBy'] }
        : { orderBy?: PolicyCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PolicyCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPolicyCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the PolicyCategory model
   */
  readonly fields: PolicyCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for PolicyCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PolicyCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the PolicyCategory model
   */
  interface PolicyCategoryFieldRefs {
    readonly id: FieldRef<"PolicyCategory", 'Int'>
    readonly value: FieldRef<"PolicyCategory", 'String'>
    readonly label: FieldRef<"PolicyCategory", 'String'>
    readonly description: FieldRef<"PolicyCategory", 'String'>
    readonly is_active: FieldRef<"PolicyCategory", 'Boolean'>
    readonly created_at: FieldRef<"PolicyCategory", 'DateTime'>
    readonly updated_at: FieldRef<"PolicyCategory", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * PolicyCategory findUnique
   */
  export type PolicyCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter, which PolicyCategory to fetch.
     */
    where: PolicyCategoryWhereUniqueInput
  }

  /**
   * PolicyCategory findUniqueOrThrow
   */
  export type PolicyCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter, which PolicyCategory to fetch.
     */
    where: PolicyCategoryWhereUniqueInput
  }

  /**
   * PolicyCategory findFirst
   */
  export type PolicyCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter, which PolicyCategory to fetch.
     */
    where?: PolicyCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyCategories to fetch.
     */
    orderBy?: PolicyCategoryOrderByWithRelationInput | PolicyCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PolicyCategories.
     */
    cursor?: PolicyCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PolicyCategories.
     */
    distinct?: PolicyCategoryScalarFieldEnum | PolicyCategoryScalarFieldEnum[]
  }

  /**
   * PolicyCategory findFirstOrThrow
   */
  export type PolicyCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter, which PolicyCategory to fetch.
     */
    where?: PolicyCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyCategories to fetch.
     */
    orderBy?: PolicyCategoryOrderByWithRelationInput | PolicyCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for PolicyCategories.
     */
    cursor?: PolicyCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of PolicyCategories.
     */
    distinct?: PolicyCategoryScalarFieldEnum | PolicyCategoryScalarFieldEnum[]
  }

  /**
   * PolicyCategory findMany
   */
  export type PolicyCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter, which PolicyCategories to fetch.
     */
    where?: PolicyCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of PolicyCategories to fetch.
     */
    orderBy?: PolicyCategoryOrderByWithRelationInput | PolicyCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing PolicyCategories.
     */
    cursor?: PolicyCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` PolicyCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` PolicyCategories.
     */
    skip?: number
    distinct?: PolicyCategoryScalarFieldEnum | PolicyCategoryScalarFieldEnum[]
  }

  /**
   * PolicyCategory create
   */
  export type PolicyCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * The data needed to create a PolicyCategory.
     */
    data: XOR<PolicyCategoryCreateInput, PolicyCategoryUncheckedCreateInput>
  }

  /**
   * PolicyCategory createMany
   */
  export type PolicyCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many PolicyCategories.
     */
    data: PolicyCategoryCreateManyInput | PolicyCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * PolicyCategory update
   */
  export type PolicyCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * The data needed to update a PolicyCategory.
     */
    data: XOR<PolicyCategoryUpdateInput, PolicyCategoryUncheckedUpdateInput>
    /**
     * Choose, which PolicyCategory to update.
     */
    where: PolicyCategoryWhereUniqueInput
  }

  /**
   * PolicyCategory updateMany
   */
  export type PolicyCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update PolicyCategories.
     */
    data: XOR<PolicyCategoryUpdateManyMutationInput, PolicyCategoryUncheckedUpdateManyInput>
    /**
     * Filter which PolicyCategories to update
     */
    where?: PolicyCategoryWhereInput
    /**
     * Limit how many PolicyCategories to update.
     */
    limit?: number
  }

  /**
   * PolicyCategory upsert
   */
  export type PolicyCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * The filter to search for the PolicyCategory to update in case it exists.
     */
    where: PolicyCategoryWhereUniqueInput
    /**
     * In case the PolicyCategory found by the `where` argument doesn't exist, create a new PolicyCategory with this data.
     */
    create: XOR<PolicyCategoryCreateInput, PolicyCategoryUncheckedCreateInput>
    /**
     * In case the PolicyCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PolicyCategoryUpdateInput, PolicyCategoryUncheckedUpdateInput>
  }

  /**
   * PolicyCategory delete
   */
  export type PolicyCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
    /**
     * Filter which PolicyCategory to delete.
     */
    where: PolicyCategoryWhereUniqueInput
  }

  /**
   * PolicyCategory deleteMany
   */
  export type PolicyCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which PolicyCategories to delete
     */
    where?: PolicyCategoryWhereInput
    /**
     * Limit how many PolicyCategories to delete.
     */
    limit?: number
  }

  /**
   * PolicyCategory without action
   */
  export type PolicyCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PolicyCategory
     */
    select?: PolicyCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the PolicyCategory
     */
    omit?: PolicyCategoryOmit<ExtArgs> | null
  }


  /**
   * Model ReportType
   */

  export type AggregateReportType = {
    _count: ReportTypeCountAggregateOutputType | null
    _avg: ReportTypeAvgAggregateOutputType | null
    _sum: ReportTypeSumAggregateOutputType | null
    _min: ReportTypeMinAggregateOutputType | null
    _max: ReportTypeMaxAggregateOutputType | null
  }

  export type ReportTypeAvgAggregateOutputType = {
    id: number | null
  }

  export type ReportTypeSumAggregateOutputType = {
    id: number | null
  }

  export type ReportTypeMinAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ReportTypeMaxAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ReportTypeCountAggregateOutputType = {
    id: number
    value: number
    label: number
    description: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ReportTypeAvgAggregateInputType = {
    id?: true
  }

  export type ReportTypeSumAggregateInputType = {
    id?: true
  }

  export type ReportTypeMinAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type ReportTypeMaxAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type ReportTypeCountAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ReportTypeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReportType to aggregate.
     */
    where?: ReportTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReportTypes to fetch.
     */
    orderBy?: ReportTypeOrderByWithRelationInput | ReportTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ReportTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReportTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReportTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ReportTypes
    **/
    _count?: true | ReportTypeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ReportTypeAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ReportTypeSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ReportTypeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ReportTypeMaxAggregateInputType
  }

  export type GetReportTypeAggregateType<T extends ReportTypeAggregateArgs> = {
        [P in keyof T & keyof AggregateReportType]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateReportType[P]>
      : GetScalarType<T[P], AggregateReportType[P]>
  }




  export type ReportTypeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReportTypeWhereInput
    orderBy?: ReportTypeOrderByWithAggregationInput | ReportTypeOrderByWithAggregationInput[]
    by: ReportTypeScalarFieldEnum[] | ReportTypeScalarFieldEnum
    having?: ReportTypeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ReportTypeCountAggregateInputType | true
    _avg?: ReportTypeAvgAggregateInputType
    _sum?: ReportTypeSumAggregateInputType
    _min?: ReportTypeMinAggregateInputType
    _max?: ReportTypeMaxAggregateInputType
  }

  export type ReportTypeGroupByOutputType = {
    id: number
    value: string
    label: string
    description: string | null
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: ReportTypeCountAggregateOutputType | null
    _avg: ReportTypeAvgAggregateOutputType | null
    _sum: ReportTypeSumAggregateOutputType | null
    _min: ReportTypeMinAggregateOutputType | null
    _max: ReportTypeMaxAggregateOutputType | null
  }

  type GetReportTypeGroupByPayload<T extends ReportTypeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ReportTypeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ReportTypeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ReportTypeGroupByOutputType[P]>
            : GetScalarType<T[P], ReportTypeGroupByOutputType[P]>
        }
      >
    >


  export type ReportTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["reportType"]>



  export type ReportTypeSelectScalar = {
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ReportTypeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "value" | "label" | "description" | "is_active" | "created_at" | "updated_at", ExtArgs["result"]["reportType"]>

  export type $ReportTypePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ReportType"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      value: string
      label: string
      description: string | null
      is_active: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["reportType"]>
    composites: {}
  }

  type ReportTypeGetPayload<S extends boolean | null | undefined | ReportTypeDefaultArgs> = $Result.GetResult<Prisma.$ReportTypePayload, S>

  type ReportTypeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ReportTypeFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ReportTypeCountAggregateInputType | true
    }

  export interface ReportTypeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ReportType'], meta: { name: 'ReportType' } }
    /**
     * Find zero or one ReportType that matches the filter.
     * @param {ReportTypeFindUniqueArgs} args - Arguments to find a ReportType
     * @example
     * // Get one ReportType
     * const reportType = await prisma.reportType.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ReportTypeFindUniqueArgs>(args: SelectSubset<T, ReportTypeFindUniqueArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one ReportType that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ReportTypeFindUniqueOrThrowArgs} args - Arguments to find a ReportType
     * @example
     * // Get one ReportType
     * const reportType = await prisma.reportType.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ReportTypeFindUniqueOrThrowArgs>(args: SelectSubset<T, ReportTypeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ReportType that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeFindFirstArgs} args - Arguments to find a ReportType
     * @example
     * // Get one ReportType
     * const reportType = await prisma.reportType.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ReportTypeFindFirstArgs>(args?: SelectSubset<T, ReportTypeFindFirstArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first ReportType that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeFindFirstOrThrowArgs} args - Arguments to find a ReportType
     * @example
     * // Get one ReportType
     * const reportType = await prisma.reportType.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ReportTypeFindFirstOrThrowArgs>(args?: SelectSubset<T, ReportTypeFindFirstOrThrowArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more ReportTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ReportTypes
     * const reportTypes = await prisma.reportType.findMany()
     * 
     * // Get first 10 ReportTypes
     * const reportTypes = await prisma.reportType.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const reportTypeWithIdOnly = await prisma.reportType.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ReportTypeFindManyArgs>(args?: SelectSubset<T, ReportTypeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a ReportType.
     * @param {ReportTypeCreateArgs} args - Arguments to create a ReportType.
     * @example
     * // Create one ReportType
     * const ReportType = await prisma.reportType.create({
     *   data: {
     *     // ... data to create a ReportType
     *   }
     * })
     * 
     */
    create<T extends ReportTypeCreateArgs>(args: SelectSubset<T, ReportTypeCreateArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many ReportTypes.
     * @param {ReportTypeCreateManyArgs} args - Arguments to create many ReportTypes.
     * @example
     * // Create many ReportTypes
     * const reportType = await prisma.reportType.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ReportTypeCreateManyArgs>(args?: SelectSubset<T, ReportTypeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a ReportType.
     * @param {ReportTypeDeleteArgs} args - Arguments to delete one ReportType.
     * @example
     * // Delete one ReportType
     * const ReportType = await prisma.reportType.delete({
     *   where: {
     *     // ... filter to delete one ReportType
     *   }
     * })
     * 
     */
    delete<T extends ReportTypeDeleteArgs>(args: SelectSubset<T, ReportTypeDeleteArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one ReportType.
     * @param {ReportTypeUpdateArgs} args - Arguments to update one ReportType.
     * @example
     * // Update one ReportType
     * const reportType = await prisma.reportType.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ReportTypeUpdateArgs>(args: SelectSubset<T, ReportTypeUpdateArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more ReportTypes.
     * @param {ReportTypeDeleteManyArgs} args - Arguments to filter ReportTypes to delete.
     * @example
     * // Delete a few ReportTypes
     * const { count } = await prisma.reportType.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ReportTypeDeleteManyArgs>(args?: SelectSubset<T, ReportTypeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ReportTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ReportTypes
     * const reportType = await prisma.reportType.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ReportTypeUpdateManyArgs>(args: SelectSubset<T, ReportTypeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one ReportType.
     * @param {ReportTypeUpsertArgs} args - Arguments to update or create a ReportType.
     * @example
     * // Update or create a ReportType
     * const reportType = await prisma.reportType.upsert({
     *   create: {
     *     // ... data to create a ReportType
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ReportType we want to update
     *   }
     * })
     */
    upsert<T extends ReportTypeUpsertArgs>(args: SelectSubset<T, ReportTypeUpsertArgs<ExtArgs>>): Prisma__ReportTypeClient<$Result.GetResult<Prisma.$ReportTypePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of ReportTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeCountArgs} args - Arguments to filter ReportTypes to count.
     * @example
     * // Count the number of ReportTypes
     * const count = await prisma.reportType.count({
     *   where: {
     *     // ... the filter for the ReportTypes we want to count
     *   }
     * })
    **/
    count<T extends ReportTypeCountArgs>(
      args?: Subset<T, ReportTypeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ReportTypeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ReportType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ReportTypeAggregateArgs>(args: Subset<T, ReportTypeAggregateArgs>): Prisma.PrismaPromise<GetReportTypeAggregateType<T>>

    /**
     * Group by ReportType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReportTypeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ReportTypeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ReportTypeGroupByArgs['orderBy'] }
        : { orderBy?: ReportTypeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ReportTypeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetReportTypeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ReportType model
   */
  readonly fields: ReportTypeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ReportType.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ReportTypeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ReportType model
   */
  interface ReportTypeFieldRefs {
    readonly id: FieldRef<"ReportType", 'Int'>
    readonly value: FieldRef<"ReportType", 'String'>
    readonly label: FieldRef<"ReportType", 'String'>
    readonly description: FieldRef<"ReportType", 'String'>
    readonly is_active: FieldRef<"ReportType", 'Boolean'>
    readonly created_at: FieldRef<"ReportType", 'DateTime'>
    readonly updated_at: FieldRef<"ReportType", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ReportType findUnique
   */
  export type ReportTypeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter, which ReportType to fetch.
     */
    where: ReportTypeWhereUniqueInput
  }

  /**
   * ReportType findUniqueOrThrow
   */
  export type ReportTypeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter, which ReportType to fetch.
     */
    where: ReportTypeWhereUniqueInput
  }

  /**
   * ReportType findFirst
   */
  export type ReportTypeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter, which ReportType to fetch.
     */
    where?: ReportTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReportTypes to fetch.
     */
    orderBy?: ReportTypeOrderByWithRelationInput | ReportTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReportTypes.
     */
    cursor?: ReportTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReportTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReportTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReportTypes.
     */
    distinct?: ReportTypeScalarFieldEnum | ReportTypeScalarFieldEnum[]
  }

  /**
   * ReportType findFirstOrThrow
   */
  export type ReportTypeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter, which ReportType to fetch.
     */
    where?: ReportTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReportTypes to fetch.
     */
    orderBy?: ReportTypeOrderByWithRelationInput | ReportTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReportTypes.
     */
    cursor?: ReportTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReportTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReportTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReportTypes.
     */
    distinct?: ReportTypeScalarFieldEnum | ReportTypeScalarFieldEnum[]
  }

  /**
   * ReportType findMany
   */
  export type ReportTypeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter, which ReportTypes to fetch.
     */
    where?: ReportTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReportTypes to fetch.
     */
    orderBy?: ReportTypeOrderByWithRelationInput | ReportTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ReportTypes.
     */
    cursor?: ReportTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReportTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReportTypes.
     */
    skip?: number
    distinct?: ReportTypeScalarFieldEnum | ReportTypeScalarFieldEnum[]
  }

  /**
   * ReportType create
   */
  export type ReportTypeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * The data needed to create a ReportType.
     */
    data: XOR<ReportTypeCreateInput, ReportTypeUncheckedCreateInput>
  }

  /**
   * ReportType createMany
   */
  export type ReportTypeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ReportTypes.
     */
    data: ReportTypeCreateManyInput | ReportTypeCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ReportType update
   */
  export type ReportTypeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * The data needed to update a ReportType.
     */
    data: XOR<ReportTypeUpdateInput, ReportTypeUncheckedUpdateInput>
    /**
     * Choose, which ReportType to update.
     */
    where: ReportTypeWhereUniqueInput
  }

  /**
   * ReportType updateMany
   */
  export type ReportTypeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ReportTypes.
     */
    data: XOR<ReportTypeUpdateManyMutationInput, ReportTypeUncheckedUpdateManyInput>
    /**
     * Filter which ReportTypes to update
     */
    where?: ReportTypeWhereInput
    /**
     * Limit how many ReportTypes to update.
     */
    limit?: number
  }

  /**
   * ReportType upsert
   */
  export type ReportTypeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * The filter to search for the ReportType to update in case it exists.
     */
    where: ReportTypeWhereUniqueInput
    /**
     * In case the ReportType found by the `where` argument doesn't exist, create a new ReportType with this data.
     */
    create: XOR<ReportTypeCreateInput, ReportTypeUncheckedCreateInput>
    /**
     * In case the ReportType was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ReportTypeUpdateInput, ReportTypeUncheckedUpdateInput>
  }

  /**
   * ReportType delete
   */
  export type ReportTypeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
    /**
     * Filter which ReportType to delete.
     */
    where: ReportTypeWhereUniqueInput
  }

  /**
   * ReportType deleteMany
   */
  export type ReportTypeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReportTypes to delete
     */
    where?: ReportTypeWhereInput
    /**
     * Limit how many ReportTypes to delete.
     */
    limit?: number
  }

  /**
   * ReportType without action
   */
  export type ReportTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReportType
     */
    select?: ReportTypeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReportType
     */
    omit?: ReportTypeOmit<ExtArgs> | null
  }


  /**
   * Model FindingSeverity
   */

  export type AggregateFindingSeverity = {
    _count: FindingSeverityCountAggregateOutputType | null
    _avg: FindingSeverityAvgAggregateOutputType | null
    _sum: FindingSeveritySumAggregateOutputType | null
    _min: FindingSeverityMinAggregateOutputType | null
    _max: FindingSeverityMaxAggregateOutputType | null
  }

  export type FindingSeverityAvgAggregateOutputType = {
    id: number | null
    sort_order: number | null
  }

  export type FindingSeveritySumAggregateOutputType = {
    id: number | null
    sort_order: number | null
  }

  export type FindingSeverityMinAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    color_class: string | null
    sort_order: number | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type FindingSeverityMaxAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    color_class: string | null
    sort_order: number | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type FindingSeverityCountAggregateOutputType = {
    id: number
    value: number
    label: number
    description: number
    color_class: number
    sort_order: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type FindingSeverityAvgAggregateInputType = {
    id?: true
    sort_order?: true
  }

  export type FindingSeveritySumAggregateInputType = {
    id?: true
    sort_order?: true
  }

  export type FindingSeverityMinAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type FindingSeverityMaxAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type FindingSeverityCountAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type FindingSeverityAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FindingSeverity to aggregate.
     */
    where?: FindingSeverityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FindingSeverities to fetch.
     */
    orderBy?: FindingSeverityOrderByWithRelationInput | FindingSeverityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: FindingSeverityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FindingSeverities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FindingSeverities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned FindingSeverities
    **/
    _count?: true | FindingSeverityCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: FindingSeverityAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: FindingSeveritySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: FindingSeverityMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: FindingSeverityMaxAggregateInputType
  }

  export type GetFindingSeverityAggregateType<T extends FindingSeverityAggregateArgs> = {
        [P in keyof T & keyof AggregateFindingSeverity]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateFindingSeverity[P]>
      : GetScalarType<T[P], AggregateFindingSeverity[P]>
  }




  export type FindingSeverityGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FindingSeverityWhereInput
    orderBy?: FindingSeverityOrderByWithAggregationInput | FindingSeverityOrderByWithAggregationInput[]
    by: FindingSeverityScalarFieldEnum[] | FindingSeverityScalarFieldEnum
    having?: FindingSeverityScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: FindingSeverityCountAggregateInputType | true
    _avg?: FindingSeverityAvgAggregateInputType
    _sum?: FindingSeveritySumAggregateInputType
    _min?: FindingSeverityMinAggregateInputType
    _max?: FindingSeverityMaxAggregateInputType
  }

  export type FindingSeverityGroupByOutputType = {
    id: number
    value: string
    label: string
    description: string | null
    color_class: string | null
    sort_order: number
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: FindingSeverityCountAggregateOutputType | null
    _avg: FindingSeverityAvgAggregateOutputType | null
    _sum: FindingSeveritySumAggregateOutputType | null
    _min: FindingSeverityMinAggregateOutputType | null
    _max: FindingSeverityMaxAggregateOutputType | null
  }

  type GetFindingSeverityGroupByPayload<T extends FindingSeverityGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<FindingSeverityGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof FindingSeverityGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], FindingSeverityGroupByOutputType[P]>
            : GetScalarType<T[P], FindingSeverityGroupByOutputType[P]>
        }
      >
    >


  export type FindingSeveritySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    color_class?: boolean
    sort_order?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["findingSeverity"]>



  export type FindingSeveritySelectScalar = {
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    color_class?: boolean
    sort_order?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type FindingSeverityOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "value" | "label" | "description" | "color_class" | "sort_order" | "is_active" | "created_at" | "updated_at", ExtArgs["result"]["findingSeverity"]>

  export type $FindingSeverityPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "FindingSeverity"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      value: string
      label: string
      description: string | null
      color_class: string | null
      sort_order: number
      is_active: boolean
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["findingSeverity"]>
    composites: {}
  }

  type FindingSeverityGetPayload<S extends boolean | null | undefined | FindingSeverityDefaultArgs> = $Result.GetResult<Prisma.$FindingSeverityPayload, S>

  type FindingSeverityCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<FindingSeverityFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: FindingSeverityCountAggregateInputType | true
    }

  export interface FindingSeverityDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['FindingSeverity'], meta: { name: 'FindingSeverity' } }
    /**
     * Find zero or one FindingSeverity that matches the filter.
     * @param {FindingSeverityFindUniqueArgs} args - Arguments to find a FindingSeverity
     * @example
     * // Get one FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends FindingSeverityFindUniqueArgs>(args: SelectSubset<T, FindingSeverityFindUniqueArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one FindingSeverity that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {FindingSeverityFindUniqueOrThrowArgs} args - Arguments to find a FindingSeverity
     * @example
     * // Get one FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends FindingSeverityFindUniqueOrThrowArgs>(args: SelectSubset<T, FindingSeverityFindUniqueOrThrowArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first FindingSeverity that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityFindFirstArgs} args - Arguments to find a FindingSeverity
     * @example
     * // Get one FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends FindingSeverityFindFirstArgs>(args?: SelectSubset<T, FindingSeverityFindFirstArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first FindingSeverity that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityFindFirstOrThrowArgs} args - Arguments to find a FindingSeverity
     * @example
     * // Get one FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends FindingSeverityFindFirstOrThrowArgs>(args?: SelectSubset<T, FindingSeverityFindFirstOrThrowArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more FindingSeverities that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all FindingSeverities
     * const findingSeverities = await prisma.findingSeverity.findMany()
     * 
     * // Get first 10 FindingSeverities
     * const findingSeverities = await prisma.findingSeverity.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const findingSeverityWithIdOnly = await prisma.findingSeverity.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends FindingSeverityFindManyArgs>(args?: SelectSubset<T, FindingSeverityFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a FindingSeverity.
     * @param {FindingSeverityCreateArgs} args - Arguments to create a FindingSeverity.
     * @example
     * // Create one FindingSeverity
     * const FindingSeverity = await prisma.findingSeverity.create({
     *   data: {
     *     // ... data to create a FindingSeverity
     *   }
     * })
     * 
     */
    create<T extends FindingSeverityCreateArgs>(args: SelectSubset<T, FindingSeverityCreateArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many FindingSeverities.
     * @param {FindingSeverityCreateManyArgs} args - Arguments to create many FindingSeverities.
     * @example
     * // Create many FindingSeverities
     * const findingSeverity = await prisma.findingSeverity.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends FindingSeverityCreateManyArgs>(args?: SelectSubset<T, FindingSeverityCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a FindingSeverity.
     * @param {FindingSeverityDeleteArgs} args - Arguments to delete one FindingSeverity.
     * @example
     * // Delete one FindingSeverity
     * const FindingSeverity = await prisma.findingSeverity.delete({
     *   where: {
     *     // ... filter to delete one FindingSeverity
     *   }
     * })
     * 
     */
    delete<T extends FindingSeverityDeleteArgs>(args: SelectSubset<T, FindingSeverityDeleteArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one FindingSeverity.
     * @param {FindingSeverityUpdateArgs} args - Arguments to update one FindingSeverity.
     * @example
     * // Update one FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends FindingSeverityUpdateArgs>(args: SelectSubset<T, FindingSeverityUpdateArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more FindingSeverities.
     * @param {FindingSeverityDeleteManyArgs} args - Arguments to filter FindingSeverities to delete.
     * @example
     * // Delete a few FindingSeverities
     * const { count } = await prisma.findingSeverity.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends FindingSeverityDeleteManyArgs>(args?: SelectSubset<T, FindingSeverityDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more FindingSeverities.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many FindingSeverities
     * const findingSeverity = await prisma.findingSeverity.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends FindingSeverityUpdateManyArgs>(args: SelectSubset<T, FindingSeverityUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one FindingSeverity.
     * @param {FindingSeverityUpsertArgs} args - Arguments to update or create a FindingSeverity.
     * @example
     * // Update or create a FindingSeverity
     * const findingSeverity = await prisma.findingSeverity.upsert({
     *   create: {
     *     // ... data to create a FindingSeverity
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the FindingSeverity we want to update
     *   }
     * })
     */
    upsert<T extends FindingSeverityUpsertArgs>(args: SelectSubset<T, FindingSeverityUpsertArgs<ExtArgs>>): Prisma__FindingSeverityClient<$Result.GetResult<Prisma.$FindingSeverityPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of FindingSeverities.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityCountArgs} args - Arguments to filter FindingSeverities to count.
     * @example
     * // Count the number of FindingSeverities
     * const count = await prisma.findingSeverity.count({
     *   where: {
     *     // ... the filter for the FindingSeverities we want to count
     *   }
     * })
    **/
    count<T extends FindingSeverityCountArgs>(
      args?: Subset<T, FindingSeverityCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], FindingSeverityCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a FindingSeverity.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends FindingSeverityAggregateArgs>(args: Subset<T, FindingSeverityAggregateArgs>): Prisma.PrismaPromise<GetFindingSeverityAggregateType<T>>

    /**
     * Group by FindingSeverity.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FindingSeverityGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends FindingSeverityGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: FindingSeverityGroupByArgs['orderBy'] }
        : { orderBy?: FindingSeverityGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, FindingSeverityGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetFindingSeverityGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the FindingSeverity model
   */
  readonly fields: FindingSeverityFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for FindingSeverity.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__FindingSeverityClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the FindingSeverity model
   */
  interface FindingSeverityFieldRefs {
    readonly id: FieldRef<"FindingSeverity", 'Int'>
    readonly value: FieldRef<"FindingSeverity", 'String'>
    readonly label: FieldRef<"FindingSeverity", 'String'>
    readonly description: FieldRef<"FindingSeverity", 'String'>
    readonly color_class: FieldRef<"FindingSeverity", 'String'>
    readonly sort_order: FieldRef<"FindingSeverity", 'Int'>
    readonly is_active: FieldRef<"FindingSeverity", 'Boolean'>
    readonly created_at: FieldRef<"FindingSeverity", 'DateTime'>
    readonly updated_at: FieldRef<"FindingSeverity", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * FindingSeverity findUnique
   */
  export type FindingSeverityFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter, which FindingSeverity to fetch.
     */
    where: FindingSeverityWhereUniqueInput
  }

  /**
   * FindingSeverity findUniqueOrThrow
   */
  export type FindingSeverityFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter, which FindingSeverity to fetch.
     */
    where: FindingSeverityWhereUniqueInput
  }

  /**
   * FindingSeverity findFirst
   */
  export type FindingSeverityFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter, which FindingSeverity to fetch.
     */
    where?: FindingSeverityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FindingSeverities to fetch.
     */
    orderBy?: FindingSeverityOrderByWithRelationInput | FindingSeverityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FindingSeverities.
     */
    cursor?: FindingSeverityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FindingSeverities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FindingSeverities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FindingSeverities.
     */
    distinct?: FindingSeverityScalarFieldEnum | FindingSeverityScalarFieldEnum[]
  }

  /**
   * FindingSeverity findFirstOrThrow
   */
  export type FindingSeverityFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter, which FindingSeverity to fetch.
     */
    where?: FindingSeverityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FindingSeverities to fetch.
     */
    orderBy?: FindingSeverityOrderByWithRelationInput | FindingSeverityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FindingSeverities.
     */
    cursor?: FindingSeverityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FindingSeverities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FindingSeverities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FindingSeverities.
     */
    distinct?: FindingSeverityScalarFieldEnum | FindingSeverityScalarFieldEnum[]
  }

  /**
   * FindingSeverity findMany
   */
  export type FindingSeverityFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter, which FindingSeverities to fetch.
     */
    where?: FindingSeverityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FindingSeverities to fetch.
     */
    orderBy?: FindingSeverityOrderByWithRelationInput | FindingSeverityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing FindingSeverities.
     */
    cursor?: FindingSeverityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FindingSeverities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FindingSeverities.
     */
    skip?: number
    distinct?: FindingSeverityScalarFieldEnum | FindingSeverityScalarFieldEnum[]
  }

  /**
   * FindingSeverity create
   */
  export type FindingSeverityCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * The data needed to create a FindingSeverity.
     */
    data: XOR<FindingSeverityCreateInput, FindingSeverityUncheckedCreateInput>
  }

  /**
   * FindingSeverity createMany
   */
  export type FindingSeverityCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many FindingSeverities.
     */
    data: FindingSeverityCreateManyInput | FindingSeverityCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * FindingSeverity update
   */
  export type FindingSeverityUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * The data needed to update a FindingSeverity.
     */
    data: XOR<FindingSeverityUpdateInput, FindingSeverityUncheckedUpdateInput>
    /**
     * Choose, which FindingSeverity to update.
     */
    where: FindingSeverityWhereUniqueInput
  }

  /**
   * FindingSeverity updateMany
   */
  export type FindingSeverityUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update FindingSeverities.
     */
    data: XOR<FindingSeverityUpdateManyMutationInput, FindingSeverityUncheckedUpdateManyInput>
    /**
     * Filter which FindingSeverities to update
     */
    where?: FindingSeverityWhereInput
    /**
     * Limit how many FindingSeverities to update.
     */
    limit?: number
  }

  /**
   * FindingSeverity upsert
   */
  export type FindingSeverityUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * The filter to search for the FindingSeverity to update in case it exists.
     */
    where: FindingSeverityWhereUniqueInput
    /**
     * In case the FindingSeverity found by the `where` argument doesn't exist, create a new FindingSeverity with this data.
     */
    create: XOR<FindingSeverityCreateInput, FindingSeverityUncheckedCreateInput>
    /**
     * In case the FindingSeverity was found with the provided `where` argument, update it with this data.
     */
    update: XOR<FindingSeverityUpdateInput, FindingSeverityUncheckedUpdateInput>
  }

  /**
   * FindingSeverity delete
   */
  export type FindingSeverityDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
    /**
     * Filter which FindingSeverity to delete.
     */
    where: FindingSeverityWhereUniqueInput
  }

  /**
   * FindingSeverity deleteMany
   */
  export type FindingSeverityDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FindingSeverities to delete
     */
    where?: FindingSeverityWhereInput
    /**
     * Limit how many FindingSeverities to delete.
     */
    limit?: number
  }

  /**
   * FindingSeverity without action
   */
  export type FindingSeverityDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FindingSeverity
     */
    select?: FindingSeveritySelect<ExtArgs> | null
    /**
     * Omit specific fields from the FindingSeverity
     */
    omit?: FindingSeverityOmit<ExtArgs> | null
  }


  /**
   * Model FindingStatus
   */

  export type AggregateFindingStatus = {
    _count: FindingStatusCountAggregateOutputType | null
    _avg: FindingStatusAvgAggregateOutputType | null
    _sum: FindingStatusSumAggregateOutputType | null
    _min: FindingStatusMinAggregateOutputType | null
    _max: FindingStatusMaxAggregateOutputType | null
  }

  export type FindingStatusAvgAggregateOutputType = {
    id: number | null
    sort_order: number | null
  }

  export type FindingStatusSumAggregateOutputType = {
    id: number | null
    sort_order: number | null
  }

  export type FindingStatusMinAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    color_class: string | null
    sort_order: number | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type FindingStatusMaxAggregateOutputType = {
    id: number | null
    value: string | null
    label: string | null
    description: string | null
    color_class: string | null
    sort_order: number | null
    is_active: boolean | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type FindingStatusCountAggregateOutputType = {
    id: number
    value: number
    label: number
    description: number
    color_class: number
    sort_order: number
    is_active: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type FindingStatusAvgAggregateInputType = {
    id?: true
    sort_order?: true
  }

  export type FindingStatusSumAggregateInputType = {
    id?: true
    sort_order?: true
  }

  export type FindingStatusMinAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type FindingStatusMaxAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
  }

  export type FindingStatusCountAggregateInputType = {
    id?: true
    value?: true
    label?: true
    description?: true
    color_class?: true
    sort_order?: true
    is_active?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type FindingStatusAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FindingStatus to aggregate.
     */
    where?: FindingStatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FindingStatuses to fetch.
     */
    orderBy?: FindingStatusOrderByWithRelationInput | FindingStatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: FindingStatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FindingStatuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FindingStatuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned FindingStatuses
    **/
    _count?: true | FindingStatusCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: FindingStatusAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: FindingStatusSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: FindingStatusMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: FindingStatusMaxAggregateInputType
  }

  export type GetFindingStatusAggregateType<T extends FindingStatusAggregateArgs> = {
        [P in keyof T & keyof AggregateFindingStatus]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateFindingStatus[P]>
      : GetScalarType<T[P], AggregateFindingStatus[P]>
  }




  export type FindingStatusGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FindingStatusWhereInput
    orderBy?: FindingStatusOrderByWithAggregationInput | FindingStatusOrderByWithAggregationInput[]
    by: FindingStatusScalarFieldEnum[] | FindingStatusScalarFieldEnum
    having?: FindingStatusScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: FindingStatusCountAggregateInputType | true
    _avg?: FindingStatusAvgAggregateInputType
    _sum?: FindingStatusSumAggregateInputType
    _min?: FindingStatusMinAggregateInputType
    _max?: FindingStatusMaxAggregateInputType
  }

  export type FindingStatusGroupByOutputType = {
    id: number
    value: string
    label: string
    description: string | null
    color_class: string | null
    sort_order: number
    is_active: boolean
    created_at: Date
    updated_at: Date
    _count: FindingStatusCountAggregateOutputType | null
    _avg: FindingStatusAvgAggregateOutputType | null
    _sum: FindingStatusSumAggregateOutputType | null
    _min: FindingStatusMinAggregateOutputType | null
    _max: FindingStatusMaxAggregateOutputType | null
  }

  type GetFindingStatusGroupByPayload<T extends FindingStatusGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<FindingStatusGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof FindingStatusGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], FindingStatusGroupByOutputType[P]>
            : GetScalarType<T[P], FindingStatusGroupByOutputType[P]>
        }
      >
    >


  export type FindingStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    value?: boolean
    label?: boolean
    description?: boolean
    color_class?: boolean
    sort_order?: boolean
    is_active?: boolean
    created_at?: boolean
    updated_at?: boolean
  }, ExtArgs["result"]["findingStatus"]>



  export type Fi