"use client";

import { SessionProvider } from "next-auth/react";
import { ReactNode } from "react";
import { UserProvider } from "@/lib/context/UserContext";
import { HospitalProvider } from "@/lib/context/HospitalContext";

export function AuthProvider({ children }: { children: ReactNode }) {
  return (
    <SessionProvider>
      <UserProvider>
        <HospitalProvider>
          {children}
        </HospitalProvider>
      </UserProvider>
    </SessionProvider>
  );
} 