import { db } from '@/lib/db';
import { compare } from 'bcrypt';
import { cookies } from 'next/headers';
import { NextResponse } from 'next/server';

export async function GET(request: Request) {
  const email = 'superadmin@healthguardian.com';
  const password = 'admin123';

  try {
    // Find the user
    const user = await db.user.findUnique({
      where: { email },
      include: { hospital: true },
    });

    if (!user) {
      return NextResponse.json(
        { success: false, message: 'User not found' },
        { status: 404 }
      );
    }

    // Verify password
    const passwordMatch = await compare(password, user.password);
    if (!passwordMatch) {
      return NextResponse.json(
        { success: false, message: 'Invalid password' },
        { status: 401 }
      );
    }

    // Create a response with redirect
    const response = NextResponse.redirect(new URL('/dashboard', request.url));

    // Add the user data as a cookie
    response.cookies.set({
      name: 'user-session',
      value: JSON.stringify({
        id: user.id,
        email: user.email,
        role: user.role,
        username: user.username,
      }),
      httpOnly: true,
      path: '/',
      maxAge: 60 * 60 * 24 * 7, // 1 week
    });

    return response;
  } catch (error) {
    console.error('Login error:', error);
    return NextResponse.json(
      { success: false, message: 'Server error' },
      { status: 500 }
    );
  }
} 