import { NextResponse } from 'next/server';
import prisma from '@/lib/prisma';

export async function GET() {
  try {
    // Check database connection and model access
    const testData = {
      prismaClient: !!prisma,
      models: {
        userExists: !!prisma.user,
        hospitalExists: !!prisma.hospital,
        documentCategoryExists: !!prisma.documentCategory,
        documentExists: !!prisma.document
      },
      databaseInfo: {
        connection: "testing"
      }
    };
    
    return NextResponse.json(testData);
  } catch (error) {
    console.error('Test DB Error:', error);
    return NextResponse.json({ error: String(error) }, { status: 500 });
  }
} 