import { NextResponse } from 'next/server'

export async function GET() {
  try {
    return NextResponse.json({ 
      status: 'error',
      message: 'The test endpoint is no longer available. Please use the specific endpoints for each schedule type:',
      endpoints: {
        auditSchedules: '/api/schedule/audits',
        trainingEvents: '/api/schedule/training',
        regulatoryDeadlines: '/api/schedule/deadlines',
        resourceAllocations: '/api/schedule/resources'
      }
    }, { status: 301 });
  } catch (error) {
    console.error('Error:', error);
    return NextResponse.json({ 
      status: 'error', 
      message: 'An unexpected error occurred',
      error: error instanceof Error ? error.message : 'Unknown error'
    }, { status: 500 });
  }
} 