import { NextResponse } from 'next/server';
import prisma from '@/lib/prisma';
import { handleApiError } from '@/lib/api-helpers';

export async function GET() {
  try {
    const statuses = await prisma.documentStatus.findMany({
      where: { is_active: true },
      orderBy: { sort_order: 'asc' },
      select: {
        id: true,
        value: true,
        label: true,
        description: true,
        color_class: true,
        sort_order: true
      }
    });

    return NextResponse.json(statuses);
  } catch (error) {
    return handleApiError(error);
  }
} 