import { NextRequest, NextResponse } from 'next/server';
import prisma from '@/lib/prisma';

export async function GET(request: NextRequest) {
  try {
    const categories = await prisma.policyCategory.findMany({
      where: {
        is_active: true
      },
      orderBy: {
        label: 'asc'
      }
    });

    return NextResponse.json(categories);
  } catch (error) {
    console.error('Error fetching policy categories:', error);
    return NextResponse.json(
      { error: 'Failed to fetch policy categories' },
      { status: 500 }
    );
  }
} 