# Health Audit System

A next-generation healthcare compliance and audit management system.

## Multi-Hospital Support

The system is designed to support multiple hospitals with a centralized administration panel. The architecture follows these principles:

### Hospital Data Isolation

- Each hospital's data is stored with a unique `hospital_id` in the database
- Regular users can only access data for their assigned hospital
- Hospital administrators can only manage their own hospital's data
- Super administrators can view and manage all hospitals

### Hospital Selection for Super Admins

The system includes a hospital selector dropdown in the header for super administrators:

1. When a super admin selects a hospital from the dropdown, all dashboard components and data views will show data specific to that hospital
2. The selected hospital is stored in localStorage to persist across page reloads
3. All API calls automatically include the selected hospital ID for super admins

### Implementation Details

- The `HospitalContext` provides the current selected hospital information
- The `useApiWithHospital` hook automatically appends the current hospital ID to API requests for super admins
- API routes check user permissions and filter data appropriately based on user role and hospital selection

## Getting Started

### Prerequisites

- Node.js 18.x or higher
- MySQL database

### Installation

1. Clone the repository
2. Install dependencies: `npm install`
3. Set up your environment variables in `.env`:
   ```
   DATABASE_URL="mysql://user:password@localhost:3306/healthaudit"
   NEXTAUTH_URL="http://localhost:3000"
   NEXTAUTH_SECRET="your-secret-key"
   ```
4. Run database migrations: `npx prisma migrate dev`
5. Start the development server: `npm run dev`

## Features

- Multi-tenant hospital management
- Compliance tracking and monitoring
- Audit findings management
- Regulatory standards tracking
- Documentation management
- Reporting and analytics
- Role-based access control

## Technology Stack

- Next.js 14
- React 18
- TypeScript
- Prisma ORM
- NextAuth.js
- TailwindCSS
- MySQL

## Project Structure

- `app/` - App Router pages and layouts
- `components/` - Reusable React components
- `public/` - Static assets
- `lib/` - Utility functions and shared code

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new).

## License

This project is licensed under the MIT License.
