"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/@auth";
exports.ids = ["vendor-chunks/@auth"];
exports.modules = {

/***/ "(rsc)/./node_modules/@auth/core/errors.js":
/*!*******************************************!*\
  !*** ./node_modules/@auth/core/errors.js ***!
  \*******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AccessDenied: () => (/* binding */ AccessDenied),\n/* harmony export */   AccountNotLinked: () => (/* binding */ AccountNotLinked),\n/* harmony export */   AdapterError: () => (/* binding */ AdapterError),\n/* harmony export */   AuthError: () => (/* binding */ AuthError),\n/* harmony export */   CallbackRouteError: () => (/* binding */ CallbackRouteError),\n/* harmony export */   CredentialsSignin: () => (/* binding */ CredentialsSignin),\n/* harmony export */   DuplicateConditionalUI: () => (/* binding */ DuplicateConditionalUI),\n/* harmony export */   EmailSignInError: () => (/* binding */ EmailSignInError),\n/* harmony export */   ErrorPageLoop: () => (/* binding */ ErrorPageLoop),\n/* harmony export */   EventError: () => (/* binding */ EventError),\n/* harmony export */   ExperimentalFeatureNotEnabled: () => (/* binding */ ExperimentalFeatureNotEnabled),\n/* harmony export */   InvalidCallbackUrl: () => (/* binding */ InvalidCallbackUrl),\n/* harmony export */   InvalidCheck: () => (/* binding */ InvalidCheck),\n/* harmony export */   InvalidEndpoints: () => (/* binding */ InvalidEndpoints),\n/* harmony export */   InvalidProvider: () => (/* binding */ InvalidProvider),\n/* harmony export */   JWTSessionError: () => (/* binding */ JWTSessionError),\n/* harmony export */   MissingAdapter: () => (/* binding */ MissingAdapter),\n/* harmony export */   MissingAdapterMethods: () => (/* binding */ MissingAdapterMethods),\n/* harmony export */   MissingAuthorize: () => (/* binding */ MissingAuthorize),\n/* harmony export */   MissingCSRF: () => (/* binding */ MissingCSRF),\n/* harmony export */   MissingSecret: () => (/* binding */ MissingSecret),\n/* harmony export */   MissingWebAuthnAutocomplete: () => (/* binding */ MissingWebAuthnAutocomplete),\n/* harmony export */   OAuthAccountNotLinked: () => (/* binding */ OAuthAccountNotLinked),\n/* harmony export */   OAuthCallbackError: () => (/* binding */ OAuthCallbackError),\n/* harmony export */   OAuthProfileParseError: () => (/* binding */ OAuthProfileParseError),\n/* harmony export */   OAuthSignInError: () => (/* binding */ OAuthSignInError),\n/* harmony export */   SessionTokenError: () => (/* binding */ SessionTokenError),\n/* harmony export */   SignInError: () => (/* binding */ SignInError),\n/* harmony export */   SignOutError: () => (/* binding */ SignOutError),\n/* harmony export */   UnknownAction: () => (/* binding */ UnknownAction),\n/* harmony export */   UnsupportedStrategy: () => (/* binding */ UnsupportedStrategy),\n/* harmony export */   UntrustedHost: () => (/* binding */ UntrustedHost),\n/* harmony export */   Verification: () => (/* binding */ Verification),\n/* harmony export */   WebAuthnVerificationError: () => (/* binding */ WebAuthnVerificationError),\n/* harmony export */   isClientError: () => (/* binding */ isClientError)\n/* harmony export */ });\n/**\n * Base error class for all Auth.js errors.\n * It's optimized to be printed in the server logs in a nicely formatted way\n * via the [`logger.error`](https://authjs.dev/reference/core#logger) option.\n * @noInheritDoc\n */\nclass AuthError extends Error {\n    /** @internal */\n    constructor(message, errorOptions) {\n        if (message instanceof Error) {\n            super(undefined, {\n                cause: { err: message, ...message.cause, ...errorOptions },\n            });\n        }\n        else if (typeof message === \"string\") {\n            if (errorOptions instanceof Error) {\n                errorOptions = { err: errorOptions, ...errorOptions.cause };\n            }\n            super(message, errorOptions);\n        }\n        else {\n            super(undefined, message);\n        }\n        this.name = this.constructor.name;\n        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841\n        this.type = this.constructor.type ?? \"AuthError\";\n        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841\n        this.kind = this.constructor.kind ?? \"error\";\n        Error.captureStackTrace?.(this, this.constructor);\n        const url = `https://errors.authjs.dev#${this.type.toLowerCase()}`;\n        this.message += `${this.message ? \". \" : \"\"}Read more at ${url}`;\n    }\n}\n/**\n * Thrown when the user's sign-in attempt failed.\n * @noInheritDoc\n */\nclass SignInError extends AuthError {\n}\n/** @internal */\nSignInError.kind = \"signIn\";\n/**\n * One of the database [`Adapter` methods](https://authjs.dev/reference/core/adapters#methods)\n * failed during execution.\n *\n * :::tip\n * If `debug: true` is set, you can check out `[auth][debug]` in the logs to learn more about the failed adapter method execution.\n * @example\n * ```sh\n * [auth][debug]: adapter_getUserByEmail\n * { \"args\": [undefined] }\n * ```\n * :::\n * @noInheritDoc\n */\nclass AdapterError extends AuthError {\n}\nAdapterError.type = \"AdapterError\";\n/**\n * Thrown when the execution of the [`signIn` callback](https://authjs.dev/reference/core/types#signin) fails\n * or if it returns `false`.\n * @noInheritDoc\n */\nclass AccessDenied extends AuthError {\n}\nAccessDenied.type = \"AccessDenied\";\n/**\n * This error occurs when the user cannot finish login.\n * Depending on the provider type, this could have happened for multiple reasons.\n *\n * :::tip\n * Check out `[auth][details]` in the logs to know which provider failed.\n * @example\n * ```sh\n * [auth][details]: { \"provider\": \"github\" }\n * ```\n * :::\n *\n * For an [OAuth provider](https://authjs.dev/getting-started/authentication/oauth), possible causes are:\n * - The user denied access to the application\n * - There was an error parsing the OAuth Profile:\n *   Check out the provider's `profile` or `userinfo.request` method to make sure\n *   it correctly fetches the user's profile.\n * - The `signIn` or `jwt` callback methods threw an uncaught error:\n *   Check the callback method implementations.\n *\n * For an [Email provider](https://authjs.dev/getting-started/authentication/email), possible causes are:\n * - The provided email/token combination was invalid/missing:\n *   Check if the provider's `sendVerificationRequest` method correctly sends the email.\n * - The provided email/token combination has expired:\n *   Ask the user to log in again.\n * - There was an error with the database:\n *   Check the database logs.\n *\n * For a [Credentials provider](https://authjs.dev/getting-started/authentication/credentials), possible causes are:\n * - The `authorize` method threw an uncaught error:\n *   Check the provider's `authorize` method.\n * - The `signIn` or `jwt` callback methods threw an uncaught error:\n *   Check the callback method implementations.\n *\n * :::tip\n * Check out `[auth][cause]` in the error message for more details.\n * It will show the original stack trace.\n * :::\n * @noInheritDoc\n */\nclass CallbackRouteError extends AuthError {\n}\nCallbackRouteError.type = \"CallbackRouteError\";\n/**\n * Thrown when Auth.js is misconfigured and accidentally tried to require authentication on a custom error page.\n * To prevent an infinite loop, Auth.js will instead render its default error page.\n *\n * To fix this, make sure that the `error` page does not require authentication.\n *\n * Learn more at [Guide: Error pages](https://authjs.dev/guides/pages/error)\n * @noInheritDoc\n */\nclass ErrorPageLoop extends AuthError {\n}\nErrorPageLoop.type = \"ErrorPageLoop\";\n/**\n * One of the [`events` methods](https://authjs.dev/reference/core/types#eventcallbacks)\n * failed during execution.\n *\n * Make sure that the `events` methods are implemented correctly and uncaught errors are handled.\n *\n * Learn more at [`events`](https://authjs.dev/reference/core/types#eventcallbacks)\n * @noInheritDoc\n */\nclass EventError extends AuthError {\n}\nEventError.type = \"EventError\";\n/**\n * Thrown when Auth.js is unable to verify a `callbackUrl` value.\n * The browser either disabled cookies or the `callbackUrl` is not a valid URL.\n *\n * Somebody might have tried to manipulate the callback URL that Auth.js uses to redirect the user back to the configured `callbackUrl`/page.\n * This could be a malicious hacker trying to redirect the user to a phishing site.\n * To prevent this, Auth.js checks if the callback URL is valid and throws this error if it is not.\n *\n * There is no action required, but it might be an indicator that somebody is trying to attack your application.\n * @noInheritDoc\n */\nclass InvalidCallbackUrl extends AuthError {\n}\nInvalidCallbackUrl.type = \"InvalidCallbackUrl\";\n/**\n * Can be thrown from the `authorize` callback of the Credentials provider.\n * When an error occurs during the `authorize` callback, two things can happen:\n * 1. The user is redirected to the signin page, with `error=CredentialsSignin&code=credentials` in the URL. `code` is configurable.\n * 2. If you throw this error in a framework that handles form actions server-side, this error is thrown, instead of redirecting the user, so you'll need to handle.\n * @noInheritDoc\n */\nclass CredentialsSignin extends SignInError {\n    constructor() {\n        super(...arguments);\n        /**\n         * The error code that is set in the `code` query parameter of the redirect URL.\n         *\n         *\n         * ⚠ NOTE: This property is going to be included in the URL, so make sure it does not hint at sensitive errors.\n         *\n         * The full error is always logged on the server, if you need to debug.\n         *\n         * Generally, we don't recommend hinting specifically if the user had either a wrong username or password specifically,\n         * try rather something like \"Invalid credentials\".\n         */\n        this.code = \"credentials\";\n    }\n}\nCredentialsSignin.type = \"CredentialsSignin\";\n/**\n * One of the configured OAuth or OIDC providers is missing the `authorization`, `token` or `userinfo`, or `issuer` configuration.\n * To perform OAuth or OIDC sign in, at least one of these endpoints is required.\n *\n * Learn more at [`OAuth2Config`](https://authjs.dev/reference/core/providers#oauth2configprofile) or [Guide: OAuth Provider](https://authjs.dev/guides/configuring-oauth-providers)\n * @noInheritDoc\n */\nclass InvalidEndpoints extends AuthError {\n}\nInvalidEndpoints.type = \"InvalidEndpoints\";\n/**\n * Thrown when a PKCE, state or nonce OAuth check could not be performed.\n * This could happen if the OAuth provider is configured incorrectly or if the browser is blocking cookies.\n *\n * Learn more at [`checks`](https://authjs.dev/reference/core/providers#checks)\n * @noInheritDoc\n */\nclass InvalidCheck extends AuthError {\n}\nInvalidCheck.type = \"InvalidCheck\";\n/**\n * Logged on the server when Auth.js could not decode or encode a JWT-based (`strategy: \"jwt\"`) session.\n *\n * Possible causes are either a misconfigured `secret` or a malformed JWT or `encode/decode` methods.\n *\n * :::note\n * When this error is logged, the session cookie is destroyed.\n * :::\n *\n * Learn more at [`secret`](https://authjs.dev/reference/core#secret), [`jwt.encode`](https://authjs.dev/reference/core/jwt#encode-1) or [`jwt.decode`](https://authjs.dev/reference/core/jwt#decode-2) for more information.\n * @noInheritDoc\n */\nclass JWTSessionError extends AuthError {\n}\nJWTSessionError.type = \"JWTSessionError\";\n/**\n * Thrown if Auth.js is misconfigured. This could happen if you configured an Email provider but did not set up a database adapter,\n * or tried using a `strategy: \"database\"` session without a database adapter.\n * In both cases, make sure you either remove the configuration or add the missing adapter.\n *\n * Learn more at [Database Adapters](https://authjs.dev/getting-started/database), [Email provider](https://authjs.dev/getting-started/authentication/email) or [Concept: Database session strategy](https://authjs.dev/concepts/session-strategies#database-session)\n * @noInheritDoc\n */\nclass MissingAdapter extends AuthError {\n}\nMissingAdapter.type = \"MissingAdapter\";\n/**\n * Thrown similarily to [`MissingAdapter`](https://authjs.dev/reference/core/errors#missingadapter), but only some required methods were missing.\n *\n * Make sure you either remove the configuration or add the missing methods to the adapter.\n *\n * Learn more at [Database Adapters](https://authjs.dev/getting-started/database)\n * @noInheritDoc\n */\nclass MissingAdapterMethods extends AuthError {\n}\nMissingAdapterMethods.type = \"MissingAdapterMethods\";\n/**\n * Thrown when a Credentials provider is missing the `authorize` configuration.\n * To perform credentials sign in, the `authorize` method is required.\n *\n * Learn more at [Credentials provider](https://authjs.dev/getting-started/authentication/credentials)\n * @noInheritDoc\n */\nclass MissingAuthorize extends AuthError {\n}\nMissingAuthorize.type = \"MissingAuthorize\";\n/**\n * Auth.js requires a secret or multiple secrets to be set, but none was not found. This is used to encrypt cookies, JWTs and other sensitive data.\n *\n * :::note\n * If you are using a framework like Next.js, we try to automatically infer the secret from the `AUTH_SECRET`, `AUTH_SECRET_1`, etc. environment variables.\n * Alternatively, you can also explicitly set the [`AuthConfig.secret`](https://authjs.dev/reference/core#secret) option.\n * :::\n *\n *\n * :::tip\n * To generate a random string, you can use the Auth.js CLI: `npx auth secret`\n * :::\n * @noInheritDoc\n */\nclass MissingSecret extends AuthError {\n}\nMissingSecret.type = \"MissingSecret\";\n/**\n * Thrown when an Email address is already associated with an account\n * but the user is trying an OAuth account that is not linked to it.\n *\n * For security reasons, Auth.js does not automatically link OAuth accounts to existing accounts if the user is not signed in.\n *\n * :::tip\n * If you trust the OAuth provider to have verified the user's email address,\n * you can enable automatic account linking by setting [`allowDangerousEmailAccountLinking: true`](https://authjs.dev/reference/core/providers#allowdangerousemailaccountlinking)\n * in the provider configuration.\n * :::\n * @noInheritDoc\n */\nclass OAuthAccountNotLinked extends SignInError {\n}\nOAuthAccountNotLinked.type = \"OAuthAccountNotLinked\";\n/**\n * Thrown when an OAuth provider returns an error during the sign in process.\n * This could happen for example if the user denied access to the application or there was a configuration error.\n *\n * For a full list of possible reasons, check out the specification [Authorization Code Grant: Error Response](https://www.rfc-editor.org/rfc/rfc6749#section-4.1.2.1)\n * @noInheritDoc\n */\nclass OAuthCallbackError extends SignInError {\n}\nOAuthCallbackError.type = \"OAuthCallbackError\";\n/**\n * This error occurs during an OAuth sign in attempt when the provider's\n * response could not be parsed. This could for example happen if the provider's API\n * changed, or the [`OAuth2Config.profile`](https://authjs.dev/reference/core/providers#oauth2configprofile) method is not implemented correctly.\n * @noInheritDoc\n */\nclass OAuthProfileParseError extends AuthError {\n}\nOAuthProfileParseError.type = \"OAuthProfileParseError\";\n/**\n * Logged on the server when Auth.js could not retrieve a session from the database (`strategy: \"database\"`).\n *\n * The database adapter might be misconfigured or the database is not reachable.\n *\n * Learn more at [Concept: Database session strategy](https://authjs.dev/concepts/session-strategies#database)\n * @noInheritDoc\n */\nclass SessionTokenError extends AuthError {\n}\nSessionTokenError.type = \"SessionTokenError\";\n/**\n * Happens when login by [OAuth](https://authjs.dev/getting-started/authentication/oauth) could not be started.\n *\n * Possible causes are:\n * - The Authorization Server is not compliant with the [OAuth 2.0](https://www.ietf.org/rfc/rfc6749.html) or the [OIDC](https://openid.net/specs/openid-connect-core-1_0.html) specification.\n *   Check the details in the error message.\n *\n * :::tip\n * Check out `[auth][details]` in the logs to know which provider failed.\n * @example\n * ```sh\n * [auth][details]: { \"provider\": \"github\" }\n * ```\n * :::\n * @noInheritDoc\n */\nclass OAuthSignInError extends SignInError {\n}\nOAuthSignInError.type = \"OAuthSignInError\";\n/**\n * Happens when the login by an [Email provider](https://authjs.dev/getting-started/authentication/email) could not be started.\n *\n * Possible causes are:\n * - The email sent from the client is invalid, could not be normalized by [`EmailConfig.normalizeIdentifier`](https://authjs.dev/reference/core/providers/email#normalizeidentifier)\n * - The provided email/token combination has expired:\n *   Ask the user to log in again.\n * - There was an error with the database:\n *   Check the database logs.\n * @noInheritDoc\n */\nclass EmailSignInError extends SignInError {\n}\nEmailSignInError.type = \"EmailSignInError\";\n/**\n * Represents an error that occurs during the sign-out process. This error\n * is logged when there are issues in terminating a user's session, either\n * by failing to delete the session from the database (in database session\n * strategies) or encountering issues during other parts of the sign-out\n * process, such as emitting sign-out events or clearing session cookies.\n *\n * The session cookie(s) are emptied even if this error is logged.\n * @noInheritDoc\n */\nclass SignOutError extends AuthError {\n}\nSignOutError.type = \"SignOutError\";\n/**\n * Auth.js was requested to handle an operation that it does not support.\n *\n * See [`AuthAction`](https://authjs.dev/reference/core/types#authaction) for the supported actions.\n * @noInheritDoc\n */\nclass UnknownAction extends AuthError {\n}\nUnknownAction.type = \"UnknownAction\";\n/**\n * Thrown when a Credentials provider is present but the JWT strategy (`strategy: \"jwt\"`) is not enabled.\n *\n * Learn more at [`strategy`](https://authjs.dev/reference/core#strategy) or [Credentials provider](https://authjs.dev/getting-started/authentication/credentials)\n * @noInheritDoc\n */\nclass UnsupportedStrategy extends AuthError {\n}\nUnsupportedStrategy.type = \"UnsupportedStrategy\";\n/**\n * Thrown when an endpoint was incorrectly called without a provider, or with an unsupported provider.\n * @noInheritDoc\n */\nclass InvalidProvider extends AuthError {\n}\nInvalidProvider.type = \"InvalidProvider\";\n/**\n * Thrown when the `trustHost` option was not set to `true`.\n *\n * Auth.js requires the `trustHost` option to be set to `true` since it's relying on the request headers' `host` value.\n *\n * :::note\n * Official Auth.js libraries might attempt to automatically set the `trustHost` option to `true` if the request is coming from a trusted host on a trusted platform.\n * :::\n *\n * Learn more at [`trustHost`](https://authjs.dev/reference/core#trusthost) or [Guide: Deployment](https://authjs.dev/getting-started/deployment)\n * @noInheritDoc\n */\nclass UntrustedHost extends AuthError {\n}\nUntrustedHost.type = \"UntrustedHost\";\n/**\n * The user's email/token combination was invalid.\n * This could be because the email/token combination was not found in the database,\n * or because the token has expired. Ask the user to log in again.\n * @noInheritDoc\n */\nclass Verification extends AuthError {\n}\nVerification.type = \"Verification\";\n/**\n * Error for missing CSRF tokens in client-side actions (`signIn`, `signOut`, `useSession#update`).\n * Thrown when actions lack the double submit cookie, essential for CSRF protection.\n *\n * CSRF ([Cross-Site Request Forgery](https://owasp.org/www-community/attacks/csrf))\n * is an attack leveraging authenticated user credentials for unauthorized actions.\n *\n * Double submit cookie pattern, a CSRF defense, requires matching values in a cookie\n * and request parameter. More on this at [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Glossary/CSRF).\n * @noInheritDoc\n */\nclass MissingCSRF extends SignInError {\n}\nMissingCSRF.type = \"MissingCSRF\";\nconst clientErrors = new Set([\n    \"CredentialsSignin\",\n    \"OAuthAccountNotLinked\",\n    \"OAuthCallbackError\",\n    \"AccessDenied\",\n    \"Verification\",\n    \"MissingCSRF\",\n    \"AccountNotLinked\",\n    \"WebAuthnVerificationError\",\n]);\n/**\n * Used to only allow sending a certain subset of errors to the client.\n * Errors are always logged on the server, but to prevent leaking sensitive information,\n * only a subset of errors are sent to the client as-is.\n * @internal\n */\nfunction isClientError(error) {\n    if (error instanceof AuthError)\n        return clientErrors.has(error.type);\n    return false;\n}\n/**\n * Thrown when multiple providers have `enableConditionalUI` set to `true`.\n * Only one provider can have this option enabled at a time.\n * @noInheritDoc\n */\nclass DuplicateConditionalUI extends AuthError {\n}\nDuplicateConditionalUI.type = \"DuplicateConditionalUI\";\n/**\n * Thrown when a WebAuthn provider has `enableConditionalUI` set to `true` but no formField has `webauthn` in its autocomplete param.\n *\n * The `webauthn` autocomplete param is required for conditional UI to work.\n * @noInheritDoc\n */\nclass MissingWebAuthnAutocomplete extends AuthError {\n}\nMissingWebAuthnAutocomplete.type = \"MissingWebAuthnAutocomplete\";\n/**\n * Thrown when a WebAuthn provider fails to verify a client response.\n * @noInheritDoc\n */\nclass WebAuthnVerificationError extends AuthError {\n}\nWebAuthnVerificationError.type = \"WebAuthnVerificationError\";\n/**\n * Thrown when an Email address is already associated with an account\n * but the user is trying an account that is not linked to it.\n *\n * For security reasons, Auth.js does not automatically link accounts to existing accounts if the user is not signed in.\n * @noInheritDoc\n */\nclass AccountNotLinked extends SignInError {\n}\nAccountNotLinked.type = \"AccountNotLinked\";\n/**\n * Thrown when an experimental feature is used but not enabled.\n * @noInheritDoc\n */\nclass ExperimentalFeatureNotEnabled extends AuthError {\n}\nExperimentalFeatureNotEnabled.type = \"ExperimentalFeatureNotEnabled\";\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/errors.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/index.js":
/*!******************************************!*\
  !*** ./node_modules/@auth/core/index.js ***!
  \******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Auth: () => (/* binding */ Auth),\n/* harmony export */   createActionURL: () => (/* reexport safe */ _lib_utils_env_js__WEBPACK_IMPORTED_MODULE_3__.createActionURL),\n/* harmony export */   customFetch: () => (/* reexport safe */ _lib_symbols_js__WEBPACK_IMPORTED_MODULE_8__.customFetch),\n/* harmony export */   isAuthAction: () => (/* reexport safe */ _lib_utils_actions_js__WEBPACK_IMPORTED_MODULE_7__.isAuthAction),\n/* harmony export */   raw: () => (/* reexport safe */ _lib_index_js__WEBPACK_IMPORTED_MODULE_2__.raw),\n/* harmony export */   setEnvDefaults: () => (/* reexport safe */ _lib_utils_env_js__WEBPACK_IMPORTED_MODULE_3__.setEnvDefaults),\n/* harmony export */   skipCSRFCheck: () => (/* reexport safe */ _lib_index_js__WEBPACK_IMPORTED_MODULE_2__.skipCSRFCheck)\n/* harmony export */ });\n/* harmony import */ var _lib_utils_assert_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/utils/assert.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/assert.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _lib_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/index.js */ \"(rsc)/./node_modules/@auth/core/lib/index.js\");\n/* harmony import */ var _lib_utils_env_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/utils/env.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/env.js\");\n/* harmony import */ var _lib_pages_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./lib/pages/index.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/index.js\");\n/* harmony import */ var _lib_utils_logger_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lib/utils/logger.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/logger.js\");\n/* harmony import */ var _lib_utils_web_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./lib/utils/web.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/web.js\");\n/* harmony import */ var _lib_utils_actions_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./lib/utils/actions.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/actions.js\");\n/* harmony import */ var _lib_symbols_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./lib/symbols.js */ \"(rsc)/./node_modules/@auth/core/lib/symbols.js\");\n/**\n *\n * :::warning Experimental\n * `@auth/core` is under active development.\n * :::\n *\n * This is the main entry point to the Auth.js library.\n *\n * Based on the {@link https://developer.mozilla.org/en-US/docs/Web/API/Request Request}\n * and {@link https://developer.mozilla.org/en-US/docs/Web/API/Response Response} Web standard APIs.\n * Primarily used to implement [framework](https://authjs.dev/getting-started/integrations)-specific packages,\n * but it can also be used directly.\n *\n * ## Installation\n *\n * ```bash npm2yarn\n * npm install @auth/core\n * ```\n *\n * ## Usage\n *\n * ```ts\n * import { Auth } from \"@auth/core\"\n *\n * const request = new Request(\"https://example.com\")\n * const response = await Auth(request, {...})\n *\n * console.log(response instanceof Response) // true\n * ```\n *\n * ## Resources\n *\n * - [Getting started](https://authjs.dev/getting-started)\n * - [Guides](https://authjs.dev/guides)\n *\n * @module @auth/core\n */\n\n\n\n\n\n\n\n\n\n\n/**\n * Core functionality provided by Auth.js.\n *\n * Receives a standard {@link Request} and returns a {@link Response}.\n *\n * @example\n * ```ts\n * import { Auth } from \"@auth/core\"\n *\n * const request = new Request(\"https://example.com\")\n * const response = await Auth(request, {\n *   providers: [Google],\n *   secret: \"...\",\n *   trustHost: true,\n * })\n *```\n * @see [Documentation](https://authjs.dev)\n */\nasync function Auth(request, config) {\n    const logger = (0,_lib_utils_logger_js__WEBPACK_IMPORTED_MODULE_5__.setLogger)(config);\n    const internalRequest = await (0,_lib_utils_web_js__WEBPACK_IMPORTED_MODULE_6__.toInternalRequest)(request, config);\n    // There was an error parsing the request\n    if (!internalRequest)\n        return Response.json(`Bad request.`, { status: 400 });\n    const warningsOrError = (0,_lib_utils_assert_js__WEBPACK_IMPORTED_MODULE_0__.assertConfig)(internalRequest, config);\n    if (Array.isArray(warningsOrError)) {\n        warningsOrError.forEach(logger.warn);\n    }\n    else if (warningsOrError) {\n        // If there's an error in the user config, bail out early\n        logger.error(warningsOrError);\n        const htmlPages = new Set([\n            \"signin\",\n            \"signout\",\n            \"error\",\n            \"verify-request\",\n        ]);\n        if (!htmlPages.has(internalRequest.action) ||\n            internalRequest.method !== \"GET\") {\n            const message = \"There was a problem with the server configuration. Check the server logs for more information.\";\n            return Response.json({ message }, { status: 500 });\n        }\n        const { pages, theme } = config;\n        // If this is true, the config required auth on the error page\n        // which could cause a redirect loop\n        const authOnErrorPage = pages?.error &&\n            internalRequest.url.searchParams\n                .get(\"callbackUrl\")\n                ?.startsWith(pages.error);\n        // Either there was no error page configured or the configured one contains infinite redirects\n        if (!pages?.error || authOnErrorPage) {\n            if (authOnErrorPage) {\n                logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_1__.ErrorPageLoop(`The error page ${pages?.error} should not require authentication`));\n            }\n            const page = (0,_lib_pages_index_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])({ theme }).error(\"Configuration\");\n            return (0,_lib_utils_web_js__WEBPACK_IMPORTED_MODULE_6__.toResponse)(page);\n        }\n        const url = `${internalRequest.url.origin}${pages.error}?error=Configuration`;\n        return Response.redirect(url);\n    }\n    const isRedirect = request.headers?.has(\"X-Auth-Return-Redirect\");\n    const isRaw = config.raw === _lib_index_js__WEBPACK_IMPORTED_MODULE_2__.raw;\n    try {\n        const internalResponse = await (0,_lib_index_js__WEBPACK_IMPORTED_MODULE_2__.AuthInternal)(internalRequest, config);\n        if (isRaw)\n            return internalResponse;\n        const response = (0,_lib_utils_web_js__WEBPACK_IMPORTED_MODULE_6__.toResponse)(internalResponse);\n        const url = response.headers.get(\"Location\");\n        if (!isRedirect || !url)\n            return response;\n        return Response.json({ url }, { headers: response.headers });\n    }\n    catch (e) {\n        const error = e;\n        logger.error(error);\n        const isAuthError = error instanceof _errors_js__WEBPACK_IMPORTED_MODULE_1__.AuthError;\n        if (isAuthError && isRaw && !isRedirect)\n            throw error;\n        // If the CSRF check failed for POST/session, return a 400 status code.\n        // We should not redirect to a page as this is an API route\n        if (request.method === \"POST\" && internalRequest.action === \"session\")\n            return Response.json(null, { status: 400 });\n        const isClientSafeErrorType = (0,_errors_js__WEBPACK_IMPORTED_MODULE_1__.isClientError)(error);\n        const type = isClientSafeErrorType ? error.type : \"Configuration\";\n        const params = new URLSearchParams({ error: type });\n        if (error instanceof _errors_js__WEBPACK_IMPORTED_MODULE_1__.CredentialsSignin)\n            params.set(\"code\", error.code);\n        const pageKind = (isAuthError && error.kind) || \"error\";\n        const pagePath = config.pages?.[pageKind] ?? `${config.basePath}/${pageKind.toLowerCase()}`;\n        const url = `${internalRequest.url.origin}${pagePath}?${params}`;\n        if (isRedirect)\n            return Response.json({ url });\n        return Response.redirect(url);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/jwt.js":
/*!****************************************!*\
  !*** ./node_modules/@auth/core/jwt.js ***!
  \****************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   decode: () => (/* binding */ decode),\n/* harmony export */   encode: () => (/* binding */ encode),\n/* harmony export */   getToken: () => (/* binding */ getToken)\n/* harmony export */ });\n/* harmony import */ var _panva_hkdf__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @panva/hkdf */ \"(rsc)/./node_modules/@panva/hkdf/dist/node/esm/index.js\");\n/* harmony import */ var jose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! jose */ \"(rsc)/./node_modules/jose/dist/webapi/jwk/thumbprint.js\");\n/* harmony import */ var jose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! jose */ \"(rsc)/./node_modules/jose/dist/webapi/util/base64url.js\");\n/* harmony import */ var jose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! jose */ \"(rsc)/./node_modules/jose/dist/webapi/jwt/encrypt.js\");\n/* harmony import */ var jose__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! jose */ \"(rsc)/./node_modules/jose/dist/webapi/jwt/decrypt.js\");\n/* harmony import */ var _lib_utils_cookie_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/utils/cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/cookie.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _lib_vendored_cookie_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/vendored/cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/vendored/cookie.js\");\n/**\n *\n *\n * This module contains functions and types\n * to encode and decode {@link https://authjs.dev/concepts/session-strategies#jwt-session JWT}s\n * issued and used by Auth.js.\n *\n * The JWT issued by Auth.js is _encrypted by default_, using the _A256CBC-HS512_ algorithm ({@link https://www.rfc-editor.org/rfc/rfc7518.html#section-5.2.5 JWE}).\n * It uses the `AUTH_SECRET` environment variable or the passed `secret` property to derive a suitable encryption key.\n *\n * :::info Note\n * Auth.js JWTs are meant to be used by the same app that issued them.\n * If you need JWT authentication for your third-party API, you should rely on your Identity Provider instead.\n * :::\n *\n * ## Installation\n *\n * ```bash npm2yarn\n * npm install @auth/core\n * ```\n *\n * You can then import this submodule from `@auth/core/jwt`.\n *\n * ## Usage\n *\n * :::warning Warning\n * This module *will* be refactored/changed. We do not recommend relying on it right now.\n * :::\n *\n *\n * ## Resources\n *\n * - [What is a JWT session strategy](https://authjs.dev/concepts/session-strategies#jwt-session)\n * - [RFC7519 - JSON Web Token (JWT)](https://www.rfc-editor.org/rfc/rfc7519)\n *\n * @module jwt\n */\n\n\n\n\n\nconst { parse: parseCookie } = _lib_vendored_cookie_js__WEBPACK_IMPORTED_MODULE_2__;\nconst DEFAULT_MAX_AGE = 30 * 24 * 60 * 60; // 30 days\nconst now = () => (Date.now() / 1000) | 0;\nconst alg = \"dir\";\nconst enc = \"A256CBC-HS512\";\n/** Issues a JWT. By default, the JWT is encrypted using \"A256CBC-HS512\". */\nasync function encode(params) {\n    const { token = {}, secret, maxAge = DEFAULT_MAX_AGE, salt } = params;\n    const secrets = Array.isArray(secret) ? secret : [secret];\n    const encryptionSecret = await getDerivedEncryptionKey(enc, secrets[0], salt);\n    const thumbprint = await (0,jose__WEBPACK_IMPORTED_MODULE_3__.calculateJwkThumbprint)({ kty: \"oct\", k: jose__WEBPACK_IMPORTED_MODULE_4__.encode(encryptionSecret) }, `sha${encryptionSecret.byteLength << 3}`);\n    // @ts-expect-error `jose` allows any object as payload.\n    return await new jose__WEBPACK_IMPORTED_MODULE_5__.EncryptJWT(token)\n        .setProtectedHeader({ alg, enc, kid: thumbprint })\n        .setIssuedAt()\n        .setExpirationTime(now() + maxAge)\n        .setJti(crypto.randomUUID())\n        .encrypt(encryptionSecret);\n}\n/** Decodes an Auth.js issued JWT. */\nasync function decode(params) {\n    const { token, secret, salt } = params;\n    const secrets = Array.isArray(secret) ? secret : [secret];\n    if (!token)\n        return null;\n    const { payload } = await (0,jose__WEBPACK_IMPORTED_MODULE_6__.jwtDecrypt)(token, async ({ kid, enc }) => {\n        for (const secret of secrets) {\n            const encryptionSecret = await getDerivedEncryptionKey(enc, secret, salt);\n            if (kid === undefined)\n                return encryptionSecret;\n            const thumbprint = await (0,jose__WEBPACK_IMPORTED_MODULE_3__.calculateJwkThumbprint)({ kty: \"oct\", k: jose__WEBPACK_IMPORTED_MODULE_4__.encode(encryptionSecret) }, `sha${encryptionSecret.byteLength << 3}`);\n            if (kid === thumbprint)\n                return encryptionSecret;\n        }\n        throw new Error(\"no matching decryption secret\");\n    }, {\n        clockTolerance: 15,\n        keyManagementAlgorithms: [alg],\n        contentEncryptionAlgorithms: [enc, \"A256GCM\"],\n    });\n    return payload;\n}\nasync function getToken(params) {\n    const { secureCookie, cookieName = (0,_lib_utils_cookie_js__WEBPACK_IMPORTED_MODULE_0__.defaultCookies)(secureCookie ?? false).sessionToken.name, decode: _decode = decode, salt = cookieName, secret, logger = console, raw, req, } = params;\n    if (!req)\n        throw new Error(\"Must pass `req` to JWT getToken()\");\n    const headers = req.headers instanceof Headers ? req.headers : new Headers(req.headers);\n    const sessionStore = new _lib_utils_cookie_js__WEBPACK_IMPORTED_MODULE_0__.SessionStore({ name: cookieName, options: { secure: secureCookie } }, parseCookie(headers.get(\"cookie\") ?? \"\"), logger);\n    let token = sessionStore.value;\n    const authorizationHeader = headers.get(\"authorization\");\n    if (!token && authorizationHeader?.split(\" \")[0] === \"Bearer\") {\n        const urlEncodedToken = authorizationHeader.split(\" \")[1];\n        token = decodeURIComponent(urlEncodedToken);\n    }\n    if (!token)\n        return null;\n    if (raw)\n        return token;\n    if (!secret)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingSecret(\"Must pass `secret` if not set to JWT getToken()\");\n    try {\n        return await _decode({ token, secret, salt });\n    }\n    catch {\n        return null;\n    }\n}\nasync function getDerivedEncryptionKey(enc, keyMaterial, salt) {\n    let length;\n    switch (enc) {\n        case \"A256CBC-HS512\":\n            length = 64;\n            break;\n        case \"A256GCM\":\n            length = 32;\n            break;\n        default:\n            throw new Error(\"Unsupported JWT Content Encryption Algorithm\");\n    }\n    return await (0,_panva_hkdf__WEBPACK_IMPORTED_MODULE_7__.hkdf)(\"sha256\", keyMaterial, salt, `Auth.js Generated Encryption Key (${salt})`, length);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/jwt.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/callback/handle-login.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/callback/handle-login.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   handleLoginOrRegister: () => (/* binding */ handleLoginOrRegister)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _utils_date_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/date.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/date.js\");\n\n\n/**\n * This function handles the complex flow of signing users in, and either creating,\n * linking (or not linking) accounts depending on if the user is currently logged\n * in, if they have account already and the authentication mechanism they are using.\n *\n * It prevents insecure behaviour, such as linking OAuth accounts unless a user is\n * signed in and authenticated with an existing valid account.\n *\n * All verification (e.g. OAuth flows or email address verification flows) are\n * done prior to this handler being called to avoid additional complexity in this\n * handler.\n */\nasync function handleLoginOrRegister(sessionToken, _profile, _account, options) {\n    // Input validation\n    if (!_account?.providerAccountId || !_account.type)\n        throw new Error(\"Missing or invalid provider account\");\n    if (![\"email\", \"oauth\", \"oidc\", \"webauthn\"].includes(_account.type))\n        throw new Error(\"Provider not supported\");\n    const { adapter, jwt, events, session: { strategy: sessionStrategy, generateSessionToken }, } = options;\n    // If no adapter is configured then we don't have a database and cannot\n    // persist data; in this mode we just return a dummy session object.\n    if (!adapter) {\n        return { user: _profile, account: _account };\n    }\n    const profile = _profile;\n    let account = _account;\n    const { createUser, updateUser, getUser, getUserByAccount, getUserByEmail, linkAccount, createSession, getSessionAndUser, deleteSession, } = adapter;\n    let session = null;\n    let user = null;\n    let isNewUser = false;\n    const useJwtSession = sessionStrategy === \"jwt\";\n    if (sessionToken) {\n        if (useJwtSession) {\n            try {\n                const salt = options.cookies.sessionToken.name;\n                session = await jwt.decode({ ...jwt, token: sessionToken, salt });\n                if (session && \"sub\" in session && session.sub) {\n                    user = await getUser(session.sub);\n                }\n            }\n            catch {\n                // If session can't be verified, treat as no session\n            }\n        }\n        else {\n            const userAndSession = await getSessionAndUser(sessionToken);\n            if (userAndSession) {\n                session = userAndSession.session;\n                user = userAndSession.user;\n            }\n        }\n    }\n    if (account.type === \"email\") {\n        // If signing in with an email, check if an account with the same email address exists already\n        const userByEmail = await getUserByEmail(profile.email);\n        if (userByEmail) {\n            // If they are not already signed in as the same user, this flow will\n            // sign them out of the current session and sign them in as the new user\n            if (user?.id !== userByEmail.id && !useJwtSession && sessionToken) {\n                // Delete existing session if they are currently signed in as another user.\n                // This will switch user accounts for the session in cases where the user was\n                // already logged in with a different account.\n                await deleteSession(sessionToken);\n            }\n            // Update emailVerified property on the user object\n            user = await updateUser({\n                id: userByEmail.id,\n                emailVerified: new Date(),\n            });\n            await events.updateUser?.({ user });\n        }\n        else {\n            // Create user account if there isn't one for the email address already\n            user = await createUser({ ...profile, emailVerified: new Date() });\n            await events.createUser?.({ user });\n            isNewUser = true;\n        }\n        // Create new session\n        session = useJwtSession\n            ? {}\n            : await createSession({\n                sessionToken: generateSessionToken(),\n                userId: user.id,\n                expires: (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(options.session.maxAge),\n            });\n        return { session, user, isNewUser };\n    }\n    else if (account.type === \"webauthn\") {\n        // Check if the account exists\n        const userByAccount = await getUserByAccount({\n            providerAccountId: account.providerAccountId,\n            provider: account.provider,\n        });\n        if (userByAccount) {\n            if (user) {\n                // If the user is already signed in with this account, we don't need to do anything\n                if (userByAccount.id === user.id) {\n                    const currentAccount = { ...account, userId: user.id };\n                    return { session, user, isNewUser, account: currentAccount };\n                }\n                // If the user is currently signed in, but the new account they are signing in\n                // with is already associated with another user, then we cannot link them\n                // and need to return an error.\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AccountNotLinked(\"The account is already associated with another user\", { provider: account.provider });\n            }\n            // If there is no active session, but the account being signed in with is already\n            // associated with a valid user then create session to sign the user in.\n            session = useJwtSession\n                ? {}\n                : await createSession({\n                    sessionToken: generateSessionToken(),\n                    userId: userByAccount.id,\n                    expires: (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(options.session.maxAge),\n                });\n            const currentAccount = {\n                ...account,\n                userId: userByAccount.id,\n            };\n            return {\n                session,\n                user: userByAccount,\n                isNewUser,\n                account: currentAccount,\n            };\n        }\n        else {\n            // If the account doesn't exist, we'll create it\n            if (user) {\n                // If the user is already signed in and the account isn't already associated\n                // with another user account then we can go ahead and link the accounts safely.\n                await linkAccount({ ...account, userId: user.id });\n                await events.linkAccount?.({ user, account, profile });\n                // As they are already signed in, we don't need to do anything after linking them\n                const currentAccount = { ...account, userId: user.id };\n                return { session, user, isNewUser, account: currentAccount };\n            }\n            // If the user is not signed in and it looks like a new account then we\n            // check there also isn't an user account already associated with the same\n            // email address as the one in the request.\n            const userByEmail = profile.email\n                ? await getUserByEmail(profile.email)\n                : null;\n            if (userByEmail) {\n                // We don't trust user-provided email addresses, so we don't want to link accounts\n                // if the email address associated with the new account is already associated with\n                // an existing account.\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AccountNotLinked(\"Another account already exists with the same e-mail address\", { provider: account.provider });\n            }\n            else {\n                // If the current user is not logged in and the profile isn't linked to any user\n                // accounts (by email or provider account id)...\n                //\n                // If no account matching the same [provider].id or .email exists, we can\n                // create a new account for the user, link it to the OAuth account and\n                // create a new session for them so they are signed in with it.\n                user = await createUser({ ...profile });\n            }\n            await events.createUser?.({ user });\n            await linkAccount({ ...account, userId: user.id });\n            await events.linkAccount?.({ user, account, profile });\n            session = useJwtSession\n                ? {}\n                : await createSession({\n                    sessionToken: generateSessionToken(),\n                    userId: user.id,\n                    expires: (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(options.session.maxAge),\n                });\n            const currentAccount = { ...account, userId: user.id };\n            return { session, user, isNewUser: true, account: currentAccount };\n        }\n    }\n    // If signing in with OAuth account, check to see if the account exists already\n    const userByAccount = await getUserByAccount({\n        providerAccountId: account.providerAccountId,\n        provider: account.provider,\n    });\n    if (userByAccount) {\n        if (user) {\n            // If the user is already signed in with this account, we don't need to do anything\n            if (userByAccount.id === user.id) {\n                return { session, user, isNewUser };\n            }\n            // If the user is currently signed in, but the new account they are signing in\n            // with is already associated with another user, then we cannot link them\n            // and need to return an error.\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.OAuthAccountNotLinked(\"The account is already associated with another user\", { provider: account.provider });\n        }\n        // If there is no active session, but the account being signed in with is already\n        // associated with a valid user then create session to sign the user in.\n        session = useJwtSession\n            ? {}\n            : await createSession({\n                sessionToken: generateSessionToken(),\n                userId: userByAccount.id,\n                expires: (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(options.session.maxAge),\n            });\n        return { session, user: userByAccount, isNewUser };\n    }\n    else {\n        const { provider: p } = options;\n        const { type, provider, providerAccountId, userId, ...tokenSet } = account;\n        const defaults = { providerAccountId, provider, type, userId };\n        account = Object.assign(p.account(tokenSet) ?? {}, defaults);\n        if (user) {\n            // If the user is already signed in and the OAuth account isn't already associated\n            // with another user account then we can go ahead and link the accounts safely.\n            await linkAccount({ ...account, userId: user.id });\n            await events.linkAccount?.({ user, account, profile });\n            // As they are already signed in, we don't need to do anything after linking them\n            return { session, user, isNewUser };\n        }\n        // If the user is not signed in and it looks like a new OAuth account then we\n        // check there also isn't an user account already associated with the same\n        // email address as the one in the OAuth profile.\n        //\n        // This step is often overlooked in OAuth implementations, but covers the following cases:\n        //\n        // 1. It makes it harder for someone to accidentally create two accounts.\n        //    e.g. by signin in with email, then again with an oauth account connected to the same email.\n        // 2. It makes it harder to hijack a user account using a 3rd party OAuth account.\n        //    e.g. by creating an oauth account then changing the email address associated with it.\n        //\n        // It's quite common for services to automatically link accounts in this case, but it's\n        // better practice to require the user to sign in *then* link accounts to be sure\n        // someone is not exploiting a problem with a third party OAuth service.\n        //\n        // OAuth providers should require email address verification to prevent this, but in\n        // practice that is not always the case; this helps protect against that.\n        const userByEmail = profile.email\n            ? await getUserByEmail(profile.email)\n            : null;\n        if (userByEmail) {\n            const provider = options.provider;\n            if (provider?.allowDangerousEmailAccountLinking) {\n                // If you trust the oauth provider to correctly verify email addresses, you can opt-in to\n                // account linking even when the user is not signed-in.\n                user = userByEmail;\n                isNewUser = false;\n            }\n            else {\n                // We end up here when we don't have an account with the same [provider].id *BUT*\n                // we do already have an account with the same email address as the one in the\n                // OAuth profile the user has just tried to sign in with.\n                //\n                // We don't want to have two accounts with the same email address, and we don't\n                // want to link them in case it's not safe to do so, so instead we prompt the user\n                // to sign in via email to verify their identity and then link the accounts.\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.OAuthAccountNotLinked(\"Another account already exists with the same e-mail address\", { provider: account.provider });\n            }\n        }\n        else {\n            // If the current user is not logged in and the profile isn't linked to any user\n            // accounts (by email or provider account id)...\n            //\n            // If no account matching the same [provider].id or .email exists, we can\n            // create a new account for the user, link it to the OAuth account and\n            // create a new session for them so they are signed in with it.\n            user = await createUser({ ...profile, emailVerified: null });\n            isNewUser = true;\n        }\n        await events.createUser?.({ user });\n        await linkAccount({ ...account, userId: user.id });\n        await events.linkAccount?.({ user, account, profile });\n        session = useJwtSession\n            ? {}\n            : await createSession({\n                sessionToken: generateSessionToken(),\n                userId: user.id,\n                expires: (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(options.session.maxAge),\n            });\n        return { session, user, isNewUser };\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/callback/handle-login.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/callback/index.js":
/*!***************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/callback/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   callback: () => (/* binding */ callback)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _handle_login_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./handle-login.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/handle-login.js\");\n/* harmony import */ var _oauth_callback_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./oauth/callback.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/callback.js\");\n/* harmony import */ var _oauth_checks_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./oauth/checks.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js\");\n/* harmony import */ var _utils_web_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/web.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/web.js\");\n/* harmony import */ var _utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/webauthn-utils.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/webauthn-utils.js\");\n// TODO: Make this file smaller\n\n\n\n\n\n\n/** Handle callbacks from login services */\nasync function callback(request, options, sessionStore, cookies) {\n    if (!options.provider)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidProvider(\"Callback route called without provider\");\n    const { query, body, method, headers } = request;\n    const { provider, adapter, url, callbackUrl, pages, jwt, events, callbacks, session: { strategy: sessionStrategy, maxAge: sessionMaxAge }, logger, } = options;\n    const useJwtSession = sessionStrategy === \"jwt\";\n    try {\n        if (provider.type === \"oauth\" || provider.type === \"oidc\") {\n            // Use body if the response mode is set to form_post. For all other cases, use query\n            const params = provider.authorization?.url.searchParams.get(\"response_mode\") ===\n                \"form_post\"\n                ? body\n                : query;\n            // If we have a state and we are on a redirect proxy, we try to parse it\n            // and see if it contains a valid origin to redirect to. If it does, we\n            // redirect the user to that origin with the original state.\n            if (options.isOnRedirectProxy && params?.state) {\n                // NOTE: We rely on the state being encrypted using a shared secret\n                // between the proxy and the original server.\n                const parsedState = await _oauth_checks_js__WEBPACK_IMPORTED_MODULE_3__.state.decode(params.state, options);\n                const shouldRedirect = parsedState?.origin &&\n                    new URL(parsedState.origin).origin !== options.url.origin;\n                if (shouldRedirect) {\n                    const proxyRedirect = `${parsedState.origin}?${new URLSearchParams(params)}`;\n                    logger.debug(\"Proxy redirecting to\", proxyRedirect);\n                    return { redirect: proxyRedirect, cookies };\n                }\n            }\n            const authorizationResult = await (0,_oauth_callback_js__WEBPACK_IMPORTED_MODULE_2__.handleOAuth)(params, request.cookies, options);\n            if (authorizationResult.cookies.length) {\n                cookies.push(...authorizationResult.cookies);\n            }\n            logger.debug(\"authorization result\", authorizationResult);\n            const { user: userFromProvider, account, profile: OAuthProfile, } = authorizationResult;\n            // If we don't have a profile object then either something went wrong\n            // or the user cancelled signing in. We don't know which, so we just\n            // direct the user to the signin page for now. We could do something\n            // else in future.\n            // TODO: Handle user cancelling signin\n            if (!userFromProvider || !account || !OAuthProfile) {\n                return { redirect: `${url}/signin`, cookies };\n            }\n            // Check if user is allowed to sign in\n            // Attempt to get Profile from OAuth provider details before invoking\n            // signIn callback - but if no user object is returned, that is fine\n            // (that just means it's a new user signing in for the first time).\n            let userByAccount;\n            if (adapter) {\n                const { getUserByAccount } = adapter;\n                userByAccount = await getUserByAccount({\n                    providerAccountId: account.providerAccountId,\n                    provider: provider.id,\n                });\n            }\n            const redirect = await handleAuthorized({\n                user: userByAccount ?? userFromProvider,\n                account,\n                profile: OAuthProfile,\n            }, options);\n            if (redirect)\n                return { redirect, cookies };\n            const { user, session, isNewUser } = await (0,_handle_login_js__WEBPACK_IMPORTED_MODULE_1__.handleLoginOrRegister)(sessionStore.value, userFromProvider, account, options);\n            if (useJwtSession) {\n                const defaultToken = {\n                    name: user.name,\n                    email: user.email,\n                    picture: user.image,\n                    sub: user.id?.toString(),\n                };\n                const token = await callbacks.jwt({\n                    token: defaultToken,\n                    user,\n                    account,\n                    profile: OAuthProfile,\n                    isNewUser,\n                    trigger: isNewUser ? \"signUp\" : \"signIn\",\n                });\n                // Clear cookies if token is null\n                if (token === null) {\n                    cookies.push(...sessionStore.clean());\n                }\n                else {\n                    const salt = options.cookies.sessionToken.name;\n                    // Encode token\n                    const newToken = await jwt.encode({ ...jwt, token, salt });\n                    // Set cookie expiry date\n                    const cookieExpires = new Date();\n                    cookieExpires.setTime(cookieExpires.getTime() + sessionMaxAge * 1000);\n                    const sessionCookies = sessionStore.chunk(newToken, {\n                        expires: cookieExpires,\n                    });\n                    cookies.push(...sessionCookies);\n                }\n            }\n            else {\n                // Save Session Token in cookie\n                cookies.push({\n                    name: options.cookies.sessionToken.name,\n                    value: session.sessionToken,\n                    options: {\n                        ...options.cookies.sessionToken.options,\n                        expires: session.expires,\n                    },\n                });\n            }\n            await events.signIn?.({\n                user,\n                account,\n                profile: OAuthProfile,\n                isNewUser,\n            });\n            // Handle first logins on new accounts\n            // e.g. option to send users to a new account landing page on initial login\n            // Note that the callback URL is preserved, so the journey can still be resumed\n            if (isNewUser && pages.newUser) {\n                return {\n                    redirect: `${pages.newUser}${pages.newUser.includes(\"?\") ? \"&\" : \"?\"}${new URLSearchParams({ callbackUrl })}`,\n                    cookies,\n                };\n            }\n            return { redirect: callbackUrl, cookies };\n        }\n        else if (provider.type === \"email\") {\n            const paramToken = query?.token;\n            const paramIdentifier = query?.email;\n            if (!paramToken) {\n                const e = new TypeError(\"Missing token. The sign-in URL was manually opened without token or the link was not sent correctly in the email.\", { cause: { hasToken: !!paramToken } });\n                e.name = \"Configuration\";\n                throw e;\n            }\n            const secret = provider.secret ?? options.secret;\n            // @ts-expect-error -- Verified in `assertConfig`.\n            const invite = await adapter.useVerificationToken({\n                // @ts-expect-error User-land adapters might decide to omit the identifier during lookup\n                identifier: paramIdentifier, // TODO: Drop this requirement for lookup in official adapters too\n                token: await (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_4__.createHash)(`${paramToken}${secret}`),\n            });\n            const hasInvite = !!invite;\n            const expired = hasInvite && invite.expires.valueOf() < Date.now();\n            const invalidInvite = !hasInvite ||\n                expired ||\n                // The user might have configured the link to not contain the identifier\n                // so we only compare if it exists\n                (paramIdentifier && invite.identifier !== paramIdentifier);\n            if (invalidInvite)\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.Verification({ hasInvite, expired });\n            const { identifier } = invite;\n            const user = (await adapter.getUserByEmail(identifier)) ?? {\n                id: crypto.randomUUID(),\n                email: identifier,\n                emailVerified: null,\n            };\n            const account = {\n                providerAccountId: user.email,\n                userId: user.id,\n                type: \"email\",\n                provider: provider.id,\n            };\n            const redirect = await handleAuthorized({ user, account }, options);\n            if (redirect)\n                return { redirect, cookies };\n            // Sign user in\n            const { user: loggedInUser, session, isNewUser, } = await (0,_handle_login_js__WEBPACK_IMPORTED_MODULE_1__.handleLoginOrRegister)(sessionStore.value, user, account, options);\n            if (useJwtSession) {\n                const defaultToken = {\n                    name: loggedInUser.name,\n                    email: loggedInUser.email,\n                    picture: loggedInUser.image,\n                    sub: loggedInUser.id?.toString(),\n                };\n                const token = await callbacks.jwt({\n                    token: defaultToken,\n                    user: loggedInUser,\n                    account,\n                    isNewUser,\n                    trigger: isNewUser ? \"signUp\" : \"signIn\",\n                });\n                // Clear cookies if token is null\n                if (token === null) {\n                    cookies.push(...sessionStore.clean());\n                }\n                else {\n                    const salt = options.cookies.sessionToken.name;\n                    // Encode token\n                    const newToken = await jwt.encode({ ...jwt, token, salt });\n                    // Set cookie expiry date\n                    const cookieExpires = new Date();\n                    cookieExpires.setTime(cookieExpires.getTime() + sessionMaxAge * 1000);\n                    const sessionCookies = sessionStore.chunk(newToken, {\n                        expires: cookieExpires,\n                    });\n                    cookies.push(...sessionCookies);\n                }\n            }\n            else {\n                // Save Session Token in cookie\n                cookies.push({\n                    name: options.cookies.sessionToken.name,\n                    value: session.sessionToken,\n                    options: {\n                        ...options.cookies.sessionToken.options,\n                        expires: session.expires,\n                    },\n                });\n            }\n            await events.signIn?.({ user: loggedInUser, account, isNewUser });\n            // Handle first logins on new accounts\n            // e.g. option to send users to a new account landing page on initial login\n            // Note that the callback URL is preserved, so the journey can still be resumed\n            if (isNewUser && pages.newUser) {\n                return {\n                    redirect: `${pages.newUser}${pages.newUser.includes(\"?\") ? \"&\" : \"?\"}${new URLSearchParams({ callbackUrl })}`,\n                    cookies,\n                };\n            }\n            // Callback URL is already verified at this point, so safe to use if specified\n            return { redirect: callbackUrl, cookies };\n        }\n        else if (provider.type === \"credentials\" && method === \"POST\") {\n            const credentials = body ?? {};\n            // TODO: Forward the original request as is, instead of reconstructing it\n            Object.entries(query ?? {}).forEach(([k, v]) => url.searchParams.set(k, v));\n            const userFromAuthorize = await provider.authorize(credentials, \n            // prettier-ignore\n            new Request(url, { headers, method, body: JSON.stringify(body) }));\n            const user = userFromAuthorize;\n            if (!user)\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.CredentialsSignin();\n            else\n                user.id = user.id?.toString() ?? crypto.randomUUID();\n            const account = {\n                providerAccountId: user.id,\n                type: \"credentials\",\n                provider: provider.id,\n            };\n            const redirect = await handleAuthorized({ user, account, credentials }, options);\n            if (redirect)\n                return { redirect, cookies };\n            const defaultToken = {\n                name: user.name,\n                email: user.email,\n                picture: user.image,\n                sub: user.id,\n            };\n            const token = await callbacks.jwt({\n                token: defaultToken,\n                user,\n                account,\n                isNewUser: false,\n                trigger: \"signIn\",\n            });\n            // Clear cookies if token is null\n            if (token === null) {\n                cookies.push(...sessionStore.clean());\n            }\n            else {\n                const salt = options.cookies.sessionToken.name;\n                // Encode token\n                const newToken = await jwt.encode({ ...jwt, token, salt });\n                // Set cookie expiry date\n                const cookieExpires = new Date();\n                cookieExpires.setTime(cookieExpires.getTime() + sessionMaxAge * 1000);\n                const sessionCookies = sessionStore.chunk(newToken, {\n                    expires: cookieExpires,\n                });\n                cookies.push(...sessionCookies);\n            }\n            await events.signIn?.({ user, account });\n            return { redirect: callbackUrl, cookies };\n        }\n        else if (provider.type === \"webauthn\" && method === \"POST\") {\n            // Get callback action from request. It should be either \"authenticate\" or \"register\"\n            const action = request.body?.action;\n            if (typeof action !== \"string\" ||\n                (action !== \"authenticate\" && action !== \"register\")) {\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(\"Invalid action parameter\");\n            }\n            // Return an error if the adapter is missing or if the provider\n            // is not a webauthn provider.\n            const localOptions = (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_5__.assertInternalOptionsWebAuthn)(options);\n            // Verify request to get user, account and authenticator\n            let user;\n            let account;\n            let authenticator;\n            switch (action) {\n                case \"authenticate\": {\n                    const verified = await (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_5__.verifyAuthenticate)(localOptions, request, cookies);\n                    user = verified.user;\n                    account = verified.account;\n                    break;\n                }\n                case \"register\": {\n                    const verified = await (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_5__.verifyRegister)(options, request, cookies);\n                    user = verified.user;\n                    account = verified.account;\n                    authenticator = verified.authenticator;\n                    break;\n                }\n            }\n            // Check if user is allowed to sign in\n            await handleAuthorized({ user, account }, options);\n            // Sign user in, creating them and their account if needed\n            const { user: loggedInUser, isNewUser, session, account: currentAccount, } = await (0,_handle_login_js__WEBPACK_IMPORTED_MODULE_1__.handleLoginOrRegister)(sessionStore.value, user, account, options);\n            if (!currentAccount) {\n                // This is mostly for type checking. It should never actually happen.\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(\"Error creating or finding account\");\n            }\n            // Create new authenticator if needed\n            if (authenticator && loggedInUser.id) {\n                await localOptions.adapter.createAuthenticator({\n                    ...authenticator,\n                    userId: loggedInUser.id,\n                });\n            }\n            // Do the session registering dance\n            if (useJwtSession) {\n                const defaultToken = {\n                    name: loggedInUser.name,\n                    email: loggedInUser.email,\n                    picture: loggedInUser.image,\n                    sub: loggedInUser.id?.toString(),\n                };\n                const token = await callbacks.jwt({\n                    token: defaultToken,\n                    user: loggedInUser,\n                    account: currentAccount,\n                    isNewUser,\n                    trigger: isNewUser ? \"signUp\" : \"signIn\",\n                });\n                // Clear cookies if token is null\n                if (token === null) {\n                    cookies.push(...sessionStore.clean());\n                }\n                else {\n                    const salt = options.cookies.sessionToken.name;\n                    // Encode token\n                    const newToken = await jwt.encode({ ...jwt, token, salt });\n                    // Set cookie expiry date\n                    const cookieExpires = new Date();\n                    cookieExpires.setTime(cookieExpires.getTime() + sessionMaxAge * 1000);\n                    const sessionCookies = sessionStore.chunk(newToken, {\n                        expires: cookieExpires,\n                    });\n                    cookies.push(...sessionCookies);\n                }\n            }\n            else {\n                // Save Session Token in cookie\n                cookies.push({\n                    name: options.cookies.sessionToken.name,\n                    value: session.sessionToken,\n                    options: {\n                        ...options.cookies.sessionToken.options,\n                        expires: session.expires,\n                    },\n                });\n            }\n            await events.signIn?.({\n                user: loggedInUser,\n                account: currentAccount,\n                isNewUser,\n            });\n            // Handle first logins on new accounts\n            // e.g. option to send users to a new account landing page on initial login\n            // Note that the callback URL is preserved, so the journey can still be resumed\n            if (isNewUser && pages.newUser) {\n                return {\n                    redirect: `${pages.newUser}${pages.newUser.includes(\"?\") ? \"&\" : \"?\"}${new URLSearchParams({ callbackUrl })}`,\n                    cookies,\n                };\n            }\n            // Callback URL is already verified at this point, so safe to use if specified\n            return { redirect: callbackUrl, cookies };\n        }\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidProvider(`Callback for provider type (${provider.type}) is not supported`);\n    }\n    catch (e) {\n        if (e instanceof _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError)\n            throw e;\n        const error = new _errors_js__WEBPACK_IMPORTED_MODULE_0__.CallbackRouteError(e, { provider: provider.id });\n        logger.debug(\"callback route error details\", { method, query, body });\n        throw error;\n    }\n}\nasync function handleAuthorized(params, config) {\n    let authorized;\n    const { signIn, redirect } = config.callbacks;\n    try {\n        authorized = await signIn(params);\n    }\n    catch (e) {\n        if (e instanceof _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError)\n            throw e;\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AccessDenied(e);\n    }\n    if (!authorized)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AccessDenied(\"AccessDenied\");\n    if (typeof authorized !== \"string\")\n        return;\n    return await redirect({ url: authorized, baseUrl: config.url.origin });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/callback/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/callback.js":
/*!************************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/callback/oauth/callback.js ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getUserAndAccount: () => (/* binding */ getUserAndAccount),\n/* harmony export */   handleOAuth: () => (/* binding */ handleOAuth)\n/* harmony export */ });\n/* harmony import */ var _checks_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checks.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js\");\n/* harmony import */ var oauth4webapi__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! oauth4webapi */ \"(rsc)/./node_modules/oauth4webapi/build/index.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _utils_providers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utils/providers.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/providers.js\");\n/* harmony import */ var _symbols_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../symbols.js */ \"(rsc)/./node_modules/@auth/core/lib/symbols.js\");\n/* harmony import */ var jose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! jose */ \"(rsc)/./node_modules/jose/dist/webapi/util/decode_jwt.js\");\n\n\n\n\n\n\nfunction formUrlEncode(token) {\n    return encodeURIComponent(token).replace(/%20/g, \"+\");\n}\n/**\n * Formats client_id and client_secret as an HTTP Basic Authentication header as per the OAuth 2.0\n * specified in RFC6749.\n */\nfunction clientSecretBasic(clientId, clientSecret) {\n    const username = formUrlEncode(clientId);\n    const password = formUrlEncode(clientSecret);\n    const credentials = btoa(`${username}:${password}`);\n    return `Basic ${credentials}`;\n}\n/**\n * Handles the following OAuth steps.\n * https://www.rfc-editor.org/rfc/rfc6749#section-4.1.1\n * https://www.rfc-editor.org/rfc/rfc6749#section-4.1.3\n * https://openid.net/specs/openid-connect-core-1_0.html#UserInfoRequest\n *\n * @note Although requesting userinfo is not required by the OAuth2.0 spec,\n * we fetch it anyway. This is because we always want a user profile.\n */\nasync function handleOAuth(params, cookies, options) {\n    const { logger, provider } = options;\n    let as;\n    const { token, userinfo } = provider;\n    // Falls back to authjs.dev if the user only passed params\n    if ((!token?.url || token.url.host === \"authjs.dev\") &&\n        (!userinfo?.url || userinfo.url.host === \"authjs.dev\")) {\n        // We assume that issuer is always defined as this has been asserted earlier\n        const issuer = new URL(provider.issuer);\n        const discoveryResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.discoveryRequest(issuer, {\n            [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.allowInsecureRequests]: true,\n            [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.customFetch]: provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.customFetch],\n        });\n        as = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.processDiscoveryResponse(issuer, discoveryResponse);\n        if (!as.token_endpoint)\n            throw new TypeError(\"TODO: Authorization server did not provide a token endpoint.\");\n        if (!as.userinfo_endpoint)\n            throw new TypeError(\"TODO: Authorization server did not provide a userinfo endpoint.\");\n    }\n    else {\n        as = {\n            issuer: provider.issuer ?? \"https://authjs.dev\", // TODO: review fallback issuer\n            token_endpoint: token?.url.toString(),\n            userinfo_endpoint: userinfo?.url.toString(),\n        };\n    }\n    const client = {\n        client_id: provider.clientId,\n        ...provider.client,\n    };\n    let clientAuth;\n    switch (client.token_endpoint_auth_method) {\n        // TODO: in the next breaking major version have undefined be `client_secret_post`\n        case undefined:\n        case \"client_secret_basic\":\n            // TODO: in the next breaking major version use o.ClientSecretBasic() here\n            clientAuth = (_as, _client, _body, headers) => {\n                headers.set(\"authorization\", clientSecretBasic(provider.clientId, provider.clientSecret));\n            };\n            break;\n        case \"client_secret_post\":\n            clientAuth = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.ClientSecretPost(provider.clientSecret);\n            break;\n        case \"client_secret_jwt\":\n            clientAuth = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.ClientSecretJwt(provider.clientSecret);\n            break;\n        case \"private_key_jwt\":\n            clientAuth = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.PrivateKeyJwt(provider.token.clientPrivateKey, {\n                // TODO: review in the next breaking change\n                [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.modifyAssertion](_header, payload) {\n                    payload.aud = [as.issuer, as.token_endpoint];\n                },\n            });\n            break;\n        case \"none\":\n            clientAuth = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.None();\n            break;\n        default:\n            throw new Error(\"unsupported client authentication method\");\n    }\n    const resCookies = [];\n    const state = await _checks_js__WEBPACK_IMPORTED_MODULE_0__.state.use(cookies, resCookies, options);\n    let codeGrantParams;\n    try {\n        codeGrantParams = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.validateAuthResponse(as, client, new URLSearchParams(params), provider.checks.includes(\"state\") ? state : oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.skipStateCheck);\n    }\n    catch (err) {\n        if (err instanceof oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.AuthorizationResponseError) {\n            const cause = {\n                providerId: provider.id,\n                ...Object.fromEntries(err.cause.entries()),\n            };\n            logger.debug(\"OAuthCallbackError\", cause);\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.OAuthCallbackError(\"OAuth Provider returned an error\", cause);\n        }\n        throw err;\n    }\n    const codeVerifier = await _checks_js__WEBPACK_IMPORTED_MODULE_0__.pkce.use(cookies, resCookies, options);\n    let redirect_uri = provider.callbackUrl;\n    if (!options.isOnRedirectProxy && provider.redirectProxyUrl) {\n        redirect_uri = provider.redirectProxyUrl;\n    }\n    let codeGrantResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.authorizationCodeGrantRequest(as, client, clientAuth, codeGrantParams, redirect_uri, codeVerifier ?? \"decoy\", {\n        // TODO: move away from allowing insecure HTTP requests\n        [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.allowInsecureRequests]: true,\n        [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.customFetch]: (...args) => {\n            if (!provider.checks.includes(\"pkce\")) {\n                args[1].body.delete(\"code_verifier\");\n            }\n            return (provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.customFetch] ?? fetch)(...args);\n        },\n    });\n    if (provider.token?.conform) {\n        codeGrantResponse =\n            (await provider.token.conform(codeGrantResponse.clone())) ??\n                codeGrantResponse;\n    }\n    let profile = {};\n    const requireIdToken = (0,_utils_providers_js__WEBPACK_IMPORTED_MODULE_2__.isOIDCProvider)(provider);\n    if (provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.conformInternal]) {\n        switch (provider.id) {\n            case \"microsoft-entra-id\":\n            case \"azure-ad\": {\n                /**\n                 * These providers return errors in the response body and\n                 * need the authorization server metadata to be re-processed\n                 * based on the `id_token`'s `tid` claim.\n                 * @see: https://learn.microsoft.com/en-us/entra/identity-platform/v2-oauth2-auth-code-flow#error-response-1\n                 */\n                const responseJson = await codeGrantResponse.clone().json();\n                if (responseJson.error) {\n                    const cause = {\n                        providerId: provider.id,\n                        ...responseJson,\n                    };\n                    throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.OAuthCallbackError(`OAuth Provider returned an error: ${responseJson.error}`, cause);\n                }\n                const { tid } = (0,jose__WEBPACK_IMPORTED_MODULE_5__.decodeJwt)(responseJson.id_token);\n                if (typeof tid === \"string\") {\n                    const tenantRe = /microsoftonline\\.com\\/(\\w+)\\/v2\\.0/;\n                    const tenantId = as.issuer?.match(tenantRe)?.[1] ?? \"common\";\n                    const issuer = new URL(as.issuer.replace(tenantId, tid));\n                    const discoveryResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.discoveryRequest(issuer, {\n                        [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.customFetch]: provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.customFetch],\n                    });\n                    as = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.processDiscoveryResponse(issuer, discoveryResponse);\n                }\n                break;\n            }\n            default:\n                break;\n        }\n    }\n    const processedCodeResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.processAuthorizationCodeResponse(as, client, codeGrantResponse, {\n        expectedNonce: await _checks_js__WEBPACK_IMPORTED_MODULE_0__.nonce.use(cookies, resCookies, options),\n        requireIdToken,\n    });\n    const tokens = processedCodeResponse;\n    if (requireIdToken) {\n        const idTokenClaims = oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.getValidatedIdTokenClaims(processedCodeResponse);\n        profile = idTokenClaims;\n        // Apple sends some of the user information in a `user` parameter as a stringified JSON.\n        // It also only does so the first time the user consents to share their information.\n        if (provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.conformInternal] && provider.id === \"apple\") {\n            try {\n                profile.user = JSON.parse(params?.user);\n            }\n            catch { }\n        }\n        if (provider.idToken === false) {\n            const userinfoResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.userInfoRequest(as, client, processedCodeResponse.access_token, {\n                [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.customFetch]: provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.customFetch],\n                // TODO: move away from allowing insecure HTTP requests\n                [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.allowInsecureRequests]: true,\n            });\n            profile = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.processUserInfoResponse(as, client, idTokenClaims.sub, userinfoResponse);\n        }\n    }\n    else {\n        if (userinfo?.request) {\n            const _profile = await userinfo.request({ tokens, provider });\n            if (_profile instanceof Object)\n                profile = _profile;\n        }\n        else if (userinfo?.url) {\n            const userinfoResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.userInfoRequest(as, client, processedCodeResponse.access_token, {\n                [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.customFetch]: provider[_symbols_js__WEBPACK_IMPORTED_MODULE_3__.customFetch],\n                // TODO: move away from allowing insecure HTTP requests\n                [oauth4webapi__WEBPACK_IMPORTED_MODULE_4__.allowInsecureRequests]: true,\n            });\n            profile = await userinfoResponse.json();\n        }\n        else {\n            throw new TypeError(\"No userinfo endpoint configured\");\n        }\n    }\n    if (tokens.expires_in) {\n        tokens.expires_at =\n            Math.floor(Date.now() / 1000) + Number(tokens.expires_in);\n    }\n    const profileResult = await getUserAndAccount(profile, provider, tokens, logger);\n    return { ...profileResult, profile, cookies: resCookies };\n}\n/**\n * Returns the user and account that is going to be created in the database.\n * @internal\n */\nasync function getUserAndAccount(OAuthProfile, provider, tokens, logger) {\n    try {\n        const userFromProfile = await provider.profile(OAuthProfile, tokens);\n        const user = {\n            ...userFromProfile,\n            // The user's id is intentionally not set based on the profile id, as\n            // the user should remain independent of the provider and the profile id\n            // is saved on the Account already, as `providerAccountId`.\n            id: crypto.randomUUID(),\n            email: userFromProfile.email?.toLowerCase(),\n        };\n        return {\n            user,\n            account: {\n                ...tokens,\n                provider: provider.id,\n                type: provider.type,\n                providerAccountId: userFromProfile.id ?? crypto.randomUUID(),\n            },\n        };\n    }\n    catch (e) {\n        // If we didn't get a response either there was a problem with the provider\n        // response *or* the user cancelled the action with the provider.\n        //\n        // Unfortunately, we can't tell which - at least not in a way that works for\n        // all providers, so we return an empty object; the user should then be\n        // redirected back to the sign up page. We log the error to help developers\n        // who might be trying to debug this when configuring a new provider.\n        logger.debug(\"getProfile error details\", OAuthProfile);\n        logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_1__.OAuthProfileParseError(e, { provider: provider.id }));\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/callback.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/callback/oauth/checks.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   nonce: () => (/* binding */ nonce),\n/* harmony export */   pkce: () => (/* binding */ pkce),\n/* harmony export */   state: () => (/* binding */ state),\n/* harmony export */   webauthnChallenge: () => (/* binding */ webauthnChallenge)\n/* harmony export */ });\n/* harmony import */ var oauth4webapi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! oauth4webapi */ \"(rsc)/./node_modules/oauth4webapi/build/index.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _jwt_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../jwt.js */ \"(rsc)/./node_modules/@auth/core/jwt.js\");\n\n\n// NOTE: We use the default JWT methods here because they encrypt/decrypt the payload, not just sign it.\n\nconst COOKIE_TTL = 60 * 15; // 15 minutes\n/** Returns a cookie with a JWT encrypted payload. */\nasync function sealCookie(name, payload, options) {\n    const { cookies, logger } = options;\n    const cookie = cookies[name];\n    const expires = new Date();\n    expires.setTime(expires.getTime() + COOKIE_TTL * 1000);\n    logger.debug(`CREATE_${name.toUpperCase()}`, {\n        name: cookie.name,\n        payload,\n        COOKIE_TTL,\n        expires,\n    });\n    const encoded = await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.encode)({\n        ...options.jwt,\n        maxAge: COOKIE_TTL,\n        token: { value: payload },\n        salt: cookie.name,\n    });\n    const cookieOptions = { ...cookie.options, expires };\n    return { name: cookie.name, value: encoded, options: cookieOptions };\n}\nasync function parseCookie(name, value, options) {\n    try {\n        const { logger, cookies, jwt } = options;\n        logger.debug(`PARSE_${name.toUpperCase()}`, { cookie: value });\n        if (!value)\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidCheck(`${name} cookie was missing`);\n        const parsed = await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.decode)({\n            ...jwt,\n            token: value,\n            salt: cookies[name].name,\n        });\n        if (parsed?.value)\n            return parsed.value;\n        throw new Error(\"Invalid cookie\");\n    }\n    catch (error) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidCheck(`${name} value could not be parsed`, {\n            cause: error,\n        });\n    }\n}\nfunction clearCookie(name, options, resCookies) {\n    const { logger, cookies } = options;\n    const cookie = cookies[name];\n    logger.debug(`CLEAR_${name.toUpperCase()}`, { cookie });\n    resCookies.push({\n        name: cookie.name,\n        value: \"\",\n        options: { ...cookies[name].options, maxAge: 0 },\n    });\n}\nfunction useCookie(check, name) {\n    return async function (cookies, resCookies, options) {\n        const { provider, logger } = options;\n        if (!provider?.checks?.includes(check))\n            return;\n        const cookieValue = cookies?.[options.cookies[name].name];\n        logger.debug(`USE_${name.toUpperCase()}`, { value: cookieValue });\n        const parsed = await parseCookie(name, cookieValue, options);\n        clearCookie(name, options, resCookies);\n        return parsed;\n    };\n}\n/**\n * @see https://www.rfc-editor.org/rfc/rfc7636\n * @see https://danielfett.de/2020/05/16/pkce-vs-nonce-equivalent-or-not/#pkce\n */\nconst pkce = {\n    /** Creates a PKCE code challenge and verifier pair. The verifier in stored in the cookie. */\n    async create(options) {\n        const code_verifier = oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.generateRandomCodeVerifier();\n        const value = await oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.calculatePKCECodeChallenge(code_verifier);\n        const cookie = await sealCookie(\"pkceCodeVerifier\", code_verifier, options);\n        return { cookie, value };\n    },\n    /**\n     * Returns code_verifier if the provider is configured to use PKCE,\n     * and clears the container cookie afterwards.\n     * An error is thrown if the code_verifier is missing or invalid.\n     */\n    use: useCookie(\"pkce\", \"pkceCodeVerifier\"),\n};\nconst STATE_MAX_AGE = 60 * 15; // 15 minutes in seconds\nconst encodedStateSalt = \"encodedState\";\n/**\n * @see https://www.rfc-editor.org/rfc/rfc6749#section-10.12\n * @see https://www.rfc-editor.org/rfc/rfc6749#section-4.1.1\n */\nconst state = {\n    /** Creates a state cookie with an optionally encoded body. */\n    async create(options, origin) {\n        const { provider } = options;\n        if (!provider.checks.includes(\"state\")) {\n            if (origin) {\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidCheck(\"State data was provided but the provider is not configured to use state\");\n            }\n            return;\n        }\n        // IDEA: Allow the user to pass data to be stored in the state\n        const payload = {\n            origin,\n            random: oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.generateRandomState(),\n        };\n        const value = await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.encode)({\n            secret: options.jwt.secret,\n            token: payload,\n            salt: encodedStateSalt,\n            maxAge: STATE_MAX_AGE,\n        });\n        const cookie = await sealCookie(\"state\", value, options);\n        return { cookie, value };\n    },\n    /**\n     * Returns state if the provider is configured to use state,\n     * and clears the container cookie afterwards.\n     * An error is thrown if the state is missing or invalid.\n     */\n    use: useCookie(\"state\", \"state\"),\n    /** Decodes the state. If it could not be decoded, it throws an error. */\n    async decode(state, options) {\n        try {\n            options.logger.debug(\"DECODE_STATE\", { state });\n            const payload = await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.decode)({\n                secret: options.jwt.secret,\n                token: state,\n                salt: encodedStateSalt,\n            });\n            if (payload)\n                return payload;\n            throw new Error(\"Invalid state\");\n        }\n        catch (error) {\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidCheck(\"State could not be decoded\", { cause: error });\n        }\n    },\n};\nconst nonce = {\n    async create(options) {\n        if (!options.provider.checks.includes(\"nonce\"))\n            return;\n        const value = oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.generateRandomNonce();\n        const cookie = await sealCookie(\"nonce\", value, options);\n        return { cookie, value };\n    },\n    /**\n     * Returns nonce if the provider is configured to use nonce,\n     * and clears the container cookie afterwards.\n     * An error is thrown if the nonce is missing or invalid.\n     * @see https://openid.net/specs/openid-connect-core-1_0.html#NonceNotes\n     * @see https://danielfett.de/2020/05/16/pkce-vs-nonce-equivalent-or-not/#nonce\n     */\n    use: useCookie(\"nonce\", \"nonce\"),\n};\nconst WEBAUTHN_CHALLENGE_MAX_AGE = 60 * 15; // 15 minutes in seconds\nconst webauthnChallengeSalt = \"encodedWebauthnChallenge\";\nconst webauthnChallenge = {\n    async create(options, challenge, registerData) {\n        return {\n            cookie: await sealCookie(\"webauthnChallenge\", await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.encode)({\n                secret: options.jwt.secret,\n                token: { challenge, registerData },\n                salt: webauthnChallengeSalt,\n                maxAge: WEBAUTHN_CHALLENGE_MAX_AGE,\n            }), options),\n        };\n    },\n    /** Returns WebAuthn challenge if present. */\n    async use(options, cookies, resCookies) {\n        const cookieValue = cookies?.[options.cookies.webauthnChallenge.name];\n        const parsed = await parseCookie(\"webauthnChallenge\", cookieValue, options);\n        const payload = await (0,_jwt_js__WEBPACK_IMPORTED_MODULE_1__.decode)({\n            secret: options.jwt.secret,\n            token: parsed,\n            salt: webauthnChallengeSalt,\n        });\n        // Clear the WebAuthn challenge cookie after use\n        clearCookie(\"webauthnChallenge\", options, resCookies);\n        if (!payload)\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidCheck(\"WebAuthn challenge was missing\");\n        return payload;\n    },\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvYWN0aW9ucy9jYWxsYmFjay9vYXV0aC9jaGVja3MuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFrQztBQUNtQjtBQUNyRDtBQUNvRDtBQUNwRCw0QkFBNEI7QUFDNUI7QUFDQTtBQUNBLFlBQVksa0JBQWtCO0FBQzlCO0FBQ0E7QUFDQTtBQUNBLDJCQUEyQixtQkFBbUI7QUFDOUM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0wsMEJBQTBCLCtDQUFNO0FBQ2hDO0FBQ0E7QUFDQSxpQkFBaUIsZ0JBQWdCO0FBQ2pDO0FBQ0EsS0FBSztBQUNMLDRCQUE0QjtBQUM1QixhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0EsZ0JBQWdCLHVCQUF1QjtBQUN2Qyw4QkFBOEIsbUJBQW1CLEtBQUssZUFBZTtBQUNyRTtBQUNBLHNCQUFzQixvREFBWSxJQUFJLE1BQU07QUFDNUMsNkJBQTZCLCtDQUFNO0FBQ25DO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLG9EQUFZLElBQUksTUFBTTtBQUN4QztBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxZQUFZLGtCQUFrQjtBQUM5QjtBQUNBLDBCQUEwQixtQkFBbUIsS0FBSyxRQUFRO0FBQzFEO0FBQ0E7QUFDQTtBQUNBLG1CQUFtQixxQ0FBcUM7QUFDeEQsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBLGdCQUFnQixtQkFBbUI7QUFDbkM7QUFDQTtBQUNBO0FBQ0EsNEJBQTRCLG1CQUFtQixLQUFLLG9CQUFvQjtBQUN4RTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDQSw4QkFBOEIsb0VBQTRCO0FBQzFELDRCQUE0QixvRUFBNEI7QUFDeEQ7QUFDQSxpQkFBaUI7QUFDakIsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsK0JBQStCO0FBQy9CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDQSxnQkFBZ0IsV0FBVztBQUMzQjtBQUNBO0FBQ0EsMEJBQTBCLG9EQUFZO0FBQ3RDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLG9CQUFvQiw2REFBcUI7QUFDekM7QUFDQSw0QkFBNEIsK0NBQU07QUFDbEM7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQSxpQkFBaUI7QUFDakIsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLG1EQUFtRCxPQUFPO0FBQzFELGtDQUFrQywrQ0FBTTtBQUN4QztBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNCQUFzQixvREFBWSxpQ0FBaUMsY0FBYztBQUNqRjtBQUNBLEtBQUs7QUFDTDtBQUNPO0FBQ1A7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLDZEQUFxQjtBQUMzQztBQUNBLGlCQUFpQjtBQUNqQixLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNENBQTRDO0FBQzVDO0FBQ087QUFDUDtBQUNBO0FBQ0EsZ0VBQWdFLCtDQUFNO0FBQ3RFO0FBQ0EseUJBQXlCLHlCQUF5QjtBQUNsRDtBQUNBO0FBQ0EsYUFBYTtBQUNiO0FBQ0EsS0FBSztBQUNMO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsOEJBQThCLCtDQUFNO0FBQ3BDO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxzQkFBc0Isb0RBQVk7QUFDbEM7QUFDQSxLQUFLO0FBQ0wiLCJzb3VyY2VzIjpbIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvbm9kZV9tb2R1bGVzL0BhdXRoL2NvcmUvbGliL2FjdGlvbnMvY2FsbGJhY2svb2F1dGgvY2hlY2tzLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIG8gZnJvbSBcIm9hdXRoNHdlYmFwaVwiO1xuaW1wb3J0IHsgSW52YWxpZENoZWNrIH0gZnJvbSBcIi4uLy4uLy4uLy4uL2Vycm9ycy5qc1wiO1xuLy8gTk9URTogV2UgdXNlIHRoZSBkZWZhdWx0IEpXVCBtZXRob2RzIGhlcmUgYmVjYXVzZSB0aGV5IGVuY3J5cHQvZGVjcnlwdCB0aGUgcGF5bG9hZCwgbm90IGp1c3Qgc2lnbiBpdC5cbmltcG9ydCB7IGRlY29kZSwgZW5jb2RlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL2p3dC5qc1wiO1xuY29uc3QgQ09PS0lFX1RUTCA9IDYwICogMTU7IC8vIDE1IG1pbnV0ZXNcbi8qKiBSZXR1cm5zIGEgY29va2llIHdpdGggYSBKV1QgZW5jcnlwdGVkIHBheWxvYWQuICovXG5hc3luYyBmdW5jdGlvbiBzZWFsQ29va2llKG5hbWUsIHBheWxvYWQsIG9wdGlvbnMpIHtcbiAgICBjb25zdCB7IGNvb2tpZXMsIGxvZ2dlciB9ID0gb3B0aW9ucztcbiAgICBjb25zdCBjb29raWUgPSBjb29raWVzW25hbWVdO1xuICAgIGNvbnN0IGV4cGlyZXMgPSBuZXcgRGF0ZSgpO1xuICAgIGV4cGlyZXMuc2V0VGltZShleHBpcmVzLmdldFRpbWUoKSArIENPT0tJRV9UVEwgKiAxMDAwKTtcbiAgICBsb2dnZXIuZGVidWcoYENSRUFURV8ke25hbWUudG9VcHBlckNhc2UoKX1gLCB7XG4gICAgICAgIG5hbWU6IGNvb2tpZS5uYW1lLFxuICAgICAgICBwYXlsb2FkLFxuICAgICAgICBDT09LSUVfVFRMLFxuICAgICAgICBleHBpcmVzLFxuICAgIH0pO1xuICAgIGNvbnN0IGVuY29kZWQgPSBhd2FpdCBlbmNvZGUoe1xuICAgICAgICAuLi5vcHRpb25zLmp3dCxcbiAgICAgICAgbWF4QWdlOiBDT09LSUVfVFRMLFxuICAgICAgICB0b2tlbjogeyB2YWx1ZTogcGF5bG9hZCB9LFxuICAgICAgICBzYWx0OiBjb29raWUubmFtZSxcbiAgICB9KTtcbiAgICBjb25zdCBjb29raWVPcHRpb25zID0geyAuLi5jb29raWUub3B0aW9ucywgZXhwaXJlcyB9O1xuICAgIHJldHVybiB7IG5hbWU6IGNvb2tpZS5uYW1lLCB2YWx1ZTogZW5jb2RlZCwgb3B0aW9uczogY29va2llT3B0aW9ucyB9O1xufVxuYXN5bmMgZnVuY3Rpb24gcGFyc2VDb29raWUobmFtZSwgdmFsdWUsIG9wdGlvbnMpIHtcbiAgICB0cnkge1xuICAgICAgICBjb25zdCB7IGxvZ2dlciwgY29va2llcywgand0IH0gPSBvcHRpb25zO1xuICAgICAgICBsb2dnZXIuZGVidWcoYFBBUlNFXyR7bmFtZS50b1VwcGVyQ2FzZSgpfWAsIHsgY29va2llOiB2YWx1ZSB9KTtcbiAgICAgICAgaWYgKCF2YWx1ZSlcbiAgICAgICAgICAgIHRocm93IG5ldyBJbnZhbGlkQ2hlY2soYCR7bmFtZX0gY29va2llIHdhcyBtaXNzaW5nYCk7XG4gICAgICAgIGNvbnN0IHBhcnNlZCA9IGF3YWl0IGRlY29kZSh7XG4gICAgICAgICAgICAuLi5qd3QsXG4gICAgICAgICAgICB0b2tlbjogdmFsdWUsXG4gICAgICAgICAgICBzYWx0OiBjb29raWVzW25hbWVdLm5hbWUsXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAocGFyc2VkPy52YWx1ZSlcbiAgICAgICAgICAgIHJldHVybiBwYXJzZWQudmFsdWU7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihcIkludmFsaWQgY29va2llXCIpO1xuICAgIH1cbiAgICBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgdGhyb3cgbmV3IEludmFsaWRDaGVjayhgJHtuYW1lfSB2YWx1ZSBjb3VsZCBub3QgYmUgcGFyc2VkYCwge1xuICAgICAgICAgICAgY2F1c2U6IGVycm9yLFxuICAgICAgICB9KTtcbiAgICB9XG59XG5mdW5jdGlvbiBjbGVhckNvb2tpZShuYW1lLCBvcHRpb25zLCByZXNDb29raWVzKSB7XG4gICAgY29uc3QgeyBsb2dnZXIsIGNvb2tpZXMgfSA9IG9wdGlvbnM7XG4gICAgY29uc3QgY29va2llID0gY29va2llc1tuYW1lXTtcbiAgICBsb2dnZXIuZGVidWcoYENMRUFSXyR7bmFtZS50b1VwcGVyQ2FzZSgpfWAsIHsgY29va2llIH0pO1xuICAgIHJlc0Nvb2tpZXMucHVzaCh7XG4gICAgICAgIG5hbWU6IGNvb2tpZS5uYW1lLFxuICAgICAgICB2YWx1ZTogXCJcIixcbiAgICAgICAgb3B0aW9uczogeyAuLi5jb29raWVzW25hbWVdLm9wdGlvbnMsIG1heEFnZTogMCB9LFxuICAgIH0pO1xufVxuZnVuY3Rpb24gdXNlQ29va2llKGNoZWNrLCBuYW1lKSB7XG4gICAgcmV0dXJuIGFzeW5jIGZ1bmN0aW9uIChjb29raWVzLCByZXNDb29raWVzLCBvcHRpb25zKSB7XG4gICAgICAgIGNvbnN0IHsgcHJvdmlkZXIsIGxvZ2dlciB9ID0gb3B0aW9ucztcbiAgICAgICAgaWYgKCFwcm92aWRlcj8uY2hlY2tzPy5pbmNsdWRlcyhjaGVjaykpXG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIGNvbnN0IGNvb2tpZVZhbHVlID0gY29va2llcz8uW29wdGlvbnMuY29va2llc1tuYW1lXS5uYW1lXTtcbiAgICAgICAgbG9nZ2VyLmRlYnVnKGBVU0VfJHtuYW1lLnRvVXBwZXJDYXNlKCl9YCwgeyB2YWx1ZTogY29va2llVmFsdWUgfSk7XG4gICAgICAgIGNvbnN0IHBhcnNlZCA9IGF3YWl0IHBhcnNlQ29va2llKG5hbWUsIGNvb2tpZVZhbHVlLCBvcHRpb25zKTtcbiAgICAgICAgY2xlYXJDb29raWUobmFtZSwgb3B0aW9ucywgcmVzQ29va2llcyk7XG4gICAgICAgIHJldHVybiBwYXJzZWQ7XG4gICAgfTtcbn1cbi8qKlxuICogQHNlZSBodHRwczovL3d3dy5yZmMtZWRpdG9yLm9yZy9yZmMvcmZjNzYzNlxuICogQHNlZSBodHRwczovL2RhbmllbGZldHQuZGUvMjAyMC8wNS8xNi9wa2NlLXZzLW5vbmNlLWVxdWl2YWxlbnQtb3Itbm90LyNwa2NlXG4gKi9cbmV4cG9ydCBjb25zdCBwa2NlID0ge1xuICAgIC8qKiBDcmVhdGVzIGEgUEtDRSBjb2RlIGNoYWxsZW5nZSBhbmQgdmVyaWZpZXIgcGFpci4gVGhlIHZlcmlmaWVyIGluIHN0b3JlZCBpbiB0aGUgY29va2llLiAqL1xuICAgIGFzeW5jIGNyZWF0ZShvcHRpb25zKSB7XG4gICAgICAgIGNvbnN0IGNvZGVfdmVyaWZpZXIgPSBvLmdlbmVyYXRlUmFuZG9tQ29kZVZlcmlmaWVyKCk7XG4gICAgICAgIGNvbnN0IHZhbHVlID0gYXdhaXQgby5jYWxjdWxhdGVQS0NFQ29kZUNoYWxsZW5nZShjb2RlX3ZlcmlmaWVyKTtcbiAgICAgICAgY29uc3QgY29va2llID0gYXdhaXQgc2VhbENvb2tpZShcInBrY2VDb2RlVmVyaWZpZXJcIiwgY29kZV92ZXJpZmllciwgb3B0aW9ucyk7XG4gICAgICAgIHJldHVybiB7IGNvb2tpZSwgdmFsdWUgfTtcbiAgICB9LFxuICAgIC8qKlxuICAgICAqIFJldHVybnMgY29kZV92ZXJpZmllciBpZiB0aGUgcHJvdmlkZXIgaXMgY29uZmlndXJlZCB0byB1c2UgUEtDRSxcbiAgICAgKiBhbmQgY2xlYXJzIHRoZSBjb250YWluZXIgY29va2llIGFmdGVyd2FyZHMuXG4gICAgICogQW4gZXJyb3IgaXMgdGhyb3duIGlmIHRoZSBjb2RlX3ZlcmlmaWVyIGlzIG1pc3Npbmcgb3IgaW52YWxpZC5cbiAgICAgKi9cbiAgICB1c2U6IHVzZUNvb2tpZShcInBrY2VcIiwgXCJwa2NlQ29kZVZlcmlmaWVyXCIpLFxufTtcbmNvbnN0IFNUQVRFX01BWF9BR0UgPSA2MCAqIDE1OyAvLyAxNSBtaW51dGVzIGluIHNlY29uZHNcbmNvbnN0IGVuY29kZWRTdGF0ZVNhbHQgPSBcImVuY29kZWRTdGF0ZVwiO1xuLyoqXG4gKiBAc2VlIGh0dHBzOi8vd3d3LnJmYy1lZGl0b3Iub3JnL3JmYy9yZmM2NzQ5I3NlY3Rpb24tMTAuMTJcbiAqIEBzZWUgaHR0cHM6Ly93d3cucmZjLWVkaXRvci5vcmcvcmZjL3JmYzY3NDkjc2VjdGlvbi00LjEuMVxuICovXG5leHBvcnQgY29uc3Qgc3RhdGUgPSB7XG4gICAgLyoqIENyZWF0ZXMgYSBzdGF0ZSBjb29raWUgd2l0aCBhbiBvcHRpb25hbGx5IGVuY29kZWQgYm9keS4gKi9cbiAgICBhc3luYyBjcmVhdGUob3B0aW9ucywgb3JpZ2luKSB7XG4gICAgICAgIGNvbnN0IHsgcHJvdmlkZXIgfSA9IG9wdGlvbnM7XG4gICAgICAgIGlmICghcHJvdmlkZXIuY2hlY2tzLmluY2x1ZGVzKFwic3RhdGVcIikpIHtcbiAgICAgICAgICAgIGlmIChvcmlnaW4pIHtcbiAgICAgICAgICAgICAgICB0aHJvdyBuZXcgSW52YWxpZENoZWNrKFwiU3RhdGUgZGF0YSB3YXMgcHJvdmlkZWQgYnV0IHRoZSBwcm92aWRlciBpcyBub3QgY29uZmlndXJlZCB0byB1c2Ugc3RhdGVcIik7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgLy8gSURFQTogQWxsb3cgdGhlIHVzZXIgdG8gcGFzcyBkYXRhIHRvIGJlIHN0b3JlZCBpbiB0aGUgc3RhdGVcbiAgICAgICAgY29uc3QgcGF5bG9hZCA9IHtcbiAgICAgICAgICAgIG9yaWdpbixcbiAgICAgICAgICAgIHJhbmRvbTogby5nZW5lcmF0ZVJhbmRvbVN0YXRlKCksXG4gICAgICAgIH07XG4gICAgICAgIGNvbnN0IHZhbHVlID0gYXdhaXQgZW5jb2RlKHtcbiAgICAgICAgICAgIHNlY3JldDogb3B0aW9ucy5qd3Quc2VjcmV0LFxuICAgICAgICAgICAgdG9rZW46IHBheWxvYWQsXG4gICAgICAgICAgICBzYWx0OiBlbmNvZGVkU3RhdGVTYWx0LFxuICAgICAgICAgICAgbWF4QWdlOiBTVEFURV9NQVhfQUdFLFxuICAgICAgICB9KTtcbiAgICAgICAgY29uc3QgY29va2llID0gYXdhaXQgc2VhbENvb2tpZShcInN0YXRlXCIsIHZhbHVlLCBvcHRpb25zKTtcbiAgICAgICAgcmV0dXJuIHsgY29va2llLCB2YWx1ZSB9O1xuICAgIH0sXG4gICAgLyoqXG4gICAgICogUmV0dXJucyBzdGF0ZSBpZiB0aGUgcHJvdmlkZXIgaXMgY29uZmlndXJlZCB0byB1c2Ugc3RhdGUsXG4gICAgICogYW5kIGNsZWFycyB0aGUgY29udGFpbmVyIGNvb2tpZSBhZnRlcndhcmRzLlxuICAgICAqIEFuIGVycm9yIGlzIHRocm93biBpZiB0aGUgc3RhdGUgaXMgbWlzc2luZyBvciBpbnZhbGlkLlxuICAgICAqL1xuICAgIHVzZTogdXNlQ29va2llKFwic3RhdGVcIiwgXCJzdGF0ZVwiKSxcbiAgICAvKiogRGVjb2RlcyB0aGUgc3RhdGUuIElmIGl0IGNvdWxkIG5vdCBiZSBkZWNvZGVkLCBpdCB0aHJvd3MgYW4gZXJyb3IuICovXG4gICAgYXN5bmMgZGVjb2RlKHN0YXRlLCBvcHRpb25zKSB7XG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICBvcHRpb25zLmxvZ2dlci5kZWJ1ZyhcIkRFQ09ERV9TVEFURVwiLCB7IHN0YXRlIH0pO1xuICAgICAgICAgICAgY29uc3QgcGF5bG9hZCA9IGF3YWl0IGRlY29kZSh7XG4gICAgICAgICAgICAgICAgc2VjcmV0OiBvcHRpb25zLmp3dC5zZWNyZXQsXG4gICAgICAgICAgICAgICAgdG9rZW46IHN0YXRlLFxuICAgICAgICAgICAgICAgIHNhbHQ6IGVuY29kZWRTdGF0ZVNhbHQsXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIGlmIChwYXlsb2FkKVxuICAgICAgICAgICAgICAgIHJldHVybiBwYXlsb2FkO1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKFwiSW52YWxpZCBzdGF0ZVwiKTtcbiAgICAgICAgfVxuICAgICAgICBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBJbnZhbGlkQ2hlY2soXCJTdGF0ZSBjb3VsZCBub3QgYmUgZGVjb2RlZFwiLCB7IGNhdXNlOiBlcnJvciB9KTtcbiAgICAgICAgfVxuICAgIH0sXG59O1xuZXhwb3J0IGNvbnN0IG5vbmNlID0ge1xuICAgIGFzeW5jIGNyZWF0ZShvcHRpb25zKSB7XG4gICAgICAgIGlmICghb3B0aW9ucy5wcm92aWRlci5jaGVja3MuaW5jbHVkZXMoXCJub25jZVwiKSlcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgY29uc3QgdmFsdWUgPSBvLmdlbmVyYXRlUmFuZG9tTm9uY2UoKTtcbiAgICAgICAgY29uc3QgY29va2llID0gYXdhaXQgc2VhbENvb2tpZShcIm5vbmNlXCIsIHZhbHVlLCBvcHRpb25zKTtcbiAgICAgICAgcmV0dXJuIHsgY29va2llLCB2YWx1ZSB9O1xuICAgIH0sXG4gICAgLyoqXG4gICAgICogUmV0dXJucyBub25jZSBpZiB0aGUgcHJvdmlkZXIgaXMgY29uZmlndXJlZCB0byB1c2Ugbm9uY2UsXG4gICAgICogYW5kIGNsZWFycyB0aGUgY29udGFpbmVyIGNvb2tpZSBhZnRlcndhcmRzLlxuICAgICAqIEFuIGVycm9yIGlzIHRocm93biBpZiB0aGUgbm9uY2UgaXMgbWlzc2luZyBvciBpbnZhbGlkLlxuICAgICAqIEBzZWUgaHR0cHM6Ly9vcGVuaWQubmV0L3NwZWNzL29wZW5pZC1jb25uZWN0LWNvcmUtMV8wLmh0bWwjTm9uY2VOb3Rlc1xuICAgICAqIEBzZWUgaHR0cHM6Ly9kYW5pZWxmZXR0LmRlLzIwMjAvMDUvMTYvcGtjZS12cy1ub25jZS1lcXVpdmFsZW50LW9yLW5vdC8jbm9uY2VcbiAgICAgKi9cbiAgICB1c2U6IHVzZUNvb2tpZShcIm5vbmNlXCIsIFwibm9uY2VcIiksXG59O1xuY29uc3QgV0VCQVVUSE5fQ0hBTExFTkdFX01BWF9BR0UgPSA2MCAqIDE1OyAvLyAxNSBtaW51dGVzIGluIHNlY29uZHNcbmNvbnN0IHdlYmF1dGhuQ2hhbGxlbmdlU2FsdCA9IFwiZW5jb2RlZFdlYmF1dGhuQ2hhbGxlbmdlXCI7XG5leHBvcnQgY29uc3Qgd2ViYXV0aG5DaGFsbGVuZ2UgPSB7XG4gICAgYXN5bmMgY3JlYXRlKG9wdGlvbnMsIGNoYWxsZW5nZSwgcmVnaXN0ZXJEYXRhKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBjb29raWU6IGF3YWl0IHNlYWxDb29raWUoXCJ3ZWJhdXRobkNoYWxsZW5nZVwiLCBhd2FpdCBlbmNvZGUoe1xuICAgICAgICAgICAgICAgIHNlY3JldDogb3B0aW9ucy5qd3Quc2VjcmV0LFxuICAgICAgICAgICAgICAgIHRva2VuOiB7IGNoYWxsZW5nZSwgcmVnaXN0ZXJEYXRhIH0sXG4gICAgICAgICAgICAgICAgc2FsdDogd2ViYXV0aG5DaGFsbGVuZ2VTYWx0LFxuICAgICAgICAgICAgICAgIG1heEFnZTogV0VCQVVUSE5fQ0hBTExFTkdFX01BWF9BR0UsXG4gICAgICAgICAgICB9KSwgb3B0aW9ucyksXG4gICAgICAgIH07XG4gICAgfSxcbiAgICAvKiogUmV0dXJucyBXZWJBdXRobiBjaGFsbGVuZ2UgaWYgcHJlc2VudC4gKi9cbiAgICBhc3luYyB1c2Uob3B0aW9ucywgY29va2llcywgcmVzQ29va2llcykge1xuICAgICAgICBjb25zdCBjb29raWVWYWx1ZSA9IGNvb2tpZXM/LltvcHRpb25zLmNvb2tpZXMud2ViYXV0aG5DaGFsbGVuZ2UubmFtZV07XG4gICAgICAgIGNvbnN0IHBhcnNlZCA9IGF3YWl0IHBhcnNlQ29va2llKFwid2ViYXV0aG5DaGFsbGVuZ2VcIiwgY29va2llVmFsdWUsIG9wdGlvbnMpO1xuICAgICAgICBjb25zdCBwYXlsb2FkID0gYXdhaXQgZGVjb2RlKHtcbiAgICAgICAgICAgIHNlY3JldDogb3B0aW9ucy5qd3Quc2VjcmV0LFxuICAgICAgICAgICAgdG9rZW46IHBhcnNlZCxcbiAgICAgICAgICAgIHNhbHQ6IHdlYmF1dGhuQ2hhbGxlbmdlU2FsdCxcbiAgICAgICAgfSk7XG4gICAgICAgIC8vIENsZWFyIHRoZSBXZWJBdXRobiBjaGFsbGVuZ2UgY29va2llIGFmdGVyIHVzZVxuICAgICAgICBjbGVhckNvb2tpZShcIndlYmF1dGhuQ2hhbGxlbmdlXCIsIG9wdGlvbnMsIHJlc0Nvb2tpZXMpO1xuICAgICAgICBpZiAoIXBheWxvYWQpXG4gICAgICAgICAgICB0aHJvdyBuZXcgSW52YWxpZENoZWNrKFwiV2ViQXV0aG4gY2hhbGxlbmdlIHdhcyBtaXNzaW5nXCIpO1xuICAgICAgICByZXR1cm4gcGF5bG9hZDtcbiAgICB9LFxufTtcbiJdLCJuYW1lcyI6W10sImlnbm9yZUxpc3QiOlswXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/csrf-token.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/callback/oauth/csrf-token.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createCSRFToken: () => (/* binding */ createCSRFToken),\n/* harmony export */   validateCSRF: () => (/* binding */ validateCSRF)\n/* harmony export */ });\n/* harmony import */ var _utils_web_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../utils/web.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/web.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\n\n/**\n * Ensure CSRF Token cookie is set for any subsequent requests.\n * Used as part of the strategy for mitigation for CSRF tokens.\n *\n * Creates a cookie like 'next-auth.csrf-token' with the value 'token|hash',\n * where 'token' is the CSRF token and 'hash' is a hash made of the token and\n * the secret, and the two values are joined by a pipe '|'. By storing the\n * value and the hash of the value (with the secret used as a salt) we can\n * verify the cookie was set by the server and not by a malicious attacker.\n *\n * For more details, see the following OWASP links:\n * https://cheatsheetseries.owasp.org/cheatsheets/Cross-Site_Request_Forgery_Prevention_Cheat_Sheet.html#double-submit-cookie\n * https://owasp.org/www-chapter-london/assets/slides/David_Johansson-Double_Defeat_of_Double-Submit_Cookie.pdf\n */\nasync function createCSRFToken({ options, cookieValue, isPost, bodyValue, }) {\n    if (cookieValue) {\n        const [csrfToken, csrfTokenHash] = cookieValue.split(\"|\");\n        const expectedCsrfTokenHash = await (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.createHash)(`${csrfToken}${options.secret}`);\n        if (csrfTokenHash === expectedCsrfTokenHash) {\n            // If hash matches then we trust the CSRF token value\n            // If this is a POST request and the CSRF Token in the POST request matches\n            // the cookie we have already verified is the one we have set, then the token is verified!\n            const csrfTokenVerified = isPost && csrfToken === bodyValue;\n            return { csrfTokenVerified, csrfToken };\n        }\n    }\n    // New CSRF token\n    const csrfToken = (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.randomString)(32);\n    const csrfTokenHash = await (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.createHash)(`${csrfToken}${options.secret}`);\n    const cookie = `${csrfToken}|${csrfTokenHash}`;\n    return { cookie, csrfToken };\n}\nfunction validateCSRF(action, verified) {\n    if (verified)\n        return;\n    throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingCSRF(`CSRF token was missing during an action ${action}`);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/csrf-token.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/index.js":
/*!******************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   callback: () => (/* reexport safe */ _callback_index_js__WEBPACK_IMPORTED_MODULE_0__.callback),\n/* harmony export */   session: () => (/* reexport safe */ _session_js__WEBPACK_IMPORTED_MODULE_1__.session),\n/* harmony export */   signIn: () => (/* reexport safe */ _signin_index_js__WEBPACK_IMPORTED_MODULE_2__.signIn),\n/* harmony export */   signOut: () => (/* reexport safe */ _signout_js__WEBPACK_IMPORTED_MODULE_3__.signOut),\n/* harmony export */   webAuthnOptions: () => (/* reexport safe */ _webauthn_options_js__WEBPACK_IMPORTED_MODULE_4__.webAuthnOptions)\n/* harmony export */ });\n/* harmony import */ var _callback_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./callback/index.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/index.js\");\n/* harmony import */ var _session_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./session.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/session.js\");\n/* harmony import */ var _signin_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./signin/index.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/signin/index.js\");\n/* harmony import */ var _signout_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./signout.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/signout.js\");\n/* harmony import */ var _webauthn_options_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./webauthn-options.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/webauthn-options.js\");\n\n\n\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvYWN0aW9ucy9pbmRleC5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBQStDO0FBQ1I7QUFDSTtBQUNKO0FBQ2lCIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L25vZGVfbW9kdWxlcy9AYXV0aC9jb3JlL2xpYi9hY3Rpb25zL2luZGV4LmpzIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCB7IGNhbGxiYWNrIH0gZnJvbSBcIi4vY2FsbGJhY2svaW5kZXguanNcIjtcbmV4cG9ydCB7IHNlc3Npb24gfSBmcm9tIFwiLi9zZXNzaW9uLmpzXCI7XG5leHBvcnQgeyBzaWduSW4gfSBmcm9tIFwiLi9zaWduaW4vaW5kZXguanNcIjtcbmV4cG9ydCB7IHNpZ25PdXQgfSBmcm9tIFwiLi9zaWdub3V0LmpzXCI7XG5leHBvcnQgeyB3ZWJBdXRobk9wdGlvbnMgfSBmcm9tIFwiLi93ZWJhdXRobi1vcHRpb25zLmpzXCI7XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/session.js":
/*!********************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/session.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   session: () => (/* binding */ session)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _utils_date_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/date.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/date.js\");\n\n\n/** Return a session object filtered via `callbacks.session` */\nasync function session(options, sessionStore, cookies, isUpdate, newSession) {\n    const { adapter, jwt, events, callbacks, logger, session: { strategy: sessionStrategy, maxAge: sessionMaxAge }, } = options;\n    const response = {\n        body: null,\n        headers: {\n            \"Content-Type\": \"application/json\",\n            ...(!isUpdate && {\n                \"Cache-Control\": \"private, no-cache, no-store\",\n                Expires: \"0\",\n                Pragma: \"no-cache\",\n            }),\n        },\n        cookies,\n    };\n    const sessionToken = sessionStore.value;\n    if (!sessionToken)\n        return response;\n    if (sessionStrategy === \"jwt\") {\n        try {\n            const salt = options.cookies.sessionToken.name;\n            const payload = await jwt.decode({ ...jwt, token: sessionToken, salt });\n            if (!payload)\n                throw new Error(\"Invalid JWT\");\n            // @ts-expect-error\n            const token = await callbacks.jwt({\n                token: payload,\n                ...(isUpdate && { trigger: \"update\" }),\n                session: newSession,\n            });\n            const newExpires = (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(sessionMaxAge);\n            if (token !== null) {\n                // By default, only exposes a limited subset of information to the client\n                // as needed for presentation purposes (e.g. \"you are logged in as...\").\n                const session = {\n                    user: { name: token.name, email: token.email, image: token.picture },\n                    expires: newExpires.toISOString(),\n                };\n                // @ts-expect-error\n                const newSession = await callbacks.session({ session, token });\n                // Return session payload as response\n                response.body = newSession;\n                // Refresh JWT expiry by re-signing it, with an updated expiry date\n                const newToken = await jwt.encode({ ...jwt, token, salt });\n                // Set cookie, to also update expiry date on cookie\n                const sessionCookies = sessionStore.chunk(newToken, {\n                    expires: newExpires,\n                });\n                response.cookies?.push(...sessionCookies);\n                await events.session?.({ session: newSession, token });\n            }\n            else {\n                response.cookies?.push(...sessionStore.clean());\n            }\n        }\n        catch (e) {\n            logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_0__.JWTSessionError(e));\n            // If the JWT is not verifiable remove the broken session cookie(s).\n            response.cookies?.push(...sessionStore.clean());\n        }\n        return response;\n    }\n    // Retrieve session from database\n    try {\n        const { getSessionAndUser, deleteSession, updateSession } = adapter;\n        let userAndSession = await getSessionAndUser(sessionToken);\n        // If session has expired, clean up the database\n        if (userAndSession &&\n            userAndSession.session.expires.valueOf() < Date.now()) {\n            await deleteSession(sessionToken);\n            userAndSession = null;\n        }\n        if (userAndSession) {\n            const { user, session } = userAndSession;\n            const sessionUpdateAge = options.session.updateAge;\n            // Calculate last updated date to throttle write updates to database\n            // Formula: ({expiry date} - sessionMaxAge) + sessionUpdateAge\n            //     e.g. ({expiry date} - 30 days) + 1 hour\n            const sessionIsDueToBeUpdatedDate = session.expires.valueOf() -\n                sessionMaxAge * 1000 +\n                sessionUpdateAge * 1000;\n            const newExpires = (0,_utils_date_js__WEBPACK_IMPORTED_MODULE_1__.fromDate)(sessionMaxAge);\n            // Trigger update of session expiry date and write to database, only\n            // if the session was last updated more than {sessionUpdateAge} ago\n            if (sessionIsDueToBeUpdatedDate <= Date.now()) {\n                await updateSession({\n                    sessionToken: sessionToken,\n                    expires: newExpires,\n                });\n            }\n            // Pass Session through to the session callback\n            const sessionPayload = await callbacks.session({\n                // TODO: user already passed below,\n                // remove from session object in https://github.com/nextauthjs/next-auth/pull/9702\n                // @ts-expect-error\n                session: { ...session, user },\n                user,\n                newSession,\n                ...(isUpdate ? { trigger: \"update\" } : {}),\n            });\n            // Return session payload as response\n            response.body = sessionPayload;\n            // Set cookie again to update expiry\n            response.cookies?.push({\n                name: options.cookies.sessionToken.name,\n                value: sessionToken,\n                options: {\n                    ...options.cookies.sessionToken.options,\n                    expires: newExpires,\n                },\n            });\n            // @ts-expect-error\n            await events.session?.({ session: sessionPayload });\n        }\n        else if (sessionToken) {\n            // If `sessionToken` was found set but it's not valid for a session then\n            // remove the sessionToken cookie from browser.\n            response.cookies?.push(...sessionStore.clean());\n        }\n    }\n    catch (e) {\n        logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_0__.SessionTokenError(e));\n    }\n    return response;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/session.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/signin/authorization-url.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/signin/authorization-url.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getAuthorizationUrl: () => (/* binding */ getAuthorizationUrl)\n/* harmony export */ });\n/* harmony import */ var _callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../callback/oauth/checks.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js\");\n/* harmony import */ var oauth4webapi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! oauth4webapi */ \"(rsc)/./node_modules/oauth4webapi/build/index.js\");\n/* harmony import */ var _symbols_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../symbols.js */ \"(rsc)/./node_modules/@auth/core/lib/symbols.js\");\n\n\n\n/**\n * Generates an authorization/request token URL.\n *\n * [OAuth 2](https://www.oauth.com/oauth2-servers/authorization/the-authorization-request/)\n */\nasync function getAuthorizationUrl(query, options) {\n    const { logger, provider } = options;\n    let url = provider.authorization?.url;\n    let as;\n    // Falls back to authjs.dev if the user only passed params\n    if (!url || url.host === \"authjs.dev\") {\n        // If url is undefined, we assume that issuer is always defined\n        // We check this in assert.ts\n        const issuer = new URL(provider.issuer);\n        const discoveryResponse = await oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.discoveryRequest(issuer, {\n            [oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.customFetch]: provider[_symbols_js__WEBPACK_IMPORTED_MODULE_1__.customFetch],\n            // TODO: move away from allowing insecure HTTP requests\n            [oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.allowInsecureRequests]: true,\n        });\n        const as = await oauth4webapi__WEBPACK_IMPORTED_MODULE_2__.processDiscoveryResponse(issuer, discoveryResponse)\n            .catch((error) => {\n            if (!(error instanceof TypeError) || error.message !== \"Invalid URL\")\n                throw error;\n            throw new TypeError(`Discovery request responded with an invalid issuer. expected: ${issuer}`);\n        });\n        if (!as.authorization_endpoint) {\n            throw new TypeError(\"Authorization server did not provide an authorization endpoint.\");\n        }\n        url = new URL(as.authorization_endpoint);\n    }\n    const authParams = url.searchParams;\n    let redirect_uri = provider.callbackUrl;\n    let data;\n    if (!options.isOnRedirectProxy && provider.redirectProxyUrl) {\n        redirect_uri = provider.redirectProxyUrl;\n        data = provider.callbackUrl;\n        logger.debug(\"using redirect proxy\", { redirect_uri, data });\n    }\n    const params = Object.assign({\n        response_type: \"code\",\n        // clientId can technically be undefined, should we check this in assert.ts or rely on the Authorization Server to do it?\n        client_id: provider.clientId,\n        redirect_uri,\n        // @ts-expect-error TODO:\n        ...provider.authorization?.params,\n    }, Object.fromEntries(provider.authorization?.url.searchParams ?? []), query);\n    for (const k in params)\n        authParams.set(k, params[k]);\n    const cookies = [];\n    if (\n    // Otherwise \"POST /redirect_uri\" wouldn't include the cookies\n    provider.authorization?.url.searchParams.get(\"response_mode\") ===\n        \"form_post\") {\n        options.cookies.state.options.sameSite = \"none\";\n        options.cookies.state.options.secure = true;\n        options.cookies.nonce.options.sameSite = \"none\";\n        options.cookies.nonce.options.secure = true;\n    }\n    const state = await _callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_0__.state.create(options, data);\n    if (state) {\n        authParams.set(\"state\", state.value);\n        cookies.push(state.cookie);\n    }\n    if (provider.checks?.includes(\"pkce\")) {\n        if (as && !as.code_challenge_methods_supported?.includes(\"S256\")) {\n            // We assume S256 PKCE support, if the server does not advertise that,\n            // a random `nonce` must be used for CSRF protection.\n            if (provider.type === \"oidc\")\n                provider.checks = [\"nonce\"];\n        }\n        else {\n            const { value, cookie } = await _callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_0__.pkce.create(options);\n            authParams.set(\"code_challenge\", value);\n            authParams.set(\"code_challenge_method\", \"S256\");\n            cookies.push(cookie);\n        }\n    }\n    const nonce = await _callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_0__.nonce.create(options);\n    if (nonce) {\n        authParams.set(\"nonce\", nonce.value);\n        cookies.push(nonce.cookie);\n    }\n    // TODO: This does not work in normalizeOAuth because authorization endpoint can come from discovery\n    // Need to make normalizeOAuth async\n    if (provider.type === \"oidc\" && !url.searchParams.has(\"scope\")) {\n        url.searchParams.set(\"scope\", \"openid profile email\");\n    }\n    logger.debug(\"authorization url is ready\", { url, cookies, provider });\n    return { redirect: url.toString(), cookies };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/signin/authorization-url.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/signin/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/signin/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   signIn: () => (/* binding */ signIn)\n/* harmony export */ });\n/* harmony import */ var _authorization_url_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./authorization-url.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/signin/authorization-url.js\");\n/* harmony import */ var _send_token_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./send-token.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/signin/send-token.js\");\n\n\nasync function signIn(request, cookies, options) {\n    const signInUrl = `${options.url.origin}${options.basePath}/signin`;\n    if (!options.provider)\n        return { redirect: signInUrl, cookies };\n    switch (options.provider.type) {\n        case \"oauth\":\n        case \"oidc\": {\n            const { redirect, cookies: authCookies } = await (0,_authorization_url_js__WEBPACK_IMPORTED_MODULE_0__.getAuthorizationUrl)(request.query, options);\n            if (authCookies)\n                cookies.push(...authCookies);\n            return { redirect, cookies };\n        }\n        case \"email\": {\n            const response = await (0,_send_token_js__WEBPACK_IMPORTED_MODULE_1__.sendToken)(request, options);\n            return { ...response, cookies };\n        }\n        default:\n            return { redirect: signInUrl, cookies };\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvYWN0aW9ucy9zaWduaW4vaW5kZXguanMiLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQTZEO0FBQ2pCO0FBQ3JDO0FBQ1AseUJBQXlCLG1CQUFtQixFQUFFLGlCQUFpQjtBQUMvRDtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBO0FBQ0E7QUFDQSxvQkFBb0IsaUNBQWlDLFFBQVEsMEVBQW1CO0FBQ2hGO0FBQ0E7QUFDQSxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLG1DQUFtQyx5REFBUztBQUM1QyxxQkFBcUI7QUFDckI7QUFDQTtBQUNBLHFCQUFxQjtBQUNyQjtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L25vZGVfbW9kdWxlcy9AYXV0aC9jb3JlL2xpYi9hY3Rpb25zL3NpZ25pbi9pbmRleC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBnZXRBdXRob3JpemF0aW9uVXJsIH0gZnJvbSBcIi4vYXV0aG9yaXphdGlvbi11cmwuanNcIjtcbmltcG9ydCB7IHNlbmRUb2tlbiB9IGZyb20gXCIuL3NlbmQtdG9rZW4uanNcIjtcbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBzaWduSW4ocmVxdWVzdCwgY29va2llcywgb3B0aW9ucykge1xuICAgIGNvbnN0IHNpZ25JblVybCA9IGAke29wdGlvbnMudXJsLm9yaWdpbn0ke29wdGlvbnMuYmFzZVBhdGh9L3NpZ25pbmA7XG4gICAgaWYgKCFvcHRpb25zLnByb3ZpZGVyKVxuICAgICAgICByZXR1cm4geyByZWRpcmVjdDogc2lnbkluVXJsLCBjb29raWVzIH07XG4gICAgc3dpdGNoIChvcHRpb25zLnByb3ZpZGVyLnR5cGUpIHtcbiAgICAgICAgY2FzZSBcIm9hdXRoXCI6XG4gICAgICAgIGNhc2UgXCJvaWRjXCI6IHtcbiAgICAgICAgICAgIGNvbnN0IHsgcmVkaXJlY3QsIGNvb2tpZXM6IGF1dGhDb29raWVzIH0gPSBhd2FpdCBnZXRBdXRob3JpemF0aW9uVXJsKHJlcXVlc3QucXVlcnksIG9wdGlvbnMpO1xuICAgICAgICAgICAgaWYgKGF1dGhDb29raWVzKVxuICAgICAgICAgICAgICAgIGNvb2tpZXMucHVzaCguLi5hdXRoQ29va2llcyk7XG4gICAgICAgICAgICByZXR1cm4geyByZWRpcmVjdCwgY29va2llcyB9O1xuICAgICAgICB9XG4gICAgICAgIGNhc2UgXCJlbWFpbFwiOiB7XG4gICAgICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHNlbmRUb2tlbihyZXF1ZXN0LCBvcHRpb25zKTtcbiAgICAgICAgICAgIHJldHVybiB7IC4uLnJlc3BvbnNlLCBjb29raWVzIH07XG4gICAgICAgIH1cbiAgICAgICAgZGVmYXVsdDpcbiAgICAgICAgICAgIHJldHVybiB7IHJlZGlyZWN0OiBzaWduSW5VcmwsIGNvb2tpZXMgfTtcbiAgICB9XG59XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/signin/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/signin/send-token.js":
/*!******************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/signin/send-token.js ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   sendToken: () => (/* binding */ sendToken)\n/* harmony export */ });\n/* harmony import */ var _utils_web_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/web.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/web.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\n\n/**\n * Starts an e-mail login flow, by generating a token,\n * and sending it to the user's e-mail (with the help of a DB adapter).\n * At the end, it returns a redirect to the `verify-request` page.\n */\nasync function sendToken(request, options) {\n    const { body } = request;\n    const { provider, callbacks, adapter } = options;\n    const normalizer = provider.normalizeIdentifier ?? defaultNormalizer;\n    const email = normalizer(body?.email);\n    const defaultUser = { id: crypto.randomUUID(), email, emailVerified: null };\n    const user = (await adapter.getUserByEmail(email)) ?? defaultUser;\n    const account = {\n        providerAccountId: email,\n        userId: user.id,\n        type: \"email\",\n        provider: provider.id,\n    };\n    let authorized;\n    try {\n        authorized = await callbacks.signIn({\n            user,\n            account,\n            email: { verificationRequest: true },\n        });\n    }\n    catch (e) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.AccessDenied(e);\n    }\n    if (!authorized)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.AccessDenied(\"AccessDenied\");\n    if (typeof authorized === \"string\") {\n        return {\n            redirect: await callbacks.redirect({\n                url: authorized,\n                baseUrl: options.url.origin,\n            }),\n        };\n    }\n    const { callbackUrl, theme } = options;\n    const token = (await provider.generateVerificationToken?.()) ?? (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.randomString)(32);\n    const ONE_DAY_IN_SECONDS = 86400;\n    const expires = new Date(Date.now() + (provider.maxAge ?? ONE_DAY_IN_SECONDS) * 1000);\n    const secret = provider.secret ?? options.secret;\n    const baseUrl = new URL(options.basePath, options.url.origin);\n    const sendRequest = provider.sendVerificationRequest({\n        identifier: email,\n        token,\n        expires,\n        url: `${baseUrl}/callback/${provider.id}?${new URLSearchParams({\n            callbackUrl,\n            token,\n            email,\n        })}`,\n        provider,\n        theme,\n        request: (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.toRequest)(request),\n    });\n    const createToken = adapter.createVerificationToken?.({\n        identifier: email,\n        token: await (0,_utils_web_js__WEBPACK_IMPORTED_MODULE_0__.createHash)(`${token}${secret}`),\n        expires,\n    });\n    await Promise.all([sendRequest, createToken]);\n    return {\n        redirect: `${baseUrl}/verify-request?${new URLSearchParams({\n            provider: provider.id,\n            type: provider.type,\n        })}`,\n    };\n}\nfunction defaultNormalizer(email) {\n    if (!email)\n        throw new Error(\"Missing email from request body.\");\n    // Get the first two elements only,\n    // separated by `@` from user input.\n    let [local, domain] = email.toLowerCase().trim().split(\"@\");\n    // The part before \"@\" can contain a \",\"\n    // but we remove it on the domain part\n    domain = domain.split(\",\")[0];\n    return `${local}@${domain}`;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/signin/send-token.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/signout.js":
/*!********************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/signout.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   signOut: () => (/* binding */ signOut)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\n/**\n * Destroys the session.\n * If the session strategy is database,\n * The session is also deleted from the database.\n * In any case, the session cookie is cleared and\n * {@link AuthConfig[\"events\"].signOut} is emitted.\n */\nasync function signOut(cookies, sessionStore, options) {\n    const { jwt, events, callbackUrl: redirect, logger, session } = options;\n    const sessionToken = sessionStore.value;\n    if (!sessionToken)\n        return { redirect, cookies };\n    try {\n        if (session.strategy === \"jwt\") {\n            const salt = options.cookies.sessionToken.name;\n            const token = await jwt.decode({ ...jwt, token: sessionToken, salt });\n            await events.signOut?.({ token });\n        }\n        else {\n            const session = await options.adapter?.deleteSession(sessionToken);\n            await events.signOut?.({ session });\n        }\n    }\n    catch (e) {\n        logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_0__.SignOutError(e));\n    }\n    cookies.push(...sessionStore.clean());\n    return { redirect, cookies };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/signout.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/actions/webauthn-options.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@auth/core/lib/actions/webauthn-options.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   webAuthnOptions: () => (/* binding */ webAuthnOptions)\n/* harmony export */ });\n/* harmony import */ var _utils_session_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/session.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/session.js\");\n/* harmony import */ var _utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/webauthn-utils.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/webauthn-utils.js\");\n\n\n/**\n * Returns authentication or registration options for a WebAuthn flow\n * depending on the parameters provided.\n */\nasync function webAuthnOptions(request, options, sessionStore, cookies\n// @ts-expect-error issue with returning from a switch case\n) {\n    // Return an error if the adapter is missing or if the provider\n    // is not a webauthn provider.\n    const narrowOptions = (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_1__.assertInternalOptionsWebAuthn)(options);\n    const { provider } = narrowOptions;\n    // Extract the action from the query parameters\n    const { action } = (request.query ?? {});\n    // Action must be either \"register\", \"authenticate\", or undefined\n    if (action !== \"register\" &&\n        action !== \"authenticate\" &&\n        typeof action !== \"undefined\") {\n        return {\n            status: 400,\n            body: { error: \"Invalid action\" },\n            cookies,\n            headers: {\n                \"Content-Type\": \"application/json\",\n            },\n        };\n    }\n    // Get the user info from the session\n    const sessionUser = await (0,_utils_session_js__WEBPACK_IMPORTED_MODULE_0__.getLoggedInUser)(options, sessionStore);\n    // Extract user info from request\n    // If session user exists, we don't need to call getUserInfo\n    const getUserInfoResponse = sessionUser\n        ? {\n            user: sessionUser,\n            exists: true,\n        }\n        : await provider.getUserInfo(options, request);\n    const userInfo = getUserInfoResponse?.user;\n    // Make a decision on what kind of webauthn options to return\n    const decision = (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_1__.inferWebAuthnOptions)(action, !!sessionUser, getUserInfoResponse);\n    switch (decision) {\n        case \"authenticate\":\n            return (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_1__.getAuthenticationResponse)(narrowOptions, request, userInfo, cookies);\n        case \"register\":\n            if (typeof userInfo?.email === \"string\") {\n                return (0,_utils_webauthn_utils_js__WEBPACK_IMPORTED_MODULE_1__.getRegistrationResponse)(narrowOptions, request, userInfo, cookies);\n            }\n            break;\n        default:\n            return {\n                status: 400,\n                body: { error: \"Invalid request\" },\n                cookies,\n                headers: {\n                    \"Content-Type\": \"application/json\",\n                },\n            };\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/actions/webauthn-options.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/index.js":
/*!**********************************************!*\
  !*** ./node_modules/@auth/core/lib/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AuthInternal: () => (/* binding */ AuthInternal),\n/* harmony export */   customFetch: () => (/* reexport safe */ _symbols_js__WEBPACK_IMPORTED_MODULE_6__.customFetch),\n/* harmony export */   raw: () => (/* reexport safe */ _symbols_js__WEBPACK_IMPORTED_MODULE_6__.raw),\n/* harmony export */   skipCSRFCheck: () => (/* reexport safe */ _symbols_js__WEBPACK_IMPORTED_MODULE_6__.skipCSRFCheck)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _utils_cookie_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/cookie.js\");\n/* harmony import */ var _init_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./init.js */ \"(rsc)/./node_modules/@auth/core/lib/init.js\");\n/* harmony import */ var _pages_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pages/index.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/index.js\");\n/* harmony import */ var _actions_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./actions/index.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/index.js\");\n/* harmony import */ var _actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./actions/callback/oauth/csrf-token.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/csrf-token.js\");\n/* harmony import */ var _symbols_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./symbols.js */ \"(rsc)/./node_modules/@auth/core/lib/symbols.js\");\n\n\n\n\n\n\n\n\n/** @internal */\nasync function AuthInternal(request, authOptions) {\n    const { action, providerId, error, method } = request;\n    const csrfDisabled = authOptions.skipCSRFCheck === _symbols_js__WEBPACK_IMPORTED_MODULE_6__.skipCSRFCheck;\n    const { options, cookies } = await (0,_init_js__WEBPACK_IMPORTED_MODULE_2__.init)({\n        authOptions,\n        action,\n        providerId,\n        url: request.url,\n        callbackUrl: request.body?.callbackUrl ?? request.query?.callbackUrl,\n        csrfToken: request.body?.csrfToken,\n        cookies: request.cookies,\n        isPost: method === \"POST\",\n        csrfDisabled,\n    });\n    const sessionStore = new _utils_cookie_js__WEBPACK_IMPORTED_MODULE_1__.SessionStore(options.cookies.sessionToken, request.cookies, options.logger);\n    if (method === \"GET\") {\n        const render = (0,_pages_index_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])({ ...options, query: request.query, cookies });\n        switch (action) {\n            case \"callback\":\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.callback(request, options, sessionStore, cookies);\n            case \"csrf\":\n                return render.csrf(csrfDisabled, options, cookies);\n            case \"error\":\n                return render.error(error);\n            case \"providers\":\n                return render.providers(options.providers);\n            case \"session\":\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.session(options, sessionStore, cookies);\n            case \"signin\":\n                return render.signin(providerId, error);\n            case \"signout\":\n                return render.signout();\n            case \"verify-request\":\n                return render.verifyRequest();\n            case \"webauthn-options\":\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.webAuthnOptions(request, options, sessionStore, cookies);\n            default:\n        }\n    }\n    else {\n        const { csrfTokenVerified } = options;\n        switch (action) {\n            case \"callback\":\n                if (options.provider.type === \"credentials\")\n                    // Verified CSRF Token required for credentials providers only\n                    (0,_actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_5__.validateCSRF)(action, csrfTokenVerified);\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.callback(request, options, sessionStore, cookies);\n            case \"session\":\n                (0,_actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_5__.validateCSRF)(action, csrfTokenVerified);\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.session(options, sessionStore, cookies, true, request.body?.data);\n            case \"signin\":\n                (0,_actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_5__.validateCSRF)(action, csrfTokenVerified);\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.signIn(request, cookies, options);\n            case \"signout\":\n                (0,_actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_5__.validateCSRF)(action, csrfTokenVerified);\n                return await _actions_index_js__WEBPACK_IMPORTED_MODULE_4__.signOut(cookies, sessionStore, options);\n            default:\n        }\n    }\n    throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.UnknownAction(`Cannot handle action: ${action}`);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/init.js":
/*!*********************************************!*\
  !*** ./node_modules/@auth/core/lib/init.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   defaultCallbacks: () => (/* binding */ defaultCallbacks),\n/* harmony export */   init: () => (/* binding */ init)\n/* harmony export */ });\n/* harmony import */ var _jwt_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../jwt.js */ \"(rsc)/./node_modules/@auth/core/jwt.js\");\n/* harmony import */ var _utils_callback_url_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/callback-url.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/callback-url.js\");\n/* harmony import */ var _utils_cookie_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/cookie.js\");\n/* harmony import */ var _actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./actions/callback/oauth/csrf-token.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/csrf-token.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _utils_providers_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/providers.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/providers.js\");\n/* harmony import */ var _utils_logger_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/logger.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/logger.js\");\n/* harmony import */ var _utils_merge_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/merge.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/merge.js\");\n\n\n\n\n\n\n\n\nconst defaultCallbacks = {\n    signIn() {\n        return true;\n    },\n    redirect({ url, baseUrl }) {\n        if (url.startsWith(\"/\"))\n            return `${baseUrl}${url}`;\n        else if (new URL(url).origin === baseUrl)\n            return url;\n        return baseUrl;\n    },\n    session({ session }) {\n        return {\n            user: {\n                name: session.user?.name,\n                email: session.user?.email,\n                image: session.user?.image,\n            },\n            expires: session.expires?.toISOString?.() ?? session.expires,\n        };\n    },\n    jwt({ token }) {\n        return token;\n    },\n};\n/** Initialize all internal options and cookies. */\nasync function init({ authOptions: config, providerId, action, url, cookies: reqCookies, callbackUrl: reqCallbackUrl, csrfToken: reqCsrfToken, csrfDisabled, isPost, }) {\n    const logger = (0,_utils_logger_js__WEBPACK_IMPORTED_MODULE_6__.setLogger)(config);\n    const { providers, provider } = (0,_utils_providers_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])({ url, providerId, config });\n    const maxAge = 30 * 24 * 60 * 60; // Sessions expire after 30 days of being idle by default\n    let isOnRedirectProxy = false;\n    if ((provider?.type === \"oauth\" || provider?.type === \"oidc\") &&\n        provider.redirectProxyUrl) {\n        try {\n            isOnRedirectProxy =\n                new URL(provider.redirectProxyUrl).origin === url.origin;\n        }\n        catch {\n            throw new TypeError(`redirectProxyUrl must be a valid URL. Received: ${provider.redirectProxyUrl}`);\n        }\n    }\n    // User provided options are overridden by other options,\n    // except for the options with special handling above\n    const options = {\n        debug: false,\n        pages: {},\n        theme: {\n            colorScheme: \"auto\",\n            logo: \"\",\n            brandColor: \"\",\n            buttonText: \"\",\n        },\n        // Custom options override defaults\n        ...config,\n        // These computed settings can have values in userOptions but we override them\n        // and are request-specific.\n        url,\n        action,\n        // @ts-expect-errors\n        provider,\n        cookies: (0,_utils_merge_js__WEBPACK_IMPORTED_MODULE_7__.merge)(_utils_cookie_js__WEBPACK_IMPORTED_MODULE_2__.defaultCookies(config.useSecureCookies ?? url.protocol === \"https:\"), config.cookies),\n        providers,\n        // Session options\n        session: {\n            // If no adapter specified, force use of JSON Web Tokens (stateless)\n            strategy: config.adapter ? \"database\" : \"jwt\",\n            maxAge,\n            updateAge: 24 * 60 * 60,\n            generateSessionToken: () => crypto.randomUUID(),\n            ...config.session,\n        },\n        // JWT options\n        jwt: {\n            secret: config.secret, // Asserted in assert.ts\n            maxAge: config.session?.maxAge ?? maxAge, // default to same as `session.maxAge`\n            encode: _jwt_js__WEBPACK_IMPORTED_MODULE_0__.encode,\n            decode: _jwt_js__WEBPACK_IMPORTED_MODULE_0__.decode,\n            ...config.jwt,\n        },\n        // Event messages\n        events: eventsErrorHandler(config.events ?? {}, logger),\n        adapter: adapterErrorHandler(config.adapter, logger),\n        // Callback functions\n        callbacks: { ...defaultCallbacks, ...config.callbacks },\n        logger,\n        callbackUrl: url.origin,\n        isOnRedirectProxy,\n        experimental: {\n            ...config.experimental,\n        },\n    };\n    // Init cookies\n    const cookies = [];\n    if (csrfDisabled) {\n        options.csrfTokenVerified = true;\n    }\n    else {\n        const { csrfToken, cookie: csrfCookie, csrfTokenVerified, } = await (0,_actions_callback_oauth_csrf_token_js__WEBPACK_IMPORTED_MODULE_3__.createCSRFToken)({\n            options,\n            cookieValue: reqCookies?.[options.cookies.csrfToken.name],\n            isPost,\n            bodyValue: reqCsrfToken,\n        });\n        options.csrfToken = csrfToken;\n        options.csrfTokenVerified = csrfTokenVerified;\n        if (csrfCookie) {\n            cookies.push({\n                name: options.cookies.csrfToken.name,\n                value: csrfCookie,\n                options: options.cookies.csrfToken.options,\n            });\n        }\n    }\n    const { callbackUrl, callbackUrlCookie } = await (0,_utils_callback_url_js__WEBPACK_IMPORTED_MODULE_1__.createCallbackUrl)({\n        options,\n        cookieValue: reqCookies?.[options.cookies.callbackUrl.name],\n        paramValue: reqCallbackUrl,\n    });\n    options.callbackUrl = callbackUrl;\n    if (callbackUrlCookie) {\n        cookies.push({\n            name: options.cookies.callbackUrl.name,\n            value: callbackUrlCookie,\n            options: options.cookies.callbackUrl.options,\n        });\n    }\n    return { options, cookies };\n}\n/** Wraps an object of methods and adds error handling. */\nfunction eventsErrorHandler(methods, logger) {\n    return Object.keys(methods).reduce((acc, name) => {\n        acc[name] = async (...args) => {\n            try {\n                const method = methods[name];\n                return await method(...args);\n            }\n            catch (e) {\n                logger.error(new _errors_js__WEBPACK_IMPORTED_MODULE_4__.EventError(e));\n            }\n        };\n        return acc;\n    }, {});\n}\n/** Handles adapter induced errors. */\nfunction adapterErrorHandler(adapter, logger) {\n    if (!adapter)\n        return;\n    return Object.keys(adapter).reduce((acc, name) => {\n        acc[name] = async (...args) => {\n            try {\n                logger.debug(`adapter_${name}`, { args });\n                const method = adapter[name];\n                return await method(...args);\n            }\n            catch (e) {\n                const error = new _errors_js__WEBPACK_IMPORTED_MODULE_4__.AdapterError(e);\n                logger.error(error);\n                throw error;\n            }\n        };\n        return acc;\n    }, {});\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/init.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/error.js":
/*!****************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/error.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ErrorPage)\n/* harmony export */ });\n/* harmony import */ var preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! preact/jsx-runtime */ \"(rsc)/./node_modules/preact/jsx-runtime/dist/jsxRuntime.mjs\");\n\n/** Renders an error page. */\nfunction ErrorPage(props) {\n    const { url, error = \"default\", theme } = props;\n    const signinPageUrl = `${url}/signin`;\n    const errors = {\n        default: {\n            status: 200,\n            heading: \"Error\",\n            message: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"site\", href: url?.origin, children: url?.host }) })),\n        },\n        Configuration: {\n            status: 500,\n            heading: \"Server error\",\n            message: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"There is a problem with the server configuration.\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"Check the server logs for more information.\" })] })),\n        },\n        AccessDenied: {\n            status: 403,\n            heading: \"Access Denied\",\n            message: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"You do not have permission to sign in.\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"button\", href: signinPageUrl, children: \"Sign in\" }) })] })),\n        },\n        Verification: {\n            status: 403,\n            heading: \"Unable to sign in\",\n            message: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"The sign in link is no longer valid.\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"It may have been used already or it may have expired.\" })] })),\n            signin: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"button\", href: signinPageUrl, children: \"Sign in\" })),\n        },\n    };\n    const { status, heading, message, signin } = errors[error] ?? errors.default;\n    return {\n        status,\n        html: ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"error\", children: [theme?.brandColor && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                        __html: `\n        :root {\n          --brand-color: ${theme?.brandColor}\n        }\n      `,\n                    } })), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"card\", children: [theme?.logo && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { src: theme?.logo, alt: \"Logo\", className: \"logo\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"h1\", { children: heading }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"message\", children: message }), signin] })] })),\n    };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvcGFnZXMvZXJyb3IuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBZ0U7QUFDaEU7QUFDZTtBQUNmLFlBQVksZ0NBQWdDO0FBQzVDLDZCQUE2QixJQUFJO0FBQ2pDO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLHVEQUFJLFFBQVEsVUFBVSx1REFBSSxRQUFRLDJEQUEyRCxHQUFHO0FBQ3RILFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQSxzQkFBc0Isd0RBQUssVUFBVSxXQUFXLHVEQUFJLFFBQVEsK0RBQStELEdBQUcsdURBQUksUUFBUSx5REFBeUQsSUFBSTtBQUN2TSxTQUFTO0FBQ1Q7QUFDQTtBQUNBO0FBQ0Esc0JBQXNCLHdEQUFLLFVBQVUsV0FBVyx1REFBSSxRQUFRLG9EQUFvRCxHQUFHLHVEQUFJLFFBQVEsVUFBVSx1REFBSSxRQUFRLCtEQUErRCxHQUFHLElBQUk7QUFDM04sU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBLHNCQUFzQix3REFBSyxVQUFVLFdBQVcsdURBQUksUUFBUSxrREFBa0QsR0FBRyx1REFBSSxRQUFRLG1FQUFtRSxJQUFJO0FBQ3BNLHFCQUFxQix1REFBSSxRQUFRLCtEQUErRDtBQUNoRyxTQUFTO0FBQ1Q7QUFDQSxZQUFZLG1DQUFtQztBQUMvQztBQUNBO0FBQ0EsZUFBZSx3REFBSyxVQUFVLHFEQUFxRCx1REFBSSxZQUFZO0FBQ25HO0FBQ0E7QUFDQSwyQkFBMkI7QUFDM0I7QUFDQTtBQUNBLHVCQUF1QixJQUFJLHdEQUFLLFVBQVUsNkNBQTZDLHVEQUFJLFVBQVUsa0RBQWtELEdBQUcsdURBQUksU0FBUyxtQkFBbUIsR0FBRyx1REFBSSxVQUFVLHlDQUF5QyxZQUFZLElBQUk7QUFDcFE7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvcml6dmkvcHJvamVjdHMvYXVkaXQtbmV4dC9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvcGFnZXMvZXJyb3IuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsganN4IGFzIF9qc3gsIGpzeHMgYXMgX2pzeHMgfSBmcm9tIFwicHJlYWN0L2pzeC1ydW50aW1lXCI7XG4vKiogUmVuZGVycyBhbiBlcnJvciBwYWdlLiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gRXJyb3JQYWdlKHByb3BzKSB7XG4gICAgY29uc3QgeyB1cmwsIGVycm9yID0gXCJkZWZhdWx0XCIsIHRoZW1lIH0gPSBwcm9wcztcbiAgICBjb25zdCBzaWduaW5QYWdlVXJsID0gYCR7dXJsfS9zaWduaW5gO1xuICAgIGNvbnN0IGVycm9ycyA9IHtcbiAgICAgICAgZGVmYXVsdDoge1xuICAgICAgICAgICAgc3RhdHVzOiAyMDAsXG4gICAgICAgICAgICBoZWFkaW5nOiBcIkVycm9yXCIsXG4gICAgICAgICAgICBtZXNzYWdlOiAoX2pzeChcInBcIiwgeyBjaGlsZHJlbjogX2pzeChcImFcIiwgeyBjbGFzc05hbWU6IFwic2l0ZVwiLCBocmVmOiB1cmw/Lm9yaWdpbiwgY2hpbGRyZW46IHVybD8uaG9zdCB9KSB9KSksXG4gICAgICAgIH0sXG4gICAgICAgIENvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICAgIHN0YXR1czogNTAwLFxuICAgICAgICAgICAgaGVhZGluZzogXCJTZXJ2ZXIgZXJyb3JcIixcbiAgICAgICAgICAgIG1lc3NhZ2U6IChfanN4cyhcImRpdlwiLCB7IGNoaWxkcmVuOiBbX2pzeChcInBcIiwgeyBjaGlsZHJlbjogXCJUaGVyZSBpcyBhIHByb2JsZW0gd2l0aCB0aGUgc2VydmVyIGNvbmZpZ3VyYXRpb24uXCIgfSksIF9qc3goXCJwXCIsIHsgY2hpbGRyZW46IFwiQ2hlY2sgdGhlIHNlcnZlciBsb2dzIGZvciBtb3JlIGluZm9ybWF0aW9uLlwiIH0pXSB9KSksXG4gICAgICAgIH0sXG4gICAgICAgIEFjY2Vzc0RlbmllZDoge1xuICAgICAgICAgICAgc3RhdHVzOiA0MDMsXG4gICAgICAgICAgICBoZWFkaW5nOiBcIkFjY2VzcyBEZW5pZWRcIixcbiAgICAgICAgICAgIG1lc3NhZ2U6IChfanN4cyhcImRpdlwiLCB7IGNoaWxkcmVuOiBbX2pzeChcInBcIiwgeyBjaGlsZHJlbjogXCJZb3UgZG8gbm90IGhhdmUgcGVybWlzc2lvbiB0byBzaWduIGluLlwiIH0pLCBfanN4KFwicFwiLCB7IGNoaWxkcmVuOiBfanN4KFwiYVwiLCB7IGNsYXNzTmFtZTogXCJidXR0b25cIiwgaHJlZjogc2lnbmluUGFnZVVybCwgY2hpbGRyZW46IFwiU2lnbiBpblwiIH0pIH0pXSB9KSksXG4gICAgICAgIH0sXG4gICAgICAgIFZlcmlmaWNhdGlvbjoge1xuICAgICAgICAgICAgc3RhdHVzOiA0MDMsXG4gICAgICAgICAgICBoZWFkaW5nOiBcIlVuYWJsZSB0byBzaWduIGluXCIsXG4gICAgICAgICAgICBtZXNzYWdlOiAoX2pzeHMoXCJkaXZcIiwgeyBjaGlsZHJlbjogW19qc3goXCJwXCIsIHsgY2hpbGRyZW46IFwiVGhlIHNpZ24gaW4gbGluayBpcyBubyBsb25nZXIgdmFsaWQuXCIgfSksIF9qc3goXCJwXCIsIHsgY2hpbGRyZW46IFwiSXQgbWF5IGhhdmUgYmVlbiB1c2VkIGFscmVhZHkgb3IgaXQgbWF5IGhhdmUgZXhwaXJlZC5cIiB9KV0gfSkpLFxuICAgICAgICAgICAgc2lnbmluOiAoX2pzeChcImFcIiwgeyBjbGFzc05hbWU6IFwiYnV0dG9uXCIsIGhyZWY6IHNpZ25pblBhZ2VVcmwsIGNoaWxkcmVuOiBcIlNpZ24gaW5cIiB9KSksXG4gICAgICAgIH0sXG4gICAgfTtcbiAgICBjb25zdCB7IHN0YXR1cywgaGVhZGluZywgbWVzc2FnZSwgc2lnbmluIH0gPSBlcnJvcnNbZXJyb3JdID8/IGVycm9ycy5kZWZhdWx0O1xuICAgIHJldHVybiB7XG4gICAgICAgIHN0YXR1cyxcbiAgICAgICAgaHRtbDogKF9qc3hzKFwiZGl2XCIsIHsgY2xhc3NOYW1lOiBcImVycm9yXCIsIGNoaWxkcmVuOiBbdGhlbWU/LmJyYW5kQ29sb3IgJiYgKF9qc3goXCJzdHlsZVwiLCB7IGRhbmdlcm91c2x5U2V0SW5uZXJIVE1MOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBfX2h0bWw6IGBcbiAgICAgICAgOnJvb3Qge1xuICAgICAgICAgIC0tYnJhbmQtY29sb3I6ICR7dGhlbWU/LmJyYW5kQ29sb3J9XG4gICAgICAgIH1cbiAgICAgIGAsXG4gICAgICAgICAgICAgICAgICAgIH0gfSkpLCBfanN4cyhcImRpdlwiLCB7IGNsYXNzTmFtZTogXCJjYXJkXCIsIGNoaWxkcmVuOiBbdGhlbWU/LmxvZ28gJiYgX2pzeChcImltZ1wiLCB7IHNyYzogdGhlbWU/LmxvZ28sIGFsdDogXCJMb2dvXCIsIGNsYXNzTmFtZTogXCJsb2dvXCIgfSksIF9qc3goXCJoMVwiLCB7IGNoaWxkcmVuOiBoZWFkaW5nIH0pLCBfanN4KFwiZGl2XCIsIHsgY2xhc3NOYW1lOiBcIm1lc3NhZ2VcIiwgY2hpbGRyZW46IG1lc3NhZ2UgfSksIHNpZ25pbl0gfSldIH0pKSxcbiAgICB9O1xufVxuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/error.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ renderPage)\n/* harmony export */ });\n/* harmony import */ var preact_render_to_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! preact-render-to-string */ \"(rsc)/./node_modules/preact-render-to-string/dist/index.mjs\");\n/* harmony import */ var _error_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./error.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/error.js\");\n/* harmony import */ var _signin_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./signin.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/signin.js\");\n/* harmony import */ var _signout_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./signout.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/signout.js\");\n/* harmony import */ var _styles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/styles.js\");\n/* harmony import */ var _verify_request_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./verify-request.js */ \"(rsc)/./node_modules/@auth/core/lib/pages/verify-request.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\n\n\n\n\n\n\nfunction send({ html, title, status, cookies, theme, headTags, }) {\n    return {\n        cookies,\n        status,\n        headers: { \"Content-Type\": \"text/html\" },\n        body: `<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"><style>${_styles_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]}</style><title>${title}</title>${headTags ?? \"\"}</head><body class=\"__next-auth-theme-${theme?.colorScheme ?? \"auto\"}\"><div class=\"page\">${(0,preact_render_to_string__WEBPACK_IMPORTED_MODULE_0__.renderToString)(html)}</div></body></html>`,\n    };\n}\n/**\n * Unless the user defines their [own pages](https://authjs.dev/reference/core#pages),\n * we render a set of default ones, using Preact SSR.\n */\nfunction renderPage(params) {\n    const { url, theme, query, cookies, pages, providers } = params;\n    return {\n        csrf(skip, options, cookies) {\n            if (!skip) {\n                return {\n                    headers: {\n                        \"Content-Type\": \"application/json\",\n                        \"Cache-Control\": \"private, no-cache, no-store\",\n                        Expires: \"0\",\n                        Pragma: \"no-cache\",\n                    },\n                    body: { csrfToken: options.csrfToken },\n                    cookies,\n                };\n            }\n            options.logger.warn(\"csrf-disabled\");\n            cookies.push({\n                name: options.cookies.csrfToken.name,\n                value: \"\",\n                options: { ...options.cookies.csrfToken.options, maxAge: 0 },\n            });\n            return { status: 404, cookies };\n        },\n        providers(providers) {\n            return {\n                headers: { \"Content-Type\": \"application/json\" },\n                body: providers.reduce((acc, { id, name, type, signinUrl, callbackUrl }) => {\n                    acc[id] = { id, name, type, signinUrl, callbackUrl };\n                    return acc;\n                }, {}),\n            };\n        },\n        signin(providerId, error) {\n            if (providerId)\n                throw new _errors_js__WEBPACK_IMPORTED_MODULE_6__.UnknownAction(\"Unsupported action\");\n            if (pages?.signIn) {\n                let signinUrl = `${pages.signIn}${pages.signIn.includes(\"?\") ? \"&\" : \"?\"}${new URLSearchParams({ callbackUrl: params.callbackUrl ?? \"/\" })}`;\n                if (error)\n                    signinUrl = `${signinUrl}&${new URLSearchParams({ error })}`;\n                return { redirect: signinUrl, cookies };\n            }\n            // If we have a webauthn provider with conditional UI and\n            // a simpleWebAuthnBrowserScript is defined, we need to\n            // render the script in the page.\n            const webauthnProvider = providers?.find((p) => p.type === \"webauthn\" &&\n                p.enableConditionalUI &&\n                !!p.simpleWebAuthnBrowserVersion);\n            let simpleWebAuthnBrowserScript = \"\";\n            if (webauthnProvider) {\n                const { simpleWebAuthnBrowserVersion } = webauthnProvider;\n                simpleWebAuthnBrowserScript = `<script src=\"https://unpkg.com/@simplewebauthn/browser@${simpleWebAuthnBrowserVersion}/dist/bundle/index.umd.min.js\" crossorigin=\"anonymous\"></script>`;\n            }\n            return send({\n                cookies,\n                theme,\n                html: (0,_signin_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])({\n                    csrfToken: params.csrfToken,\n                    // We only want to render providers\n                    providers: params.providers?.filter((provider) => \n                    // Always render oauth and email type providers\n                    [\"email\", \"oauth\", \"oidc\"].includes(provider.type) ||\n                        // Only render credentials type provider if credentials are defined\n                        (provider.type === \"credentials\" && provider.credentials) ||\n                        // Only render webauthn type provider if formFields are defined\n                        (provider.type === \"webauthn\" && provider.formFields) ||\n                        // Don't render other provider types\n                        false),\n                    callbackUrl: params.callbackUrl,\n                    theme: params.theme,\n                    error,\n                    ...query,\n                }),\n                title: \"Sign In\",\n                headTags: simpleWebAuthnBrowserScript,\n            });\n        },\n        signout() {\n            if (pages?.signOut)\n                return { redirect: pages.signOut, cookies };\n            return send({\n                cookies,\n                theme,\n                html: (0,_signout_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])({ csrfToken: params.csrfToken, url, theme }),\n                title: \"Sign Out\",\n            });\n        },\n        verifyRequest(props) {\n            if (pages?.verifyRequest)\n                return {\n                    redirect: `${pages.verifyRequest}${url?.search ?? \"\"}`,\n                    cookies,\n                };\n            return send({\n                cookies,\n                theme,\n                html: (0,_verify_request_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"])({ url, theme, ...props }),\n                title: \"Verify Request\",\n            });\n        },\n        error(error) {\n            if (pages?.error) {\n                return {\n                    redirect: `${pages.error}${pages.error.includes(\"?\") ? \"&\" : \"?\"}error=${error}`,\n                    cookies,\n                };\n            }\n            return send({\n                cookies,\n                theme,\n                // @ts-expect-error fix error type\n                ...(0,_error_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])({ url, theme, error }),\n                title: \"Error\",\n            });\n        },\n    };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/index.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/signin.js":
/*!*****************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/signin.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ SigninPage)\n/* harmony export */ });\n/* harmony import */ var preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! preact/jsx-runtime */ \"(rsc)/./node_modules/preact/jsx-runtime/dist/jsxRuntime.mjs\");\n/* harmony import */ var _utils_webauthn_client_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/webauthn-client.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/webauthn-client.js\");\n\n\nconst signinErrors = {\n    default: \"Unable to sign in.\",\n    Signin: \"Try signing in with a different account.\",\n    OAuthSignin: \"Try signing in with a different account.\",\n    OAuthCallbackError: \"Try signing in with a different account.\",\n    OAuthCreateAccount: \"Try signing in with a different account.\",\n    EmailCreateAccount: \"Try signing in with a different account.\",\n    Callback: \"Try signing in with a different account.\",\n    OAuthAccountNotLinked: \"To confirm your identity, sign in with the same account you used originally.\",\n    EmailSignin: \"The e-mail could not be sent.\",\n    CredentialsSignin: \"Sign in failed. Check the details you provided are correct.\",\n    SessionRequired: \"Please sign in to access this page.\",\n};\nfunction ConditionalUIScript(providerID) {\n    const startConditionalUIScript = `\nconst currentURL = window.location.href;\nconst authURL = currentURL.substring(0, currentURL.lastIndexOf('/'));\n(${_utils_webauthn_client_js__WEBPACK_IMPORTED_MODULE_1__.webauthnScript})(authURL, \"${providerID}\");\n`;\n    return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"script\", { dangerouslySetInnerHTML: { __html: startConditionalUIScript } }) }));\n}\nfunction SigninPage(props) {\n    const { csrfToken, providers = [], callbackUrl, theme, email, error: errorType, } = props;\n    if (typeof document !== \"undefined\" && theme?.brandColor) {\n        document.documentElement.style.setProperty(\"--brand-color\", theme.brandColor);\n    }\n    if (typeof document !== \"undefined\" && theme?.buttonText) {\n        document.documentElement.style.setProperty(\"--button-text-color\", theme.buttonText);\n    }\n    const error = errorType && (signinErrors[errorType] ?? signinErrors.default);\n    const providerLogoPath = \"https://authjs.dev/img/providers\";\n    const conditionalUIProviderID = providers.find((provider) => provider.type === \"webauthn\" && provider.enableConditionalUI)?.id;\n    return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"signin\", children: [theme?.brandColor && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                    __html: `:root {--brand-color: ${theme.brandColor}}`,\n                } })), theme?.buttonText && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                    __html: `\n        :root {\n          --button-text-color: ${theme.buttonText}\n        }\n      `,\n                } })), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"card\", children: [error && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"div\", { className: \"error\", children: (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: error }) })), theme?.logo && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { src: theme.logo, alt: \"Logo\", className: \"logo\" }), providers.map((provider, i) => {\n                        let bg, brandColor, logo;\n                        if (provider.type === \"oauth\" || provider.type === \"oidc\") {\n                            ;\n                            ({\n                                bg = \"#fff\",\n                                brandColor,\n                                logo = `${providerLogoPath}/${provider.id}.svg`,\n                            } = provider.style ?? {});\n                        }\n                        const color = brandColor ?? bg ?? \"#fff\";\n                        return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"provider\", children: [provider.type === \"oauth\" || provider.type === \"oidc\" ? ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"form\", { action: provider.signinUrl, method: \"POST\", children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"csrfToken\", value: csrfToken }), callbackUrl && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"callbackUrl\", value: callbackUrl })), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"button\", { type: \"submit\", className: \"button\", style: {\n                                                \"--provider-brand-color\": color,\n                                            }, tabIndex: 0, children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"span\", { style: {\n                                                        filter: \"invert(1) grayscale(1) brightness(1.3) contrast(9000)\",\n                                                        \"mix-blend-mode\": \"luminosity\",\n                                                        opacity: 0.95,\n                                                    }, children: [\"Sign in with \", provider.name] }), logo && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { loading: \"lazy\", height: 24, src: logo })] })] })) : null, (provider.type === \"email\" ||\n                                    provider.type === \"credentials\" ||\n                                    provider.type === \"webauthn\") &&\n                                    i > 0 &&\n                                    providers[i - 1].type !== \"email\" &&\n                                    providers[i - 1].type !== \"credentials\" &&\n                                    providers[i - 1].type !== \"webauthn\" && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"hr\", {}), provider.type === \"email\" && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"form\", { action: provider.signinUrl, method: \"POST\", children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"csrfToken\", value: csrfToken }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"label\", { className: \"section-header\", htmlFor: `input-email-for-${provider.id}-provider`, children: \"Email\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { id: `input-email-for-${provider.id}-provider`, autoFocus: true, type: \"email\", name: \"email\", value: email, placeholder: \"email@example.com\", required: true }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"button\", { id: \"submitButton\", type: \"submit\", tabIndex: 0, children: [\"Sign in with \", provider.name] })] })), provider.type === \"credentials\" && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"form\", { action: provider.callbackUrl, method: \"POST\", children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"csrfToken\", value: csrfToken }), Object.keys(provider.credentials).map((credential) => {\n                                            return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"label\", { className: \"section-header\", htmlFor: `input-${credential}-for-${provider.id}-provider`, children: provider.credentials[credential].label ?? credential }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { name: credential, id: `input-${credential}-for-${provider.id}-provider`, type: provider.credentials[credential].type ?? \"text\", placeholder: provider.credentials[credential].placeholder ?? \"\", ...provider.credentials[credential] })] }, `input-group-${provider.id}`));\n                                        }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"button\", { id: \"submitButton\", type: \"submit\", tabIndex: 0, children: [\"Sign in with \", provider.name] })] })), provider.type === \"webauthn\" && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"form\", { action: provider.callbackUrl, method: \"POST\", id: `${provider.id}-form`, children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"csrfToken\", value: csrfToken }), Object.keys(provider.formFields).map((field) => {\n                                            return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"label\", { className: \"section-header\", htmlFor: `input-${field}-for-${provider.id}-provider`, children: provider.formFields[field].label ?? field }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { name: field, \"data-form-field\": true, id: `input-${field}-for-${provider.id}-provider`, type: provider.formFields[field].type ?? \"text\", placeholder: provider.formFields[field].placeholder ?? \"\", ...provider.formFields[field] })] }, `input-group-${provider.id}`));\n                                        }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"button\", { id: `submitButton-${provider.id}`, type: \"submit\", tabIndex: 0, children: [\"Sign in with \", provider.name] })] })), (provider.type === \"email\" ||\n                                    provider.type === \"credentials\" ||\n                                    provider.type === \"webauthn\") &&\n                                    i + 1 < providers.length && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"hr\", {})] }, provider.id));\n                    })] }), conditionalUIProviderID && ConditionalUIScript(conditionalUIProviderID)] }));\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvcGFnZXMvc2lnbmluLmpzIiwibWFwcGluZ3MiOiI7Ozs7OztBQUF1RjtBQUMxQjtBQUM3RDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsR0FBRyxxRUFBYyxDQUFDLGNBQWMsV0FBVztBQUMzQztBQUNBLFlBQVksdURBQUksQ0FBQyx3REFBUyxJQUFJLFVBQVUsdURBQUksYUFBYSwyQkFBMkIsb0NBQW9DLEdBQUc7QUFDM0g7QUFDZTtBQUNmLFlBQVksMEVBQTBFO0FBQ3RGO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFlBQVksd0RBQUssVUFBVSxzREFBc0QsdURBQUksWUFBWTtBQUNqRyxvQ0FBb0MsaUJBQWlCLGtCQUFrQjtBQUN2RSxtQkFBbUIsMEJBQTBCLHVEQUFJLFlBQVk7QUFDN0Q7QUFDQTtBQUNBLGlDQUFpQztBQUNqQztBQUNBO0FBQ0EsbUJBQW1CLElBQUksd0RBQUssVUFBVSx3Q0FBd0MsdURBQUksVUFBVSw4QkFBOEIsdURBQUksUUFBUSxpQkFBaUIsR0FBRyxtQkFBbUIsdURBQUksVUFBVSxpREFBaUQ7QUFDNU87QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsMENBQTBDLGlCQUFpQixHQUFHLFlBQVk7QUFDMUUsOEJBQThCLHNCQUFzQjtBQUNwRDtBQUNBO0FBQ0EsZ0NBQWdDLHdEQUFLLFVBQVUsMkZBQTJGLHdEQUFLLFdBQVcsdURBQXVELHVEQUFJLFlBQVkscURBQXFELG1CQUFtQix1REFBSSxZQUFZLHlEQUF5RCxJQUFJLHdEQUFLLGFBQWE7QUFDeFk7QUFDQSw2Q0FBNkMsMEJBQTBCLHdEQUFLLFdBQVc7QUFDdkY7QUFDQTtBQUNBO0FBQ0EscURBQXFELDhDQUE4QyxXQUFXLHVEQUFJLFVBQVUsd0NBQXdDLElBQUksSUFBSTtBQUM1SztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsNEVBQTRFLHVEQUFJLFNBQVMsaUNBQWlDLHdEQUFLLFdBQVcsdURBQXVELHVEQUFJLFlBQVkscURBQXFELEdBQUcsdURBQUksWUFBWSx5REFBeUQsWUFBWSwrQkFBK0IsR0FBRyx1REFBSSxZQUFZLHVCQUF1QixZQUFZLDJIQUEySCxHQUFHLHdEQUFLLGFBQWEsNkZBQTZGLElBQUksd0NBQXdDLHdEQUFLLFdBQVcseURBQXlELHVEQUFJLFlBQVkscURBQXFEO0FBQzExQixvREFBb0Qsd0RBQUssVUFBVSxXQUFXLHVEQUFJLFlBQVksK0NBQStDLFdBQVcsT0FBTyxZQUFZLDRFQUE0RSxHQUFHLHVEQUFJLFlBQVksK0JBQStCLFdBQVcsT0FBTyxZQUFZLHlLQUF5SyxJQUFJLGlCQUFpQixZQUFZO0FBQ2poQix5Q0FBeUMsR0FBRyx3REFBSyxhQUFhLDZGQUE2RixJQUFJLHFDQUFxQyx3REFBSyxXQUFXLHFEQUFxRCxZQUFZLG1CQUFtQix1REFBSSxZQUFZLHFEQUFxRDtBQUM3VyxvREFBb0Qsd0RBQUssVUFBVSxXQUFXLHVEQUFJLFlBQVksK0NBQStDLE1BQU0sT0FBTyxZQUFZLGlFQUFpRSxHQUFHLHVEQUFJLFlBQVksbURBQW1ELE1BQU0sT0FBTyxZQUFZLHVKQUF1SixJQUFJLGlCQUFpQixZQUFZO0FBQzlmLHlDQUF5QyxHQUFHLHdEQUFLLGFBQWEsb0JBQW9CLFlBQVksNEVBQTRFLElBQUk7QUFDOUs7QUFDQTtBQUNBLGdFQUFnRSx1REFBSSxTQUFTLElBQUk7QUFDakYscUJBQXFCLElBQUksNkVBQTZFO0FBQ3RHIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L25vZGVfbW9kdWxlcy9AYXV0aC9jb3JlL2xpYi9wYWdlcy9zaWduaW4uanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsganN4IGFzIF9qc3gsIEZyYWdtZW50IGFzIF9GcmFnbWVudCwganN4cyBhcyBfanN4cyB9IGZyb20gXCJwcmVhY3QvanN4LXJ1bnRpbWVcIjtcbmltcG9ydCB7IHdlYmF1dGhuU2NyaXB0IH0gZnJvbSBcIi4uL3V0aWxzL3dlYmF1dGhuLWNsaWVudC5qc1wiO1xuY29uc3Qgc2lnbmluRXJyb3JzID0ge1xuICAgIGRlZmF1bHQ6IFwiVW5hYmxlIHRvIHNpZ24gaW4uXCIsXG4gICAgU2lnbmluOiBcIlRyeSBzaWduaW5nIGluIHdpdGggYSBkaWZmZXJlbnQgYWNjb3VudC5cIixcbiAgICBPQXV0aFNpZ25pbjogXCJUcnkgc2lnbmluZyBpbiB3aXRoIGEgZGlmZmVyZW50IGFjY291bnQuXCIsXG4gICAgT0F1dGhDYWxsYmFja0Vycm9yOiBcIlRyeSBzaWduaW5nIGluIHdpdGggYSBkaWZmZXJlbnQgYWNjb3VudC5cIixcbiAgICBPQXV0aENyZWF0ZUFjY291bnQ6IFwiVHJ5IHNpZ25pbmcgaW4gd2l0aCBhIGRpZmZlcmVudCBhY2NvdW50LlwiLFxuICAgIEVtYWlsQ3JlYXRlQWNjb3VudDogXCJUcnkgc2lnbmluZyBpbiB3aXRoIGEgZGlmZmVyZW50IGFjY291bnQuXCIsXG4gICAgQ2FsbGJhY2s6IFwiVHJ5IHNpZ25pbmcgaW4gd2l0aCBhIGRpZmZlcmVudCBhY2NvdW50LlwiLFxuICAgIE9BdXRoQWNjb3VudE5vdExpbmtlZDogXCJUbyBjb25maXJtIHlvdXIgaWRlbnRpdHksIHNpZ24gaW4gd2l0aCB0aGUgc2FtZSBhY2NvdW50IHlvdSB1c2VkIG9yaWdpbmFsbHkuXCIsXG4gICAgRW1haWxTaWduaW46IFwiVGhlIGUtbWFpbCBjb3VsZCBub3QgYmUgc2VudC5cIixcbiAgICBDcmVkZW50aWFsc1NpZ25pbjogXCJTaWduIGluIGZhaWxlZC4gQ2hlY2sgdGhlIGRldGFpbHMgeW91IHByb3ZpZGVkIGFyZSBjb3JyZWN0LlwiLFxuICAgIFNlc3Npb25SZXF1aXJlZDogXCJQbGVhc2Ugc2lnbiBpbiB0byBhY2Nlc3MgdGhpcyBwYWdlLlwiLFxufTtcbmZ1bmN0aW9uIENvbmRpdGlvbmFsVUlTY3JpcHQocHJvdmlkZXJJRCkge1xuICAgIGNvbnN0IHN0YXJ0Q29uZGl0aW9uYWxVSVNjcmlwdCA9IGBcbmNvbnN0IGN1cnJlbnRVUkwgPSB3aW5kb3cubG9jYXRpb24uaHJlZjtcbmNvbnN0IGF1dGhVUkwgPSBjdXJyZW50VVJMLnN1YnN0cmluZygwLCBjdXJyZW50VVJMLmxhc3RJbmRleE9mKCcvJykpO1xuKCR7d2ViYXV0aG5TY3JpcHR9KShhdXRoVVJMLCBcIiR7cHJvdmlkZXJJRH1cIik7XG5gO1xuICAgIHJldHVybiAoX2pzeChfRnJhZ21lbnQsIHsgY2hpbGRyZW46IF9qc3goXCJzY3JpcHRcIiwgeyBkYW5nZXJvdXNseVNldElubmVySFRNTDogeyBfX2h0bWw6IHN0YXJ0Q29uZGl0aW9uYWxVSVNjcmlwdCB9IH0pIH0pKTtcbn1cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIFNpZ25pblBhZ2UocHJvcHMpIHtcbiAgICBjb25zdCB7IGNzcmZUb2tlbiwgcHJvdmlkZXJzID0gW10sIGNhbGxiYWNrVXJsLCB0aGVtZSwgZW1haWwsIGVycm9yOiBlcnJvclR5cGUsIH0gPSBwcm9wcztcbiAgICBpZiAodHlwZW9mIGRvY3VtZW50ICE9PSBcInVuZGVmaW5lZFwiICYmIHRoZW1lPy5icmFuZENvbG9yKSB7XG4gICAgICAgIGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5zdHlsZS5zZXRQcm9wZXJ0eShcIi0tYnJhbmQtY29sb3JcIiwgdGhlbWUuYnJhbmRDb2xvcik7XG4gICAgfVxuICAgIGlmICh0eXBlb2YgZG9jdW1lbnQgIT09IFwidW5kZWZpbmVkXCIgJiYgdGhlbWU/LmJ1dHRvblRleHQpIHtcbiAgICAgICAgZG9jdW1lbnQuZG9jdW1lbnRFbGVtZW50LnN0eWxlLnNldFByb3BlcnR5KFwiLS1idXR0b24tdGV4dC1jb2xvclwiLCB0aGVtZS5idXR0b25UZXh0KTtcbiAgICB9XG4gICAgY29uc3QgZXJyb3IgPSBlcnJvclR5cGUgJiYgKHNpZ25pbkVycm9yc1tlcnJvclR5cGVdID8/IHNpZ25pbkVycm9ycy5kZWZhdWx0KTtcbiAgICBjb25zdCBwcm92aWRlckxvZ29QYXRoID0gXCJodHRwczovL2F1dGhqcy5kZXYvaW1nL3Byb3ZpZGVyc1wiO1xuICAgIGNvbnN0IGNvbmRpdGlvbmFsVUlQcm92aWRlcklEID0gcHJvdmlkZXJzLmZpbmQoKHByb3ZpZGVyKSA9PiBwcm92aWRlci50eXBlID09PSBcIndlYmF1dGhuXCIgJiYgcHJvdmlkZXIuZW5hYmxlQ29uZGl0aW9uYWxVSSk/LmlkO1xuICAgIHJldHVybiAoX2pzeHMoXCJkaXZcIiwgeyBjbGFzc05hbWU6IFwic2lnbmluXCIsIGNoaWxkcmVuOiBbdGhlbWU/LmJyYW5kQ29sb3IgJiYgKF9qc3goXCJzdHlsZVwiLCB7IGRhbmdlcm91c2x5U2V0SW5uZXJIVE1MOiB7XG4gICAgICAgICAgICAgICAgICAgIF9faHRtbDogYDpyb290IHstLWJyYW5kLWNvbG9yOiAke3RoZW1lLmJyYW5kQ29sb3J9fWAsXG4gICAgICAgICAgICAgICAgfSB9KSksIHRoZW1lPy5idXR0b25UZXh0ICYmIChfanN4KFwic3R5bGVcIiwgeyBkYW5nZXJvdXNseVNldElubmVySFRNTDoge1xuICAgICAgICAgICAgICAgICAgICBfX2h0bWw6IGBcbiAgICAgICAgOnJvb3Qge1xuICAgICAgICAgIC0tYnV0dG9uLXRleHQtY29sb3I6ICR7dGhlbWUuYnV0dG9uVGV4dH1cbiAgICAgICAgfVxuICAgICAgYCxcbiAgICAgICAgICAgICAgICB9IH0pKSwgX2pzeHMoXCJkaXZcIiwgeyBjbGFzc05hbWU6IFwiY2FyZFwiLCBjaGlsZHJlbjogW2Vycm9yICYmIChfanN4KFwiZGl2XCIsIHsgY2xhc3NOYW1lOiBcImVycm9yXCIsIGNoaWxkcmVuOiBfanN4KFwicFwiLCB7IGNoaWxkcmVuOiBlcnJvciB9KSB9KSksIHRoZW1lPy5sb2dvICYmIF9qc3goXCJpbWdcIiwgeyBzcmM6IHRoZW1lLmxvZ28sIGFsdDogXCJMb2dvXCIsIGNsYXNzTmFtZTogXCJsb2dvXCIgfSksIHByb3ZpZGVycy5tYXAoKHByb3ZpZGVyLCBpKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgYmcsIGJyYW5kQ29sb3IsIGxvZ287XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAocHJvdmlkZXIudHlwZSA9PT0gXCJvYXV0aFwiIHx8IHByb3ZpZGVyLnR5cGUgPT09IFwib2lkY1wiKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICh7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJnID0gXCIjZmZmXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyYW5kQ29sb3IsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ28gPSBgJHtwcm92aWRlckxvZ29QYXRofS8ke3Byb3ZpZGVyLmlkfS5zdmdgLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0gPSBwcm92aWRlci5zdHlsZSA/PyB7fSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBjb2xvciA9IGJyYW5kQ29sb3IgPz8gYmcgPz8gXCIjZmZmXCI7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gKF9qc3hzKFwiZGl2XCIsIHsgY2xhc3NOYW1lOiBcInByb3ZpZGVyXCIsIGNoaWxkcmVuOiBbcHJvdmlkZXIudHlwZSA9PT0gXCJvYXV0aFwiIHx8IHByb3ZpZGVyLnR5cGUgPT09IFwib2lkY1wiID8gKF9qc3hzKFwiZm9ybVwiLCB7IGFjdGlvbjogcHJvdmlkZXIuc2lnbmluVXJsLCBtZXRob2Q6IFwiUE9TVFwiLCBjaGlsZHJlbjogW19qc3goXCJpbnB1dFwiLCB7IHR5cGU6IFwiaGlkZGVuXCIsIG5hbWU6IFwiY3NyZlRva2VuXCIsIHZhbHVlOiBjc3JmVG9rZW4gfSksIGNhbGxiYWNrVXJsICYmIChfanN4KFwiaW5wdXRcIiwgeyB0eXBlOiBcImhpZGRlblwiLCBuYW1lOiBcImNhbGxiYWNrVXJsXCIsIHZhbHVlOiBjYWxsYmFja1VybCB9KSksIF9qc3hzKFwiYnV0dG9uXCIsIHsgdHlwZTogXCJzdWJtaXRcIiwgY2xhc3NOYW1lOiBcImJ1dHRvblwiLCBzdHlsZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCItLXByb3ZpZGVyLWJyYW5kLWNvbG9yXCI6IGNvbG9yLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LCB0YWJJbmRleDogMCwgY2hpbGRyZW46IFtfanN4cyhcInNwYW5cIiwgeyBzdHlsZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmaWx0ZXI6IFwiaW52ZXJ0KDEpIGdyYXlzY2FsZSgxKSBicmlnaHRuZXNzKDEuMykgY29udHJhc3QoOTAwMClcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJtaXgtYmxlbmQtbW9kZVwiOiBcImx1bWlub3NpdHlcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgb3BhY2l0eTogMC45NSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LCBjaGlsZHJlbjogW1wiU2lnbiBpbiB3aXRoIFwiLCBwcm92aWRlci5uYW1lXSB9KSwgbG9nbyAmJiBfanN4KFwiaW1nXCIsIHsgbG9hZGluZzogXCJsYXp5XCIsIGhlaWdodDogMjQsIHNyYzogbG9nbyB9KV0gfSldIH0pKSA6IG51bGwsIChwcm92aWRlci50eXBlID09PSBcImVtYWlsXCIgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb3ZpZGVyLnR5cGUgPT09IFwiY3JlZGVudGlhbHNcIiB8fFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJvdmlkZXIudHlwZSA9PT0gXCJ3ZWJhdXRoblwiKSAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaSA+IDAgJiZcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb3ZpZGVyc1tpIC0gMV0udHlwZSAhPT0gXCJlbWFpbFwiICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm92aWRlcnNbaSAtIDFdLnR5cGUgIT09IFwiY3JlZGVudGlhbHNcIiAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJvdmlkZXJzW2kgLSAxXS50eXBlICE9PSBcIndlYmF1dGhuXCIgJiYgX2pzeChcImhyXCIsIHt9KSwgcHJvdmlkZXIudHlwZSA9PT0gXCJlbWFpbFwiICYmIChfanN4cyhcImZvcm1cIiwgeyBhY3Rpb246IHByb3ZpZGVyLnNpZ25pblVybCwgbWV0aG9kOiBcIlBPU1RcIiwgY2hpbGRyZW46IFtfanN4KFwiaW5wdXRcIiwgeyB0eXBlOiBcImhpZGRlblwiLCBuYW1lOiBcImNzcmZUb2tlblwiLCB2YWx1ZTogY3NyZlRva2VuIH0pLCBfanN4KFwibGFiZWxcIiwgeyBjbGFzc05hbWU6IFwic2VjdGlvbi1oZWFkZXJcIiwgaHRtbEZvcjogYGlucHV0LWVtYWlsLWZvci0ke3Byb3ZpZGVyLmlkfS1wcm92aWRlcmAsIGNoaWxkcmVuOiBcIkVtYWlsXCIgfSksIF9qc3goXCJpbnB1dFwiLCB7IGlkOiBgaW5wdXQtZW1haWwtZm9yLSR7cHJvdmlkZXIuaWR9LXByb3ZpZGVyYCwgYXV0b0ZvY3VzOiB0cnVlLCB0eXBlOiBcImVtYWlsXCIsIG5hbWU6IFwiZW1haWxcIiwgdmFsdWU6IGVtYWlsLCBwbGFjZWhvbGRlcjogXCJlbWFpbEBleGFtcGxlLmNvbVwiLCByZXF1aXJlZDogdHJ1ZSB9KSwgX2pzeHMoXCJidXR0b25cIiwgeyBpZDogXCJzdWJtaXRCdXR0b25cIiwgdHlwZTogXCJzdWJtaXRcIiwgdGFiSW5kZXg6IDAsIGNoaWxkcmVuOiBbXCJTaWduIGluIHdpdGggXCIsIHByb3ZpZGVyLm5hbWVdIH0pXSB9KSksIHByb3ZpZGVyLnR5cGUgPT09IFwiY3JlZGVudGlhbHNcIiAmJiAoX2pzeHMoXCJmb3JtXCIsIHsgYWN0aW9uOiBwcm92aWRlci5jYWxsYmFja1VybCwgbWV0aG9kOiBcIlBPU1RcIiwgY2hpbGRyZW46IFtfanN4KFwiaW5wdXRcIiwgeyB0eXBlOiBcImhpZGRlblwiLCBuYW1lOiBcImNzcmZUb2tlblwiLCB2YWx1ZTogY3NyZlRva2VuIH0pLCBPYmplY3Qua2V5cyhwcm92aWRlci5jcmVkZW50aWFscykubWFwKChjcmVkZW50aWFsKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiAoX2pzeHMoXCJkaXZcIiwgeyBjaGlsZHJlbjogW19qc3goXCJsYWJlbFwiLCB7IGNsYXNzTmFtZTogXCJzZWN0aW9uLWhlYWRlclwiLCBodG1sRm9yOiBgaW5wdXQtJHtjcmVkZW50aWFsfS1mb3ItJHtwcm92aWRlci5pZH0tcHJvdmlkZXJgLCBjaGlsZHJlbjogcHJvdmlkZXIuY3JlZGVudGlhbHNbY3JlZGVudGlhbF0ubGFiZWwgPz8gY3JlZGVudGlhbCB9KSwgX2pzeChcImlucHV0XCIsIHsgbmFtZTogY3JlZGVudGlhbCwgaWQ6IGBpbnB1dC0ke2NyZWRlbnRpYWx9LWZvci0ke3Byb3ZpZGVyLmlkfS1wcm92aWRlcmAsIHR5cGU6IHByb3ZpZGVyLmNyZWRlbnRpYWxzW2NyZWRlbnRpYWxdLnR5cGUgPz8gXCJ0ZXh0XCIsIHBsYWNlaG9sZGVyOiBwcm92aWRlci5jcmVkZW50aWFsc1tjcmVkZW50aWFsXS5wbGFjZWhvbGRlciA/PyBcIlwiLCAuLi5wcm92aWRlci5jcmVkZW50aWFsc1tjcmVkZW50aWFsXSB9KV0gfSwgYGlucHV0LWdyb3VwLSR7cHJvdmlkZXIuaWR9YCkpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pLCBfanN4cyhcImJ1dHRvblwiLCB7IGlkOiBcInN1Ym1pdEJ1dHRvblwiLCB0eXBlOiBcInN1Ym1pdFwiLCB0YWJJbmRleDogMCwgY2hpbGRyZW46IFtcIlNpZ24gaW4gd2l0aCBcIiwgcHJvdmlkZXIubmFtZV0gfSldIH0pKSwgcHJvdmlkZXIudHlwZSA9PT0gXCJ3ZWJhdXRoblwiICYmIChfanN4cyhcImZvcm1cIiwgeyBhY3Rpb246IHByb3ZpZGVyLmNhbGxiYWNrVXJsLCBtZXRob2Q6IFwiUE9TVFwiLCBpZDogYCR7cHJvdmlkZXIuaWR9LWZvcm1gLCBjaGlsZHJlbjogW19qc3goXCJpbnB1dFwiLCB7IHR5cGU6IFwiaGlkZGVuXCIsIG5hbWU6IFwiY3NyZlRva2VuXCIsIHZhbHVlOiBjc3JmVG9rZW4gfSksIE9iamVjdC5rZXlzKHByb3ZpZGVyLmZvcm1GaWVsZHMpLm1hcCgoZmllbGQpID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIChfanN4cyhcImRpdlwiLCB7IGNoaWxkcmVuOiBbX2pzeChcImxhYmVsXCIsIHsgY2xhc3NOYW1lOiBcInNlY3Rpb24taGVhZGVyXCIsIGh0bWxGb3I6IGBpbnB1dC0ke2ZpZWxkfS1mb3ItJHtwcm92aWRlci5pZH0tcHJvdmlkZXJgLCBjaGlsZHJlbjogcHJvdmlkZXIuZm9ybUZpZWxkc1tmaWVsZF0ubGFiZWwgPz8gZmllbGQgfSksIF9qc3goXCJpbnB1dFwiLCB7IG5hbWU6IGZpZWxkLCBcImRhdGEtZm9ybS1maWVsZFwiOiB0cnVlLCBpZDogYGlucHV0LSR7ZmllbGR9LWZvci0ke3Byb3ZpZGVyLmlkfS1wcm92aWRlcmAsIHR5cGU6IHByb3ZpZGVyLmZvcm1GaWVsZHNbZmllbGRdLnR5cGUgPz8gXCJ0ZXh0XCIsIHBsYWNlaG9sZGVyOiBwcm92aWRlci5mb3JtRmllbGRzW2ZpZWxkXS5wbGFjZWhvbGRlciA/PyBcIlwiLCAuLi5wcm92aWRlci5mb3JtRmllbGRzW2ZpZWxkXSB9KV0gfSwgYGlucHV0LWdyb3VwLSR7cHJvdmlkZXIuaWR9YCkpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pLCBfanN4cyhcImJ1dHRvblwiLCB7IGlkOiBgc3VibWl0QnV0dG9uLSR7cHJvdmlkZXIuaWR9YCwgdHlwZTogXCJzdWJtaXRcIiwgdGFiSW5kZXg6IDAsIGNoaWxkcmVuOiBbXCJTaWduIGluIHdpdGggXCIsIHByb3ZpZGVyLm5hbWVdIH0pXSB9KSksIChwcm92aWRlci50eXBlID09PSBcImVtYWlsXCIgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb3ZpZGVyLnR5cGUgPT09IFwiY3JlZGVudGlhbHNcIiB8fFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJvdmlkZXIudHlwZSA9PT0gXCJ3ZWJhdXRoblwiKSAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaSArIDEgPCBwcm92aWRlcnMubGVuZ3RoICYmIF9qc3goXCJoclwiLCB7fSldIH0sIHByb3ZpZGVyLmlkKSk7XG4gICAgICAgICAgICAgICAgICAgIH0pXSB9KSwgY29uZGl0aW9uYWxVSVByb3ZpZGVySUQgJiYgQ29uZGl0aW9uYWxVSVNjcmlwdChjb25kaXRpb25hbFVJUHJvdmlkZXJJRCldIH0pKTtcbn1cbiJdLCJuYW1lcyI6W10sImlnbm9yZUxpc3QiOlswXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/signin.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/signout.js":
/*!******************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/signout.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ SignoutPage)\n/* harmony export */ });\n/* harmony import */ var preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! preact/jsx-runtime */ \"(rsc)/./node_modules/preact/jsx-runtime/dist/jsxRuntime.mjs\");\n\nfunction SignoutPage(props) {\n    const { url, csrfToken, theme } = props;\n    return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"signout\", children: [theme?.brandColor && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                    __html: `\n        :root {\n          --brand-color: ${theme.brandColor}\n        }\n      `,\n                } })), theme?.buttonText && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                    __html: `\n        :root {\n          --button-text-color: ${theme.buttonText}\n        }\n      `,\n                } })), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"card\", children: [theme?.logo && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { src: theme.logo, alt: \"Logo\", className: \"logo\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"h1\", { children: \"Signout\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"Are you sure you want to sign out?\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"form\", { action: url?.toString(), method: \"POST\", children: [(0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"input\", { type: \"hidden\", name: \"csrfToken\", value: csrfToken }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"button\", { id: \"submitButton\", type: \"submit\", children: \"Sign out\" })] })] })] }));\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/signout.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/styles.js":
/*!*****************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/styles.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n// Generated by `pnpm css`\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (`:root {\n  --border-width: 1px;\n  --border-radius: 0.5rem;\n  --color-error: #c94b4b;\n  --color-info: #157efb;\n  --color-info-hover: #0f6ddb;\n  --color-info-text: #fff;\n}\n\n.__next-auth-theme-auto,\n.__next-auth-theme-light {\n  --color-background: #ececec;\n  --color-background-hover: rgba(236, 236, 236, 0.8);\n  --color-background-card: #fff;\n  --color-text: #000;\n  --color-primary: #444;\n  --color-control-border: #bbb;\n  --color-button-active-background: #f9f9f9;\n  --color-button-active-border: #aaa;\n  --color-separator: #ccc;\n  --provider-bg: #fff;\n  --provider-bg-hover: color-mix(\n    in srgb,\n    var(--provider-brand-color) 30%,\n    #fff\n  );\n}\n\n.__next-auth-theme-dark {\n  --color-background: #161b22;\n  --color-background-hover: rgba(22, 27, 34, 0.8);\n  --color-background-card: #0d1117;\n  --color-text: #fff;\n  --color-primary: #ccc;\n  --color-control-border: #555;\n  --color-button-active-background: #060606;\n  --color-button-active-border: #666;\n  --color-separator: #444;\n  --provider-bg: #161b22;\n  --provider-bg-hover: color-mix(\n    in srgb,\n    var(--provider-brand-color) 30%,\n    #000\n  );\n}\n\n.__next-auth-theme-dark img[src$=\"42-school.svg\"],\n  .__next-auth-theme-dark img[src$=\"apple.svg\"],\n  .__next-auth-theme-dark img[src$=\"boxyhq-saml.svg\"],\n  .__next-auth-theme-dark img[src$=\"eveonline.svg\"],\n  .__next-auth-theme-dark img[src$=\"github.svg\"],\n  .__next-auth-theme-dark img[src$=\"mailchimp.svg\"],\n  .__next-auth-theme-dark img[src$=\"medium.svg\"],\n  .__next-auth-theme-dark img[src$=\"okta.svg\"],\n  .__next-auth-theme-dark img[src$=\"patreon.svg\"],\n  .__next-auth-theme-dark img[src$=\"ping-id.svg\"],\n  .__next-auth-theme-dark img[src$=\"roblox.svg\"],\n  .__next-auth-theme-dark img[src$=\"threads.svg\"],\n  .__next-auth-theme-dark img[src$=\"wikimedia.svg\"] {\n    filter: invert(1);\n  }\n\n.__next-auth-theme-dark #submitButton {\n    background-color: var(--provider-bg, var(--color-info));\n  }\n\n@media (prefers-color-scheme: dark) {\n  .__next-auth-theme-auto {\n    --color-background: #161b22;\n    --color-background-hover: rgba(22, 27, 34, 0.8);\n    --color-background-card: #0d1117;\n    --color-text: #fff;\n    --color-primary: #ccc;\n    --color-control-border: #555;\n    --color-button-active-background: #060606;\n    --color-button-active-border: #666;\n    --color-separator: #444;\n    --provider-bg: #161b22;\n    --provider-bg-hover: color-mix(\n      in srgb,\n      var(--provider-brand-color) 30%,\n      #000\n    );\n  }\n    .__next-auth-theme-auto img[src$=\"42-school.svg\"],\n    .__next-auth-theme-auto img[src$=\"apple.svg\"],\n    .__next-auth-theme-auto img[src$=\"boxyhq-saml.svg\"],\n    .__next-auth-theme-auto img[src$=\"eveonline.svg\"],\n    .__next-auth-theme-auto img[src$=\"github.svg\"],\n    .__next-auth-theme-auto img[src$=\"mailchimp.svg\"],\n    .__next-auth-theme-auto img[src$=\"medium.svg\"],\n    .__next-auth-theme-auto img[src$=\"okta.svg\"],\n    .__next-auth-theme-auto img[src$=\"patreon.svg\"],\n    .__next-auth-theme-auto img[src$=\"ping-id.svg\"],\n    .__next-auth-theme-auto img[src$=\"roblox.svg\"],\n    .__next-auth-theme-auto img[src$=\"threads.svg\"],\n    .__next-auth-theme-auto img[src$=\"wikimedia.svg\"] {\n      filter: invert(1);\n    }\n    .__next-auth-theme-auto #submitButton {\n      background-color: var(--provider-bg, var(--color-info));\n    }\n}\n\nhtml {\n  box-sizing: border-box;\n}\n\n*,\n*:before,\n*:after {\n  box-sizing: inherit;\n  margin: 0;\n  padding: 0;\n}\n\nbody {\n  background-color: var(--color-background);\n  margin: 0;\n  padding: 0;\n  font-family:\n    ui-sans-serif,\n    system-ui,\n    -apple-system,\n    BlinkMacSystemFont,\n    \"Segoe UI\",\n    Roboto,\n    \"Helvetica Neue\",\n    Arial,\n    \"Noto Sans\",\n    sans-serif,\n    \"Apple Color Emoji\",\n    \"Segoe UI Emoji\",\n    \"Segoe UI Symbol\",\n    \"Noto Color Emoji\";\n}\n\nh1 {\n  margin-bottom: 1.5rem;\n  padding: 0 1rem;\n  font-weight: 400;\n  color: var(--color-text);\n}\n\np {\n  margin-bottom: 1.5rem;\n  padding: 0 1rem;\n  color: var(--color-text);\n}\n\nform {\n  margin: 0;\n  padding: 0;\n}\n\nlabel {\n  font-weight: 500;\n  text-align: left;\n  margin-bottom: 0.25rem;\n  display: block;\n  color: var(--color-text);\n}\n\ninput[type] {\n  box-sizing: border-box;\n  display: block;\n  width: 100%;\n  padding: 0.5rem 1rem;\n  border: var(--border-width) solid var(--color-control-border);\n  background: var(--color-background-card);\n  font-size: 1rem;\n  border-radius: var(--border-radius);\n  color: var(--color-text);\n}\n\np {\n  font-size: 1.1rem;\n  line-height: 2rem;\n}\n\na.button {\n  text-decoration: none;\n  line-height: 1rem;\n}\n\na.button:link,\n  a.button:visited {\n    background-color: var(--color-background);\n    color: var(--color-primary);\n  }\n\nbutton,\na.button {\n  padding: 0.75rem 1rem;\n  color: var(--provider-color, var(--color-primary));\n  background-color: var(--provider-bg, var(--color-background));\n  border: 1px solid #00000031;\n  font-size: 0.9rem;\n  height: 50px;\n  border-radius: var(--border-radius);\n  transition: background-color 250ms ease-in-out;\n  font-weight: 300;\n  position: relative;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n\n:is(button,a.button):hover {\n    background-color: var(--provider-bg-hover, var(--color-background-hover));\n    cursor: pointer;\n  }\n\n:is(button,a.button):active {\n    cursor: pointer;\n  }\n\n:is(button,a.button) span {\n    color: var(--provider-bg);\n  }\n\n#submitButton {\n  color: var(--button-text-color, var(--color-info-text));\n  background-color: var(--brand-color, var(--color-info));\n  width: 100%;\n}\n\n#submitButton:hover {\n    background-color: var(\n      --button-hover-bg,\n      var(--color-info-hover)\n    ) !important;\n  }\n\na.site {\n  color: var(--color-primary);\n  text-decoration: none;\n  font-size: 1rem;\n  line-height: 2rem;\n}\n\na.site:hover {\n    text-decoration: underline;\n  }\n\n.page {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  display: grid;\n  place-items: center;\n  margin: 0;\n  padding: 0;\n  box-sizing: border-box;\n}\n\n.page > div {\n    text-align: center;\n  }\n\n.error a.button {\n    padding-left: 2rem;\n    padding-right: 2rem;\n    margin-top: 0.5rem;\n  }\n\n.error .message {\n    margin-bottom: 1.5rem;\n  }\n\n.signin input[type=\"text\"] {\n    margin-left: auto;\n    margin-right: auto;\n    display: block;\n  }\n\n.signin hr {\n    display: block;\n    border: 0;\n    border-top: 1px solid var(--color-separator);\n    margin: 2rem auto 1rem auto;\n    overflow: visible;\n  }\n\n.signin hr::before {\n      content: \"or\";\n      background: var(--color-background-card);\n      color: #888;\n      padding: 0 0.4rem;\n      position: relative;\n      top: -0.7rem;\n    }\n\n.signin .error {\n    background: #f5f5f5;\n    font-weight: 500;\n    border-radius: 0.3rem;\n    background: var(--color-error);\n  }\n\n.signin .error p {\n      text-align: left;\n      padding: 0.5rem 1rem;\n      font-size: 0.9rem;\n      line-height: 1.2rem;\n      color: var(--color-info-text);\n    }\n\n.signin > div,\n  .signin form {\n    display: block;\n  }\n\n.signin > div input[type], .signin form input[type] {\n      margin-bottom: 0.5rem;\n    }\n\n.signin > div button, .signin form button {\n      width: 100%;\n    }\n\n.signin .provider + .provider {\n    margin-top: 1rem;\n  }\n\n.logo {\n  display: inline-block;\n  max-width: 150px;\n  margin: 1.25rem 0;\n  max-height: 70px;\n}\n\n.card {\n  background-color: var(--color-background-card);\n  border-radius: 1rem;\n  padding: 1.25rem 2rem;\n}\n\n.card .header {\n    color: var(--color-primary);\n  }\n\n.card input[type]::-moz-placeholder {\n    color: color-mix(\n      in srgb,\n      var(--color-text) 20%,\n      var(--color-button-active-background)\n    );\n  }\n\n.card input[type]::placeholder {\n    color: color-mix(\n      in srgb,\n      var(--color-text) 20%,\n      var(--color-button-active-background)\n    );\n  }\n\n.card input[type] {\n    background: color-mix(in srgb, var(--color-background-card) 95%, black);\n  }\n\n.section-header {\n  color: var(--color-text);\n}\n\n@media screen and (min-width: 450px) {\n  .card {\n    margin: 2rem 0;\n    width: 368px;\n  }\n}\n\n@media screen and (max-width: 450px) {\n  .card {\n    margin: 1rem 0;\n    width: 343px;\n  }\n}\n`);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/styles.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/pages/verify-request.js":
/*!*************************************************************!*\
  !*** ./node_modules/@auth/core/lib/pages/verify-request.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ VerifyRequestPage)\n/* harmony export */ });\n/* harmony import */ var preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! preact/jsx-runtime */ \"(rsc)/./node_modules/preact/jsx-runtime/dist/jsxRuntime.mjs\");\n\nfunction VerifyRequestPage(props) {\n    const { url, theme } = props;\n    return ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"verify-request\", children: [theme.brandColor && ((0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"style\", { dangerouslySetInnerHTML: {\n                    __html: `\n        :root {\n          --brand-color: ${theme.brandColor}\n        }\n      `,\n                } })), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(\"div\", { className: \"card\", children: [theme.logo && (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"img\", { src: theme.logo, alt: \"Logo\", className: \"logo\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"h1\", { children: \"Check your email\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: \"A sign in link has been sent to your email address.\" }), (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"p\", { children: (0,preact_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(\"a\", { className: \"site\", href: url.origin, children: url.host }) })] })] }));\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvcGFnZXMvdmVyaWZ5LXJlcXVlc3QuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBZ0U7QUFDakQ7QUFDZixZQUFZLGFBQWE7QUFDekIsWUFBWSx3REFBSyxVQUFVLDZEQUE2RCx1REFBSSxZQUFZO0FBQ3hHO0FBQ0E7QUFDQSwyQkFBMkI7QUFDM0I7QUFDQTtBQUNBLG1CQUFtQixJQUFJLHdEQUFLLFVBQVUsNENBQTRDLHVEQUFJLFVBQVUsaURBQWlELEdBQUcsdURBQUksU0FBUyw4QkFBOEIsR0FBRyx1REFBSSxRQUFRLGlFQUFpRSxHQUFHLHVEQUFJLFFBQVEsVUFBVSx1REFBSSxRQUFRLHlEQUF5RCxHQUFHLElBQUksSUFBSTtBQUN4WCIsInNvdXJjZXMiOlsiL2hvbWUvcml6dmkvcHJvamVjdHMvYXVkaXQtbmV4dC9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvcGFnZXMvdmVyaWZ5LXJlcXVlc3QuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsganN4IGFzIF9qc3gsIGpzeHMgYXMgX2pzeHMgfSBmcm9tIFwicHJlYWN0L2pzeC1ydW50aW1lXCI7XG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBWZXJpZnlSZXF1ZXN0UGFnZShwcm9wcykge1xuICAgIGNvbnN0IHsgdXJsLCB0aGVtZSB9ID0gcHJvcHM7XG4gICAgcmV0dXJuIChfanN4cyhcImRpdlwiLCB7IGNsYXNzTmFtZTogXCJ2ZXJpZnktcmVxdWVzdFwiLCBjaGlsZHJlbjogW3RoZW1lLmJyYW5kQ29sb3IgJiYgKF9qc3goXCJzdHlsZVwiLCB7IGRhbmdlcm91c2x5U2V0SW5uZXJIVE1MOiB7XG4gICAgICAgICAgICAgICAgICAgIF9faHRtbDogYFxuICAgICAgICA6cm9vdCB7XG4gICAgICAgICAgLS1icmFuZC1jb2xvcjogJHt0aGVtZS5icmFuZENvbG9yfVxuICAgICAgICB9XG4gICAgICBgLFxuICAgICAgICAgICAgICAgIH0gfSkpLCBfanN4cyhcImRpdlwiLCB7IGNsYXNzTmFtZTogXCJjYXJkXCIsIGNoaWxkcmVuOiBbdGhlbWUubG9nbyAmJiBfanN4KFwiaW1nXCIsIHsgc3JjOiB0aGVtZS5sb2dvLCBhbHQ6IFwiTG9nb1wiLCBjbGFzc05hbWU6IFwibG9nb1wiIH0pLCBfanN4KFwiaDFcIiwgeyBjaGlsZHJlbjogXCJDaGVjayB5b3VyIGVtYWlsXCIgfSksIF9qc3goXCJwXCIsIHsgY2hpbGRyZW46IFwiQSBzaWduIGluIGxpbmsgaGFzIGJlZW4gc2VudCB0byB5b3VyIGVtYWlsIGFkZHJlc3MuXCIgfSksIF9qc3goXCJwXCIsIHsgY2hpbGRyZW46IF9qc3goXCJhXCIsIHsgY2xhc3NOYW1lOiBcInNpdGVcIiwgaHJlZjogdXJsLm9yaWdpbiwgY2hpbGRyZW46IHVybC5ob3N0IH0pIH0pXSB9KV0gfSkpO1xufVxuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/pages/verify-request.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/symbols.js":
/*!************************************************!*\
  !*** ./node_modules/@auth/core/lib/symbols.js ***!
  \************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   conformInternal: () => (/* binding */ conformInternal),\n/* harmony export */   customFetch: () => (/* binding */ customFetch),\n/* harmony export */   raw: () => (/* binding */ raw),\n/* harmony export */   skipCSRFCheck: () => (/* binding */ skipCSRFCheck)\n/* harmony export */ });\n/**\n * :::danger\n * This option is intended for framework authors.\n * :::\n *\n * Auth.js comes with built-in CSRF protection, but\n * if you are implementing a framework that is already protected against CSRF attacks, you can skip this check by\n * passing this value to {@link AuthConfig.skipCSRFCheck}.\n */\nconst skipCSRFCheck = Symbol(\"skip-csrf-check\");\n/**\n * :::danger\n * This option is intended for framework authors.\n * :::\n *\n * Auth.js returns a web standard {@link Response} by default, but\n * if you are implementing a framework you might want to get access to the raw internal response\n * by passing this value to {@link AuthConfig.raw}.\n */\nconst raw = Symbol(\"return-type-raw\");\n/**\n * :::danger\n * This option allows you to override the default `fetch` function used by the provider\n * to make requests to the provider's OAuth endpoints directly.\n * Used incorrectly, it can have security implications.\n * :::\n *\n * It can be used to support corporate proxies, custom fetch libraries, cache discovery endpoints,\n * add mocks for testing, logging, set custom headers/params for non-spec compliant providers, etc.\n *\n * @example\n * ```ts\n * import { Auth, customFetch } from \"@auth/core\"\n * import GitHub from \"@auth/core/providers/github\"\n *\n * const dispatcher = new ProxyAgent(\"my.proxy.server\")\n * function proxy(...args: Parameters<typeof fetch>): ReturnType<typeof fetch> {\n *   return undici(args[0], { ...(args[1] ?? {}), dispatcher })\n * }\n *\n * const response = await Auth(request, {\n *   providers: [GitHub({ [customFetch]: proxy })]\n * })\n * ```\n *\n * @see https://undici.nodejs.org/#/docs/api/ProxyAgent?id=example-basic-proxy-request-with-local-agent-dispatcher\n * @see https://authjs.dev/guides/corporate-proxy\n */\nconst customFetch = Symbol(\"custom-fetch\");\n/**\n * @internal\n *\n * Used to mark some providers for processing within the core library.\n *\n * **Do not use or you will be fired.**\n */\nconst conformInternal = Symbol(\"conform-internal\");\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/symbols.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/actions.js":
/*!******************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/actions.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   isAuthAction: () => (/* binding */ isAuthAction)\n/* harmony export */ });\nconst actions = [\n    \"providers\",\n    \"session\",\n    \"csrf\",\n    \"signin\",\n    \"signout\",\n    \"callback\",\n    \"verify-request\",\n    \"error\",\n    \"webauthn-options\",\n];\nfunction isAuthAction(action) {\n    return actions.includes(action);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvYWN0aW9ucy5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPO0FBQ1A7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvcml6dmkvcHJvamVjdHMvYXVkaXQtbmV4dC9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvYWN0aW9ucy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBhY3Rpb25zID0gW1xuICAgIFwicHJvdmlkZXJzXCIsXG4gICAgXCJzZXNzaW9uXCIsXG4gICAgXCJjc3JmXCIsXG4gICAgXCJzaWduaW5cIixcbiAgICBcInNpZ25vdXRcIixcbiAgICBcImNhbGxiYWNrXCIsXG4gICAgXCJ2ZXJpZnktcmVxdWVzdFwiLFxuICAgIFwiZXJyb3JcIixcbiAgICBcIndlYmF1dGhuLW9wdGlvbnNcIixcbl07XG5leHBvcnQgZnVuY3Rpb24gaXNBdXRoQWN0aW9uKGFjdGlvbikge1xuICAgIHJldHVybiBhY3Rpb25zLmluY2x1ZGVzKGFjdGlvbik7XG59XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/actions.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/assert.js":
/*!*****************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/assert.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   assertConfig: () => (/* binding */ assertConfig)\n/* harmony export */ });\n/* harmony import */ var _cookie_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/cookie.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\n\nlet warned = false;\nfunction isValidHttpUrl(url, baseUrl) {\n    try {\n        return /^https?:/.test(new URL(url, url.startsWith(\"/\") ? baseUrl : undefined).protocol);\n    }\n    catch {\n        return false;\n    }\n}\nfunction isSemverString(version) {\n    return /^v\\d+(?:\\.\\d+){0,2}$/.test(version);\n}\nlet hasCredentials = false;\nlet hasEmail = false;\nlet hasWebAuthn = false;\nconst emailMethods = [\n    \"createVerificationToken\",\n    \"useVerificationToken\",\n    \"getUserByEmail\",\n];\nconst sessionMethods = [\n    \"createUser\",\n    \"getUser\",\n    \"getUserByEmail\",\n    \"getUserByAccount\",\n    \"updateUser\",\n    \"linkAccount\",\n    \"createSession\",\n    \"getSessionAndUser\",\n    \"updateSession\",\n    \"deleteSession\",\n];\nconst webauthnMethods = [\n    \"createUser\",\n    \"getUser\",\n    \"linkAccount\",\n    \"getAccount\",\n    \"getAuthenticator\",\n    \"createAuthenticator\",\n    \"listAuthenticatorsByUserId\",\n    \"updateAuthenticatorCounter\",\n];\n/**\n * Verify that the user configured Auth.js correctly.\n * Good place to mention deprecations as well.\n *\n * This is invoked before the init method, so default values are not available yet.\n */\nfunction assertConfig(request, options) {\n    const { url } = request;\n    const warnings = [];\n    if (!warned && options.debug)\n        warnings.push(\"debug-enabled\");\n    if (!options.trustHost) {\n        return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UntrustedHost(`Host must be trusted. URL was: ${request.url}`);\n    }\n    if (!options.secret?.length) {\n        return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingSecret(\"Please define a `secret`\");\n    }\n    const callbackUrlParam = request.query?.callbackUrl;\n    if (callbackUrlParam && !isValidHttpUrl(callbackUrlParam, url.origin)) {\n        return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.InvalidCallbackUrl(`Invalid callback URL. Received: ${callbackUrlParam}`);\n    }\n    const { callbackUrl: defaultCallbackUrl } = (0,_cookie_js__WEBPACK_IMPORTED_MODULE_0__.defaultCookies)(options.useSecureCookies ?? url.protocol === \"https:\");\n    const callbackUrlCookie = request.cookies?.[options.cookies?.callbackUrl?.name ?? defaultCallbackUrl.name];\n    if (callbackUrlCookie && !isValidHttpUrl(callbackUrlCookie, url.origin)) {\n        return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.InvalidCallbackUrl(`Invalid callback URL. Received: ${callbackUrlCookie}`);\n    }\n    // Keep track of webauthn providers that use conditional UI\n    let hasConditionalUIProvider = false;\n    for (const p of options.providers) {\n        const provider = typeof p === \"function\" ? p() : p;\n        if ((provider.type === \"oauth\" || provider.type === \"oidc\") &&\n            !(provider.issuer ?? provider.options?.issuer)) {\n            const { authorization: a, token: t, userinfo: u } = provider;\n            let key;\n            if (typeof a !== \"string\" && !a?.url)\n                key = \"authorization\";\n            else if (typeof t !== \"string\" && !t?.url)\n                key = \"token\";\n            else if (typeof u !== \"string\" && !u?.url)\n                key = \"userinfo\";\n            if (key) {\n                return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.InvalidEndpoints(`Provider \"${provider.id}\" is missing both \\`issuer\\` and \\`${key}\\` endpoint config. At least one of them is required`);\n            }\n        }\n        if (provider.type === \"credentials\")\n            hasCredentials = true;\n        else if (provider.type === \"email\")\n            hasEmail = true;\n        else if (provider.type === \"webauthn\") {\n            hasWebAuthn = true;\n            // Validate simpleWebAuthnBrowserVersion\n            if (provider.simpleWebAuthnBrowserVersion &&\n                !isSemverString(provider.simpleWebAuthnBrowserVersion)) {\n                return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.AuthError(`Invalid provider config for \"${provider.id}\": simpleWebAuthnBrowserVersion \"${provider.simpleWebAuthnBrowserVersion}\" must be a valid semver string.`);\n            }\n            if (provider.enableConditionalUI) {\n                // Make sure only one webauthn provider has \"enableConditionalUI\" set to true\n                if (hasConditionalUIProvider) {\n                    return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.DuplicateConditionalUI(`Multiple webauthn providers have 'enableConditionalUI' set to True. Only one provider can have this option enabled at a time`);\n                }\n                hasConditionalUIProvider = true;\n                // Make sure at least one formField has \"webauthn\" in its autocomplete param\n                const hasWebauthnFormField = Object.values(provider.formFields).some((f) => f.autocomplete && f.autocomplete.toString().indexOf(\"webauthn\") > -1);\n                if (!hasWebauthnFormField) {\n                    return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingWebAuthnAutocomplete(`Provider \"${provider.id}\" has 'enableConditionalUI' set to True, but none of its formFields have 'webauthn' in their autocomplete param`);\n                }\n            }\n        }\n    }\n    if (hasCredentials) {\n        const dbStrategy = options.session?.strategy === \"database\";\n        const onlyCredentials = !options.providers.some((p) => (typeof p === \"function\" ? p() : p).type !== \"credentials\");\n        if (dbStrategy && onlyCredentials) {\n            return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnsupportedStrategy(\"Signing in with credentials only supported if JWT strategy is enabled\");\n        }\n        const credentialsNoAuthorize = options.providers.some((p) => {\n            const provider = typeof p === \"function\" ? p() : p;\n            return provider.type === \"credentials\" && !provider.authorize;\n        });\n        if (credentialsNoAuthorize) {\n            return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingAuthorize(\"Must define an authorize() handler to use credentials authentication provider\");\n        }\n    }\n    const { adapter, session } = options;\n    const requiredMethods = [];\n    if (hasEmail ||\n        session?.strategy === \"database\" ||\n        (!session?.strategy && adapter)) {\n        if (hasEmail) {\n            if (!adapter)\n                return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingAdapter(\"Email login requires an adapter\");\n            requiredMethods.push(...emailMethods);\n        }\n        else {\n            if (!adapter)\n                return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingAdapter(\"Database session requires an adapter\");\n            requiredMethods.push(...sessionMethods);\n        }\n    }\n    if (hasWebAuthn) {\n        // Log experimental warning\n        if (options.experimental?.enableWebAuthn) {\n            warnings.push(\"experimental-webauthn\");\n        }\n        else {\n            return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.ExperimentalFeatureNotEnabled(\"WebAuthn is an experimental feature. To enable it, set `experimental.enableWebAuthn` to `true` in your config\");\n        }\n        if (!adapter)\n            return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingAdapter(\"WebAuthn requires an adapter\");\n        requiredMethods.push(...webauthnMethods);\n    }\n    if (adapter) {\n        const missing = requiredMethods.filter((m) => !(m in adapter));\n        if (missing.length) {\n            return new _errors_js__WEBPACK_IMPORTED_MODULE_1__.MissingAdapterMethods(`Required adapter methods were missing: ${missing.join(\", \")}`);\n        }\n    }\n    if (!warned)\n        warned = true;\n    return warnings;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/assert.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/callback-url.js":
/*!***********************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/callback-url.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createCallbackUrl: () => (/* binding */ createCallbackUrl)\n/* harmony export */ });\n/**\n * Get callback URL based on query param / cookie + validation,\n * and add it to `req.options.callbackUrl`.\n */\nasync function createCallbackUrl({ options, paramValue, cookieValue, }) {\n    const { url, callbacks } = options;\n    let callbackUrl = url.origin;\n    if (paramValue) {\n        // If callbackUrl form field or query parameter is passed try to use it if allowed\n        callbackUrl = await callbacks.redirect({\n            url: paramValue,\n            baseUrl: url.origin,\n        });\n    }\n    else if (cookieValue) {\n        // If no callbackUrl specified, try using the value from the cookie if allowed\n        callbackUrl = await callbacks.redirect({\n            url: cookieValue,\n            baseUrl: url.origin,\n        });\n    }\n    return {\n        callbackUrl,\n        // Save callback URL in a cookie so that it can be used for subsequent requests in signin/signout/callback flow\n        callbackUrlCookie: callbackUrl !== cookieValue ? callbackUrl : undefined,\n    };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvY2FsbGJhY2stdXJsLmpzIiwibWFwcGluZ3MiOiI7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLG1DQUFtQyxtQ0FBbUM7QUFDN0UsWUFBWSxpQkFBaUI7QUFDN0I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvcml6dmkvcHJvamVjdHMvYXVkaXQtbmV4dC9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvY2FsbGJhY2stdXJsLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogR2V0IGNhbGxiYWNrIFVSTCBiYXNlZCBvbiBxdWVyeSBwYXJhbSAvIGNvb2tpZSArIHZhbGlkYXRpb24sXG4gKiBhbmQgYWRkIGl0IHRvIGByZXEub3B0aW9ucy5jYWxsYmFja1VybGAuXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBjcmVhdGVDYWxsYmFja1VybCh7IG9wdGlvbnMsIHBhcmFtVmFsdWUsIGNvb2tpZVZhbHVlLCB9KSB7XG4gICAgY29uc3QgeyB1cmwsIGNhbGxiYWNrcyB9ID0gb3B0aW9ucztcbiAgICBsZXQgY2FsbGJhY2tVcmwgPSB1cmwub3JpZ2luO1xuICAgIGlmIChwYXJhbVZhbHVlKSB7XG4gICAgICAgIC8vIElmIGNhbGxiYWNrVXJsIGZvcm0gZmllbGQgb3IgcXVlcnkgcGFyYW1ldGVyIGlzIHBhc3NlZCB0cnkgdG8gdXNlIGl0IGlmIGFsbG93ZWRcbiAgICAgICAgY2FsbGJhY2tVcmwgPSBhd2FpdCBjYWxsYmFja3MucmVkaXJlY3Qoe1xuICAgICAgICAgICAgdXJsOiBwYXJhbVZhbHVlLFxuICAgICAgICAgICAgYmFzZVVybDogdXJsLm9yaWdpbixcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIGVsc2UgaWYgKGNvb2tpZVZhbHVlKSB7XG4gICAgICAgIC8vIElmIG5vIGNhbGxiYWNrVXJsIHNwZWNpZmllZCwgdHJ5IHVzaW5nIHRoZSB2YWx1ZSBmcm9tIHRoZSBjb29raWUgaWYgYWxsb3dlZFxuICAgICAgICBjYWxsYmFja1VybCA9IGF3YWl0IGNhbGxiYWNrcy5yZWRpcmVjdCh7XG4gICAgICAgICAgICB1cmw6IGNvb2tpZVZhbHVlLFxuICAgICAgICAgICAgYmFzZVVybDogdXJsLm9yaWdpbixcbiAgICAgICAgfSk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICAgIGNhbGxiYWNrVXJsLFxuICAgICAgICAvLyBTYXZlIGNhbGxiYWNrIFVSTCBpbiBhIGNvb2tpZSBzbyB0aGF0IGl0IGNhbiBiZSB1c2VkIGZvciBzdWJzZXF1ZW50IHJlcXVlc3RzIGluIHNpZ25pbi9zaWdub3V0L2NhbGxiYWNrIGZsb3dcbiAgICAgICAgY2FsbGJhY2tVcmxDb29raWU6IGNhbGxiYWNrVXJsICE9PSBjb29raWVWYWx1ZSA/IGNhbGxiYWNrVXJsIDogdW5kZWZpbmVkLFxuICAgIH07XG59XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/callback-url.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/cookie.js":
/*!*****************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/cookie.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SessionStore: () => (/* binding */ SessionStore),\n/* harmony export */   defaultCookies: () => (/* binding */ defaultCookies)\n/* harmony export */ });\nvar __classPrivateFieldSet = (undefined && undefined.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {\n    if (kind === \"m\") throw new TypeError(\"Private method is not writable\");\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a setter\");\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot write private member to an object whose class did not declare it\");\n    return (kind === \"a\" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;\n};\nvar __classPrivateFieldGet = (undefined && undefined.__classPrivateFieldGet) || function (receiver, state, kind, f) {\n    if (kind === \"a\" && !f) throw new TypeError(\"Private accessor was defined without a getter\");\n    if (typeof state === \"function\" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError(\"Cannot read private member from an object whose class did not declare it\");\n    return kind === \"m\" ? f : kind === \"a\" ? f.call(receiver) : f ? f.value : state.get(receiver);\n};\nvar _SessionStore_instances, _SessionStore_chunks, _SessionStore_option, _SessionStore_logger, _SessionStore_chunk, _SessionStore_clean;\n// Uncomment to recalculate the estimated size\n// of an empty session cookie\n// import * as cookie from \"../vendored/cookie.js\"\n// const { serialize } = cookie\n// console.log(\n//   \"Cookie estimated to be \",\n//   serialize(`__Secure.authjs.session-token.0`, \"\", {\n//     expires: new Date(),\n//     httpOnly: true,\n//     maxAge: Number.MAX_SAFE_INTEGER,\n//     path: \"/\",\n//     sameSite: \"strict\",\n//     secure: true,\n//     domain: \"example.com\",\n//   }).length,\n//   \" bytes\"\n// )\nconst ALLOWED_COOKIE_SIZE = 4096;\n// Based on commented out section above\nconst ESTIMATED_EMPTY_COOKIE_SIZE = 160;\nconst CHUNK_SIZE = ALLOWED_COOKIE_SIZE - ESTIMATED_EMPTY_COOKIE_SIZE;\n/**\n * Use secure cookies if the site uses HTTPS\n * This being conditional allows cookies to work non-HTTPS development URLs\n * Honour secure cookie option, which sets 'secure' and also adds '__Secure-'\n * prefix, but enable them by default if the site URL is HTTPS; but not for\n * non-HTTPS URLs like http://localhost which are used in development).\n * For more on prefixes see https://googlechrome.github.io/samples/cookie-prefixes/\n *\n * @TODO Review cookie settings (names, options)\n */\nfunction defaultCookies(useSecureCookies) {\n    const cookiePrefix = useSecureCookies ? \"__Secure-\" : \"\";\n    return {\n        // default cookie options\n        sessionToken: {\n            name: `${cookiePrefix}authjs.session-token`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n            },\n        },\n        callbackUrl: {\n            name: `${cookiePrefix}authjs.callback-url`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n            },\n        },\n        csrfToken: {\n            // Default to __Host- for CSRF token for additional protection if using useSecureCookies\n            // NB: The `__Host-` prefix is stricter than the `__Secure-` prefix.\n            name: `${useSecureCookies ? \"__Host-\" : \"\"}authjs.csrf-token`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n            },\n        },\n        pkceCodeVerifier: {\n            name: `${cookiePrefix}authjs.pkce.code_verifier`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n                maxAge: 60 * 15, // 15 minutes in seconds\n            },\n        },\n        state: {\n            name: `${cookiePrefix}authjs.state`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n                maxAge: 60 * 15, // 15 minutes in seconds\n            },\n        },\n        nonce: {\n            name: `${cookiePrefix}authjs.nonce`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n            },\n        },\n        webauthnChallenge: {\n            name: `${cookiePrefix}authjs.challenge`,\n            options: {\n                httpOnly: true,\n                sameSite: \"lax\",\n                path: \"/\",\n                secure: useSecureCookies,\n                maxAge: 60 * 15, // 15 minutes in seconds\n            },\n        },\n    };\n}\nclass SessionStore {\n    constructor(option, cookies, logger) {\n        _SessionStore_instances.add(this);\n        _SessionStore_chunks.set(this, {});\n        _SessionStore_option.set(this, void 0);\n        _SessionStore_logger.set(this, void 0);\n        __classPrivateFieldSet(this, _SessionStore_logger, logger, \"f\");\n        __classPrivateFieldSet(this, _SessionStore_option, option, \"f\");\n        if (!cookies)\n            return;\n        const { name: sessionCookiePrefix } = option;\n        for (const [name, value] of Object.entries(cookies)) {\n            if (!name.startsWith(sessionCookiePrefix) || !value)\n                continue;\n            __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")[name] = value;\n        }\n    }\n    /**\n     * The JWT Session or database Session ID\n     * constructed from the cookie chunks.\n     */\n    get value() {\n        // Sort the chunks by their keys before joining\n        const sortedKeys = Object.keys(__classPrivateFieldGet(this, _SessionStore_chunks, \"f\")).sort((a, b) => {\n            const aSuffix = parseInt(a.split(\".\").pop() || \"0\");\n            const bSuffix = parseInt(b.split(\".\").pop() || \"0\");\n            return aSuffix - bSuffix;\n        });\n        // Use the sorted keys to join the chunks in the correct order\n        return sortedKeys.map((key) => __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")[key]).join(\"\");\n    }\n    /**\n     * Given a cookie value, return new cookies, chunked, to fit the allowed cookie size.\n     * If the cookie has changed from chunked to unchunked or vice versa,\n     * it deletes the old cookies as well.\n     */\n    chunk(value, options) {\n        // Assume all cookies should be cleaned by default\n        const cookies = __classPrivateFieldGet(this, _SessionStore_instances, \"m\", _SessionStore_clean).call(this);\n        // Calculate new chunks\n        const chunked = __classPrivateFieldGet(this, _SessionStore_instances, \"m\", _SessionStore_chunk).call(this, {\n            name: __classPrivateFieldGet(this, _SessionStore_option, \"f\").name,\n            value,\n            options: { ...__classPrivateFieldGet(this, _SessionStore_option, \"f\").options, ...options },\n        });\n        // Update stored chunks / cookies\n        for (const chunk of chunked) {\n            cookies[chunk.name] = chunk;\n        }\n        return Object.values(cookies);\n    }\n    /** Returns a list of cookies that should be cleaned. */\n    clean() {\n        return Object.values(__classPrivateFieldGet(this, _SessionStore_instances, \"m\", _SessionStore_clean).call(this));\n    }\n}\n_SessionStore_chunks = new WeakMap(), _SessionStore_option = new WeakMap(), _SessionStore_logger = new WeakMap(), _SessionStore_instances = new WeakSet(), _SessionStore_chunk = function _SessionStore_chunk(cookie) {\n    const chunkCount = Math.ceil(cookie.value.length / CHUNK_SIZE);\n    if (chunkCount === 1) {\n        __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")[cookie.name] = cookie.value;\n        return [cookie];\n    }\n    const cookies = [];\n    for (let i = 0; i < chunkCount; i++) {\n        const name = `${cookie.name}.${i}`;\n        const value = cookie.value.substr(i * CHUNK_SIZE, CHUNK_SIZE);\n        cookies.push({ ...cookie, name, value });\n        __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")[name] = value;\n    }\n    __classPrivateFieldGet(this, _SessionStore_logger, \"f\").debug(\"CHUNKING_SESSION_COOKIE\", {\n        message: `Session cookie exceeds allowed ${ALLOWED_COOKIE_SIZE} bytes.`,\n        emptyCookieSize: ESTIMATED_EMPTY_COOKIE_SIZE,\n        valueSize: cookie.value.length,\n        chunks: cookies.map((c) => c.value.length + ESTIMATED_EMPTY_COOKIE_SIZE),\n    });\n    return cookies;\n}, _SessionStore_clean = function _SessionStore_clean() {\n    const cleanedChunks = {};\n    for (const name in __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")) {\n        delete __classPrivateFieldGet(this, _SessionStore_chunks, \"f\")?.[name];\n        cleanedChunks[name] = {\n            name,\n            value: \"\",\n            options: { ...__classPrivateFieldGet(this, _SessionStore_option, \"f\").options, maxAge: 0 },\n        };\n    }\n    return cleanedChunks;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/cookie.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/date.js":
/*!***************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/date.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   fromDate: () => (/* binding */ fromDate)\n/* harmony export */ });\n/**\n * Takes a number in seconds and returns the date in the future.\n * Optionally takes a second date parameter. In that case\n * the date in the future will be calculated from that date instead of now.\n */\nfunction fromDate(time, date = Date.now()) {\n    return new Date(date + time * 1000);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvZGF0ZS5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPO0FBQ1A7QUFDQSIsInNvdXJjZXMiOlsiL2hvbWUvcml6dmkvcHJvamVjdHMvYXVkaXQtbmV4dC9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvZGF0ZS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFRha2VzIGEgbnVtYmVyIGluIHNlY29uZHMgYW5kIHJldHVybnMgdGhlIGRhdGUgaW4gdGhlIGZ1dHVyZS5cbiAqIE9wdGlvbmFsbHkgdGFrZXMgYSBzZWNvbmQgZGF0ZSBwYXJhbWV0ZXIuIEluIHRoYXQgY2FzZVxuICogdGhlIGRhdGUgaW4gdGhlIGZ1dHVyZSB3aWxsIGJlIGNhbGN1bGF0ZWQgZnJvbSB0aGF0IGRhdGUgaW5zdGVhZCBvZiBub3cuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBmcm9tRGF0ZSh0aW1lLCBkYXRlID0gRGF0ZS5ub3coKSkge1xuICAgIHJldHVybiBuZXcgRGF0ZShkYXRlICsgdGltZSAqIDEwMDApO1xufVxuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/date.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/env.js":
/*!**************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/env.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createActionURL: () => (/* binding */ createActionURL),\n/* harmony export */   setEnvDefaults: () => (/* binding */ setEnvDefaults)\n/* harmony export */ });\n/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./logger.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/logger.js\");\n\n/**\n *  Set default env variables on the config object\n * @param suppressWarnings intended for framework authors.\n */\nfunction setEnvDefaults(envObject, config, suppressBasePathWarning = false) {\n    try {\n        const url = envObject.AUTH_URL;\n        if (url) {\n            if (config.basePath) {\n                if (!suppressBasePathWarning) {\n                    const logger = (0,_logger_js__WEBPACK_IMPORTED_MODULE_0__.setLogger)(config);\n                    logger.warn(\"env-url-basepath-redundant\");\n                }\n            }\n            else {\n                config.basePath = new URL(url).pathname;\n            }\n        }\n    }\n    catch {\n        // Catching and swallowing potential URL parsing errors, we'll fall\n        // back to `/auth` below.\n    }\n    finally {\n        config.basePath ?? (config.basePath = `/auth`);\n    }\n    if (!config.secret?.length) {\n        config.secret = [];\n        const secret = envObject.AUTH_SECRET;\n        if (secret)\n            config.secret.push(secret);\n        for (const i of [1, 2, 3]) {\n            const secret = envObject[`AUTH_SECRET_${i}`];\n            if (secret)\n                config.secret.unshift(secret);\n        }\n    }\n    config.redirectProxyUrl ?? (config.redirectProxyUrl = envObject.AUTH_REDIRECT_PROXY_URL);\n    config.trustHost ?? (config.trustHost = !!(envObject.AUTH_URL ??\n        envObject.AUTH_TRUST_HOST ??\n        envObject.VERCEL ??\n        envObject.CF_PAGES ??\n        envObject.NODE_ENV !== \"production\"));\n    config.providers = config.providers.map((provider) => {\n        const { id } = typeof provider === \"function\" ? provider({}) : provider;\n        const ID = id.toUpperCase().replace(/-/g, \"_\");\n        const clientId = envObject[`AUTH_${ID}_ID`];\n        const clientSecret = envObject[`AUTH_${ID}_SECRET`];\n        const issuer = envObject[`AUTH_${ID}_ISSUER`];\n        const apiKey = envObject[`AUTH_${ID}_KEY`];\n        const finalProvider = typeof provider === \"function\"\n            ? provider({ clientId, clientSecret, issuer, apiKey })\n            : provider;\n        if (finalProvider.type === \"oauth\" || finalProvider.type === \"oidc\") {\n            finalProvider.clientId ?? (finalProvider.clientId = clientId);\n            finalProvider.clientSecret ?? (finalProvider.clientSecret = clientSecret);\n            finalProvider.issuer ?? (finalProvider.issuer = issuer);\n        }\n        else if (finalProvider.type === \"email\") {\n            finalProvider.apiKey ?? (finalProvider.apiKey = apiKey);\n        }\n        return finalProvider;\n    });\n}\nfunction createActionURL(action, protocol, headers, envObject, config) {\n    const basePath = config?.basePath;\n    const envUrl = envObject.AUTH_URL ?? envObject.NEXTAUTH_URL;\n    let url;\n    if (envUrl) {\n        url = new URL(envUrl);\n        if (basePath && basePath !== \"/\" && url.pathname !== \"/\") {\n            if (url.pathname !== basePath) {\n                const logger = (0,_logger_js__WEBPACK_IMPORTED_MODULE_0__.setLogger)(config);\n                logger.warn(\"env-url-basepath-mismatch\");\n            }\n            url.pathname = \"/\";\n        }\n    }\n    else {\n        const detectedHost = headers.get(\"x-forwarded-host\") ?? headers.get(\"host\");\n        const detectedProtocol = headers.get(\"x-forwarded-proto\") ?? protocol ?? \"https\";\n        const _protocol = detectedProtocol.endsWith(\":\")\n            ? detectedProtocol\n            : detectedProtocol + \":\";\n        url = new URL(`${_protocol}//${detectedHost}`);\n    }\n    // remove trailing slash\n    const sanitizedUrl = url.toString().replace(/\\/$/, \"\");\n    if (basePath) {\n        // remove leading and trailing slash\n        const sanitizedBasePath = basePath?.replace(/(^\\/|\\/$)/g, \"\") ?? \"\";\n        return new URL(`${sanitizedUrl}/${sanitizedBasePath}/${action}`);\n    }\n    return new URL(`${sanitizedUrl}/${action}`);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/env.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/logger.js":
/*!*****************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/logger.js ***!
  \*****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   setLogger: () => (/* binding */ setLogger)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n\nconst red = \"\\x1b[31m\";\nconst yellow = \"\\x1b[33m\";\nconst grey = \"\\x1b[90m\";\nconst reset = \"\\x1b[0m\";\nconst defaultLogger = {\n    error(error) {\n        const name = error instanceof _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError ? error.type : error.name;\n        console.error(`${red}[auth][error]${reset} ${name}: ${error.message}`);\n        if (error.cause &&\n            typeof error.cause === \"object\" &&\n            \"err\" in error.cause &&\n            error.cause.err instanceof Error) {\n            const { err, ...data } = error.cause;\n            console.error(`${red}[auth][cause]${reset}:`, err.stack);\n            if (data)\n                console.error(`${red}[auth][details]${reset}:`, JSON.stringify(data, null, 2));\n        }\n        else if (error.stack) {\n            console.error(error.stack.replace(/.*/, \"\").substring(1));\n        }\n    },\n    warn(code) {\n        const url = `https://warnings.authjs.dev`;\n        console.warn(`${yellow}[auth][warn][${code}]${reset}`, `Read more: ${url}`);\n    },\n    debug(message, metadata) {\n        console.log(`${grey}[auth][debug]:${reset} ${message}`, JSON.stringify(metadata, null, 2));\n    },\n};\n/**\n * Override the built-in logger with user's implementation.\n * Any `undefined` level will use the default logger.\n */\nfunction setLogger(config) {\n    const newLogger = {\n        ...defaultLogger,\n    };\n    // Turn off debug logging if `debug` isn't set to `true`\n    if (!config.debug)\n        newLogger.debug = () => { };\n    if (config.logger?.error)\n        newLogger.error = config.logger.error;\n    if (config.logger?.warn)\n        newLogger.warn = config.logger.warn;\n    if (config.logger?.debug)\n        newLogger.debug = config.logger.debug;\n    config.logger ?? (config.logger = newLogger);\n    return newLogger;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/logger.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/merge.js":
/*!****************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/merge.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   merge: () => (/* binding */ merge)\n/* harmony export */ });\nfunction isObject(item) {\n    return item !== null && typeof item === \"object\";\n}\n/** Deep merge two or more objects */\nfunction merge(target, ...sources) {\n    if (!sources.length)\n        return target;\n    const source = sources.shift();\n    if (isObject(target) && isObject(source)) {\n        for (const key in source) {\n            if (isObject(source[key])) {\n                if (!isObject(target[key]))\n                    target[key] = Array.isArray(source[key])\n                        ? []\n                        : {};\n                merge(target[key], source[key]);\n            }\n            else if (source[key] !== undefined)\n                target[key] = source[key];\n        }\n    }\n    return merge(target, ...sources);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvbWVyZ2UuanMiLCJtYXBwaW5ncyI6Ijs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ087QUFDUDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvbm9kZV9tb2R1bGVzL0BhdXRoL2NvcmUvbGliL3V0aWxzL21lcmdlLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImZ1bmN0aW9uIGlzT2JqZWN0KGl0ZW0pIHtcbiAgICByZXR1cm4gaXRlbSAhPT0gbnVsbCAmJiB0eXBlb2YgaXRlbSA9PT0gXCJvYmplY3RcIjtcbn1cbi8qKiBEZWVwIG1lcmdlIHR3byBvciBtb3JlIG9iamVjdHMgKi9cbmV4cG9ydCBmdW5jdGlvbiBtZXJnZSh0YXJnZXQsIC4uLnNvdXJjZXMpIHtcbiAgICBpZiAoIXNvdXJjZXMubGVuZ3RoKVxuICAgICAgICByZXR1cm4gdGFyZ2V0O1xuICAgIGNvbnN0IHNvdXJjZSA9IHNvdXJjZXMuc2hpZnQoKTtcbiAgICBpZiAoaXNPYmplY3QodGFyZ2V0KSAmJiBpc09iamVjdChzb3VyY2UpKSB7XG4gICAgICAgIGZvciAoY29uc3Qga2V5IGluIHNvdXJjZSkge1xuICAgICAgICAgICAgaWYgKGlzT2JqZWN0KHNvdXJjZVtrZXldKSkge1xuICAgICAgICAgICAgICAgIGlmICghaXNPYmplY3QodGFyZ2V0W2tleV0pKVxuICAgICAgICAgICAgICAgICAgICB0YXJnZXRba2V5XSA9IEFycmF5LmlzQXJyYXkoc291cmNlW2tleV0pXG4gICAgICAgICAgICAgICAgICAgICAgICA/IFtdXG4gICAgICAgICAgICAgICAgICAgICAgICA6IHt9O1xuICAgICAgICAgICAgICAgIG1lcmdlKHRhcmdldFtrZXldLCBzb3VyY2Vba2V5XSk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIGlmIChzb3VyY2Vba2V5XSAhPT0gdW5kZWZpbmVkKVxuICAgICAgICAgICAgICAgIHRhcmdldFtrZXldID0gc291cmNlW2tleV07XG4gICAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG1lcmdlKHRhcmdldCwgLi4uc291cmNlcyk7XG59XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/merge.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/providers.js":
/*!********************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/providers.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ parseProviders),\n/* harmony export */   isOAuth2Provider: () => (/* binding */ isOAuth2Provider),\n/* harmony export */   isOAuthProvider: () => (/* binding */ isOAuthProvider),\n/* harmony export */   isOIDCProvider: () => (/* binding */ isOIDCProvider)\n/* harmony export */ });\n/* harmony import */ var _merge_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./merge.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/merge.js\");\n/* harmony import */ var _symbols_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../symbols.js */ \"(rsc)/./node_modules/@auth/core/lib/symbols.js\");\n\n\n/**\n * Adds `signinUrl` and `callbackUrl` to each provider\n * and deep merge user-defined options.\n */\nfunction parseProviders(params) {\n    const { providerId, config } = params;\n    const url = new URL(config.basePath ?? \"/auth\", params.url.origin);\n    const providers = config.providers.map((p) => {\n        const provider = typeof p === \"function\" ? p() : p;\n        const { options: userOptions, ...defaults } = provider;\n        const id = (userOptions?.id ?? defaults.id);\n        // TODO: Support if properties have different types, e.g. authorization: string or object\n        const merged = (0,_merge_js__WEBPACK_IMPORTED_MODULE_0__.merge)(defaults, userOptions, {\n            signinUrl: `${url}/signin/${id}`,\n            callbackUrl: `${url}/callback/${id}`,\n        });\n        if (provider.type === \"oauth\" || provider.type === \"oidc\") {\n            merged.redirectProxyUrl ?? (merged.redirectProxyUrl = userOptions?.redirectProxyUrl ?? config.redirectProxyUrl);\n            const normalized = normalizeOAuth(merged);\n            // We currently don't support redirect proxies for response_mode=form_post\n            if (normalized.authorization?.url.searchParams.get(\"response_mode\") ===\n                \"form_post\") {\n                delete normalized.redirectProxyUrl;\n            }\n            // @ts-expect-error Symbols don't get merged by the `merge` function\n            // so we need to do it manually.\n            normalized[_symbols_js__WEBPACK_IMPORTED_MODULE_1__.customFetch] ?? (normalized[_symbols_js__WEBPACK_IMPORTED_MODULE_1__.customFetch] = userOptions?.[_symbols_js__WEBPACK_IMPORTED_MODULE_1__.customFetch]);\n            return normalized;\n        }\n        return merged;\n    });\n    const provider = providers.find(({ id }) => id === providerId);\n    if (providerId && !provider) {\n        const availableProviders = providers.map((p) => p.id).join(\", \");\n        throw new Error(`Provider with id \"${providerId}\" not found. Available providers: [${availableProviders}].`);\n    }\n    return { providers, provider };\n}\n// TODO: Also add discovery here, if some endpoints/config are missing.\n// We should return both a client and authorization server config.\nfunction normalizeOAuth(c) {\n    if (c.issuer)\n        c.wellKnown ?? (c.wellKnown = `${c.issuer}/.well-known/openid-configuration`);\n    const authorization = normalizeEndpoint(c.authorization, c.issuer);\n    if (authorization && !authorization.url?.searchParams.has(\"scope\")) {\n        authorization.url.searchParams.set(\"scope\", \"openid profile email\");\n    }\n    const token = normalizeEndpoint(c.token, c.issuer);\n    const userinfo = normalizeEndpoint(c.userinfo, c.issuer);\n    const checks = c.checks ?? [\"pkce\"];\n    if (c.redirectProxyUrl) {\n        if (!checks.includes(\"state\"))\n            checks.push(\"state\");\n        c.redirectProxyUrl = `${c.redirectProxyUrl}/callback/${c.id}`;\n    }\n    return {\n        ...c,\n        authorization,\n        token,\n        checks,\n        userinfo,\n        profile: c.profile ?? defaultProfile,\n        account: c.account ?? defaultAccount,\n    };\n}\n/**\n * Returns basic user profile from the userinfo response/`id_token` claims.\n * The returned `id` will become the `account.providerAccountId`. `user.id`\n * and `account.id` are auto-generated UUID's.\n *\n * The result if this function is used to create the `User` in the database.\n * @see https://authjs.dev/reference/core/adapters#user\n * @see https://openid.net/specs/openid-connect-core-1_0.html#IDToken\n * @see https://openid.net/specs/openid-connect-core-1_0.html#\n */\nconst defaultProfile = (profile) => {\n    return stripUndefined({\n        id: profile.sub ?? profile.id ?? crypto.randomUUID(),\n        name: profile.name ?? profile.nickname ?? profile.preferred_username,\n        email: profile.email,\n        image: profile.picture,\n    });\n};\n/**\n * Returns basic OAuth/OIDC values from the token response.\n * @see https://www.ietf.org/rfc/rfc6749.html#section-5.1\n * @see https://openid.net/specs/openid-connect-core-1_0.html#TokenResponse\n * @see https://authjs.dev/reference/core/adapters#account\n */\nconst defaultAccount = (account) => {\n    return stripUndefined({\n        access_token: account.access_token,\n        id_token: account.id_token,\n        refresh_token: account.refresh_token,\n        expires_at: account.expires_at,\n        scope: account.scope,\n        token_type: account.token_type,\n        session_state: account.session_state,\n    });\n};\nfunction stripUndefined(o) {\n    const result = {};\n    for (const [k, v] of Object.entries(o)) {\n        if (v !== undefined)\n            result[k] = v;\n    }\n    return result;\n}\nfunction normalizeEndpoint(e, issuer) {\n    if (!e && issuer)\n        return;\n    if (typeof e === \"string\") {\n        return { url: new URL(e) };\n    }\n    // If e.url is undefined, it's because the provider config\n    // assumes that we will use the issuer endpoint.\n    // The existence of either e.url or provider.issuer is checked in\n    // assert.ts. We fallback to \"https://authjs.dev\" to be able to pass around\n    // a valid URL even if the user only provided params.\n    // NOTE: This need to be checked when constructing the URL\n    // for the authorization, token and userinfo endpoints.\n    const url = new URL(e?.url ?? \"https://authjs.dev\");\n    if (e?.params != null) {\n        for (let [key, value] of Object.entries(e.params)) {\n            if (key === \"claims\") {\n                value = JSON.stringify(value);\n            }\n            url.searchParams.set(key, String(value));\n        }\n    }\n    return {\n        url,\n        request: e?.request,\n        conform: e?.conform,\n        ...(e?.clientPrivateKey ? { clientPrivateKey: e?.clientPrivateKey } : null),\n    };\n}\nfunction isOIDCProvider(provider) {\n    return provider.type === \"oidc\";\n}\nfunction isOAuth2Provider(provider) {\n    return provider.type === \"oauth\";\n}\n/** Either OAuth 2 or OIDC */\nfunction isOAuthProvider(provider) {\n    return provider.type === \"oauth\" || provider.type === \"oidc\";\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/providers.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/session.js":
/*!******************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/session.js ***!
  \******************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getLoggedInUser: () => (/* binding */ getLoggedInUser)\n/* harmony export */ });\n/**\n * Returns the currently logged in user, if any.\n */\nasync function getLoggedInUser(options, sessionStore) {\n    const { adapter, jwt, session: { strategy: sessionStrategy }, } = options;\n    const sessionToken = sessionStore.value;\n    if (!sessionToken)\n        return null;\n    // Try to decode JWT\n    if (sessionStrategy === \"jwt\") {\n        const salt = options.cookies.sessionToken.name;\n        const payload = await jwt.decode({ ...jwt, token: sessionToken, salt });\n        if (payload && payload.sub) {\n            return {\n                id: payload.sub,\n                name: payload.name,\n                email: payload.email,\n                image: payload.picture,\n            };\n        }\n    }\n    else {\n        const userAndSession = await adapter?.getSessionAndUser(sessionToken);\n        if (userAndSession) {\n            return userAndSession.user;\n        }\n    }\n    return null;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvc2Vzc2lvbi5qcyIsIm1hcHBpbmdzIjoiOzs7O0FBQUE7QUFDQTtBQUNBO0FBQ087QUFDUCxZQUFZLHlCQUF5QiwyQkFBMkIsSUFBSTtBQUNwRTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSwyQ0FBMkMsbUNBQW1DO0FBQzlFO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvbm9kZV9tb2R1bGVzL0BhdXRoL2NvcmUvbGliL3V0aWxzL3Nlc3Npb24uanMiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBSZXR1cm5zIHRoZSBjdXJyZW50bHkgbG9nZ2VkIGluIHVzZXIsIGlmIGFueS5cbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldExvZ2dlZEluVXNlcihvcHRpb25zLCBzZXNzaW9uU3RvcmUpIHtcbiAgICBjb25zdCB7IGFkYXB0ZXIsIGp3dCwgc2Vzc2lvbjogeyBzdHJhdGVneTogc2Vzc2lvblN0cmF0ZWd5IH0sIH0gPSBvcHRpb25zO1xuICAgIGNvbnN0IHNlc3Npb25Ub2tlbiA9IHNlc3Npb25TdG9yZS52YWx1ZTtcbiAgICBpZiAoIXNlc3Npb25Ub2tlbilcbiAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgLy8gVHJ5IHRvIGRlY29kZSBKV1RcbiAgICBpZiAoc2Vzc2lvblN0cmF0ZWd5ID09PSBcImp3dFwiKSB7XG4gICAgICAgIGNvbnN0IHNhbHQgPSBvcHRpb25zLmNvb2tpZXMuc2Vzc2lvblRva2VuLm5hbWU7XG4gICAgICAgIGNvbnN0IHBheWxvYWQgPSBhd2FpdCBqd3QuZGVjb2RlKHsgLi4uand0LCB0b2tlbjogc2Vzc2lvblRva2VuLCBzYWx0IH0pO1xuICAgICAgICBpZiAocGF5bG9hZCAmJiBwYXlsb2FkLnN1Yikge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBpZDogcGF5bG9hZC5zdWIsXG4gICAgICAgICAgICAgICAgbmFtZTogcGF5bG9hZC5uYW1lLFxuICAgICAgICAgICAgICAgIGVtYWlsOiBwYXlsb2FkLmVtYWlsLFxuICAgICAgICAgICAgICAgIGltYWdlOiBwYXlsb2FkLnBpY3R1cmUsXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICBjb25zdCB1c2VyQW5kU2Vzc2lvbiA9IGF3YWl0IGFkYXB0ZXI/LmdldFNlc3Npb25BbmRVc2VyKHNlc3Npb25Ub2tlbik7XG4gICAgICAgIGlmICh1c2VyQW5kU2Vzc2lvbikge1xuICAgICAgICAgICAgcmV0dXJuIHVzZXJBbmRTZXNzaW9uLnVzZXI7XG4gICAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG51bGw7XG59XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/session.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/web.js":
/*!**************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/web.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   createHash: () => (/* binding */ createHash),\n/* harmony export */   parseActionAndProviderId: () => (/* binding */ parseActionAndProviderId),\n/* harmony export */   randomString: () => (/* binding */ randomString),\n/* harmony export */   toInternalRequest: () => (/* binding */ toInternalRequest),\n/* harmony export */   toRequest: () => (/* binding */ toRequest),\n/* harmony export */   toResponse: () => (/* binding */ toResponse)\n/* harmony export */ });\n/* harmony import */ var _vendored_cookie_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vendored/cookie.js */ \"(rsc)/./node_modules/@auth/core/lib/vendored/cookie.js\");\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./logger.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/logger.js\");\n/* harmony import */ var _actions_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./actions.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/actions.js\");\n\n\n\n\nconst { parse: parseCookie, serialize: serializeCookie } = _vendored_cookie_js__WEBPACK_IMPORTED_MODULE_0__;\nasync function getBody(req) {\n    if (!(\"body\" in req) || !req.body || req.method !== \"POST\")\n        return;\n    const contentType = req.headers.get(\"content-type\");\n    if (contentType?.includes(\"application/json\")) {\n        return await req.json();\n    }\n    else if (contentType?.includes(\"application/x-www-form-urlencoded\")) {\n        const params = new URLSearchParams(await req.text());\n        return Object.fromEntries(params);\n    }\n}\nasync function toInternalRequest(req, config) {\n    try {\n        if (req.method !== \"GET\" && req.method !== \"POST\")\n            throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnknownAction(\"Only GET and POST requests are supported\");\n        // Defaults are usually set in the `init` function, but this is needed below\n        config.basePath ?? (config.basePath = \"/auth\");\n        const url = new URL(req.url);\n        const { action, providerId } = parseActionAndProviderId(url.pathname, config.basePath);\n        return {\n            url,\n            action,\n            providerId,\n            method: req.method,\n            headers: Object.fromEntries(req.headers),\n            body: req.body ? await getBody(req) : undefined,\n            cookies: parseCookie(req.headers.get(\"cookie\") ?? \"\") ?? {},\n            error: url.searchParams.get(\"error\") ?? undefined,\n            query: Object.fromEntries(url.searchParams),\n        };\n    }\n    catch (e) {\n        const logger = (0,_logger_js__WEBPACK_IMPORTED_MODULE_2__.setLogger)(config);\n        logger.error(e);\n        logger.debug(\"request\", req);\n    }\n}\nfunction toRequest(request) {\n    return new Request(request.url, {\n        headers: request.headers,\n        method: request.method,\n        body: request.method === \"POST\"\n            ? JSON.stringify(request.body ?? {})\n            : undefined,\n    });\n}\nfunction toResponse(res) {\n    const headers = new Headers(res.headers);\n    res.cookies?.forEach((cookie) => {\n        const { name, value, options } = cookie;\n        const cookieHeader = serializeCookie(name, value, options);\n        if (headers.has(\"Set-Cookie\"))\n            headers.append(\"Set-Cookie\", cookieHeader);\n        else\n            headers.set(\"Set-Cookie\", cookieHeader);\n    });\n    let body = res.body;\n    if (headers.get(\"content-type\") === \"application/json\")\n        body = JSON.stringify(res.body);\n    else if (headers.get(\"content-type\") === \"application/x-www-form-urlencoded\")\n        body = new URLSearchParams(res.body).toString();\n    const status = res.redirect ? 302 : (res.status ?? 200);\n    const response = new Response(body, { headers, status });\n    if (res.redirect)\n        response.headers.set(\"Location\", res.redirect);\n    return response;\n}\n/** Web compatible method to create a hash, using SHA256 */\nasync function createHash(message) {\n    const data = new TextEncoder().encode(message);\n    const hash = await crypto.subtle.digest(\"SHA-256\", data);\n    return Array.from(new Uint8Array(hash))\n        .map((b) => b.toString(16).padStart(2, \"0\"))\n        .join(\"\")\n        .toString();\n}\n/** Web compatible method to create a random string of a given length */\nfunction randomString(size) {\n    const i2hex = (i) => (\"0\" + i.toString(16)).slice(-2);\n    const r = (a, i) => a + i2hex(i);\n    const bytes = crypto.getRandomValues(new Uint8Array(size));\n    return Array.from(bytes).reduce(r, \"\");\n}\n/** @internal Parse the action and provider id from a URL pathname. */\nfunction parseActionAndProviderId(pathname, base) {\n    const a = pathname.match(new RegExp(`^${base}(.+)`));\n    if (a === null)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnknownAction(`Cannot parse action at ${pathname}`);\n    const actionAndProviderId = a.at(-1);\n    const b = actionAndProviderId.replace(/^\\//, \"\").split(\"/\").filter(Boolean);\n    if (b.length !== 1 && b.length !== 2)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnknownAction(`Cannot parse action at ${pathname}`);\n    const [action, providerId] = b;\n    if (!(0,_actions_js__WEBPACK_IMPORTED_MODULE_3__.isAuthAction)(action))\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnknownAction(`Cannot parse action at ${pathname}`);\n    if (providerId &&\n        ![\"signin\", \"callback\", \"webauthn-options\"].includes(action))\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_1__.UnknownAction(`Cannot parse action at ${pathname}`);\n    return { action, providerId };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/web.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/webauthn-client.js":
/*!**************************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/webauthn-client.js ***!
  \**************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   webauthnScript: () => (/* binding */ webauthnScript)\n/* harmony export */ });\n//@ts-check\n// Declare a SimpleWebAuthnBrowser variable as part of \"window\"\n/** @typedef {\"authenticate\"} WebAuthnAuthenticate */\n/** @typedef {\"register\"} WebAuthnRegister */\n/** @typedef {WebAuthnRegister | WebAuthnAuthenticate} WebAuthnOptionsAction */\n/**\n * @template {WebAuthnOptionsAction} T\n * @typedef {T extends WebAuthnAuthenticate ?\n *  { options: import(\"@simplewebauthn/types\").PublicKeyCredentialRequestOptionsJSON; action: \"authenticate\" } :\n *  T extends WebAuthnRegister ?\n *  { options: import(\"@simplewebauthn/types\").PublicKeyCredentialCreationOptionsJSON; action: \"register\" } :\n * never\n * } WebAuthnOptionsReturn\n */\n/**\n * webauthnScript is the client-side script that handles the webauthn form\n *\n * @param {string} authURL is the URL of the auth API\n * @param {string} providerID is the ID of the webauthn provider\n */\nasync function webauthnScript(authURL, providerID) {\n    /** @type {typeof import(\"@simplewebauthn/browser\")} */\n    // @ts-ignore\n    const WebAuthnBrowser = window.SimpleWebAuthnBrowser;\n    /**\n     * Fetch webauthn options from the server\n     *\n     * @template {WebAuthnOptionsAction} T\n     * @param {T | undefined} action action to fetch options for\n     * @returns {Promise<WebAuthnOptionsReturn<T> | undefined>}\n     */\n    async function fetchOptions(action) {\n        // Create the options URL with the action and query parameters\n        const url = new URL(`${authURL}/webauthn-options/${providerID}`);\n        if (action)\n            url.searchParams.append(\"action\", action);\n        const formFields = getFormFields();\n        formFields.forEach((field) => {\n            url.searchParams.append(field.name, field.value);\n        });\n        const res = await fetch(url);\n        if (!res.ok) {\n            console.error(\"Failed to fetch options\", res);\n            return;\n        }\n        return res.json();\n    }\n    /**\n     * Get the webauthn form from the page\n     *\n     * @returns {HTMLFormElement}\n     */\n    function getForm() {\n        const formID = `#${providerID}-form`;\n        /** @type {HTMLFormElement | null} */\n        const form = document.querySelector(formID);\n        if (!form)\n            throw new Error(`Form '${formID}' not found`);\n        return form;\n    }\n    /**\n     * Get formFields from the form\n     *\n     * @returns {HTMLInputElement[]}\n     */\n    function getFormFields() {\n        const form = getForm();\n        /** @type {HTMLInputElement[]} */\n        const formFields = Array.from(form.querySelectorAll(\"input[data-form-field]\"));\n        return formFields;\n    }\n    /**\n     * Passkey form submission handler.\n     * Takes the input from the form and a few other parameters and submits it to the server.\n     *\n     * @param {WebAuthnOptionsAction} action action to submit\n     * @param {unknown | undefined} data optional data to submit\n     * @returns {Promise<void>}\n     */\n    async function submitForm(action, data) {\n        const form = getForm();\n        // If a POST request, create hidden fields in the form\n        // and submit it so the browser redirects on login\n        if (action) {\n            const actionInput = document.createElement(\"input\");\n            actionInput.type = \"hidden\";\n            actionInput.name = \"action\";\n            actionInput.value = action;\n            form.appendChild(actionInput);\n        }\n        if (data) {\n            const dataInput = document.createElement(\"input\");\n            dataInput.type = \"hidden\";\n            dataInput.name = \"data\";\n            dataInput.value = JSON.stringify(data);\n            form.appendChild(dataInput);\n        }\n        return form.submit();\n    }\n    /**\n     * Executes the authentication flow by fetching options from the server,\n     * starting the authentication, and submitting the response to the server.\n     *\n     * @param {WebAuthnOptionsReturn<WebAuthnAuthenticate>['options']} options\n     * @param {boolean} autofill Whether or not to use the browser's autofill\n     * @returns {Promise<void>}\n     */\n    async function authenticationFlow(options, autofill) {\n        // Start authentication\n        const authResp = await WebAuthnBrowser.startAuthentication(options, autofill);\n        // Submit authentication response to server\n        return await submitForm(\"authenticate\", authResp);\n    }\n    /**\n     * @param {WebAuthnOptionsReturn<WebAuthnRegister>['options']} options\n     */\n    async function registrationFlow(options) {\n        // Check if all required formFields are set\n        const formFields = getFormFields();\n        formFields.forEach((field) => {\n            if (field.required && !field.value) {\n                throw new Error(`Missing required field: ${field.name}`);\n            }\n        });\n        // Start registration\n        const regResp = await WebAuthnBrowser.startRegistration(options);\n        // Submit registration response to server\n        return await submitForm(\"register\", regResp);\n    }\n    /**\n     * Attempts to authenticate the user when the page loads\n     * using the browser's autofill popup.\n     *\n     * @returns {Promise<void>}\n     */\n    async function autofillAuthentication() {\n        // if the browser can't handle autofill, don't try\n        if (!WebAuthnBrowser.browserSupportsWebAuthnAutofill())\n            return;\n        const res = await fetchOptions(\"authenticate\");\n        if (!res) {\n            console.error(\"Failed to fetch option for autofill authentication\");\n            return;\n        }\n        try {\n            await authenticationFlow(res.options, true);\n        }\n        catch (e) {\n            console.error(e);\n        }\n    }\n    /**\n     * Sets up the passkey form by overriding the form submission handler\n     * so that it attempts to authenticate the user when the form is submitted.\n     * If the user is not registered, it will attempt to register them instead.\n     */\n    async function setupForm() {\n        const form = getForm();\n        // If the browser can't do WebAuthn, hide the form\n        if (!WebAuthnBrowser.browserSupportsWebAuthn()) {\n            form.style.display = \"none\";\n            return;\n        }\n        if (form) {\n            form.addEventListener(\"submit\", async (e) => {\n                e.preventDefault();\n                // Fetch options from the server without assuming that\n                // the user is registered\n                const res = await fetchOptions(undefined);\n                if (!res) {\n                    console.error(\"Failed to fetch options for form submission\");\n                    return;\n                }\n                // Then execute the appropriate flow\n                if (res.action === \"authenticate\") {\n                    try {\n                        await authenticationFlow(res.options, false);\n                    }\n                    catch (e) {\n                        console.error(e);\n                    }\n                }\n                else if (res.action === \"register\") {\n                    try {\n                        await registrationFlow(res.options);\n                    }\n                    catch (e) {\n                        console.error(e);\n                    }\n                }\n            });\n        }\n    }\n    // On page load, setup the form and attempt to authenticate the user.\n    setupForm();\n    autofillAuthentication();\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/webauthn-client.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/utils/webauthn-utils.js":
/*!*************************************************************!*\
  !*** ./node_modules/@auth/core/lib/utils/webauthn-utils.js ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   assertInternalOptionsWebAuthn: () => (/* binding */ assertInternalOptionsWebAuthn),\n/* harmony export */   fromBase64: () => (/* binding */ fromBase64),\n/* harmony export */   getAuthenticationResponse: () => (/* binding */ getAuthenticationResponse),\n/* harmony export */   getRegistrationResponse: () => (/* binding */ getRegistrationResponse),\n/* harmony export */   inferWebAuthnOptions: () => (/* binding */ inferWebAuthnOptions),\n/* harmony export */   stringToTransports: () => (/* binding */ stringToTransports),\n/* harmony export */   toBase64: () => (/* binding */ toBase64),\n/* harmony export */   transportsToString: () => (/* binding */ transportsToString),\n/* harmony export */   verifyAuthenticate: () => (/* binding */ verifyAuthenticate),\n/* harmony export */   verifyRegister: () => (/* binding */ verifyRegister)\n/* harmony export */ });\n/* harmony import */ var _errors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../errors.js */ \"(rsc)/./node_modules/@auth/core/errors.js\");\n/* harmony import */ var _actions_callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../actions/callback/oauth/checks.js */ \"(rsc)/./node_modules/@auth/core/lib/actions/callback/oauth/checks.js\");\n/* harmony import */ var _web_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./web.js */ \"(rsc)/./node_modules/@auth/core/lib/utils/web.js\");\n\n\n\n/**\n * Infers the WebAuthn options based on the provided parameters.\n *\n * @param action - The WebAuthn action to perform (optional).\n * @param loggedInUser - The logged-in user (optional).\n * @param userInfoResponse - The response containing user information (optional).\n *\n * @returns The WebAuthn action to perform, or null if no inference could be made.\n */\nfunction inferWebAuthnOptions(action, loggedIn, userInfoResponse) {\n    const { user, exists = false } = userInfoResponse ?? {};\n    switch (action) {\n        case \"authenticate\": {\n            /**\n             * Always allow explicit authentication requests.\n             */\n            return \"authenticate\";\n        }\n        case \"register\": {\n            /**\n             * Registration is only allowed if:\n             * - The user is logged in, meaning the user wants to register a new authenticator.\n             * - The user is not logged in and provided user info that does NOT exist, meaning the user wants to register a new account.\n             */\n            if (user && loggedIn === exists)\n                return \"register\";\n            break;\n        }\n        case undefined: {\n            /**\n             * When no explicit action is provided, we try to infer it based on the user info provided. These are the possible cases:\n             * - Logged in users must always send an explit action, so we bail out in this case.\n             * - Otherwise, if no user info is provided, the desired action is authentication without pre-defined authenticators.\n             * - Otherwise, if the user info provided is of an existing user, the desired action is authentication with their pre-defined authenticators.\n             * - Finally, if the user info provided is of a non-existing user, the desired action is registration.\n             */\n            if (!loggedIn) {\n                if (user) {\n                    if (exists) {\n                        return \"authenticate\";\n                    }\n                    else {\n                        return \"register\";\n                    }\n                }\n                else {\n                    return \"authenticate\";\n                }\n            }\n            break;\n        }\n    }\n    // No decision could be made\n    return null;\n}\n/**\n * Retrieves the registration response for WebAuthn options request.\n *\n * @param options - The internal options for WebAuthn.\n * @param request - The request object.\n * @param user - The user information.\n * @param resCookies - Optional cookies to be included in the response.\n * @returns A promise that resolves to the WebAuthnOptionsResponse.\n */\nasync function getRegistrationResponse(options, request, user, resCookies) {\n    // Get registration options\n    const regOptions = await getRegistrationOptions(options, request, user);\n    // Get signed cookie\n    const { cookie } = await _actions_callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_1__.webauthnChallenge.create(options, regOptions.challenge, user);\n    return {\n        status: 200,\n        cookies: [...(resCookies ?? []), cookie],\n        body: {\n            action: \"register\",\n            options: regOptions,\n        },\n        headers: {\n            \"Content-Type\": \"application/json\",\n        },\n    };\n}\n/**\n * Retrieves the authentication response for WebAuthn options request.\n *\n * @param options - The internal options for WebAuthn.\n * @param request - The request object.\n * @param user - Optional user information.\n * @param resCookies - Optional array of cookies to be included in the response.\n * @returns A promise that resolves to a WebAuthnOptionsResponse object.\n */\nasync function getAuthenticationResponse(options, request, user, resCookies) {\n    // Get authentication options\n    const authOptions = await getAuthenticationOptions(options, request, user);\n    // Get signed cookie\n    const { cookie } = await _actions_callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_1__.webauthnChallenge.create(options, authOptions.challenge);\n    return {\n        status: 200,\n        cookies: [...(resCookies ?? []), cookie],\n        body: {\n            action: \"authenticate\",\n            options: authOptions,\n        },\n        headers: {\n            \"Content-Type\": \"application/json\",\n        },\n    };\n}\nasync function verifyAuthenticate(options, request, resCookies) {\n    const { adapter, provider } = options;\n    // Get WebAuthn response from request body\n    const data = request.body && typeof request.body.data === \"string\"\n        ? JSON.parse(request.body.data)\n        : undefined;\n    if (!data ||\n        typeof data !== \"object\" ||\n        !(\"id\" in data) ||\n        typeof data.id !== \"string\") {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(\"Invalid WebAuthn Authentication response\");\n    }\n    // Reset the ID so we smooth out implementation differences\n    const credentialID = toBase64(fromBase64(data.id));\n    // Get authenticator from database\n    const authenticator = await adapter.getAuthenticator(credentialID);\n    if (!authenticator) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(`WebAuthn authenticator not found in database: ${JSON.stringify({\n            credentialID,\n        })}`);\n    }\n    // Get challenge from request cookies\n    const { challenge: expectedChallenge } = await _actions_callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_1__.webauthnChallenge.use(options, request.cookies, resCookies);\n    // Verify the response\n    let verification;\n    try {\n        const relayingParty = provider.getRelayingParty(options, request);\n        verification = await provider.simpleWebAuthn.verifyAuthenticationResponse({\n            ...provider.verifyAuthenticationOptions,\n            expectedChallenge,\n            response: data,\n            authenticator: fromAdapterAuthenticator(authenticator),\n            expectedOrigin: relayingParty.origin,\n            expectedRPID: relayingParty.id,\n        });\n    }\n    catch (e) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.WebAuthnVerificationError(e);\n    }\n    const { verified, authenticationInfo } = verification;\n    // Make sure the response was verified\n    if (!verified) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.WebAuthnVerificationError(\"WebAuthn authentication response could not be verified\");\n    }\n    // Update authenticator counter\n    try {\n        const { newCounter } = authenticationInfo;\n        await adapter.updateAuthenticatorCounter(authenticator.credentialID, newCounter);\n    }\n    catch (e) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AdapterError(`Failed to update authenticator counter. This may cause future authentication attempts to fail. ${JSON.stringify({\n            credentialID,\n            oldCounter: authenticator.counter,\n            newCounter: authenticationInfo.newCounter,\n        })}`, e);\n    }\n    // Get the account and user\n    const account = await adapter.getAccount(authenticator.providerAccountId, provider.id);\n    if (!account) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(`WebAuthn account not found in database: ${JSON.stringify({\n            credentialID,\n            providerAccountId: authenticator.providerAccountId,\n        })}`);\n    }\n    const user = await adapter.getUser(account.userId);\n    if (!user) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(`WebAuthn user not found in database: ${JSON.stringify({\n            credentialID,\n            providerAccountId: authenticator.providerAccountId,\n            userID: account.userId,\n        })}`);\n    }\n    return {\n        account,\n        user,\n    };\n}\nasync function verifyRegister(options, request, resCookies) {\n    const { provider } = options;\n    // Get WebAuthn response from request body\n    const data = request.body && typeof request.body.data === \"string\"\n        ? JSON.parse(request.body.data)\n        : undefined;\n    if (!data ||\n        typeof data !== \"object\" ||\n        !(\"id\" in data) ||\n        typeof data.id !== \"string\") {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(\"Invalid WebAuthn Registration response\");\n    }\n    // Get challenge from request cookies\n    const { challenge: expectedChallenge, registerData: user } = await _actions_callback_oauth_checks_js__WEBPACK_IMPORTED_MODULE_1__.webauthnChallenge.use(options, request.cookies, resCookies);\n    if (!user) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.AuthError(\"Missing user registration data in WebAuthn challenge cookie\");\n    }\n    // Verify the response\n    let verification;\n    try {\n        const relayingParty = provider.getRelayingParty(options, request);\n        verification = await provider.simpleWebAuthn.verifyRegistrationResponse({\n            ...provider.verifyRegistrationOptions,\n            expectedChallenge,\n            response: data,\n            expectedOrigin: relayingParty.origin,\n            expectedRPID: relayingParty.id,\n        });\n    }\n    catch (e) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.WebAuthnVerificationError(e);\n    }\n    // Make sure the response was verified\n    if (!verification.verified || !verification.registrationInfo) {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.WebAuthnVerificationError(\"WebAuthn registration response could not be verified\");\n    }\n    // Build a new account\n    const account = {\n        providerAccountId: toBase64(verification.registrationInfo.credentialID),\n        provider: options.provider.id,\n        type: provider.type,\n    };\n    // Build a new authenticator\n    const authenticator = {\n        providerAccountId: account.providerAccountId,\n        counter: verification.registrationInfo.counter,\n        credentialID: toBase64(verification.registrationInfo.credentialID),\n        credentialPublicKey: toBase64(verification.registrationInfo.credentialPublicKey),\n        credentialBackedUp: verification.registrationInfo.credentialBackedUp,\n        credentialDeviceType: verification.registrationInfo.credentialDeviceType,\n        transports: transportsToString(data.response\n            .transports),\n    };\n    // Return created stuff\n    return {\n        user,\n        account,\n        authenticator,\n    };\n}\n/**\n * Generates WebAuthn authentication options.\n *\n * @param options - The internal options for WebAuthn.\n * @param request - The request object.\n * @param user - Optional user information.\n * @returns The authentication options.\n */\nasync function getAuthenticationOptions(options, request, user) {\n    const { provider, adapter } = options;\n    // Get the user's authenticators.\n    const authenticators = user && user[\"id\"]\n        ? await adapter.listAuthenticatorsByUserId(user.id)\n        : null;\n    const relayingParty = provider.getRelayingParty(options, request);\n    // Return the authentication options.\n    return await provider.simpleWebAuthn.generateAuthenticationOptions({\n        ...provider.authenticationOptions,\n        rpID: relayingParty.id,\n        allowCredentials: authenticators?.map((a) => ({\n            id: fromBase64(a.credentialID),\n            type: \"public-key\",\n            transports: stringToTransports(a.transports),\n        })),\n    });\n}\n/**\n * Generates WebAuthn registration options.\n *\n * @param options - The internal options for WebAuthn.\n * @param request - The request object.\n * @param user - The user information.\n * @returns The registration options.\n */\nasync function getRegistrationOptions(options, request, user) {\n    const { provider, adapter } = options;\n    // Get the user's authenticators.\n    const authenticators = user[\"id\"]\n        ? await adapter.listAuthenticatorsByUserId(user.id)\n        : null;\n    // Generate a random user ID for the credential.\n    // We can do this because we don't use this user ID to link the\n    // credential to the user. Instead, we store actual userID in the\n    // Authenticator object and fetch it via it's credential ID.\n    const userID = (0,_web_js__WEBPACK_IMPORTED_MODULE_2__.randomString)(32);\n    const relayingParty = provider.getRelayingParty(options, request);\n    // Return the registration options.\n    return await provider.simpleWebAuthn.generateRegistrationOptions({\n        ...provider.registrationOptions,\n        userID,\n        userName: user.email,\n        userDisplayName: user.name ?? undefined,\n        rpID: relayingParty.id,\n        rpName: relayingParty.name,\n        excludeCredentials: authenticators?.map((a) => ({\n            id: fromBase64(a.credentialID),\n            type: \"public-key\",\n            transports: stringToTransports(a.transports),\n        })),\n    });\n}\nfunction assertInternalOptionsWebAuthn(options) {\n    const { provider, adapter } = options;\n    // Adapter is required for WebAuthn\n    if (!adapter)\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.MissingAdapter(\"An adapter is required for the WebAuthn provider\");\n    // Provider must be WebAuthn\n    if (!provider || provider.type !== \"webauthn\") {\n        throw new _errors_js__WEBPACK_IMPORTED_MODULE_0__.InvalidProvider(\"Provider must be WebAuthn\");\n    }\n    // Narrow the options type for typed usage later\n    return { ...options, provider, adapter };\n}\nfunction fromAdapterAuthenticator(authenticator) {\n    return {\n        ...authenticator,\n        credentialDeviceType: authenticator.credentialDeviceType,\n        transports: stringToTransports(authenticator.transports),\n        credentialID: fromBase64(authenticator.credentialID),\n        credentialPublicKey: fromBase64(authenticator.credentialPublicKey),\n    };\n}\nfunction fromBase64(base64) {\n    return new Uint8Array(Buffer.from(base64, \"base64\"));\n}\nfunction toBase64(bytes) {\n    return Buffer.from(bytes).toString(\"base64\");\n}\nfunction transportsToString(transports) {\n    return transports?.join(\",\");\n}\nfunction stringToTransports(tstring) {\n    return tstring\n        ? tstring.split(\",\")\n        : undefined;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvQGF1dGgvY29yZS9saWIvdXRpbHMvd2ViYXV0aG4tdXRpbHMuanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUF1SDtBQUMvQztBQUNoQztBQUN4QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQLFlBQVksdUJBQXVCO0FBQ25DO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBLFlBQVksU0FBUyxRQUFRLGdGQUFpQjtBQUM5QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ087QUFDUDtBQUNBO0FBQ0E7QUFDQSxZQUFZLFNBQVMsUUFBUSxnRkFBaUI7QUFDOUM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNPO0FBQ1AsWUFBWSxvQkFBb0I7QUFDaEM7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixpREFBUztBQUMzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0IsaURBQVMsa0RBQWtEO0FBQzdFO0FBQ0EsU0FBUyxFQUFFO0FBQ1g7QUFDQTtBQUNBLFlBQVksK0JBQStCLFFBQVEsZ0ZBQWlCO0FBQ3BFO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLGtCQUFrQixpRUFBeUI7QUFDM0M7QUFDQSxZQUFZLCtCQUErQjtBQUMzQztBQUNBO0FBQ0Esa0JBQWtCLGlFQUF5QjtBQUMzQztBQUNBO0FBQ0E7QUFDQSxnQkFBZ0IsYUFBYTtBQUM3QjtBQUNBO0FBQ0E7QUFDQSxrQkFBa0Isb0RBQVksbUdBQW1HO0FBQ2pJO0FBQ0E7QUFDQTtBQUNBLFNBQVMsRUFBRTtBQUNYO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLGlEQUFTLDRDQUE0QztBQUN2RTtBQUNBO0FBQ0EsU0FBUyxFQUFFO0FBQ1g7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLGlEQUFTLHlDQUF5QztBQUNwRTtBQUNBO0FBQ0E7QUFDQSxTQUFTLEVBQUU7QUFDWDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQLFlBQVksV0FBVztBQUN2QjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCLGlEQUFTO0FBQzNCO0FBQ0E7QUFDQSxZQUFZLG1EQUFtRCxRQUFRLGdGQUFpQjtBQUN4RjtBQUNBLGtCQUFrQixpREFBUztBQUMzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQSxrQkFBa0IsaUVBQXlCO0FBQzNDO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQixpRUFBeUI7QUFDM0M7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLG9CQUFvQjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVCxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxZQUFZLG9CQUFvQjtBQUNoQztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsbUJBQW1CLHFEQUFZO0FBQy9CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBUztBQUNULEtBQUs7QUFDTDtBQUNPO0FBQ1AsWUFBWSxvQkFBb0I7QUFDaEM7QUFDQTtBQUNBLGtCQUFrQixzREFBYztBQUNoQztBQUNBO0FBQ0Esa0JBQWtCLHVEQUFlO0FBQ2pDO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDTztBQUNQO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L25vZGVfbW9kdWxlcy9AYXV0aC9jb3JlL2xpYi91dGlscy93ZWJhdXRobi11dGlscy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBZGFwdGVyRXJyb3IsIEF1dGhFcnJvciwgSW52YWxpZFByb3ZpZGVyLCBNaXNzaW5nQWRhcHRlciwgV2ViQXV0aG5WZXJpZmljYXRpb25FcnJvciwgfSBmcm9tIFwiLi4vLi4vZXJyb3JzLmpzXCI7XG5pbXBvcnQgeyB3ZWJhdXRobkNoYWxsZW5nZSB9IGZyb20gXCIuLi9hY3Rpb25zL2NhbGxiYWNrL29hdXRoL2NoZWNrcy5qc1wiO1xuaW1wb3J0IHsgcmFuZG9tU3RyaW5nIH0gZnJvbSBcIi4vd2ViLmpzXCI7XG4vKipcbiAqIEluZmVycyB0aGUgV2ViQXV0aG4gb3B0aW9ucyBiYXNlZCBvbiB0aGUgcHJvdmlkZWQgcGFyYW1ldGVycy5cbiAqXG4gKiBAcGFyYW0gYWN0aW9uIC0gVGhlIFdlYkF1dGhuIGFjdGlvbiB0byBwZXJmb3JtIChvcHRpb25hbCkuXG4gKiBAcGFyYW0gbG9nZ2VkSW5Vc2VyIC0gVGhlIGxvZ2dlZC1pbiB1c2VyIChvcHRpb25hbCkuXG4gKiBAcGFyYW0gdXNlckluZm9SZXNwb25zZSAtIFRoZSByZXNwb25zZSBjb250YWluaW5nIHVzZXIgaW5mb3JtYXRpb24gKG9wdGlvbmFsKS5cbiAqXG4gKiBAcmV0dXJucyBUaGUgV2ViQXV0aG4gYWN0aW9uIHRvIHBlcmZvcm0sIG9yIG51bGwgaWYgbm8gaW5mZXJlbmNlIGNvdWxkIGJlIG1hZGUuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpbmZlcldlYkF1dGhuT3B0aW9ucyhhY3Rpb24sIGxvZ2dlZEluLCB1c2VySW5mb1Jlc3BvbnNlKSB7XG4gICAgY29uc3QgeyB1c2VyLCBleGlzdHMgPSBmYWxzZSB9ID0gdXNlckluZm9SZXNwb25zZSA/PyB7fTtcbiAgICBzd2l0Y2ggKGFjdGlvbikge1xuICAgICAgICBjYXNlIFwiYXV0aGVudGljYXRlXCI6IHtcbiAgICAgICAgICAgIC8qKlxuICAgICAgICAgICAgICogQWx3YXlzIGFsbG93IGV4cGxpY2l0IGF1dGhlbnRpY2F0aW9uIHJlcXVlc3RzLlxuICAgICAgICAgICAgICovXG4gICAgICAgICAgICByZXR1cm4gXCJhdXRoZW50aWNhdGVcIjtcbiAgICAgICAgfVxuICAgICAgICBjYXNlIFwicmVnaXN0ZXJcIjoge1xuICAgICAgICAgICAgLyoqXG4gICAgICAgICAgICAgKiBSZWdpc3RyYXRpb24gaXMgb25seSBhbGxvd2VkIGlmOlxuICAgICAgICAgICAgICogLSBUaGUgdXNlciBpcyBsb2dnZWQgaW4sIG1lYW5pbmcgdGhlIHVzZXIgd2FudHMgdG8gcmVnaXN0ZXIgYSBuZXcgYXV0aGVudGljYXRvci5cbiAgICAgICAgICAgICAqIC0gVGhlIHVzZXIgaXMgbm90IGxvZ2dlZCBpbiBhbmQgcHJvdmlkZWQgdXNlciBpbmZvIHRoYXQgZG9lcyBOT1QgZXhpc3QsIG1lYW5pbmcgdGhlIHVzZXIgd2FudHMgdG8gcmVnaXN0ZXIgYSBuZXcgYWNjb3VudC5cbiAgICAgICAgICAgICAqL1xuICAgICAgICAgICAgaWYgKHVzZXIgJiYgbG9nZ2VkSW4gPT09IGV4aXN0cylcbiAgICAgICAgICAgICAgICByZXR1cm4gXCJyZWdpc3RlclwiO1xuICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICAgICAgY2FzZSB1bmRlZmluZWQ6IHtcbiAgICAgICAgICAgIC8qKlxuICAgICAgICAgICAgICogV2hlbiBubyBleHBsaWNpdCBhY3Rpb24gaXMgcHJvdmlkZWQsIHdlIHRyeSB0byBpbmZlciBpdCBiYXNlZCBvbiB0aGUgdXNlciBpbmZvIHByb3ZpZGVkLiBUaGVzZSBhcmUgdGhlIHBvc3NpYmxlIGNhc2VzOlxuICAgICAgICAgICAgICogLSBMb2dnZWQgaW4gdXNlcnMgbXVzdCBhbHdheXMgc2VuZCBhbiBleHBsaXQgYWN0aW9uLCBzbyB3ZSBiYWlsIG91dCBpbiB0aGlzIGNhc2UuXG4gICAgICAgICAgICAgKiAtIE90aGVyd2lzZSwgaWYgbm8gdXNlciBpbmZvIGlzIHByb3ZpZGVkLCB0aGUgZGVzaXJlZCBhY3Rpb24gaXMgYXV0aGVudGljYXRpb24gd2l0aG91dCBwcmUtZGVmaW5lZCBhdXRoZW50aWNhdG9ycy5cbiAgICAgICAgICAgICAqIC0gT3RoZXJ3aXNlLCBpZiB0aGUgdXNlciBpbmZvIHByb3ZpZGVkIGlzIG9mIGFuIGV4aXN0aW5nIHVzZXIsIHRoZSBkZXNpcmVkIGFjdGlvbiBpcyBhdXRoZW50aWNhdGlvbiB3aXRoIHRoZWlyIHByZS1kZWZpbmVkIGF1dGhlbnRpY2F0b3JzLlxuICAgICAgICAgICAgICogLSBGaW5hbGx5LCBpZiB0aGUgdXNlciBpbmZvIHByb3ZpZGVkIGlzIG9mIGEgbm9uLWV4aXN0aW5nIHVzZXIsIHRoZSBkZXNpcmVkIGFjdGlvbiBpcyByZWdpc3RyYXRpb24uXG4gICAgICAgICAgICAgKi9cbiAgICAgICAgICAgIGlmICghbG9nZ2VkSW4pIHtcbiAgICAgICAgICAgICAgICBpZiAodXNlcikge1xuICAgICAgICAgICAgICAgICAgICBpZiAoZXhpc3RzKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gXCJhdXRoZW50aWNhdGVcIjtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBcInJlZ2lzdGVyXCI7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBcImF1dGhlbnRpY2F0ZVwiO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG4gICAgfVxuICAgIC8vIE5vIGRlY2lzaW9uIGNvdWxkIGJlIG1hZGVcbiAgICByZXR1cm4gbnVsbDtcbn1cbi8qKlxuICogUmV0cmlldmVzIHRoZSByZWdpc3RyYXRpb24gcmVzcG9uc2UgZm9yIFdlYkF1dGhuIG9wdGlvbnMgcmVxdWVzdC5cbiAqXG4gKiBAcGFyYW0gb3B0aW9ucyAtIFRoZSBpbnRlcm5hbCBvcHRpb25zIGZvciBXZWJBdXRobi5cbiAqIEBwYXJhbSByZXF1ZXN0IC0gVGhlIHJlcXVlc3Qgb2JqZWN0LlxuICogQHBhcmFtIHVzZXIgLSBUaGUgdXNlciBpbmZvcm1hdGlvbi5cbiAqIEBwYXJhbSByZXNDb29raWVzIC0gT3B0aW9uYWwgY29va2llcyB0byBiZSBpbmNsdWRlZCBpbiB0aGUgcmVzcG9uc2UuXG4gKiBAcmV0dXJucyBBIHByb21pc2UgdGhhdCByZXNvbHZlcyB0byB0aGUgV2ViQXV0aG5PcHRpb25zUmVzcG9uc2UuXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZXRSZWdpc3RyYXRpb25SZXNwb25zZShvcHRpb25zLCByZXF1ZXN0LCB1c2VyLCByZXNDb29raWVzKSB7XG4gICAgLy8gR2V0IHJlZ2lzdHJhdGlvbiBvcHRpb25zXG4gICAgY29uc3QgcmVnT3B0aW9ucyA9IGF3YWl0IGdldFJlZ2lzdHJhdGlvbk9wdGlvbnMob3B0aW9ucywgcmVxdWVzdCwgdXNlcik7XG4gICAgLy8gR2V0IHNpZ25lZCBjb29raWVcbiAgICBjb25zdCB7IGNvb2tpZSB9ID0gYXdhaXQgd2ViYXV0aG5DaGFsbGVuZ2UuY3JlYXRlKG9wdGlvbnMsIHJlZ09wdGlvbnMuY2hhbGxlbmdlLCB1c2VyKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBzdGF0dXM6IDIwMCxcbiAgICAgICAgY29va2llczogWy4uLihyZXNDb29raWVzID8/IFtdKSwgY29va2llXSxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgICAgYWN0aW9uOiBcInJlZ2lzdGVyXCIsXG4gICAgICAgICAgICBvcHRpb25zOiByZWdPcHRpb25zLFxuICAgICAgICB9LFxuICAgICAgICBoZWFkZXJzOiB7XG4gICAgICAgICAgICBcIkNvbnRlbnQtVHlwZVwiOiBcImFwcGxpY2F0aW9uL2pzb25cIixcbiAgICAgICAgfSxcbiAgICB9O1xufVxuLyoqXG4gKiBSZXRyaWV2ZXMgdGhlIGF1dGhlbnRpY2F0aW9uIHJlc3BvbnNlIGZvciBXZWJBdXRobiBvcHRpb25zIHJlcXVlc3QuXG4gKlxuICogQHBhcmFtIG9wdGlvbnMgLSBUaGUgaW50ZXJuYWwgb3B0aW9ucyBmb3IgV2ViQXV0aG4uXG4gKiBAcGFyYW0gcmVxdWVzdCAtIFRoZSByZXF1ZXN0IG9iamVjdC5cbiAqIEBwYXJhbSB1c2VyIC0gT3B0aW9uYWwgdXNlciBpbmZvcm1hdGlvbi5cbiAqIEBwYXJhbSByZXNDb29raWVzIC0gT3B0aW9uYWwgYXJyYXkgb2YgY29va2llcyB0byBiZSBpbmNsdWRlZCBpbiB0aGUgcmVzcG9uc2UuXG4gKiBAcmV0dXJucyBBIHByb21pc2UgdGhhdCByZXNvbHZlcyB0byBhIFdlYkF1dGhuT3B0aW9uc1Jlc3BvbnNlIG9iamVjdC5cbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldEF1dGhlbnRpY2F0aW9uUmVzcG9uc2Uob3B0aW9ucywgcmVxdWVzdCwgdXNlciwgcmVzQ29va2llcykge1xuICAgIC8vIEdldCBhdXRoZW50aWNhdGlvbiBvcHRpb25zXG4gICAgY29uc3QgYXV0aE9wdGlvbnMgPSBhd2FpdCBnZXRBdXRoZW50aWNhdGlvbk9wdGlvbnMob3B0aW9ucywgcmVxdWVzdCwgdXNlcik7XG4gICAgLy8gR2V0IHNpZ25lZCBjb29raWVcbiAgICBjb25zdCB7IGNvb2tpZSB9ID0gYXdhaXQgd2ViYXV0aG5DaGFsbGVuZ2UuY3JlYXRlKG9wdGlvbnMsIGF1dGhPcHRpb25zLmNoYWxsZW5nZSk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgc3RhdHVzOiAyMDAsXG4gICAgICAgIGNvb2tpZXM6IFsuLi4ocmVzQ29va2llcyA/PyBbXSksIGNvb2tpZV0sXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIGFjdGlvbjogXCJhdXRoZW50aWNhdGVcIixcbiAgICAgICAgICAgIG9wdGlvbnM6IGF1dGhPcHRpb25zLFxuICAgICAgICB9LFxuICAgICAgICBoZWFkZXJzOiB7XG4gICAgICAgICAgICBcIkNvbnRlbnQtVHlwZVwiOiBcImFwcGxpY2F0aW9uL2pzb25cIixcbiAgICAgICAgfSxcbiAgICB9O1xufVxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHZlcmlmeUF1dGhlbnRpY2F0ZShvcHRpb25zLCByZXF1ZXN0LCByZXNDb29raWVzKSB7XG4gICAgY29uc3QgeyBhZGFwdGVyLCBwcm92aWRlciB9ID0gb3B0aW9ucztcbiAgICAvLyBHZXQgV2ViQXV0aG4gcmVzcG9uc2UgZnJvbSByZXF1ZXN0IGJvZHlcbiAgICBjb25zdCBkYXRhID0gcmVxdWVzdC5ib2R5ICYmIHR5cGVvZiByZXF1ZXN0LmJvZHkuZGF0YSA9PT0gXCJzdHJpbmdcIlxuICAgICAgICA/IEpTT04ucGFyc2UocmVxdWVzdC5ib2R5LmRhdGEpXG4gICAgICAgIDogdW5kZWZpbmVkO1xuICAgIGlmICghZGF0YSB8fFxuICAgICAgICB0eXBlb2YgZGF0YSAhPT0gXCJvYmplY3RcIiB8fFxuICAgICAgICAhKFwiaWRcIiBpbiBkYXRhKSB8fFxuICAgICAgICB0eXBlb2YgZGF0YS5pZCAhPT0gXCJzdHJpbmdcIikge1xuICAgICAgICB0aHJvdyBuZXcgQXV0aEVycm9yKFwiSW52YWxpZCBXZWJBdXRobiBBdXRoZW50aWNhdGlvbiByZXNwb25zZVwiKTtcbiAgICB9XG4gICAgLy8gUmVzZXQgdGhlIElEIHNvIHdlIHNtb290aCBvdXQgaW1wbGVtZW50YXRpb24gZGlmZmVyZW5jZXNcbiAgICBjb25zdCBjcmVkZW50aWFsSUQgPSB0b0Jhc2U2NChmcm9tQmFzZTY0KGRhdGEuaWQpKTtcbiAgICAvLyBHZXQgYXV0aGVudGljYXRvciBmcm9tIGRhdGFiYXNlXG4gICAgY29uc3QgYXV0aGVudGljYXRvciA9IGF3YWl0IGFkYXB0ZXIuZ2V0QXV0aGVudGljYXRvcihjcmVkZW50aWFsSUQpO1xuICAgIGlmICghYXV0aGVudGljYXRvcikge1xuICAgICAgICB0aHJvdyBuZXcgQXV0aEVycm9yKGBXZWJBdXRobiBhdXRoZW50aWNhdG9yIG5vdCBmb3VuZCBpbiBkYXRhYmFzZTogJHtKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgICAgICBjcmVkZW50aWFsSUQsXG4gICAgICAgIH0pfWApO1xuICAgIH1cbiAgICAvLyBHZXQgY2hhbGxlbmdlIGZyb20gcmVxdWVzdCBjb29raWVzXG4gICAgY29uc3QgeyBjaGFsbGVuZ2U6IGV4cGVjdGVkQ2hhbGxlbmdlIH0gPSBhd2FpdCB3ZWJhdXRobkNoYWxsZW5nZS51c2Uob3B0aW9ucywgcmVxdWVzdC5jb29raWVzLCByZXNDb29raWVzKTtcbiAgICAvLyBWZXJpZnkgdGhlIHJlc3BvbnNlXG4gICAgbGV0IHZlcmlmaWNhdGlvbjtcbiAgICB0cnkge1xuICAgICAgICBjb25zdCByZWxheWluZ1BhcnR5ID0gcHJvdmlkZXIuZ2V0UmVsYXlpbmdQYXJ0eShvcHRpb25zLCByZXF1ZXN0KTtcbiAgICAgICAgdmVyaWZpY2F0aW9uID0gYXdhaXQgcHJvdmlkZXIuc2ltcGxlV2ViQXV0aG4udmVyaWZ5QXV0aGVudGljYXRpb25SZXNwb25zZSh7XG4gICAgICAgICAgICAuLi5wcm92aWRlci52ZXJpZnlBdXRoZW50aWNhdGlvbk9wdGlvbnMsXG4gICAgICAgICAgICBleHBlY3RlZENoYWxsZW5nZSxcbiAgICAgICAgICAgIHJlc3BvbnNlOiBkYXRhLFxuICAgICAgICAgICAgYXV0aGVudGljYXRvcjogZnJvbUFkYXB0ZXJBdXRoZW50aWNhdG9yKGF1dGhlbnRpY2F0b3IpLFxuICAgICAgICAgICAgZXhwZWN0ZWRPcmlnaW46IHJlbGF5aW5nUGFydHkub3JpZ2luLFxuICAgICAgICAgICAgZXhwZWN0ZWRSUElEOiByZWxheWluZ1BhcnR5LmlkLFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgY2F0Y2ggKGUpIHtcbiAgICAgICAgdGhyb3cgbmV3IFdlYkF1dGhuVmVyaWZpY2F0aW9uRXJyb3IoZSk7XG4gICAgfVxuICAgIGNvbnN0IHsgdmVyaWZpZWQsIGF1dGhlbnRpY2F0aW9uSW5mbyB9ID0gdmVyaWZpY2F0aW9uO1xuICAgIC8vIE1ha2Ugc3VyZSB0aGUgcmVzcG9uc2Ugd2FzIHZlcmlmaWVkXG4gICAgaWYgKCF2ZXJpZmllZCkge1xuICAgICAgICB0aHJvdyBuZXcgV2ViQXV0aG5WZXJpZmljYXRpb25FcnJvcihcIldlYkF1dGhuIGF1dGhlbnRpY2F0aW9uIHJlc3BvbnNlIGNvdWxkIG5vdCBiZSB2ZXJpZmllZFwiKTtcbiAgICB9XG4gICAgLy8gVXBkYXRlIGF1dGhlbnRpY2F0b3IgY291bnRlclxuICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IHsgbmV3Q291bnRlciB9ID0gYXV0aGVudGljYXRpb25JbmZvO1xuICAgICAgICBhd2FpdCBhZGFwdGVyLnVwZGF0ZUF1dGhlbnRpY2F0b3JDb3VudGVyKGF1dGhlbnRpY2F0b3IuY3JlZGVudGlhbElELCBuZXdDb3VudGVyKTtcbiAgICB9XG4gICAgY2F0Y2ggKGUpIHtcbiAgICAgICAgdGhyb3cgbmV3IEFkYXB0ZXJFcnJvcihgRmFpbGVkIHRvIHVwZGF0ZSBhdXRoZW50aWNhdG9yIGNvdW50ZXIuIFRoaXMgbWF5IGNhdXNlIGZ1dHVyZSBhdXRoZW50aWNhdGlvbiBhdHRlbXB0cyB0byBmYWlsLiAke0pTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgICAgIGNyZWRlbnRpYWxJRCxcbiAgICAgICAgICAgIG9sZENvdW50ZXI6IGF1dGhlbnRpY2F0b3IuY291bnRlcixcbiAgICAgICAgICAgIG5ld0NvdW50ZXI6IGF1dGhlbnRpY2F0aW9uSW5mby5uZXdDb3VudGVyLFxuICAgICAgICB9KX1gLCBlKTtcbiAgICB9XG4gICAgLy8gR2V0IHRoZSBhY2NvdW50IGFuZCB1c2VyXG4gICAgY29uc3QgYWNjb3VudCA9IGF3YWl0IGFkYXB0ZXIuZ2V0QWNjb3VudChhdXRoZW50aWNhdG9yLnByb3ZpZGVyQWNjb3VudElkLCBwcm92aWRlci5pZCk7XG4gICAgaWYgKCFhY2NvdW50KSB7XG4gICAgICAgIHRocm93IG5ldyBBdXRoRXJyb3IoYFdlYkF1dGhuIGFjY291bnQgbm90IGZvdW5kIGluIGRhdGFiYXNlOiAke0pTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgICAgIGNyZWRlbnRpYWxJRCxcbiAgICAgICAgICAgIHByb3ZpZGVyQWNjb3VudElkOiBhdXRoZW50aWNhdG9yLnByb3ZpZGVyQWNjb3VudElkLFxuICAgICAgICB9KX1gKTtcbiAgICB9XG4gICAgY29uc3QgdXNlciA9IGF3YWl0IGFkYXB0ZXIuZ2V0VXNlcihhY2NvdW50LnVzZXJJZCk7XG4gICAgaWYgKCF1c2VyKSB7XG4gICAgICAgIHRocm93IG5ldyBBdXRoRXJyb3IoYFdlYkF1dGhuIHVzZXIgbm90IGZvdW5kIGluIGRhdGFiYXNlOiAke0pTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgICAgIGNyZWRlbnRpYWxJRCxcbiAgICAgICAgICAgIHByb3ZpZGVyQWNjb3VudElkOiBhdXRoZW50aWNhdG9yLnByb3ZpZGVyQWNjb3VudElkLFxuICAgICAgICAgICAgdXNlcklEOiBhY2NvdW50LnVzZXJJZCxcbiAgICAgICAgfSl9YCk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICAgIGFjY291bnQsXG4gICAgICAgIHVzZXIsXG4gICAgfTtcbn1cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiB2ZXJpZnlSZWdpc3RlcihvcHRpb25zLCByZXF1ZXN0LCByZXNDb29raWVzKSB7XG4gICAgY29uc3QgeyBwcm92aWRlciB9ID0gb3B0aW9ucztcbiAgICAvLyBHZXQgV2ViQXV0aG4gcmVzcG9uc2UgZnJvbSByZXF1ZXN0IGJvZHlcbiAgICBjb25zdCBkYXRhID0gcmVxdWVzdC5ib2R5ICYmIHR5cGVvZiByZXF1ZXN0LmJvZHkuZGF0YSA9PT0gXCJzdHJpbmdcIlxuICAgICAgICA/IEpTT04ucGFyc2UocmVxdWVzdC5ib2R5LmRhdGEpXG4gICAgICAgIDogdW5kZWZpbmVkO1xuICAgIGlmICghZGF0YSB8fFxuICAgICAgICB0eXBlb2YgZGF0YSAhPT0gXCJvYmplY3RcIiB8fFxuICAgICAgICAhKFwiaWRcIiBpbiBkYXRhKSB8fFxuICAgICAgICB0eXBlb2YgZGF0YS5pZCAhPT0gXCJzdHJpbmdcIikge1xuICAgICAgICB0aHJvdyBuZXcgQXV0aEVycm9yKFwiSW52YWxpZCBXZWJBdXRobiBSZWdpc3RyYXRpb24gcmVzcG9uc2VcIik7XG4gICAgfVxuICAgIC8vIEdldCBjaGFsbGVuZ2UgZnJvbSByZXF1ZXN0IGNvb2tpZXNcbiAgICBjb25zdCB7IGNoYWxsZW5nZTogZXhwZWN0ZWRDaGFsbGVuZ2UsIHJlZ2lzdGVyRGF0YTogdXNlciB9ID0gYXdhaXQgd2ViYXV0aG5DaGFsbGVuZ2UudXNlKG9wdGlvbnMsIHJlcXVlc3QuY29va2llcywgcmVzQ29va2llcyk7XG4gICAgaWYgKCF1c2VyKSB7XG4gICAgICAgIHRocm93IG5ldyBBdXRoRXJyb3IoXCJNaXNzaW5nIHVzZXIgcmVnaXN0cmF0aW9uIGRhdGEgaW4gV2ViQXV0aG4gY2hhbGxlbmdlIGNvb2tpZVwiKTtcbiAgICB9XG4gICAgLy8gVmVyaWZ5IHRoZSByZXNwb25zZVxuICAgIGxldCB2ZXJpZmljYXRpb247XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgcmVsYXlpbmdQYXJ0eSA9IHByb3ZpZGVyLmdldFJlbGF5aW5nUGFydHkob3B0aW9ucywgcmVxdWVzdCk7XG4gICAgICAgIHZlcmlmaWNhdGlvbiA9IGF3YWl0IHByb3ZpZGVyLnNpbXBsZVdlYkF1dGhuLnZlcmlmeVJlZ2lzdHJhdGlvblJlc3BvbnNlKHtcbiAgICAgICAgICAgIC4uLnByb3ZpZGVyLnZlcmlmeVJlZ2lzdHJhdGlvbk9wdGlvbnMsXG4gICAgICAgICAgICBleHBlY3RlZENoYWxsZW5nZSxcbiAgICAgICAgICAgIHJlc3BvbnNlOiBkYXRhLFxuICAgICAgICAgICAgZXhwZWN0ZWRPcmlnaW46IHJlbGF5aW5nUGFydHkub3JpZ2luLFxuICAgICAgICAgICAgZXhwZWN0ZWRSUElEOiByZWxheWluZ1BhcnR5LmlkLFxuICAgICAgICB9KTtcbiAgICB9XG4gICAgY2F0Y2ggKGUpIHtcbiAgICAgICAgdGhyb3cgbmV3IFdlYkF1dGhuVmVyaWZpY2F0aW9uRXJyb3IoZSk7XG4gICAgfVxuICAgIC8vIE1ha2Ugc3VyZSB0aGUgcmVzcG9uc2Ugd2FzIHZlcmlmaWVkXG4gICAgaWYgKCF2ZXJpZmljYXRpb24udmVyaWZpZWQgfHwgIXZlcmlmaWNhdGlvbi5yZWdpc3RyYXRpb25JbmZvKSB7XG4gICAgICAgIHRocm93IG5ldyBXZWJBdXRoblZlcmlmaWNhdGlvbkVycm9yKFwiV2ViQXV0aG4gcmVnaXN0cmF0aW9uIHJlc3BvbnNlIGNvdWxkIG5vdCBiZSB2ZXJpZmllZFwiKTtcbiAgICB9XG4gICAgLy8gQnVpbGQgYSBuZXcgYWNjb3VudFxuICAgIGNvbnN0IGFjY291bnQgPSB7XG4gICAgICAgIHByb3ZpZGVyQWNjb3VudElkOiB0b0Jhc2U2NCh2ZXJpZmljYXRpb24ucmVnaXN0cmF0aW9uSW5mby5jcmVkZW50aWFsSUQpLFxuICAgICAgICBwcm92aWRlcjogb3B0aW9ucy5wcm92aWRlci5pZCxcbiAgICAgICAgdHlwZTogcHJvdmlkZXIudHlwZSxcbiAgICB9O1xuICAgIC8vIEJ1aWxkIGEgbmV3IGF1dGhlbnRpY2F0b3JcbiAgICBjb25zdCBhdXRoZW50aWNhdG9yID0ge1xuICAgICAgICBwcm92aWRlckFjY291bnRJZDogYWNjb3VudC5wcm92aWRlckFjY291bnRJZCxcbiAgICAgICAgY291bnRlcjogdmVyaWZpY2F0aW9uLnJlZ2lzdHJhdGlvbkluZm8uY291bnRlcixcbiAgICAgICAgY3JlZGVudGlhbElEOiB0b0Jhc2U2NCh2ZXJpZmljYXRpb24ucmVnaXN0cmF0aW9uSW5mby5jcmVkZW50aWFsSUQpLFxuICAgICAgICBjcmVkZW50aWFsUHVibGljS2V5OiB0b0Jhc2U2NCh2ZXJpZmljYXRpb24ucmVnaXN0cmF0aW9uSW5mby5jcmVkZW50aWFsUHVibGljS2V5KSxcbiAgICAgICAgY3JlZGVudGlhbEJhY2tlZFVwOiB2ZXJpZmljYXRpb24ucmVnaXN0cmF0aW9uSW5mby5jcmVkZW50aWFsQmFja2VkVXAsXG4gICAgICAgIGNyZWRlbnRpYWxEZXZpY2VUeXBlOiB2ZXJpZmljYXRpb24ucmVnaXN0cmF0aW9uSW5mby5jcmVkZW50aWFsRGV2aWNlVHlwZSxcbiAgICAgICAgdHJhbnNwb3J0czogdHJhbnNwb3J0c1RvU3RyaW5nKGRhdGEucmVzcG9uc2VcbiAgICAgICAgICAgIC50cmFuc3BvcnRzKSxcbiAgICB9O1xuICAgIC8vIFJldHVybiBjcmVhdGVkIHN0dWZmXG4gICAgcmV0dXJuIHtcbiAgICAgICAgdXNlcixcbiAgICAgICAgYWNjb3VudCxcbiAgICAgICAgYXV0aGVudGljYXRvcixcbiAgICB9O1xufVxuLyoqXG4gKiBHZW5lcmF0ZXMgV2ViQXV0aG4gYXV0aGVudGljYXRpb24gb3B0aW9ucy5cbiAqXG4gKiBAcGFyYW0gb3B0aW9ucyAtIFRoZSBpbnRlcm5hbCBvcHRpb25zIGZvciBXZWJBdXRobi5cbiAqIEBwYXJhbSByZXF1ZXN0IC0gVGhlIHJlcXVlc3Qgb2JqZWN0LlxuICogQHBhcmFtIHVzZXIgLSBPcHRpb25hbCB1c2VyIGluZm9ybWF0aW9uLlxuICogQHJldHVybnMgVGhlIGF1dGhlbnRpY2F0aW9uIG9wdGlvbnMuXG4gKi9cbmFzeW5jIGZ1bmN0aW9uIGdldEF1dGhlbnRpY2F0aW9uT3B0aW9ucyhvcHRpb25zLCByZXF1ZXN0LCB1c2VyKSB7XG4gICAgY29uc3QgeyBwcm92aWRlciwgYWRhcHRlciB9ID0gb3B0aW9ucztcbiAgICAvLyBHZXQgdGhlIHVzZXIncyBhdXRoZW50aWNhdG9ycy5cbiAgICBjb25zdCBhdXRoZW50aWNhdG9ycyA9IHVzZXIgJiYgdXNlcltcImlkXCJdXG4gICAgICAgID8gYXdhaXQgYWRhcHRlci5saXN0QXV0aGVudGljYXRvcnNCeVVzZXJJZCh1c2VyLmlkKVxuICAgICAgICA6IG51bGw7XG4gICAgY29uc3QgcmVsYXlpbmdQYXJ0eSA9IHByb3ZpZGVyLmdldFJlbGF5aW5nUGFydHkob3B0aW9ucywgcmVxdWVzdCk7XG4gICAgLy8gUmV0dXJuIHRoZSBhdXRoZW50aWNhdGlvbiBvcHRpb25zLlxuICAgIHJldHVybiBhd2FpdCBwcm92aWRlci5zaW1wbGVXZWJBdXRobi5nZW5lcmF0ZUF1dGhlbnRpY2F0aW9uT3B0aW9ucyh7XG4gICAgICAgIC4uLnByb3ZpZGVyLmF1dGhlbnRpY2F0aW9uT3B0aW9ucyxcbiAgICAgICAgcnBJRDogcmVsYXlpbmdQYXJ0eS5pZCxcbiAgICAgICAgYWxsb3dDcmVkZW50aWFsczogYXV0aGVudGljYXRvcnM/Lm1hcCgoYSkgPT4gKHtcbiAgICAgICAgICAgIGlkOiBmcm9tQmFzZTY0KGEuY3JlZGVudGlhbElEKSxcbiAgICAgICAgICAgIHR5cGU6IFwicHVibGljLWtleVwiLFxuICAgICAgICAgICAgdHJhbnNwb3J0czogc3RyaW5nVG9UcmFuc3BvcnRzKGEudHJhbnNwb3J0cyksXG4gICAgICAgIH0pKSxcbiAgICB9KTtcbn1cbi8qKlxuICogR2VuZXJhdGVzIFdlYkF1dGhuIHJlZ2lzdHJhdGlvbiBvcHRpb25zLlxuICpcbiAqIEBwYXJhbSBvcHRpb25zIC0gVGhlIGludGVybmFsIG9wdGlvbnMgZm9yIFdlYkF1dGhuLlxuICogQHBhcmFtIHJlcXVlc3QgLSBUaGUgcmVxdWVzdCBvYmplY3QuXG4gKiBAcGFyYW0gdXNlciAtIFRoZSB1c2VyIGluZm9ybWF0aW9uLlxuICogQHJldHVybnMgVGhlIHJlZ2lzdHJhdGlvbiBvcHRpb25zLlxuICovXG5hc3luYyBmdW5jdGlvbiBnZXRSZWdpc3RyYXRpb25PcHRpb25zKG9wdGlvbnMsIHJlcXVlc3QsIHVzZXIpIHtcbiAgICBjb25zdCB7IHByb3ZpZGVyLCBhZGFwdGVyIH0gPSBvcHRpb25zO1xuICAgIC8vIEdldCB0aGUgdXNlcidzIGF1dGhlbnRpY2F0b3JzLlxuICAgIGNvbnN0IGF1dGhlbnRpY2F0b3JzID0gdXNlcltcImlkXCJdXG4gICAgICAgID8gYXdhaXQgYWRhcHRlci5saXN0QXV0aGVudGljYXRvcnNCeVVzZXJJZCh1c2VyLmlkKVxuICAgICAgICA6IG51bGw7XG4gICAgLy8gR2VuZXJhdGUgYSByYW5kb20gdXNlciBJRCBmb3IgdGhlIGNyZWRlbnRpYWwuXG4gICAgLy8gV2UgY2FuIGRvIHRoaXMgYmVjYXVzZSB3ZSBkb24ndCB1c2UgdGhpcyB1c2VyIElEIHRvIGxpbmsgdGhlXG4gICAgLy8gY3JlZGVudGlhbCB0byB0aGUgdXNlci4gSW5zdGVhZCwgd2Ugc3RvcmUgYWN0dWFsIHVzZXJJRCBpbiB0aGVcbiAgICAvLyBBdXRoZW50aWNhdG9yIG9iamVjdCBhbmQgZmV0Y2ggaXQgdmlhIGl0J3MgY3JlZGVudGlhbCBJRC5cbiAgICBjb25zdCB1c2VySUQgPSByYW5kb21TdHJpbmcoMzIpO1xuICAgIGNvbnN0IHJlbGF5aW5nUGFydHkgPSBwcm92aWRlci5nZXRSZWxheWluZ1BhcnR5KG9wdGlvbnMsIHJlcXVlc3QpO1xuICAgIC8vIFJldHVybiB0aGUgcmVnaXN0cmF0aW9uIG9wdGlvbnMuXG4gICAgcmV0dXJuIGF3YWl0IHByb3ZpZGVyLnNpbXBsZVdlYkF1dGhuLmdlbmVyYXRlUmVnaXN0cmF0aW9uT3B0aW9ucyh7XG4gICAgICAgIC4uLnByb3ZpZGVyLnJlZ2lzdHJhdGlvbk9wdGlvbnMsXG4gICAgICAgIHVzZXJJRCxcbiAgICAgICAgdXNlck5hbWU6IHVzZXIuZW1haWwsXG4gICAgICAgIHVzZXJEaXNwbGF5TmFtZTogdXNlci5uYW1lID8/IHVuZGVmaW5lZCxcbiAgICAgICAgcnBJRDogcmVsYXlpbmdQYXJ0eS5pZCxcbiAgICAgICAgcnBOYW1lOiByZWxheWluZ1BhcnR5Lm5hbWUsXG4gICAgICAgIGV4Y2x1ZGVDcmVkZW50aWFsczogYXV0aGVudGljYXRvcnM/Lm1hcCgoYSkgPT4gKHtcbiAgICAgICAgICAgIGlkOiBmcm9tQmFzZTY0KGEuY3JlZGVudGlhbElEKSxcbiAgICAgICAgICAgIHR5cGU6IFwicHVibGljLWtleVwiLFxuICAgICAgICAgICAgdHJhbnNwb3J0czogc3RyaW5nVG9UcmFuc3BvcnRzKGEudHJhbnNwb3J0cyksXG4gICAgICAgIH0pKSxcbiAgICB9KTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBhc3NlcnRJbnRlcm5hbE9wdGlvbnNXZWJBdXRobihvcHRpb25zKSB7XG4gICAgY29uc3QgeyBwcm92aWRlciwgYWRhcHRlciB9ID0gb3B0aW9ucztcbiAgICAvLyBBZGFwdGVyIGlzIHJlcXVpcmVkIGZvciBXZWJBdXRoblxuICAgIGlmICghYWRhcHRlcilcbiAgICAgICAgdGhyb3cgbmV3IE1pc3NpbmdBZGFwdGVyKFwiQW4gYWRhcHRlciBpcyByZXF1aXJlZCBmb3IgdGhlIFdlYkF1dGhuIHByb3ZpZGVyXCIpO1xuICAgIC8vIFByb3ZpZGVyIG11c3QgYmUgV2ViQXV0aG5cbiAgICBpZiAoIXByb3ZpZGVyIHx8IHByb3ZpZGVyLnR5cGUgIT09IFwid2ViYXV0aG5cIikge1xuICAgICAgICB0aHJvdyBuZXcgSW52YWxpZFByb3ZpZGVyKFwiUHJvdmlkZXIgbXVzdCBiZSBXZWJBdXRoblwiKTtcbiAgICB9XG4gICAgLy8gTmFycm93IHRoZSBvcHRpb25zIHR5cGUgZm9yIHR5cGVkIHVzYWdlIGxhdGVyXG4gICAgcmV0dXJuIHsgLi4ub3B0aW9ucywgcHJvdmlkZXIsIGFkYXB0ZXIgfTtcbn1cbmZ1bmN0aW9uIGZyb21BZGFwdGVyQXV0aGVudGljYXRvcihhdXRoZW50aWNhdG9yKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgLi4uYXV0aGVudGljYXRvcixcbiAgICAgICAgY3JlZGVudGlhbERldmljZVR5cGU6IGF1dGhlbnRpY2F0b3IuY3JlZGVudGlhbERldmljZVR5cGUsXG4gICAgICAgIHRyYW5zcG9ydHM6IHN0cmluZ1RvVHJhbnNwb3J0cyhhdXRoZW50aWNhdG9yLnRyYW5zcG9ydHMpLFxuICAgICAgICBjcmVkZW50aWFsSUQ6IGZyb21CYXNlNjQoYXV0aGVudGljYXRvci5jcmVkZW50aWFsSUQpLFxuICAgICAgICBjcmVkZW50aWFsUHVibGljS2V5OiBmcm9tQmFzZTY0KGF1dGhlbnRpY2F0b3IuY3JlZGVudGlhbFB1YmxpY0tleSksXG4gICAgfTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBmcm9tQmFzZTY0KGJhc2U2NCkge1xuICAgIHJldHVybiBuZXcgVWludDhBcnJheShCdWZmZXIuZnJvbShiYXNlNjQsIFwiYmFzZTY0XCIpKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiB0b0Jhc2U2NChieXRlcykge1xuICAgIHJldHVybiBCdWZmZXIuZnJvbShieXRlcykudG9TdHJpbmcoXCJiYXNlNjRcIik7XG59XG5leHBvcnQgZnVuY3Rpb24gdHJhbnNwb3J0c1RvU3RyaW5nKHRyYW5zcG9ydHMpIHtcbiAgICByZXR1cm4gdHJhbnNwb3J0cz8uam9pbihcIixcIik7XG59XG5leHBvcnQgZnVuY3Rpb24gc3RyaW5nVG9UcmFuc3BvcnRzKHRzdHJpbmcpIHtcbiAgICByZXR1cm4gdHN0cmluZ1xuICAgICAgICA/IHRzdHJpbmcuc3BsaXQoXCIsXCIpXG4gICAgICAgIDogdW5kZWZpbmVkO1xufVxuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/utils/webauthn-utils.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/lib/vendored/cookie.js":
/*!********************************************************!*\
  !*** ./node_modules/@auth/core/lib/vendored/cookie.js ***!
  \********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   parse: () => (/* binding */ parse),\n/* harmony export */   serialize: () => (/* binding */ serialize)\n/* harmony export */ });\n/**\n * @source https://github.com/jshttp/cookie\n * @author blakeembrey\n * @license MIT\n */\n/**\n * This is a workaround to support ESM-only environments, until `cookie` ships ESM builds.\n * @see https://github.com/jshttp/cookie/issues/211\n */\n/**\n * RegExp to match cookie-name in RFC 6265 sec 4.1.1\n * This refers out to the obsoleted definition of token in RFC 2616 sec 2.2\n * which has been replaced by the token definition in RFC 7230 appendix B.\n *\n * cookie-name       = token\n * token             = 1*tchar\n * tchar             = \"!\" / \"#\" / \"$\" / \"%\" / \"&\" / \"'\" /\n *                     \"*\" / \"+\" / \"-\" / \".\" / \"^\" / \"_\" /\n *                     \"`\" / \"|\" / \"~\" / DIGIT / ALPHA\n */\nconst cookieNameRegExp = /^[!#$%&'*+\\-.^_`|~0-9A-Za-z]+$/;\n/**\n * RegExp to match cookie-value in RFC 6265 sec 4.1.1\n *\n * cookie-value      = *cookie-octet / ( DQUOTE *cookie-octet DQUOTE )\n * cookie-octet      = %x21 / %x23-2B / %x2D-3A / %x3C-5B / %x5D-7E\n *                     ; US-ASCII characters excluding CTLs,\n *                     ; whitespace DQUOTE, comma, semicolon,\n *                     ; and backslash\n */\nconst cookieValueRegExp = /^(\"?)[\\u0021\\u0023-\\u002B\\u002D-\\u003A\\u003C-\\u005B\\u005D-\\u007E]*\\1$/;\n/**\n * RegExp to match domain-value in RFC 6265 sec 4.1.1\n *\n * domain-value      = <subdomain>\n *                     ; defined in [RFC1034], Section 3.5, as\n *                     ; enhanced by [RFC1123], Section 2.1\n * <subdomain>       = <label> | <subdomain> \".\" <label>\n * <label>           = <let-dig> [ [ <ldh-str> ] <let-dig> ]\n *                     Labels must be 63 characters or less.\n *                     'let-dig' not 'letter' in the first char, per RFC1123\n * <ldh-str>         = <let-dig-hyp> | <let-dig-hyp> <ldh-str>\n * <let-dig-hyp>     = <let-dig> | \"-\"\n * <let-dig>         = <letter> | <digit>\n * <letter>          = any one of the 52 alphabetic characters A through Z in\n *                     upper case and a through z in lower case\n * <digit>           = any one of the ten digits 0 through 9\n *\n * Keep support for leading dot: https://github.com/jshttp/cookie/issues/173\n *\n * > (Note that a leading %x2E (\".\"), if present, is ignored even though that\n * character is not permitted, but a trailing %x2E (\".\"), if present, will\n * cause the user agent to ignore the attribute.)\n */\nconst domainValueRegExp = /^([.]?[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)([.][a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)*$/i;\n/**\n * RegExp to match path-value in RFC 6265 sec 4.1.1\n *\n * path-value        = <any CHAR except CTLs or \";\">\n * CHAR              = %x01-7F\n *                     ; defined in RFC 5234 appendix B.1\n */\nconst pathValueRegExp = /^[\\u0020-\\u003A\\u003D-\\u007E]*$/;\nconst __toString = Object.prototype.toString;\nconst NullObject = /* @__PURE__ */ (() => {\n    const C = function () { };\n    C.prototype = Object.create(null);\n    return C;\n})();\n/**\n * Parse a cookie header.\n *\n * Parse the given cookie header string into an object\n * The object has the various cookies as keys(names) => values\n */\nfunction parse(str, options) {\n    const obj = new NullObject();\n    const len = str.length;\n    // RFC 6265 sec 4.1.1, RFC 2616 2.2 defines a cookie name consists of one char minimum, plus '='.\n    if (len < 2)\n        return obj;\n    const dec = options?.decode || decode;\n    let index = 0;\n    do {\n        const eqIdx = str.indexOf(\"=\", index);\n        if (eqIdx === -1)\n            break; // No more cookie pairs.\n        const colonIdx = str.indexOf(\";\", index);\n        const endIdx = colonIdx === -1 ? len : colonIdx;\n        if (eqIdx > endIdx) {\n            // backtrack on prior semicolon\n            index = str.lastIndexOf(\";\", eqIdx - 1) + 1;\n            continue;\n        }\n        const keyStartIdx = startIndex(str, index, eqIdx);\n        const keyEndIdx = endIndex(str, eqIdx, keyStartIdx);\n        const key = str.slice(keyStartIdx, keyEndIdx);\n        // only assign once\n        if (obj[key] === undefined) {\n            let valStartIdx = startIndex(str, eqIdx + 1, endIdx);\n            let valEndIdx = endIndex(str, endIdx, valStartIdx);\n            const value = dec(str.slice(valStartIdx, valEndIdx));\n            obj[key] = value;\n        }\n        index = endIdx + 1;\n    } while (index < len);\n    return obj;\n}\nfunction startIndex(str, index, max) {\n    do {\n        const code = str.charCodeAt(index);\n        if (code !== 0x20 /*   */ && code !== 0x09 /* \\t */)\n            return index;\n    } while (++index < max);\n    return max;\n}\nfunction endIndex(str, index, min) {\n    while (index > min) {\n        const code = str.charCodeAt(--index);\n        if (code !== 0x20 /*   */ && code !== 0x09 /* \\t */)\n            return index + 1;\n    }\n    return min;\n}\n/**\n * Serialize data into a cookie header.\n *\n * Serialize a name value pair into a cookie string suitable for\n * http headers. An optional options object specifies cookie parameters.\n *\n * serialize('foo', 'bar', { httpOnly: true })\n *   => \"foo=bar; httpOnly\"\n */\nfunction serialize(name, val, options) {\n    const enc = options?.encode || encodeURIComponent;\n    if (!cookieNameRegExp.test(name)) {\n        throw new TypeError(`argument name is invalid: ${name}`);\n    }\n    const value = enc(val);\n    if (!cookieValueRegExp.test(value)) {\n        throw new TypeError(`argument val is invalid: ${val}`);\n    }\n    let str = name + \"=\" + value;\n    if (!options)\n        return str;\n    if (options.maxAge !== undefined) {\n        if (!Number.isInteger(options.maxAge)) {\n            throw new TypeError(`option maxAge is invalid: ${options.maxAge}`);\n        }\n        str += \"; Max-Age=\" + options.maxAge;\n    }\n    if (options.domain) {\n        if (!domainValueRegExp.test(options.domain)) {\n            throw new TypeError(`option domain is invalid: ${options.domain}`);\n        }\n        str += \"; Domain=\" + options.domain;\n    }\n    if (options.path) {\n        if (!pathValueRegExp.test(options.path)) {\n            throw new TypeError(`option path is invalid: ${options.path}`);\n        }\n        str += \"; Path=\" + options.path;\n    }\n    if (options.expires) {\n        if (!isDate(options.expires) ||\n            !Number.isFinite(options.expires.valueOf())) {\n            throw new TypeError(`option expires is invalid: ${options.expires}`);\n        }\n        str += \"; Expires=\" + options.expires.toUTCString();\n    }\n    if (options.httpOnly) {\n        str += \"; HttpOnly\";\n    }\n    if (options.secure) {\n        str += \"; Secure\";\n    }\n    if (options.partitioned) {\n        str += \"; Partitioned\";\n    }\n    if (options.priority) {\n        const priority = typeof options.priority === \"string\"\n            ? options.priority.toLowerCase()\n            : undefined;\n        switch (priority) {\n            case \"low\":\n                str += \"; Priority=Low\";\n                break;\n            case \"medium\":\n                str += \"; Priority=Medium\";\n                break;\n            case \"high\":\n                str += \"; Priority=High\";\n                break;\n            default:\n                throw new TypeError(`option priority is invalid: ${options.priority}`);\n        }\n    }\n    if (options.sameSite) {\n        const sameSite = typeof options.sameSite === \"string\"\n            ? options.sameSite.toLowerCase()\n            : options.sameSite;\n        switch (sameSite) {\n            case true:\n            case \"strict\":\n                str += \"; SameSite=Strict\";\n                break;\n            case \"lax\":\n                str += \"; SameSite=Lax\";\n                break;\n            case \"none\":\n                str += \"; SameSite=None\";\n                break;\n            default:\n                throw new TypeError(`option sameSite is invalid: ${options.sameSite}`);\n        }\n    }\n    return str;\n}\n/**\n * URL-decode string value. Optimized to skip native call when no %.\n */\nfunction decode(str) {\n    if (str.indexOf(\"%\") === -1)\n        return str;\n    try {\n        return decodeURIComponent(str);\n    }\n    catch (e) {\n        return str;\n    }\n}\n/**\n * Determine if value is a Date.\n */\nfunction isDate(val) {\n    return __toString.call(val) === \"[object Date]\";\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/lib/vendored/cookie.js\n");

/***/ }),

/***/ "(rsc)/./node_modules/@auth/core/providers/credentials.js":
/*!**********************************************************!*\
  !*** ./node_modules/@auth/core/providers/credentials.js ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Credentials)\n/* harmony export */ });\n/**\n * The Credentials provider allows you to handle signing in with arbitrary credentials,\n * such as a username and password, domain, or two factor authentication or hardware device (e.g. YubiKey U2F / FIDO).\n *\n * It is intended to support use cases where you have an existing system you need to authenticate users against.\n *\n * It comes with the constraint that users authenticated in this manner are not persisted in the database,\n * and consequently that the Credentials provider can only be used if JSON Web Tokens are enabled for sessions.\n *\n * :::caution\n * The functionality provided for credentials-based authentication is intentionally limited to discourage the use of passwords due to the inherent security risks of the username-password model.\n *\n * OAuth providers spend significant amounts of money, time, and engineering effort to build:\n *\n * - abuse detection (bot-protection, rate-limiting)\n * - password management (password reset, credential stuffing, rotation)\n * - data security (encryption/salting, strength validation)\n *\n * and much more for authentication solutions. It is likely that your application would benefit from leveraging these battle-tested solutions rather than try to rebuild them from scratch.\n *\n * If you'd still like to build password-based authentication for your application despite these risks, Auth.js gives you full control to do so.\n *\n * :::\n *\n * See the [callbacks documentation](/reference/core#authconfig#callbacks) for more information on how to interact with the token. For example, you can add additional information to the token by returning an object from the `jwt()` callback:\n *\n * ```ts\n * callbacks: {\n *   async jwt({ token, user, account, profile, isNewUser }) {\n *     if (user) {\n *       token.id = user.id\n *     }\n *     return token\n *   }\n * }\n * ```\n *\n * @example\n * ```ts\n * import { Auth } from \"@auth/core\"\n * import Credentials from \"@auth/core/providers/credentials\"\n *\n * const request = new Request(\"https://example.com\")\n * const response = await AuthHandler(request, {\n *   providers: [\n *     Credentials({\n *       credentials: {\n *         username: { label: \"Username\" },\n *         password: {  label: \"Password\", type: \"password\" }\n *       },\n *       async authorize({ request }) {\n *         const response = await fetch(request)\n *         if(!response.ok) return null\n *         return await response.json() ?? null\n *       }\n *     })\n *   ],\n *   secret: \"...\",\n *   trustHost: true,\n * })\n * ```\n * @see [Username/Password Example](https://authjs.dev/getting-started/authentication/credentials)\n */\nfunction Credentials(config) {\n    return {\n        id: \"credentials\",\n        name: \"Credentials\",\n        type: \"credentials\",\n        credentials: {},\n        authorize: () => null,\n        // @ts-expect-error\n        options: config,\n    };\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/@auth/core/providers/credentials.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/@auth/core/errors.js":
/*!*******************************************!*\
  !*** ./node_modules/@auth/core/errors.js ***!
  \*******************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AccessDenied: () => (/* binding */ AccessDenied),\n/* harmony export */   AccountNotLinked: () => (/* binding */ AccountNotLinked),\n/* harmony export */   AdapterError: () => (/* binding */ AdapterError),\n/* harmony export */   AuthError: () => (/* binding */ AuthError),\n/* harmony export */   CallbackRouteError: () => (/* binding */ CallbackRouteError),\n/* harmony export */   CredentialsSignin: () => (/* binding */ CredentialsSignin),\n/* harmony export */   DuplicateConditionalUI: () => (/* binding */ DuplicateConditionalUI),\n/* harmony export */   EmailSignInError: () => (/* binding */ EmailSignInError),\n/* harmony export */   ErrorPageLoop: () => (/* binding */ ErrorPageLoop),\n/* harmony export */   EventError: () => (/* binding */ EventError),\n/* harmony export */   ExperimentalFeatureNotEnabled: () => (/* binding */ ExperimentalFeatureNotEnabled),\n/* harmony export */   InvalidCallbackUrl: () => (/* binding */ InvalidCallbackUrl),\n/* harmony export */   InvalidCheck: () => (/* binding */ InvalidCheck),\n/* harmony export */   InvalidEndpoints: () => (/* binding */ InvalidEndpoints),\n/* harmony export */   InvalidProvider: () => (/* binding */ InvalidProvider),\n/* harmony export */   JWTSessionError: () => (/* binding */ JWTSessionError),\n/* harmony export */   MissingAdapter: () => (/* binding */ MissingAdapter),\n/* harmony export */   MissingAdapterMethods: () => (/* binding */ MissingAdapterMethods),\n/* harmony export */   MissingAuthorize: () => (/* binding */ MissingAuthorize),\n/* harmony export */   MissingCSRF: () => (/* binding */ MissingCSRF),\n/* harmony export */   MissingSecret: () => (/* binding */ MissingSecret),\n/* harmony export */   MissingWebAuthnAutocomplete: () => (/* binding */ MissingWebAuthnAutocomplete),\n/* harmony export */   OAuthAccountNotLinked: () => (/* binding */ OAuthAccountNotLinked),\n/* harmony export */   OAuthCallbackError: () => (/* binding */ OAuthCallbackError),\n/* harmony export */   OAuthProfileParseError: () => (/* binding */ OAuthProfileParseError),\n/* harmony export */   OAuthSignInError: () => (/* binding */ OAuthSignInError),\n/* harmony export */   SessionTokenError: () => (/* binding */ SessionTokenError),\n/* harmony export */   SignInError: () => (/* binding */ SignInError),\n/* harmony export */   SignOutError: () => (/* binding */ SignOutError),\n/* harmony export */   UnknownAction: () => (/* binding */ UnknownAction),\n/* harmony export */   UnsupportedStrategy: () => (/* binding */ UnsupportedStrategy),\n/* harmony export */   UntrustedHost: () => (/* binding */ UntrustedHost),\n/* harmony export */   Verification: () => (/* binding */ Verification),\n/* harmony export */   WebAuthnVerificationError: () => (/* binding */ WebAuthnVerificationError),\n/* harmony export */   isClientError: () => (/* binding */ isClientError)\n/* harmony export */ });\n/**\n * Base error class for all Auth.js errors.\n * It's optimized to be printed in the server logs in a nicely formatted way\n * via the [`logger.error`](https://authjs.dev/reference/core#logger) option.\n * @noInheritDoc\n */\nclass AuthError extends Error {\n    /** @internal */\n    constructor(message, errorOptions) {\n        if (message instanceof Error) {\n            super(undefined, {\n                cause: { err: message, ...message.cause, ...errorOptions },\n            });\n        }\n        else if (typeof message === \"string\") {\n            if (errorOptions instanceof Error) {\n                errorOptions = { err: errorOptions, ...errorOptions.cause };\n            }\n            super(message, errorOptions);\n        }\n        else {\n            super(undefined, message);\n        }\n        this.name = this.constructor.name;\n        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841\n        this.type = this.constructor.type ?? \"AuthError\";\n        // @ts-expect-error https://github.com/microsoft/TypeScript/issues/3841\n        this.kind = this.constructor.kind ?? \"error\";\n        Error.captureStackTrace?.(this, this.constructor);\n        const url = `https://errors.authjs.dev#${this.type.toLowerCase()}`;\n        this.message += `${this.message ? \". \" : \"\"}Read more at ${url}`;\n    }\n}\n/**\n * Thrown when the user's sign-in attempt failed.\n * @noInheritDoc\n */\nclass SignInError extends AuthError {\n}\n/** @internal */\nSignInError.kind = \"signIn\";\n/**\n * One of the database [`Adapter` methods](https://authjs.dev/reference/core/adapters#methods)\n * failed during execution.\n *\n * :::tip\n * If `debug: true` is set, you can check out `[auth][debug]` in the logs to learn more about the failed adapter method execution.\n * @example\n * ```sh\n * [auth][debug]: adapter_getUserByEmail\n * { \"args\": [undefined] }\n * ```\n * :::\n * @noInheritDoc\n */\nclass AdapterError extends AuthError {\n}\nAdapterError.type = \"AdapterError\";\n/**\n * Thrown when the execution of the [`signIn` callback](https://authjs.dev/reference/core/types#signin) fails\n * or if it returns `false`.\n * @noInheritDoc\n */\nclass AccessDenied extends AuthError {\n}\nAccessDenied.type = \"AccessDenied\";\n/**\n * This error occurs when the user cannot finish login.\n * Depending on the provider type, this could have happened for multiple reasons.\n *\n * :::tip\n * Check out `[auth][details]` in the logs to know which provider failed.\n * @example\n * ```sh\n * [auth][details]: { \"provider\": \"github\" }\n * ```\n * :::\n *\n * For an [OAuth provider](https://authjs.dev/getting-started/authentication/oauth), possible causes are:\n * - The user denied access to the application\n * - There was an error parsing the OAuth Profile:\n *   Check out the provider's `profile` or `userinfo.request` method to make sure\n *   it correctly fetches the user's profile.\n * - The `signIn` or `jwt` callback methods threw an uncaught error:\n *   Check the callback method implementations.\n *\n * For an [Email provider](https://authjs.dev/getting-started/authentication/email), possible causes are:\n * - The provided email/token combination was invalid/missing:\n *   Check if the provider's `sendVerificationRequest` method correctly sends the email.\n * - The provided email/token combination has expired:\n *   Ask the user to log in again.\n * - There was an error with the database:\n *   Check the database logs.\n *\n * For a [Credentials provider](https://authjs.dev/getting-started/authentication/credentials), possible causes are:\n * - The `authorize` method threw an uncaught error:\n *   Check the provider's `authorize` method.\n * - The `signIn` or `jwt` callback methods threw an uncaught error:\n *   Check the callback method implementations.\n *\n * :::tip\n * Check out `[auth][cause]` in the error message for more details.\n * It will show the original stack trace.\n * :::\n * @noInheritDoc\n */\nclass CallbackRouteError extends AuthError {\n}\nCallbackRouteError.type = \"CallbackRouteError\";\n/**\n * Thrown when Auth.js is misconfigured and accidentally tried to require authentication on a custom error page.\n * To prevent an infinite loop, Auth.js will instead render its default error page.\n *\n * To fix this, make sure that the `error` page does not require authentication.\n *\n * Learn more at [Guide: Error pages](https://authjs.dev/guides/pages/error)\n * @noInheritDoc\n */\nclass ErrorPageLoop extends AuthError {\n}\nErrorPageLoop.type = \"ErrorPageLoop\";\n/**\n * One of the [`events` methods](https://authjs.dev/reference/core/types#eventcallbacks)\n * failed during execution.\n *\n * Make sure that the `events` methods are implemented correctly and uncaught errors are handled.\n *\n * Learn more at [`events`](https://authjs.dev/reference/core/types#eventcallbacks)\n * @noInheritDoc\n */\nclass EventError extends AuthError {\n}\nEventError.type = \"EventError\";\n/**\n * Thrown when Auth.js is unable to verify a `callbackUrl` value.\n * The browser either disabled cookies or the `callbackUrl` is not a valid URL.\n *\n * Somebody might have tried to manipulate the callback URL that Auth.js uses to redirect the user back to the configured `callbackUrl`/page.\n * This could be a malicious hacker trying to redirect the user to a phishing site.\n * To prevent this, Auth.js checks if the callback URL is valid and throws this error if it is not.\n *\n * There is no action required, but it might be an indicator that somebody is trying to attack your application.\n * @noInheritDoc\n */\nclass InvalidCallbackUrl extends AuthError {\n}\nInvalidCallbackUrl.type = \"InvalidCallbackUrl\";\n/**\n * Can be thrown from the `authorize` callback of the Credentials provider.\n * When an error occurs during the `authorize` callback, two things can happen:\n * 1. The user is redirected to the signin page, with `error=CredentialsSignin&code=credentials` in the URL. `code` is configurable.\n * 2. If you throw this error in a framework that handles form actions server-side, this error is thrown, instead of redirecting the user, so you'll need to handle.\n * @noInheritDoc\n */\nclass CredentialsSignin extends SignInError {\n    constructor() {\n        super(...arguments);\n        /**\n         * The error code that is set in the `code` query parameter of the redirect URL.\n         *\n         *\n         * ⚠ NOTE: This property is going to be included in the URL, so make sure it does not hint at sensitive errors.\n         *\n         * The full error is always logged on the server, if you need to debug.\n         *\n         * Generally, we don't recommend hinting specifically if the user had either a wrong username or password specifically,\n         * try rather something like \"Invalid credentials\".\n         */\n        this.code = \"credentials\";\n    }\n}\nCredentialsSignin.type = \"CredentialsSignin\";\n/**\n * One of the configured OAuth or OIDC providers is missing the `authorization`, `token` or `userinfo`, or `issuer` configuration.\n * To perform OAuth or OIDC sign in, at least one of these endpoints is required.\n *\n * Learn more at [`OAuth2Config`](https://authjs.dev/reference/core/providers#oauth2configprofile) or [Guide: OAuth Provider](https://authjs.dev/guides/configuring-oauth-providers)\n * @noInheritDoc\n */\nclass InvalidEndpoints extends AuthError {\n}\nInvalidEndpoints.type = \"InvalidEndpoints\";\n/**\n * Thrown when a PKCE, state or nonce OAuth check could not be performed.\n * This could happen if the OAuth provider is configured incorrectly or if the browser is blocking cookies.\n *\n * Learn more at [`checks`](https://authjs.dev/reference/core/providers#checks)\n * @noInheritDoc\n */\nclass InvalidCheck extends AuthError {\n}\nInvalidCheck.type = \"InvalidCheck\";\n/**\n * Logged on the server when Auth.js could not decode or encode a JWT-based (`strategy: \"jwt\"`) session.\n *\n * Possible causes are either a misconfigured `secret` or a malformed JWT or `encode/decode` methods.\n *\n * :::note\n * When this error is logged, the session cookie is destroyed.\n * :::\n *\n * Learn more at [`secret`](https://authjs.dev/reference/core#secret), [`jwt.encode`](https://authjs.dev/reference/core/jwt#encode-1) or [`jwt.decode`](https://authjs.dev/reference/core/jwt#decode-2) for more information.\n * @noInheritDoc\n */\nclass JWTSessionError extends AuthError {\n}\nJWTSessionError.type = \"JWTSessionError\";\n/**\n * Thrown if Auth.js is misconfigured. This could happen if you configured an Email provider but did not set up a database adapter,\n * or tried using a `strategy: \"database\"` session without a database adapter.\n * In both cases, make sure you either remove the configuration or add the missing adapter.\n *\n * Learn more at [Database Adapters](https://authjs.dev/getting-started/database), [Email provider](https://authjs.dev/getting-started/authentication/email) or [Concept: Database session strategy](https://authjs.dev/concepts/session-strategies#database-session)\n * @noInheritDoc\n */\nclass MissingAdapter extends AuthError {\n}\nMissingAdapter.type = \"MissingAdapter\";\n/**\n * Thrown similarily to [`MissingAdapter`](https://authjs.dev/reference/core/errors#missingadapter), but only some required methods were missing.\n *\n * Make sure you either remove the configuration or add the missing methods to the adapter.\n *\n * Learn more at [Database Adapters](https://authjs.dev/getting-started/database)\n * @noInheritDoc\n */\nclass MissingAdapterMethods extends AuthError {\n}\nMissingAdapterMethods.type = \"MissingAdapterMethods\";\n/**\n * Thrown when a Credentials provider is missing the `authorize` configuration.\n * To perform credentials sign in, the `authorize` method is required.\n *\n * Learn more at [Credentials provider](https://authjs.dev/getting-started/authentication/credentials)\n * @noInheritDoc\n */\nclass MissingAuthorize extends AuthError {\n}\nMissingAuthorize.type = \"MissingAuthorize\";\n/**\n * Auth.js requires a secret or multiple secrets to be set, but none was not found. This is used to encrypt cookies, JWTs and other sensitive data.\n *\n * :::note\n * If you are using a framework like Next.js, we try to automatically infer the secret from the `AUTH_SECRET`, `AUTH_SECRET_1`, etc. environment variables.\n * Alternatively, you can also explicitly set the [`AuthConfig.secret`](https://authjs.dev/reference/core#secret) option.\n * :::\n *\n *\n * :::tip\n * To generate a random string, you can use the Auth.js CLI: `npx auth secret`\n * :::\n * @noInheritDoc\n */\nclass MissingSecret extends AuthError {\n}\nMissingSecret.type = \"MissingSecret\";\n/**\n * Thrown when an Email address is already associated with an account\n * but the user is trying an OAuth account that is not linked to it.\n *\n * For security reasons, Auth.js does not automatically link OAuth accounts to existing accounts if the user is not signed in.\n *\n * :::tip\n * If you trust the OAuth provider to have verified the user's email address,\n * you can enable automatic account linking by setting [`allowDangerousEmailAccountLinking: true`](https://authjs.dev/reference/core/providers#allowdangerousemailaccountlinking)\n * in the provider configuration.\n * :::\n * @noInheritDoc\n */\nclass OAuthAccountNotLinked extends SignInError {\n}\nOAuthAccountNotLinked.type = \"OAuthAccountNotLinked\";\n/**\n * Thrown when an OAuth provider returns an error during the sign in process.\n * This could happen for example if the user denied access to the application or there was a configuration error.\n *\n * For a full list of possible reasons, check out the specification [Authorization Code Grant: Error Response](https://www.rfc-editor.org/rfc/rfc6749#section-4.1.2.1)\n * @noInheritDoc\n */\nclass OAuthCallbackError extends SignInError {\n}\nOAuthCallbackError.type = \"OAuthCallbackError\";\n/**\n * This error occurs during an OAuth sign in attempt when the provider's\n * response could not be parsed. This could for example happen if the provider's API\n * changed, or the [`OAuth2Config.profile`](https://authjs.dev/reference/core/providers#oauth2configprofile) method is not implemented correctly.\n * @noInheritDoc\n */\nclass OAuthProfileParseError extends AuthError {\n}\nOAuthProfileParseError.type = \"OAuthProfileParseError\";\n/**\n * Logged on the server when Auth.js could not retrieve a session from the database (`strategy: \"database\"`).\n *\n * The database adapter might be misconfigured or the database is not reachable.\n *\n * Learn more at [Concept: Database session strategy](https://authjs.dev/concepts/session-strategies#database)\n * @noInheritDoc\n */\nclass SessionTokenError extends AuthError {\n}\nSessionTokenError.type = \"SessionTokenError\";\n/**\n * Happens when login by [OAuth](https://authjs.dev/getting-started/authentication/oauth) could not be started.\n *\n * Possible causes are:\n * - The Authorization Server is not compliant with the [OAuth 2.0](https://www.ietf.org/rfc/rfc6749.html) or the [OIDC](https://openid.net/specs/openid-connect-core-1_0.html) specification.\n *   Check the details in the error message.\n *\n * :::tip\n * Check out `[auth][details]` in the logs to know which provider failed.\n * @example\n * ```sh\n * [auth][details]: { \"provider\": \"github\" }\n * ```\n * :::\n * @noInheritDoc\n */\nclass OAuthSignInError extends SignInError {\n}\nOAuthSignInError.type = \"OAuthSignInError\";\n/**\n * Happens when the login by an [Email provider](https://authjs.dev/getting-started/authentication/email) could not be started.\n *\n * Possible causes are:\n * - The email sent from the client is invalid, could not be normalized by [`EmailConfig.normalizeIdentifier`](https://authjs.dev/reference/core/providers/email#normalizeidentifier)\n * - The provided email/token combination has expired:\n *   Ask the user to log in again.\n * - There was an error with the database:\n *   Check the database logs.\n * @noInheritDoc\n */\nclass EmailSignInError extends SignInError {\n}\nEmailSignInError.type = \"EmailSignInError\";\n/**\n * Represents an error that occurs during the sign-out process. This error\n * is logged when there are issues in terminating a user's session, either\n * by failing to delete the session from the database (in database session\n * strategies) or encountering issues during other parts of the sign-out\n * process, such as emitting sign-out events or clearing session cookies.\n *\n * The session cookie(s) are emptied even if this error is logged.\n * @noInheritDoc\n */\nclass SignOutError extends AuthError {\n}\nSignOutError.type = \"SignOutError\";\n/**\n * Auth.js was requested to handle an operation that it does not support.\n *\n * See [`AuthAction`](https://authjs.dev/reference/core/types#authaction) for the supported actions.\n * @noInheritDoc\n */\nclass UnknownAction extends AuthError {\n}\nUnknownAction.type = \"UnknownAction\";\n/**\n * Thrown when a Credentials provider is present but the JWT strategy (`strategy: \"jwt\"`) is not enabled.\n *\n * Learn more at [`strategy`](https://authjs.dev/reference/core#strategy) or [Credentials provider](https://authjs.dev/getting-started/authentication/credentials)\n * @noInheritDoc\n */\nclass UnsupportedStrategy extends AuthError {\n}\nUnsupportedStrategy.type = \"UnsupportedStrategy\";\n/**\n * Thrown when an endpoint was incorrectly called without a provider, or with an unsupported provider.\n * @noInheritDoc\n */\nclass InvalidProvider extends AuthError {\n}\nInvalidProvider.type = \"InvalidProvider\";\n/**\n * Thrown when the `trustHost` option was not set to `true`.\n *\n * Auth.js requires the `trustHost` option to be set to `true` since it's relying on the request headers' `host` value.\n *\n * :::note\n * Official Auth.js libraries might attempt to automatically set the `trustHost` option to `true` if the request is coming from a trusted host on a trusted platform.\n * :::\n *\n * Learn more at [`trustHost`](https://authjs.dev/reference/core#trusthost) or [Guide: Deployment](https://authjs.dev/getting-started/deployment)\n * @noInheritDoc\n */\nclass UntrustedHost extends AuthError {\n}\nUntrustedHost.type = \"UntrustedHost\";\n/**\n * The user's email/token combination was invalid.\n * This could be because the email/token combination was not found in the database,\n * or because the token has expired. Ask the user to log in again.\n * @noInheritDoc\n */\nclass Verification extends AuthError {\n}\nVerification.type = \"Verification\";\n/**\n * Error for missing CSRF tokens in client-side actions (`signIn`, `signOut`, `useSession#update`).\n * Thrown when actions lack the double submit cookie, essential for CSRF protection.\n *\n * CSRF ([Cross-Site Request Forgery](https://owasp.org/www-community/attacks/csrf))\n * is an attack leveraging authenticated user credentials for unauthorized actions.\n *\n * Double submit cookie pattern, a CSRF defense, requires matching values in a cookie\n * and request parameter. More on this at [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Glossary/CSRF).\n * @noInheritDoc\n */\nclass MissingCSRF extends SignInError {\n}\nMissingCSRF.type = \"MissingCSRF\";\nconst clientErrors = new Set([\n    \"CredentialsSignin\",\n    \"OAuthAccountNotLinked\",\n    \"OAuthCallbackError\",\n    \"AccessDenied\",\n    \"Verification\",\n    \"MissingCSRF\",\n    \"AccountNotLinked\",\n    \"WebAuthnVerificationError\",\n]);\n/**\n * Used to only allow sending a certain subset of errors to the client.\n * Errors are always logged on the server, but to prevent leaking sensitive information,\n * only a subset of errors are sent to the client as-is.\n * @internal\n */\nfunction isClientError(error) {\n    if (error instanceof AuthError)\n        return clientErrors.has(error.type);\n    return false;\n}\n/**\n * Thrown when multiple providers have `enableConditionalUI` set to `true`.\n * Only one provider can have this option enabled at a time.\n * @noInheritDoc\n */\nclass DuplicateConditionalUI extends AuthError {\n}\nDuplicateConditionalUI.type = \"DuplicateConditionalUI\";\n/**\n * Thrown when a WebAuthn provider has `enableConditionalUI` set to `true` but no formField has `webauthn` in its autocomplete param.\n *\n * The `webauthn` autocomplete param is required for conditional UI to work.\n * @noInheritDoc\n */\nclass MissingWebAuthnAutocomplete extends AuthError {\n}\nMissingWebAuthnAutocomplete.type = \"MissingWebAuthnAutocomplete\";\n/**\n * Thrown when a WebAuthn provider fails to verify a client response.\n * @noInheritDoc\n */\nclass WebAuthnVerificationError extends AuthError {\n}\nWebAuthnVerificationError.type = \"WebAuthnVerificationError\";\n/**\n * Thrown when an Email address is already associated with an account\n * but the user is trying an account that is not linked to it.\n *\n * For security reasons, Auth.js does not automatically link accounts to existing accounts if the user is not signed in.\n * @noInheritDoc\n */\nclass AccountNotLinked extends SignInError {\n}\nAccountNotLinked.type = \"AccountNotLinked\";\n/**\n * Thrown when an experimental feature is used but not enabled.\n * @noInheritDoc\n */\nclass ExperimentalFeatureNotEnabled extends AuthError {\n}\nExperimentalFeatureNotEnabled.type = \"ExperimentalFeatureNotEnabled\";\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@auth/core/errors.js\n");

/***/ })

};
;