/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(() => {
var exports = {};
exports.id = "app/api/findings/severities/route";
exports.ids = ["app/api/findings/severities/route"];
exports.modules = {

/***/ "(rsc)/./app/api/findings/severities/route.ts":
/*!**********************************************!*\
  !*** ./app/api/findings/severities/route.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GET: () => (/* binding */ GET)\n/* harmony export */ });\n/* harmony import */ var next_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/server */ \"(rsc)/./node_modules/next/dist/api/server.js\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n/* harmony import */ var _lib_api_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/api-helpers */ \"(rsc)/./lib/api-helpers.ts\");\n\n\n\nasync function GET() {\n    try {\n        const severities = await _lib_prisma__WEBPACK_IMPORTED_MODULE_1__[\"default\"].findingSeverity.findMany({\n            where: {\n                is_active: true\n            },\n            orderBy: {\n                sort_order: 'asc'\n            },\n            select: {\n                id: true,\n                value: true,\n                label: true,\n                description: true,\n                color_class: true,\n                sort_order: true\n            }\n        });\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json(severities);\n    } catch (error) {\n        return (0,_lib_api_helpers__WEBPACK_IMPORTED_MODULE_2__.handleApiError)(error);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9hcHAvYXBpL2ZpbmRpbmdzL3NldmVyaXRpZXMvcm91dGUudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUEyQztBQUNUO0FBQ2lCO0FBRTVDLGVBQWVHO0lBQ3BCLElBQUk7UUFDRixNQUFNQyxhQUFhLE1BQU1ILG1EQUFNQSxDQUFDSSxlQUFlLENBQUNDLFFBQVEsQ0FBQztZQUN2REMsT0FBTztnQkFBRUMsV0FBVztZQUFLO1lBQ3pCQyxTQUFTO2dCQUFFQyxZQUFZO1lBQU07WUFDN0JDLFFBQVE7Z0JBQ05DLElBQUk7Z0JBQ0pDLE9BQU87Z0JBQ1BDLE9BQU87Z0JBQ1BDLGFBQWE7Z0JBQ2JDLGFBQWE7Z0JBQ2JOLFlBQVk7WUFDZDtRQUNGO1FBRUEsT0FBT1YscURBQVlBLENBQUNpQixJQUFJLENBQUNiO0lBQzNCLEVBQUUsT0FBT2MsT0FBTztRQUNkLE9BQU9oQixnRUFBY0EsQ0FBQ2dCO0lBQ3hCO0FBQ0YiLCJzb3VyY2VzIjpbIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvYXBwL2FwaS9maW5kaW5ncy9zZXZlcml0aWVzL3JvdXRlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5leHRSZXNwb25zZSB9IGZyb20gJ25leHQvc2VydmVyJztcbmltcG9ydCBwcmlzbWEgZnJvbSAnQC9saWIvcHJpc21hJztcbmltcG9ydCB7IGhhbmRsZUFwaUVycm9yIH0gZnJvbSAnQC9saWIvYXBpLWhlbHBlcnMnO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gR0VUKCkge1xuICB0cnkge1xuICAgIGNvbnN0IHNldmVyaXRpZXMgPSBhd2FpdCBwcmlzbWEuZmluZGluZ1NldmVyaXR5LmZpbmRNYW55KHtcbiAgICAgIHdoZXJlOiB7IGlzX2FjdGl2ZTogdHJ1ZSB9LFxuICAgICAgb3JkZXJCeTogeyBzb3J0X29yZGVyOiAnYXNjJyB9LFxuICAgICAgc2VsZWN0OiB7XG4gICAgICAgIGlkOiB0cnVlLFxuICAgICAgICB2YWx1ZTogdHJ1ZSxcbiAgICAgICAgbGFiZWw6IHRydWUsXG4gICAgICAgIGRlc2NyaXB0aW9uOiB0cnVlLFxuICAgICAgICBjb2xvcl9jbGFzczogdHJ1ZSxcbiAgICAgICAgc29ydF9vcmRlcjogdHJ1ZVxuICAgICAgfVxuICAgIH0pO1xuXG4gICAgcmV0dXJuIE5leHRSZXNwb25zZS5qc29uKHNldmVyaXRpZXMpO1xuICB9IGNhdGNoIChlcnJvcikge1xuICAgIHJldHVybiBoYW5kbGVBcGlFcnJvcihlcnJvcik7XG4gIH1cbn0gIl0sIm5hbWVzIjpbIk5leHRSZXNwb25zZSIsInByaXNtYSIsImhhbmRsZUFwaUVycm9yIiwiR0VUIiwic2V2ZXJpdGllcyIsImZpbmRpbmdTZXZlcml0eSIsImZpbmRNYW55Iiwid2hlcmUiLCJpc19hY3RpdmUiLCJvcmRlckJ5Iiwic29ydF9vcmRlciIsInNlbGVjdCIsImlkIiwidmFsdWUiLCJsYWJlbCIsImRlc2NyaXB0aW9uIiwiY29sb3JfY2xhc3MiLCJqc29uIiwiZXJyb3IiXSwiaWdub3JlTGlzdCI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./app/api/findings/severities/route.ts\n");

/***/ }),

/***/ "(rsc)/./lib/api-helpers.ts":
/*!****************************!*\
  !*** ./lib/api-helpers.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ApiError: () => (/* binding */ ApiError),\n/* harmony export */   createApiResponse: () => (/* binding */ createApiResponse),\n/* harmony export */   createErrorResponse: () => (/* binding */ createErrorResponse),\n/* harmony export */   getApiContext: () => (/* binding */ getApiContext),\n/* harmony export */   getAuthenticatedSession: () => (/* binding */ getAuthenticatedSession),\n/* harmony export */   handleApiError: () => (/* binding */ handleApiError),\n/* harmony export */   hasHospitalAccess: () => (/* binding */ hasHospitalAccess),\n/* harmony export */   withAuth: () => (/* binding */ withAuth)\n/* harmony export */ });\n/* harmony import */ var next_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/server */ \"(rsc)/./node_modules/next/dist/api/server.js\");\n/* harmony import */ var _lib_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/lib/auth */ \"(rsc)/./lib/auth.ts\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n\n\n\n/**\n * Gets the hospital ID from various sources (header, URL, user record)\n * Ensures consistent hospital ID handling across API routes\n */ async function getApiContext(req) {\n    // Get the session\n    const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n    if (!session || !session.user?.email) {\n        throw new Error('Unauthorized');\n    }\n    // Get the user from the database\n    const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n        where: {\n            email: session.user.email\n        },\n        select: {\n            id: true,\n            username: true,\n            email: true,\n            role: true,\n            hospital_id: true\n        }\n    });\n    if (!user) {\n        throw new Error('User not found');\n    }\n    const isSuperAdmin = user.role === 'super_admin';\n    // Get the hospital ID\n    let hospitalId = null;\n    if (isSuperAdmin) {\n        // For super admins, try to get hospital ID from header, URL, or body\n        let headerHospitalId = null;\n        let urlHospitalId = null;\n        // Handle case where req might be empty or undefined (for GET requests without a request object)\n        if (!req || typeof req !== 'object') {\n            console.log(\"WARNING: Request object is empty or undefined. Using cookies from server request.\");\n        // Continue without trying to access req - we'll use cookies instead\n        } else if (req instanceof Request) {\n            const headers = new Headers(req.headers);\n            headerHospitalId = headers.get('x-hospital-id');\n            // Get hospital ID from URL query parameter\n            const url = new URL(req.url);\n            urlHospitalId = url.searchParams.get('hospitalId');\n        } else if (req.headers && typeof req.headers.get === 'function') {\n            headerHospitalId = req.headers.get('x-hospital-id');\n            // Get hospital ID from URL query parameter if nextUrl exists\n            if (req.nextUrl && typeof req.nextUrl.searchParams?.get === 'function') {\n                urlHospitalId = req.nextUrl.searchParams.get('hospitalId');\n            }\n        }\n        // Get hospital ID from cookies\n        let cookieHospitalId = null;\n        // Try to get from cookies in the request\n        if (req instanceof Request) {\n            // Parse cookies from Request header\n            const cookieHeader = new Headers(req.headers).get('cookie');\n            if (cookieHeader) {\n                const cookies = parseCookieString(cookieHeader);\n                cookieHospitalId = cookies.selectedHospitalId || null;\n            }\n        } else if (req && req.cookies && typeof req.cookies.get === 'function') {\n            cookieHospitalId = req.cookies.get('selectedHospitalId')?.value || null;\n        }\n        // If we couldn't get from request, try the server request object\n        if (!cookieHospitalId) {\n            // Try to get from global request context\n            const { cookies } = __webpack_require__(/*! next/headers */ \"(rsc)/./node_modules/next/dist/api/headers.js\");\n            try {\n                const cookieStore = cookies();\n                if (cookieStore && typeof cookieStore.get === 'function') {\n                    const cookie = cookieStore.get('selectedHospitalId');\n                    cookieHospitalId = cookie?.value || null;\n                }\n            } catch (e) {\n                console.error('Error accessing server cookies:', e);\n            }\n        }\n        // Try to get hospital ID from body if it's a POST or PUT request\n        let bodyHospitalId = null;\n        if (req instanceof Request && req.method && [\n            'POST',\n            'PUT'\n        ].includes(req.method)) {\n            try {\n                const clone = req.clone(); // Clone the request to avoid consuming the body\n                const body = await clone.json();\n                bodyHospitalId = body.hospitalId?.toString() || null;\n            } catch (e) {\n            // Ignore error if body can't be parsed\n            }\n        }\n        // Use the first available hospital ID\n        const hospitalIdStr = headerHospitalId || urlHospitalId || cookieHospitalId || bodyHospitalId;\n        // Debug log all sources\n        console.log('Hospital ID sources:', {\n            header: headerHospitalId,\n            url: urlHospitalId,\n            cookie: cookieHospitalId,\n            body: bodyHospitalId,\n            selected: hospitalIdStr\n        });\n        if (hospitalIdStr) {\n            const parsed = parseInt(hospitalIdStr);\n            if (!isNaN(parsed)) {\n                hospitalId = parsed;\n            }\n        }\n    } else {\n        // For regular users, always use their assigned hospital\n        if (user.hospital_id) {\n            hospitalId = user.hospital_id;\n            console.log(`Using assigned hospital ID for regular user: ${hospitalId}`);\n        } else {\n            console.log('Warning: User has no assigned hospital_id');\n            throw new Error('User has no assigned hospital. Please contact an administrator.');\n        }\n    }\n    return {\n        req,\n        session,\n        user,\n        isSuperAdmin,\n        hospitalId\n    };\n}\n/**\n * Helper function to parse cookies from a cookie header string\n */ function parseCookieString(cookieHeader) {\n    return cookieHeader.split(';').reduce((cookies, cookie)=>{\n        const [name, value] = cookie.trim().split('=').map((c)=>c.trim());\n        if (name && value) cookies[name] = value;\n        return cookies;\n    }, {});\n}\n/**\n * Helper function to verify if a user has access to a specific hospital\n */ async function hasHospitalAccess(userEmail, hospitalId) {\n    const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n        where: {\n            email: userEmail\n        },\n        select: {\n            role: true,\n            hospital_id: true\n        }\n    });\n    if (!user) return false;\n    // Super admins have access to all hospitals\n    if (user.role === 'super_admin') return true;\n    // Regular users only have access to their assigned hospital\n    return user.hospital_id === hospitalId;\n}\n/**\n * Standard error handler for API routes\n */ function handleApiError(error, statusCode = 500) {\n    console.error('API error:', error);\n    return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n        error: error instanceof Error ? error.message : 'An unexpected error occurred',\n        details: error instanceof Error ? error.stack : String(error)\n    }, {\n        status: statusCode\n    });\n}\nclass ApiError extends Error {\n    constructor(message, status = 500){\n        super(message), this.message = message, this.status = status;\n        this.name = 'ApiError';\n    }\n}\nasync function getAuthenticatedSession() {\n    try {\n        const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n        if (!session?.user) {\n            throw new ApiError('Unauthorized access', 401);\n        }\n        return session;\n    } catch (error) {\n        console.error('Session error:', error);\n        throw new ApiError('Authentication failed', 401);\n    }\n}\nfunction createApiResponse(data, message) {\n    return {\n        data,\n        message,\n        success: true\n    };\n}\nfunction createErrorResponse(error, status = 500) {\n    return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n        error,\n        success: false\n    }, {\n        status\n    });\n}\nasync function withAuth(handler) {\n    try {\n        const session = await getAuthenticatedSession();\n        const result = await handler(session);\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json(createApiResponse(result));\n    } catch (error) {\n        if (error instanceof ApiError) {\n            return createErrorResponse(error.message, error.status);\n        }\n        console.error('Unexpected error:', error);\n        return createErrorResponse('Internal server error', 500);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9saWIvYXBpLWhlbHBlcnMudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7QUFBd0Q7QUFDdEI7QUFDQTtBQVVsQzs7O0NBR0MsR0FDTSxlQUFlRyxjQUFjQyxHQUFnQztJQUNsRSxrQkFBa0I7SUFDbEIsTUFBTUMsVUFBVSxNQUFNSiwrQ0FBSUE7SUFFMUIsSUFBSSxDQUFDSSxXQUFXLENBQUNBLFFBQVFDLElBQUksRUFBRUMsT0FBTztRQUNwQyxNQUFNLElBQUlDLE1BQU07SUFDbEI7SUFFQSxpQ0FBaUM7SUFDakMsTUFBTUYsT0FBTyxNQUFNSixtREFBTUEsQ0FBQ0ksSUFBSSxDQUFDRyxVQUFVLENBQUM7UUFDeENDLE9BQU87WUFBRUgsT0FBT0YsUUFBUUMsSUFBSSxDQUFDQyxLQUFLO1FBQVc7UUFDN0NJLFFBQVE7WUFBRUMsSUFBSTtZQUFNQyxVQUFVO1lBQU1OLE9BQU87WUFBTU8sTUFBTTtZQUFNQyxhQUFhO1FBQUs7SUFDakY7SUFFQSxJQUFJLENBQUNULE1BQU07UUFDVCxNQUFNLElBQUlFLE1BQU07SUFDbEI7SUFFQSxNQUFNUSxlQUFlVixLQUFLUSxJQUFJLEtBQUs7SUFFbkMsc0JBQXNCO0lBQ3RCLElBQUlHLGFBQTRCO0lBRWhDLElBQUlELGNBQWM7UUFDaEIscUVBQXFFO1FBQ3JFLElBQUlFLG1CQUFrQztRQUN0QyxJQUFJQyxnQkFBK0I7UUFFbkMsZ0dBQWdHO1FBQ2hHLElBQUksQ0FBQ2YsT0FBTyxPQUFPQSxRQUFRLFVBQVU7WUFDbkNnQixRQUFRQyxHQUFHLENBQUM7UUFDWixvRUFBb0U7UUFDdEUsT0FFSyxJQUFJakIsZUFBZWtCLFNBQVM7WUFDL0IsTUFBTUMsVUFBVSxJQUFJQyxRQUFRcEIsSUFBSW1CLE9BQU87WUFDdkNMLG1CQUFtQkssUUFBUUUsR0FBRyxDQUFDO1lBRS9CLDJDQUEyQztZQUMzQyxNQUFNQyxNQUFNLElBQUlDLElBQUl2QixJQUFJc0IsR0FBRztZQUMzQlAsZ0JBQWdCTyxJQUFJRSxZQUFZLENBQUNILEdBQUcsQ0FBQztRQUN2QyxPQUVLLElBQUlyQixJQUFJbUIsT0FBTyxJQUFJLE9BQU9uQixJQUFJbUIsT0FBTyxDQUFDRSxHQUFHLEtBQUssWUFBWTtZQUM3RFAsbUJBQW1CZCxJQUFJbUIsT0FBTyxDQUFDRSxHQUFHLENBQUM7WUFFbkMsNkRBQTZEO1lBQzdELElBQUlyQixJQUFJeUIsT0FBTyxJQUFJLE9BQU96QixJQUFJeUIsT0FBTyxDQUFDRCxZQUFZLEVBQUVILFFBQVEsWUFBWTtnQkFDdEVOLGdCQUFnQmYsSUFBSXlCLE9BQU8sQ0FBQ0QsWUFBWSxDQUFDSCxHQUFHLENBQUM7WUFDL0M7UUFDRjtRQUVBLCtCQUErQjtRQUMvQixJQUFJSyxtQkFBa0M7UUFFdEMseUNBQXlDO1FBQ3pDLElBQUkxQixlQUFla0IsU0FBUztZQUMxQixvQ0FBb0M7WUFDcEMsTUFBTVMsZUFBZSxJQUFJUCxRQUFRcEIsSUFBSW1CLE9BQU8sRUFBRUUsR0FBRyxDQUFDO1lBQ2xELElBQUlNLGNBQWM7Z0JBQ2hCLE1BQU1DLFVBQVVDLGtCQUFrQkY7Z0JBQ2xDRCxtQkFBbUJFLFFBQVFFLGtCQUFrQixJQUFJO1lBQ25EO1FBQ0YsT0FFSyxJQUFJOUIsT0FBT0EsSUFBSTRCLE9BQU8sSUFBSSxPQUFPNUIsSUFBSTRCLE9BQU8sQ0FBQ1AsR0FBRyxLQUFLLFlBQVk7WUFDcEVLLG1CQUFtQjFCLElBQUk0QixPQUFPLENBQUNQLEdBQUcsQ0FBQyx1QkFBdUJVLFNBQVM7UUFDckU7UUFFQSxpRUFBaUU7UUFDakUsSUFBSSxDQUFDTCxrQkFBa0I7WUFDckIseUNBQXlDO1lBQ3pDLE1BQU0sRUFBRUUsT0FBTyxFQUFFLEdBQUdJLG1CQUFPQSxDQUFDLG1FQUFjO1lBQzFDLElBQUk7Z0JBQ0YsTUFBTUMsY0FBY0w7Z0JBQ3BCLElBQUlLLGVBQWUsT0FBT0EsWUFBWVosR0FBRyxLQUFLLFlBQVk7b0JBQ3hELE1BQU1hLFNBQVNELFlBQVlaLEdBQUcsQ0FBQztvQkFDL0JLLG1CQUFtQlEsUUFBUUgsU0FBUztnQkFDdEM7WUFDRixFQUFFLE9BQU9JLEdBQUc7Z0JBQ1ZuQixRQUFRb0IsS0FBSyxDQUFDLG1DQUFtQ0Q7WUFDbkQ7UUFDRjtRQUVBLGlFQUFpRTtRQUNqRSxJQUFJRSxpQkFBZ0M7UUFDcEMsSUFBSXJDLGVBQWVrQixXQUFXbEIsSUFBSXNDLE1BQU0sSUFBSTtZQUFDO1lBQVE7U0FBTSxDQUFDQyxRQUFRLENBQUN2QyxJQUFJc0MsTUFBTSxHQUFHO1lBQ2hGLElBQUk7Z0JBQ0YsTUFBTUUsUUFBUXhDLElBQUl3QyxLQUFLLElBQUksZ0RBQWdEO2dCQUMzRSxNQUFNQyxPQUFPLE1BQU1ELE1BQU1FLElBQUk7Z0JBQzdCTCxpQkFBaUJJLEtBQUs1QixVQUFVLEVBQUU4QixjQUFjO1lBQ2xELEVBQUUsT0FBT1IsR0FBRztZQUNWLHVDQUF1QztZQUN6QztRQUNGO1FBRUEsc0NBQXNDO1FBQ3RDLE1BQU1TLGdCQUFnQjlCLG9CQUFvQkMsaUJBQWlCVyxvQkFBb0JXO1FBRS9FLHdCQUF3QjtRQUN4QnJCLFFBQVFDLEdBQUcsQ0FBQyx3QkFBd0I7WUFDbEM0QixRQUFRL0I7WUFDUlEsS0FBS1A7WUFDTG1CLFFBQVFSO1lBQ1JlLE1BQU1KO1lBQ05TLFVBQVVGO1FBQ1o7UUFFQSxJQUFJQSxlQUFlO1lBQ2pCLE1BQU1HLFNBQVNDLFNBQVNKO1lBQ3hCLElBQUksQ0FBQ0ssTUFBTUYsU0FBUztnQkFDbEJsQyxhQUFha0M7WUFDZjtRQUNGO0lBQ0YsT0FBTztRQUNILHdEQUF3RDtRQUM1RCxJQUFJN0MsS0FBS1MsV0FBVyxFQUFFO1lBQ3BCRSxhQUFhWCxLQUFLUyxXQUFXO1lBQzdCSyxRQUFRQyxHQUFHLENBQUMsQ0FBQyw2Q0FBNkMsRUFBRUosWUFBWTtRQUMxRSxPQUFPO1lBQ0xHLFFBQVFDLEdBQUcsQ0FBQztZQUNaLE1BQU0sSUFBSWIsTUFBTTtRQUNsQjtJQUNBO0lBRUEsT0FBTztRQUFFSjtRQUFLQztRQUFTQztRQUFNVTtRQUFjQztJQUFXO0FBQ3hEO0FBRUE7O0NBRUMsR0FDRCxTQUFTZ0Isa0JBQWtCRixZQUFvQjtJQUM3QyxPQUFPQSxhQUFhdUIsS0FBSyxDQUFDLEtBQUtDLE1BQU0sQ0FBQyxDQUFDdkIsU0FBU007UUFDOUMsTUFBTSxDQUFDa0IsTUFBTXJCLE1BQU0sR0FBR0csT0FBT21CLElBQUksR0FBR0gsS0FBSyxDQUFDLEtBQUtJLEdBQUcsQ0FBQ0MsQ0FBQUEsSUFBS0EsRUFBRUYsSUFBSTtRQUM5RCxJQUFJRCxRQUFRckIsT0FBT0gsT0FBTyxDQUFDd0IsS0FBSyxHQUFHckI7UUFDbkMsT0FBT0g7SUFDVCxHQUFHLENBQUM7QUFDTjtBQUVBOztDQUVDLEdBQ00sZUFBZTRCLGtCQUFrQkMsU0FBaUIsRUFBRTVDLFVBQWtCO0lBQzNFLE1BQU1YLE9BQU8sTUFBTUosbURBQU1BLENBQUNJLElBQUksQ0FBQ0csVUFBVSxDQUFDO1FBQ3hDQyxPQUFPO1lBQUVILE9BQU9zRDtRQUFVO1FBQzFCbEQsUUFBUTtZQUFFRyxNQUFNO1lBQU1DLGFBQWE7UUFBSztJQUMxQztJQUVBLElBQUksQ0FBQ1QsTUFBTSxPQUFPO0lBRWxCLDRDQUE0QztJQUM1QyxJQUFJQSxLQUFLUSxJQUFJLEtBQUssZUFBZSxPQUFPO0lBRXhDLDREQUE0RDtJQUM1RCxPQUFPUixLQUFLUyxXQUFXLEtBQUtFO0FBQzlCO0FBRUE7O0NBRUMsR0FDTSxTQUFTNkMsZUFBZXRCLEtBQVUsRUFBRXVCLGFBQWEsR0FBRztJQUN6RDNDLFFBQVFvQixLQUFLLENBQUMsY0FBY0E7SUFFNUIsT0FBT3hDLHFEQUFZQSxDQUFDOEMsSUFBSSxDQUFDO1FBQ3ZCTixPQUFPQSxpQkFBaUJoQyxRQUFRZ0MsTUFBTXdCLE9BQU8sR0FBRztRQUNoREMsU0FBU3pCLGlCQUFpQmhDLFFBQVFnQyxNQUFNMEIsS0FBSyxHQUFHQyxPQUFPM0I7SUFDekQsR0FBRztRQUFFNEIsUUFBUUw7SUFBVztBQUMxQjtBQVNPLE1BQU1NLGlCQUFpQjdEO0lBQzVCOEQsWUFBWSxPQUFzQixFQUFFLFNBQXdCLEdBQUcsQ0FBRTtRQUMvRCxLQUFLLENBQUNOLGVBRFdBLFVBQUFBLGNBQXdCSSxTQUFBQTtRQUV6QyxJQUFJLENBQUNaLElBQUksR0FBRztJQUNkO0FBQ0Y7QUFFTyxlQUFlZTtJQUNwQixJQUFJO1FBQ0YsTUFBTWxFLFVBQVUsTUFBTUosK0NBQUlBO1FBRTFCLElBQUksQ0FBQ0ksU0FBU0MsTUFBTTtZQUNsQixNQUFNLElBQUkrRCxTQUFTLHVCQUF1QjtRQUM1QztRQUVBLE9BQU9oRTtJQUNULEVBQUUsT0FBT21DLE9BQU87UUFDZHBCLFFBQVFvQixLQUFLLENBQUMsa0JBQWtCQTtRQUNoQyxNQUFNLElBQUk2QixTQUFTLHlCQUF5QjtJQUM5QztBQUNGO0FBRU8sU0FBU0csa0JBQXFCQyxJQUFPLEVBQUVULE9BQWdCO0lBQzVELE9BQU87UUFDTFM7UUFDQVQ7UUFDQVUsU0FBUztJQUNYO0FBQ0Y7QUFFTyxTQUFTQyxvQkFBb0JuQyxLQUFhLEVBQUU0QixTQUFpQixHQUFHO0lBQ3JFLE9BQU9wRSxxREFBWUEsQ0FBQzhDLElBQUksQ0FDdEI7UUFDRU47UUFDQWtDLFNBQVM7SUFDWCxHQUNBO1FBQUVOO0lBQU87QUFFYjtBQUVPLGVBQWVRLFNBQ3BCQyxPQUFxQztJQUVyQyxJQUFJO1FBQ0YsTUFBTXhFLFVBQVUsTUFBTWtFO1FBQ3RCLE1BQU1PLFNBQVMsTUFBTUQsUUFBUXhFO1FBQzdCLE9BQU9MLHFEQUFZQSxDQUFDOEMsSUFBSSxDQUFDMEIsa0JBQWtCTTtJQUM3QyxFQUFFLE9BQU90QyxPQUFPO1FBQ2QsSUFBSUEsaUJBQWlCNkIsVUFBVTtZQUM3QixPQUFPTSxvQkFBb0JuQyxNQUFNd0IsT0FBTyxFQUFFeEIsTUFBTTRCLE1BQU07UUFDeEQ7UUFDQWhELFFBQVFvQixLQUFLLENBQUMscUJBQXFCQTtRQUNuQyxPQUFPbUMsb0JBQW9CLHlCQUF5QjtJQUN0RDtBQUNGIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L2xpYi9hcGktaGVscGVycy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBOZXh0UmVxdWVzdCwgTmV4dFJlc3BvbnNlIH0gZnJvbSAnbmV4dC9zZXJ2ZXInO1xuaW1wb3J0IHsgYXV0aCB9IGZyb20gJ0AvbGliL2F1dGgnO1xuaW1wb3J0IHByaXNtYSBmcm9tICdAL2xpYi9wcmlzbWEnO1xuXG5pbnRlcmZhY2UgQXBpUmVxdWVzdENvbnRleHQge1xuICByZXE6IE5leHRSZXF1ZXN0IHwgUmVxdWVzdDtcbiAgc2Vzc2lvbjogYW55O1xuICB1c2VyOiBhbnk7XG4gIGlzU3VwZXJBZG1pbjogYm9vbGVhbjtcbiAgaG9zcGl0YWxJZDogbnVtYmVyIHwgbnVsbDtcbn1cblxuLyoqXG4gKiBHZXRzIHRoZSBob3NwaXRhbCBJRCBmcm9tIHZhcmlvdXMgc291cmNlcyAoaGVhZGVyLCBVUkwsIHVzZXIgcmVjb3JkKVxuICogRW5zdXJlcyBjb25zaXN0ZW50IGhvc3BpdGFsIElEIGhhbmRsaW5nIGFjcm9zcyBBUEkgcm91dGVzXG4gKi9cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZXRBcGlDb250ZXh0KHJlcTogTmV4dFJlcXVlc3QgfCBSZXF1ZXN0IHwgYW55KTogUHJvbWlzZTxBcGlSZXF1ZXN0Q29udGV4dD4ge1xuICAvLyBHZXQgdGhlIHNlc3Npb25cbiAgY29uc3Qgc2Vzc2lvbiA9IGF3YWl0IGF1dGgoKTtcbiAgXG4gIGlmICghc2Vzc2lvbiB8fCAhc2Vzc2lvbi51c2VyPy5lbWFpbCkge1xuICAgIHRocm93IG5ldyBFcnJvcignVW5hdXRob3JpemVkJyk7XG4gIH1cbiAgXG4gIC8vIEdldCB0aGUgdXNlciBmcm9tIHRoZSBkYXRhYmFzZVxuICBjb25zdCB1c2VyID0gYXdhaXQgcHJpc21hLnVzZXIuZmluZFVuaXF1ZSh7XG4gICAgd2hlcmU6IHsgZW1haWw6IHNlc3Npb24udXNlci5lbWFpbCBhcyBzdHJpbmcgfSxcbiAgICBzZWxlY3Q6IHsgaWQ6IHRydWUsIHVzZXJuYW1lOiB0cnVlLCBlbWFpbDogdHJ1ZSwgcm9sZTogdHJ1ZSwgaG9zcGl0YWxfaWQ6IHRydWUgfVxuICB9KTtcbiAgXG4gIGlmICghdXNlcikge1xuICAgIHRocm93IG5ldyBFcnJvcignVXNlciBub3QgZm91bmQnKTtcbiAgfVxuICBcbiAgY29uc3QgaXNTdXBlckFkbWluID0gdXNlci5yb2xlID09PSAnc3VwZXJfYWRtaW4nO1xuICBcbiAgLy8gR2V0IHRoZSBob3NwaXRhbCBJRFxuICBsZXQgaG9zcGl0YWxJZDogbnVtYmVyIHwgbnVsbCA9IG51bGw7XG4gIFxuICBpZiAoaXNTdXBlckFkbWluKSB7XG4gICAgLy8gRm9yIHN1cGVyIGFkbWlucywgdHJ5IHRvIGdldCBob3NwaXRhbCBJRCBmcm9tIGhlYWRlciwgVVJMLCBvciBib2R5XG4gICAgbGV0IGhlYWRlckhvc3BpdGFsSWQ6IHN0cmluZyB8IG51bGwgPSBudWxsO1xuICAgIGxldCB1cmxIb3NwaXRhbElkOiBzdHJpbmcgfCBudWxsID0gbnVsbDtcbiAgICBcbiAgICAvLyBIYW5kbGUgY2FzZSB3aGVyZSByZXEgbWlnaHQgYmUgZW1wdHkgb3IgdW5kZWZpbmVkIChmb3IgR0VUIHJlcXVlc3RzIHdpdGhvdXQgYSByZXF1ZXN0IG9iamVjdClcbiAgICBpZiAoIXJlcSB8fCB0eXBlb2YgcmVxICE9PSAnb2JqZWN0Jykge1xuICAgICAgY29uc29sZS5sb2coXCJXQVJOSU5HOiBSZXF1ZXN0IG9iamVjdCBpcyBlbXB0eSBvciB1bmRlZmluZWQuIFVzaW5nIGNvb2tpZXMgZnJvbSBzZXJ2ZXIgcmVxdWVzdC5cIik7XG4gICAgICAvLyBDb250aW51ZSB3aXRob3V0IHRyeWluZyB0byBhY2Nlc3MgcmVxIC0gd2UnbGwgdXNlIGNvb2tpZXMgaW5zdGVhZFxuICAgIH0gXG4gICAgLy8gSWYgaXQncyBhIHByb3BlciBSZXF1ZXN0IG9iamVjdFxuICAgIGVsc2UgaWYgKHJlcSBpbnN0YW5jZW9mIFJlcXVlc3QpIHtcbiAgICAgIGNvbnN0IGhlYWRlcnMgPSBuZXcgSGVhZGVycyhyZXEuaGVhZGVycyk7XG4gICAgICBoZWFkZXJIb3NwaXRhbElkID0gaGVhZGVycy5nZXQoJ3gtaG9zcGl0YWwtaWQnKTtcbiAgICAgIFxuICAgICAgLy8gR2V0IGhvc3BpdGFsIElEIGZyb20gVVJMIHF1ZXJ5IHBhcmFtZXRlclxuICAgICAgY29uc3QgdXJsID0gbmV3IFVSTChyZXEudXJsKTtcbiAgICAgIHVybEhvc3BpdGFsSWQgPSB1cmwuc2VhcmNoUGFyYW1zLmdldCgnaG9zcGl0YWxJZCcpO1xuICAgIH0gXG4gICAgLy8gSWYgaXQncyBhIE5leHRSZXF1ZXN0XG4gICAgZWxzZSBpZiAocmVxLmhlYWRlcnMgJiYgdHlwZW9mIHJlcS5oZWFkZXJzLmdldCA9PT0gJ2Z1bmN0aW9uJykge1xuICAgICAgaGVhZGVySG9zcGl0YWxJZCA9IHJlcS5oZWFkZXJzLmdldCgneC1ob3NwaXRhbC1pZCcpO1xuICAgICAgXG4gICAgICAvLyBHZXQgaG9zcGl0YWwgSUQgZnJvbSBVUkwgcXVlcnkgcGFyYW1ldGVyIGlmIG5leHRVcmwgZXhpc3RzXG4gICAgICBpZiAocmVxLm5leHRVcmwgJiYgdHlwZW9mIHJlcS5uZXh0VXJsLnNlYXJjaFBhcmFtcz8uZ2V0ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgIHVybEhvc3BpdGFsSWQgPSByZXEubmV4dFVybC5zZWFyY2hQYXJhbXMuZ2V0KCdob3NwaXRhbElkJyk7XG4gICAgICB9XG4gICAgfVxuICAgIFxuICAgIC8vIEdldCBob3NwaXRhbCBJRCBmcm9tIGNvb2tpZXNcbiAgICBsZXQgY29va2llSG9zcGl0YWxJZDogc3RyaW5nIHwgbnVsbCA9IG51bGw7XG4gICAgXG4gICAgLy8gVHJ5IHRvIGdldCBmcm9tIGNvb2tpZXMgaW4gdGhlIHJlcXVlc3RcbiAgICBpZiAocmVxIGluc3RhbmNlb2YgUmVxdWVzdCkge1xuICAgICAgLy8gUGFyc2UgY29va2llcyBmcm9tIFJlcXVlc3QgaGVhZGVyXG4gICAgICBjb25zdCBjb29raWVIZWFkZXIgPSBuZXcgSGVhZGVycyhyZXEuaGVhZGVycykuZ2V0KCdjb29raWUnKTtcbiAgICAgIGlmIChjb29raWVIZWFkZXIpIHtcbiAgICAgICAgY29uc3QgY29va2llcyA9IHBhcnNlQ29va2llU3RyaW5nKGNvb2tpZUhlYWRlcik7XG4gICAgICAgIGNvb2tpZUhvc3BpdGFsSWQgPSBjb29raWVzLnNlbGVjdGVkSG9zcGl0YWxJZCB8fCBudWxsO1xuICAgICAgfVxuICAgIH0gXG4gICAgLy8gSWYgaXQgaGFzIGEgY29va2llcyBwcm9wZXJ0eSB3aXRoIGEgZ2V0IG1ldGhvZFxuICAgIGVsc2UgaWYgKHJlcSAmJiByZXEuY29va2llcyAmJiB0eXBlb2YgcmVxLmNvb2tpZXMuZ2V0ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICBjb29raWVIb3NwaXRhbElkID0gcmVxLmNvb2tpZXMuZ2V0KCdzZWxlY3RlZEhvc3BpdGFsSWQnKT8udmFsdWUgfHwgbnVsbDtcbiAgICB9XG4gICAgXG4gICAgLy8gSWYgd2UgY291bGRuJ3QgZ2V0IGZyb20gcmVxdWVzdCwgdHJ5IHRoZSBzZXJ2ZXIgcmVxdWVzdCBvYmplY3RcbiAgICBpZiAoIWNvb2tpZUhvc3BpdGFsSWQpIHtcbiAgICAgIC8vIFRyeSB0byBnZXQgZnJvbSBnbG9iYWwgcmVxdWVzdCBjb250ZXh0XG4gICAgICBjb25zdCB7IGNvb2tpZXMgfSA9IHJlcXVpcmUoJ25leHQvaGVhZGVycycpO1xuICAgICAgdHJ5IHtcbiAgICAgICAgY29uc3QgY29va2llU3RvcmUgPSBjb29raWVzKCk7XG4gICAgICAgIGlmIChjb29raWVTdG9yZSAmJiB0eXBlb2YgY29va2llU3RvcmUuZ2V0ID09PSAnZnVuY3Rpb24nKSB7XG4gICAgICAgICAgY29uc3QgY29va2llID0gY29va2llU3RvcmUuZ2V0KCdzZWxlY3RlZEhvc3BpdGFsSWQnKTtcbiAgICAgICAgICBjb29raWVIb3NwaXRhbElkID0gY29va2llPy52YWx1ZSB8fCBudWxsO1xuICAgICAgICB9XG4gICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoJ0Vycm9yIGFjY2Vzc2luZyBzZXJ2ZXIgY29va2llczonLCBlKTtcbiAgICAgIH1cbiAgICB9XG4gICAgXG4gICAgLy8gVHJ5IHRvIGdldCBob3NwaXRhbCBJRCBmcm9tIGJvZHkgaWYgaXQncyBhIFBPU1Qgb3IgUFVUIHJlcXVlc3RcbiAgICBsZXQgYm9keUhvc3BpdGFsSWQ6IHN0cmluZyB8IG51bGwgPSBudWxsO1xuICAgIGlmIChyZXEgaW5zdGFuY2VvZiBSZXF1ZXN0ICYmIHJlcS5tZXRob2QgJiYgWydQT1NUJywgJ1BVVCddLmluY2x1ZGVzKHJlcS5tZXRob2QpKSB7XG4gICAgICB0cnkge1xuICAgICAgICBjb25zdCBjbG9uZSA9IHJlcS5jbG9uZSgpOyAvLyBDbG9uZSB0aGUgcmVxdWVzdCB0byBhdm9pZCBjb25zdW1pbmcgdGhlIGJvZHlcbiAgICAgICAgY29uc3QgYm9keSA9IGF3YWl0IGNsb25lLmpzb24oKTtcbiAgICAgICAgYm9keUhvc3BpdGFsSWQgPSBib2R5Lmhvc3BpdGFsSWQ/LnRvU3RyaW5nKCkgfHwgbnVsbDtcbiAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgLy8gSWdub3JlIGVycm9yIGlmIGJvZHkgY2FuJ3QgYmUgcGFyc2VkXG4gICAgICB9XG4gICAgfVxuICAgIFxuICAgIC8vIFVzZSB0aGUgZmlyc3QgYXZhaWxhYmxlIGhvc3BpdGFsIElEXG4gICAgY29uc3QgaG9zcGl0YWxJZFN0ciA9IGhlYWRlckhvc3BpdGFsSWQgfHwgdXJsSG9zcGl0YWxJZCB8fCBjb29raWVIb3NwaXRhbElkIHx8IGJvZHlIb3NwaXRhbElkO1xuICAgIFxuICAgIC8vIERlYnVnIGxvZyBhbGwgc291cmNlc1xuICAgIGNvbnNvbGUubG9nKCdIb3NwaXRhbCBJRCBzb3VyY2VzOicsIHtcbiAgICAgIGhlYWRlcjogaGVhZGVySG9zcGl0YWxJZCxcbiAgICAgIHVybDogdXJsSG9zcGl0YWxJZCxcbiAgICAgIGNvb2tpZTogY29va2llSG9zcGl0YWxJZCxcbiAgICAgIGJvZHk6IGJvZHlIb3NwaXRhbElkLFxuICAgICAgc2VsZWN0ZWQ6IGhvc3BpdGFsSWRTdHJcbiAgICB9KTtcbiAgICBcbiAgICBpZiAoaG9zcGl0YWxJZFN0cikge1xuICAgICAgY29uc3QgcGFyc2VkID0gcGFyc2VJbnQoaG9zcGl0YWxJZFN0cik7XG4gICAgICBpZiAoIWlzTmFOKHBhcnNlZCkpIHtcbiAgICAgICAgaG9zcGl0YWxJZCA9IHBhcnNlZDtcbiAgICAgIH1cbiAgICB9XG4gIH0gZWxzZSB7XG4gICAgICAvLyBGb3IgcmVndWxhciB1c2VycywgYWx3YXlzIHVzZSB0aGVpciBhc3NpZ25lZCBob3NwaXRhbFxuICBpZiAodXNlci5ob3NwaXRhbF9pZCkge1xuICAgIGhvc3BpdGFsSWQgPSB1c2VyLmhvc3BpdGFsX2lkO1xuICAgIGNvbnNvbGUubG9nKGBVc2luZyBhc3NpZ25lZCBob3NwaXRhbCBJRCBmb3IgcmVndWxhciB1c2VyOiAke2hvc3BpdGFsSWR9YCk7XG4gIH0gZWxzZSB7XG4gICAgY29uc29sZS5sb2coJ1dhcm5pbmc6IFVzZXIgaGFzIG5vIGFzc2lnbmVkIGhvc3BpdGFsX2lkJyk7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdVc2VyIGhhcyBubyBhc3NpZ25lZCBob3NwaXRhbC4gUGxlYXNlIGNvbnRhY3QgYW4gYWRtaW5pc3RyYXRvci4nKTtcbiAgfVxuICB9XG4gIFxuICByZXR1cm4geyByZXEsIHNlc3Npb24sIHVzZXIsIGlzU3VwZXJBZG1pbiwgaG9zcGl0YWxJZCB9O1xufVxuXG4vKipcbiAqIEhlbHBlciBmdW5jdGlvbiB0byBwYXJzZSBjb29raWVzIGZyb20gYSBjb29raWUgaGVhZGVyIHN0cmluZ1xuICovXG5mdW5jdGlvbiBwYXJzZUNvb2tpZVN0cmluZyhjb29raWVIZWFkZXI6IHN0cmluZyk6IFJlY29yZDxzdHJpbmcsIHN0cmluZz4ge1xuICByZXR1cm4gY29va2llSGVhZGVyLnNwbGl0KCc7JykucmVkdWNlKChjb29raWVzLCBjb29raWUpID0+IHtcbiAgICBjb25zdCBbbmFtZSwgdmFsdWVdID0gY29va2llLnRyaW0oKS5zcGxpdCgnPScpLm1hcChjID0+IGMudHJpbSgpKTtcbiAgICBpZiAobmFtZSAmJiB2YWx1ZSkgY29va2llc1tuYW1lXSA9IHZhbHVlO1xuICAgIHJldHVybiBjb29raWVzO1xuICB9LCB7fSBhcyBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+KTtcbn1cblxuLyoqXG4gKiBIZWxwZXIgZnVuY3Rpb24gdG8gdmVyaWZ5IGlmIGEgdXNlciBoYXMgYWNjZXNzIHRvIGEgc3BlY2lmaWMgaG9zcGl0YWxcbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhc0hvc3BpdGFsQWNjZXNzKHVzZXJFbWFpbDogc3RyaW5nLCBob3NwaXRhbElkOiBudW1iZXIpOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgY29uc3QgdXNlciA9IGF3YWl0IHByaXNtYS51c2VyLmZpbmRVbmlxdWUoe1xuICAgIHdoZXJlOiB7IGVtYWlsOiB1c2VyRW1haWwgfSxcbiAgICBzZWxlY3Q6IHsgcm9sZTogdHJ1ZSwgaG9zcGl0YWxfaWQ6IHRydWUgfVxuICB9KTtcbiAgXG4gIGlmICghdXNlcikgcmV0dXJuIGZhbHNlO1xuICBcbiAgLy8gU3VwZXIgYWRtaW5zIGhhdmUgYWNjZXNzIHRvIGFsbCBob3NwaXRhbHNcbiAgaWYgKHVzZXIucm9sZSA9PT0gJ3N1cGVyX2FkbWluJykgcmV0dXJuIHRydWU7XG4gIFxuICAvLyBSZWd1bGFyIHVzZXJzIG9ubHkgaGF2ZSBhY2Nlc3MgdG8gdGhlaXIgYXNzaWduZWQgaG9zcGl0YWxcbiAgcmV0dXJuIHVzZXIuaG9zcGl0YWxfaWQgPT09IGhvc3BpdGFsSWQ7XG59XG5cbi8qKlxuICogU3RhbmRhcmQgZXJyb3IgaGFuZGxlciBmb3IgQVBJIHJvdXRlc1xuICovXG5leHBvcnQgZnVuY3Rpb24gaGFuZGxlQXBpRXJyb3IoZXJyb3I6IGFueSwgc3RhdHVzQ29kZSA9IDUwMCk6IE5leHRSZXNwb25zZSB7XG4gIGNvbnNvbGUuZXJyb3IoJ0FQSSBlcnJvcjonLCBlcnJvcik7XG4gIFxuICByZXR1cm4gTmV4dFJlc3BvbnNlLmpzb24oeyBcbiAgICBlcnJvcjogZXJyb3IgaW5zdGFuY2VvZiBFcnJvciA/IGVycm9yLm1lc3NhZ2UgOiAnQW4gdW5leHBlY3RlZCBlcnJvciBvY2N1cnJlZCcsXG4gICAgZGV0YWlsczogZXJyb3IgaW5zdGFuY2VvZiBFcnJvciA/IGVycm9yLnN0YWNrIDogU3RyaW5nKGVycm9yKVxuICB9LCB7IHN0YXR1czogc3RhdHVzQ29kZSB9KTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBcGlSZXNwb25zZTxUID0gYW55PiB7XG4gIGRhdGE/OiBUO1xuICBlcnJvcj86IHN0cmluZztcbiAgbWVzc2FnZT86IHN0cmluZztcbiAgc3VjY2VzczogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIEFwaUVycm9yIGV4dGVuZHMgRXJyb3Ige1xuICBjb25zdHJ1Y3RvcihwdWJsaWMgbWVzc2FnZTogc3RyaW5nLCBwdWJsaWMgc3RhdHVzOiBudW1iZXIgPSA1MDApIHtcbiAgICBzdXBlcihtZXNzYWdlKTtcbiAgICB0aGlzLm5hbWUgPSAnQXBpRXJyb3InO1xuICB9XG59XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZXRBdXRoZW50aWNhdGVkU2Vzc2lvbigpIHtcbiAgdHJ5IHtcbiAgICBjb25zdCBzZXNzaW9uID0gYXdhaXQgYXV0aCgpO1xuICAgIFxuICAgIGlmICghc2Vzc2lvbj8udXNlcikge1xuICAgICAgdGhyb3cgbmV3IEFwaUVycm9yKCdVbmF1dGhvcml6ZWQgYWNjZXNzJywgNDAxKTtcbiAgICB9XG4gICAgXG4gICAgcmV0dXJuIHNlc3Npb247XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgY29uc29sZS5lcnJvcignU2Vzc2lvbiBlcnJvcjonLCBlcnJvcik7XG4gICAgdGhyb3cgbmV3IEFwaUVycm9yKCdBdXRoZW50aWNhdGlvbiBmYWlsZWQnLCA0MDEpO1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjcmVhdGVBcGlSZXNwb25zZTxUPihkYXRhOiBULCBtZXNzYWdlPzogc3RyaW5nKTogQXBpUmVzcG9uc2U8VD4ge1xuICByZXR1cm4ge1xuICAgIGRhdGEsXG4gICAgbWVzc2FnZSxcbiAgICBzdWNjZXNzOiB0cnVlLFxuICB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY3JlYXRlRXJyb3JSZXNwb25zZShlcnJvcjogc3RyaW5nLCBzdGF0dXM6IG51bWJlciA9IDUwMCk6IE5leHRSZXNwb25zZSB7XG4gIHJldHVybiBOZXh0UmVzcG9uc2UuanNvbihcbiAgICB7XG4gICAgICBlcnJvcixcbiAgICAgIHN1Y2Nlc3M6IGZhbHNlLFxuICAgIH0sXG4gICAgeyBzdGF0dXMgfVxuICApO1xufVxuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gd2l0aEF1dGg8VD4oXG4gIGhhbmRsZXI6IChzZXNzaW9uOiBhbnkpID0+IFByb21pc2U8VD5cbik6IFByb21pc2U8TmV4dFJlc3BvbnNlPiB7XG4gIHRyeSB7XG4gICAgY29uc3Qgc2Vzc2lvbiA9IGF3YWl0IGdldEF1dGhlbnRpY2F0ZWRTZXNzaW9uKCk7XG4gICAgY29uc3QgcmVzdWx0ID0gYXdhaXQgaGFuZGxlcihzZXNzaW9uKTtcbiAgICByZXR1cm4gTmV4dFJlc3BvbnNlLmpzb24oY3JlYXRlQXBpUmVzcG9uc2UocmVzdWx0KSk7XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgaWYgKGVycm9yIGluc3RhbmNlb2YgQXBpRXJyb3IpIHtcbiAgICAgIHJldHVybiBjcmVhdGVFcnJvclJlc3BvbnNlKGVycm9yLm1lc3NhZ2UsIGVycm9yLnN0YXR1cyk7XG4gICAgfVxuICAgIGNvbnNvbGUuZXJyb3IoJ1VuZXhwZWN0ZWQgZXJyb3I6JywgZXJyb3IpO1xuICAgIHJldHVybiBjcmVhdGVFcnJvclJlc3BvbnNlKCdJbnRlcm5hbCBzZXJ2ZXIgZXJyb3InLCA1MDApO1xuICB9XG59ICJdLCJuYW1lcyI6WyJOZXh0UmVzcG9uc2UiLCJhdXRoIiwicHJpc21hIiwiZ2V0QXBpQ29udGV4dCIsInJlcSIsInNlc3Npb24iLCJ1c2VyIiwiZW1haWwiLCJFcnJvciIsImZpbmRVbmlxdWUiLCJ3aGVyZSIsInNlbGVjdCIsImlkIiwidXNlcm5hbWUiLCJyb2xlIiwiaG9zcGl0YWxfaWQiLCJpc1N1cGVyQWRtaW4iLCJob3NwaXRhbElkIiwiaGVhZGVySG9zcGl0YWxJZCIsInVybEhvc3BpdGFsSWQiLCJjb25zb2xlIiwibG9nIiwiUmVxdWVzdCIsImhlYWRlcnMiLCJIZWFkZXJzIiwiZ2V0IiwidXJsIiwiVVJMIiwic2VhcmNoUGFyYW1zIiwibmV4dFVybCIsImNvb2tpZUhvc3BpdGFsSWQiLCJjb29raWVIZWFkZXIiLCJjb29raWVzIiwicGFyc2VDb29raWVTdHJpbmciLCJzZWxlY3RlZEhvc3BpdGFsSWQiLCJ2YWx1ZSIsInJlcXVpcmUiLCJjb29raWVTdG9yZSIsImNvb2tpZSIsImUiLCJlcnJvciIsImJvZHlIb3NwaXRhbElkIiwibWV0aG9kIiwiaW5jbHVkZXMiLCJjbG9uZSIsImJvZHkiLCJqc29uIiwidG9TdHJpbmciLCJob3NwaXRhbElkU3RyIiwiaGVhZGVyIiwic2VsZWN0ZWQiLCJwYXJzZWQiLCJwYXJzZUludCIsImlzTmFOIiwic3BsaXQiLCJyZWR1Y2UiLCJuYW1lIiwidHJpbSIsIm1hcCIsImMiLCJoYXNIb3NwaXRhbEFjY2VzcyIsInVzZXJFbWFpbCIsImhhbmRsZUFwaUVycm9yIiwic3RhdHVzQ29kZSIsIm1lc3NhZ2UiLCJkZXRhaWxzIiwic3RhY2siLCJTdHJpbmciLCJzdGF0dXMiLCJBcGlFcnJvciIsImNvbnN0cnVjdG9yIiwiZ2V0QXV0aGVudGljYXRlZFNlc3Npb24iLCJjcmVhdGVBcGlSZXNwb25zZSIsImRhdGEiLCJzdWNjZXNzIiwiY3JlYXRlRXJyb3JSZXNwb25zZSIsIndpdGhBdXRoIiwiaGFuZGxlciIsInJlc3VsdCJdLCJpZ25vcmVMaXN0IjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///(rsc)/./lib/api-helpers.ts\n");

/***/ }),

/***/ "(rsc)/./lib/auth.ts":
/*!*********************!*\
  !*** ./lib/auth.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   auth: () => (/* binding */ auth),\n/* harmony export */   authOptions: () => (/* binding */ authOptions),\n/* harmony export */   handlers: () => (/* binding */ handlers),\n/* harmony export */   signIn: () => (/* binding */ signIn),\n/* harmony export */   signOut: () => (/* binding */ signOut)\n/* harmony export */ });\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bcrypt */ \"bcrypt\");\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(bcrypt__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next-auth */ \"(rsc)/./node_modules/next-auth/index.js\");\n/* harmony import */ var next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next-auth/providers/credentials */ \"(rsc)/./node_modules/next-auth/providers/credentials.js\");\n/* harmony import */ var _db__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./db */ \"(rsc)/./lib/db.ts\");\n\n\n\n\nconst authConfig = {\n    session: {\n        strategy: \"jwt\",\n        maxAge: 30 * 24 * 60 * 60\n    },\n    pages: {\n        signIn: \"/login\",\n        signOut: \"/login\",\n        error: \"/login\"\n    },\n    secret: process.env.NEXTAUTH_SECRET || \"your-default-secret-do-not-use-in-production\",\n    debug: true,\n    providers: [\n        (0,next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__[\"default\"])({\n            name: \"credentials\",\n            credentials: {\n                email: {\n                    label: \"Email\",\n                    type: \"email\"\n                },\n                password: {\n                    label: \"Password\",\n                    type: \"password\"\n                }\n            },\n            async authorize (credentials) {\n                console.log(\"Authorizing with credentials:\", credentials?.email);\n                if (!credentials?.email || !credentials?.password) {\n                    console.log(\"Missing credentials\");\n                    return null;\n                }\n                try {\n                    const user = await _db__WEBPACK_IMPORTED_MODULE_3__.db.user.findUnique({\n                        where: {\n                            email: credentials.email\n                        },\n                        include: {\n                            hospital: true\n                        }\n                    });\n                    console.log(\"User found:\", user ? \"Yes\" : \"No\");\n                    if (!user) {\n                        return null;\n                    }\n                    const isPasswordValid = await (0,bcrypt__WEBPACK_IMPORTED_MODULE_0__.compare)(credentials.password, user.password);\n                    console.log(\"Password valid:\", isPasswordValid);\n                    if (!isPasswordValid) {\n                        return null;\n                    }\n                    const authUser = {\n                        id: String(user.id),\n                        email: user.email,\n                        name: user.username,\n                        role: user.role,\n                        hospitalId: user.hospital_id ? String(user.hospital_id) : null,\n                        hospitalName: user.hospital?.name\n                    };\n                    console.log(\"Authentication successful for user:\", authUser.email);\n                    return authUser;\n                } catch (error) {\n                    console.error(\"Auth error:\", error);\n                    return null;\n                }\n            }\n        })\n    ],\n    callbacks: {\n        async jwt ({ token, user }) {\n            if (user) {\n                console.log(\"JWT callback with user:\", user.email);\n                token.id = user.id;\n                token.role = user.role;\n                token.hospitalId = user.hospitalId;\n                token.hospitalName = user.hospitalName;\n            }\n            return token;\n        },\n        async session ({ session, token }) {\n            console.log(\"Session callback for user:\", token.email);\n            if (session.user && token) {\n                session.user.id = token.id;\n                session.user.role = token.role;\n                session.user.hospitalId = token.hospitalId;\n                session.user.hospitalName = token.hospitalName;\n            }\n            return session;\n        }\n    }\n};\nconst { handlers, auth, signIn, signOut } = (0,next_auth__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(authConfig);\n// Keep the legacy export for backward compatibility if needed\nconst authOptions = authConfig;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/auth.ts\n");

/***/ }),

/***/ "(rsc)/./lib/db.ts":
/*!*******************!*\
  !*** ./lib/db.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   db: () => (/* binding */ db)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\nconst globalForPrisma = globalThis;\nconst db = globalForPrisma.prisma ?? new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient();\nif (true) globalForPrisma.prisma = db;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9saWIvZGIudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQThDO0FBRTlDLE1BQU1DLGtCQUFrQkM7QUFJakIsTUFBTUMsS0FBS0YsZ0JBQWdCRyxNQUFNLElBQUksSUFBSUosd0RBQVlBLEdBQUc7QUFFL0QsSUFBSUssSUFBcUMsRUFBRUosZ0JBQWdCRyxNQUFNLEdBQUdEIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L2xpYi9kYi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcmlzbWFDbGllbnQgfSBmcm9tICdAcHJpc21hL2NsaWVudCc7XG5cbmNvbnN0IGdsb2JhbEZvclByaXNtYSA9IGdsb2JhbFRoaXMgYXMgdW5rbm93biBhcyB7XG4gIHByaXNtYTogUHJpc21hQ2xpZW50IHwgdW5kZWZpbmVkO1xufTtcblxuZXhwb3J0IGNvbnN0IGRiID0gZ2xvYmFsRm9yUHJpc21hLnByaXNtYSA/PyBuZXcgUHJpc21hQ2xpZW50KCk7XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gJ3Byb2R1Y3Rpb24nKSBnbG9iYWxGb3JQcmlzbWEucHJpc21hID0gZGI7ICJdLCJuYW1lcyI6WyJQcmlzbWFDbGllbnQiLCJnbG9iYWxGb3JQcmlzbWEiLCJnbG9iYWxUaGlzIiwiZGIiLCJwcmlzbWEiLCJwcm9jZXNzIl0sImlnbm9yZUxpc3QiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./lib/db.ts\n");

/***/ }),

/***/ "(rsc)/./lib/prisma.ts":
/*!***********************!*\
  !*** ./lib/prisma.ts ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\n// PrismaClient is attached to the `global` object in development to prevent\n// exhausting your database connection limit.\n// Learn more: https://pris.ly/d/help/next-js-best-practices\n// Global variable to store Prisma instance\nconst globalForPrisma = globalThis;\n// Optimized Prisma client configuration\nconst prismaClientSingleton = ()=>{\n    return new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient({\n        log:  true ? [\n            'error',\n            'warn'\n        ] : 0,\n        datasources: {\n            db: {\n                url: process.env.DATABASE_URL\n            }\n        }\n    });\n};\nconst prisma = globalForPrisma.prisma ?? prismaClientSingleton();\n// Simple query performance monitoring\nif (true) {\n    prisma.$use(async (params, next)=>{\n        const before = Date.now();\n        const result = await next(params);\n        const after = Date.now();\n        // Log slow queries (>100ms)\n        if (after - before > 100) {\n            console.log(`🐌 Slow Query: ${params.model}.${params.action} took ${after - before}ms`);\n        }\n        return result;\n    });\n}\n// Graceful shutdown handling\nif (false) {}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prisma);\nif (true) globalForPrisma.prisma = prisma;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/prisma.ts\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Ffindings%2Fseverities%2Froute&page=%2Fapi%2Ffindings%2Fseverities%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Ffindings%2Fseverities%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Ffindings%2Fseverities%2Froute&page=%2Fapi%2Ffindings%2Fseverities%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Ffindings%2Fseverities%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D! ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   patchFetch: () => (/* binding */ patchFetch),\n/* harmony export */   routeModule: () => (/* binding */ routeModule),\n/* harmony export */   serverHooks: () => (/* binding */ serverHooks),\n/* harmony export */   workAsyncStorage: () => (/* binding */ workAsyncStorage),\n/* harmony export */   workUnitAsyncStorage: () => (/* binding */ workUnitAsyncStorage)\n/* harmony export */ });\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/dist/server/route-modules/app-route/module.compiled */ \"(rsc)/./node_modules/next/dist/server/route-modules/app-route/module.compiled.js\");\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next/dist/server/route-kind */ \"(rsc)/./node_modules/next/dist/server/route-kind.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next/dist/server/lib/patch-fetch */ \"(rsc)/./node_modules/next/dist/server/lib/patch-fetch.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _home_rizvi_projects_audit_next_app_api_findings_severities_route_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app/api/findings/severities/route.ts */ \"(rsc)/./app/api/findings/severities/route.ts\");\n\n\n\n\n// We inject the nextConfigOutput here so that we can use them in the route\n// module.\nconst nextConfigOutput = \"\"\nconst routeModule = new next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__.AppRouteRouteModule({\n    definition: {\n        kind: next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__.RouteKind.APP_ROUTE,\n        page: \"/api/findings/severities/route\",\n        pathname: \"/api/findings/severities\",\n        filename: \"route\",\n        bundlePath: \"app/api/findings/severities/route\"\n    },\n    resolvedPagePath: \"/home/rizvi/projects/audit-next/app/api/findings/severities/route.ts\",\n    nextConfigOutput,\n    userland: _home_rizvi_projects_audit_next_app_api_findings_severities_route_ts__WEBPACK_IMPORTED_MODULE_3__\n});\n// Pull out the exports that we need to expose from the module. This should\n// be eliminated when we've moved the other routes to the new format. These\n// are used to hook into the route.\nconst { workAsyncStorage, workUnitAsyncStorage, serverHooks } = routeModule;\nfunction patchFetch() {\n    return (0,next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__.patchFetch)({\n        workAsyncStorage,\n        workUnitAsyncStorage\n    });\n}\n\n\n//# sourceMappingURL=app-route.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9ub2RlX21vZHVsZXMvbmV4dC9kaXN0L2J1aWxkL3dlYnBhY2svbG9hZGVycy9uZXh0LWFwcC1sb2FkZXIvaW5kZXguanM/bmFtZT1hcHAlMkZhcGklMkZmaW5kaW5ncyUyRnNldmVyaXRpZXMlMkZyb3V0ZSZwYWdlPSUyRmFwaSUyRmZpbmRpbmdzJTJGc2V2ZXJpdGllcyUyRnJvdXRlJmFwcFBhdGhzPSZwYWdlUGF0aD1wcml2YXRlLW5leHQtYXBwLWRpciUyRmFwaSUyRmZpbmRpbmdzJTJGc2V2ZXJpdGllcyUyRnJvdXRlLnRzJmFwcERpcj0lMkZob21lJTJGcml6dmklMkZwcm9qZWN0cyUyRmF1ZGl0LW5leHQlMkZhcHAmcGFnZUV4dGVuc2lvbnM9dHN4JnBhZ2VFeHRlbnNpb25zPXRzJnBhZ2VFeHRlbnNpb25zPWpzeCZwYWdlRXh0ZW5zaW9ucz1qcyZyb290RGlyPSUyRmhvbWUlMkZyaXp2aSUyRnByb2plY3RzJTJGYXVkaXQtbmV4dCZpc0Rldj10cnVlJnRzY29uZmlnUGF0aD10c2NvbmZpZy5qc29uJmJhc2VQYXRoPSZhc3NldFByZWZpeD0mbmV4dENvbmZpZ091dHB1dD0mcHJlZmVycmVkUmVnaW9uPSZtaWRkbGV3YXJlQ29uZmlnPWUzMCUzRCEiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7QUFBK0Y7QUFDdkM7QUFDcUI7QUFDb0I7QUFDakc7QUFDQTtBQUNBO0FBQ0Esd0JBQXdCLHlHQUFtQjtBQUMzQztBQUNBLGNBQWMsa0VBQVM7QUFDdkI7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBLFlBQVk7QUFDWixDQUFDO0FBQ0Q7QUFDQTtBQUNBO0FBQ0EsUUFBUSxzREFBc0Q7QUFDOUQ7QUFDQSxXQUFXLDRFQUFXO0FBQ3RCO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDMEY7O0FBRTFGIiwic291cmNlcyI6WyIiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwUm91dGVSb3V0ZU1vZHVsZSB9IGZyb20gXCJuZXh0L2Rpc3Qvc2VydmVyL3JvdXRlLW1vZHVsZXMvYXBwLXJvdXRlL21vZHVsZS5jb21waWxlZFwiO1xuaW1wb3J0IHsgUm91dGVLaW5kIH0gZnJvbSBcIm5leHQvZGlzdC9zZXJ2ZXIvcm91dGUta2luZFwiO1xuaW1wb3J0IHsgcGF0Y2hGZXRjaCBhcyBfcGF0Y2hGZXRjaCB9IGZyb20gXCJuZXh0L2Rpc3Qvc2VydmVyL2xpYi9wYXRjaC1mZXRjaFwiO1xuaW1wb3J0ICogYXMgdXNlcmxhbmQgZnJvbSBcIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvYXBwL2FwaS9maW5kaW5ncy9zZXZlcml0aWVzL3JvdXRlLnRzXCI7XG4vLyBXZSBpbmplY3QgdGhlIG5leHRDb25maWdPdXRwdXQgaGVyZSBzbyB0aGF0IHdlIGNhbiB1c2UgdGhlbSBpbiB0aGUgcm91dGVcbi8vIG1vZHVsZS5cbmNvbnN0IG5leHRDb25maWdPdXRwdXQgPSBcIlwiXG5jb25zdCByb3V0ZU1vZHVsZSA9IG5ldyBBcHBSb3V0ZVJvdXRlTW9kdWxlKHtcbiAgICBkZWZpbml0aW9uOiB7XG4gICAgICAgIGtpbmQ6IFJvdXRlS2luZC5BUFBfUk9VVEUsXG4gICAgICAgIHBhZ2U6IFwiL2FwaS9maW5kaW5ncy9zZXZlcml0aWVzL3JvdXRlXCIsXG4gICAgICAgIHBhdGhuYW1lOiBcIi9hcGkvZmluZGluZ3Mvc2V2ZXJpdGllc1wiLFxuICAgICAgICBmaWxlbmFtZTogXCJyb3V0ZVwiLFxuICAgICAgICBidW5kbGVQYXRoOiBcImFwcC9hcGkvZmluZGluZ3Mvc2V2ZXJpdGllcy9yb3V0ZVwiXG4gICAgfSxcbiAgICByZXNvbHZlZFBhZ2VQYXRoOiBcIi9ob21lL3JpenZpL3Byb2plY3RzL2F1ZGl0LW5leHQvYXBwL2FwaS9maW5kaW5ncy9zZXZlcml0aWVzL3JvdXRlLnRzXCIsXG4gICAgbmV4dENvbmZpZ091dHB1dCxcbiAgICB1c2VybGFuZFxufSk7XG4vLyBQdWxsIG91dCB0aGUgZXhwb3J0cyB0aGF0IHdlIG5lZWQgdG8gZXhwb3NlIGZyb20gdGhlIG1vZHVsZS4gVGhpcyBzaG91bGRcbi8vIGJlIGVsaW1pbmF0ZWQgd2hlbiB3ZSd2ZSBtb3ZlZCB0aGUgb3RoZXIgcm91dGVzIHRvIHRoZSBuZXcgZm9ybWF0LiBUaGVzZVxuLy8gYXJlIHVzZWQgdG8gaG9vayBpbnRvIHRoZSByb3V0ZS5cbmNvbnN0IHsgd29ya0FzeW5jU3RvcmFnZSwgd29ya1VuaXRBc3luY1N0b3JhZ2UsIHNlcnZlckhvb2tzIH0gPSByb3V0ZU1vZHVsZTtcbmZ1bmN0aW9uIHBhdGNoRmV0Y2goKSB7XG4gICAgcmV0dXJuIF9wYXRjaEZldGNoKHtcbiAgICAgICAgd29ya0FzeW5jU3RvcmFnZSxcbiAgICAgICAgd29ya1VuaXRBc3luY1N0b3JhZ2VcbiAgICB9KTtcbn1cbmV4cG9ydCB7IHJvdXRlTW9kdWxlLCB3b3JrQXN5bmNTdG9yYWdlLCB3b3JrVW5pdEFzeW5jU3RvcmFnZSwgc2VydmVySG9va3MsIHBhdGNoRmV0Y2gsICB9O1xuXG4vLyMgc291cmNlTWFwcGluZ1VSTD1hcHAtcm91dGUuanMubWFwIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Ffindings%2Fseverities%2Froute&page=%2Fapi%2Ffindings%2Fseverities%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Ffindings%2Fseverities%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "(ssr)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "../app-render/action-async-storage.external":
/*!*******************************************************************************!*\
  !*** external "next/dist/server/app-render/action-async-storage.external.js" ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/action-async-storage.external.js");

/***/ }),

/***/ "../app-render/after-task-async-storage.external":
/*!***********************************************************************************!*\
  !*** external "next/dist/server/app-render/after-task-async-storage.external.js" ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/after-task-async-storage.external.js");

/***/ }),

/***/ "../app-render/work-async-storage.external":
/*!*****************************************************************************!*\
  !*** external "next/dist/server/app-render/work-async-storage.external.js" ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-async-storage.external.js");

/***/ }),

/***/ "./work-unit-async-storage.external":
/*!**********************************************************************************!*\
  !*** external "next/dist/server/app-render/work-unit-async-storage.external.js" ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-unit-async-storage.external.js");

/***/ }),

/***/ "@prisma/client":
/*!*********************************!*\
  !*** external "@prisma/client" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@prisma/client");

/***/ }),

/***/ "bcrypt":
/*!*************************!*\
  !*** external "bcrypt" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("bcrypt");

/***/ }),

/***/ "crypto":
/*!*************************!*\
  !*** external "crypto" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("crypto");

/***/ }),

/***/ "next/dist/compiled/next-server/app-page.runtime.dev.js":
/*!*************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-page.runtime.dev.js" ***!
  \*************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-page.runtime.dev.js");

/***/ }),

/***/ "next/dist/compiled/next-server/app-route.runtime.dev.js":
/*!**************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-route.runtime.dev.js" ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-route.runtime.dev.js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, ["vendor-chunks/next","vendor-chunks/@auth","vendor-chunks/next-auth","vendor-chunks/oauth4webapi","vendor-chunks/jose","vendor-chunks/preact","vendor-chunks/preact-render-to-string","vendor-chunks/@panva"], () => (__webpack_exec__("(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Ffindings%2Fseverities%2Froute&page=%2Fapi%2Ffindings%2Fseverities%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Ffindings%2Fseverities%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!")));
module.exports = __webpack_exports__;

})();