/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(() => {
var exports = {};
exports.id = "app/api/dashboard/route";
exports.ids = ["app/api/dashboard/route"];
exports.modules = {

/***/ "(rsc)/./app/api/dashboard/route.ts":
/*!************************************!*\
  !*** ./app/api/dashboard/route.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GET: () => (/* binding */ GET)\n/* harmony export */ });\n/* harmony import */ var next_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/server */ \"(rsc)/./node_modules/next/dist/api/server.js\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n/* harmony import */ var _lib_api_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/api-helpers */ \"(rsc)/./lib/api-helpers.ts\");\n/* harmony import */ var _barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! __barrel_optimize__?names=addDays,formatISO,isFuture,isThisMonth!=!date-fns */ \"(rsc)/./node_modules/date-fns/isThisMonth.mjs\");\n/* harmony import */ var _barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! __barrel_optimize__?names=addDays,formatISO,isFuture,isThisMonth!=!date-fns */ \"(rsc)/./node_modules/date-fns/isFuture.mjs\");\n/* harmony import */ var _barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! __barrel_optimize__?names=addDays,formatISO,isFuture,isThisMonth!=!date-fns */ \"(rsc)/./node_modules/date-fns/formatISO.mjs\");\n/* harmony import */ var _barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! __barrel_optimize__?names=addDays,formatISO,isFuture,isThisMonth!=!date-fns */ \"(rsc)/./node_modules/date-fns/addDays.mjs\");\n\n\n\n\nasync function GET(req) {\n    try {\n        // Get context including hospital ID\n        const { hospitalId } = await (0,_lib_api_helpers__WEBPACK_IMPORTED_MODULE_2__.getApiContext)(req);\n        if (!hospitalId) {\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Hospital selection required',\n                message: 'A hospital must be selected to view dashboard data'\n            }, {\n                status: 400\n            });\n        }\n        // Get findings for the hospital\n        const findings = await _lib_prisma__WEBPACK_IMPORTED_MODULE_1__[\"default\"].auditFinding.findMany({\n            where: {\n                hospital_id: hospitalId\n            },\n            orderBy: {\n                date_reported: 'desc'\n            }\n        });\n        // Get actual standards compliance data from the database\n        const standardsData = await _lib_prisma__WEBPACK_IMPORTED_MODULE_1__[\"default\"].standardCompliance.findMany({\n            where: {\n                hospital_id: hospitalId\n            },\n            orderBy: {\n                category: 'asc'\n            }\n        });\n        // Map standards data to the format needed for the dashboard\n        const standards = standardsData.map((std)=>({\n                id: std.id,\n                name: std.standard,\n                category: std.category,\n                compliance: std.compliance,\n                required: std.required_threshold\n            }));\n        // Calculate compliance metrics\n        const totalStandardsCount = standards.length;\n        // Calculate overall compliance score based on actual standards data\n        const complianceScore = totalStandardsCount > 0 ? Math.round(standards.reduce((sum, std)=>sum + std.compliance, 0) / totalStandardsCount) : 0;\n        // For previous score, either fetch historical data or use a placeholder\n        // In a real implementation, we would track historical compliance data\n        const previousComplianceScore = Math.max(complianceScore - 4, 0);\n        // Calculate findings metrics\n        const resolvedThisMonth = findings.filter((finding)=>finding.status === 'resolved' && finding.resolution_date && (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_3__.isThisMonth)(new Date(finding.resolution_date))).length;\n        const upcomingDeadlines = findings.filter((finding)=>finding.status !== 'resolved' && finding.timeline && (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_4__.isFuture)(new Date(finding.timeline))).length;\n        // Get latest findings\n        const recentFindings = findings.slice(0, 3);\n        // Get staff compliance data from database and calculate overall rate\n        const staffComplianceData = await _lib_prisma__WEBPACK_IMPORTED_MODULE_1__[\"default\"].staffCompliance.findMany({\n            where: {\n                hospital_id: hospitalId\n            },\n            orderBy: {\n                department: 'asc'\n            }\n        });\n        // Calculate overall staff compliance rate\n        let staffCompliancePercentage = 0;\n        if (staffComplianceData.length > 0) {\n            const totalStaff = staffComplianceData.reduce((sum, dept)=>sum + dept.staff_count, 0);\n            const weightedCompliance = staffComplianceData.reduce((sum, dept)=>sum + dept.compliance_rate * dept.staff_count, 0);\n            staffCompliancePercentage = totalStaff > 0 ? Math.round(weightedCompliance / totalStaff) : 0;\n            console.log(`📊 Staff compliance calculation for hospital ${hospitalId}:`);\n            console.log(`  - Departments found: ${staffComplianceData.length}`);\n            console.log(`  - Total staff: ${totalStaff}`);\n            console.log(`  - Weighted compliance sum: ${weightedCompliance}`);\n            console.log(`  - Final percentage: ${staffCompliancePercentage}%`);\n        } else {\n            console.log(`⚠️ No staff compliance data found for hospital ${hospitalId}`);\n        }\n        // Generate compliance cards based on standards data\n        const complianceCards = standards.slice(0, 3).map((std)=>{\n            const status = std.compliance >= std.required ? 'compliant' : std.compliance >= std.required - 10 ? 'at-risk' : 'non-compliant';\n            return {\n                title: `${std.name} Compliance`,\n                description: `Category: ${std.category}`,\n                standard: std.name,\n                status,\n                dueDate: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), Math.floor(Math.random() * 60) + 1), {\n                    representation: 'date'\n                }),\n                compliance: std.compliance,\n                required: std.required\n            };\n        });\n        // Generate action items based on findings and compliance status\n        const actionItems = [];\n        // Add items for critical findings\n        const criticalFindings = findings.filter((f)=>f.severity === 'critical' && f.status !== 'resolved').slice(0, 2);\n        criticalFindings.forEach((finding)=>{\n            actionItems.push({\n                id: `finding-${finding.id}`,\n                title: `Resolve critical finding: ${finding.title}`,\n                dueDate: finding.timeline ? (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)(new Date(finding.timeline), {\n                    representation: 'date'\n                }) : (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), 7), {\n                    representation: 'date'\n                }),\n                priority: 'high',\n                assignee: 'Compliance Team',\n                category: 'finding'\n            });\n        });\n        // Add items for low compliance standards\n        const lowComplianceStandards = standards.filter((s)=>s.compliance < s.required).slice(0, 3 - actionItems.length);\n        lowComplianceStandards.forEach((std, index)=>{\n            actionItems.push({\n                id: `compliance-${std.id}`,\n                title: `Improve ${std.name} compliance from ${std.compliance}% to ${std.required}%`,\n                dueDate: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), (index + 1) * 15), {\n                    representation: 'date'\n                }),\n                priority: std.compliance < std.required - 15 ? 'high' : 'medium',\n                assignee: 'Quality Manager',\n                category: 'compliance'\n            });\n        });\n        // If we still need more items, add some general ones\n        if (actionItems.length < 3) {\n            actionItems.push({\n                id: 'training-1',\n                title: 'Update staff emergency response training materials',\n                dueDate: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), 30), {\n                    representation: 'date'\n                }),\n                priority: 'low',\n                assignee: 'Training Dept.',\n                category: 'training'\n            });\n        }\n        // Generate regulatory news based on standards\n        const regulatoryNews = [\n            {\n                id: 'news-1',\n                title: `${standards[0]?.name || 'HIPAA'} Privacy Rule Amendments`,\n                description: 'New patient data sharing requirements coming into effect next quarter.',\n                date: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)(new Date(), {\n                    representation: 'date'\n                }),\n                category: 'regulation',\n                severity: 'info'\n            },\n            {\n                id: 'news-2',\n                title: 'Joint Commission Patient Safety Goals Update',\n                description: 'Updated criteria for medication reconciliation processes.',\n                date: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), -3), {\n                    representation: 'date'\n                }),\n                category: 'safety',\n                severity: 'warning'\n            },\n            {\n                id: 'news-3',\n                title: 'FDA Guidance on Medical Device Security',\n                description: 'New cybersecurity requirements for connected medical devices.',\n                date: (0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_5__.formatISO)((0,_barrel_optimize_names_addDays_formatISO_isFuture_isThisMonth_date_fns__WEBPACK_IMPORTED_MODULE_6__.addDays)(new Date(), -7), {\n                    representation: 'date'\n                }),\n                category: 'security',\n                severity: 'info'\n            }\n        ];\n        // Calculate trend data for metrics\n        const trends = {\n            totalStandards: {\n                value: 5,\n                isPositive: true,\n                label: \"from last month\"\n            },\n            auditsCompleted: {\n                value: Math.abs(resolvedThisMonth - 3),\n                isPositive: resolvedThisMonth >= 3,\n                label: \"vs. last month\"\n            },\n            upcomingDeadlines: {\n                value: upcomingDeadlines,\n                isNeutral: true,\n                label: \"in next 14 days\"\n            },\n            staffCompliance: {\n                value: 3,\n                isPositive: false,\n                label: \"below target\"\n            }\n        };\n        console.log(`🚀 Returning dashboard data with staff compliance: ${staffCompliancePercentage}%`);\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n            metrics: {\n                auditCompletedCount: resolvedThisMonth,\n                upcomingDeadlinesCount: upcomingDeadlines,\n                staffCompliancePercentage,\n                totalStandardsCount,\n                complianceScore,\n                previousComplianceScore,\n                standardsData: standards,\n                trends\n            },\n            recentFindings,\n            complianceCards,\n            actionItems,\n            regulatoryNews\n        });\n    } catch (error) {\n        return (0,_lib_api_helpers__WEBPACK_IMPORTED_MODULE_2__.handleApiError)(error);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./app/api/dashboard/route.ts\n");

/***/ }),

/***/ "(rsc)/./lib/api-helpers.ts":
/*!****************************!*\
  !*** ./lib/api-helpers.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ApiError: () => (/* binding */ ApiError),\n/* harmony export */   createApiResponse: () => (/* binding */ createApiResponse),\n/* harmony export */   createErrorResponse: () => (/* binding */ createErrorResponse),\n/* harmony export */   getApiContext: () => (/* binding */ getApiContext),\n/* harmony export */   getAuthenticatedSession: () => (/* binding */ getAuthenticatedSession),\n/* harmony export */   handleApiError: () => (/* binding */ handleApiError),\n/* harmony export */   hasHospitalAccess: () => (/* binding */ hasHospitalAccess),\n/* harmony export */   withAuth: () => (/* binding */ withAuth)\n/* harmony export */ });\n/* harmony import */ var next_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/server */ \"(rsc)/./node_modules/next/dist/api/server.js\");\n/* harmony import */ var _lib_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/lib/auth */ \"(rsc)/./lib/auth.ts\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n\n\n\n/**\n * Gets the hospital ID from various sources (header, URL, user record)\n * Ensures consistent hospital ID handling across API routes\n */ async function getApiContext(req) {\n    // Get the session\n    const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n    if (!session || !session.user?.email) {\n        throw new Error('Unauthorized');\n    }\n    // Get the user from the database\n    const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n        where: {\n            email: session.user.email\n        },\n        select: {\n            id: true,\n            username: true,\n            email: true,\n            role: true,\n            hospital_id: true\n        }\n    });\n    if (!user) {\n        throw new Error('User not found');\n    }\n    const isSuperAdmin = user.role === 'super_admin';\n    // Get the hospital ID\n    let hospitalId = null;\n    if (isSuperAdmin) {\n        // For super admins, try to get hospital ID from header, URL, or body\n        let headerHospitalId = null;\n        let urlHospitalId = null;\n        // Handle case where req might be empty or undefined (for GET requests without a request object)\n        if (!req || typeof req !== 'object') {\n            console.log(\"WARNING: Request object is empty or undefined. Using cookies from server request.\");\n        // Continue without trying to access req - we'll use cookies instead\n        } else if (req instanceof Request) {\n            const headers = new Headers(req.headers);\n            headerHospitalId = headers.get('x-hospital-id');\n            // Get hospital ID from URL query parameter\n            const url = new URL(req.url);\n            urlHospitalId = url.searchParams.get('hospitalId');\n        } else if (req.headers && typeof req.headers.get === 'function') {\n            headerHospitalId = req.headers.get('x-hospital-id');\n            // Get hospital ID from URL query parameter if nextUrl exists\n            if (req.nextUrl && typeof req.nextUrl.searchParams?.get === 'function') {\n                urlHospitalId = req.nextUrl.searchParams.get('hospitalId');\n            }\n        }\n        // Get hospital ID from cookies\n        let cookieHospitalId = null;\n        // Try to get from cookies in the request\n        if (req instanceof Request) {\n            // Parse cookies from Request header\n            const cookieHeader = new Headers(req.headers).get('cookie');\n            if (cookieHeader) {\n                const cookies = parseCookieString(cookieHeader);\n                cookieHospitalId = cookies.selectedHospitalId || null;\n            }\n        } else if (req && req.cookies && typeof req.cookies.get === 'function') {\n            cookieHospitalId = req.cookies.get('selectedHospitalId')?.value || null;\n        }\n        // If we couldn't get from request, try the server request object\n        if (!cookieHospitalId) {\n            // Try to get from global request context\n            const { cookies } = __webpack_require__(/*! next/headers */ \"(rsc)/./node_modules/next/dist/api/headers.js\");\n            try {\n                const cookieStore = cookies();\n                if (cookieStore && typeof cookieStore.get === 'function') {\n                    const cookie = cookieStore.get('selectedHospitalId');\n                    cookieHospitalId = cookie?.value || null;\n                }\n            } catch (e) {\n                console.error('Error accessing server cookies:', e);\n            }\n        }\n        // Try to get hospital ID from body if it's a POST or PUT request\n        let bodyHospitalId = null;\n        if (req instanceof Request && req.method && [\n            'POST',\n            'PUT'\n        ].includes(req.method)) {\n            try {\n                const clone = req.clone(); // Clone the request to avoid consuming the body\n                const body = await clone.json();\n                bodyHospitalId = body.hospitalId?.toString() || null;\n            } catch (e) {\n            // Ignore error if body can't be parsed\n            }\n        }\n        // Use the first available hospital ID\n        const hospitalIdStr = headerHospitalId || urlHospitalId || cookieHospitalId || bodyHospitalId;\n        // Debug log all sources\n        console.log('Hospital ID sources:', {\n            header: headerHospitalId,\n            url: urlHospitalId,\n            cookie: cookieHospitalId,\n            body: bodyHospitalId,\n            selected: hospitalIdStr\n        });\n        if (hospitalIdStr) {\n            const parsed = parseInt(hospitalIdStr);\n            if (!isNaN(parsed)) {\n                hospitalId = parsed;\n            }\n        }\n    } else {\n        // For regular users, always use their assigned hospital\n        if (user.hospital_id) {\n            hospitalId = user.hospital_id;\n            console.log(`Using assigned hospital ID for regular user: ${hospitalId}`);\n        } else {\n            console.log('Warning: User has no assigned hospital_id');\n            throw new Error('User has no assigned hospital. Please contact an administrator.');\n        }\n    }\n    return {\n        req,\n        session,\n        user,\n        isSuperAdmin,\n        hospitalId\n    };\n}\n/**\n * Helper function to parse cookies from a cookie header string\n */ function parseCookieString(cookieHeader) {\n    return cookieHeader.split(';').reduce((cookies, cookie)=>{\n        const [name, value] = cookie.trim().split('=').map((c)=>c.trim());\n        if (name && value) cookies[name] = value;\n        return cookies;\n    }, {});\n}\n/**\n * Helper function to verify if a user has access to a specific hospital\n */ async function hasHospitalAccess(userEmail, hospitalId) {\n    const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n        where: {\n            email: userEmail\n        },\n        select: {\n            role: true,\n            hospital_id: true\n        }\n    });\n    if (!user) return false;\n    // Super admins have access to all hospitals\n    if (user.role === 'super_admin') return true;\n    // Regular users only have access to their assigned hospital\n    return user.hospital_id === hospitalId;\n}\n/**\n * Standard error handler for API routes\n */ function handleApiError(error, statusCode = 500) {\n    console.error('API error:', error);\n    return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n        error: error instanceof Error ? error.message : 'An unexpected error occurred',\n        details: error instanceof Error ? error.stack : String(error)\n    }, {\n        status: statusCode\n    });\n}\nclass ApiError extends Error {\n    constructor(message, status = 500){\n        super(message), this.message = message, this.status = status;\n        this.name = 'ApiError';\n    }\n}\nasync function getAuthenticatedSession() {\n    try {\n        const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n        if (!session?.user) {\n            throw new ApiError('Unauthorized access', 401);\n        }\n        return session;\n    } catch (error) {\n        console.error('Session error:', error);\n        throw new ApiError('Authentication failed', 401);\n    }\n}\nfunction createApiResponse(data, message) {\n    return {\n        data,\n        message,\n        success: true\n    };\n}\nfunction createErrorResponse(error, status = 500) {\n    return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n        error,\n        success: false\n    }, {\n        status\n    });\n}\nasync function withAuth(handler) {\n    try {\n        const session = await getAuthenticatedSession();\n        const result = await handler(session);\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json(createApiResponse(result));\n    } catch (error) {\n        if (error instanceof ApiError) {\n            return createErrorResponse(error.message, error.status);\n        }\n        console.error('Unexpected error:', error);\n        return createErrorResponse('Internal server error', 500);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/api-helpers.ts\n");

/***/ }),

/***/ "(rsc)/./lib/auth.ts":
/*!*********************!*\
  !*** ./lib/auth.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   auth: () => (/* binding */ auth),\n/* harmony export */   authOptions: () => (/* binding */ authOptions),\n/* harmony export */   handlers: () => (/* binding */ handlers),\n/* harmony export */   signIn: () => (/* binding */ signIn),\n/* harmony export */   signOut: () => (/* binding */ signOut)\n/* harmony export */ });\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bcrypt */ \"bcrypt\");\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(bcrypt__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next-auth */ \"(rsc)/./node_modules/next-auth/index.js\");\n/* harmony import */ var next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next-auth/providers/credentials */ \"(rsc)/./node_modules/next-auth/providers/credentials.js\");\n/* harmony import */ var _db__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./db */ \"(rsc)/./lib/db.ts\");\n\n\n\n\nconst authConfig = {\n    session: {\n        strategy: \"jwt\",\n        maxAge: 30 * 24 * 60 * 60\n    },\n    pages: {\n        signIn: \"/login\",\n        signOut: \"/login\",\n        error: \"/login\"\n    },\n    secret: process.env.NEXTAUTH_SECRET || \"your-default-secret-do-not-use-in-production\",\n    debug: true,\n    providers: [\n        (0,next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__[\"default\"])({\n            name: \"credentials\",\n            credentials: {\n                email: {\n                    label: \"Email\",\n                    type: \"email\"\n                },\n                password: {\n                    label: \"Password\",\n                    type: \"password\"\n                }\n            },\n            async authorize (credentials) {\n                console.log(\"Authorizing with credentials:\", credentials?.email);\n                if (!credentials?.email || !credentials?.password) {\n                    console.log(\"Missing credentials\");\n                    return null;\n                }\n                try {\n                    const user = await _db__WEBPACK_IMPORTED_MODULE_3__.db.user.findUnique({\n                        where: {\n                            email: credentials.email\n                        },\n                        include: {\n                            hospital: true\n                        }\n                    });\n                    console.log(\"User found:\", user ? \"Yes\" : \"No\");\n                    if (!user) {\n                        return null;\n                    }\n                    const isPasswordValid = await (0,bcrypt__WEBPACK_IMPORTED_MODULE_0__.compare)(credentials.password, user.password);\n                    console.log(\"Password valid:\", isPasswordValid);\n                    if (!isPasswordValid) {\n                        return null;\n                    }\n                    const authUser = {\n                        id: String(user.id),\n                        email: user.email,\n                        name: user.username,\n                        role: user.role,\n                        hospitalId: user.hospital_id ? String(user.hospital_id) : null,\n                        hospitalName: user.hospital?.name\n                    };\n                    console.log(\"Authentication successful for user:\", authUser.email);\n                    return authUser;\n                } catch (error) {\n                    console.error(\"Auth error:\", error);\n                    return null;\n                }\n            }\n        })\n    ],\n    callbacks: {\n        async jwt ({ token, user }) {\n            if (user) {\n                console.log(\"JWT callback with user:\", user.email);\n                token.id = user.id;\n                token.role = user.role;\n                token.hospitalId = user.hospitalId;\n                token.hospitalName = user.hospitalName;\n            }\n            return token;\n        },\n        async session ({ session, token }) {\n            console.log(\"Session callback for user:\", token.email);\n            if (session.user && token) {\n                session.user.id = token.id;\n                session.user.role = token.role;\n                session.user.hospitalId = token.hospitalId;\n                session.user.hospitalName = token.hospitalName;\n            }\n            return session;\n        }\n    }\n};\nconst { handlers, auth, signIn, signOut } = (0,next_auth__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(authConfig);\n// Keep the legacy export for backward compatibility if needed\nconst authOptions = authConfig;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/auth.ts\n");

/***/ }),

/***/ "(rsc)/./lib/db.ts":
/*!*******************!*\
  !*** ./lib/db.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   db: () => (/* binding */ db)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\nconst globalForPrisma = globalThis;\nconst db = globalForPrisma.prisma ?? new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient();\nif (true) globalForPrisma.prisma = db;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9saWIvZGIudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQThDO0FBRTlDLE1BQU1DLGtCQUFrQkM7QUFJakIsTUFBTUMsS0FBS0YsZ0JBQWdCRyxNQUFNLElBQUksSUFBSUosd0RBQVlBLEdBQUc7QUFFL0QsSUFBSUssSUFBcUMsRUFBRUosZ0JBQWdCRyxNQUFNLEdBQUdEIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L2xpYi9kYi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcmlzbWFDbGllbnQgfSBmcm9tICdAcHJpc21hL2NsaWVudCc7XG5cbmNvbnN0IGdsb2JhbEZvclByaXNtYSA9IGdsb2JhbFRoaXMgYXMgdW5rbm93biBhcyB7XG4gIHByaXNtYTogUHJpc21hQ2xpZW50IHwgdW5kZWZpbmVkO1xufTtcblxuZXhwb3J0IGNvbnN0IGRiID0gZ2xvYmFsRm9yUHJpc21hLnByaXNtYSA/PyBuZXcgUHJpc21hQ2xpZW50KCk7XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gJ3Byb2R1Y3Rpb24nKSBnbG9iYWxGb3JQcmlzbWEucHJpc21hID0gZGI7ICJdLCJuYW1lcyI6WyJQcmlzbWFDbGllbnQiLCJnbG9iYWxGb3JQcmlzbWEiLCJnbG9iYWxUaGlzIiwiZGIiLCJwcmlzbWEiLCJwcm9jZXNzIl0sImlnbm9yZUxpc3QiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./lib/db.ts\n");

/***/ }),

/***/ "(rsc)/./lib/prisma.ts":
/*!***********************!*\
  !*** ./lib/prisma.ts ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\n// PrismaClient is attached to the `global` object in development to prevent\n// exhausting your database connection limit.\n// Learn more: https://pris.ly/d/help/next-js-best-practices\n// Global variable to store Prisma instance\nconst globalForPrisma = globalThis;\n// Optimized Prisma client configuration\nconst prismaClientSingleton = ()=>{\n    return new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient({\n        log:  true ? [\n            'error',\n            'warn'\n        ] : 0,\n        datasources: {\n            db: {\n                url: process.env.DATABASE_URL\n            }\n        }\n    });\n};\nconst prisma = globalForPrisma.prisma ?? prismaClientSingleton();\n// Simple query performance monitoring\nif (true) {\n    prisma.$use(async (params, next)=>{\n        const before = Date.now();\n        const result = await next(params);\n        const after = Date.now();\n        // Log slow queries (>100ms)\n        if (after - before > 100) {\n            console.log(`🐌 Slow Query: ${params.model}.${params.action} took ${after - before}ms`);\n        }\n        return result;\n    });\n}\n// Graceful shutdown handling\nif (false) {}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prisma);\nif (true) globalForPrisma.prisma = prisma;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/prisma.ts\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fdashboard%2Froute&page=%2Fapi%2Fdashboard%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fdashboard%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fdashboard%2Froute&page=%2Fapi%2Fdashboard%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fdashboard%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D! ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   patchFetch: () => (/* binding */ patchFetch),\n/* harmony export */   routeModule: () => (/* binding */ routeModule),\n/* harmony export */   serverHooks: () => (/* binding */ serverHooks),\n/* harmony export */   workAsyncStorage: () => (/* binding */ workAsyncStorage),\n/* harmony export */   workUnitAsyncStorage: () => (/* binding */ workUnitAsyncStorage)\n/* harmony export */ });\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/dist/server/route-modules/app-route/module.compiled */ \"(rsc)/./node_modules/next/dist/server/route-modules/app-route/module.compiled.js\");\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next/dist/server/route-kind */ \"(rsc)/./node_modules/next/dist/server/route-kind.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next/dist/server/lib/patch-fetch */ \"(rsc)/./node_modules/next/dist/server/lib/patch-fetch.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _home_rizvi_projects_audit_next_app_api_dashboard_route_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app/api/dashboard/route.ts */ \"(rsc)/./app/api/dashboard/route.ts\");\n\n\n\n\n// We inject the nextConfigOutput here so that we can use them in the route\n// module.\nconst nextConfigOutput = \"\"\nconst routeModule = new next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__.AppRouteRouteModule({\n    definition: {\n        kind: next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__.RouteKind.APP_ROUTE,\n        page: \"/api/dashboard/route\",\n        pathname: \"/api/dashboard\",\n        filename: \"route\",\n        bundlePath: \"app/api/dashboard/route\"\n    },\n    resolvedPagePath: \"/home/rizvi/projects/audit-next/app/api/dashboard/route.ts\",\n    nextConfigOutput,\n    userland: _home_rizvi_projects_audit_next_app_api_dashboard_route_ts__WEBPACK_IMPORTED_MODULE_3__\n});\n// Pull out the exports that we need to expose from the module. This should\n// be eliminated when we've moved the other routes to the new format. These\n// are used to hook into the route.\nconst { workAsyncStorage, workUnitAsyncStorage, serverHooks } = routeModule;\nfunction patchFetch() {\n    return (0,next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__.patchFetch)({\n        workAsyncStorage,\n        workUnitAsyncStorage\n    });\n}\n\n\n//# sourceMappingURL=app-route.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fdashboard%2Froute&page=%2Fapi%2Fdashboard%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fdashboard%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "(ssr)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "../app-render/action-async-storage.external":
/*!*******************************************************************************!*\
  !*** external "next/dist/server/app-render/action-async-storage.external.js" ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/action-async-storage.external.js");

/***/ }),

/***/ "../app-render/after-task-async-storage.external":
/*!***********************************************************************************!*\
  !*** external "next/dist/server/app-render/after-task-async-storage.external.js" ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/after-task-async-storage.external.js");

/***/ }),

/***/ "../app-render/work-async-storage.external":
/*!*****************************************************************************!*\
  !*** external "next/dist/server/app-render/work-async-storage.external.js" ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-async-storage.external.js");

/***/ }),

/***/ "./work-unit-async-storage.external":
/*!**********************************************************************************!*\
  !*** external "next/dist/server/app-render/work-unit-async-storage.external.js" ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-unit-async-storage.external.js");

/***/ }),

/***/ "@prisma/client":
/*!*********************************!*\
  !*** external "@prisma/client" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@prisma/client");

/***/ }),

/***/ "bcrypt":
/*!*************************!*\
  !*** external "bcrypt" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("bcrypt");

/***/ }),

/***/ "crypto":
/*!*************************!*\
  !*** external "crypto" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("crypto");

/***/ }),

/***/ "next/dist/compiled/next-server/app-page.runtime.dev.js":
/*!*************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-page.runtime.dev.js" ***!
  \*************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-page.runtime.dev.js");

/***/ }),

/***/ "next/dist/compiled/next-server/app-route.runtime.dev.js":
/*!**************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-route.runtime.dev.js" ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-route.runtime.dev.js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, ["vendor-chunks/next","vendor-chunks/@auth","vendor-chunks/next-auth","vendor-chunks/oauth4webapi","vendor-chunks/jose","vendor-chunks/preact","vendor-chunks/preact-render-to-string","vendor-chunks/@panva","vendor-chunks/date-fns"], () => (__webpack_exec__("(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fdashboard%2Froute&page=%2Fapi%2Fdashboard%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fdashboard%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!")));
module.exports = __webpack_exports__;

})();