/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(() => {
var exports = {};
exports.id = "app/api/admin/hospitals/route";
exports.ids = ["app/api/admin/hospitals/route"];
exports.modules = {

/***/ "(rsc)/./app/api/admin/hospitals/route.ts":
/*!******************************************!*\
  !*** ./app/api/admin/hospitals/route.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GET: () => (/* binding */ GET),\n/* harmony export */   POST: () => (/* binding */ POST)\n/* harmony export */ });\n/* harmony import */ var next_server__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/server */ \"(rsc)/./node_modules/next/dist/api/server.js\");\n/* harmony import */ var _lib_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/lib/auth */ \"(rsc)/./lib/auth.ts\");\n/* harmony import */ var _lib_prisma__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/lib/prisma */ \"(rsc)/./lib/prisma.ts\");\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! bcrypt */ \"bcrypt\");\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(bcrypt__WEBPACK_IMPORTED_MODULE_3__);\n\n\n\n\n// Helper to generate a secure password\nconst generateSecurePassword = ()=>{\n    const length = 12;\n    const charset = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+';\n    let password = '';\n    for(let i = 0; i < length; i++){\n        const randomIndex = Math.floor(Math.random() * charset.length);\n        password += charset[randomIndex];\n    }\n    return password;\n};\n// GET - Fetch all hospitals\nasync function GET(request) {\n    try {\n        // Check database connection first\n        try {\n            await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].$connect();\n            console.log('Database connection successful');\n        } catch (connectionError) {\n            console.error('Database connection failed:', connectionError instanceof Error ? connectionError.message : String(connectionError));\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Database connection failed',\n                details: connectionError instanceof Error ? connectionError.message : String(connectionError)\n            }, {\n                status: 503\n            });\n        }\n        const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n        if (!session) {\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Unauthorized'\n            }, {\n                status: 401\n            });\n        }\n        const userEmail = session.user?.email;\n        // Get user and check if super_admin\n        const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n            where: {\n                email: userEmail\n            },\n            select: {\n                role: true\n            }\n        });\n        if (!user || user.role !== 'super_admin') {\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Forbidden - Requires super admin access'\n            }, {\n                status: 403\n            });\n        }\n        // Fetch all hospitals with their admin users\n        const hospitals = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].hospital.findMany({\n            include: {\n                users: {\n                    where: {\n                        role: 'hospital'\n                    },\n                    select: {\n                        id: true,\n                        username: true,\n                        email: true\n                    }\n                }\n            },\n            orderBy: {\n                name: 'asc'\n            }\n        });\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json(hospitals);\n    } catch (error) {\n        // Fix the console.error null payload issue\n        if (error) {\n            console.error('Error fetching hospitals:', error instanceof Error ? error.message : String(error));\n        }\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n            error: 'Failed to fetch hospitals',\n            details: error instanceof Error ? error.message : String(error)\n        }, {\n            status: 500\n        });\n    }\n}\n// POST - Create a new hospital with admin user\nasync function POST(request) {\n    try {\n        console.log('Starting hospital creation...');\n        // Test database connection with more specific error handling\n        try {\n            await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].$connect();\n            const dbTest = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].hospital.count();\n            console.log('Database connection test successful. Hospital count:', dbTest);\n        } catch (dbError) {\n            // Fix the console.error null payload issue\n            if (dbError) {\n                console.error('Database connection test failed:', dbError instanceof Error ? dbError.message : String(dbError));\n            }\n            // Check for specific database connection errors\n            const errorMessage = dbError instanceof Error ? dbError.message : String(dbError);\n            if (errorMessage.includes(\"Can't reach database server\")) {\n                return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                    error: 'Database server not reachable',\n                    details: 'Please make sure your MySQL server is running at localhost:3006.',\n                    originalError: errorMessage\n                }, {\n                    status: 503\n                });\n            }\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Database connection failed',\n                details: errorMessage\n            }, {\n                status: 500\n            });\n        }\n        // Override NEXTAUTH_URL if needed\n        if (process.env.NEXTAUTH_URL !== 'http://localhost:3002') {\n            console.log(`Overriding NEXTAUTH_URL from ${process.env.NEXTAUTH_URL} to http://localhost:3002`);\n            process.env.NEXTAUTH_URL = 'http://localhost:3002';\n        }\n        const session = await (0,_lib_auth__WEBPACK_IMPORTED_MODULE_1__.auth)();\n        console.log('Session details:', {\n            exists: !!session,\n            user: session?.user ? {\n                name: session.user.name,\n                email: session.user.email,\n                role: session.user.role\n            } : 'No user in session'\n        });\n        if (!session) {\n            console.log('No session found');\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Unauthorized'\n            }, {\n                status: 401\n            });\n        }\n        const userEmail = session.user?.email;\n        console.log('User email:', userEmail);\n        // Get user and check if super_admin\n        const user = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n            where: {\n                email: userEmail\n            },\n            select: {\n                role: true\n            }\n        });\n        console.log('User found:', user);\n        if (!user || user.role !== 'super_admin') {\n            console.log('User is not a super admin:', user?.role);\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Forbidden - Requires super admin access'\n            }, {\n                status: 403\n            });\n        }\n        const data = await request.json();\n        console.log('Request data:', JSON.stringify(data));\n        // Validate the hospital data\n        if (!data.name || !data.location) {\n            console.log('Missing required hospital data');\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Invalid data. Hospital name and location are required.'\n            }, {\n                status: 400\n            });\n        }\n        // Validate admin user data\n        if (!data.adminEmail || !data.adminUsername) {\n            console.log('Missing required admin user data');\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Invalid data. Admin email and username are required.'\n            }, {\n                status: 400\n            });\n        }\n        // Check if admin email already exists\n        const existingUser = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].user.findUnique({\n            where: {\n                email: data.adminEmail\n            }\n        });\n        if (existingUser) {\n            console.log('Email already exists:', data.adminEmail);\n            return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n                error: 'Admin email already exists. Please use a different email.'\n            }, {\n                status: 400\n            });\n        }\n        console.log('Starting transaction...');\n        // Create transaction to ensure both hospital and user are created\n        const result = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].$transaction(async (prisma)=>{\n            console.log('Creating hospital...');\n            // Create the hospital\n            const hospital = await prisma.hospital.create({\n                data: {\n                    name: data.name,\n                    location: data.location,\n                    logo_url: data.logoUrl || null\n                }\n            });\n            console.log('Hospital created:', hospital);\n            // Generate a secure password for the admin user\n            const password = data.password || generateSecurePassword();\n            console.log('Hashing password...');\n            const hashedPassword = await (0,bcrypt__WEBPACK_IMPORTED_MODULE_3__.hash)(password, 10);\n            console.log('Creating admin user...');\n            try {\n                // Create the admin user for this hospital\n                const adminUser = await prisma.user.create({\n                    data: {\n                        username: data.adminUsername,\n                        email: data.adminEmail,\n                        password: hashedPassword,\n                        role: 'hospital',\n                        hospital_id: hospital.id,\n                        auth0_id: null // Explicitly set auth0_id to null since it's optional\n                    }\n                });\n                console.log('Admin user created:', adminUser.id);\n                return {\n                    hospital,\n                    adminUser,\n                    plainPassword: password\n                };\n            } catch (userError) {\n                // Fix the console.error null payload issue\n                if (userError) {\n                    console.error('Error creating user:', userError instanceof Error ? userError.message : String(userError));\n                }\n                // Throw a more specific error\n                throw new Error(`Failed to create admin user: ${userError instanceof Error ? userError.message : String(userError)}`);\n            }\n        });\n        console.log('Transaction completed successfully');\n        // Fetch the hospital with its users to match the expected format\n        const hospitalWithUsers = await _lib_prisma__WEBPACK_IMPORTED_MODULE_2__[\"default\"].hospital.findUnique({\n            where: {\n                id: result.hospital.id\n            },\n            include: {\n                users: {\n                    where: {\n                        role: 'hospital'\n                    },\n                    select: {\n                        id: true,\n                        username: true,\n                        email: true\n                    }\n                }\n            }\n        });\n        // Return the created hospital and admin info\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n            hospital: hospitalWithUsers,\n            adminUser: {\n                id: result.adminUser.id,\n                username: result.adminUser.username,\n                email: result.adminUser.email\n            },\n            // Include plain password only in response for first-time setup\n            temporaryPassword: result.plainPassword\n        }, {\n            status: 201\n        });\n    } catch (error) {\n        // Fix the console.error null payload issue\n        if (error) {\n            console.error('Error creating hospital:', error instanceof Error ? error.message : String(error));\n        }\n        // Return more detailed error information for debugging\n        return next_server__WEBPACK_IMPORTED_MODULE_0__.NextResponse.json({\n            error: 'Failed to create hospital',\n            details: error instanceof Error ? error.message : String(error)\n        }, {\n            status: 500\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./app/api/admin/hospitals/route.ts\n");

/***/ }),

/***/ "(rsc)/./lib/auth.ts":
/*!*********************!*\
  !*** ./lib/auth.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   auth: () => (/* binding */ auth),\n/* harmony export */   authOptions: () => (/* binding */ authOptions),\n/* harmony export */   handlers: () => (/* binding */ handlers),\n/* harmony export */   signIn: () => (/* binding */ signIn),\n/* harmony export */   signOut: () => (/* binding */ signOut)\n/* harmony export */ });\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bcrypt */ \"bcrypt\");\n/* harmony import */ var bcrypt__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(bcrypt__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next-auth */ \"(rsc)/./node_modules/next-auth/index.js\");\n/* harmony import */ var next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next-auth/providers/credentials */ \"(rsc)/./node_modules/next-auth/providers/credentials.js\");\n/* harmony import */ var _db__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./db */ \"(rsc)/./lib/db.ts\");\n\n\n\n\nconst authConfig = {\n    session: {\n        strategy: \"jwt\",\n        maxAge: 30 * 24 * 60 * 60\n    },\n    pages: {\n        signIn: \"/login\",\n        signOut: \"/login\",\n        error: \"/login\"\n    },\n    secret: process.env.NEXTAUTH_SECRET || \"your-default-secret-do-not-use-in-production\",\n    debug: true,\n    providers: [\n        (0,next_auth_providers_credentials__WEBPACK_IMPORTED_MODULE_2__[\"default\"])({\n            name: \"credentials\",\n            credentials: {\n                email: {\n                    label: \"Email\",\n                    type: \"email\"\n                },\n                password: {\n                    label: \"Password\",\n                    type: \"password\"\n                }\n            },\n            async authorize (credentials) {\n                console.log(\"Authorizing with credentials:\", credentials?.email);\n                if (!credentials?.email || !credentials?.password) {\n                    console.log(\"Missing credentials\");\n                    return null;\n                }\n                try {\n                    const user = await _db__WEBPACK_IMPORTED_MODULE_3__.db.user.findUnique({\n                        where: {\n                            email: credentials.email\n                        },\n                        include: {\n                            hospital: true\n                        }\n                    });\n                    console.log(\"User found:\", user ? \"Yes\" : \"No\");\n                    if (!user) {\n                        return null;\n                    }\n                    const isPasswordValid = await (0,bcrypt__WEBPACK_IMPORTED_MODULE_0__.compare)(credentials.password, user.password);\n                    console.log(\"Password valid:\", isPasswordValid);\n                    if (!isPasswordValid) {\n                        return null;\n                    }\n                    const authUser = {\n                        id: String(user.id),\n                        email: user.email,\n                        name: user.username,\n                        role: user.role,\n                        hospitalId: user.hospital_id ? String(user.hospital_id) : null,\n                        hospitalName: user.hospital?.name\n                    };\n                    console.log(\"Authentication successful for user:\", authUser.email);\n                    return authUser;\n                } catch (error) {\n                    console.error(\"Auth error:\", error);\n                    return null;\n                }\n            }\n        })\n    ],\n    callbacks: {\n        async jwt ({ token, user }) {\n            if (user) {\n                console.log(\"JWT callback with user:\", user.email);\n                token.id = user.id;\n                token.role = user.role;\n                token.hospitalId = user.hospitalId;\n                token.hospitalName = user.hospitalName;\n            }\n            return token;\n        },\n        async session ({ session, token }) {\n            console.log(\"Session callback for user:\", token.email);\n            if (session.user && token) {\n                session.user.id = token.id;\n                session.user.role = token.role;\n                session.user.hospitalId = token.hospitalId;\n                session.user.hospitalName = token.hospitalName;\n            }\n            return session;\n        }\n    }\n};\nconst { handlers, auth, signIn, signOut } = (0,next_auth__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(authConfig);\n// Keep the legacy export for backward compatibility if needed\nconst authOptions = authConfig;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/auth.ts\n");

/***/ }),

/***/ "(rsc)/./lib/db.ts":
/*!*******************!*\
  !*** ./lib/db.ts ***!
  \*******************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   db: () => (/* binding */ db)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\nconst globalForPrisma = globalThis;\nconst db = globalForPrisma.prisma ?? new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient();\nif (true) globalForPrisma.prisma = db;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHJzYykvLi9saWIvZGIudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQThDO0FBRTlDLE1BQU1DLGtCQUFrQkM7QUFJakIsTUFBTUMsS0FBS0YsZ0JBQWdCRyxNQUFNLElBQUksSUFBSUosd0RBQVlBLEdBQUc7QUFFL0QsSUFBSUssSUFBcUMsRUFBRUosZ0JBQWdCRyxNQUFNLEdBQUdEIiwic291cmNlcyI6WyIvaG9tZS9yaXp2aS9wcm9qZWN0cy9hdWRpdC1uZXh0L2xpYi9kYi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcmlzbWFDbGllbnQgfSBmcm9tICdAcHJpc21hL2NsaWVudCc7XG5cbmNvbnN0IGdsb2JhbEZvclByaXNtYSA9IGdsb2JhbFRoaXMgYXMgdW5rbm93biBhcyB7XG4gIHByaXNtYTogUHJpc21hQ2xpZW50IHwgdW5kZWZpbmVkO1xufTtcblxuZXhwb3J0IGNvbnN0IGRiID0gZ2xvYmFsRm9yUHJpc21hLnByaXNtYSA/PyBuZXcgUHJpc21hQ2xpZW50KCk7XG5cbmlmIChwcm9jZXNzLmVudi5OT0RFX0VOViAhPT0gJ3Byb2R1Y3Rpb24nKSBnbG9iYWxGb3JQcmlzbWEucHJpc21hID0gZGI7ICJdLCJuYW1lcyI6WyJQcmlzbWFDbGllbnQiLCJnbG9iYWxGb3JQcmlzbWEiLCJnbG9iYWxUaGlzIiwiZGIiLCJwcmlzbWEiLCJwcm9jZXNzIl0sImlnbm9yZUxpc3QiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(rsc)/./lib/db.ts\n");

/***/ }),

/***/ "(rsc)/./lib/prisma.ts":
/*!***********************!*\
  !*** ./lib/prisma.ts ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @prisma/client */ \"@prisma/client\");\n/* harmony import */ var _prisma_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_prisma_client__WEBPACK_IMPORTED_MODULE_0__);\n\n// PrismaClient is attached to the `global` object in development to prevent\n// exhausting your database connection limit.\n// Learn more: https://pris.ly/d/help/next-js-best-practices\n// Global variable to store Prisma instance\nconst globalForPrisma = globalThis;\n// Optimized Prisma client configuration\nconst prismaClientSingleton = ()=>{\n    return new _prisma_client__WEBPACK_IMPORTED_MODULE_0__.PrismaClient({\n        log:  true ? [\n            'error',\n            'warn'\n        ] : 0,\n        datasources: {\n            db: {\n                url: process.env.DATABASE_URL\n            }\n        }\n    });\n};\nconst prisma = globalForPrisma.prisma ?? prismaClientSingleton();\n// Simple query performance monitoring\nif (true) {\n    prisma.$use(async (params, next)=>{\n        const before = Date.now();\n        const result = await next(params);\n        const after = Date.now();\n        // Log slow queries (>100ms)\n        if (after - before > 100) {\n            console.log(`🐌 Slow Query: ${params.model}.${params.action} took ${after - before}ms`);\n        }\n        return result;\n    });\n}\n// Graceful shutdown handling\nif (false) {}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prisma);\nif (true) globalForPrisma.prisma = prisma;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./lib/prisma.ts\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fadmin%2Fhospitals%2Froute&page=%2Fapi%2Fadmin%2Fhospitals%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fadmin%2Fhospitals%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fadmin%2Fhospitals%2Froute&page=%2Fapi%2Fadmin%2Fhospitals%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fadmin%2Fhospitals%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D! ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   patchFetch: () => (/* binding */ patchFetch),\n/* harmony export */   routeModule: () => (/* binding */ routeModule),\n/* harmony export */   serverHooks: () => (/* binding */ serverHooks),\n/* harmony export */   workAsyncStorage: () => (/* binding */ workAsyncStorage),\n/* harmony export */   workUnitAsyncStorage: () => (/* binding */ workUnitAsyncStorage)\n/* harmony export */ });\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! next/dist/server/route-modules/app-route/module.compiled */ \"(rsc)/./node_modules/next/dist/server/route-modules/app-route/module.compiled.js\");\n/* harmony import */ var next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! next/dist/server/route-kind */ \"(rsc)/./node_modules/next/dist/server/route-kind.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! next/dist/server/lib/patch-fetch */ \"(rsc)/./node_modules/next/dist/server/lib/patch-fetch.js\");\n/* harmony import */ var next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _home_rizvi_projects_audit_next_app_api_admin_hospitals_route_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app/api/admin/hospitals/route.ts */ \"(rsc)/./app/api/admin/hospitals/route.ts\");\n\n\n\n\n// We inject the nextConfigOutput here so that we can use them in the route\n// module.\nconst nextConfigOutput = \"\"\nconst routeModule = new next_dist_server_route_modules_app_route_module_compiled__WEBPACK_IMPORTED_MODULE_0__.AppRouteRouteModule({\n    definition: {\n        kind: next_dist_server_route_kind__WEBPACK_IMPORTED_MODULE_1__.RouteKind.APP_ROUTE,\n        page: \"/api/admin/hospitals/route\",\n        pathname: \"/api/admin/hospitals\",\n        filename: \"route\",\n        bundlePath: \"app/api/admin/hospitals/route\"\n    },\n    resolvedPagePath: \"/home/rizvi/projects/audit-next/app/api/admin/hospitals/route.ts\",\n    nextConfigOutput,\n    userland: _home_rizvi_projects_audit_next_app_api_admin_hospitals_route_ts__WEBPACK_IMPORTED_MODULE_3__\n});\n// Pull out the exports that we need to expose from the module. This should\n// be eliminated when we've moved the other routes to the new format. These\n// are used to hook into the route.\nconst { workAsyncStorage, workUnitAsyncStorage, serverHooks } = routeModule;\nfunction patchFetch() {\n    return (0,next_dist_server_lib_patch_fetch__WEBPACK_IMPORTED_MODULE_2__.patchFetch)({\n        workAsyncStorage,\n        workUnitAsyncStorage\n    });\n}\n\n\n//# sourceMappingURL=app-route.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fadmin%2Fhospitals%2Froute&page=%2Fapi%2Fadmin%2Fhospitals%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fadmin%2Fhospitals%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!\n");

/***/ }),

/***/ "(rsc)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "(ssr)/./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true!":
/*!******************************************************************************************************!*\
  !*** ./node_modules/next/dist/build/webpack/loaders/next-flight-client-entry-loader.js?server=true! ***!
  \******************************************************************************************************/
/***/ (() => {



/***/ }),

/***/ "../app-render/action-async-storage.external":
/*!*******************************************************************************!*\
  !*** external "next/dist/server/app-render/action-async-storage.external.js" ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/action-async-storage.external.js");

/***/ }),

/***/ "../app-render/after-task-async-storage.external":
/*!***********************************************************************************!*\
  !*** external "next/dist/server/app-render/after-task-async-storage.external.js" ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/after-task-async-storage.external.js");

/***/ }),

/***/ "../app-render/work-async-storage.external":
/*!*****************************************************************************!*\
  !*** external "next/dist/server/app-render/work-async-storage.external.js" ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-async-storage.external.js");

/***/ }),

/***/ "./work-unit-async-storage.external":
/*!**********************************************************************************!*\
  !*** external "next/dist/server/app-render/work-unit-async-storage.external.js" ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/server/app-render/work-unit-async-storage.external.js");

/***/ }),

/***/ "@prisma/client":
/*!*********************************!*\
  !*** external "@prisma/client" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@prisma/client");

/***/ }),

/***/ "bcrypt":
/*!*************************!*\
  !*** external "bcrypt" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("bcrypt");

/***/ }),

/***/ "crypto":
/*!*************************!*\
  !*** external "crypto" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = require("crypto");

/***/ }),

/***/ "next/dist/compiled/next-server/app-page.runtime.dev.js":
/*!*************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-page.runtime.dev.js" ***!
  \*************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-page.runtime.dev.js");

/***/ }),

/***/ "next/dist/compiled/next-server/app-route.runtime.dev.js":
/*!**************************************************************************!*\
  !*** external "next/dist/compiled/next-server/app-route.runtime.dev.js" ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = require("next/dist/compiled/next-server/app-route.runtime.dev.js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, ["vendor-chunks/next","vendor-chunks/@auth","vendor-chunks/next-auth","vendor-chunks/oauth4webapi","vendor-chunks/jose","vendor-chunks/preact","vendor-chunks/preact-render-to-string","vendor-chunks/@panva"], () => (__webpack_exec__("(rsc)/./node_modules/next/dist/build/webpack/loaders/next-app-loader/index.js?name=app%2Fapi%2Fadmin%2Fhospitals%2Froute&page=%2Fapi%2Fadmin%2Fhospitals%2Froute&appPaths=&pagePath=private-next-app-dir%2Fapi%2Fadmin%2Fhospitals%2Froute.ts&appDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next%2Fapp&pageExtensions=tsx&pageExtensions=ts&pageExtensions=jsx&pageExtensions=js&rootDir=%2Fhome%2Frizvi%2Fprojects%2Faudit-next&isDev=true&tsconfigPath=tsconfig.json&basePath=&assetPrefix=&nextConfigOutput=&preferredRegion=&middlewareConfig=e30%3D!")));
module.exports = __webpack_exports__;

})();