"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatWeekNumber = formatWeekNumber;
const DateLib_js_1 = require("../classes/DateLib.js");
/**
 * Formats the week number.
 *
 * @defaultValue The week number as a string, with a leading zero for single-digit numbers.
 * @param weekNumber The week number to format.
 * @param dateLib The date library to use for formatting. Defaults to
 *   `defaultDateLib`.
 * @returns The formatted week number as a string.
 * @group Formatters
 * @see https://daypicker.dev/docs/translation#custom-formatters
 */
function formatWeekNumber(weekNumber, dateLib = DateLib_js_1.defaultDateLib) {
    if (weekNumber < 10) {
        return dateLib.formatNumber(`0${weekNumber.toLocaleString()}`);
    }
    return dateLib.formatNumber(`${weekNumber.toLocaleString()}`);
}
//# sourceMappingURL=formatWeekNumber.js.map